/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <qvaluevector.h>
#include <qstring.h>
#include <qmessagebox.h>
#include <qtooltip.h>
#include "kimeraglobal.h"

const QString PREFIX = "keyassigntbl";
const int  MAX_AVAILABLE_KEYS = 28;

static QValueVector<QString>  FuncName(FID_NumFunctions);

static int KeyAssign[NUM_SETTING_TYPE][MAX_AVAILABLE_KEYS][NUM_OF_CONVSTATUS + 1] = {
  { { 0 } },     // Current setting  (dummy)

  { { Qt::Key_Space,     FID_InputSpaceChar, FID_ConvertAllSegments, FID_NextCandidacy, FID_NextCandidacy, FID_ConvertCrntSegment },    // MSIME
    { Qt::Key_Return,    FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Enter,     FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Backspace, FID_ForwardKeyEvent, FID_DeleteBackward, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::Key_Left,      FID_ForwardKeyEvent, FID_None, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },
    { Qt::Key_Right,     FID_ForwardKeyEvent, FID_None, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::Key_Up,        FID_ForwardKeyEvent, FID_None, FID_PreviousCandidacy, FID_PreviousCandidacy, FID_ShortenSegment },
    { Qt::Key_Down,      FID_ForwardKeyEvent, FID_None, FID_NextCandidacy, FID_NextCandidacy, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_Left,   FID_ForwardKeyEvent, FID_None, FID_ToFirstSegment, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_Right,  FID_ForwardKeyEvent, FID_None, FID_ToLastSegment, FID_None, FID_None },
    { Qt::CTRL+Qt::Key_Up,     FID_ForwardKeyEvent, FID_None, FID_PreviousCandidacy, FID_PreviousCandidacy, FID_None },
    { Qt::CTRL+Qt::Key_Down,   FID_ForwardKeyEvent, FID_None, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_DecideCrntSegment },
    { Qt::SHIFT+Qt::Key_Left,  FID_ForwardKeyEvent, FID_None, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::SHIFT+Qt::Key_Right, FID_ForwardKeyEvent, FID_None, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::SHIFT+Qt::Key_Up,    FID_ForwardKeyEvent, FID_None, FID_None, FID_PreviousCandidacyGroup, FID_None },
    { Qt::SHIFT+Qt::Key_Down,  FID_ForwardKeyEvent, FID_None, FID_None, FID_NextCandidacyGroup, FID_None },
    { Qt::Key_PageUp,    FID_ForwardKeyEvent, FID_None, FID_None, FID_PreviousCandidacyGroup, FID_None },
    { Qt::Key_PageDown,  FID_ForwardKeyEvent, FID_None, FID_None, FID_NextCandidacyGroup, FID_None },    
    { Qt::Key_F6,        FID_ForwardKeyEvent, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::Key_F7,        FID_ForwardKeyEvent, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::Key_F8,        FID_ForwardKeyEvent, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::Key_F9,        FID_ForwardKeyEvent, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::Key_F10,       FID_ForwardKeyEvent, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu } },

  { { Qt::Key_Space,     FID_InputSpaceChar, FID_ConvertAllSegments, FID_NextCandidacy, FID_NextCandidacy, FID_ConvertCrntSegment },   // ATOK
    { Qt::Key_Return,    FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Enter,     FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Backspace, FID_ForwardKeyEvent, FID_DeleteBackward, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::Key_Left,      FID_ForwardKeyEvent, FID_None, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::Key_Right,     FID_ForwardKeyEvent, FID_None, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::Key_Up,        FID_ForwardKeyEvent, FID_None, FID_PreviousCandidacy, FID_PreviousCandidacy, FID_None },
    { Qt::Key_Down,      FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_DecideCrntSegment },
    { Qt::CTRL+Qt::Key_Left,   FID_ForwardKeyEvent, FID_None, FID_ToFirstSegment, FID_ToFirstSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_Right,  FID_ForwardKeyEvent, FID_None, FID_ToLastSegment, FID_ToLastSegment, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_Up,     FID_ForwardKeyEvent, FID_None, FID_PreviousCandidacy, FID_PreviousCandidacy, FID_None },
    { Qt::SHIFT+Qt::Key_Left,  FID_ForwardKeyEvent, FID_None, FID_BackwardSegment, FID_BackwardSegment, FID_ShortenSegment },    
    { Qt::SHIFT+Qt::Key_Right, FID_ForwardKeyEvent, FID_None, FID_ForwardSegment, FID_ForwardSegment, FID_LengthenSegment },
    { Qt::SHIFT+Qt::Key_Up,    FID_ForwardKeyEvent, FID_None, FID_PreviousCandidacy, FID_PreviousCandidacy, FID_None },
    { Qt::SHIFT+Qt::Key_Down,  FID_ForwardKeyEvent, FID_None, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_DecideCrntSegment },
    { Qt::Key_PageUp,    FID_ForwardKeyEvent, FID_None, FID_PreviousCandidacyGroup, FID_PreviousCandidacyGroup, FID_None },
    { Qt::Key_PageDown,  FID_ForwardKeyEvent, FID_None, FID_NextCandidacyGroup, FID_NextCandidacyGroup, FID_None }, 
    { Qt::Key_F6,        FID_ForwardKeyEvent, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::Key_F7,        FID_ForwardKeyEvent, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::Key_F8,        FID_ForwardKeyEvent, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::Key_F9,        FID_ForwardKeyEvent, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::Key_F10,       FID_ForwardKeyEvent, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu } },
  
  { { Qt::Key_Space,      FID_InputSpaceChar, FID_ConvertAllSegments, FID_NextCandidacy, FID_NextCandidacy, FID_ConvertCrntSegment },  // KINPUT2
    { Qt::Key_Return,     FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Enter,      FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Backspace,  FID_ForwardKeyEvent, FID_DeleteBackward, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::CTRL+Qt::Key_A, FID_ForwardKeyEvent, FID_None, FID_ToFirstSegment, FID_ToFirstSegment, FID_ToFirstSegment },
    { Qt::CTRL+Qt::Key_B, FID_ForwardKeyEvent, FID_None, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },    
    { Qt::CTRL+Qt::Key_E, FID_ForwardKeyEvent, FID_None, FID_ToLastSegment, FID_ToLastSegment, FID_ToLastSegment },
    { Qt::CTRL+Qt::Key_F, FID_ForwardKeyEvent, FID_None, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::CTRL+Qt::Key_G, FID_ForwardKeyEvent, FID_DeleteBackward, FID_CancelConversion, FID_CancelConversion, FID_CancelConversion },
    { Qt::CTRL+Qt::Key_H, FID_ForwardKeyEvent, FID_DeleteBackward, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::CTRL+Qt::Key_I, FID_ForwardKeyEvent, FID_None, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_M, FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::CTRL+Qt::Key_N, FID_ForwardKeyEvent, FID_None, FID_NextCandidacy, FID_NextCandidacy, FID_None },
    { Qt::CTRL+Qt::Key_O, FID_ForwardKeyEvent, FID_None, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::CTRL+Qt::Key_P, FID_ForwardKeyEvent, FID_None, FID_PreviousCandidacy, FID_PreviousCandidacy, FID_None },  
    { Qt::Key_Left,      FID_ForwardKeyEvent, FID_None, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },
    { Qt::Key_Right,     FID_ForwardKeyEvent, FID_None, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::Key_Up,        FID_ForwardKeyEvent, FID_None, FID_PreviousCandidacy, FID_PreviousCandidacy, FID_None },
    { Qt::Key_Down,      FID_ForwardKeyEvent, FID_None, FID_NextCandidacy, FID_NextCandidacy, FID_None },
    { Qt::SHIFT+Qt::Key_Left,  FID_ForwardKeyEvent, FID_None, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::SHIFT+Qt::Key_Right, FID_ForwardKeyEvent, FID_None, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },
    { Qt::Key_PageUp,    FID_ForwardKeyEvent, FID_None, FID_PreviousCandidacyGroup, FID_PreviousCandidacyGroup, FID_None },
    { Qt::Key_PageDown,  FID_ForwardKeyEvent, FID_None, FID_NextCandidacyGroup, FID_NextCandidacyGroup, FID_None },
    { Qt::Key_F6,        FID_ForwardKeyEvent, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::Key_F7,        FID_ForwardKeyEvent, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::Key_F8,        FID_ForwardKeyEvent, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::Key_F9,        FID_ForwardKeyEvent, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::Key_F10,       FID_ForwardKeyEvent, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu } },
  
  { { Qt::Key_Space,     FID_InputSpaceChar, FID_ConvertAllSegments, FID_NextCandidacy, FID_NextCandidacy, FID_ConvertCrntSegment },    // VJE
    { Qt::Key_Return,    FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Enter,     FID_ForwardKeyEvent, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments, FID_DecideAllSegments },
    { Qt::Key_Backspace, FID_ForwardKeyEvent, FID_DeleteBackward, FID_CancelConversion, FID_CancelConversion, FID_None },
    { Qt::Key_Left,      FID_ForwardKeyEvent, FID_None, FID_BackwardSegment, FID_BackwardSegment, FID_BackwardSegment },
    { Qt::Key_Right,     FID_ForwardKeyEvent, FID_None, FID_ForwardSegment, FID_ForwardSegment, FID_ForwardSegment },
    { Qt::Key_Up,        FID_ForwardKeyEvent, FID_ConvertAllSegments, FID_PreviousCandidacy, FID_PreviousCandidacy, FID_ConvertCrntSegment },
    { Qt::Key_Down,      FID_ForwardKeyEvent, FID_ConvertAllSegments, FID_NextCandidacy, FID_NextCandidacy, FID_ConvertCrntSegment },
    { Qt::CTRL+Qt::Key_Up,     FID_ForwardKeyEvent, FID_ConvertAllSegments, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::CTRL+Qt::Key_Down,   FID_ForwardKeyEvent, FID_ConvertAllSegments, FID_DecideCrntSegment, FID_DecideCrntSegment, FID_LengthenSegment },
    { Qt::SHIFT+Qt::Key_Left,  FID_ForwardKeyEvent, FID_None, FID_ShortenSegment, FID_ShortenSegment, FID_ShortenSegment },
    { Qt::SHIFT+Qt::Key_Right, FID_ForwardKeyEvent, FID_None, FID_LengthenSegment, FID_LengthenSegment, FID_LengthenSegment },    
    { Qt::SHIFT+Qt::Key_Up,    FID_ForwardKeyEvent, FID_ConvertAllSegments, FID_PreviousCandidacy, FID_PreviousCandidacyGroup, FID_ConvertCrntSegment },
    { Qt::SHIFT+Qt::Key_Down,  FID_ForwardKeyEvent, FID_ConvertAllSegments, FID_NextCandidacy, FID_NextCandidacyGroup, FID_ConvertCrntSegment },
    { Qt::Key_PageUp,    FID_ForwardKeyEvent, FID_None, FID_NextCandidacy, FID_PreviousCandidacyGroup, FID_None },
    { Qt::Key_PageDown,  FID_ForwardKeyEvent, FID_None, FID_NextCandidacy, FID_NextCandidacyGroup, FID_None }, 
    { Qt::Key_F6,        FID_ForwardKeyEvent, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira, FID_ConvertToHira },
    { Qt::Key_F7,        FID_ForwardKeyEvent, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana, FID_ConvertToKana },
    { Qt::Key_F8,        FID_ForwardKeyEvent, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu, FID_ConvertToZenkakuEisu },
    { Qt::Key_F9,        FID_ForwardKeyEvent, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana, FID_ConvertToHankakuKana },
    { Qt::Key_F10,       FID_ForwardKeyEvent, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu, FID_ConvertToHankakuEisu } },
};


void KeyAssigner::init()
{
  FuncName[FID_AppendChar]             = tr("");
  FuncName[FID_NextCandidacy]          = tr("");
  FuncName[FID_NextCandidacyGroup]     = tr("䷲");
  FuncName[FID_PreviousCandidacy]      = tr("");
  FuncName[FID_PreviousCandidacyGroup] = tr("䷲");
  FuncName[FID_ConvertAllSegments]     = tr("Ѵ");
  FuncName[FID_ConvertCrntSegment]     = tr("ʸѴ");
  FuncName[FID_DeleteBackward]         = tr("");
  FuncName[FID_DecideAllSegments]      = tr("");
  FuncName[FID_DecideCrntSegment]      = tr("ʸ");
  FuncName[FID_CancelConversion]       = tr("ᤷ");
  FuncName[FID_LengthenSegment]        = tr("ʸĹ +1");
  FuncName[FID_ShortenSegment]         = tr("ʸĹ -1");
  FuncName[FID_InputSpaceChar]         = tr("ʸ");
  FuncName[FID_ConvertToHira]          = tr("Ҥ餬");
  FuncName[FID_ConvertToKana]          = tr("");
  FuncName[FID_ConvertToHankakuKana]   = tr("Ⱦѥ");
  FuncName[FID_ConvertToHankakuEisu]   = tr("Ⱦѱѿ");
  FuncName[FID_ConvertToZenkakuEisu]   = tr("ѱѿ");
  FuncName[FID_ForwardSegment]         = tr("ʸ ");
  FuncName[FID_BackwardSegment]        = tr("ʸ ");
  FuncName[FID_ToFirstSegment]         = tr("ʸƬ");
  FuncName[FID_ToLastSegment]          = tr("ʸ");
  FuncName[FID_SwitchZenkakuEisu]      = tr("ѱѿ");
  FuncName[FID_ForwardKeyEvent]        = "-";
  FuncName[FID_None]                   = "-";

  _keyassigntbl->setNumCols( NUM_OF_CONVSTATUS + 1 );
  for (int i = 0; i < _keyassigntbl->numCols(); ++i)
    _keyassigntbl->setColumnStretchable(i, TRUE);

  _cmbloadsetting->insertItem(tr("ߤ"), ST_CURRENT_SETTING);
  _cmbloadsetting->insertItem(tr("MS-IME"), ST_MSIME);
  _cmbloadsetting->insertItem(tr("ATOK"), ST_ATOK);
  _cmbloadsetting->insertItem(tr("Kinput2"), ST_KINPUT2);
  _cmbloadsetting->insertItem(tr("VJE"), ST_VJE);

  QToolTip::add(_cmbloadsetting, tr("ꥹȤ򤵤줿ɤ߹ߤޤ"));
}


void KeyAssigner::polish()
{
  loadSetting(ST_CURRENT_SETTING);
}


void KeyAssigner::saveSetting()
{
  for (int row = 0; row < MAX_AVAILABLE_KEYS; row++) {
    if (row < _keyassigntbl->numRows()) {
      QKeySequence keyseq( _keyassigntbl->text(row, 0) );
      int key = keyseq[0] & ~UNICODE_ACCEL;
      Config::writeEntry(PREFIX + QString::number(row) + "-" + QString::number(0), key);

      for (int col = 1; col < NUM_OF_CONVSTATUS + 1; col++) {
	Config::writeEntry(PREFIX + QString::number(row) 
			   + "-" + QString::number(col), (int)functionID(_keyassigntbl->text(row, col)));
      }
    
    } else {
      // 0 clear
      for (int col = 0; col < NUM_OF_CONVSTATUS + 1; col++)
	Config::writeEntry(PREFIX + QString::number(row) 
			   + "-" + QString::number(col), (int)0);
    }
  }
}


void KeyAssigner::loadSetting( int index )
{
  _keyassigntbl->setNumRows(MAX_AVAILABLE_KEYS);

  int row = 0;
  switch ( index ) {
  case ST_CURRENT_SETTING:
    for (row = 0; row < MAX_AVAILABLE_KEYS; row++) {
      bool ok;
      int key = Config::readNumEntry(PREFIX + QString::number(row) + "-" + QString::number(0), 0, &ok);
      if ( !ok || !key )
	break;

      QKeySequence keyseq(key);
      _keyassigntbl->insertRows(row);
      _keyassigntbl->setText(row, 0, (QString)keyseq);
      
      for (int col = 1; col < NUM_OF_CONVSTATUS + 1; col++) {
	int funcid = Config::readNumEntry(PREFIX + QString::number(row) + "-" + QString::number(col), FID_None);
	_keyassigntbl->setText(row, col, functionName( (FuncID)funcid ));
      }
    }
    _keyassigntbl->setNumRows(row);
    break;
    
  case ST_MSIME:
  case ST_ATOK:
  case ST_KINPUT2:
  case ST_VJE:
    for (row = 0; row < MAX_AVAILABLE_KEYS; row++) {
      if ( ! KeyAssign[index][row][0] )
	break;

      QKeySequence keyseq( KeyAssign[index][row][0] );
      _keyassigntbl->insertRows(row);
      _keyassigntbl->setText(row, 0, keyseq);
      
      for (int col = 1; col < NUM_OF_CONVSTATUS + 1; col++) {
	_keyassigntbl->setText(row, col, functionName( (FuncID)KeyAssign[index][row][col] ));
      }
    }
    _keyassigntbl->setNumRows(row);
    break;
    
  default:
    break;
  }
}


QString KeyAssigner::functionName( FuncID id )
{
  if (id >= FID_AppendChar && id < FID_NumFunctions) {
    bool ok;
    QString str = FuncName.at(id, &ok); 
    if ( ok ) {
      return str;
    }
  }

  return QString::null;
}



FuncID KeyAssigner::functionID( const QString & func )
{
  for (int i = 0; i < FID_NumFunctions; ++i) {
    if (FuncName[i] == func) 
      return (FuncID)i;
  }

  return FID_None;
}


FuncID KeyAssigner::functionID( int key, ConvStatus stat )
{
  for (int i = 0; i < MAX_AVAILABLE_KEYS; ++i) {
    if (key == Config::readNumEntry(PREFIX + QString::number(i) + "-" + QString::number(0))) {
      return (FuncID)Config::readNumEntry(PREFIX + QString::number(i) + "-" + QString::number((int)stat), FID_None);
    }
  }

  if (key & ~(0xff | SHIFT)) {
    return FID_ForwardKeyEvent;
  }
  
  return FID_AppendChar;
}


void KeyAssigner::accept()
{
  saveSetting();
  QDialog::accept();
}


void KeyAssigner::saveDefaultSetting()
{
  const int setting = ST_KINPUT2;

  for (int row = 0; row < MAX_AVAILABLE_KEYS; row++) {
    if ( KeyAssign[setting][row][0] ) {
      for (int col = 0; col < NUM_OF_CONVSTATUS + 1; col++) {
	Config::writeEntry(PREFIX + QString::number(row) + "-" + QString::number(col), KeyAssign[setting][row][col], false);
      }

    } else {
      for (int col = 0; col < NUM_OF_CONVSTATUS + 1; col++) {
	Config::writeEntry(PREFIX + QString::number(row) + "-" + QString::number(col), (int)0, false);
      }
    }
  }
}
