#ifndef XIMATTRIBUTE_H
#define XIMATTRIBUTE_H

#include "xicontext.h"
#include <X11/Xlib.h>

class XIMethod;

const XIMStyle  OVER_THE_SPOT_STYLE = XIMPreeditPosition  | XIMStatusNothing;
const XIMStyle  ON_THE_SPOT_STYLE   = XIMPreeditCallbacks | XIMStatusNothing;

class XIMAttribute {
public:
  XIMAttribute(Window w) : _commwin(w), _ximstyle(0), _xic(XIContext()) { }
  ~XIMAttribute() {}
  
  Window      commWin() const { return _commwin; } 
  XIMStyle    style() const { return _ximstyle; }
  XIContext   xic() const { return _xic; }

protected:
  void        setStyle(XIMStyle s) { _ximstyle = s; }
  
private:
  Window       _commwin;     // communication window
  XIMStyle     _ximstyle;    // attribute ID: 0
  XIContext    _xic;         // XInputContext

  friend class XIMethod;
};
 

#endif // XIMATTRIBUTE_H







