#ifndef MAINFORM_H
#define MAINFORM_H

#include "kimeraapp.h"
#include "kanjiconvert.h"
#include <qwidget.h>
#include <qapplication.h>
#include <qvariant.h>
#include <qtoolbutton.h>
#include <qpopupmenu.h>
#include <qcursor.h>

class QVBoxLayout; 
class QHBoxLayout; 
class QGridLayout; 
class QToolButton;
class QPopupMenu;
class InputMethod;
class InputMode;
class PropertyForm;
class Mover;
class Popup;

class MainForm : public QWidget { 
  Q_OBJECT
  
public:
  MainForm();
  ~MainForm();

  bool loadPos(QPoint& pos);
  bool isHideState();

public slots:
  void  polish();
  void  slotTriggerNotify(bool);
  void  initIM();
  void  savePos();

signals:
  void  setInputMode(const InputMode&);

protected slots:
  void  setButton1Text(int id);
  void  setButton2Text(int id);
  void  execPropertyDialog();
  virtual void languageChange();

private:
  Mover*            _leftmover;
  Mover*            _rightmover;  
  QToolButton*      _toolbtn1;
  QToolButton*      _toolbtn2;
  QToolButton*      _toolbtn3;
  Popup*            _pupmenu1;
  Popup*            _pupmenu2;
  PropertyForm*     _propform;
  bool              _triggerflag;
  QDict<int>        _modemap;
  QIntDict<QString> _labelmap;
};


class Mover : public QToolButton {
  Q_OBJECT
    
public:
  Mover(QWidget* parent, const char* name = 0) : QToolButton(parent, name) { }

signals:
  void mouseMoved(const QPoint& pos);
  void mouseMoveStopped(const QPoint& pos);

protected:
  void mousePressEvent(QMouseEvent* e);
  void mouseReleaseEvent(QMouseEvent* e);
  void mouseMoveEvent(QMouseEvent* e);
  void enterEvent(QEvent* e);
  void leaveEvent(QEvent* e);

private:
  QPoint _p;
};


class Popup : public QPopupMenu {
 Q_OBJECT

public:
  Popup(QWidget* parent=0, const char* name=0) : QPopupMenu(parent, name) { }

public slots:
  void hide() { clearFocus(); QPopupMenu::hide(); }
};


inline void
Mover::mousePressEvent(QMouseEvent* e)
{
  _p = e->globalPos();
  if ( topLevelWidget() ) {
    _p -= topLevelWidget()->pos();
  }
  
  QToolButton::mousePressEvent(e);
}


inline void
Mover::mouseReleaseEvent(QMouseEvent* e)
{
  emit mouseMoveStopped(e->globalPos() - _p);
  QToolButton::mouseReleaseEvent(e);
}


inline void
Mover::mouseMoveEvent(QMouseEvent* e) 
{
  emit mouseMoved(e->globalPos() - _p);
  QToolButton::mouseMoveEvent(e);
}


inline void
Mover::enterEvent(QEvent* e)
{
  QApplication::setOverrideCursor( QCursor(Qt::SizeAllCursor) );
  QToolButton::enterEvent(e);
}


inline void
Mover::leaveEvent(QEvent* e)
{
  QApplication::restoreOverrideCursor();
  QToolButton::leaveEvent(e);
}

#endif // MAINFORM_H
