#include "mainform.h"
#include "kimeraglobal.h"
#include "kimeraapp.h"
#include "inputmethod.h"
#include "inputmode.h"
#include "propertydialog.h"
#include "keyassigner.h"
#include "config.h"
#include "debug.h"
#include <qlabel.h>
#include <qvariant.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qstring.h>
#include <qtimer.h>
using namespace Kimera;

static const char* property_xpm[] = {
  "16 16 79 2",
  "Qt c None",
  ".a c #383858",
  ".e c #5a5a79",
  ".K c #676786",
  ".o c #6a6a88",
  ".8 c #6d6d8c",
  ".0 c #71718f",
  "#j c #737391",
  ".P c #757592",
  "#e c #767693",
  "#m c #777795",
  ".t c #797b97",
  "#i c #7b7b98",
  ".3 c #7c7c98",
  ".2 c #7e7e9a",
  "#d c #7f7e9a",
  "#h c #7f7e9b",
  ".1 c #80809b",
  ".f c #82829e",
  "#c c #83829e",
  ".# c #83839f",
  "## c #8886a2",
  ".Q c #8989a3",
  "#. c #8b8ba6",
  ".7 c #8f8fa9",
  ".6 c #9595ae",
  "#l c #9797af",
  ".Z c #9a9ab2",
  ".Y c #9f9fb6",
  "#g c #a1a1b8",
  ".X c #a5a5bb",
  ".O c #a5a6bc",
  "#b c #a8a8bd",
  ".N c #aaabbf",
  ".J c #abaabf",
  ".9 c #afafc3",
  ".E c #b0afc4",
  ".I c #b0b0c4",
  "#k c #b1b1c5",
  "#f c #b2b2c5",
  "#a c #b5b5c8",
  ".z c #b6b6c9",
  ".M c #b7b7c9",
  ".5 c #b8b8ca",
  ".4 c #b9b9cb",
  ".x c #bcbccc",
  ".W c #c1c0d1",
  ".r c #c1c1d1",
  ".q c #c7c5d5",
  ".w c #c7c7d5",
  ".p c #cbcbd8",
  ".D c #cbcbda",
  ".n c #cbccda",
  ".H c #ccccd8",
  ".v c #ccccda",
  ".m c #cfd0dc",
  ".k c #d0cfdc",
  ".u c #d0d0dc",
  ".j c #d5d5e0",
  ".C c #d8d8e2",
  ".G c #d8d9e2",
  ".l c #d9d8e2",
  ".i c #d9d9e2",
  ".h c #dbdbe6",
  ".d c #dddbe6",
  ".B c #dddde6",
  ".g c #dfdfe8",
  ".c c #e0dfe8",
  ".y c #e0e0e8",
  ".V c #e1e1e9",
  ".b c #e2e2e9",
  ".U c #e3e3eb",
  ".T c #e5e5ec",
  ".S c #e8e8ed",
  ".R c #eaeaf0",
  ".L c #ededf2",
  ".F c #f1f1f5",
  ".A c #f2f2f5",
  ".s c #f3f3f6",
  "QtQtQtQt.#.#.#.#.#QtQtQtQtQtQtQt",
  "QtQtQtQt.a.b.b.c.d.e.eQtQtQtQtQt",
  "QtQtQtQt.f.a.g.h.i.j.k.eQtQtQtQt",
  "QtQtQtQtQt.f.a.l.j.m.n.eQtQtQtQt",
  ".o.oQtQtQtQt.f.#.k.p.q.r.eQtQtQt",
  ".o.s.#QtQtQt.t.u.v.w.r.x.eQtQtQt",
  ".o.s.y.#Qt.t.u.p.w.r.x.z.eQtQtQt",
  ".o.A.B.C.t.u.D.w.r.x.z.E.eQtQtQt",
  ".o.F.G.j.k.H.w.r.x.z.I.J.eQtQtQt",
  ".o.K.L.u.v.w.r.x.M.I.N.O.P.eQtQt",
  "Qt.a.Q.R.S.T.U.V.u.W.X.Y.Z.0.eQt",
  "Qt.f.a.a.f.1.2.3.f.4.5.Z.6.7.8.e",
  "QtQtQt.f.a.a.a.a.a.2.M.9.7#.##.o",
  "QtQtQtQtQtQtQtQt.f.a.t#a#b###c#d",
  "QtQtQtQtQtQtQtQtQt.f.a#e#f#g#h#i",
  "QtQtQtQtQtQtQtQtQtQt.f.a#j#k#l#m"
};


MainForm::MainForm()
  : QWidget(0, "MainForm", WStyle_Customize | WStyle_StaysOnTop | WX11BypassWM | WGroupLeader | WDestructiveClose), _triggerflag(FALSE)
{
  _leftmover = new Mover( this, "left mover" );
  _leftmover->setGeometry( QRect( 0, 0, 8, 30 ) ); 

  _toolbtn1 = new QToolButton( this, "ToolButton1" );
  _toolbtn1->setGeometry( QRect( 8, 0, 30, 30 ) ); 
 
  _toolbtn2 = new QToolButton( this, "ToolButton2" );
  _toolbtn2->setGeometry( QRect( 38, 0, 30, 30 ) ); 
  
  _toolbtn3 = new QToolButton( this, "ToolButton3" );
  _toolbtn3->setGeometry( QRect( 68, 0, 30, 30 ) ); 

  _rightmover = new Mover( this, "right mover" );
  _rightmover->setGeometry( QRect( 98, 0, 8, 30 ) ); 

  _pupmenu1 = new Popup( this );
  _pupmenu2 = new Popup( this );

  languageChange();
  resize( QSize(106, 30) );

  // signals and slots connections
  InputMethod* im = KimeraApp::inputmethod();
  connect(im, SIGNAL(triggerNotify(bool)), this, SLOT(slotTriggerNotify(bool)));
  connect(_toolbtn3,   SIGNAL(clicked()), this, SLOT(execPropertyDialog()));
  connect(_pupmenu1,   SIGNAL(activated(int)), this, SLOT(setButton1Text(int)));
  connect(_pupmenu2,   SIGNAL(activated(int)), this, SLOT(setButton2Text(int))); 
  connect(_leftmover,  SIGNAL(mouseMoved(const QPoint&)), this, SLOT(move(const QPoint&)));
  connect(_rightmover, SIGNAL(mouseMoved(const QPoint&)), this, SLOT(move(const QPoint&)));
  connect(_leftmover,  SIGNAL(mouseMoveStopped(const QPoint&)), this, SLOT(savePos()));
  connect(_rightmover, SIGNAL(mouseMoveStopped(const QPoint&)), this, SLOT(savePos()));

  // Transfer signal to signal
  connect(this, SIGNAL(setInputMode(const InputMode&)), im, SIGNAL(setInputMode(const InputMode&)));

  for (int i = 1; i <= 10; ++i)
    QTimer::singleShot(10000 * i, this, SLOT(raise()));  // To stay on top at starting up on Gnome

  // Save Default setting
  PropertyDialog::saveDefaultSetting();
  KeyAssigner::saveDefaultSetting();
}


MainForm::~MainForm()
{
  // no need to delete child widgets, Qt does it all for us  
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void 
MainForm::languageChange()
{
  setCaption( tr("Kimera") );

  QFont f =_toolbtn1->font();
  _toolbtn1->setTextLabel("A_");
  _toolbtn1->setUsesTextLabel(TRUE);
  f.setPointSize( 10 );
  _toolbtn1->setFont(f);
  _toolbtn2->setTextLabel(tr("-"));
  _toolbtn2->setUsesTextLabel(TRUE);
  f.setPointSize( 7 );
  _toolbtn2->setFont(f);
  _toolbtn3->setIconSet( QIconSet( QPixmap((const char **)property_xpm) ) );

  _pupmenu1->clear();
  _pupmenu1->insertItem(tr("Ҥ餬"), Mode_Hiragana);
  _pupmenu1->insertItem(tr(""), Mode_Katakana);
  _pupmenu1->insertItem(tr("Ⱦѥ"), Mode_HankakuKana);
  _pupmenu1->insertItem(tr("ѱѿ"), Mode_ZenkakuEisu);
  _pupmenu1->setCheckable(TRUE);

  _pupmenu2->clear();
  _pupmenu2->insertItem(tr("޻"), Mode_RomaInput);
  _pupmenu2->insertItem(tr(""), Mode_KanaInput);
  _pupmenu2->setCheckable(TRUE);

  _toolbtn1->setPopup(_pupmenu1);
  _toolbtn1->setPopupDelay(1);
  _toolbtn2->setPopup(_pupmenu2);
  _toolbtn2->setPopupDelay(1);
  
  _modemap.setAutoDelete( TRUE );
  _modemap.insert(tr("Ҥ餬"),     new int(Mode_Hiragana));
  _modemap.insert(tr(""),     new int(Mode_Katakana));
  _modemap.insert(tr("ѱѿ"),     new int(Mode_ZenkakuEisu));
  _modemap.insert(tr("޻"),  new int(Mode_RomaInput));
  _modemap.insert(tr(""),     new int(Mode_KanaInput));

  _labelmap.setAutoDelete( TRUE );
  _labelmap.insert(Mode_Hiragana,    new QString(tr("")));
  _labelmap.insert(Mode_Katakana,    new QString(tr("")));
  _labelmap.insert(Mode_HankakuKana, new QString(tr("_")));
  _labelmap.insert(Mode_ZenkakuEisu, new QString(tr("")));
  _labelmap.insert(Mode_RomaInput,   new QString(tr("-")));
  _labelmap.insert(Mode_KanaInput,   new QString(tr("")));
}


void
MainForm::initIM()
{
  DEBUG_TRACEFUNC();
  QTimer::singleShot(0, KimeraApp::inputmethod(), SLOT(init()));
}


void
MainForm::polish()
{
  int* p = _modemap[ Config::readEntry("_cmbinputmode", "") ];
  if ( p )
    setButton1Text( *p );

  p = _modemap[ Config::readEntry("_cmbinputstyle", "") ];
  if ( p )
    setButton2Text( *p );

  initIM();
  QWidget::polish();
}


void
MainForm::setButton1Text(int id)
{
  DEBUG_TRACEFUNC("id: %d", id);
  id &= Mode_ModeMask;
  if ( _pupmenu1->text(id).isEmpty() )
    return;

  for (int i = 0; i < (int)_pupmenu1->count(); ++i)
    _pupmenu1->setItemChecked(_pupmenu1->idAt(i), FALSE);
  
  _pupmenu1->setItemChecked(id, TRUE);
 
  if ( !_triggerflag ) {
    _toolbtn1->setTextLabel("A_");
    
  } else {
    QString* p = _labelmap[id];
    if ( p )
      _toolbtn1->setTextLabel( *p );
  }
  
  emit setInputMode(InputMode(id));
}


void
MainForm::setButton2Text(int id)
{ 
  DEBUG_TRACEFUNC("id: %d", id);
  id &= Mode_InputMask;
  if ( _pupmenu2->text(id).isEmpty() )
    return;

  for (int i = 0; i < (int)_pupmenu2->count(); ++i)
    _pupmenu2->setItemChecked(_pupmenu2->idAt(i), FALSE);
  
  _pupmenu2->setItemChecked(id, TRUE);

  QString* p = _labelmap[id];
  if ( p )
    _toolbtn2->setTextLabel( *p );

  emit setInputMode(InputMode(id));
}


void
MainForm::slotTriggerNotify(bool b)
{
  DEBUG_TRACEFUNC("b: %d", b); 
  if (_triggerflag == b) {
    // Do nothing
    return;
  }

  _triggerflag = b;
  for (int i = 0; i < (int)_pupmenu1->count(); i++) {
    if ( _pupmenu1->isItemChecked(_pupmenu1->idAt(i)) ) {
      setButton1Text( _pupmenu1->idAt(i) );
      break;
    }
  }

  if ( isHideState() ) {
    hide();
  } else {
    clearFocus();
    show();
    raise();
  }
}


void
MainForm::execPropertyDialog()
{
  DEBUG_TRACEFUNC();
  _toolbtn3->setEnabled(FALSE);
  PropertyDialog* dlg = new PropertyDialog();
  int res = dlg->exec();
  delete dlg;
  _toolbtn3->setEnabled(TRUE);

  if (res == PropertyDialog::Accepted)
    initIM();
}


bool
MainForm::isHideState()
{
  DEBUG_TRACEFUNC();
  return !_triggerflag && Config::readBoolEntry("_chkdispbar");
}


void
MainForm::savePos()
{
  DEBUG_TRACEFUNC();
  Config::writeEntry("point_x", x());
  Config::writeEntry("point_y", y());
  qDebug("saved (%d, %d)", x(), y());
}


bool
MainForm::loadPos(QPoint& pos)
{
  DEBUG_TRACEFUNC();
  bool ok;
  int x = Config::readNumEntry("point_x", 0, &ok);
  if ( ok ) {
    int y = Config::readNumEntry("point_y", 0, &ok);
    if ( ok ) {
      x = QMIN(QMAX(x, 0), QApplication::desktop()->width() - width());
      y = QMIN(QMAX(y, 0), QApplication::desktop()->height() - height()); 
      pos = QPoint(x, y);
    }
  }

  return ok;
}
