#include "kimeraapp.h"
#include "mainform.h"
#include <qtextcodec.h>
#include <qapplication.h>
#include <qdir.h>
#include <qfile.h>
#include <sys/types.h>
#include <unistd.h>
#include <pwd.h>

void 
outputMessage(QtMsgType type, const char *msg)
{
  switch ( type ) {
#ifndef KIMERA_NO_DEBUG
  case QtDebugMsg:
    fprintf(stderr, "%s\n", msg);
    break;
    
  case QtWarningMsg:
    fprintf(stderr, "Warning: %s\n", msg);
    break;
#endif

  case QtFatalMsg:
    fprintf(stderr, "Fatal: %s\n", msg);
#ifndef KIMERA_NO_DEBUG
    abort();          // dump core on purpose
#endif
    break;

  default:
    break;
  }
}


int 
main(int argc, char* argv[])
{
  qInstallMsgHandler(outputMessage);
  KimeraApp app(argc, argv);

  // Check lock file
  struct passwd* pass = getpwuid( getuid() );
  QDir::setCurrent("/tmp");
  QFile lockfile(QString(".kimera_") + pass->pw_name + ".lock");
  if ( !lockfile.exists() ) {
    qWarning("No such lock file: %s/%s", QDir::current().path().ascii(), lockfile.name().ascii());
    return -1;
  } else {
    lockfile.remove();
  }

  QTextCodec*  codec = QTextCodec::codecForName("eucJP");  
  Q_CHECK_PTR( codec );
  qDebug("codec: %s", codec->name());    
  app.setDefaultCodec(codec); 

  MainForm* mainwidget = new MainForm();
  app.setMainWidget(mainwidget);

  QPoint pos;
  if ( mainwidget->loadPos(pos) )
    mainwidget->move(pos);

  mainwidget->show();    // Need to show at least once for initiation
  if ( mainwidget->isHideState() )
    mainwidget->hide();

  return app.exec();
}
