#ifndef KIMERAGLOBAL_H
#define KIMERAGLOBAL_H

#include <qstring.h>
#include <qdatastream.h>
#include <qpair.h>
#include <sys/types.h>

namespace Kimera {
  typedef  QPair<u_int16_t, u_int16_t>  ImIcPair;
  
  const QString KIMERACONF     = QString("/kimera/") + KIMERA_VERSION "/";
  
  enum ModeID {
    Mode_Hiragana    = 0x0001,  // Ҥ餬
    Mode_Katakana    = 0x0002,  // 
    Mode_HankakuKana = 0x0004,  // Ⱦѥ
    Mode_ZenkakuEisu = 0x0010,  // ѱѿ
    Mode_HankakuEisu = 0x0020,  // Ⱦѱѿ
    Mode_ModeMask    = 0x00ff,
    Mode_RomaInput   = 0x0100,  // ޻
    Mode_KanaInput   = 0x0200,  // 
    Mode_InputMask   = 0x0f00
  };

  enum ConvStatus {        // Kanji conversion status definition
    NONE_YOMI = 1,         // ϤƤʤ
    INPUTING_YOMI,         // ɤߤϤƤ
    CONVERTING_YOMI,       // ɤߤѴƤ
    SHOWING_LIST,          // ѴθɽƤ
    CHANGING_LENGTH,       // ʸĹѹƤ
    //EDITING_SEGMENT,     // Ѵ줿ʸԽƤ
    NUM_OF_CONVSTATUS = 5,
  };
  
  enum FuncID {     // Function name definition
    FID_AppendChar = 0,
    FID_NextCandidacy,
    FID_NextCandidacyGroup,
    FID_PreviousCandidacy,
    FID_PreviousCandidacyGroup,
    FID_ConvertAllSegments,
    FID_ConvertCrntSegment,
    FID_DeleteBackward,
    FID_DecideAllSegments,
    FID_DecideCrntSegment,
    FID_CancelConversion,
    FID_LengthenSegment,
    FID_ShortenSegment,
    FID_InputSpaceChar,
    FID_ConvertToHira,
    FID_ConvertToKana,
    FID_ConvertToHankakuKana,
    FID_ConvertToHankakuEisu,
    FID_ConvertToZenkakuEisu,
    FID_ForwardSegment,
    FID_BackwardSegment,
    FID_ToFirstSegment,
    FID_ToLastSegment,
    FID_SwitchZenkakuEisu,
    FID_ForwardKeyEvent, // ٥Ȥ򥯥饤Ȥ᤹
    FID_None,            // ⤷ʤ
    FID_NumFunctions,
  };

  enum SettingType {
    ST_CURRENT_SETTING = 0,
    ST_MSIME,
    ST_ATOK,
    ST_KINPUT2,
    ST_VJE,
    NUM_SETTING_TYPE,
  };
};

extern QDataStream::ByteOrder sysByteOrder();

#endif  // KIMERAGLOBAL_H
