#ifndef KANJIENGINE_H
#define KANJIENGINE_H

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>

#define EXPORT_KANJIENGINE(ENGINE)                              \
  class Static##ENGINE##Instance {                              \
  public:                                                       \
    Static##ENGINE##Instance() {                                \
      static ENGINE* instance;                                  \
      if (!instance) {                                          \
        instance = new ENGINE;                                  \
      }                                                         \
    }                                                           \
  };                                                            \
  static Static##ENGINE##Instance static##ENGINE##Instance;


class KanjiEngineCleanup;

class KanjiEngine : public QObject {
public:
  enum {  // For resizeSegment function
    LENGTHEN_1CHAR = -1,
    SHORTEN_1CHAR  = -2,
  };

  virtual QString name() const = 0;
  virtual bool  init();
  virtual void  cleanup();
  virtual bool  beginConvert(const QString& hira, QStringList& kanji, QStringList& yomigana) = 0;
  virtual void  endConvert(const QStringList& kanji=QString::null) = 0;
  virtual bool  getCandidate(int index, QStringList& candidate) = 0;
  virtual bool  resizeSegment(int index, int length, QStringList& kanji, QStringList& yomigana) = 0;
  virtual bool  isConverting();
  virtual bool  isTCPConnectionSupported() const;

  static KanjiEngine* kanjiEngine(const QString& name);
  static QStringList kanjiEngineList();

protected:
  KanjiEngine();
  virtual ~KanjiEngine() {}
  
  friend class QPtrList<KanjiEngine>;
  friend class KanjiEngineCleanup;
};

#endif  // KANJIENGINE_H
