#ifndef KANJICONVERT_H
#define KANJICONVERT_H

#include "kimeraglobal.h"
#include "dicthiragana.h"
#include "candidacylistbox.h"
#include "inputmode.h"
#include <qobject.h>
#include <qevent.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>
#include <qintdict.h>
using namespace Kimera;

class KanjiEngine;
class CandidacyListBox;
class PreeditArea;
class KanjiConvert;
class FuncPtr;

typedef bool  (KanjiConvert::*pmfunc)();
typedef Kimera::FuncID    FuncIDArray[NUM_OF_CONVSTATUS];


class KanjiConvert : public QObject {
  Q_OBJECT

public:
  KanjiConvert();
  ~KanjiConvert();
  void    init();
  void    clear();
  bool    processKeyEvent(const QKeyEvent&);
  void    setFont(QFont);
  void    setPreeditPoint(QPoint);
  
public slots:
  void    setInputMode(const InputMode&);

signals:
  void    decideSegments(const QString&);

protected slots:
  void    slotDecideSegment(QListBoxItem* item);

protected:
  bool    convertAllSegments();
  bool    convertCrntSegment();
  bool    nextCandidacy();
  bool    nextCandidacyGroup();
  bool    previousCandidacy();
  bool    previousCandidacyGroup();
  bool    appendChar(const QKeyEvent&);
  bool    deleteBackward();
  bool    decideAllSegments();
  bool    decideCrntSegment();
  bool    cancelConversion();
  bool    lengthenSegment();
  bool    shortenSegment();
  bool    inputSpaceChar();
  bool    convertToHira();
  bool    convertToKata();
  bool    convertToHankakuKana();
  bool    convertToHankakuEisu();
  bool    convertToZenkakuEisu();
  bool    forwardSegment();
  bool    backwardSegment();
  bool    toFirstSegment();
  bool    toLastSegment();
  bool    switchZenkakuEisu();

  bool    moveCrntItemCandidacyListBox(int d);
  void    showPreeditArea();
  void    syncInputKeysForward(const QString& str);
  void    syncInputKeysBackward(const QString& str);
  void    hideToolBox();
  QString forceConvtYomigana(const InputMode& mode) const;
  void    setConvertSegments(int idx, const QString&);
  void    setConvertSegments(int idx, const QStringList&);
  void    setYomigana(int idx, const QStringList&);

  static void  init_funcptrdict();

private:
  uint                 _crntsegidx;     // current segment index
  uint                 _minsegidx;      // minimum segment index
  QString              _inputkeys;      // input roma string
  QStringList          _yomiseglist;    // yomigana segment list
  QStringList          _convtkanjilist; // kanji string list converted
  ConvStatus           _stat;           // kanji conversion status
  InputMode            _mode;           // input mode
  DictHiragana         _dict;
  KanjiEngine*         _eng;
  PreeditArea*         _preedit;
  CandidacyListBox*    _candlist;
  
  static QIntDict<FuncPtr>   funcptrdict;  // dictionary of function pointer
};


class FuncPtr {
public:
  explicit FuncPtr(pmfunc p) : _pmf(p) { }
  pmfunc   ptr() const { return _pmf; }

private:  
  pmfunc   _pmf;  // pointer to member function of KanjiConvert class
};

#endif // KANJICONVERT_H
