#ifndef DICTHIRAGANA_H
#define DICTHIRAGANA_H

#include "kimeraglobal.h"
#include "inputmode.h"
#include <qdict.h>
#include <qstring.h>
#include <qevent.h>

class DictHiragana {
public:
  DictHiragana();
  ~DictHiragana();
  void     init();
  QString  convert(const QKeyEvent& key, const InputMode& mode = InputMode(Kimera::Mode_KanaInput | Kimera::Mode_Hiragana)) const;  // ޻  ߤ Ѵ
  QString  convert(const QString& roma, const InputMode& mode = InputMode()) const;           // ޻  ߤ Ѵ
  QString  forceConvt(const QString& roma, const InputMode& mode = InputMode()) const;        // ޻  ߤ Ѵ

protected:
  void     initDict(QDict<QString>& dict, const QString&, bool reverse_dict=FALSE);
  QString  convertToHira(const QString&) const;    // Ҥ餬Ѵ
  QString  forceConvtToHira(const QString&) const;
  QString  convertToKata(const QString&) const;    // Ѵ
  QString  forceConvtToKata(const QString&) const;
  QString  convertToHankakuKana(const QString& src) const;   // ȾѥѴ
  QString  forceConvtToHankakuKana(const QString& src) const;
  QString  convertToZenkakuEisu(const QString&) const;   // ѱѿѴ
  QString  reverseConvt(const QString& hira) const;    // Ҥ餬  ޻ Ѵ  

  static void copyDictFile(const QString dicname);

private:
  QDict<QString>     _dicthira;      // Ҥ餬ʼ
  QDict<QString>     _dictkata;      // ʼ
  QDict<QString>     _dicthankana;   // Ⱦѥʼ
  QDict<QString>     _dictalphbt;    // ѱѻ
  QDict<QString>     _dictsymbol;    // ѿ漭
  QDict<QString>     _dictkanainp;   // ϼ
  QDict<QString>     _dictdakuten;   // 
  QDict<QString>     _reversedict;   // հ
};

#endif // DICTHIRAGANA_H
