#include "config.h"
#include "kimeraglobal.h"
#include <qapplication.h>
#include <qdir.h>
using namespace Kimera;

QSettings Config::settings(QSettings::Ini);

QString
Config::readEntry(const QString& key, const QString& def, bool* ok)
{
  init();
  return settings.readEntry(KIMERACONF + key, def, ok);
}


bool
Config::readBoolEntry(const QString& key, bool def, bool* ok)
{
  init();
  return settings.readBoolEntry(KIMERACONF + key, def, ok);
}


int
Config::readNumEntry(const QString& key, int def, bool* ok)
{
  init();
  return settings.readNumEntry(KIMERACONF + key, def, ok);
}


bool 
Config::writeEntry(const QString& key, const QString& value, bool override, bool sync)
{
  init();
  bool res = true;
  if ( override ) {
    res = settings.writeEntry(KIMERACONF + key, value);

  } else {
    bool ok;
    settings.readEntry(KIMERACONF + key, QString::null, &ok);
    if ( !ok ) {
      res = settings.writeEntry(KIMERACONF + key, value);
    }
  }

  if ( sync )
    settings.sync();  // Sync

  return res;
}


bool 
Config::writeEntry(const QString& key, bool value, bool override, bool sync)
{
  init();
  bool res = true;
  if ( override ) {
    res = settings.writeEntry(KIMERACONF + key, value);
  
  } else {
    bool ok;
    settings.readBoolEntry(KIMERACONF + key, FALSE, &ok);
    if ( !ok ) 
      res = settings.writeEntry(KIMERACONF + key, value);
  }

  if ( sync )
    settings.sync();  // Sync
  
  return res;
}


bool 
Config::writeEntry(const QString& key, int value, bool override, bool sync)
{
  init();
  bool res = true;
  if ( override ) {
    res = settings.writeEntry(KIMERACONF + key, value);

  } else {
    bool ok;
    settings.readNumEntry(KIMERACONF + key, 0, &ok);
    if ( !ok ) {
      res = settings.writeEntry(KIMERACONF + key, value);
    }
  }

  if ( sync )
    settings.sync();  // Sync
  
  return res;
}


void
Config::init()
{
  static bool initdone = FALSE;

  if ( ! initdone ) {
    QString strconfdir = QDir::homeDirPath() + "/.kimera/";
    QDir confdir(strconfdir);
    
    if ( !confdir.exists() ) {
      confdir.mkdir(confdir.path());
    }
    
    settings.setPath("localhost", "kimera", QSettings::User);
    settings.insertSearchPath(QSettings::Unix, confdir.path());
    initdone = TRUE;
  }
}


QString
Config::dictionaryPath()
{
  QDir  dicdir(QDir::homeDirPath() + "/.kimera/dic");
  if ( !dicdir.exists() ) {
    dicdir.mkdir("", FALSE);
  }

  return dicdir.path();
}
