#ifndef CANDIDACYLISTBOX_H
#define CANDIDACYLISTBOX_H

#include <qlistbox.h>
#include <qstringlist.h>
#include <qpoint.h>

class CandidacyListBox : public QListBox {
  Q_OBJECT

public:
  enum {
    MAX_VISIBLE_ITEMS = 9,
  };

  CandidacyListBox();
  void showList(const QStringList& strs, int crntidx = 0);
  void showPreviousCandidacy(uint decrement = 1);
  void showNextCandidacy(uint increment = 1);
  void setFont(const QFont&);

public slots:
  void setPos(const QPoint& p);

protected:
  void showEvent(QShowEvent *);
  void hideEvent(QHideEvent *);

private:
  QPoint _pos;
};

#endif // CANDIDACYLISTBOX_H
