#include "candidacylistbox.h"
#include "inputmethod.h"
#include "ximattribute.h"
#include <qapplication.h>

const int MARGIN = 6;

CandidacyListBox::CandidacyListBox() 
  : QListBox((QWidget*)0, "candidacylistbox", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM),
    _pos()
{
}


void
CandidacyListBox::showList(const QStringList& strs, int crntidx)
{
  Q_ASSERT( !strs.isEmpty() );
  resize(0, 0);  
  insertStringList(strs);
  setCurrentItem((crntidx < (int)count()) ? crntidx : count() - 1);
  ensureCurrentVisible();
  
  int w ,h;
  if (count() > (uint)MAX_VISIBLE_ITEMS) {
    w = contentsWidth() + 22;
    h = itemHeight() * MAX_VISIBLE_ITEMS + MARGIN;
  } else {
    w = contentsWidth() + MARGIN;
    h = contentsHeight() + MARGIN;
  }
  resize(w, h);
  qDebug("CandidacyListBox w:%d h:%d", w, h);
  show();
}


void
CandidacyListBox::showPreviousCandidacy(uint decrement)
{
  if ( isHidden() ) {
    qFatal("Assert  %s:%d", __FILE__, __LINE__);
    return;
  } else if ( !count() ) {
    Q_ASSERT( count() );
    return;
  }

  int prev = currentItem() - decrement;
  if (prev < 0) {
    if (topItem() > 0) {
      setCurrentItem(0);
    } else {
      setCurrentItem(count() - 1);
    }

  } else {
    if (prev < topItem()) {
      int top = (decrement == MAX_VISIBLE_ITEMS) ? prev : prev - MAX_VISIBLE_ITEMS + 1;
      setTopItem(top);
    }
    setCurrentItem(prev);
  }
  
  ensureCurrentVisible();
}


void
CandidacyListBox::showNextCandidacy(uint increment)
{
  if ( isHidden() ) {
    qFatal("Assert  %s:%d", __FILE__, __LINE__);
    return;
  } else if ( !count() ) {
    Q_ASSERT( count() );
    return;
  }

  int next = currentItem() + increment;
  if (next < (int)count()) {
    if (next >= topItem() + MAX_VISIBLE_ITEMS) {
      setTopItem(next);
    }
    setCurrentItem(next);

  } else {
    setCurrentItem(0);
  }

  ensureCurrentVisible();
}


void
CandidacyListBox::showEvent(QShowEvent* e)
{
  // Adjusts pos
  const int offset = 2;
  int x = QMIN(_pos.x(), QApplication::desktop()->width() - width() - offset);
  int y = _pos.y();
  if (y > QApplication::desktop()->height() - height() - offset) {
    if (KimeraApp::inputmethod()->currentXIMStyle() == ON_THE_SPOT_STYLE) {
      y = QMIN(y, QApplication::desktop()->height() - height() - offset);
    } else {
      QFontMetrics fm( QListBox::font() ); 
      y -= height() + fm.height() + 1;
    }
  }
  move(QMAX(x, 0), QMAX(y, 0));
  
  QListBox::showEvent(e);
}


void
CandidacyListBox::hideEvent(QHideEvent* e)
{
  clear();
  QListBox::hideEvent(e);
}


void
CandidacyListBox::setFont(const QFont& f)
{
  QListBox::setFont(f);
  setMargins(1, 2, 1, 2);
  setFrameStyle( QFrame::Plain | QFrame::Box );
  setLineWidth( 1 );
  setColumnMode( 1 );   // Number of column is 1
  setHScrollBarMode( AlwaysOff );
}


void
CandidacyListBox::setPos(const QPoint& p)
{
  _pos = p;
}
