#ifndef ANTHYENGINE_H
#define ANTHYENGINE_H

#include "kanjiengine.h"

struct anthy_conv_stat;
struct anthy_segment_stat;


class AnthyEngine : public KanjiEngine {
public:
  explicit AnthyEngine();
  virtual  ~AnthyEngine();

  QString name() const;
  bool  init();
  void  cleanup();
  bool  beginConvert(const QString& hira, QStringList& kanji, QStringList& yomigana);
  void  endConvert(const QStringList& kanji=QString::null);
  bool  getCandidate(int idx, QStringList& candidate);
  bool  resizeSegment(int idx, int len, QStringList& kanji, QStringList& yomigana) ;
  bool  isConverting() { return _convertflag; }

private:
  void*   _anthy;
  bool    _convertflag;  // TRUE:  conversion in progress
                         // FALSE: conversion done
  void*   _dlanthydic;
  void*   _dlanthy;
  int     (*_pf_init)();
  void    (*_pf_quit)();
  void*   (*_pf_create_context)();
  void    (*_pf_release_context)(void*);
  int     (*_pf_set_string)(void* ac, char *str);
  int     (*_pf_get_stat)(void* ac, struct anthy_conv_stat* cs);
  int     (*_pf_get_segment)(void* ac, int s, int n, char* buf, int len);
  int     (*_pf_get_segment_stat)(void* ac, int n, struct anthy_segment_stat* ss);
  void    (*_pf_resize_segment)(void* ac, int nth, int resize);
  int     (*_pf_commit_segment)(void* ac, int s, int n);
};

#endif  // ANTHYENGINE_H
