TEMPLATE	= app
CONFIG	       += qt x11 warn_on release
TARGET          = kimera-bin
VERSION         = 1.0
isEmpty( target.path ) {
  target.path   = /usr/lib/kimera-$$VERSION
}
system( sed -e 's:^\(KIMERA_BIN=\).*\(kimera-bin\)$:\1$$target.path/\2:' tools/kimera > kimera && chmod +x kimera )
message(This project will be installed in $$target.path)
isEmpty( script.path ) {
  script.path     = /usr/bin
}
message(Kimera startup script will be installed in $$script.path)
script.files    = kimera
dic.files       = dic/hiragana.dic \
                  dic/katakana.dic \
                  dic/hankakukana.dic \
                  dic/numeralsymbols.dic \
                  dic/dakuten.dic \
                  dic/kanainput.dic \
                  dic/zenkakualphabet.dic
dic.path        = $$target.path/dic
INSTALLS        = target \
                  script \
                  dic
DEFINES        += KIMERA_VERSION=\"$$VERSION\" INSTALL_PATH=\"$$target.path\"
!contains(CONFIG, debug) {
  DEFINES      += KIMERA_NO_DEBUG
}
INCLUDEPATH    += src ui /usr/local/include
DEPENDPATH     += src ui
LIBS           += -ldl
HEADERS		= \
                  kimeraglobal.h \
                  mainform.h \
                  dicthiragana.h \
                  kimeraapp.h \
                  inputmethod.h \
                  ximattribute.h \
                  xicattribute.h \
	          kanjiengine.h \
                  cannaengine.h \
                  anthyengine.h \
#                  primeengine.h \
                  preeditarea.h \
                  supportattr.h \
                  candidacylistbox.h \
                  kanjiconvert.h \
                  ximethod.h \
                  xicontext.h \
                  inputmode.h \
                  config.h \
                  debug.h
SOURCES		= \
		  main.cpp \
                  kimeraglobal.cpp \
                  mainform.cpp \
                  dicthiragana.cpp \
                  kimeraapp.cpp \
                  inputmethod.cpp \
                  inputmethod_x11.cpp \
                  xicattribute.cpp \
                  kanjiengine.cpp \
		  cannaengine.cpp \
#                  primeengine.cpp \
                  preeditarea.cpp \
                  candidacylistbox.cpp \
                  kanjiconvert.cpp \
                  ximethod.cpp \
                  xicontext.cpp \
                  config.cpp \
                  debug.cpp

isEmpty(no_anthy) {
  SOURCES      +=  anthyengine.cpp
}

FORMS		= \
                  keyassigner.ui \
                  propertydialog.ui
DISTFILES      += \
                  AUTHORS \
                  INSTALL \
                  COPYING \
                  README \
                  tools/kimera \
                  dic/hiragana.dic \
                  dic/katakana.dic \
                  dic/hankakukana.dic \
                  dic/numeralsymbols.dic \
                  dic/dakuten.dic \
                  dic/kanainput.dic \
                  dic/zenkakualphabet.dic
DESTDIR         = .
OBJECTS_DIR	= .obj
MOC_DIR         = .obj
UI_DIR          = ui
DEFAULTCODEC    = eucJP
