/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/

#include <qapplication.h>
#include <qmessagebox.h>
#include <qregexp.h>
#include <qcolordialog.h>
#include <qpushbutton.h>
#include <qobject.h>
#include "kimeranamespace.h"
#include "config.h"
using namespace Kimera;

const int NUM_ROWS = 4;
const int NUM_COLS = 3;

static QString  ColorSetting[NUM_SETTING_TYPE][NUM_ROWS][NUM_COLS] = { 
  { { 0 } },       // Current setting (dummy)
  
  { { "black",  "white", "1" },      // MS-IME
    { "black",  "lightGray", "1" }, 
    { "black",  "white", "1" },
    { "white",  "blue",  "0" } },
  
  { { "blue",   "white", "0" },      // ATOK
    { "black",  "cyan",  "0" },
    { "blue",   "white", "0" },
    { "white",  "bule",  "0" } },
  
  { { "black",  "white", "1" },      // KINPUT2
    { "white",  "black", "0" }, 
    { "black",  "white", "1" },
    { "white",  "black", "0" } },
  
  { { "blue",   "gray",  "0" },      // VJE
    { "yellow", "black", "0" }, 
    { "yellow", "blue",  "0" },
    { "gray",   "blue",  "1" } },
};


void PropertyDialog::init()
{
  _colorsetting->setNumRows(NUM_ROWS);
  _colorsetting->setNumCols(NUM_COLS);

  for (int i = 0; i < _colorsetting->numRows(); ++i)
    _colorsetting->setRowStretchable (i ,TRUE);

  for (int i = 0; i < _colorsetting->numCols(); ++i)
    _colorsetting->setColumnStretchable(i ,TRUE);

  _cmbloadcolor->insertItem(tr("ߤ"), ST_CURRENT_SETTING);
  _cmbloadcolor->insertItem(tr("MS-IME"), ST_MSIME);
  _cmbloadcolor->insertItem(tr("ATOK"), ST_ATOK);
  _cmbloadcolor->insertItem(tr("Kinput2"), ST_KINPUT2);
  _cmbloadcolor->insertItem(tr("VJE"), ST_VJE);

  QStringList strlist;
  strlist << tr("ʤ") << tr("");
  for (int i = 0; i < NUM_ROWS; i++) {
    _colorsetting->setItem(i, 2, new QComboTableItem(_colorsetting, strlist));
  }

  QToolTip::add(_tab1, tr("ΥڡϼεưȿǤޤ"));
  QToolTip::add(_lblstartkey, tr("Ϥ򳫻Ϥ뤿Υꤷޤ"));
  QToolTip::add(_cmbstartkey, tr("Ϥ򳫻Ϥ뤿Υꤷޤ"));
  QToolTip::add(_lblinputmode, tr("Kimeraưϥ⡼ɤꤷޤ"));
  QToolTip::add(_cmbinputmode, tr("Kimeraưϥ⡼ɤꤷޤ"));
  QToolTip::add(_lblinputstyle, tr("KimeraưȤơ\n޻ϤޤϤϤꤷޤ"));
  QToolTip::add(_cmbinputstyle, tr("KimeraưȤơ\n޻ϤޤϤϤꤷޤ"));

  QToolTip::add(_lblspacekey, tr("ڡ򲡤ζʸˤĤ\nȾѤޤѤꤷޤ"));
  QToolTip::add(_cmbspacekey, tr("ڡ򲡤ζʸˤĤ\nȾѤޤѤꤷޤ"));
  QToolTip::add(_lbltenkey, tr("ƥ󥭡ϤʸˤĤ\nȾѤޤѤꤷޤ"));
  QToolTip::add(_cmbtenkey, tr("ƥ󥭡ϤʸˤĤ\nȾѤޤѤꤷޤ"));
  QToolTip::add(_lbltouten, tr("ꤷޤ"));
  QToolTip::add(_cmbtouten, tr("ꤷޤ"));
  QToolTip::add(_lblkuten, tr("ʸꤷޤ"));
  QToolTip::add(_cmbkuten, tr("ʸꤷޤ"));
  QToolTip::add(_lblbracket, tr("̤ꤷޤ"));
  QToolTip::add(_cmbbracket, tr("̤ꤷޤ"));
  QToolTip::add(_lblsymbol, tr("ꤷޤ"));
  QToolTip::add(_cmbsymbol, tr("ꤷޤ"));

  QToolTip::add(_lblkanjisys, tr("ѤѴƥꤷޤ"));
  QToolTip::add(_cmbkanjisys, tr("ѤѴƥꤷޤ"));
  QToolTip::add(_lblsvrname, tr("ѴФΥۥ̾ꤷޤ"));
  QToolTip::add(_edtsvrname, tr("ѴФΥۥ̾ꤷޤ"));
  QToolTip::add(_lblport, tr("³ݡֹꤷޤ"));
  QToolTip::add(_edtport, tr("³ݡֹꤷޤ"));
}


void PropertyDialog::polish()
{
  QDialog::polish();

  _cmbstartkey->setCurrentText(Config::readEntry(_cmbstartkey->name(),
						 _cmbstartkey->currentText()));
  _cmbinputmode->setCurrentText(Config::readEntry(_cmbinputmode->name(), 
						  _cmbinputmode->currentText()));
  _cmbinputstyle->setCurrentText(Config::readEntry(_cmbinputstyle->name(), 
						   _cmbinputstyle->currentText()));
  
  _cmbspacekey->setCurrentText(Config::readEntry(_cmbspacekey->name(),
						 _cmbspacekey->currentText()));
  _cmbtenkey->setCurrentText(Config::readEntry(_cmbtenkey->name(), 
					       _cmbtenkey->currentText()));
  _cmbkuten->setCurrentText(Config::readEntry(_cmbkuten->name(), 
					      _cmbkuten->currentText()));
  _cmbtouten->setCurrentText(Config::readEntry(_cmbtouten->name(), 
					       _cmbtouten->currentText()));
  _cmbsymbol->setCurrentText(Config::readEntry(_cmbsymbol->name(), 
					       _cmbsymbol->currentText()));
  _cmbbracket->setCurrentText(Config::readEntry(_cmbbracket->name(), 
						_cmbbracket->currentText()));

  _cmbkanjisys->setCurrentText(Config::readEntry(_cmbkanjisys->name(), 
						 _cmbkanjisys->currentText()));
  _chkremote->setChecked(Config::readBoolEntry(_chkremote->name(), 
					       _chkremote->isChecked()));
  _edtsvrname->setText(Config::readEntry(_edtsvrname->name(), _edtsvrname->text()));
  _edtport->setText(Config::readEntry(_edtport->name(), _edtport->text()));

  loadColorSetting( ST_CURRENT_SETTING );    // Loads color setting
}

void PropertyDialog::saveSetteing()
{
  // Check entry
  if (_chkremote->isChecked()) {
    if (_edtsvrname->text().isEmpty() || _edtport->text().isEmpty()) {
      QMessageBox::warning(0, "Incorrect entry", 
			   "Incorrect entry!\nInput Kanji server and port correctly.",
			   QMessageBox::Ok | QMessageBox::Default, 0);

      _tabwdg->showPage(_tab3);  // show page
      return;
      
    } else if ( !_edtport->text().contains(QRegExp("^[0-9]{4,5}$")) ) {
      QMessageBox::warning(0, "Incorrect port number", 
			   "Incorrect port number!\nInput numerical string, 4 or 5 characters.",
			   QMessageBox::Ok | QMessageBox::Default, 0);
      
      _tabwdg->showPage(_tab3);  // show page
      return;
    }
  }
  
  // Saves setting
  Config::writeEntry(_cmbstartkey->name(), _cmbstartkey->currentText());
  Config::writeEntry(_cmbinputmode->name(), _cmbinputmode->currentText());
  Config::writeEntry(_cmbinputstyle->name(), _cmbinputstyle->currentText());

  Config::writeEntry(_cmbspacekey->name(), _cmbspacekey->currentText());
  Config::writeEntry(_cmbtenkey->name(), _cmbtenkey->currentText());
  Config::writeEntry(_cmbkuten->name(), _cmbkuten->currentText());
  Config::writeEntry(_cmbtouten->name(), _cmbtouten->currentText());
  Config::writeEntry(_cmbsymbol->name(), _cmbsymbol->currentText());
  Config::writeEntry(_cmbbracket->name(), _cmbbracket->currentText());
  
  Config::writeEntry(_cmbkanjisys->name(), _cmbkanjisys->currentText());
  Config::writeEntry(_chkremote->name(), _chkremote->isChecked());
  Config::writeEntry(_edtsvrname->name(), _edtsvrname->text());
  Config::writeEntry(_edtport->name(), _edtport->text());
  
  saveColorSetting();
  qDebug("Saved settings");
  accept(); 
}


void PropertyDialog::changeColor( int row, int col, int button, const QPoint & mousePos ) 
{
  if (col > 1) return;

  QColor color( white );
  if ( _colorsetting->text(row, col) ) {
    QColor c( _colorsetting->text(row, col) );
    if ( c.isValid() ) color = c;    // default color
  }
  
  // Select color
  color = QColorDialog::getColor(color, this);
  if ( color.isValid() ) {
    QPixmap  pix = _colorsetting->pixmap( row, col );
    pix.resize(_colorsetting->columnWidth(col), _colorsetting->rowHeight(row));
    pix.fill( color );
    _colorsetting->setPixmap(row, col, pix);
    _colorsetting->setText(row, col, color.name());
    qDebug("get color name: %s", color.name().data());
  }
}


void PropertyDialog::showEvent(QShowEvent* e)
{
#if 0
  _cmbstartkey->setCurrentText(Config::readEntry(_cmbstartkey->name(),
						 _cmbstartkey->currentText()));
  _cmbinputmode->setCurrentText(Config::readEntry(_cmbinputmode->name(), 
						  _cmbinputmode->currentText()));
  _cmbinputstyle->setCurrentText(Config::readEntry(_cmbinputstyle->name(), 
						   _cmbinputstyle->currentText()));
  
  _cmbspacekey->setCurrentText(Config::readEntry(_cmbspacekey->name(),
						 _cmbspacekey->currentText()));
  _cmbtenkey->setCurrentText(Config::readEntry(_cmbtenkey->name(), 
					       _cmbtenkey->currentText()));
  _cmbkuten->setCurrentText(Config::readEntry(_cmbkuten->name(), 
					      _cmbkuten->currentText()));
  _cmbtouten->setCurrentText(Config::readEntry(_cmbtouten->name(), 
					       _cmbtouten->currentText()));
  _cmbsymbol->setCurrentText(Config::readEntry(_cmbsymbol->name(), 
					       _cmbsymbol->currentText()));
  _cmbbracket->setCurrentText(Config::readEntry(_cmbbracket->name(), 
						_cmbbracket->currentText()));

  _cmbkanjisys->setCurrentText(Config::readEntry(_cmbkanjisys->name(), 
						 _cmbkanjisys->currentText()));
  _chkremote->setChecked(Config::readBoolEntry(_chkremote->name(), 
					       _chkremote->isChecked()));
  _edtsvrname->setText(Config::readEntry(_edtsvrname->name(), _edtsvrname->text()));
  _edtport->setText(Config::readEntry(_edtport->name(), _edtport->text()));
#endif
  QDialog::showEvent(e);
}


void PropertyDialog::execKeyAssiner()
{
  KeyAssigner* dlg = new KeyAssigner();
  dlg->exec();
  delete dlg;
}


void PropertyDialog::saveColorSetting()
{
  // Saves color table items
  int i, j;
  for (i = 0; i < NUM_ROWS; i++) {
    for (j = 0; j < NUM_COLS - 1; j++) {
      if ( _colorsetting->text(i, j) ) {
	Config::writeEntry(QString(_colorsetting->name()) + "color" + QString::number(i * 2 + j), 
			   _colorsetting->text(i, j) );
      }
    }
    
    Config::writeEntry(QString(_colorsetting->name()) + "underline" + QString::number(i), 
		       _colorsetting->text(i, j) );
  }
}


void PropertyDialog::loadColorSetting( int index )
{
  qApp->processEvents();

  int i, j;
  switch ( index ) {
  case ST_CURRENT_SETTING:         // Current setting
    // Loads Color table
    for (i = 0; i < NUM_ROWS; i++) {
      for (j = 0; j < NUM_COLS - 1; j++) {
        QColor color(Config::readEntry(QString(_colorsetting->name()) + "color" 
                                       + QString::number(i * 2 + j), "white"));
        if ( color.isValid() ) {
          QPixmap  pix = _colorsetting->pixmap(i, j);
          pix.resize(_colorsetting->columnWidth(j), _colorsetting->rowHeight(i));
          pix.fill( color );
          _colorsetting->setPixmap(i, j, pix);
          _colorsetting->setText(i, j, color.name());
          qDebug("set color row: %d  col: %d  name: %s", i, j, color.name().data());
        }
      }

      QComboTableItem*  item =  (QComboTableItem *)_colorsetting->item(i, j);
      item->setCurrentItem(Config::readEntry(QString(_colorsetting->name()) 
                                             + "underline" + QString::number(i), 
                                             tr("ʤ")));
    }
    break;

  case ST_ATOK:
  case ST_KINPUT2:
  case ST_MSIME:
  case ST_VJE:
    // Loads Color table
    for (i = 0; i < NUM_ROWS; i++) {
      for (j = 0; j < NUM_COLS - 1; j++) {
        QColor color( ColorSetting[index][i][j] );
        if ( color.isValid() ) {
          QPixmap  pix = _colorsetting->pixmap(i, j);
          pix.resize(_colorsetting->columnWidth(j), _colorsetting->rowHeight(i));
          pix.fill( color );
          _colorsetting->setPixmap(i, j, pix);
          _colorsetting->setText(i, j, color.name());
          qDebug("set color row: %d  col: %d  name: %s", i, j, color.name().data());
        }
      }
      
      QComboTableItem*  item =  (QComboTableItem *)_colorsetting->item(i, j);
      item->setCurrentItem( (ColorSetting[index][i][j]).toInt() );
    }
    break;

  default:
    break;
  }
}


void PropertyDialog::saveDefaultSetting()
{
  Config::writeEntry("_cmbstartkey", QObject::tr("Kanji"), FALSE);
  Config::writeEntry("_cmbinputmode", QObject::tr("Ҥ餬"), FALSE);
  Config::writeEntry("_cmbinputstyle", QObject::tr("޻"), FALSE);
  
  Config::writeEntry("_cmbspacekey", QObject::tr("Ⱦ"), FALSE);
  Config::writeEntry("_cmbtenkey", QObject::tr("Ⱦ"), FALSE);
  Config::writeEntry("_cmbtouten", QObject::tr(""), FALSE);
  Config::writeEntry("_cmbkuten", QObject::tr(""), FALSE);
  Config::writeEntry("_cmbsymbol", QObject::tr(""), FALSE);
  Config::writeEntry("_cmbbracket", QObject::tr("֡"), FALSE);
  
  Config::writeEntry("_cmbkanjisys", QObject::tr("canna"), FALSE);
  Config::writeEntry("_chkremote", FALSE, FALSE);
  Config::writeEntry("_edtsvrname", QString::null, FALSE);
  Config::writeEntry("_edtport", QString::null, FALSE);

  // Saves default color table items
  const int setting = ST_KINPUT2;
  int i, j;
  for (i = 0; i < NUM_ROWS; i++) {
    for (j = 0; j < NUM_COLS - 1; j++) {
      Config::writeEntry(QString("_colorsetting") + "color" + QString::number(i * 2 + j), 
			 ColorSetting[setting][i][j], FALSE);
    }
    
    Config::writeEntry(QString("_colorsetting") + "underline" + QString::number(i), 
		       ColorSetting[setting][i][j], FALSE);
  }
}
