#ifndef XIMATTRIBUTE_H
#define XIMATTRIBUTE_H

#include "xicontext.h"
#include <X11/Xlib.h>

class XIMethod;

enum { OverTheSpotStyle = XIMPreeditPosition | XIMStatusNothing };
  
class XIMAttribute {
public:
  XIMAttribute(Window w, QDataStream::ByteOrder b, XIMStyle s = OverTheSpotStyle) : _imid(0), _commwin(w), _border(b), _ximstyle(s), _xic(XIContext(b)) { }
  ~XIMAttribute() {}
  
  inline Window   commWin() const { return _commwin; } 
  inline ushort   im() const { return _imid; }
  inline XIMStyle style() const { return _ximstyle; }
  inline QDataStream::ByteOrder byteOrder() const { return _border; }

protected:
  ushort   setIM(ushort im) { _imid = im; }
  void     setStyle(XIMStyle s) { _ximstyle = s; }
  
private:
  Window       _commwin;     // communication window
  ushort       _imid;        // IM-ID  
  XIMStyle     _ximstyle;    // attribute ID: 0
  XIContext    _xic;         // XInputContext
  QDataStream::ByteOrder _border;

  friend class XIMethod;
};
 

#endif // XIMATTRIBUTE_H







