#include "xicontext.h"
#include "xicattribute.h"

QValueList<SupportAttr> XIContext::_attr_list = QValueList<SupportAttr>();

void
XIContext::initSuppICAttr()
{
  if ( !_attr_list.isEmpty() ) return;
  
  ushort i = 0;
  _attr_list << SupportAttr(i++, XNInputStyle, TYPE_LONG);
  _attr_list << SupportAttr(i++, XNClientWindow,TYPE_WINDOW);
  _attr_list << SupportAttr(i++, XNPreeditAttributes, TYPE_NESTEDLIST);
  _attr_list << SupportAttr(i++, XNStatusAttributes, TYPE_NESTEDLIST);
  _attr_list << SupportAttr(i++, XNFilterEvents, TYPE_WORD);
  _attr_list << SupportAttr(i++, XNFocusWindow, TYPE_WINDOW);
  _attr_list << SupportAttr(i++, XNFontSet, TYPE_XFONTSET);
  _attr_list << SupportAttr(i++, XNSpotLocation, TYPE_XPOINT);
  _attr_list << SupportAttr(i++, XNAreaNeeded, TYPE_XRECTANGLE);
  _attr_list << SupportAttr(i++, XNArea, TYPE_XRECTANGLE);
  _attr_list << SupportAttr(i++, XNForeground, TYPE_LONG);
  _attr_list << SupportAttr(i++, XNBackground, TYPE_LONG);
  _attr_list << SupportAttr(i++, XNBackgroundPixmap, TYPE_LONG);
  _attr_list << SupportAttr(i++, XNColormap, TYPE_WORD);
  _attr_list << SupportAttr(i++, XNStdColormap, TYPE_WORD);
  //_attr_list << SupportAttr(i++, XNLineSpace, TYPE_WORD);
  _attr_list << SupportAttr(i++, XNLineSpace, TYPE_LONG);
  _attr_list << SupportAttr(i++, XNCursor, TYPE_WORD);

  Q_ASSERT(_attr_list.count() == 17);
}


QValueList<SupportAttr>
XIContext::getSuppICAttr() 
{
  if ( _attr_list.isEmpty() ) initSuppICAttr();
  return _attr_list; 
}


XIContext::XIContext(QDataStream::ByteOrder bo) : _byteorder(bo)
{
  _iclist.setAutoDelete(TRUE);
}


XIContext::~XIContext()
{

}


ushort     
XIContext::createIC()
{
  ushort newic = 1;   // 1 origin
  for (;;) {
    if ( !_iclist[newic] ) break;
    ++newic;
  }
  
  _iclist.replace(newic, new XICAttribute(newic, _byteorder));
  return newic;
}


void  
XIContext::removeIC(ushort ic) 
{ 
  _iclist.remove(ic); 
}


void
XIContext::setValue(ushort ic, ushort id, const QByteArray& data)
{
  XICAttribute* pxic = _iclist[ic];
  if ( pxic ) pxic->setValue(id, data);
}


QByteArray
XIContext::getValue(ushort ic, ushort id) const
{
  XICAttribute* pxic = _iclist[ic];
  return pxic ? pxic->getValue(id) : QByteArray();
}


Window
XIContext::focusWindow(ushort ic) const
{
  XICAttribute* pxic = _iclist[ic];
  return pxic ? pxic->focusWindow() : 0;
}


QString
XIContext::fontPreedit(ushort ic) const
{
  XICAttribute* pxic = _iclist[ic];
  return pxic ? pxic->fontPreedit() : QString();
}


QPoint
XIContext::spotPreedit(ushort ic) const
{
  XICAttribute* pxic = _iclist[ic];
  return pxic ? pxic->spotPreedit() : QPoint();
}


void
XIContext::setTriggerFlag(ushort ic, bool b)
{
  XICAttribute* pxic = _iclist[ic];
  if ( pxic ) pxic->setTriggerFlag(b);
}


bool
XIContext::triggerFlag(ushort ic) const
{
  XICAttribute* pxic = _iclist[ic];
  return pxic ? pxic->triggerFlag() : FALSE;
}















