#ifndef SOCKKANJICLIENT_H
#define SOCKKANJICLIENT_H

#include <qobject.h>
#include <qstring.h>
#include <qstringlist.h>
#include <stddef.h>

class QSocket;

class SockKanjiClient : public QObject {
  Q_OBJECT

public:
  SockKanjiClient();
  ~SockKanjiClient();

  void init();
  void beginConvert(const QString&);
  void endConvert();
  void getCandidacyList(int idx);
  void getYomi(int idx);
  void resizePause(int idx, int len);
  bool isConverting() const { return _convertflag; }

signals:
  void converted(const QStringList&, int idx);
  void candidate(const QStringList&, int idx);
  void yomigana(const QString&, int idx);

protected:
  void sendInitialize();
  void mountDictionary();
  void getDictionaryList();
  void recvGetDictionaryListReply();
  void recvInitializeReply();
  void recvMountDictionaryReply(); 
  void recvBeginConvertReply();
  void recvEndConvertReply() const;
  void recvGetCandidacyListReply();
  void recvGetYomiReply();
  void recvResizePause();

  QByteArray  eucToUint16(const QCString&);
  QCString    uint16ToEuc(const QByteArray&);

protected slots:
  void slotConnected();
  void slotDispatch();
  void slotDetectError();
  void slotConnectionClosed();

private:
  QSocket*    _sock;
  int16_t     _contxt;
  int         _crntidx;
  bool        _convertflag;   // TRUE:  conversion in progress
                              // FALSE: conversion done
  QStringList _strlist;       // string list converted
  QStringList _diclist;       // to mount dictionary
};

#endif // SOCKKANJICLIENT_H
