#include "mainform.h"
#include "kimeranamespace.h"
#include "kimeraapp.h"
#include "inputmethod.h"
#include "inputmode.h"
#include "propertydialog.h"
#include "keyassigner.h"
#include "config.h"
#include <qvariant.h>
#include <qtoolbutton.h>
#include <qlayout.h>
#include <qtooltip.h>
#include <qwhatsthis.h>
#include <qpopupmenu.h> 
#include <qstring.h>
using namespace Kimera;

static const char *property_xpm[] = {
  "16 16 79 2",
  "Qt c None",
  ".a c #383858",
  ".e c #5a5a79",
  ".K c #676786",
  ".o c #6a6a88",
  ".8 c #6d6d8c",
  ".0 c #71718f",
  "#j c #737391",
  ".P c #757592",
  "#e c #767693",
  "#m c #777795",
  ".t c #797b97",
  "#i c #7b7b98",
  ".3 c #7c7c98",
  ".2 c #7e7e9a",
  "#d c #7f7e9a",
  "#h c #7f7e9b",
  ".1 c #80809b",
  ".f c #82829e",
  "#c c #83829e",
  ".# c #83839f",
  "## c #8886a2",
  ".Q c #8989a3",
  "#. c #8b8ba6",
  ".7 c #8f8fa9",
  ".6 c #9595ae",
  "#l c #9797af",
  ".Z c #9a9ab2",
  ".Y c #9f9fb6",
  "#g c #a1a1b8",
  ".X c #a5a5bb",
  ".O c #a5a6bc",
  "#b c #a8a8bd",
  ".N c #aaabbf",
  ".J c #abaabf",
  ".9 c #afafc3",
  ".E c #b0afc4",
  ".I c #b0b0c4",
  "#k c #b1b1c5",
  "#f c #b2b2c5",
  "#a c #b5b5c8",
  ".z c #b6b6c9",
  ".M c #b7b7c9",
  ".5 c #b8b8ca",
  ".4 c #b9b9cb",
  ".x c #bcbccc",
  ".W c #c1c0d1",
  ".r c #c1c1d1",
  ".q c #c7c5d5",
  ".w c #c7c7d5",
  ".p c #cbcbd8",
  ".D c #cbcbda",
  ".n c #cbccda",
  ".H c #ccccd8",
  ".v c #ccccda",
  ".m c #cfd0dc",
  ".k c #d0cfdc",
  ".u c #d0d0dc",
  ".j c #d5d5e0",
  ".C c #d8d8e2",
  ".G c #d8d9e2",
  ".l c #d9d8e2",
  ".i c #d9d9e2",
  ".h c #dbdbe6",
  ".d c #dddbe6",
  ".B c #dddde6",
  ".g c #dfdfe8",
  ".c c #e0dfe8",
  ".y c #e0e0e8",
  ".V c #e1e1e9",
  ".b c #e2e2e9",
  ".U c #e3e3eb",
  ".T c #e5e5ec",
  ".S c #e8e8ed",
  ".R c #eaeaf0",
  ".L c #ededf2",
  ".F c #f1f1f5",
  ".A c #f2f2f5",
  ".s c #f3f3f6",
  "QtQtQtQt.#.#.#.#.#QtQtQtQtQtQtQt",
  "QtQtQtQt.a.b.b.c.d.e.eQtQtQtQtQt",
  "QtQtQtQt.f.a.g.h.i.j.k.eQtQtQtQt",
  "QtQtQtQtQt.f.a.l.j.m.n.eQtQtQtQt",
  ".o.oQtQtQtQt.f.#.k.p.q.r.eQtQtQt",
  ".o.s.#QtQtQt.t.u.v.w.r.x.eQtQtQt",
  ".o.s.y.#Qt.t.u.p.w.r.x.z.eQtQtQt",
  ".o.A.B.C.t.u.D.w.r.x.z.E.eQtQtQt",
  ".o.F.G.j.k.H.w.r.x.z.I.J.eQtQtQt",
  ".o.K.L.u.v.w.r.x.M.I.N.O.P.eQtQt",
  "Qt.a.Q.R.S.T.U.V.u.W.X.Y.Z.0.eQt",
  "Qt.f.a.a.f.1.2.3.f.4.5.Z.6.7.8.e",
  "QtQtQt.f.a.a.a.a.a.2.M.9.7#.##.o",
  "QtQtQtQtQtQtQtQt.f.a.t#a#b###c#d",
  "QtQtQtQtQtQtQtQtQt.f.a#e#f#g#h#i",
  "QtQtQtQtQtQtQtQtQtQt.f.a#j#k#l#m"
};


MainForm::MainForm( QWidget* parent, const char* name, WFlags fl )
  : QWidget(parent, name, fl)
{
  if ( !name ) 
    setName( "MainForm" );
  
  _toolbutton1 = new QToolButton( this, "ToolButton1" );
  _toolbutton1->setGeometry( QRect( 0, 0, 31, 31 ) ); 
 
  _toolbutton2 = new QToolButton( this, "ToolButton2" );
  _toolbutton2->setGeometry( QRect( 30, 0, 31, 31 ) ); 
  
  _toolbutton3 = new QToolButton( this, "ToolButton3" );
  _toolbutton3->setGeometry( QRect( 60, 0, 31, 31 ) ); 

  _popupmenu1 = new QPopupMenu( this );
  _popupmenu2 = new QPopupMenu( this );
  //_propform = new PropertyForm(this, "property form", Qt::WType_Dialog);
  _inputmethod = KimeraApp::inputmethod();

  languageChange();
  resize( QSize(91, 31).expandedTo(minimumSizeHint()) );

  // signals and slots connections
  connect(_inputmethod, SIGNAL(triggerNotify(bool)), 
	  this, SLOT(slotTriggerNotify(bool)));

  // Transfer signal to signal
  connect(this, SIGNAL(setInputMode(const InputMode&)), 
	  _inputmethod, SIGNAL(setInputMode(const InputMode&)));

  //connect(_toolbutton3, SIGNAL(clicked()), _propform, SLOT(show()));
  connect(_toolbutton3, SIGNAL(clicked()), this, SLOT(execPropertyDialog()));
  connect(_popupmenu1, SIGNAL(activated(int)), this, SLOT(setButtonText(int)));
  connect(_popupmenu2, SIGNAL(activated(int)), this, SLOT(setButtonText(int)));

  // Save Default setting
  PropertyDialog::saveDefaultSetting();
  KeyAssigner::saveDefaultSetting();
}


MainForm::~MainForm()
{
  // no need to delete child widgets, Qt does it all for us  
}

/*
 *  Sets the strings of the subwidgets using the current
 *  language.
 */
void 
MainForm::languageChange()
{
  setCaption( tr("Kimera") );

  _toolbutton1->setTextLabel("A_");
  _toolbutton1->setUsesTextLabel(TRUE);

  _toolbutton2->setTextLabel(tr("-"));
  _toolbutton2->setUsesTextLabel(TRUE);
  QFont f =_toolbutton2->font();
  f.setPointSize( 7 );
  _toolbutton2->setFont(f);

  _toolbutton3->setIconSet( QIconSet( QPixmap((const char **)property_xpm) ) );

  _popupmenu1->clear();
  _popupmenu1->insertItem(tr("Ҥ餬"), Mode_Hiragana);
  _popupmenu1->insertItem(tr(""), Mode_Katakana);
  _popupmenu1->insertItem(tr("ѱѿ"), Mode_ZenkakuEisu);
  _popupmenu1->setCheckable(TRUE);

  _popupmenu2->clear();
  _popupmenu2->insertItem(tr("޻"), Mode_RomaInput);
  _popupmenu2->insertItem(tr(""), Mode_KanaInput);
  _popupmenu2->setCheckable(TRUE);

  _toolbutton1->setPopup(_popupmenu1);
  _toolbutton1->setPopupDelay(1);

  _toolbutton2->setPopup(_popupmenu2);
  _toolbutton2->setPopupDelay(1);
}


void
MainForm::initIM()
{
  _inputmethod->init();
}


void
MainForm::polish()
{
  QWidget::polish();
  initIM();

  QString s(Config::readEntry("_cmbinputmode", ""));
  int mode = 0;
  if (s == tr("Ҥ餬")) {
    _popupmenu1->setItemChecked(Mode_Hiragana, TRUE);

  } else if (s == tr("")) {
    _popupmenu1->setItemChecked(Mode_Katakana, TRUE);
    
  } else if (s == tr("ѱѿ")) {
    _popupmenu1->setItemChecked(Mode_ZenkakuEisu, TRUE);

  } else {
    Q_ASSERT(0);
  }
  
  s = Config::readEntry("_cmbinputstyle", "");
  if (s == tr("޻")) {
    mode = Mode_RomaInput;

  } else if (s == tr("")) {
    mode = Mode_KanaInput;

  } else {
    Q_ASSERT(0);
  }

  setButtonText(mode);
  _popupmenu1->setItemEnabled(Mode_Hiragana, FALSE);
  _popupmenu1->setItemEnabled(Mode_Katakana, FALSE);
  _popupmenu1->setItemEnabled(Mode_ZenkakuEisu, FALSE);
  _popupmenu2->setItemEnabled(Mode_RomaInput, FALSE);
  _popupmenu2->setItemEnabled(Mode_KanaInput, FALSE);
}


void
MainForm::setButtonText(int id)
{
  switch (id & Mode_ModeMask) {
  case Mode_Hiragana:
  case Mode_Katakana:
  case Mode_ZenkakuEisu:
    _popupmenu1->setItemChecked(Mode_Hiragana, FALSE);
    _popupmenu1->setItemChecked(Mode_Katakana, FALSE);
    _popupmenu1->setItemChecked(Mode_ZenkakuEisu, FALSE);
    _popupmenu1->setItemChecked(id, TRUE);
    break;

  case 0:
    break;
    
  default:
    Q_ASSERT(0);
    break;
  }

  switch (id & Mode_InputMask) {
  case Mode_RomaInput:
  case Mode_KanaInput:
    _popupmenu2->setItemChecked(Mode_RomaInput, FALSE);
    _popupmenu2->setItemChecked(Mode_KanaInput, FALSE);
    _popupmenu2->setItemChecked(id, TRUE);
    break;
    
  case 0:
    break;

  default:
    Q_ASSERT(0);
    break;
  }

  switch (id & Mode_ModeMask) {
  case Mode_Hiragana:
    _toolbutton1->setTextLabel(tr(""));
    break;
    
  case Mode_Katakana:
    _toolbutton1->setTextLabel(tr(""));
    break;
    
  case Mode_ZenkakuEisu:
    _toolbutton1->setTextLabel(tr(""));
    break;

  case 0:
    break;

  default:
    Q_ASSERT(0);
    break;
  }

  switch (id & Mode_InputMask) {
  case Mode_RomaInput:
    _toolbutton2->setTextLabel(tr("-"));
    break;
    
  case Mode_KanaInput:
    _toolbutton2->setTextLabel(tr(""));
    break;
    
  case 0:
    break;
    
  default:
    Q_ASSERT(0);
    break;
  }
  
  emit setInputMode(InputMode(id));
}


void
MainForm::slotTriggerNotify(bool b)
{
  static bool  tiggerflag = FALSE;
  
  if (tiggerflag == b) 
    return;
  else 
    tiggerflag = b;
  
  if ( tiggerflag ) {
    for (int i = 0; i < _popupmenu1->count(); i++) {
      if ( _popupmenu1->isItemChecked (_popupmenu1->idAt(i)) ) {
	setButtonText(_popupmenu1->idAt(i));
	break;
      }
    }
    
    _popupmenu1->setItemEnabled(Mode_Hiragana, TRUE);
    _popupmenu1->setItemEnabled(Mode_Katakana, TRUE);
    _popupmenu1->setItemEnabled(Mode_ZenkakuEisu, TRUE);
    _popupmenu2->setItemEnabled(Mode_RomaInput, TRUE);
    _popupmenu2->setItemEnabled(Mode_KanaInput, TRUE);
    
  } else {
    _toolbutton1->setTextLabel("A_");
    _popupmenu1->setItemEnabled(Mode_Hiragana, FALSE);
    _popupmenu1->setItemEnabled(Mode_Katakana, FALSE);
    _popupmenu1->setItemEnabled(Mode_ZenkakuEisu, FALSE);
    _popupmenu2->setItemEnabled(Mode_RomaInput, FALSE);
    _popupmenu2->setItemEnabled(Mode_KanaInput, FALSE);
  }
}


void
MainForm::execPropertyDialog()
{
  PropertyDialog* dlg = new PropertyDialog();
  int res = dlg->exec();
  delete dlg;

  if (res == PropertyDialog::Accepted)
    initIM();
}
