#include "kimeraapp.h"
#include "mainform.h"
#include <qtextcodec.h>
#include <qapplication.h>

void 
outputMessage(QtMsgType type, const char *msg)
{
#ifndef QT_NO_DEBUG
  switch ( type ) {
  case QtDebugMsg:
    fprintf(stderr, "%s\n", msg);
    break;
    
  case QtWarningMsg:
    fprintf(stderr, "Warning: %s\n", msg);
    break;
    
  case QtFatalMsg:
    fprintf(stderr, "Fatal: %s\n", msg);
    abort();          // dump core on purpose
  }
#endif
}


int 
main(int argc, char* argv[])
{
  qInstallMsgHandler(outputMessage);
  KimeraApp app(argc, argv);

  QTranslator translator( 0 );
  bool res = translator.load( QString("kimera-") + QString(QTextCodec::locale()).section('.', 0, 0), INSTALL_PATH );
  if ( res ) {
    app.installTranslator( &translator );
  } else {
    qFatal("Can not load translator file");
  }
  
  QTextCodec*  codec = QTextCodec::codecForName("eucJP");  
  Q_CHECK_PTR( codec );
  qDebug("codec: %s", codec->name());    
  app.setDefaultCodec(codec); 

  MainForm* mainwidget = new MainForm(0, "MainForm", Qt::WStyle_Customize | Qt::WStyle_StaysOnTop | Qt::WStyle_Title);
  app.setMainWidget(mainwidget);
  mainwidget->show();

  int ret = app.exec();
  delete mainwidget;
  return ret;
}
