#ifndef KIMERANAMESPACE_H
#define KIMERANAMESPACE_H

#include <qobject.h>
#include <qstring.h>

namespace Kimera {
  const QString KIMERACONF     = QString("/kimera/") + KIMERA_VERSION "/";
  
  enum ModeID {
    Mode_Hiragana    = 0x0001,  // Ҥ餬
    Mode_Katakana    = 0x0002,  // 
    Mode_ZenkakuEisu = 0x0004,  // ѱѿ
    Mode_Hankaku     = 0x0008,  // Ⱦ
    Mode_ModeMask    = 0x000f,
    Mode_RomaInput   = 0x0010,  // ޻
    Mode_KanaInput   = 0x0020,  // 
    Mode_InputMask   = 0x00f0
  };

  enum ConvStatus {        // Kanji conversion status definition
    NONE_YOMI = 1,         // ϤƤʤ
    INPUTING_YOMI,         // ɤߤϤƤ
    CONVERTING_YOMI,       // ɤߤѴƤ
    SHOWING_LIST,          // ѴθɽƤ
    CHANGING_LENGTH,       // ʸĹѹƤ
    //EDITING_SEGMENT,     // Ѵ줿ʸԽƤ
    NUM_OF_CONVSTATUS = 5,
  };
  
  enum FuncID {     // Function name definition
    FID_AppendChar = 0,
    FID_NextCandidacy,
    FID_PreviousCandidacy,
    FID_ConvertAllSegments,
    FID_ConvertCrntSegment,
    FID_DeleteBackward,
    FID_DecideAllSegments,
    FID_DecideCrntSegment,
    FID_CancelConversion,
    FID_LengthenSegment,
    FID_ShortenSegment,
    FID_InputSpaceChar,
    FID_ConvertToHira,
    FID_ConvertToKana,
    FID_ConvertToHankakuEisu,
    FID_ConvertToZenkakuEisu,
    FID_ForwardSegment,
    FID_BackwardSegment,
    FID_ToFirstSegment,
    FID_ToLastSegment,
    FID_SwitchZenkakuEisu,
    FID_ForwardKeyEvent, // ٥Ȥ򥯥饤Ȥ᤹
    FID_None,            // ⤷ʤ
    FID_NumFunctions,
  };

  enum SettingType {
    ST_CURRENT_SETTING = 0,
    ST_MSIME,
    ST_ATOK,
    ST_KINPUT2,
    ST_VJE,
    NUM_SETTING_TYPE,
  };
};

#endif
