#ifndef KANJICONVERT_H
#define KANJICONVERT_H

#include "kimeranamespace.h"
#include "dicthiragana.h"
#include "candidacylistbox.h"
#include "inputmode.h"
#include <qobject.h>
#include <qevent.h>
#include <qstring.h>
#include <qstringlist.h>
#include <qptrlist.h>
#include <qintdict.h>
using namespace Kimera;

class SockKanjiClient;
class CandidacyListBox;
class PreeditArea;
class KanjiConvert;
class FuncPtr;

typedef bool  (KanjiConvert::*pmfunc)();
typedef Kimera::FuncID    FuncIDArray[NUM_OF_CONVSTATUS];


class KanjiConvert : public QObject {
  Q_OBJECT

public:
  KanjiConvert();
  ~KanjiConvert();
  void    init();
  void    clear();
  bool    processKeyEvent(const QKeyEvent&);
  void    setFont(QFont);
  void    setPreeditPoint(QPoint);
  
public slots:
  void    setInputMode(const InputMode&);

signals:
  void    decideSegments(const QString&);

protected slots:
  void    slotConvertSegments(const QStringList&, int idx);
  void    slotCandidacyList(const QStringList&, int idx);
  void    slotYomigana(const QString&, int idx);
  void    slotDecideSegment(QListBoxItem* item);
  void    joinYomiList(int index);

protected:
  bool    convertAllSegments();
  bool    convertCrntSegment();
  bool    nextCandidacy();
  bool    previousCandidacy();
  bool    appendChar(const QKeyEvent&);
  bool    deleteBackward();
  bool    decideAllSegments();
  bool    decideCrntSegment();
  bool    cancelConversion();
  bool    lengthenSegment();
  bool    shortenSegment();
  bool    inputSpaceChar();
  bool    convertToHira();
  bool    convertToKata();
  bool    convertToHankakuEisu();
  bool    convertToZenkakuEisu();
  bool    forwardSegment();
  bool    backwardSegment();
  bool    toFirstSegment();
  bool    toLastSegment();
  bool    switchZenkakuEisu();

  void    showPreeditArea();
  void    syncInputKeysForward(const QString& str);
  void    syncInputKeysBackward(const QString& str);
  void    hideToolBox();

  static void  init_funcptrdict();

private:
  uint                 _crntsegidx;     // current segment index
  uint                 _minsegidx;      // minimum segment index
  QString              _inputkeys;      // input roma string
  QStringList          _yomiseglist;    // yomigana segment list
  QStringList          _convtkanjilist; // kanji string list converted
  ConvStatus           _stat;           // kanji conversion status
  InputMode            _mode;           // input mode
  DictHiragana         _dict;
  SockKanjiClient*     _sockkanjiclt;
  PreeditArea*         _preedit;
  CandidacyListBox*    _candlist;
  
  static QIntDict<FuncPtr>   funcptrdict;  // dictionary of function pointer
};


class FuncPtr {
public:
  explicit FuncPtr(pmfunc p) : _pmf(p) { }
  pmfunc   ptr() const { return _pmf; }

private:  
  pmfunc   _pmf;  // pointer to member function of KanjiConvert class
};

#endif // KANJICONVERT_H
