#ifndef DICTHIRAGANA_H
#define DICTHIRAGANA_H

#include "kimeranamespace.h"
#include "inputmode.h"
#include <qdict.h>
//#include <qstringlist.h>
#include <qstring.h>
#include <qevent.h>

class DictHiragana {
public:
  DictHiragana();
  ~DictHiragana();
  void     init();
  QString  convert(const QKeyEvent& key, const InputMode& mode = InputMode(Kimera::Mode_KanaInput | Kimera::Mode_Hiragana));  // ޻  ߤ Ѵ
//   QStringList convert(const QString& roma, const InputMode& mode = InputMode());           // ޻  ߤ Ѵ
//   QStringList forceConvt(const QString& roma, const InputMode& mode = InputMode());        // ޻  ߤ Ѵ
  QString  convert(const QString& roma, const InputMode& mode = InputMode());           // ޻  ߤ Ѵ
  QString  forceConvt(const QString& roma, const InputMode& mode = InputMode());        // ޻  ߤ Ѵ
  QString  inverseConvt(const QString& hira);    // Ҥ餬  ޻ Ѵ

protected:
  void     initDict(QDict<QString>& dict, const QString&);
  void     initReverseDict(const QDict<QString>& src); // հ
  //   QStringList convertToHira(const QString&);    // Ҥ餬Ѵ
  //   QStringList forceConvtToHira(const QString&);
  //   QStringList convertToKata(const QString&);    // Ѵ
  //   QStringList forceConvtToKata(const QString&);
  //   QStringList convertToZenkakuEisu(const QString&);   // ѱѿѴ
  QString  convertToHira(const QString&);    // Ҥ餬Ѵ
  QString  forceConvtToHira(const QString&);
  QString  convertToKata(const QString&);    // Ѵ
  QString  forceConvtToKata(const QString&);
  QString  convertToZenkakuEisu(const QString&);   // ѱѿѴ
  void writeDictHira() const;
  void writeDictKata() const;
  void writeDictAlphbt() const;
  void writeDictSymbol() const;
  void writeDictKanaInp() const;
  void writeDictDakuten() const;

private:
  QDict<QString>     _dicthira;      // Ҥ餬ʼ
  QDict<QString>     _dictkata;      // ʼ
  QDict<QString>     _dictalphbt;    // ѱѻ
  QDict<QString>     _dictsymbol;    // ѿ漭
  QDict<QString>     _dictkanainp;   // ϼ
  QDict<QString>     _dictdakuten;   // 
  QDict<QString>     _reversedict;   // հ
};

#endif // DICTHIRAGANA_H
