#ifndef CONFIG_H
#define CONFIG_H

#include <qsettings.h>

class Config {
public:
  static QString readEntry(const QString& key, const QString& def=QString::null, bool *ok=0);
  static bool readBoolEntry(const QString& key, bool def=false, bool *ok=0);
  static int  readNumEntry(const QString& key, int def=0, bool *ok=0);
  static bool writeEntry(const QString& key, const QString& value, bool override=true);
  static bool writeEntry(const QString& key, bool value, bool override=true);
  static bool writeEntry(const QString& key, int value, bool override=true);
  
protected:
  static void init();
  
private:
  static QSettings settings;
};

#endif
