#include "config.h"
#include "kimeranamespace.h"
#include <qapplication.h>
#include <qdir.h>
#include <qfile.h>
using namespace Kimera;

QSettings Config::settings(QSettings::Ini);

QString
Config::readEntry(const QString& key, const QString& def, bool *ok)
{
  init();
  return settings.readEntry(KIMERACONF + key, def, ok);
}


bool
Config::readBoolEntry(const QString& key, bool def, bool *ok)
{
  init();
  return settings.readBoolEntry(KIMERACONF + key, def, ok);
}


int
Config::readNumEntry(const QString& key, int def, bool *ok)
{
  init();
  return settings.readNumEntry(KIMERACONF + key, def, ok);
}


bool 
Config::writeEntry(const QString& key, const QString& value, bool override)
{
  init();
  bool res = false;
  if ( override ) {
    res = settings.writeEntry(KIMERACONF + key, value);
  
  } else {
    bool ok;
    readEntry(key, value, &ok);
    if ( !ok )
      res = settings.writeEntry(KIMERACONF + key, value);
  }

  settings.sync();  // Sync
  return res;
}


bool 
Config::writeEntry(const QString& key, bool value, bool override)
{
  init();
  bool res = false;
  if ( override ) {
    res = settings.writeEntry(KIMERACONF + key, value);
  
  } else {
    bool ok;
    readBoolEntry(key, value, &ok);
    if ( !ok )
      res = settings.writeEntry(KIMERACONF + key, value);
  }

  settings.sync();  // Sync
  return res;
}


bool 
Config::writeEntry(const QString& key, int value, bool override)
{
  init();
  bool res = false;
  if ( override ) {
    res = settings.writeEntry(KIMERACONF + key, value);
  
  } else {
    bool ok;
    readNumEntry(key, value, &ok);
    if ( !ok )
      res = settings.writeEntry(KIMERACONF + key, value);
  }

  settings.sync();  // Sync
  return res;
}


void
Config::init()
{
  static bool initdone = FALSE;

  if ( ! initdone ) {
    QString strconfdir = QString(getenv("HOME")) + "/.kimera/";
    QDir confdir(strconfdir);
    
    if ( !confdir.exists() ) {
      confdir.mkdir(confdir.path());
    }
    
    settings.insertSearchPath(QSettings::Unix, confdir.path());
    initdone = TRUE;
  }
}
