#include "candidacylistbox.h"

enum { 
  MAXHEIGHT = 180 
};


CandidacyListBox::CandidacyListBox() 
  : QListBox((QWidget*)0, "candidacylistbox", WStyle_StaysOnTop | WStyle_Customize | WStyle_NoBorder | WStyle_Tool | WX11BypassWM), _crntcandcyidx(0)
{
  
}


void
CandidacyListBox::showList(const QStringList& strs, int crntidx)
{
  Q_ASSERT( !count() );
  resize(0, 0);

  insertStringList(strs);
  _crntcandcyidx = (count() > crntidx) ?  crntidx : count() - 1;
  setCurrentItem(_crntcandcyidx);
  ensureCurrentVisible();

  int w = contentsWidth();
  int h = contentsHeight() + 6;
  w += (h > MAXHEIGHT) ? 22 : 6;
  resize(w, h);

  qDebug("CandidacyListBox w:%d h:%d", w, h);
  show();
}


void
CandidacyListBox::showPreviousCandidacy()
{
  if ( !count() ) {
    Q_ASSERT( count() );
    return;
  }
  
  _crntcandcyidx--;
  _crntcandcyidx = (_crntcandcyidx < 0) ? count() - 1 : _crntcandcyidx;

  setCurrentItem(_crntcandcyidx);
  ensureCurrentVisible(); 
}


void
CandidacyListBox::showNextCandidacy()
{
  if ( !count() ) {
    Q_ASSERT( count() );
    return;
  }
  
  _crntcandcyidx++;
  _crntcandcyidx = (_crntcandcyidx < count()) ? _crntcandcyidx : 0;

  setCurrentItem(_crntcandcyidx);
  ensureCurrentVisible(); 
}


void
CandidacyListBox::hideEvent(QHideEvent *)
{
  clear();
  _crntcandcyidx = 0;
}


void
CandidacyListBox::setFont(const QFont& f)
{
  QListBox::setFont(f);
  
  setMargins(1, 2, 1, 2);
  setFrameStyle( QFrame::Plain | QFrame::Box );
  setLineWidth( 1 );
  setColumnMode( 1 );   // Number of column is 1
  setMaximumHeight( MAXHEIGHT );
  setHScrollBarMode( AlwaysOff );
}
