package org.kikaineko.mock.runner;

import java.io.File;

public class Path {
	public static final int YourProjectBinPath=0;
	public static final int OtherProjectBinPath=1;
	public static final int LibPath=2;
	public static final int JREPath=99;
	private String rawPath;
	private int type;
	public Path(String path,int type)throws InvalidPathException{
		check(path);
		rawPath=path;
		this.type=type;
	}
	
	private void check(String path)throws InvalidPathException{
		if (!((new File(path)).exists())){
			throw new InvalidPathException("Not found your path");
		}
		if(path.endsWith(System.getProperty("file.separator"))){
			throw new InvalidPathException("shoud not endWith file.separator");
		}
	}
	
	public String getRawPath(){
		return rawPath;
	}
	
	public int getType(){
		return type;
	}
}
