/*
 * 쐬F 2005/03/15
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Vector;

import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.sourcescan.Tokenizer;

/**
 * 񂩂҂lɕϊNX <br>
 * ToStringerƋtϊ
 * 
 * @author Masayuki Ioki
 *  
 */
public class ReturnValue {
    private static String kakkoTrim(String s) {
        return s.substring(s.indexOf("(") + 1, s.length() - 1);
    }

    /**
     * @param string
     * @return
     */
    public static int intValue(String s) {
        return Integer.parseInt(kakkoTrim(s));
    }

    /**
     * @param string
     * @return
     */
    public static long longValue(String string) {
        return Long.parseLong(kakkoTrim(string));
    }

    /**
     * @param string
     * @return
     */
    public static float floatValue(String string) {
        return Float.parseFloat(kakkoTrim(string));
    }

    /**
     * @param string
     * @return
     */
    public static double doubleValue(String string) {
        return Double.parseDouble(kakkoTrim(string));
    }

    /**
     * @param string
     * @return
     */
    public static char charValue(String string) {
        return (char) Integer.parseInt(kakkoTrim(string));
    }

    /**
     * @param string
     * @return
     */
    public static String stringValue(String string) {
    	if(string.equals("(0)")){
    		return "0";
    	}
        return (String)getObject(string);
    }

    public static Class getClass(String val) {
        Class c = LangMgn.getPremitClass(val);
        if (c != null)
            return c;
        try {
            c = Class.forName(val);
        } catch (Exception e) {
        }
        return c;
    }

    protected static Object getRupperObject(String clazz, String val) {
        if (clazz.equals("int") || clazz.equals("java.lang.Integer"))
            return new Integer(val);
        else if (clazz.equals("long") || clazz.equals("java.lang.Long"))
            return new Long(val);
        else if (clazz.equals("float") || clazz.equals("java.lang.Float"))
            return new Float(val);
        else if (clazz.equals("double") || clazz.equals("java.lang.Double"))
            return new Double(val);
        else if (clazz.equals("char") || clazz.equals("java.lang.Character")) {
            char c = (char) Integer.parseInt(val);
            return new Character(c);
        } else if (clazz.equals("java.lang.String"))
            return sanit(val);
        else if (clazz.equals("boolean") || clazz.equals("java.lang.Boolean"))
            return new Boolean(val);
        else if (clazz.equals("byte") || clazz.equals("java.lang.Byte"))
            return new Byte(val);
        else if (clazz.equals("short") || clazz.equals("java.lang.Short"))
            return new Short(val);
        else if (clazz.equals("java.lang.Class"))
            return getClass(val);
        return null;
    }

    private static String sanit(String value) {
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < value.length()) {
            char c = value.charAt(index);
            if (c == '@') {
                c = value.charAt(index + 1);
                sb.append(c);
                index++;
            } else {
                sb.append(c);
            }
            index++;
        }
        return sb.toString();
    }

    protected static Object getArray(Class clazz, String val) {
        Class uc = LangMgn.underOneDimentionArray(clazz);
        String[] ss = getSameLevelStrings(val);
        Object os = Array.newInstance(uc, ss.length);
        try {
            for (int i = 0; i < ss.length; i++) {
                if (ss[i].getClass().isArray()) {
                    Array.set(os, i, getArray(uc, ss[i]));
                } else {
                    Array.set(os, i, getObject(ss[i].toString()));
                }
            }
        } catch (Exception e) {
            System.out.println(e);
        }
        return os;
    }

    public static Object getObject(String value) {
        return getObject(value, null);
    }

    /**
     * @param cs
     * @param string
     * @param string2
     * @return
     */
    public static Object getObject(String value, Class[] usedClasses) {
        if (value == null || value.equals("(0)")) {
            return null;
        }
        
        String[] ^ƒl = getTypeAndValue(value);
        String ^ = ^ƒl[0];
        String l = ^ƒl[1];
        
        if(l.equals(KikainekoChar.NULL)){
        	return null;
        }
        
        try {
            Object o = getRupperObject(^, l);
            if (o != null) {
                return o;
            }
            
            Class c = Class.forName(^);
            if (^.startsWith("[")) {
                return getArray(c, l);
            }
            
            o = ObjectCreater.newInstance(c, usedClasses);
            String[] ss = getSameLevelStrings(l);

            Field[] fs = FieldSorter.sortWithOutFinalStaticTrans(o);
            
            AccessibleObject.setAccessible(fs, true);
            for (int i = 0; i < ss.length; i++) {
                if (!Modifier.isFinal(fs[i].getModifiers())) {
                    fs[i].set(o, getObject(ss[i]));
                }
            }
            return o;
        } catch (Exception e) {
        	e.printStackTrace();
        }
        return null;
    }

    /**
     * @param string
     * @return
     */
    public static boolean booleanValue(String string) {
        return kakkoTrim(string).startsWith("true");
    }

    /**
     * @param string
     * @return
     */
    public static byte byteValue(String string) {
        return Byte.parseByte(kakkoTrim(string));
    }

    /**
     * @param string
     * @return
     */
    public static short shortValue(String string) {
        return Short.parseShort(kakkoTrim(string));
    }

    /**
     * @param s
     * @return
     */
    protected static String[] getTypeAndValue(String s) {
        String[] ss = new String[2];
        int ͂߂̂̈ʒu = s.indexOf("(");
        ss[0] = s.substring(0, ͂߂̂̈ʒu);
        String ͂܂̒l = s.substring(͂߂̂̈ʒu);
        int Ō̂̈ʒu = ͂܂̒l.lastIndexOf(")");
        ss[1] = ͂܂̒l.substring(1, Ō̂̈ʒu);
        return ss;
    }

    /**
     * @param s
     * @return
     */
    protected static String[] getSameLevelStrings(String s) {
        String  = String.valueOf(KikainekoChar.FIELD_OPEN);
        String  = String.valueOf(KikainekoChar.FIELD_CLOSE);
        String k\ = KikainekoChar.NULL;

        Vector motoneta = ReturnValue.getƃk\ƂȊOɕ̔z(s);
        int lev = 0;
        Vector vec = new Vector();
        StringBuffer sb = new StringBuffer();
        int index = 0;
        while (index < motoneta.size()) {
            String str = (String) motoneta.get(index);
            if (str.equals()) {
                lev--;
                sb.append(str);
            } else if (str.equals(k\)) {
                sb.append(str);
            } else {
                sb.append(str);
                if (motoneta.get(index + 1).equals()) {
                    sb.append();
                    lev++;
                    index++;
                } else {
                    sb.append();
                    lev--;
                    index++;
                }
            }

            if (lev == 0) {
                vec.add(sb.toString());
                sb = new StringBuffer();
            }
            index++;

        }
        String[] ss = new String[vec.size()];
        for (int i = 0; i < ss.length; i++) {
            ss[i] = (String) vec.get(i);
        }
        return ss;
    }

    /**
     * @param s
     * @return
     */
    protected static Vector getƃk\ƂȊOɕ̔z(String s) {
        String  = String.valueOf(KikainekoChar.FIELD_OPEN);
        String  = String.valueOf(KikainekoChar.FIELD_CLOSE);
        String GXP[v = String.valueOf(KikainekoChar.ESC);
        String k = String.valueOf(KikainekoChar.NULLCHAR);

        Vector v = new Vector();
        Tokenizer t = new Tokenizer(s);
        Token[] tks = t.getTokens();

        StringBuffer sb = new StringBuffer();

        boolean GXP[v = false;
        for (int i = 0; i < tks.length; i++) {
            String str = tks[i].getVal();
            if (!GXP[v) {
                if (str.equals()) {
                    v.add(sb.toString());
                    v.add();
                    sb = new StringBuffer();
                } else if (str.equals()) {
                    if (sb.length() > 0) {
                        v.add(sb.toString());
                    }
                    v.add();
                    sb = new StringBuffer();

                } else {
                    sb.append(str);
                    if (str.equals(GXP[v)) {
                        GXP[v = true;
                    }
                }
            } else {
                sb.append(str);
                if (str.equals(k)) {
                    v.add(sb.toString());
                    sb = new StringBuffer();
                }

                GXP[v = false;
            }
        }
        return v;
    }
}