package org.kikaineko.mock.analysis.innersi;

import org.kikaineko.mock.analysis.ClassNameResolver;
import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class BlockBody {
	public static void run(SharedFields sf) throws Exception {
		TokenArray tokenArray = sf.tokenArray;
		String targetName = sf.targetName;
		ClassNameResolver classNameResolver = sf.classNameResolver;

		while (true) {
			Token t = tokenArray.get(sf.index++);
			String s = t.getVal();
			int kind = t.getKind();
			if (kind == TokenKind.Word && !s.equals(targetName)
					&& isVariable(sf, s)) {

				if (tokenArray.getVal(sf.index).equals(".")) {
					// ܂ł݂ȂƕȂ
					Statement.run(sf, s);
				} else {
					Class c = classNameResolver.getClazz(s);
					Variable.run(sf, c);
				}

			} else if (!s.equals("}")) {
				String cName = isFullName(sf, t);
				if (cName == null) {
					Statement.run(sf, s);
				} else {
					Class c = classNameResolver.getClazz(cName);
					Variable.run(sf, c);
				}
			} else {
				break;
			}
		}
	}

	private static String isFullName(SharedFields sf, Token t) {
		if(t.getKind()!=TokenKind.Word)
			return null;
		StringBuffer sb = new StringBuffer();
		boolean flag = false;
		String s=t.getVal();
		if(s!=null && !s.equals(";"))
			sb.append(s);
		
		for (int i = sf.index; i < sf.tokenArray.length(); i++) {
			int k = sf.tokenArray.getKind(i);
			if (k == TokenKind.Word) {
				if (flag) {
					sf.index = i;
					break;
				} else {
					sb.append(sf.tokenArray.getVal(i));
					flag = true;
				}
			} else if (k == TokenKind.OpenKakko) {
				return null;
			} else if (k == TokenKind.Piriod) {
				sb.append(".");
				flag = false;
			} else {
				return null;
			}
		}
		return sb.toString();
	}

	protected static boolean isVariable(SharedFields sf, String s) {
		return SmallInterpreterSupportor.isVariable(sf.classNameResolver, s);
	}
}
