/*
 * 쐬F 2005/02/04
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.sourcescan;

import java.util.Vector;

import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenKind;

/**
 * g[Nɐ؂oNXB
 * g[N[̓g[NI[g}gɈˑB
 * @author masayuki
 */
public class Tokenizer {
	private String st;

	private int index;

	private TokenAutomaton tokenAutomaton;

	private char lastchar = (char) 0;//xǂݖh~pϐ

	private boolean hasMore = true;

	private Token[] tk;

	/**
	 * @param string
	 */
	public Tokenizer(String string) {
		st = string;
		index = 0;
		tokenAutomaton = new TokenAutomaton();
		if (st.length() == 0)
			hasMore = true;
		
		makeTokens();
		index=0;
	}

	protected Token nextToken() {
		return tk[index++];
	}

	/**
	 * @return
	 */
	protected Token innerNextToken() {
		StringBuffer sb = new StringBuffer();
		if (lastchar != 0)
			sb.append(lastchar);

		for (int i = index; i < st.length(); i++) {
			char c = st.charAt(i);
			boolean flag = tokenAutomaton.isToken(c);

			if (flag) {
				lastchar = c;
				index = i + 1;

				return new Token(tokenAutomaton.getState(), sb.toString());

			} else {
				sb.append(c);
			}
		}

		hasMore = false;
		return new Token(tokenAutomaton.endState(), sb.toString());
	}

	private void makeTokens() {
		Vector vec = new Vector();
		while (hasMore()) {
			vec.add(innerNextToken());
		}
		
		boolean isString = false;
		boolean isChar = false;
		StringBuffer sb = new StringBuffer();
		for (int i = 0; i < vec.size(); i++) {
			Token t = (Token) vec.get(i);
			if (isString) {
				if (t.getKind() == TokenKind.DoubleQ) {
					isString = false;
					if (sb.length() > 0) {
						vec.insertElementAt(new Token(TokenKind.STring, sb
								.toString()), i);
						i++;
						sb = new StringBuffer();
					}
				} else {
					sb.append(t.getVal());
					vec.remove(i);
					i--;
				}
			} else if (isChar) {
				if (t.getKind() == TokenKind.SingleQ) {
					isChar = false;
				} else {
					t.setKind(TokenKind.Char);
				}
			} else {
				if (t.getKind() == TokenKind.DoubleQ) {
					isString = true;
				} else if (t.getKind() == TokenKind.SingleQ) {
					isChar = true;
				} else if (t.getKind() == TokenKind.Kuuhaku) {
					vec.remove(i);
					i--;
				}
			}
		}

		tk = new Token[vec.size()];
		for (int i = 0; i < tk.length; i++) {
			tk[i] = (Token) vec.get(i);
		}
	}

	/**
	 * @return
	 */
	public Token[] getTokens() {

		Token[] tks = new Token[tk.length];
		System.arraycopy(tk, 0, tks, 0, tks.length);
		return tks;
	}

	/**
	 * @return
	 */
	private boolean hasMore() {
		return hasMore;
	}
}