/*
 * Created on 2005/02/18
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.kikaineko.sourcescan;

import java.io.File;

import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;

import junit.framework.TestCase;

/**
 * @author masayuki
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class CodeReaderTest extends TestCase {
	CodeReader cr;
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		cr=new CodeReader(new File("src\\fortest\\TestReaderTestTest.java"));
	}
	
	public void testGetLinesWithoutComment(){
		TokenArray ta=cr.getTokenArrayWithoutComment();

		assertEquals("package",ta.getVal(0));
		assertEquals(false,ta.get(0).isLiteral);
		
		int len=ta.length();
		assertEquals("}",ta.getVal(len-1));
		assertEquals("}",ta.getVal(len-2));
		assertEquals(";",ta.getVal(len-3));
		
	}
	
	public void testGetTokensWithoutComment(){
		Token[] ts=cr.getTokensWithoutComment("\" ad \"/* hoge */ package org.kikaineko.analysis;");
		assertEquals(" ad ",ts[1].getVal());
		assertEquals(true,ts[1].isLiteral);
		assertEquals("package",ts[3].getVal());
		ts=cr.getTokensWithoutComment("package org.kikaineko.analysis;/* hoge */ ");
		assertEquals("package",ts[0].getVal());
		ts=cr.getTokensWithoutComment("package org.kikaineko.analysis/* hoge */;");
		assertEquals("package",ts[0].getVal());
	}
	public void testGetTokensWithoutCommentOpenAndClose(){
		Token[] ts=cr.getTokensWithoutComment("package org.kikaineko./* analysis;");
		assertEquals("package",ts[0].getVal());
		assertEquals(5,ts.length);
		
		ts=cr.getTokensWithoutComment("package \" dafa \"org.kikaineko./* analysis;");
		assertEquals(0,ts.length);
		ts=cr.getTokensWithoutComment("package org.kikaineko.*/ analysis;");
		assertEquals("analysis",ts[0].getVal());
		ts=cr.getTokensWithoutComment("package org.kikaineko./* analysis;");
		ts=cr.getTokensWithoutComment("package org.kikaineko. analysis;*/");
		assertEquals(0,ts.length);
	}
	
	public void testGetTokensWithoutLineComment(){
		Token[] ts=cr.getTokensWithoutComment("package org.kikaineko.//analysis;");
		assertEquals("package",ts[0].getVal());
		assertEquals(5,ts.length);
		ts=cr.getTokensWithoutComment("package org.kikaineko.analysis;");
		assertEquals(7,ts.length);
	}

}
