/*
 * Created on 2005/02/18
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package org.kikaineko.source.util;

import org.kikaineko.sourcescan.Tokenizer;

import junit.framework.TestCase;

/**
 * @author masayuki
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TokenArrayTest extends TestCase {
	TokenArray ta;
	Token[] ts;
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		Tokenizer tkn=new Tokenizer("p=1+2,1");
		ts=tkn.getTokens();
		ta=new TokenArray(ts);
	}
	
	public void test̃RXgN^(){
		TokenArray tokenArray=new TokenArray("p=1+2,1");
		assertEquals(0,tokenArray.howManyOfVal("0"));
		assertEquals(1,tokenArray.howManyOfVal("p"));
	}
	public void test폜ł(){
		assertEquals(7, ta.length());
		ta.deleteThisVal("1");
		assertEquals(0,ta.howManyOfVal("0"));
		assertEquals(1,ta.howManyOfVal("p"));
		assertEquals(0,ta.howManyOfVal("1"));
		assertEquals(5, ta.length());
	}
	public void testHowManyOfVal(){
		assertEquals(0,ta.howManyOfVal("0"));
		assertEquals(1,ta.howManyOfVal("p"));
		assertEquals(2,ta.howManyOfVal("1"));
	}
	
	public void testAddArray(){
		ta=new TokenArray();
		Tokenizer ts1=new Tokenizer("p=1+2,1");
		
		assertEquals(0,ta.length());
		ta.addArray(ts1.getTokens());
		ts1=new Tokenizer("p=1+2,1");
		assertEquals(7,ta.length());
		ta.addArray(ts1.getTokens());
		
		assertEquals(14,ta.length());
		assertEquals("1",ta.getVal(13));
		for(int i=0;i<10;i++){
			ta.addArray(new Tokenizer("p=1+2,1").getTokens());
		}
		assertEquals(84,ta.length());
		assertEquals("1",ta.getVal(13));
		assertEquals("1",ta.getVal(83));
		for(int i=0;i<10;i++){
			ta.addArray(new Tokenizer("p=1+2,1").getTokens());
		}
		assertEquals(154,ta.length());
		assertEquals("1",ta.getVal(13));
		assertEquals("1",ta.getVal(153));
	}
	
	public void testLength(){
		assertEquals(7,ta.length());
	}
	public void testStaticHowManyOfKind(){
		assertEquals(1,TokenArray.howManyOfKind(ts,TokenKind.Word));
		assertEquals(3,TokenArray.howManyOfKind(ts,TokenKind.Number));
	}
	//IndexOfńAftHgŕȂ
	public void testStaticIndexOfKind(){
		assertEquals(0,TokenArray.indexOfKind(ts,TokenKind.Word));
		assertEquals(-1,TokenArray.indexOfKind(ts,TokenKind.Word,2));
	}
	public void testStaticIndexOfVal(){
		assertEquals(0,TokenArray.indexOfVal(ts,"p"));
		assertEquals(-1,TokenArray.indexOfVal(ts,"p",2));
	}
	public void testStaticSubArray(){
		assertEquals(4,TokenArray.subArray(ts,1,5).length);
		assertEquals(6,TokenArray.subArray(ts,1).length);
	}
	public void testStaticRemoveArray(){
		assertEquals(3,TokenArray.removeArray(ts,1,5).length);
		assertEquals("p",TokenArray.removeArray(ts,1,5)[0].getVal());
		assertEquals(",",TokenArray.removeArray(ts,1,5)[1].getVal());
		assertEquals("1",TokenArray.removeArray(ts,1,5)[2].getVal());
		
		assertEquals(1,TokenArray.removeArray(ts,1).length);
	}
	
	public void testIndexOfKind(){
		assertEquals(0,ta.indexOfKind(TokenKind.Word));
		assertEquals(-1,ta.indexOfKind(TokenKind.Star));
		assertEquals(1,ta.indexOfKind(TokenKind.Eq));
		assertEquals(2,ta.indexOfKind(TokenKind.Number));
		
		assertEquals(2,ta.indexOfKind(TokenKind.Number,1));
		assertEquals(2,ta.indexOfKind(TokenKind.Number,2));
		assertEquals(4,ta.indexOfKind(TokenKind.Number,3));
	}
	public void testIndexOfVal(){
		assertEquals(0,ta.indexOfVal("p"));
		assertEquals(2,ta.indexOfVal("1"));
		
		assertEquals(-1,ta.indexOfVal("pi"));
		
		assertEquals(6,ta.indexOfVal("1",4));
	}
	public void testIndexOfVal2(){
		Tokenizer tkn=new Tokenizer("p=1+2,1-n+1k");
		ts=tkn.getTokens();
		ta=new TokenArray(ts);
		assertEquals(0,ta.indexOfVal("p","="));
		assertEquals(6,ta.indexOfVal("1","-"));
		assertEquals(10,ta.indexOfVal("1","k"));
		
		assertEquals(-1,ta.indexOfVal("j","k"));
		assertEquals(-1,ta.indexOfVal("-","k"));
		assertEquals(-1,ta.indexOfVal("k","k"));
		assertEquals(-1,ta.indexOfVal("j","u"));
	}
	
	public void testIndexOfVal3(){
		Tokenizer tkn=new Tokenizer("p=1+2,1-n+1k");
		ts=tkn.getTokens();
		ta=new TokenArray(ts);
		assertEquals(0,ta.indexOfVal("p","=","1"));
		assertEquals(6,ta.indexOfVal("1","-","n"));
		assertEquals(9,ta.indexOfVal("+","1","k"));
		
		assertEquals(-1,ta.indexOfVal("1","k","k"));
		assertEquals(-1,ta.indexOfVal("j","k","l"));
		assertEquals(-1,ta.indexOfVal("p","k","1"));
	}
	
	public void testGet(){
		assertEquals("p",ta.get(0).getVal());
		assertEquals("p",ta.getVal(0));
		assertEquals(false,ta.isLiteral(0));
		assertEquals(TokenKind.Word,ta.getKind(0));
		//ێ̕ۏ
		Token t=ta.get(0);
		t=null;
		assertNull(t);
		assertEquals("p",ta.get(0).getVal());
        //ێ̕ۏ
		ts[0]=null;
		assertNull(ts[0]);
		assertEquals("p",ta.get(0).getVal());
	}
	
	public void testSubArray(){
		TokenArray ta2=ta.subArray(1,5);
		assertEquals(4,ta2.length());
		assertEquals("=",ta2.getVal(0));
		assertEquals("2",ta2.getVal(3));
		
		ta2=ta.subArray(1);
		assertEquals(6,ta2.length());
		assertEquals("=",ta2.getVal(0));
		assertEquals("2",ta2.getVal(3));
		assertEquals("1",ta2.getVal(5));
		
	}
	
	public void testTakeSubArray(){
		assertEquals("p = 1 + 2 , 1 ",ta.toString());
		assertEquals(7,ta.length());
		TokenArray ta2=ta.takeSubArray(1,5);
		assertEquals(4,ta2.length());
		assertEquals(3,ta.length());
		assertEquals("=",ta2.getVal(0));
		assertEquals("2",ta2.getVal(3));
		
		assertEquals("p , 1 ",ta.toString());
		assertEquals("= 1 + 2 ",ta2.toString());
	}
	public void testTakeSubArray2(){
		assertEquals("p = 1 + 2 , 1 ",ta.toString());
		assertEquals(7,ta.length());
		TokenArray ta2=ta.takeSubArray(1);
		assertEquals(6,ta2.length());
		assertEquals(1,ta.length());
		System.out.println(ta);
		System.out.println(ta2);
		assertEquals("p ",ta.toString());
		assertEquals("= 1 + 2 , 1 ",ta2.toString());
		
		
	}
}
