/*
 * 쐬F 2005/03/27
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.source.util;

import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.List;

import junit.framework.TestCase;

/**
 * @author masayuki
 *
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
public class LangMgnTest extends TestCase {

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		//ftHǧꂪJAVAł邩̊mF
		assertEquals(Java.class,LangMgn.getLang().getClass());
		//ꉞZbgł邱Ƃ𖾎邽߂ɃZbg
		LangMgn.setLang(new Java());
	}
	
	public void testGetAbstractMethods(){
	    Method[] ms=LangMgn.getAbstratcMethods(String.class);
	    assertEquals(0,ms.length);
	    ms=LangMgn.getAbstratcMethods(AbstractList.class);
	    assertEquals(1,ms.length);
	    System.out.println(ms[0].getName());
	}
	
	public void testGetClassName(){
	    assertEquals("int",LangMgn.getClassName(int.class));
	    assertEquals("int[]",LangMgn.getClassName(int[].class));
	    assertEquals("java.lang.Object[]",LangMgn.getClassName(Object[].class));
	    assertEquals("java.lang.String[][]",LangMgn.getClassName(String[][].class));
	}
	public void testGetClassByName(){
		assertEquals(int.class,LangMgn.getClassByName("int"));
		assertEquals(void.class,LangMgn.getClassByName("void"));
		assertEquals(Object.class,LangMgn.getClassByName("java.lang.Object"));
		assertEquals(String.class,LangMgn.getClassByName("java.lang.String"));
		assertEquals(String[].class,LangMgn.getClassByName("java.lang.String[]"));
		assertEquals(String[][][].class,LangMgn.getClassByName("java.lang.String[][][]"));
	}
	
	public void testIsConcreteArray(){
	    assertEquals(true,LangMgn.isConcrete(int[].class));
	    assertEquals(true,LangMgn.isConcrete(StringBuffer[][].class));
	    assertEquals(false,LangMgn.isConcrete(List[].class));
	    
	}
	
	public void testIsConst(){
	    assertEquals(true,LangMgn.isConcrete(String.class));
	    assertEquals(true,LangMgn.isConcrete(int.class));
	    assertEquals(false,LangMgn.isConcrete(AbstractList.class));
	}
	
	public void testUnitInArray(){
		assertEquals(int.class,LangMgn.unitTypeInArray(int[].class));
		assertEquals(double.class,LangMgn.unitTypeInArray(double[].class));
		assertEquals(String.class,LangMgn.unitTypeInArray(String[].class));
		assertEquals(StringBuffer.class,LangMgn.unitTypeInArray(StringBuffer[].class));
		assertEquals(int.class,LangMgn.unitTypeInArray(int[][].class));
	}
	
	public void testUnderOneDimentionArray(){
	    assertNull(LangMgn.underOneDimentionArray(int.class));
	    assertEquals(int.class,LangMgn.underOneDimentionArray(int[].class));
	    assertEquals(int[].class,LangMgn.underOneDimentionArray(int[][].class));
	    assertEquals(int[][].class,LangMgn.underOneDimentionArray(int[][][].class));
	    assertEquals(StringBuffer[][].class,LangMgn.underOneDimentionArray(StringBuffer[][][].class));
	    assertEquals(String[].class,LangMgn.underOneDimentionArray(String[][].class));
		
	}
	
	public void testSuffix(){
		assertEquals(".java", LangMgn.getSuffix());
		assertEquals(".class", LangMgn.getBinSuffix());
	}
	
	public void testArrayType(){
		assertEquals("int[]",LangMgn.arrayType(int[].class.getName()));
		assertEquals("float[]",LangMgn.arrayType(float[].class.getName()));
		assertEquals("long[]",LangMgn.arrayType(long[].class.getName()));
		assertEquals("double[]",LangMgn.arrayType(double[].class.getName()));
		assertEquals("char[]",LangMgn.arrayType(char[].class.getName()));
		assertEquals("byte[]",LangMgn.arrayType(byte[].class.getName()));
		assertEquals("short[]",LangMgn.arrayType(short[].class.getName()));
		assertEquals("boolean[]",LangMgn.arrayType(boolean[].class.getName()));
		assertEquals("java.lang.String[]",LangMgn.arrayType(String[].class.getName()));
		assertEquals("java.util.List[]",LangMgn.arrayType(List[].class.getName()));
		
		assertEquals("int[]",LangMgn.arrayType("[I"));
		assertEquals("float[]",LangMgn.arrayType("[F"));
		assertEquals("long[]",LangMgn.arrayType("[J"));
		assertEquals("double[]",LangMgn.arrayType("[D"));
		assertEquals("char[]",LangMgn.arrayType("[C"));
		assertEquals("byte[]",LangMgn.arrayType("[B"));
		assertEquals("short[]",LangMgn.arrayType("[S"));
		assertEquals("boolean[]",LangMgn.arrayType("[Z"));
		assertEquals("java.lang.String[]",LangMgn.arrayType("[Ljava.lang.String;"));
	}
	
	public void testTAJUUArray(){
		assertEquals("int[][][]",LangMgn.arrayType("[[[I"));
	}
	
	public void testGetPackagerSeparator(){
		assertEquals(".",LangMgn.getPackagerSeparator());
	}
	
	public void testg\ꂩǂ(){
		assertTrue(LangMgn.canUseThisReservedWord("try"));
		assertTrue(LangMgn.canUseThisReservedWord("catch"));
		assertTrue(LangMgn.canUseThisReservedWord("super"));

		assertFalse(LangMgn.canUseThisReservedWord("for"));
		assertFalse(LangMgn.canUseThisReservedWord("while"));
		assertFalse(LangMgn.canUseThisReservedWord("if"));
	}
	
	public void test܂gȂ\(){
		assertTrue(LangMgn.cannotUseThisReservedWordNow("switch"));
		assertTrue(LangMgn.cannotUseThisReservedWordNow("this"));
		
		
		//܂ɁA͑ΉȂ낤ǁBBB
		assertTrue(LangMgn.cannotUseThisReservedWordNow("synchronized"));
	}

}
