/*
 * 쐬F 2005/03/09
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.framework;

import junit.framework.TestCase;

import org.kikaineko.source.util.TokenArray;
import org.kikaineko.sourcescan.Tokenizer;


/**
 * @author masayuki
 * 
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎QƁB EBhE  ݒ  Java  R[hEX^C 
 * R[hEev[g
 */
public class ImportTest extends TestCase {
	Import im;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
	}

	public void testGetClassName() {
		Tokenizer tkn = new Tokenizer("import java.lang.String;");
		im = new Import(new TokenArray(tkn.getTokens()));
		assertEquals("String", im.getClassNmae());

		tkn = new Tokenizer("import java.lang.Class;");
		im = new Import(new TokenArray(tkn.getTokens()));
		assertEquals("Class", im.getClassNmae());
	}
	
	public void testGetPackageName() {
		Tokenizer tkn = new Tokenizer("import java.lang.String;");
		im = new Import(new TokenArray(tkn.getTokens()));
		assertEquals("java.lang.", im.getPackageName());

		tkn = new Tokenizer("import org.kikaineko.source.util.TokenArray;");
		im = new Import(new TokenArray(tkn.getTokens()));
		assertEquals("org.kikaineko.source.util.",im.getPackageName());
	}
	
	
	public void testIsInPachage(){
		Tokenizer tkn = new Tokenizer("import java.lang.String;");
		im = new Import(new TokenArray(tkn.getTokens()));
		assertEquals(false, im.isInPackage("junit"));
		assertEquals(true, im.isInPackage("lang"));
	}
	
	public void testAster(){
		Tokenizer tkn = new Tokenizer("import java.lang.*;");
		im = new Import(new TokenArray(tkn.getTokens()));
		assertEquals("java.lang.", im.getPackageName());
	}

}