package org.kikaineko.mock.framework;

import java.io.File;

import org.kikaineko.mock.analysis.Analyst;
import org.kikaineko.mock.analysis.SmallInterpreter;
import org.kikaineko.mock.analysis.TestAnalyst;
import org.kikaineko.sourcescan.CodeReader;
import org.kikaineko.util.IntArray;
import org.kikaineko.util.StringArray;

import junit.framework.TestCase;

public class DestroyMethodSeakerFilterTest extends TestCase {
	DestroyMethodSeakerFilter dmsf;
	VoidDestroyFilter vdf;
	TargetClass target;
    /*
     * @see TestCase#setUp()
     */
	
    protected void setUp() throws Exception {
        super.setUp();
        vdf=new VoidDestroyFilter();
        dmsf=new DestroyMethodSeakerFilter();
        TargetHistory.initialize();
        TargetHistoryTerm.initialize();
    }
    

    public void test܂łȂqXgV{Q(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	
    	IntArray[] ias=dmsf.Ō̃\bhĂяolقȂhitorỹV{̏WԂ(target);
    	assertEquals(1, ias.length);
    	assertEquals(2, ias[0].length());
    	
    	StringArray destroys=new StringArray();
    	IntArray historySymbols=dmsf.܂łȂqXgV{Q(ias[0],destroys);
    	assertEquals(2, historySymbols.length());
    	assertEquals("set();next();", TargetHistory.getTargetHistoryBySymbol(historySymbols.get(0)).toString());
    	assertEquals("set();next();next();", TargetHistory.getTargetHistoryBySymbol(historySymbols.get(1)).toString());
    	
    	
    	destroys.add("set()");
    	historySymbols=dmsf.܂łȂqXgV{Q(ias[0],destroys);
    	assertEquals(2, historySymbols.length());
    	
    	destroys.add("next()");
    	historySymbols=dmsf.܂łȂqXgV{Q(ias[0],destroys);
    	assertEquals(0, historySymbols.length());
    }
    
    public void test܂łȂqXgV{Q_G(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	target.invokingMethod("void", "set2()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.flush();
    	target.invokingMethod("void", "set3()", null, null);
    	target.invokingMethod("void", "set4()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(2)");
    	target.flush();
    	
    	IntArray[] ias=dmsf.Ō̃\bhĂяolقȂhitorỹV{̏WԂ(target);
    	assertEquals(1, ias.length);
    	assertEquals(3, ias[0].length());
    	
    	StringArray destroys=new StringArray();
    	IntArray historySymbols=dmsf.܂łȂqXgV{Q(ias[0],destroys);
    	assertEquals(3, historySymbols.length());
    	assertEquals("set();next();", TargetHistory.getTargetHistoryBySymbol(historySymbols.get(0)).toString());
    	assertEquals("set2();next();", TargetHistory.getTargetHistoryBySymbol(historySymbols.get(1)).toString());
    	assertEquals("set3();set4();next();", TargetHistory.getTargetHistoryBySymbol(historySymbols.get(2)).toString());
    	
    	
    	destroys.add("set()");
    	historySymbols=dmsf.܂łȂqXgV{Q(ias[0],destroys);
    	assertEquals(2, historySymbols.length());
    	
    	destroys.add("set2()");
    	historySymbols=dmsf.܂łȂqXgV{Q(ias[0],destroys);
    	assertEquals(0, historySymbols.length());
    }
    
    public void test܂j󃁃\bhɎw肳ĂȂ̂1w肷(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	
    	IntArray[] ias=dmsf.Ō̃\bhĂяolقȂhitorỹV{̏WԂ(target);
    	assertEquals(1, ias.length);
    	assertEquals(2, ias[0].length());
    	
    	StringArray destroys=new StringArray();
    	IntArray historySymbols=dmsf.܂łȂqXgV{Q(ias[0],destroys);
    	IntArray[] histories = dmsf.qXgV{Q^[̔zɕϊ(historySymbols);
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(1, destroys.length());
    	assertEquals("set()", destroys.get(0));
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(2, destroys.length());
    	assertEquals("next()", destroys.get(1));
    	
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(2, destroys.length());
    }
    public void test܂j󃁃\bhɎw肳ĂȂ̂1w肷_Gȏꍇ(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	target.invokingMethod("void", "set2()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.flush();
    	target.invokingMethod("void", "set3()", null, null);
    	target.invokingMethod("void", "set4()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(2)");
    	target.flush();
    	
    	IntArray[] ias=dmsf.Ō̃\bhĂяolقȂhitorỹV{̏WԂ(target);
    	assertEquals(1, ias.length);
    	assertEquals(3, ias[0].length());
    	
    	StringArray destroys=new StringArray();
    	IntArray historySymbols=dmsf.܂łȂqXgV{Q(ias[0],destroys);
    	IntArray[] histories = dmsf.qXgV{Q^[̔zɕϊ(historySymbols);
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(1, destroys.length());
    	assertEquals("set()", destroys.get(0));
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(2, destroys.length());
    	assertEquals("set2()", destroys.get(1));
    	
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(3, destroys.length());
    	assertEquals("set3()", destroys.get(2));
    	
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(4, destroys.length());
    	assertEquals("next()", destroys.get(3));
    	
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(5, destroys.length());
    	assertEquals("set4()", destroys.get(4));
    	
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(5, destroys.length());
    }
    
    
    public void testÔ͂Ɩ邩(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "aho()", null, null);
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	target.invokingMethod("void", "aho()", null, null);
    	target.invokingMethod("void", "set2()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.flush();
    	target.invokingMethod("void", "aho()", null, null);
    	target.invokingMethod("void", "set3()", null, null);
    	target.invokingMethod("void", "set4()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(2)");
    	target.flush();
    	
    	IntArray[] ias=dmsf.Ō̃\bhĂяolقȂhitorỹV{̏WԂ(target);
    	assertEquals(1, ias.length);
    	assertEquals(3, ias[0].length());
    	
    	StringArray destroys=new StringArray();
    	IntArray historySymbols=dmsf.܂łȂqXgV{Q(ias[0],destroys);
    	IntArray[] histories = dmsf.qXgV{Q^[̔zɕϊ(historySymbols);
    	
    	histories = DestroyMethodSeakerHelper.Ō̌Ăяo͋ʂ̂Ȃ̂ō(histories);
		histories = DestroyMethodSeakerHelper.Őʍ(histories);
		
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(1, destroys.length());
    	assertEquals("set()", destroys.get(0));
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(2, destroys.length());
    	assertEquals("set2()", destroys.get(1));
    	
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(3, destroys.length());
    	assertEquals("set3()", destroys.get(2));
    	
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(4, destroys.length());
    	assertEquals("set4()", destroys.get(3));
    	
    	dmsf.܂j󃁃\bhɎw肳ĂȂ̂1w肷(histories, destroys);
    	assertEquals(4, destroys.length());
    }
    
    
    
    public void testlXȃ\bhǂł݂2(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.invokingMethod("int", "length()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	target.invokingMethod("int", "setLength()", null, null);
    	target.expectValueAtCurrentHistory("int(-1)");
    	target.invokingMethod("int", "length()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.flush();
    	target.invokingMethod("int", "length()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "gg()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	target.invokingMethod("int", "hoge()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "gg()", null, null);
    	target.expectValueAtCurrentHistory("int(10)");
    	target.flush();
    	
    	
    	target = vdf.execute(target);
    	
    	IntArray[] ias=dmsf.Ō̃\bhĂяolقȂhitorỹV{̏WԂ(target);
    	assertEquals(3, ias.length);
    	assertEquals(2, ias[0].length());
    	assertEquals("set();next();",TargetHistory.getTargetHistoryBySymbol(ias[0].get(0)).toString());
    	assertEquals("set();next();next();",TargetHistory.getTargetHistoryBySymbol(ias[0].get(1)).toString());
    	assertEquals(3, ias[1].length());
    	assertEquals("set();next();next();length();",TargetHistory.getTargetHistoryBySymbol(ias[1].get(0)).toString());
    	assertEquals("setLength();length();",TargetHistory.getTargetHistoryBySymbol(ias[1].get(1)).toString());
    	assertEquals("length();",TargetHistory.getTargetHistoryBySymbol(ias[1].get(2)).toString());
    	assertEquals(2, ias[2].length());
    	assertEquals("length();gg();",TargetHistory.getTargetHistoryBySymbol(ias[2].get(0)).toString());
    	assertEquals("hoge();gg();",TargetHistory.getTargetHistoryBySymbol(ias[2].get(1)).toString());
    	
    	target = dmsf.seaking(target);

    	assertEquals("set()", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));
    	assertEquals("next()", target.getMethodName(1));
    	assertEquals(true, target.isDestoryMethod(1));
    	assertEquals("length()", target.getMethodName(2));
    	assertEquals(true, target.isDestoryMethod(2));
    	assertEquals("setLength()", target.getMethodName(3));
    	assertEquals(true, target.isDestoryMethod(3));
    	assertEquals("gg()", target.getMethodName(4));
    	assertEquals(false, target.isDestoryMethod(4));
    	assertEquals("hoge()", target.getMethodName(5));
    	assertEquals(false, target.isDestoryMethod(5));
    	
    	
    	
    }
    public void testlXȃ\bhǂł݂(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.invokingMethod("int", "length()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	target.invokingMethod("void", "setLength()", null, null);
    	target.invokingMethod("int", "length()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.flush();
    	target.invokingMethod("int", "length()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "gg()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	target.invokingMethod("int", "hoge()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "gg()", null, null);
    	target.expectValueAtCurrentHistory("int(10)");
    	target.flush();
    	target.invokingMethod("void", "a()", null, null);
    	target.invokingMethod("void", "b()", null, null);
    	target.invokingMethod("void", "c()", null, null);
    	target.invokingMethod("void", "d()", null, null);
    	target.invokingMethod("int", "toI2()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	target.invokingMethod("void", "a()", null, null);
    	target.invokingMethod("void", "b()", null, null);
    	target.invokingMethod("void", "c()", null, null);
    	target.invokingMethod("void", "d()", null, null);
    	target.invokingMethod("int", "toI()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.invokingMethod("int", "toI()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.invokingMethod("int", "toI2()", null, null);
    	target.expectValueAtCurrentHistory("int(2)");
    	target.flush();
    	
    	
    	assertEquals(12, target.howManyMethods());
    	assertEquals(12, target.howManyHistories());
    	
    	target=vdf.execute(target);
    	
    	
    	IntArray[] ias=dmsf.Ō̃\bhĂяolقȂhitorỹV{̏WԂ(target);
    	assertEquals(4, ias.length);
    	assertEquals(2, ias[0].length());
    	assertEquals("set();next();",TargetHistory.getTargetHistoryBySymbol(ias[0].get(0)).toString());
    	assertEquals("set();next();next();",TargetHistory.getTargetHistoryBySymbol(ias[0].get(1)).toString());
    	assertEquals(3, ias[1].length());
    	assertEquals("set();next();next();length();",TargetHistory.getTargetHistoryBySymbol(ias[1].get(0)).toString());
    	assertEquals("setLength();length();",TargetHistory.getTargetHistoryBySymbol(ias[1].get(1)).toString());
    	assertEquals("length();",TargetHistory.getTargetHistoryBySymbol(ias[1].get(2)).toString());
    	assertEquals(2, ias[2].length());
    	assertEquals("length();gg();",TargetHistory.getTargetHistoryBySymbol(ias[2].get(0)).toString());
    	assertEquals("hoge();gg();",TargetHistory.getTargetHistoryBySymbol(ias[2].get(1)).toString());
    	assertEquals(2, ias[3].length());
    	assertEquals("a();b();c();d();toI2();",TargetHistory.getTargetHistoryBySymbol(ias[3].get(0)).toString());
    	assertEquals("a();b();c();d();toI();toI();toI2();",TargetHistory.getTargetHistoryBySymbol(ias[3].get(1)).toString());
    	
    	target = dmsf.seaking(target);

    	assertEquals("set()", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));
    	assertEquals("next()", target.getMethodName(1));
    	assertEquals(true, target.isDestoryMethod(1));
    	assertEquals("length()", target.getMethodName(2));
    	assertEquals(true, target.isDestoryMethod(2));
    	assertEquals("setLength()", target.getMethodName(3));
    	assertEquals(true, target.isDestoryMethod(3));
    	assertEquals("gg()", target.getMethodName(4));
    	assertEquals(false, target.isDestoryMethod(4));
    	assertEquals("hoge()", target.getMethodName(5));
    	assertEquals(false, target.isDestoryMethod(5));
    	
    	assertEquals("a()", target.getMethodName(6));
    	assertEquals(true, target.isDestoryMethod(6));
    	assertEquals("b()", target.getMethodName(7));
    	assertEquals(true, target.isDestoryMethod(7));
    	assertEquals("c()", target.getMethodName(8));
    	assertEquals(true, target.isDestoryMethod(8));
    	assertEquals("d()", target.getMethodName(9));
    	assertEquals(true, target.isDestoryMethod(9));
    	
    	assertEquals("toI2()", target.getMethodName(10));
    	assertEquals(false, target.isDestoryMethod(10));
    	assertEquals("toI()", target.getMethodName(11));
    	assertEquals(true, target.isDestoryMethod(11));
    	
    	//\bhIɁAj󃁃\bhɌ邪
    	//qXg[͔j󃁃\bhłKRȂ߁Aj󃁃\bhƎvĂ܂
    	assertEquals("length()", target.getMethodName(2));
    	assertEquals(true, target.isDestoryMethod(2));
    }
    
    
    public void testVoid\bh() {
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "hoge()", null, null);
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target=vdf.execute(target);
    	target = dmsf.seaking(target);
    	assertEquals(2, target.howManyMethods());
    	
    	assertEquals("hoge()", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));
    	assertEquals("get()", target.getMethodName(1));
    	assertEquals(false, target.isDestoryMethod(1));
    	
    }
    public void testd\bhĂяoĂ邩() {
    	target=new TargetClass("Calc", "cl");
    	Object[] args={"0"};
    	target.invokingMethod("int", "hoge(String )", null,args);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	
    	target.flush();
    	Object[] args2={"1"};
    	target.invokingMethod("int", "hoge(String )", null,args2);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	
    	assertEquals(4, target.howManyHistories());
    	
    	IntArray[] ias=dmsf.Ō̃\bhĂяolقȂhitorỹV{̏WԂ(target);
    	assertEquals(1, ias.length);//dg
    	assertEquals(2, ias[0].length());//̑gȂɃqXg[2AIntArrayɂ̓V{lĂ
    	assertEquals("hoge(String )(java.lang.String(0) );get();", TargetHistory.getTargetHistoryBySymbol(ias[0].get(0)).toString());
    	assertEquals("hoge(String )(java.lang.String(1) );get();", TargetHistory.getTargetHistoryBySymbol(ias[0].get(1)).toString());
    }
    
    public void testVoid\bhŎꍇ_قȂ(){
    	target=new TargetClass("Calc", "cl");
    	Object[] args={"0"};
    	target.invokingMethod("void", "set(String )",null, args);
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	
    	Object[] args2={"1"};
    	target.invokingMethod("void", "set(String )",null, args2);
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.flush();
    	assertEquals(2, target.howManyMethods());
    	assertEquals(2, target.howManyHistories());
    	
    	target=vdf.execute(target);
    	target = dmsf.seaking(target);
    	
    	assertEquals("set(String )", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));
    	assertEquals("get()", target.getMethodName(1));
    	assertEquals(false, target.isDestoryMethod(1));
    }
    public void testVoid\bhŎꍇ_Ă΂񐔂Ⴄ(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.flush();
    	assertEquals(2, target.howManyMethods());
    	assertEquals(2, target.howManyHistories());
    	
    	target=vdf.execute(target);
    	target = dmsf.seaking(target);
    	
    	assertEquals("set()", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));
    	assertEquals("get()", target.getMethodName(1));
    	assertEquals(false, target.isDestoryMethod(1));
    }
    public void testVoid\bhŎꍇ_Ă΂鏇Ⴄ(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "setA()", null, null);
    	target.invokingMethod("void", "setB()", null, null);
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.flush();
    	
    	target.invokingMethod("void", "setB()", null, null);
    	target.invokingMethod("void", "setA()", null, null);
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.flush();
    	assertEquals(3, target.howManyMethods());
    	assertEquals(2, target.howManyHistories());
    	
    	target=vdf.execute(target);
    	
    	target = dmsf.seaking(target);
    	
    	assertEquals("setA()", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));
    	assertEquals("setB()", target.getMethodName(1));
    	assertEquals(true, target.isDestoryMethod(1));
    	assertEquals("get()", target.getMethodName(2));
    	assertEquals(false, target.isDestoryMethod(2));
    }
    public void testVoid\bhł͎ʏꍇ_擪Ӗȏꍇ(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("int", "hogeI()", null, null);
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	
    	assertEquals(3, target.howManyMethods());
    	assertEquals(2, target.howManyHistories());
    	
    	target=vdf.execute(target);
    	target = dmsf.seaking(target);
    	
    	assertEquals("hogeI()", target.getMethodName(0));
    	assertEquals(false, target.isDestoryMethod(0));
    	assertEquals("set()", target.getMethodName(1));
    	assertEquals(true, target.isDestoryMethod(1));
    	assertEquals("next()", target.getMethodName(2));
    	assertEquals(true, target.isDestoryMethod(2));
    }
    public void testVoid\bhł͎ʏꍇ(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	
    	assertEquals(2, target.howManyMethods());
    	assertEquals(2, target.howManyHistories());
    	
    	target=vdf.execute(target);    	
    	target = dmsf.seaking(target);
    	
    	assertEquals("set()", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));
    	assertEquals("next()", target.getMethodName(1));
    	assertEquals(true, target.isDestoryMethod(1));
    }
    public void testVoid\bhł͎ʏꍇ_Ăяoꍇ(){
    	target=new TargetClass("Calc", "cl");
    	target.invokingMethod("void", "set()", null, null);
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(2)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(3)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(4)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(5)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(6)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(7)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(8)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(9)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(10)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(11)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(12)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(13)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(14)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(15)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(16)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(17)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(18)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(19)");
    	target.invokingMethod("int", "next()", null, null);
    	target.expectValueAtCurrentHistory("int(20)");
    	
    	assertEquals(2, target.howManyMethods());
    	assertEquals(21, target.howManyHistories());
    	
    	target=vdf.execute(target);
    	target = dmsf.seaking(target);
    	
    	assertEquals("set()", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));
    	assertEquals("next()", target.getMethodName(1));
    	assertEquals(true, target.isDestoryMethod(1));
    }
    
	
    public void testVoid\bhȂĂ() {
    	target=new TargetClass("Calc", "cl");
    	Object[] args={"0"};
    	target.invokingMethod("int", "hoge(String )",null, args);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(0)");
    	
    	target.flush();
    	Object[] args2={"1"};
    	target.invokingMethod("int", "hoge(String )", null,args2);
    	target.expectValueAtCurrentHistory("int(0)");
    	target.invokingMethod("int", "get()", null, null);
    	target.expectValueAtCurrentHistory("int(1)");
    	
    	assertEquals(4, target.howManyHistories());
    	
    	target = dmsf.seaking(target);
    	assertEquals(2, target.howManyMethods());
    	assertEquals("hoge(String )", target.getMethodName(0));
    	assertEquals(true, target.isDestoryMethod(0));

    	
    }
    
	public void testۂɒPȃQb^[Zb^[݂Ă݂() {
		Analyst mi = null;
		try {
			Analyst ta = new TestAnalyst(
					new CodeReader(
							new File(
									"src\\fortest\\beyondthetest\\SimpleSetterGetterTest.java"))
							.getTokenArrayWithoutComment());
			ta.analyze();
			mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
			mi.analyze();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
		target = mi.getTargetClass();
		assertEquals(3, target.howManyMethods());
		assertEquals("SimpleSetterGetter()", target.getMethodName(0));
		assertEquals(false, target.isDestoryMethod(0));
		assertEquals("set(int )", target.getMethodName(1));
		assertEquals("void", target.getReturnType(1));
		assertEquals(false, target.isDestoryMethod(1));
		assertEquals("get()", target.getMethodName(2));
		assertEquals("int", target.getReturnType(2));
		assertEquals(false, target.isDestoryMethod(2));
		
		target=vdf.execute(target);
		target=dmsf.seaking(target);
		
		assertEquals("SimpleSetterGetter()", target.getMethodName(0));
		assertEquals(false, target.isDestoryMethod(0));
		assertEquals(3, target.howManyMethods());
		assertEquals("set(int )", target.getMethodName(1));
		assertEquals(true, target.isDestoryMethod(1));
		assertEquals("get()", target.getMethodName(2));
		assertEquals("int", target.getReturnType(2));
		assertEquals(false, target.isDestoryMethod(2));
		
	}
}
