package org.kikaineko.mock.analysis.innersi;

import java.util.Stack;

import org.kikaineko.mock.analysis.SmallInterpreterSupportor;
import org.kikaineko.mock.analysis.VariableTable;
import org.kikaineko.mock.analysis.exception.CannotUseThisTokenException;
import org.kikaineko.mock.analysis.exception.MaybeCannotCompileException;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.source.util.Token;
import org.kikaineko.source.util.TokenArray;
import org.kikaineko.source.util.TokenKind;

public class Statement {
	public static void run(SharedFields sf, String s) throws Exception {
		VariableTable vt = sf.vt;
		Stack valueStack = sf.valueStack;
		String targetName = sf.targetName;

		TokenArray tokenArray = sf.tokenArray;
		
		if (vt.include(s) || isVariable(sf, s)) {
			if (sf.target.getRawUndefinedValues().containsKey(s)) {
				TargetInvoke.run(sf, (TargetClass) vt.getVal(s));
			} else {
				CallingVariable.run(sf, s);
			}
		} else if (s.equals("{")) {
			Block.run(sf);
		} else if (s.equals("++")) {
			// Ou++
			Token t = tokenArray.getToken(sf.index++);
			VariableOrClassPush.run(sf, t.getVal());
			Object o = valueStack.pop();
			Object ro = SmallInterpreterSupportor.getIncOrDec(o, "+");
			vt.setVal(t.getVal(), ro);
			valueStack.push(ro);
		} else if (s.equals("--")) {
			// Ou--
			Token t = tokenArray.getToken(sf.index++);
			VariableOrClassPush.run(sf, t.getVal());
			Object o = valueStack.pop();
			Object ro = SmallInterpreterSupportor.getIncOrDec(o, "-");
			vt.setVal(t.getVal(), ro);
			valueStack.push(ro);
		} else if (s.equals("assertEquals")) {
			assertEq(sf);
		} else if (s.equals("assertTrue")) {
			assertTr(sf);
		} else if (s.equals("assertFalse")) {
			assertFl(sf);
		} else if (s.equals("assertNull")) {
			assertNl(sf);
		} else if (s.equals(targetName)) {
			TargetInvoke.run(sf, sf.target);
		} else if (s.equals("try")) {
			TryCatch.run(sf);
			if (tokenArray.getVal(sf.index).equals("finally")) {
				sf.index++;
				Block.run(sf);
				// tryJbRn܂悤ɌďĂ̂ŁAň߂B
				sf.index--;
			}
		} else if (s.equals("catch")) {
			IgnoreCatch.run(sf);
		} else if (s.equals("finally")) {
			sf.index++;
			Block.run(sf);
		} else if (s.equals("super")) {
			sf.index = tokenArray.indexOfVal(";", sf.index);
			sf.index++;
		} else if (s.equals("if")) {
			IfBlock.run(sf);
		} else if (s.equals("for")) {
			ForBlock.run(sf);
		} else if (s.equals("while")) {
			WhileBlock.run(sf);
		} else if (s.equals("break")) {
			Break.run(sf);
		} else if (s.equals("do")) {
			DoWhile.run(sf);
		} else if (s.equals("continue")) {
			Continue.run(sf);
		} else if (LangMgn.cannotUseThisReservedWordNow(s)) {
			throw new CannotUseThisTokenException(tokenArray.getToken(sf.index)
					.getLineNo(), s);
		} else if (tokenArray.getKind(sf.index - 1) == TokenKind.Word) {
			Token t = tokenArray.getToken(sf.index - 1);
			throw new MaybeCannotCompileException(t.getLineNo(), t.getVal());
		}
	}
	

	protected static boolean isVariable(SharedFields sf, String s) {
		return SmallInterpreterSupportor.isVariable(sf.classNameResolver, s);
	}

	private static void assertEq(SharedFields sf) throws Exception {
		AssertEquals.run(sf);
	}

	private static void assertTr(SharedFields sf) throws Exception {
		AssertHelper.assertTr(sf);
		AssertEquals.runActual(sf);
	}

	private static void assertFl(SharedFields sf) throws Exception {
		AssertHelper.assertFl(sf);
		AssertEquals.runActual(sf);
	}

	private static void assertNl(SharedFields sf) throws Exception {
		AssertHelper.assertNl(sf);
		AssertEquals.runActual(sf);
	}
}
