/*
 * 쐬F 2005/03/09
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.analysis;

import java.io.File;
import java.lang.reflect.Array;

import junit.framework.TestCase;


import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.util.ToStringer;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;




/**
 * TasuTest.java͂eXg
 * ɕϐ\̊mFB
 * 
 * @author Masayuki Ioki
 *
 */
public class SmallInterpreterTest extends TestCase {
	SmallInterpreter mi;

	VariableTable vt;

	TargetClass target;

	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\TasuTest.java")).getTokenArrayWithoutComment());
		ta.analyze();
		
		
		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(0);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();
	}
	
	/**
	 * 
	 */
	public void testLXg(){
		assertEquals(long.class, vt.getType("l1"));
		//l1long^Aۂ̒lint^̃LXgŒ`ꂽlB
		//ϐ\Ɋi[Ă^B
		//̎dlł̂IH
		assertEquals(Integer.class,vt.getVal("l1").getClass());
		assertEquals(new Integer(-3), vt.getVal("l1"));
	}
	
	/**
	 * 
	 */
	public void testtB[hɃANZXł邩(){
		assertEquals(int.class, vt.getType("ii7"));
		assertEquals(Integer.class,vt.getVal("ii7").getClass());
		assertEquals(new Integer(10), vt.getVal("ii7"));
		
		assertEquals(int.class, vt.getType("ii8"));
		assertEquals(Integer.class,vt.getVal("ii8").getClass());
		assertEquals(new Integer(1), vt.getVal("ii8"));
	}
	/**
	 * 
	 */
	public void testStatic\bhɃANZXł邩(){
		assertEquals(String.class, vt.getType("ssss1"));
		assertEquals("aho", vt.getVal("ssss1"));
		
	}
	
	/**
	 * Nulll擾łĂ邩̃eXg
	 *
	 */
	public void testNull(){
		assertEquals(null,vt.getVal("s2"));
		assertEquals(String.class,vt.getType("s2"));
		assertEquals("ho",vt.getValToString("s3"));
		assertEquals(String.class,vt.getType("s3"));
		assertEquals(null,vt.getVal("s4"));
		assertEquals(String.class,vt.getType("s4"));
		
		assertEquals(String.class,vt.getType("sKara"));
		assertEquals("",vt.getVal("sKara"));
	}
	
	/**
	 * \bhĂ΂Ă邩̃eXg
	 *
	 */
	public void testMethodInvoke(){
		assertEquals("10",vt.getValToString("iii7"));
		assertEquals(int.class,vt.getType("iii7"));
	}
	
	/**
	 * ++A--̃eXg
	 *
	 */
	public void testIncreDecre(){
		assertEquals("2", vt.getValToString("iii2"));
		assertEquals("1", vt.getValToString("iii3"));
		assertEquals("1", vt.getValToString("iii4"));
		assertEquals("2", vt.getValToString("iii5"));
		
		assertEquals("11", vt.getValToString("iii10"));
		assertEquals("8", vt.getValToString("iii11"));
		assertEquals("8", vt.getValToString("iii12"));
	}
	
	/**
	 * z̃eXg
	 *
	 */
	public void testArray(){
		assertEquals(true,vt.include("iis"));
		assertEquals(int[].class,vt.getType("iis"));
		assertEquals("1",Array.get(vt.getVal("iis"),0).toString());
		assertEquals("aho",Array.get(vt.getVal("sss1"),0).toString());
		assertEquals(int.class, vt.getType("iii1"));
		assertEquals("1", vt.getValToString("iii1"));
		assertEquals("3",Array.get(vt.getVal("iis2"),2).toString());
		assertEquals("s3",Array.get(vt.getVal("sss2"),2).toString());
		assertEquals("[Ljava.lang.Object;(java.lang.String(s1)java.lang.String(s2)java.lang.String(s3))", ToStringer.getStrick(vt.getVal("sss2"),null));
		
		assertEquals("java.lang.Integer(101)", ToStringer.getStrick(vt.getVal("iii13"),null));
		
	}
	
	
	public void testTarget() {
		assertEquals("hoge(int )", target.getMethodName(0));
		assertEquals("hoge()", target.getMethodName(1));
		assertEquals("hoge(int int )", target.getMethodName(2));
		assertEquals("Tasu()", target.getMethodName(3));
		assertEquals("add(int int )", target.getMethodName(4));
		assertEquals(5,target.howManyMethods());
		assertEquals("hoge(int )(int(1) );hoge();hoge(int int )(int(2) int(3) );Tasu();add(int int )(int(1) int(100) );",
				mi.sf.target.getCurrentHistoryAsString());
		assertEquals(1,target.howManyHistories());
		assertEquals("hoge(int )(int(1) );hoge();hoge(int int )(int(2) int(3) );Tasu();add(int int )(int(1) int(100) );",target.getHistoryAsRawString(0));
		assertEquals("int(101)",target.getValueAtHistory(0));
		assertEquals("int",target.getReturnType(4));
	}
	
	
	public void testMethod() {
		assertEquals("123", vt.getValToString("ss2"));
		assertEquals("3", vt.getValToString("i7"));
		assertEquals("2", vt.getValToString("i8"));
		assertEquals("2", vt.getValToString("i9"));
		assertEquals("56", vt.getValToString("ss4"));
		assertEquals("10", vt.getValToString("in"));
		assertEquals(Integer.class, vt.getType("in"));
		assertEquals(new Integer(10), vt.getVal("in"));
		assertEquals("0", vt.getValToString("i10"));
		assertEquals("0", vt.getValToString("in3"));
		assertEquals(Integer.class, vt.getType("in3"));
		assertEquals("234", vt.getValToString("ss6"));
	}

	public void testConst() {
		assertEquals("1", vt.getValToString("sb"));
		assertEquals("ab", vt.getValToString("sb2"));
	}
	
	/**
	 * ϐ\̃eXg
	 *
	 */
	public void testVtable() {
		assertEquals(true, vt.include("i"));
		assertEquals("1", vt.getValToString("i"));
		assertEquals(int.class, vt.getType("i"));
		assertEquals("100", vt.getValToString("j"));
		assertEquals("20", vt.getValToString("hoge"));
		assertEquals("5", vt.getValToString("a"));
		assertEquals("8", vt.getValToString("k"));
		assertEquals("12", vt.getValToString("l"));
		assertEquals("25", vt.getValToString("m"));
		assertEquals("61", vt.getValToString("n"));
		assertEquals("2", vt.getValToString("o"));
		assertEquals("-1", vt.getValToString("p"));
		assertEquals("-19", vt.getValToString("q"));
		assertEquals("800", vt.getValToString("r"));
		assertEquals("12", vt.getValToString("s"));
		assertEquals("16", vt.getValToString("t"));
		assertEquals("20", vt.getValToString("u"));
		assertEquals("aho", vt.getValToString("ss"));
		assertEquals("ahohoge", vt.getValToString("s1"));
		assertEquals("10", vt.getValToString("v"));
		assertEquals("-1", vt.getValToString("w"));
		assertEquals("100", vt.getValToString("x"));
		assertEquals("1", vt.getValToString("la"));
		assertEquals(long.class, vt.getType("la"));
		assertEquals("100000000000000000", vt.getValToString("lb"));
		assertEquals("100000000000000001", vt.getValToString("lc"));
		assertEquals("1.0", vt.getValToString("da"));
		assertEquals("2.0", vt.getValToString("db"));
		assertEquals("3.0", vt.getValToString("dc"));
		assertEquals("3.0", vt.getValToString("dd"));
		assertEquals("3.0", vt.getValToString("de"));
		assertEquals("1", vt.getValToString("f1"));
		assertEquals(float.class,vt.getType("f1"));
		//assertTrue(vt.getVal("f1") instanceof Float);
		assertEquals("2.0", vt.getValToString("f2"));
		assertEquals("3.0", vt.getValToString("f3"));
		assertEquals("4.0", vt.getValToString("f4"));
		assertEquals("3.0", vt.getValToString("f5"));

		assertEquals("a", vt.getValToString("c1"));
		assertEquals("2", vt.getValToString("c2"));

		assertEquals("ahoge", vt.getValToString("ss1"));

		assertEquals("true", vt.getValToString("b1"));
		assertEquals("false", vt.getValToString("b2"));
		assertEquals("false", vt.getValToString("b3"));

		assertEquals("10", vt.getValToString("i5"));

		assertEquals("10", vt.getValToString("fff"));
		
		
		//z͌őΉ
		//assertEquals(int[][].class, vt.getType("ia2"));
		//assertEquals(int[][][].class, vt.getType("ia3"));
		
		assertEquals("-1000.0", vt.getValToString("ddd"));
		assertEquals("1000.0", vt.getValToString("dddd"));
		assertEquals("aho100", vt.getValToString("sss"));
		assertEquals("0", vt.getValToString("iii"));
		
		assertEquals("0", vt.getValToString("xx"));
		
		assertEquals(int.class, vt.getType("ii1"));
		assertEquals(Integer.class,vt.getVal("ii1").getClass());
		assertEquals(new Integer((int)2), vt.getVal("ii1"));
		
		assertEquals("a1", vt.getVal("ssb"));
		
		assertEquals(Class.class, vt.getType("aho"));
		assertEquals(int.class, vt.getVal("aho"));

		assertEquals("0.1", vt.getValToString("dd1"));
		assertEquals(double.class, vt.getType("dd1"));
		assertEquals("0.111", vt.getValToString("ffff1"));
		assertEquals(float.class, vt.getType("ffff1"));
		
		
	}
	
	public void test܂Ƃ߂̂͐̂(){
		assertEquals(new Integer((int)-3), vt.getVal("ii6"));
	}
	
	public void testċAZ͐̂(){
//		+=͂
		assertEquals(int.class, vt.getType("ii2"));
		assertEquals(Integer.class,vt.getVal("ii2").getClass());
		assertEquals(new Integer((int)20), vt.getVal("ii2"));
		
		//*=͂
		assertEquals(int.class, vt.getType("ii3"));
		assertEquals(Integer.class,vt.getVal("ii3").getClass());
		assertEquals(new Integer((int)100), vt.getVal("ii3"));
		
		//-=
		assertEquals(int.class, vt.getType("ii4"));
		assertEquals(Integer.class,vt.getVal("ii4").getClass());
		assertEquals(new Integer((int)-70), vt.getVal("ii4"));
		
		// /=
		assertEquals(int.class, vt.getType("ii5"));
		assertEquals(Integer.class,vt.getVal("ii5").getClass());
		assertEquals(new Integer((int)-13), vt.getVal("ii5"));
		
	}
	
	public void testoCgƃV[g(){

		assertEquals(byte.class, vt.getType("b"));
		assertEquals(Byte.class,vt.getVal("b").getClass());
		assertEquals(new Byte((byte)2), vt.getVal("b"));
		
		assertEquals(byte.class, vt.getType("bb2"));
		assertEquals(Byte.class,vt.getVal("bb2").getClass());
		assertEquals(new Byte((byte)-2), vt.getVal("bb2"));	
		
		assertEquals(byte.class, vt.getType("bb3"));
		assertEquals(Byte.class,vt.getVal("bb3").getClass());
		assertEquals(new Byte((byte)2), vt.getVal("bb3"));	
		
		assertEquals(short.class, vt.getType("short1"));
		assertEquals(Short.class,vt.getVal("short1").getClass());
		assertEquals(new Short((short)1), vt.getVal("short1"));
		
		assertEquals(short.class, vt.getType("short2"));
		assertEquals(Short.class,vt.getVal("short2").getClass());
		assertEquals(new Short((short)-1), vt.getVal("short2"));
		
		assertEquals(short.class, vt.getType("short3"));
		assertEquals(Short.class,vt.getVal("short3").getClass());
		assertEquals(new Short((short)-2), vt.getVal("short3"));
		
	}
	
	/**
	 * ubÑx̃eXg
	 *
	 */
	public void testLevel() {
		assertEquals(2, vt.getLevle("i5"));
		assertEquals(1, vt.getLevle("sss"));
		assertEquals(3, vt.getLevle("i6"));
	}
	
	/**
	 * ϐĂ邩̃eXg
	 *
	 */
	public void testIsVariable() {
		assertEquals(true, mi.isVariable("int"));
		assertEquals(true, mi.isVariable("String"));
		assertEquals(true, mi.isVariable("TestCase"));
		assertEquals(false, mi.isVariable("Calc2"));
		assertEquals(false, mi.isVariable("dorararara"));
	}

}