package org.kikaineko.mock.analysis;

import java.io.File;

import org.kikaineko.mock.analysis.exception.UndefinedValueException;
import org.kikaineko.mock.framework.FilterMgn;
import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.mock.framework.UndefinedValue;
import org.kikaineko.mock.textui.MockMaker;
import org.kikaineko.sourcescan.CodeReader;
import org.kikaineko.util.FileIO;

import junit.framework.TestCase;

public class SmallInterpreterForUndefUserTest extends TestCase {
	TargetClass target;

	public void testslcĐł邩() throws Exception {
		Analyst mi = null;
		try {
			Analyst ta = new TestAnalyst(new CodeReader(new File(
					"src\\fortest\\undef\\UndefClassUserTest.java"))
					.getTokenArrayWithoutComment());
			ta.analyze();
			mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
			mi.analyze();
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
		target = mi.getTargetClass();
		assertTrue(target.hasUndefValue());
		UndefinedValue[] us = target.getUndefValues();
		assertEquals(1, us.length);
		UndefinedValue uv = us[0];
		assertEquals(2, uv.howManyHistories());
		assertEquals("gg();hoge();", uv.getHistoryAsRawString(0));
		assertEquals("gg();gg();hoge();", uv.getHistoryAsRawString(1));
	}
	
	public void testslƃLXgƔ() throws Exception {
		Analyst mi = null;
		try {
			Analyst ta = new TestAnalyst(new CodeReader(new File(
					"src\\fortest\\cast\\UndefUserUserTest.java"))
					.getTokenArrayWithoutComment());
			ta.analyze();
			mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
			mi.analyze();
			target = mi.getTargetClass();
			target=FilterMgn.doFilter(target);
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
		
		assertTrue(target.hasUndefValue());
		assertEquals(3, target.howManyMethods());
		UndefinedValue[] us = target.getUndefValues();
		assertEquals(1, us.length);
		UndefinedValue u0=us[0];
		UndefinedValue[] us2 = u0.getUndefValues();
		assertEquals(0, us2.length);
		assertEquals(1, u0.howManyHistories());
		assertEquals("java.lang.String(a)", u0.getValueAtHistory(0));
	}
	public void testslsl𐶐邩() throws Exception {
		Analyst mi = null;
		try {
			Analyst ta = new TestAnalyst(new CodeReader(new File(
					"src\\fortest\\undef\\UndefUserUserTest.java"))
					.getTokenArrayWithoutComment());
			ta.analyze();
			mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
			mi.analyze();
			target = mi.getTargetClass();
			target=FilterMgn.doFilter(target);
		} catch (Exception e) {
			e.printStackTrace();
			fail();
		}
		
		assertTrue(target.hasUndefValue());
		assertEquals(2, target.howManyMethods());
		UndefinedValue[] us = target.getUndefValues();
		assertEquals(1, us.length);
		UndefinedValue u0=us[0];
		UndefinedValue[] us2 = u0.getUndefValues();
		assertEquals(1, us2.length);
		assertEquals(2, u0.howManyHistories());
		assertEquals("java.lang.String(a)", u0.getValueAtHistory(0));
		assertTrue(u0.getValueAtHistory(1).startsWith("org.kikaineko.mock.framework.UndefinedValue("));
		assertTrue(u0.hasUndefValue());
	}

	public void testsl邪Ă邩() throws Exception {
		Analyst mi = null;
		try {
			Analyst ta = new TestAnalyst(new CodeReader(new File(
					"src\\fortest\\undef\\UndefUserTest.java"))
					.getTokenArrayWithoutComment());
			ta.analyze();
			mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
			mi.analyze();
		} catch (Exception e) {
			// TODO: handle exception
		}
		target = mi.getTargetClass();
		assertFalse(target.hasUndefValue());
	}

	public void testcslɃt@CiƗOł() {
		try {
			String[] ss = { "-v",
					"src\\fortest\\undef\\UndefForFinalClassTest.java" };
			MockMaker.main(ss);
			fail();
		} catch (UndefinedValueException t) {
			assertTrue(true);
		} catch (Throwable t) {
			fail();
		}
		assertTrue(true);
	}

	public void testMain() {
		try {
			String[] ss = { "-v", "src\\fortest\\undef\\UndefUserTest.java" };
			MockMaker.main(ss);
		} catch (Throwable t) {
			t.printStackTrace();
			fail();
		}
		assertTrue(true);
		FileIO.cutting("src\\fortest\\undef\\UndefUser.java", 600);
	}

	public void testMain2() {
		try {
			String[] ss = { "-v",
					"src\\fortest\\undef\\UndefClassUserTest.java" };
			MockMaker.main(ss);
		} catch (Throwable t) {
			t.printStackTrace();
			fail();
		}
		assertTrue(true);
		FileIO.cutting("src\\fortest\\undef\\UndefClassUser.java", 600);
	}
	

}
