package org.kikaineko.mock.analysis;

import java.io.File;

import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;

import junit.framework.TestCase;

public class SmallInterpreterForIfTest extends TestCase {
	SmallInterpreter mi;

	VariableTable vt;

	TargetClass target;

	public void testCt() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\controlstatements\\IfUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(0);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();

		assertEquals(int.class, vt.getType("simpleIfI"));
		assertEquals(Integer.class, vt.getVal("simpleIfI").getClass());
		assertEquals(new Integer((int) 100), vt.getVal("simpleIfI"));

		assertEquals(new Integer((int) 0), vt.getVal("simpleIfI2"));

		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI3"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI4"));
		assertEquals(new Integer((int) 100), vt.getVal("simpleIfI5"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI6"));

		assertEquals(new Integer((int) 100), vt.getVal("simpleIfI7"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI8"));

		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI9"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI10"));

		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI11"));

		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI12"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI13"));

		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI14"));

		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI15"));

		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI16"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI17"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI18"));

		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI19"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI20"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI21"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI22"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI23"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI24"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI25"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI26"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI27"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI28"));

		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI29"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI30"));

		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI31"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI32"));

		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI33"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI34"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI35"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI36"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI37"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI38"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI39"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI40"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI41"));
		assertEquals(new Integer((int) 1), vt.getVal("simpleIfI42"));
		assertEquals(new Integer((int) 11), vt.getVal("simpleIfI43"));

		assertEquals(new Integer((int) 101), vt.getVal("simpleIfILast"));

	}

	public void testGY() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\controlstatements\\IfUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(1);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();

		assertEquals(new Integer((int) 101), vt.getVal("elseIfI1"));
		assertEquals(new Integer((int) 11), vt.getVal("elseIfI2"));

		assertEquals(new Integer((int) 21), vt.getVal("elseIfI3"));
		assertEquals(new Integer((int) 21), vt.getVal("elseIfI4"));
		assertEquals(new Integer((int) 21), vt.getVal("elseIfI5"));
		assertEquals(new Integer((int) 21), vt.getVal("elseIfI6"));
		assertEquals(new Integer((int) 21), vt.getVal("elseIfI7"));

		assertEquals(new Integer((int) 101), vt.getVal("simpleIfILast"));
	}

	public void testGӕ() throws Exception {
		LangMgn.setLang(new Java());
		TestAnalyst ta = new TestAnalyst(new CodeReader(new File(
				"src\\fortest\\controlstatements\\IfUserTest.java"))
				.getTokenArrayWithoutComment());
		ta.analyze();

		mi = new SmallInterpreter(ta.getTestClass(), ta.getTargetClass());
		mi.setUpanalyze();
		mi.analyze(2);
		vt = mi.getVariableTable();
		target = mi.getTargetClass();

		assertEquals(new Integer((int) 6), vt.getVal("compI"));
	}
}
