/*
 * 쐬F 2005/03/14
 *
 * TODO ̐ꂽt@C̃ev[gύXɂ͎QƁB
 * EBhE  ݒ  Java  R[hEX^C  R[hEev[g
 */
package org.kikaineko.mock.analysis;

import java.io.File;

import junit.framework.TestCase;


import org.kikaineko.mock.framework.TargetClass;
import org.kikaineko.source.util.Java;
import org.kikaineko.source.util.LangMgn;
import org.kikaineko.sourcescan.CodeReader;


/**
 * eXg͂Ă邩̃eXgB
 * ɃCv^[͂łԂɂȂĂ邩mFB
 * @author Masayuki Ioki
 *
 */
public class SmallInterpreter1Test extends TestCase {
	TargetClass target;
	/*
	 * @see TestCase#setUp()
	 */
	protected void setUp() throws Exception {
		super.setUp();
		LangMgn.setLang(new Java());
	}
	
	public void testFXAssert() throws Exception {
		Analyst ta = new TestAnalyst(new CodeReader(new File(
		"src\\fortest\\AssertsTest.java")).getTokenArrayWithoutComment());
		ta.analyze();
		Analyst mi=new SmallInterpreter(ta.getTestClass(),ta.getTargetClass());
		mi.analyze();
		target=mi.getTargetClass();
		
		assertEquals(4,target.howManyMethods());

		assertEquals("ForAsserts()",target.getMethodName(0));
		assertEquals("n()",target.getMethodName(1));
		assertEquals("f()",target.getMethodName(2));
		assertEquals("t()",target.getMethodName(3));

		assertEquals(3,target.howManyHistories());
		
		String s=target.getHistoryAsRawString(0);
		assertEquals("ForAsserts();n();",s);
		assertEquals("java.lang.Object(@0)",target.getValueAtHistory(0));
		
		s=target.getHistoryAsRawString(1);
		assertEquals("ForAsserts();f();",s);
		assertEquals("boolean(false)",target.getValueAtHistory(1));
		
		s=target.getHistoryAsRawString(2);
		assertEquals("ForAsserts();f();t();",s);
		assertEquals("boolean(true)",target.getValueAtHistory(2));
	}
	
	public void testArrayUser() throws Exception {
		Analyst ta = new TestAnalyst(new CodeReader(new File(
		"src\\fortest\\ArrayUserTest.java")).getTokenArrayWithoutComment());
		ta.analyze();
		Analyst mi=new SmallInterpreter(ta.getTestClass(),ta.getTargetClass());
		mi.analyze();
		target=mi.getTargetClass();
		assertEquals(6,target.howManyMethods());
		
		assertEquals("ArrayUser()",target.getMethodName(0));
		assertEquals("set([I )",target.getMethodName(1));
		assertEquals("set(int )",target.getMethodName(2));
		assertEquals("length()",target.getMethodName(3));
		assertEquals("set([Lorg.kikaineko.source.util.Token; )",target.getMethodName(4));
		assertEquals("getToken(org.kikaineko.source.util.Token )",target.getMethodName(5));
		
	}
	
	public void testIntUser() throws Exception {
		Analyst ta = new TestAnalyst(new CodeReader(new File(
		"src\\fortest\\IntUserTest.java")).getTokenArrayWithoutComment());
		ta.analyze();
		Analyst mi=new SmallInterpreter(ta.getTestClass(),ta.getTargetClass());
		mi.analyze();
		target=mi.getTargetClass();
		assertEquals("IntUser()",target.getMethodName(0));
		assertEquals("get()",target.getMethodName(1));
		assertEquals("int",target.getReturnType(1));
		assertEquals("int(10)",target.getValueAtHistory(0));
		
	}
	
	public void testTestReaderTest0Test()throws Exception {
		Analyst ta = new TestAnalyst(new CodeReader(new File(
		"src\\fortest\\TestReaderTest0Test.java")).getTokenArrayWithoutComment());
		ta.analyze();
		Analyst mi=new SmallInterpreter(ta.getTestClass(),ta.getTargetClass());
		mi.analyze();
		target=mi.getTargetClass();
		assertEquals(10,target.howManyMethods());
		assertEquals("Tasu()",target.getMethodName(0));
		assertEquals("add(int int )",target.getMethodName(1));
		assertEquals("add(double double )",target.getMethodName(2));
		
		assertEquals("add(float float )",target.getMethodName(3));
		assertEquals("int",target.getReturnType(3));
		
		assertEquals("add(long long )",target.getMethodName(4));
		assertEquals("long",target.getReturnType(4));
		
		assertEquals("add(java.lang.String java.lang.String )",target.getMethodName(5));
		assertEquals("java.lang.String",target.getReturnType(5));
		
		assertEquals("add(char char )",target.getMethodName(6));
		assertEquals("char",target.getReturnType(6));
		
		assertEquals("add(int java.lang.String )",target.getMethodName(7));
		
		assertEquals("ok()",target.getMethodName(8));
		assertEquals("boolean",target.getReturnType(8));
		
		assertEquals(13,target.howManyHistories());
		java.lang.String s=target.getHistoryAsRawString(0);
		assertEquals("Tasu();add(int int )(int(1) int(1) );",s);
		assertEquals("int(2)",target.getValueAtHistory(0));
		
		s=target.getHistoryAsRawString(1);
		assertEquals("Tasu();add(int int )(int(2) int(1) );",s);
		assertEquals("int(3)",target.getValueAtHistory(1));
		
		s=target.getHistoryAsRawString(2);
		assertEquals("Tasu();add(double double )(double(2.0) double(1.0) );",s);
		
		s=target.getHistoryAsRawString(3);
		assertEquals("Tasu();add(float float )(float(2.0) float(1.0) );",s);
		assertEquals("int(3)",target.getValueAtHistory(3));
		
		s=target.getHistoryAsRawString(4);
		assertEquals("Tasu();add(long long )(long(2) long(1) );",s);
		
		s=target.getHistoryAsRawString(5);
		assertEquals("Tasu();add(double double )(double(3.0) double(0.0) );",s);
		
		
		s=target.getHistoryAsRawString(6);
		assertEquals("Tasu();add(java.lang.String java.lang.String )(java.lang.String(1) java.lang.String(2) );",s);
		assertEquals("int(3)",target.getValueAtHistory(5));
		
		s=target.getHistoryAsRawString(7);
		assertEquals("Tasu();add(char char )(char(49) char(50) );",s);
		assertEquals("java.lang.String(3)",target.getValueAtHistory(6));
		
		s=target.getHistoryAsRawString(8);
		assertEquals("Tasu();add(int java.lang.String )(int(1) java.lang.String(1) );",s);
		
		s=target.getHistoryAsRawString(9);
		assertEquals("Tasu();add(double double )(double(1.0) double(2.0) );",s);
		
		s=target.getHistoryAsRawString(10);
		assertEquals("Tasu();add(int int )(int(4) int(-1) );",s);
		
		s=target.getHistoryAsRawString(11);
		assertEquals("Tasu();ok();",s);
		assertEquals("boolean(true)",target.getValueAtHistory(11));
		
		s=target.getHistoryAsRawString(12);
		assertEquals("Tasu();ok(boolean )(boolean(false) );",s);
		assertEquals("boolean(false)",target.getValueAtHistory(12));
	}

}
