/*
KhadashPay
Distributed under the MIT License
© Copyright Maxim Bortnikov 2023
For more information please visit
https://sourceforge.net/projects/khadashpay/
https://osdn.net/projects/khadashpay/
https://github.com/Northstrix/KhadashPay
Required libraries:
https://github.com/zhouyangchao/AES
https://github.com/peterferrie/serpent
https://github.com/ddokkaebi/Blowfish
https://github.com/Northstrix/DES_and_3DES_Library_for_MCUs
https://github.com/ulwanski/sha512
https://github.com/Bodmer/TFT_eSPI
https://github.com/intrbiz/arduino-crypto
https://github.com/miguelbalboa/rfid
https://github.com/techpaul/PS2KeyAdvanced
https://github.com/techpaul/PS2KeyMap
*/
// !!! Before uploading this sketch -
// Change the Flash Size (Tools -> Flash Size) to the
// "2MB (Sketch: 1MB, FS: 1MB)" !!!
/*
Credit for photos:
https://unsplash.com/photos/wKfTNWaDYgs
https://unsplash.com/photos/GkacI-_mGlg
https://unsplash.com/photos/LqZJf4ukqz0
https://unsplash.com/photos/tNklhdD_D9o
*/
#include <TFT_eSPI.h> // Hardware-specific library
#include <SPI.h>

TFT_eSPI tft = TFT_eSPI();       // Invoke custom library
TFT_eSprite mvng_bc = TFT_eSprite(&tft);


const uint16_t Tel_Aviv PROGMEM [320][241] = {
{36085,38165,38197,27698,15118,13005,17199,23537,21359,23472,23440,19247,15054,15053,12973,15021,15021,15021,15021,15053,15021,15020,15020,15020,15020,15020,17068,17068,17101,19181,19214,17133,19213,21261,25487,38197,40375,40374,40374,44470,50710,54871,52790,48565,42259,40146,38033,44338,46418,42226,44338,46419,48499,46419,44338,44306,40146,35953,33841,31760,33840,35953,38033,42225,42225,38065,35920,35952,40112,40112,40079,40079,40047,40047,40047,40047,35888,31727,31662,31661,29516,27403,25355,25323,23242,23210,19048,19048,19016,23177,25290,25290,23209,23177,29483,31563,29515,33676,31596,27371,27403,33676,33740,25323,29516,31629,21096,14790,12710,10565,33741,29615,27470,25422,25357,23276,21163,23243,23243,21131,19017,16905,14824,12679,10598,8486,16969,23276,19115,21196,19115,14856,14824,14823,6405,6437,12874,25584,10663,12776,14889,12842,12874,12809,8583,6437,6437,6470,8550,6469,6470,2178,4291,4324,6437,6502,12776,12743,17100,19245,12906,10760,10695,8615,6437,2211,10761,21358,17067,14987,17099,12906,12874,10793,8713,8713,8681,6632,6567,8550,6436,4322,4323,8517,10663,8582,12776,6469,6404,4291,4324,10663,6469,6404,6468,2145,64,97,2178,6403,6403,10629,14889,17001,8549,64,2178,10597,8484,6371,10563,12676,10564,10531,6370,4226,4258,8484,8484,6339,4226,6404,8582,10826,6437,14889,17033,21259,19147,14856,19147,4714,391,423,260,358,195,261,163,195,255},
{38165,40278,40278,25650,13038,10925,13005,17199,17166,19247,19247,15086,13005,15053,15021,15053,15021,15021,15053,15053,15053,15020,15020,17068,17068,17068,17068,17068,17101,17101,19181,17101,19181,21261,23406,36084,40375,40374,40374,44502,48630,52822,52790,52758,46452,40114,42226,50611,48499,44306,44338,46419,48499,48499,46386,44338,42258,35985,33873,31760,33840,35921,38033,42225,42225,40145,35952,35952,42160,42160,42128,42127,42127,40079,42127,40080,35888,31727,31662,33742,29516,27403,25323,25323,25323,23242,21096,21064,21064,23209,27370,27370,25257,25289,29482,29482,29515,31595,31596,29515,31628,31628,29515,27403,27370,27468,25355,19049,16904,10597,29449,39915,39981,39949,39982,39982,35822,33742,31630,29550,27470,27470,27437,25357,23276,21163,23211,21065,21196,29679,19116,12679,12678,10565,6372,6437,10728,12809,10663,10696,12809,14922,12776,12744,6502,6437,4357,6437,4356,10663,10728,8550,4291,4324,8582,6535,8550,10663,15052,17165,10793,8647,6502,8615,4324,2178,12842,19278,10826,10826,10859,10858,10826,10826,10794,8745,8713,8680,6567,6470,10630,10630,6469,8549,8582,4356,4324,4291,4291,8517,10662,10663,6437,6436,6436,2145,2145,4290,10597,14856,16969,16970,12808,8517,6436,2210,6404,10662,4291,4258,4258,4226,4226,2145,4226,6371,6371,6371,4291,4226,2145,64,4389,8615,10630,14889,21259,23340,19114,6437,4324,553,358,456,260,358,228,260,227,162,255},
{40246,42358,38197,19312,10957,10925,12973,13005,13005,15053,15086,13005,12973,15053,15053,15053,15053,15053,15053,15053,15053,15021,15020,17101,17068,17068,17068,17068,17101,17101,17101,17101,19149,19181,21294,31858,40342,40374,40374,46550,50710,52790,52790,52758,52758,44339,44306,52692,50579,46387,46419,46419,48499,48499,46386,44338,40178,35985,35921,31760,31760,35921,38033,42193,42225,42193,38033,38000,42192,42192,42160,42160,42127,42127,42127,40080,35888,33775,31662,33742,31596,27436,27436,25323,25323,23242,21097,21064,21064,25257,25289,23209,25289,29483,29483,29482,31563,31596,35789,35821,37934,37902,29482,25257,16870,14758,19016,21097,19017,12678,12743,10630,16936,16870,18950,23175,23175,29480,42061,42094,44142,42094,42063,37935,31695,14857,21129,21097,23308,21196,14857,10630,10630,10566,4259,6404,10696,6470,8550,8615,8648,8616,8583,8550,8583,4324,4291,6404,8583,10728,10695,8550,6437,4324,6502,8615,6470,12744,15052,17165,10793,8648,6502,8615,4324,2146,14955,19245,14987,12939,12907,10859,10826,8713,8713,8681,8681,8680,6567,6469,10662,8582,6469,8582,6469,4323,4324,6404,10630,12776,12743,10663,6404,6404,4323,2210,8549,12775,14856,14921,17002,17034,6436,32,2210,8549,12775,14855,8452,2145,32,64,2145,4193,4226,6437,4324,4259,2146,2113,2177,32,8582,6437,10663,16969,29612,27533,17034,14921,15019,586,326,455,293,325,293,228,260,130,255},
{40278,40278,25618,13038,13005,12973,13005,13005,13005,13005,12973,12973,12973,13005,15053,15053,15053,15053,15053,15053,15053,15053,15053,17101,17069,17068,17068,17101,17101,17133,17101,17101,17100,19181,21294,31826,40342,40374,40375,46583,50742,52791,52790,50710,50710,46452,44306,52692,50611,46419,46419,48499,48499,48499,44338,42226,38066,35985,35953,33840,31760,33873,38001,40145,42225,42193,38001,35952,42192,42192,42192,42192,42160,42160,42159,42128,35888,33775,31694,35822,29516,27403,25323,23243,25355,23210,21097,21096,21096,25290,25289,25289,25322,31629,31629,31629,33741,33676,33676,39949,42094,39948,33707,27337,16870,12677,16903,16903,14791,21130,23275,12711,14791,10597,10564,6371,6372,6372,10663,12711,14823,16935,21096,31563,23243,12711,20999,25225,29484,29484,14857,6437,10598,10598,6404,6437,10696,8583,8583,8648,8648,10761,6502,4389,6502,4389,6502,6502,6437,2211,8485,10631,10663,4291,4389,10696,10728,19213,19310,19310,15052,12906,8680,8648,6470,4292,23406,27501,23242,19049,10761,8648,8681,8681,8681,8681,8680,8680,6567,8582,10663,8517,8549,8582,2211,4291,8550,12743,12775,12808,10695,8582,6436,10695,12743,10597,16969,17034,17034,17034,14954,12808,4290,64,2178,4291,6404,8516,4258,2145,2145,2145,2145,4226,4226,6437,4291,65,4258,6339,6338,2145,10760,6404,10662,19082,29579,29646,17002,17001,10923,554,423,423,390,293,326,195,260,130,255},
{40310,36085,17264,15086,13038,15086,15086,15086,15053,13005,12973,12973,12973,12973,15053,15053,15053,15053,15053,15053,15053,15053,15053,17101,17069,17068,17068,19181,19181,17133,17133,17101,17100,19148,21261,31826,40310,40374,42423,48631,52791,52791,52790,50710,50678,46452,44339,52724,52692,46451,46419,48499,48499,48499,44338,40146,38066,38034,35953,33840,31760,33840,35953,40145,42225,42193,35953,38000,42192,42192,42192,44240,44240,44240,44208,42160,35888,33775,33742,35822,29548,27403,25355,25323,25355,23210,21097,21096,21097,25290,25289,23209,25290,35756,39916,35756,35822,35821,37869,37900,35755,31563,35756,33676,27402,18951,16871,8484,8452,16904,25355,12710,16936,23275,14856,6404,6404,6404,6404,6372,4291,8484,4291,14823,10598,6371,12612,16805,23144,33743,16969,8485,10598,10598,6404,10630,14856,17002,14922,12841,12874,12907,6503,4422,10793,12842,6535,2243,2211,4291,6404,12809,12841,6405,8518,12874,10761,21359,23536,21423,17230,15084,15052,12939,8713,4390,14922,23243,21162,12743,12842,6535,6567,6503,4454,4357,4422,4356,4356,8582,10662,8549,8550,6436,6404,10695,12808,12776,12776,12808,10696,8615,6404,12776,12743,12743,19115,19147,14921,14889,10695,4355,2177,2178,12807,10662,6437,12742,4226,64,32,64,2145,4258,4291,65,32,6339,10565,4258,4225,2145,12873,12776,14889,19081,25420,34004,8582,4291,423,521,423,358,423,293,358,228,260,163,255},
{40310,36085,23505,19312,17199,15118,15086,15086,13005,13005,13005,13005,13005,15053,15053,15053,15053,15053,15053,15085,15053,15053,15053,17101,17101,17068,17101,19213,19214,19181,17101,17100,17068,19148,21261,27632,38197,40374,42423,48663,52823,52790,52790,48630,48630,50710,48564,52724,52724,48531,46419,48499,48499,46451,46419,42259,38066,38034,35953,33841,33840,33840,35921,40113,42225,42193,38001,38000,42192,42192,44240,44240,44240,44240,44240,42160,35888,33775,33742,35822,31596,27403,27436,25355,25323,23210,21097,21096,21097,25289,25290,25257,25290,33708,44173,44140,33708,31563,33676,33643,33675,35756,33611,27369,35756,37935,21097,8484,6404,6372,12710,10565,19115,27566,12710,6371,6371,6404,12743,17002,12743,6371,4259,2178,2178,4291,10630,6404,6404,19016,29549,18985,10598,8453,12808,14922,21196,23374,15020,12939,10762,10729,6470,6470,12907,21358,4422,4389,4389,2276,4356,8615,4422,4292,6405,12809,12841,19278,21424,19343,17198,15085,19310,21424,21359,17165,14955,14954,21228,14922,12777,10761,10728,8648,8615,8582,8582,4356,6404,8517,10695,6469,4291,6404,8615,12808,12808,12776,12776,12808,10728,8582,4324,10728,10630,14824,12743,6436,2178,97,97,2209,2177,6436,21227,17034,10663,10630,4258,0,0,0,2145,4291,4323,2145,2178,6371,8451,6306,4258,4258,12906,14921,14921,19113,27631,29843,12874,17132,521,423,488,293,423,260,326,228,227,228,255},
{36085,27731,29811,19344,19279,19312,19279,17199,15086,13006,13005,15053,15053,15053,17134,17134,15053,15053,15085,15085,15085,15053,15053,17101,17101,17069,17101,19181,21326,19214,17133,17068,17068,19148,21229,25487,33971,40375,42455,48663,52823,52790,52791,48630,48630,50710,50644,50612,52692,50611,46419,48499,48499,46451,46419,44339,42226,38066,35985,33873,33840,33840,35920,40081,42193,42193,38033,38000,42192,42192,44240,44272,44272,44272,44240,42160,35920,33807,31662,39982,37869,27436,27436,25356,27403,23210,21097,21097,21129,25290,25290,25322,29483,31661,31629,31628,31595,33644,35789,35756,35756,35756,35658,29417,31595,37934,25322,10564,8452,8452,8452,8485,16969,16969,10630,6403,6371,6404,14889,19082,12775,12678,16871,10565,8452,6372,8517,6371,6371,14856,29647,19017,10565,4292,10696,10728,27567,17100,12875,8648,6535,10728,6470,10794,19344,17231,2276,4422,6502,4357,2276,2244,2276,2178,4324,14987,12809,15020,23504,19343,23536,17133,17133,23504,23472,23472,23472,21391,14987,8582,12809,12809,12744,10631,12776,12775,8517,8517,8484,8517,8517,4291,6371,8550,10695,12809,12808,12776,12808,14889,10728,8550,2210,12775,12743,14856,10630,2177,64,32,96,2177,64,10662,23340,17002,8517,10630,2178,32,0,0,4258,4291,2146,6404,6339,4226,4258,2177,2145,4388,12938,14921,14921,21194,31890,25585,17067,12906,554,358,488,326,423,325,293,293,195,2309,255},
{38198,23538,23537,21424,21392,31859,31859,21424,17199,15086,15053,15053,15086,15086,17198,19279,17199,15053,15053,15053,17133,15053,15053,17101,17101,17069,17068,19181,19214,19214,17101,17068,17068,19148,21229,25454,33971,40374,42454,48663,52823,52823,52790,48662,48630,50710,48564,54836,52724,48531,48499,48499,48499,48499,46387,42259,40146,38034,35953,35921,33840,31760,35920,38033,40145,42193,38033,35952,42160,42192,44240,44272,44272,44272,44240,44241,35920,33807,33742,40014,37869,27403,27468,27436,27468,23210,21097,19016,23177,25290,25290,25322,27435,33709,33709,33709,33676,35788,37869,37901,37901,37835,44010,35722,23143,23144,29548,14790,8484,8484,8452,10662,17002,10597,14791,6371,6404,8484,16969,16970,14824,23242,21129,12743,12678,10598,6372,4291,8452,16969,23276,19018,8518,8550,17002,14889,23373,14922,6535,10761,12875,12842,4422,10859,21522,15085,195,4455,8713,4389,4389,4356,4324,4292,4324,15019,10728,17132,23536,15052,19278,23439,17100,8680,10826,12971,15084,15117,14987,14824,14922,14922,29680,21195,16936,8517,8516,8516,8484,8484,6403,6371,6371,8550,10728,12808,12776,12776,14889,14921,10696,6469,2178,10630,10663,12776,12775,4290,2145,96,2145,96,64,14888,21260,17001,10662,10630,2145,32,0,2145,6404,2145,65,8517,4258,64,65,4258,2112,6534,12906,14921,17034,25451,23405,12874,6437,4422,618,390,488,391,391,358,260,325,163,2341,255},
{42391,36085,23505,19344,21424,36052,33972,23505,19279,17199,15086,15086,15086,15086,17166,23473,23505,19247,17134,15053,17133,17101,17101,17101,17101,17101,17100,19149,19181,19181,17101,17100,17068,19148,21228,23374,33938,40342,44503,48663,52823,54871,52790,50710,48630,50710,52789,56949,54804,48531,48531,48531,48499,48499,46387,42226,38066,35953,35953,33873,33840,31760,33873,38033,40113,40113,38033,35952,42160,42192,44240,44272,44272,44272,44272,44241,37968,33807,33774,37934,33741,27403,25291,27404,27468,23177,21097,21065,23177,25290,25289,25290,27370,29515,29482,31596,33676,33708,37869,39981,39981,33641,39881,35754,23175,23111,27403,23210,14791,12677,8452,10662,10630,8485,12742,6403,6404,8517,19115,19082,19050,27436,19049,12743,10631,8485,4291,4259,12776,23341,25454,27502,14890,17002,17034,19115,17002,10729,10794,14988,12907,12842,4422,12972,15183,10827,2276,6567,8713,4356,4324,4324,6437,6437,6470,14987,12841,19213,23471,17133,17133,27698,19245,4356,4324,2243,2276,2244,8582,17035,14889,12808,14889,16970,10630,8516,8484,6371,6371,6403,6371,6371,6371,10630,12808,12809,12809,12808,12809,12809,10695,6436,4259,10630,12743,10630,4322,4289,4289,2144,2144,64,64,8549,10662,6437,17034,12710,4258,4291,2210,2178,2178,0,10630,8517,65,2113,64,2113,2113,10793,12874,14954,19147,25451,21259,12939,19278,6828,586,456,456,455,325,390,228,325,228,4421,255},
{36117,34004,21424,25586,23505,27698,34004,25585,19312,19312,15118,15086,15118,17166,15086,21392,25650,23505,17166,17134,17133,17101,17101,17101,17101,17101,17101,19149,19181,19181,17101,17100,19116,19148,21228,23374,29713,38197,44503,50711,52823,54903,52822,50710,48630,50710,54870,58998,54836,50644,50611,48531,48531,48499,44371,42226,38098,38034,35953,35921,33841,31760,35921,38033,40113,40113,38001,38000,42160,42192,44240,44272,44272,44272,46320,44241,37968,33807,33742,37934,35821,29516,29516,27436,27468,23242,21097,21097,23177,25289,25289,23209,25257,27370,27369,31563,33676,33708,37901,37837,35788,37868,33674,33674,31594,25289,21096,14823,16936,19016,8484,10662,8485,10598,12743,8517,8452,10663,17100,12711,8517,23275,16969,16937,19050,14824,6371,6339,17035,23407,21326,29745,29745,25519,23308,21163,17003,10729,12907,12940,12939,14922,6535,15052,15118,10891,8746,10859,6567,4324,4324,4324,6470,6437,8615,14986,14889,14987,17100,21326,19213,29745,21391,23471,21358,19245,17100,12841,14987,12874,8550,6371,4323,19115,16969,10597,6371,4258,2145,65,65,2113,2178,6469,12808,12809,10728,10695,12809,12809,10663,4356,4323,8549,12775,14823,6435,4289,2177,2144,64,64,2177,2177,8582,10630,17002,4226,2178,4258,4258,4291,4291,32,6404,4259,32,64,2145,2145,6338,12938,12874,14986,17034,12840,12873,15084,15052,2667,553,521,455,488,358,423,293,293,2308,2308,255},
{23570,23538,25618,36085,36085,31891,34004,31891,23505,19312,19311,19344,21392,19312,15118,17199,21425,19312,19279,17166,17134,17101,17101,17101,17101,17101,17101,17101,19181,19181,17101,19149,19148,19148,21228,23342,27600,33971,44470,50743,52823,54903,52823,50710,48630,50710,52790,58998,54836,52724,50644,48531,48531,48531,44339,40146,38098,38066,38033,35953,33841,33840,33872,38033,38033,40113,35953,38000,42160,42192,44272,44272,44272,44272,44272,44240,37968,35856,33742,37934,35789,29516,29549,29549,27468,25291,21097,21065,23177,25257,25289,25257,25289,25322,27402,35789,35821,35789,37901,37901,37836,35787,35755,33675,33675,31563,21064,12645,14791,23210,10630,10598,8485,10598,17002,10630,6404,12743,21293,8485,4259,21130,14856,19050,19082,14889,6404,6436,25454,25519,23406,25520,21326,21294,19116,23243,21228,10794,12940,12940,12940,12874,6503,15053,6634,6503,6568,10892,6535,4324,4357,4356,6470,4389,10761,14954,14824,14954,17067,29712,27566,19147,14987,17132,19213,21358,21359,19278,17100,8583,4324,4291,6404,21228,23341,10597,10565,8484,8451,8452,6339,4258,4291,8582,12808,12808,10695,8582,8615,10695,8615,4324,8549,10695,10663,16969,10662,2145,64,64,64,2210,4290,8647,12841,8615,14921,2145,32,32,32,2178,2145,0,4226,2145,2145,4225,4226,4225,4291,15019,14954,14922,14921,10792,12874,8615,4324,553,488,553,391,488,358,358,293,325,2276,2243,255},
{29844,23505,31892,38165,42358,44471,36117,36117,31924,21425,21425,23570,25618,25618,19280,15086,17166,19247,19312,17199,17134,15085,15053,15053,17133,17133,17101,19149,19181,19181,19149,19149,19148,19148,21228,23374,27567,33906,44470,50743,52823,54903,54903,50742,48630,48662,50710,54837,52692,52724,52692,50612,48531,48531,44371,40178,40146,40146,38066,35953,35921,33840,35921,38033,38033,38033,35953,38001,42192,42192,44272,44272,44272,44272,46320,44272,37968,35887,35822,35854,33677,29548,29581,29516,27436,25291,21097,21097,23177,25257,27370,25257,23209,25257,29482,31595,33676,33676,35756,39981,35755,31561,35787,33675,31562,33741,25322,14725,10565,10565,8452,8485,6404,6372,10598,10597,8484,8485,19148,21228,10565,19016,12776,19082,19082,12744,4291,8582,27599,27567,27600,31825,29745,27633,19116,21163,21228,10827,12940,12940,12940,8616,8583,17166,17166,6503,2309,6568,6503,4357,4389,4324,6470,4324,12841,16969,14856,14954,14954,17002,8615,4356,4291,6436,12743,14856,10663,12776,17003,14922,8518,10663,10662,21293,21195,10564,10564,14791,19049,21227,6437,4356,4324,4389,6469,8550,6469,8582,12776,10728,8582,4324,12743,12808,12743,19114,6404,32,32,32,64,4291,8484,10793,10793,10695,10728,2145,2113,32,2113,2178,2178,4226,4258,2145,2145,2145,4258,4225,4356,14987,12873,12808,14986,10793,8647,14888,14953,586,423,553,423,456,391,325,326,325,2341,2341,255},
{40311,29844,29779,42358,46551,46551,42423,42423,38263,23570,19312,25650,27763,25650,21392,13006,15053,15086,17166,17134,15086,15085,17133,15053,17101,17133,17133,19149,19181,19181,19149,19149,19148,19148,21229,23374,25519,31826,42422,52791,54903,56983,54903,52790,48662,48662,50710,46452,48499,52724,52692,50612,48531,48531,46419,44371,44339,40178,38066,38033,35953,33840,33872,38033,40113,38033,35953,38001,42192,44240,44272,44272,44272,46320,46320,44273,38000,35887,35854,37934,33677,31628,29581,29548,25323,23209,23177,21097,23177,25290,27337,23177,23177,23176,27370,33676,37934,35789,35821,40014,35755,35788,37901,33675,27336,31595,25321,16838,10565,10564,8452,8452,8452,6404,4291,14823,23308,16937,21196,25454,12743,19050,14857,19083,21195,23276,10631,16970,21261,21261,21229,19148,17003,31859,27567,27469,21261,12940,12940,12907,17002,16970,17035,14955,14988,6503,2211,6567,6535,4357,4324,4324,4356,2178,14987,14888,14856,17002,8550,6437,4389,8582,14856,14888,12711,8517,10630,6404,12776,12776,14889,14856,14824,21195,18918,16837,25355,23308,29679,19180,4421,4389,2276,2243,98,130,8614,12808,17034,10728,6501,4324,14889,14922,6404,14823,4258,32,32,64,64,4323,4323,10793,10695,8516,10662,4258,2145,2145,2113,6371,8452,8452,4259,2178,4323,6371,4290,2145,8615,14954,14921,14986,17197,10728,6469,14888,14986,619,391,521,456,423,423,293,390,325,2373,4454,255},
{40343,40278,38165,46519,48632,48632,44503,42423,42424,29844,17199,19312,23570,19344,15086,13005,15053,15086,15053,15053,15086,15086,15085,17101,17101,17133,17133,19149,19181,19181,19181,19181,19149,19148,21228,23342,25454,29745,42390,52823,57016,56983,54903,52791,48662,48662,52790,44371,46387,54804,52724,50612,50611,48531,46419,46419,46451,42259,40146,38066,35985,33873,33840,38033,40113,38033,35953,38033,42192,44272,44272,44272,46320,46320,46320,44273,38000,35888,37967,40014,33741,29516,29516,29516,27435,23209,23177,21097,23177,25290,25289,25257,25257,25257,27370,29450,33708,35756,35788,39981,35756,37900,37900,33643,29450,27402,29515,21097,10597,8484,8452,14823,10630,16936,8484,16969,25454,21228,17003,23341,19050,21130,14857,21195,25389,23276,10631,21196,21228,23406,23374,21196,19083,29778,27503,29582,21261,12940,14889,27435,25290,16905,10729,12842,19213,4389,4324,8680,6502,4356,4324,4357,4324,2211,15019,14856,14823,8517,10565,14986,12841,16969,14889,8517,6404,97,4259,8518,12776,10663,12776,10663,12744,12710,8517,14888,21228,25421,33840,21260,4389,4422,2276,2243,130,163,8615,2211,10728,10695,6469,6469,14954,14921,6371,10629,2145,32,32,2177,4257,64,2178,8615,4291,6306,6403,4290,2145,32,2113,6338,4193,6404,4324,10695,6469,2178,2145,2113,12808,17034,17034,17100,19310,10793,12841,8549,2471,586,456,488,488,358,456,261,391,2374,2341,6665,255},
{42391,46519,44471,46551,50712,48632,44503,34069,29876,31989,21425,15119,17232,15119,13005,13005,15086,17166,15086,15053,15086,15053,15053,15053,17101,17133,17101,19149,19181,19181,19181,19181,19181,19181,21229,23341,25454,29713,40277,50743,57016,54935,52855,50743,48662,48662,50742,46452,46387,54804,54772,50612,50611,48499,44307,46419,46451,44339,40146,40114,38033,33873,33840,38033,40113,38033,38001,38033,42192,44272,44272,44272,46320,46320,46352,44273,38000,35888,35855,35854,33741,31596,31629,29548,27435,23210,23177,21097,23177,27370,27337,25289,25257,25257,27337,29450,35789,33643,35756,40014,37901,35787,37868,35755,33675,27370,27371,29516,19016,12678,8484,12743,10598,6404,8484,17002,25454,19115,12711,21260,21163,23276,16970,21196,27502,21196,10631,10663,23374,29680,27567,23341,23341,21326,23341,31694,14889,6405,8485,19017,12744,6437,10696,17101,23407,4324,4422,8616,6437,2211,2243,4324,4259,4324,17100,14824,14823,6371,10564,15019,12776,8550,8517,2145,2178,2210,4324,4356,6502,8615,12809,12809,8583,4357,6470,16969,16970,31694,38033,21195,2309,4389,2276,2211,98,2211,12808,10630,14889,10695,6436,8582,12808,10662,6403,4322,64,32,2145,2177,4257,64,6404,6469,4226,65,8484,4226,4258,4291,4226,32,4258,10694,4291,2210,6437,2146,32,2145,12841,16969,14889,15019,19310,17165,19212,12775,4682,553,553,456,521,358,423,293,390,2374,2341,8746,255},
{44471,44471,44439,44471,50712,50744,44471,25650,21425,31989,23538,15119,15086,13038,13005,13005,17166,17166,15086,15086,15086,15053,15053,15021,15053,17101,17101,19149,19181,19213,19213,19213,19181,21229,21229,23374,25455,29680,36019,46485,56984,52823,52823,50743,48663,48630,50710,48597,46419,54804,54804,50644,50611,48531,44339,46419,48499,44371,40178,40146,38034,35921,33873,38033,38065,38033,38033,38033,42193,44273,44273,46352,46352,46352,46352,44273,38001,35888,37967,37902,33741,31596,33741,29549,27435,23209,21096,21096,23177,25289,25289,25289,23176,25289,27369,25257,31563,33643,35788,37869,35755,42061,33642,33642,31530,27337,25322,23209,25323,23243,14791,12711,19016,12710,8484,21228,23341,12776,14856,16970,21196,25422,27535,21261,27534,19115,8583,8518,23276,23276,21163,17002,14889,21294,25422,31694,10598,4291,4291,8485,12809,6470,10761,17133,21326,2244,6502,4389,2211,2179,2211,4259,2146,4389,17100,14823,12743,6339,8516,14987,14954,8518,2178,6372,6404,8582,4356,4324,8583,6502,4324,6372,2210,97,6470,25421,29581,37968,40114,23341,12841,12808,10663,6469,4324,4357,12743,16904,12809,10663,6404,6437,10630,8516,2177,129,64,2177,4257,2145,4258,4258,6436,4323,4258,10597,10630,2113,0,0,0,32,4225,6371,4258,2178,4356,2113,32,4291,12808,14856,17002,19180,21325,25552,14889,14889,4779,488,586,456,521,423,423,358,326,2341,2276,8779,255},
{44471,36085,36085,42326,46519,48631,42390,23505,19312,21457,19312,17199,15086,13006,13005,15053,15086,17167,17166,17199,17166,15086,15053,15021,15021,17101,17101,17101,19213,19214,19213,21262,21229,21261,21261,25422,29648,31793,36019,46485,52855,50743,50775,48663,48663,48630,48662,50677,48499,54804,54804,52692,50612,50611,48499,46451,46451,46419,40178,40146,38066,35953,33873,38033,38033,38033,38033,38033,42193,44273,44305,46352,46352,46352,46353,44273,38001,35888,35887,37902,33709,29516,31629,31628,31628,23209,21096,21097,23177,25289,25257,25289,25225,23176,25256,27369,29482,33643,37869,37869,35723,33642,29416,29448,33643,29450,18951,14757,19016,25388,25356,16904,19082,21260,10663,21227,23341,17002,12744,14890,25454,27568,25487,21294,25454,14922,8583,8550,25388,14857,16970,10663,8551,21326,25454,27502,8485,4291,8517,10695,6438,4390,10793,12907,17133,2244,8583,4357,2243,2211,2244,4324,4259,6535,15019,12743,12677,6339,10630,14986,14954,12809,8550,6404,4291,4291,8550,12776,10663,6404,2113,10467,10467,12711,23374,27567,25422,33840,38066,27534,19147,19115,19082,17034,14921,14922,14759,14791,12776,10663,4356,10630,10662,2209,96,96,32,2177,2177,2145,8516,10662,6403,4291,6469,19114,8484,2113,0,0,2112,2113,2113,32,65,2178,2145,65,2113,6469,17002,23275,29646,31694,23308,8583,14921,14986,683,423,586,455,488,455,326,358,2341,6633,4455,8811,255},
{38230,27731,29778,40245,44438,44438,38197,23538,17232,17231,17231,15151,15086,15054,15053,15053,17166,19279,17199,17199,17166,15086,15053,15053,15021,17069,17101,19149,21262,21294,19214,19213,21261,21261,23374,27567,31793,36051,38131,42292,52823,50743,50743,48663,48663,48662,48662,50677,50612,54804,54836,52692,50612,50611,48531,46451,46451,46419,42226,40146,38066,35953,33873,38033,38033,38033,38033,38033,44241,44273,46353,46353,46352,46352,46353,44273,38001,35888,37967,40014,33741,29548,31628,29516,31596,23209,21096,21096,23177,25257,25289,27337,27370,27369,25256,27369,29482,31562,37868,42062,37836,33641,29416,29416,33708,35822,23144,14757,12677,10630,16969,19115,14856,21261,10631,21163,19050,17002,12776,14889,27567,29680,25455,25487,25422,12809,8583,10664,21261,12777,12809,12809,14955,23471,27534,25421,6404,4292,6404,2211,6502,6535,15019,17165,14988,2244,6535,2276,2244,2243,4357,4421,2244,8648,12808,4258,6371,8452,12775,12841,8582,4356,4291,2178,10598,16969,19213,21294,10533,6371,6371,10500,12580,21098,23342,27535,31760,40113,42160,37934,33741,29549,23308,21227,19115,19147,19082,16969,12776,10663,6436,12743,12742,2208,64,64,64,2145,64,4291,14856,21228,10630,6437,4324,14856,6371,2178,2145,2145,2112,2145,2145,65,32,4291,2145,64,2145,8615,8550,10662,17002,16969,19115,12841,17034,12938,683,456,553,488,423,488,293,358,2373,6632,4487,8811,255},
{34070,29779,27698,36052,40245,36085,29843,23505,17231,17199,17199,15151,15086,15086,15053,15054,17166,17231,17199,17199,17166,17134,17134,15053,15053,17069,17101,19149,21294,21327,21262,19213,19181,23342,25487,29713,31826,33971,33938,40179,52823,50743,50743,48663,48663,48662,48662,50645,48532,54836,56884,52692,50612,50612,48532,44371,44371,46451,42226,40146,38066,35953,35921,38033,38033,40113,38033,38033,44241,44273,46353,46353,46352,46352,46353,44273,38000,35888,37967,37935,33709,31628,31661,29516,29516,23209,21096,21064,23177,25257,25289,27369,27337,25289,27402,27402,29482,29450,33675,42094,35755,31561,29449,29417,29449,31563,23143,16837,12645,8452,19050,14857,14857,14889,8485,23308,12743,12776,17002,17002,27502,27568,23374,23374,17068,12875,10729,10728,14987,12777,8583,4324,14922,23406,25422,19083,4324,4291,8550,10761,10729,4455,15052,17133,12874,4324,6535,4357,2244,2276,4389,2211,2178,10728,10695,10565,10565,6371,10663,6469,4258,2145,2145,8485,21195,19148,21359,19181,8420,4258,4258,6306,6307,19116,21230,27502,40081,40079,35853,33741,29548,25355,21130,16936,14824,12743,10630,8550,8582,8582,6404,12776,12774,6402,97,64,2177,96,2145,10597,19115,21195,6469,2210,8583,17002,4259,65,32,32,2113,2145,2113,65,32,2113,2178,65,2145,10760,8550,14889,17034,17002,19147,19147,17067,11020,618,521,489,521,391,488,293,325,2341,2308,2373,10891,255},
{31957,25650,23505,27698,36084,29811,25618,21457,21393,19312,17231,15151,15118,15086,15086,15118,17166,17199,17199,17199,17166,17166,17134,17101,17101,17069,17068,17101,21262,21326,21294,19213,19181,23342,27600,29745,29745,29681,27632,40179,54903,50743,50743,48663,48663,48662,50710,54870,48532,54836,56884,52724,50612,50612,48532,44371,44339,46419,42258,40146,40146,35953,35921,38033,38033,40113,38033,38033,44241,44273,46353,46353,46352,46352,46353,44273,38000,35888,37935,37935,33709,31661,29548,29516,27435,23209,21096,21064,23209,25257,25257,25257,25257,25257,27369,31563,33675,33643,33676,35756,35788,31561,29417,29417,27304,29482,31595,21031,12645,10597,21195,16937,27566,12743,8484,25388,23275,12775,14856,23341,31728,27568,21262,19181,17068,10729,12842,12907,15020,10697,8583,98,12809,23439,25519,10631,8518,6469,8582,6535,6600,4389,12907,15085,10696,4324,8745,6567,4357,4389,4389,4389,2243,12874,12775,12743,10565,10532,12808,6404,2178,2178,2145,12743,16970,12711,19213,17035,8452,6371,6339,6339,6372,17231,19344,25454,14889,21130,16807,12646,16904,12743,14791,10598,10598,8484,8550,10695,8582,8517,6437,12776,12742,10628,2145,2177,2209,2177,8484,14888,14888,8582,14986,10663,19082,17034,4258,4258,4324,4356,4356,6339,2113,32,2145,4258,4258,65,4258,12874,12841,17002,17034,17034,21260,17099,17067,6925,553,586,488,554,391,423,162,97,32,0,4389,12939,255},
{21458,19344,19312,21457,21457,21393,21425,23538,25650,21457,17231,15119,15086,15086,15086,17199,17199,17167,19279,19279,17199,17166,17134,17101,17101,17101,17101,19149,19213,21294,21326,21262,19181,23374,27600,31826,29745,27600,27568,35986,48598,50743,50743,48663,48663,48662,50710,54903,56917,56917,56885,52724,50612,50612,48532,44339,44306,48499,42259,40178,38098,35953,35921,38033,38033,38033,38033,40081,44241,44273,46352,46352,46353,46353,46353,44273,38000,37968,35887,35886,33709,33709,31629,29548,27435,25290,23176,21064,23209,23176,27337,25257,25257,25257,27337,27337,33676,33644,35789,31563,37868,31529,29384,29482,27501,23177,27403,25290,12677,10631,12809,12809,19180,10631,6404,21162,25356,12710,12743,25454,35888,19181,21261,23342,25421,6470,10696,12809,17068,12810,10696,2211,14987,29843,29843,10663,16969,12808,8550,6437,6568,8681,15053,15118,8616,4389,10858,6535,4357,6437,4357,8583,4356,15019,14824,12710,10597,12645,17100,12808,4291,2177,2145,14889,17002,10598,14954,14824,6339,6339,8420,10533,16905,19246,19376,21293,6404,6404,6307,12581,14694,14693,10565,8452,6404,6436,10662,10631,10663,8517,8582,12808,6436,64,64,6403,4290,8549,16937,19082,4323,2210,15019,12808,14823,10597,4258,32,32,65,4226,4258,2145,65,6372,6372,2178,2113,8550,15019,12873,14986,17067,17067,19212,15051,15052,6925,2699,683,651,619,553,325,32,0,0,32,8615,12906,255},
{15184,19345,19344,19344,17232,19312,21457,25618,25618,19344,17199,15119,15086,15086,15118,19279,19279,17166,19312,19279,17166,17166,17134,17133,17101,17101,17101,19149,19181,21294,21326,21294,21261,23374,29680,33938,31826,27600,27567,29648,38099,50710,50775,48663,48663,48663,50742,52822,56950,56949,56885,52724,50644,50612,48532,44339,42259,46419,42259,40146,38066,35953,35921,38033,38033,38033,38033,38033,42193,44273,46352,46353,46353,46353,46353,46321,38001,37968,35887,35854,33741,33709,31628,31628,31628,23209,23176,21096,23177,23176,29449,25224,23144,27369,27337,27403,31596,35789,37902,37902,37868,31529,31595,25454,19213,6470,17002,25486,14954,15019,12906,14987,12906,12841,10729,12777,10728,10631,10696,12841,21195,10729,14987,21261,25421,6470,12809,8583,21294,14890,8550,6437,21293,34004,27632,12776,17002,14856,8549,6437,6568,12907,19343,15118,10826,8648,8681,6470,6437,6437,6437,10663,6405,17100,12775,10630,8452,12710,19213,14955,10696,6437,10630,17002,16937,10598,21261,12711,6307,4259,8452,17002,27567,29745,21391,19147,2211,8484,16969,25454,27567,29582,27470,23341,19115,8517,8518,10695,10695,6437,10663,14856,12775,4290,2145,6403,14823,17002,16969,14856,4290,2145,10728,14954,14791,10597,4226,0,0,32,65,32,0,4258,8549,12743,6404,6436,8550,15019,14954,17067,17067,17100,17229,15149,13100,10955,10922,8874,8874,8875,8875,10825,6436,2177,97,64,2211,2178,255},
{15184,19312,19345,19312,17231,19312,21425,21425,21425,19312,17232,17199,15118,15086,15118,17199,19279,17167,17199,17199,17166,17166,17134,17133,17101,19181,19149,19181,19181,21262,21294,21326,21294,23374,29745,31858,31793,27600,27567,27567,33841,48598,50743,48663,48663,48663,50743,52790,54869,56917,56917,54772,50644,50612,48532,44371,44339,44339,42259,40146,38066,35953,35921,38033,38033,38033,38033,40081,42193,44273,46353,46353,46353,46353,48401,46353,40081,37968,37935,37967,33741,33708,35788,29516,27435,25322,23209,21096,23177,23176,29449,25225,23177,27370,27402,29516,33709,37934,37869,42095,35788,31627,23374,17035,19116,4389,17067,19213,8616,8681,4422,12874,6568,12971,10826,15052,15052,15020,15052,15019,12907,12874,12875,12874,12874,8616,10761,8648,19181,14922,17035,14922,10729,23374,25389,16969,19082,14856,14955,10794,6568,12972,17166,8714,6437,4357,8713,6438,6437,6437,6437,8583,8518,17099,12743,10630,8583,10696,10761,10761,8583,8583,14921,19148,14857,10598,19050,12711,8452,8420,10598,17099,29712,25519,23439,14954,2178,17002,17067,21294,19213,19213,23439,27665,29713,19212,12809,8583,10663,6437,14889,16969,19114,14791,8484,16936,21195,19115,14856,4290,2209,4290,14921,14954,19148,10630,2145,32,32,4226,65,32,32,6436,6404,8485,8517,6404,10761,12971,12971,15116,17229,15181,15148,13035,10890,8711,12905,15051,15018,19212,17131,12808,12742,14823,8484,32,2178,2145,255},
{15184,17232,19344,19344,19312,19344,21424,21392,19344,19344,19312,17199,15119,15118,15086,17167,17199,17199,17166,17166,17166,17166,17166,17133,17133,19181,19181,19181,21261,21294,21294,23374,21294,23439,29713,27632,29713,29680,27600,27567,31761,48598,50743,48663,48663,48663,50743,52791,56950,56917,56917,54804,50644,50612,48500,44339,42259,44307,42259,40146,38066,35953,35921,38033,40114,38033,38033,40081,42193,44273,46353,46353,46353,46353,46353,46353,40081,37968,37967,37967,33741,31661,31661,27468,29516,25355,23209,21064,23176,25256,29449,27337,27337,25257,29483,31596,31628,35756,39949,42030,35788,31628,19115,17068,19148,4390,10762,21164,30885,12549,2244,2308,2309,4487,2341,6600,4422,6600,8746,6600,12971,8680,15084,14954,17165,12972,15085,15084,10794,8713,10761,8648,6568,6535,14922,14922,10728,10696,12875,10826,4455,17166,17198,12972,2244,4389,10794,4389,4389,4389,6469,8517,8518,12874,10663,8615,6470,4389,6535,10728,8615,10696,12808,17067,14792,14856,21293,10598,6307,4258,10630,21260,33873,23406,23439,10728,4356,16970,19213,23471,14955,14955,12874,14923,23439,29810,25454,19017,12679,6437,12743,12776,16969,14856,19049,19050,10662,6436,6403,2209,2177,4290,8615,6469,19115,8517,2178,2178,4323,12775,6404,8452,6404,4291,6404,6371,32,2243,12971,12971,15116,17229,12971,12938,10825,12840,6500,2145,6436,10695,10630,14855,16903,16903,16903,14823,12677,6371,12709,14822,255},
{15184,17232,19312,19344,19344,19344,19344,19344,19344,19344,19312,17231,15119,15118,15086,15086,17166,17166,17134,17166,17166,17166,19182,19182,19181,19181,19181,19181,21262,21294,21294,21294,21294,23374,25519,25519,27600,29713,29680,27567,29648,44405,52823,48663,48663,48663,50743,52791,56950,59030,56917,54836,52692,50612,48532,44371,44339,44339,44307,40178,38098,35986,35953,38034,38034,38065,40081,40081,42193,44273,46353,46353,46353,48401,48433,46353,40081,37968,37967,37967,33709,31661,31662,29516,29548,27435,23177,21064,25257,27337,27369,29417,29449,27336,27402,31596,31596,31563,35789,37902,39982,31662,23341,19181,17068,6470,23439,25390,30853,14662,2276,2276,4389,4421,2373,4454,2373,4487,2309,4519,8713,2276,4487,4389,8680,2374,8713,6632,10858,10890,8778,15020,10794,17132,10826,12972,12874,10761,8681,6568,4455,19278,15053,12907,2212,4422,8713,4357,4389,4324,4389,4259,4291,4389,6470,6436,2244,6502,6470,6534,8615,10729,14922,12744,14759,14889,23374,10565,6339,6307,12646,31628,31662,19181,21294,8550,19115,29745,10664,21391,19278,19246,19213,17100,21424,19310,10696,25292,16904,8453,12711,10631,14857,16969,27534,12743,97,4258,4290,97,96,2242,8550,8485,16904,8484,2145,2178,10630,12808,8517,6339,4226,64,2113,65,32,4258,6404,6404,14889,17132,12776,10662,6403,12644,12611,8418,10596,14790,14823,14823,14823,14790,12710,12677,8484,8484,10629,12710,255},
{17232,17232,17232,19312,19344,19312,19312,19344,19344,19344,19344,19280,17199,15119,15086,15086,15086,17134,17134,17134,17166,19214,19214,19182,19214,19214,21262,21262,21262,21294,21294,23374,23342,23374,25455,25487,25455,27567,27567,27535,29615,44372,52823,48663,46583,48663,52791,52823,54902,56982,56917,54837,52724,50612,48532,44371,44339,44339,44339,42259,38098,35954,35953,38034,38065,40114,40081,40081,42193,44273,46353,46353,48401,48433,48433,46321,40081,37968,37967,37934,33709,31629,31661,29516,31661,27435,23177,21064,25257,27337,25257,29449,29450,25256,25257,33708,37902,35788,37836,40048,37901,29549,23374,21261,17003,8583,27730,23375,26855,10663,2276,2308,4421,4422,4421,2373,2374,4486,2308,8712,10793,2308,2341,2373,2341,4454,4487,4389,4584,2406,4487,8713,2341,8615,4390,10826,6567,12939,8745,13004,12907,15117,17197,15052,12907,12907,12939,8680,8648,6502,6470,2211,4291,6469,4324,4356,8680,8615,4324,8550,6502,12842,19213,23374,21065,21098,16905,10565,10565,8484,8420,8452,19115,17068,21261,6470,25487,25552,12809,21294,14987,14987,14987,14987,17100,14955,6503,10663,10598,10533,14759,14856,19050,16969,23308,16969,6402,2209,2145,2176,4224,14953,14888,8484,16870,6339,33,32,8549,8550,8484,8452,2145,2178,4258,2113,65,6371,8517,12743,17035,14922,6403,6371,4257,6306,14692,14757,14790,14822,14822,14790,14790,12710,16903,16903,12710,10629,10597,10598,255},
{17264,17264,17232,17264,17264,19344,17264,19312,19312,19312,21392,19312,19280,17199,15086,15086,15086,17134,17134,17134,17134,19214,19214,19214,21294,21294,21294,21294,21294,23342,23374,23374,23407,23374,25455,25455,23374,25454,25455,27535,29648,44372,52823,48663,46583,48695,52823,52823,54903,56950,56917,56917,52724,50612,46452,44339,44339,44339,42259,40146,38066,35986,35953,38034,40114,40114,40081,40081,42193,44273,46353,46353,48433,48433,48433,46353,40048,37968,37935,37966,33741,31661,31661,29548,31629,25322,21096,21096,25257,27369,27369,29449,29450,25289,23176,29450,35788,37836,42095,42161,35756,29581,25455,21261,14889,8616,27763,21262,24838,6470,2276,2308,4389,4421,4422,4389,4454,4454,2276,10728,12906,2341,4422,4422,2373,4454,4454,4454,4584,2374,8712,12906,4389,2276,2211,2309,6567,6567,4487,6632,4389,8615,6502,4454,6567,6503,10761,8648,15052,10761,15052,10793,12906,10826,12842,10761,8648,2211,2211,8550,10696,17035,25454,21229,19050,14824,8485,6339,4259,4258,4259,6404,19181,17101,21293,10663,29713,21293,12841,23439,19245,17165,17068,14955,14955,12809,10664,12744,8517,8485,14792,21131,25421,25356,25388,14824,10563,6337,4256,14689,20929,25223,23045,20963,23076,12577,6304,4224,4192,4193,10595,10628,4324,4356,4323,4291,6404,14823,16937,19115,21294,8516,2145,8451,8516,12710,18983,21064,16871,12710,14790,19016,19016,19016,19016,16936,14855,12743,8550,8550,255},
{19377,19312,17264,17264,17264,17264,17264,19312,19312,19312,19312,21392,19312,17199,17166,17166,17166,17134,17166,17166,17134,17134,19214,19214,21294,21326,23407,23375,23375,25455,23374,23375,25487,25455,25455,25455,23374,25422,25454,27535,29680,44372,52823,48663,46583,50743,52823,52855,54903,56950,56917,56917,52724,48532,44339,42259,44339,44339,44307,40179,38066,35986,35953,38034,40114,40113,40113,40113,42193,44273,46353,46353,48433,48433,48433,46353,40048,37968,37935,40015,33741,31629,31629,31628,29548,25289,21064,23176,25289,27369,29449,29450,29450,27369,25257,31596,27337,29417,37934,33708,35788,29581,17100,17035,12809,8648,25682,25325,26887,6470,2276,2276,4389,4422,4389,4389,4422,4486,2308,6535,6567,2309,2309,2308,2309,2309,4389,4486,4454,2373,12938,14986,4421,2276,2276,4389,6534,4454,4487,6567,4389,10728,6470,2276,4357,4324,4357,6437,6502,4357,6502,2308,6535,2244,8680,6600,6567,2178,2178,8550,12776,12809,14890,19148,25585,19213,21261,14824,12711,4259,2113,6405,19214,21294,23439,23374,31793,14954,14954,15019,12841,14987,21359,21359,19278,12874,8517,12743,8485,12776,14954,19115,21163,23243,27470,18953,10531,16769,18881,20929,20929,25158,23044,25156,23042,18849,20929,20929,18816,14657,12578,10498,6339,8550,14824,19049,21195,21196,17002,21326,14987,10597,12710,14856,16937,14856,21097,19016,16903,16903,19048,19016,16904,12743,12711,10662,10663,10663,10662,10663,255},
{21425,19377,17265,17264,17264,17264,19312,19312,19312,19312,19312,19312,19312,19279,17199,17199,19247,17166,17134,17167,17166,17134,19182,21294,21327,23375,23407,23407,23407,25487,23407,23407,25487,25455,25455,25455,23374,23374,25454,25454,27567,38066,48662,50743,48663,50743,52855,52855,54903,59030,56917,56917,52757,50612,46420,42259,44339,44339,44339,42227,38098,38034,35953,40114,40114,40114,40114,40113,42193,44305,46353,46353,48433,48433,48433,46353,40048,37968,37935,37967,33741,33742,31661,29548,29483,23209,21064,23144,27369,27369,29449,31562,27402,25256,27337,33676,33676,33708,33675,31530,35755,31694,21326,17035,12777,10729,25682,25325,24903,8615,2244,4487,4422,4454,4454,4422,4454,6535,2309,8648,6567,2308,2309,2341,2308,2276,4389,4454,2374,2373,8745,8615,4389,2243,2243,4421,2341,4454,6567,6534,6470,17067,8615,2276,4389,4324,4356,8550,8550,4324,4324,4389,2276,131,6502,2276,4422,2178,2178,10630,12809,12777,12809,25421,25487,12809,12776,17002,14857,6404,8518,14988,23439,23439,23439,29778,27632,10631,19180,4291,65,6372,14954,12874,12874,6468,4290,10630,8517,14921,17067,19148,19018,18985,14825,19050,8417,8417,10497,12609,16804,21096,16805,23110,18883,14658,14690,12578,10497,12578,16805,16871,19017,19050,21261,19180,23407,17100,19246,21293,10630,12743,14856,16969,17002,14856,14791,16903,14855,14823,12743,12743,12711,10663,10663,10663,10663,10663,10630,8550,255},
{21425,19377,19345,19345,19312,19312,19312,19312,19312,19312,19312,19312,19312,19312,19279,19279,21360,19279,17166,17166,17166,17134,19214,23375,23375,23407,23407,23407,25487,25487,23375,23407,25487,25487,25455,25455,25422,25422,25422,25454,27535,31728,42292,50711,48663,50743,52823,52823,54903,59030,56917,56917,52757,50644,46452,42259,44339,44339,44339,40179,40146,38034,38033,40146,42194,40146,42194,40113,42193,44305,46353,46353,48433,48433,48433,46353,40080,37968,37935,37967,33742,33742,33709,29548,27435,23176,21064,21096,27369,27337,29449,31562,29450,25256,25256,29482,31595,33709,33709,37902,33643,25355,14987,17035,10664,14890,27763,23180,18758,4324,2244,4617,4422,4389,4422,4422,6534,4422,4421,17100,10793,2308,4422,4454,2373,2308,4389,4454,2406,2373,8712,6535,2276,2243,2244,4486,2341,4487,6599,8647,4389,10728,4389,2276,4356,4324,2243,6469,8550,4421,2309,2341,2276,4389,10793,6535,6535,6502,10663,12776,12809,12842,14955,17100,25618,19279,17067,25421,23373,21228,17002,21326,21391,21359,23472,29745,23374,12809,17034,2145,2146,12808,19212,8582,6469,4323,6371,10630,10565,12711,14856,19050,19018,18985,14858,17034,6370,6370,2209,2177,8583,17133,8518,21129,10532,8419,12677,12678,12678,16937,23341,23373,19180,23406,23439,17133,21327,19246,23472,14824,12711,14856,14856,21162,17001,14856,14824,12743,14856,12743,12743,12743,10663,10630,10630,8550,8550,8550,8550,8583,255},
{21425,19377,19377,19345,19345,19344,19344,19312,19312,17232,19312,19312,19312,19312,19312,19312,21360,21360,19247,17166,17166,17134,19214,23407,23407,23439,23407,23375,25488,25487,23374,23407,25487,25487,25455,25455,25422,25422,25422,25454,27502,29615,38034,48630,50743,50743,52823,52823,52823,56950,54869,54837,50644,48564,46420,42259,42259,42259,42259,40179,38066,38066,38033,42194,42194,42194,42194,40113,42193,46353,46353,48433,48433,48433,48433,46353,40080,37968,37935,40015,37935,33774,31628,27435,31629,25289,23144,23176,25289,27337,29417,33610,31563,27369,27369,33741,33742,35790,35789,35822,37869,23275,14988,23374,10663,14955,27763,27211,20839,4389,2276,4519,2309,2276,4389,4389,6502,4389,4421,12938,4454,2308,2341,2341,2341,4454,4454,4519,2406,2406,17099,8647,4389,2211,2276,4519,2374,6600,8745,6632,4422,10728,2308,2308,4389,4291,2243,8549,6469,6534,2276,2341,2309,4389,8648,8746,13004,8616,12809,14922,17133,27796,23571,17232,36248,17264,23406,23308,25453,21195,17002,23406,17133,23439,21359,29810,14987,25065,10468,2145,6372,17035,14954,8517,8484,8516,12743,12775,12710,12711,14825,16905,18985,21098,14824,8484,4257,4290,6338,8516,21326,27763,17002,19049,14758,21163,14856,14856,10630,21260,23439,21326,19180,21261,19181,23440,27698,17035,12678,10565,12743,16969,14889,14856,12776,12743,12711,16937,14856,10630,10663,10662,10663,10663,12743,12776,12808,12776,12776,10663,255},
{19377,19377,19377,19377,19377,19345,19345,19345,19312,19312,19312,19312,19312,19312,19280,19279,19312,21360,19279,17167,17166,17166,19246,23407,23407,25520,25488,25455,25520,27568,25487,25455,25487,25487,25455,25455,25422,25422,25422,25422,27502,29582,38033,50711,50743,50743,52823,52823,52823,54903,54870,52757,44340,42259,44372,44339,42259,42259,42259,40179,38066,38034,38033,42194,42194,42194,42194,42161,42193,44273,46353,48433,48433,48433,48433,46353,40080,37968,37967,37967,35854,33741,31596,29548,33742,25289,23176,23176,25256,27337,27369,33610,29482,27369,25256,33709,37935,35789,33709,35821,33708,29614,25422,27436,10566,23309,29842,27114,24968,4487,2276,4519,2309,2276,2309,4389,4454,4389,2309,10793,4422,2341,2308,2309,2276,4486,6534,4551,2406,2373,10858,4454,2308,2211,2276,4552,2439,4552,4519,4421,8583,14986,2309,2308,4356,2243,4323,8517,4356,4324,2309,2341,2309,4389,4422,4520,6633,6535,14890,14922,12907,29876,23570,15119,25683,17329,25618,23276,25421,21163,19082,23439,21359,25520,23472,25584,12679,33062,4193,2146,10663,19245,17067,4290,6371,8516,12775,12743,10630,17036,17134,17036,19050,25389,21195,14856,12742,14823,14823,14824,27666,23407,12679,16969,21195,21260,17002,12776,12776,17067,19180,21261,19083,21229,21229,21293,14889,14857,14921,8518,14856,14889,14824,12744,10663,10630,10630,17034,12743,12743,14856,14856,17001,16969,14856,14857,10663,8550,6469,6437,255},
{19377,19377,19377,19377,19377,19377,19377,19345,19312,19312,19312,19312,19312,19312,19312,19280,19279,21359,21360,19279,17166,19214,21295,21359,23407,25488,25520,27568,27568,27600,27600,27568,27535,25487,23374,25422,25454,25422,25422,25422,27470,29582,38001,50710,50743,50743,54903,52823,52823,54903,54870,50645,42292,40179,44340,44371,42259,40179,40179,40146,38066,38034,38033,42194,42226,42194,42194,42193,42193,44273,46353,48433,48433,48433,48433,46353,40081,38000,37967,37934,33741,33741,33741,33741,33742,25289,23176,23176,25256,25289,29417,31562,29450,27369,25256,33676,35790,33676,37934,35854,29483,35789,31563,29450,21031,21163,27632,24968,18791,2309,2308,4584,2309,2276,2308,2309,4454,4389,4422,17132,6535,2309,4454,4421,2309,4519,6534,4519,2341,2341,10825,4422,2276,2243,2308,4584,2471,4552,4422,6469,6470,10728,4454,6502,6437,6437,6502,6469,4389,4356,4422,2373,2341,8648,8648,6698,4487,8583,12777,10663,6470,19246,21392,19344,23570,17264,25552,23308,23308,21163,19082,25584,25585,25520,27666,23374,19017,16807,65,6339,14987,14987,12842,14889,10630,8517,12776,12711,10565,14890,17003,19083,19115,25454,21195,19082,19082,17002,23373,16970,14889,19181,23407,14889,19082,21196,21261,23439,27697,25519,19017,19115,19147,19115,19115,14857,12743,19181,14955,12808,14856,12776,12744,10630,10663,10630,14856,16969,10598,17001,16937,12776,10663,8550,8550,14889,10662,8550,2243,4291,255},
{19377,19377,21425,21425,21425,21425,21425,19345,19344,19312,19312,19312,19312,19312,19312,19312,19280,19311,21359,21359,19247,19247,21327,21327,21327,23407,25488,27568,27600,27600,27600,27568,27568,25487,23374,23374,25422,25422,25422,27470,27470,29582,38033,52791,50743,50743,54903,54903,52823,54903,54870,50645,46452,42260,42291,44372,42259,40179,40179,40146,38066,38034,38034,42194,42226,42226,42194,42193,42193,44273,46353,48433,48433,48433,48433,46353,40081,40048,42127,44206,37934,33742,35822,31629,29548,25289,23176,23176,25289,27337,29449,31529,25257,27337,25224,33676,35789,35789,40014,33708,35789,35854,33708,35789,23176,23308,23406,10664,10728,2276,4389,4487,2309,4421,2276,2309,4454,2308,2276,10793,2341,2309,4486,4454,4454,4421,4422,4551,2373,6567,17132,4486,4389,2243,2341,4649,6697,4584,4454,8745,8712,12808,8615,8582,8550,8615,10663,8517,4389,4389,2309,2309,2308,8648,8680,10826,4454,6502,14857,17035,12841,21294,21261,21163,27468,31693,37934,37934,37902,31629,29549,25618,27698,25519,27665,29615,23373,4356,2113,8485,19213,17100,12874,19148,8550,12775,12776,12775,14791,14824,16937,16970,21163,21196,23341,21228,19115,19082,21228,14889,16937,23309,25422,21228,27665,29811,27665,23374,19148,19083,16937,14889,14921,17002,19115,14889,14889,6469,4292,14889,14857,14856,14889,10663,12775,10630,17002,17002,14856,12743,8517,8550,10630,10630,12743,14824,10662,6437,4291,8517,255},
{19377,21425,21425,21425,21457,21457,21457,21425,19344,19312,19312,21360,21360,21392,21360,21360,21360,21359,21359,21359,21327,21327,21327,23407,23407,23407,25487,27568,27568,27600,27600,25487,25487,25455,23374,23374,25422,25422,25422,27470,27470,29582,38033,52823,50711,50743,54935,56983,54903,54903,52822,50645,48564,42292,42292,46420,42259,40179,40179,40147,38066,38066,38034,42194,42226,42226,42194,42193,42193,44273,46353,48433,48433,48433,48433,46353,40081,40048,40047,40014,37934,31661,25355,27436,27468,25322,23176,25256,27337,27337,31529,33642,29417,29449,27304,35788,35821,33708,37901,35756,35788,37902,29450,35789,31596,29647,29647,21196,19180,12841,17099,10760,12906,8680,8680,8615,6535,6535,2276,10761,2276,4389,2309,4422,4389,6437,4422,4552,2309,6567,14987,4422,4356,2276,4389,6600,6665,6665,4454,6599,12906,12841,8582,8582,8550,8615,12710,8550,4357,2276,2308,4389,4389,6535,2244,4454,4357,8550,8550,17035,17003,16969,25323,29548,33708,35788,37901,31628,27371,25290,29614,25682,27730,27567,21228,21163,19212,2178,2146,12808,14954,10728,19115,14889,6404,14889,12743,14856,17002,14921,23308,21163,17002,17002,19115,25388,21195,17002,16969,19050,19082,19082,23308,23309,23309,19083,16905,12711,12744,19115,16969,14889,14889,14922,14922,14889,14889,10695,12809,17002,14889,12776,12776,12743,10663,10663,14889,14889,14856,12711,12711,12711,12711,10663,12743,14856,12743,14856,16969,19082,255},
{19377,21425,21425,21457,21457,23505,21457,21425,21393,21392,21392,21392,21392,21392,21392,21360,21360,21360,21360,21359,21359,21359,21327,23407,25487,23407,25487,25487,25487,25487,27568,25487,25487,23407,23374,23374,25422,25422,25422,27470,27470,29582,38033,50678,50710,50775,54935,56983,54903,52855,48598,44372,46484,44404,42292,46452,44307,40179,40179,40179,40146,38066,38034,42194,44274,42226,42226,42193,42193,44273,46353,48433,48433,48433,48433,46353,40113,40048,40047,40014,40014,33742,29516,27435,27435,23209,23176,27337,29449,27369,31529,33641,29449,29449,27336,33708,31563,31563,37869,33708,31595,33709,27304,31596,31628,21096,21032,25324,23308,23341,14889,12809,17067,17035,17067,17100,17165,21293,19180,21293,12841,17100,8615,12906,6502,8648,6502,6599,4389,6535,10825,4389,4356,2243,4389,4486,6600,8713,4454,4389,10696,8648,6534,8582,8550,8550,8550,8582,4454,4422,4454,6469,6502,10793,4389,4324,6469,10695,6437,14889,21261,14824,12743,14922,12776,8550,19083,19050,16937,23243,25487,25715,27698,25454,23308,29582,31727,27534,21195,8550,10695,17002,16969,6404,10630,14889,21195,25454,21228,17002,19050,16969,16937,19083,17002,21195,17034,17002,12809,14889,14889,16969,16970,16969,14889,19082,17002,14889,14889,17002,14889,14857,14889,14922,14922,14921,14889,12776,12776,12744,12744,12743,12776,12775,10695,12743,16970,16937,14856,12743,12711,12711,12743,14856,19050,19082,23275,21227,19082,16969,255},
{19377,21425,21425,21457,21457,23505,23505,21457,21425,21393,21392,21425,21392,21392,21392,21392,21392,21392,21360,21359,21359,21327,23407,23439,25487,25487,25487,25487,25487,25487,25487,23407,23407,23374,23374,23374,25422,25422,25422,27502,27470,29582,38001,48532,54870,54903,54903,54903,54903,52855,46485,42292,42292,44372,44372,46452,44339,42227,40179,40179,40147,40114,38033,40146,44306,44274,44274,42193,42193,44273,48401,48433,48433,48465,48465,46353,42161,40080,40015,40014,40015,33710,31629,31661,31661,25289,23209,25257,29449,27369,31529,35690,29417,29449,27336,33676,33709,33708,37901,35789,37902,35789,31595,29450,29482,16870,18983,27436,31793,31793,14889,6404,12776,10631,10533,8615,4357,8550,12841,10728,12841,14922,17035,19148,17100,19245,17132,21326,21261,19148,17067,14922,14954,8615,12841,6502,10793,6535,6567,2276,10696,6535,4389,8550,6469,6437,10597,8582,6534,4389,4389,6469,6502,10826,8615,4356,6469,10631,19115,19213,19213,8550,12776,17002,12776,8550,21196,10534,16905,27534,25454,29712,35953,38000,37967,33774,31661,29549,21129,4258,8484,16969,8485,10597,14856,12776,17002,23308,19082,14857,16970,21228,16937,14889,17002,19115,14954,12841,12809,12809,12809,12809,12809,14857,14889,17035,14922,14889,14922,17002,14889,12809,14857,14857,14857,14856,12776,14856,14856,12776,12776,14856,14856,12808,12776,14856,19082,14889,14856,14824,14856,16937,19049,21163,21163,19050,14857,10695,10631,8550,255},
{21425,21425,21457,21457,21457,23505,23505,23505,23505,21425,21425,23505,23505,23440,21392,23440,23440,23440,21392,21360,21359,21359,23407,23407,25487,25487,25487,27568,25487,25487,25487,23407,23375,23374,23374,23374,25422,25422,25422,27502,27470,29550,35921,44372,50645,56983,54935,54903,54935,52823,44372,42324,42292,42292,46452,48532,44339,42259,42259,42259,40179,40146,38033,40114,44306,44274,44274,42193,42193,44273,46353,48433,48433,48465,50513,46353,42161,40080,40015,40014,39982,31661,25323,27403,27403,25289,27402,27337,29449,29449,33609,35722,27369,29449,29449,29483,33741,35756,39949,39982,35821,35789,35789,31563,27369,18950,14790,25355,29712,29712,14857,6372,12776,12711,10566,8614,4324,4324,4356,4356,8550,8518,10598,12711,8485,10663,25422,19147,14856,23308,17002,17002,19148,17100,19213,17133,19246,17100,21326,14954,19180,10761,14987,8647,12809,6470,8615,6502,6534,2244,6405,4357,4389,6534,2211,2210,6436,12776,23309,14987,17132,10631,14889,14889,8582,10631,19115,6373,21164,27567,27438,12613,12710,21130,27468,27435,25322,19016,16904,16968,6371,14889,12776,12743,14889,14856,14856,17002,16969,14889,17002,19147,16970,12776,10696,12776,12776,10728,10696,10696,10728,12776,14889,14922,14922,14954,17002,12809,12808,12808,14954,17035,12776,14857,12776,12776,12776,14856,10630,14856,16969,14889,14856,12743,12744,14889,17002,10663,10663,14856,12743,10663,10630,8582,10695,10663,10663,12776,12841,14922,255},
{21458,21457,21457,21458,23505,23505,23505,23538,23538,23505,23505,25585,25553,23472,23472,23472,23472,23440,23440,23440,23407,23407,23407,23407,25487,25487,27535,27567,25487,25487,25487,23407,23375,23374,23342,23342,25422,25422,25422,27502,27502,29550,33776,42259,48532,56951,57015,54903,54935,48598,44372,44372,44372,42259,44340,50580,44371,44339,46420,44339,40179,40146,38066,40114,44274,44274,44274,44273,42193,44273,48401,48433,48465,50513,50513,46353,42161,40080,40047,37934,39983,35854,33708,31628,31596,25289,23176,25257,29449,29449,31561,35722,29417,29450,29482,31628,31563,35789,35788,37869,35789,35821,35756,33708,25256,27370,14758,21129,27534,14889,14889,19147,14922,14889,8517,8517,6469,6437,6470,6469,8517,8517,10598,10598,8517,14824,31793,19115,6404,23276,21131,19050,19050,14856,14889,14890,12777,10664,17035,19148,19181,21261,14955,14987,17132,15019,19213,17100,17132,12874,14922,12808,10728,10761,10696,10663,17002,21228,21228,14987,17100,8582,17002,17035,10631,10630,14922,18889,23310,33874,25292,10533,8485,14857,19050,16937,16936,16904,14791,19017,10630,14857,14857,16937,19115,16969,14889,16970,16969,16969,17035,19148,16970,14857,10696,10696,10663,10696,10728,12809,12841,14922,12809,12776,12776,12809,14889,14889,14889,14889,19181,19181,12776,14856,14856,14856,16969,19082,23275,23275,19082,14889,14889,12776,10663,14921,14922,8582,10631,10663,12776,14889,17002,17002,14954,14954,17067,17099,12874,14954,255},
{23538,23506,21458,23506,23538,23506,23538,23538,25586,25585,25585,25585,23505,23473,23472,23472,23472,23440,23440,23440,23440,23407,23407,23407,25487,27535,27567,27567,27567,25487,25487,23407,23375,23374,23342,23342,25390,25390,27470,27502,27502,29582,31695,40114,44307,54805,59063,54935,56984,50710,44405,44372,44372,42260,42259,48532,46419,42259,44339,42259,40179,40146,40114,38034,44274,44306,44274,44273,44241,46321,48433,48433,48465,50513,50513,46353,42161,40080,40047,37934,40015,37902,31628,31628,31628,25289,25224,27337,29449,29449,33609,33641,27337,29417,27368,37902,35822,35756,35756,35756,37935,33676,29449,35821,23143,23209,21064,25323,29615,14824,12743,23374,21261,17035,14856,8550,12776,16970,14922,19083,14889,8517,10565,10597,10630,16970,31826,14857,8517,19082,21163,23309,16969,12744,16970,17002,12842,14890,17002,17003,21196,25422,23244,16969,4357,4357,4324,8518,10696,10631,19115,23373,25454,23341,19148,19180,19116,21196,21196,19148,17068,12744,19147,21261,14857,19017,16970,8486,25487,33874,23050,12645,12711,17002,21195,19017,16936,16904,14791,14824,14857,14792,14856,16969,19082,14889,16969,16970,17002,16970,19115,21228,17002,17002,14889,12776,10696,10696,10728,10728,12776,14889,12776,12776,14857,17002,16970,12776,14856,12743,10663,12776,16969,14889,14856,14856,14889,14857,14889,12808,12776,14889,14889,12776,10696,17067,19115,19115,19147,21260,21261,21261,19180,19147,19180,12841,12841,6470,98,10696,255},
{23538,23538,23538,23506,23538,23538,23538,23538,25586,25586,25586,25585,25553,23473,25521,25520,23472,25520,25520,25520,25488,25488,23439,25487,25487,27567,27567,27567,27535,25487,25487,25455,23374,23374,23342,23342,25390,25389,27470,27502,29550,29582,31695,38001,44306,54805,59063,56983,56984,52790,44372,42292,42324,42260,40211,46452,46420,42259,44307,42259,42227,40147,40114,40114,44274,44306,44306,44274,44273,46321,48433,48433,50513,50513,50513,48433,42161,40080,40047,37934,37934,37934,35822,33709,33709,25289,27337,29449,29449,29417,33609,35690,29417,29449,29416,37869,35789,39982,37868,33676,42129,33675,27303,35821,29482,16870,23177,29614,29647,16969,16969,23406,27600,17035,19115,14857,8550,14889,14922,23341,23309,10598,14823,14791,8517,19083,27535,16969,16936,23210,21162,21162,12711,16937,19083,17002,10664,10598,16937,21163,16937,21131,21195,16937,14856,19050,14824,12678,16970,8551,19050,19018,12711,12678,19115,23341,23341,29712,27534,27565,31727,33775,33775,33807,27501,25389,23374,10664,23342,25454,18953,16872,16937,23309,25454,19050,12710,14824,14856,16936,16937,14856,14857,16970,19083,17002,17002,19083,16970,14889,19147,19115,19083,17002,14857,8583,8615,10696,10696,12776,12776,14889,12744,12744,12776,12743,14856,10662,12743,10663,10663,12744,12776,12776,12776,12809,17002,14922,17034,14922,12809,14922,14889,19148,21293,21293,21293,19147,17034,14921,12808,12776,8582,14921,25454,16970,14889,12711,16904,19017,255},
{23538,23538,23538,23538,23538,23538,23538,25586,25586,25586,25586,25585,25553,25553,25553,25553,25553,25552,27600,25520,25520,25520,25488,25488,25487,25487,27567,27567,27567,27535,25487,25455,25454,25422,25422,25390,25390,25389,27470,29550,29550,29582,31694,37968,46354,56950,59063,56983,56984,54903,46517,42292,42292,42292,42260,44340,46420,42259,42259,42259,42227,42227,40146,40114,42226,44306,44306,44274,44273,46353,48433,48433,50513,50513,50513,48433,42161,42128,40047,37934,35854,35822,33708,35821,33676,25289,27369,29449,29449,29417,33609,35722,29417,31529,29448,31528,37868,40047,35756,37902,40048,31562,27336,33675,29450,14757,23178,31695,29615,14889,12744,23374,23406,25519,17035,19147,12776,14922,17003,21229,19115,16937,23276,27437,12678,4291,6437,12743,14824,14791,16936,21129,21130,27436,27469,29549,23243,12678,10630,10630,12711,16936,8484,6404,14856,19083,14824,6339,6404,12743,19082,8452,8484,6371,8517,19017,14856,16937,21163,23276,25356,23308,25356,25356,23276,23309,21228,19148,17002,14889,14824,16904,16969,21229,21196,19082,16937,14856,14856,16937,17002,16937,16970,19115,19115,17003,17003,19083,16970,10662,2242,4323,6469,10630,10663,8550,10728,10695,10663,12743,10663,10630,10662,10663,12743,12743,12743,10630,10630,10663,10695,12808,12841,17035,17067,17035,14922,14954,14987,12841,10728,12841,10696,17034,12841,12809,10695,8582,8582,8550,8550,8550,6469,16970,23211,18953,23146,23114,21001,21000,255},
{23538,23538,23538,23538,25586,25618,25618,25586,25586,25586,25586,25586,25585,25553,27601,27633,27633,29681,29681,27600,27600,27568,25520,25520,25487,25487,25488,27568,27567,27535,27535,27535,25455,25422,25422,25422,25390,25389,27470,29550,29550,29582,31694,37968,42193,54805,61143,56983,57016,54903,46485,42292,42260,42292,42260,42260,42292,42292,44339,42291,42259,40178,40146,40114,42226,46354,44306,44274,44273,44305,48433,48465,50513,50513,50513,48433,42161,42128,42095,39981,39982,33741,33708,35789,33741,27402,25256,27369,29417,29417,33609,37802,31529,31529,31561,33641,35755,39949,35757,40014,37902,31562,31529,33609,23176,18984,16839,33741,27534,14857,14889,25454,23277,17002,14922,17035,12776,14922,16970,21228,19050,16969,21162,27404,16904,8485,10663,12809,12809,8550,8518,8452,6339,6372,12678,16904,19050,25356,16937,14856,16904,12710,8451,12710,19050,16937,16937,14792,10598,12743,14824,12678,12710,8484,10694,14921,17002,19050,23308,27469,23276,21196,21163,21163,21163,21163,23309,19083,19083,17002,16937,16970,17002,14889,17002,17002,14889,14889,16970,17002,16970,12776,12744,21228,23309,19083,19083,19083,12743,2210,129,97,97,4257,4323,8516,6403,4290,6403,10630,8517,6436,8550,10662,10630,12743,12743,10662,12711,8518,6470,12841,14922,14987,17100,19213,17067,12809,10761,6372,4324,15052,10696,8583,6502,12939,6502,8550,8582,8550,8582,8550,12744,16872,18888,21033,21001,23114,18920,18920,255},
{25619,25619,25618,23538,23538,25618,25618,25586,25586,25586,27666,27666,27633,27633,27633,29713,31761,31761,29681,29681,29681,27600,27568,25520,25488,25488,25487,25487,25487,25487,25487,25455,25455,25454,25454,25422,25422,25421,27470,29550,29550,29582,33742,35888,42161,52692,59063,56983,57015,54903,44405,42292,42292,42292,42260,42260,42292,42259,42259,42259,42227,40146,40146,40114,42226,44306,46354,44306,44273,44305,48433,48465,50513,50513,50513,48433,42193,42128,42095,42062,40046,35822,35789,35789,33741,27402,27337,27337,29417,29417,33609,37770,33609,33610,33609,33641,37868,40014,35788,40014,37869,27369,29449,33675,27435,25388,14791,31596,29582,14857,19115,25455,25422,23341,21260,19180,12776,12809,16970,19083,23309,19083,21130,23210,14824,14857,12744,12777,12809,14857,19050,14791,12711,12711,10630,10598,14824,23341,21196,14824,12711,12743,12711,14792,14824,19050,16937,16937,18985,19050,21163,23276,19082,19082,19114,21195,14889,16970,23308,27502,27502,27534,27501,25389,23308,19050,19083,14889,14857,14889,14889,16970,23374,17035,17002,19083,17002,16970,16969,14889,14856,12776,12744,21196,23309,19083,19115,23309,6436,2177,2177,97,129,97,2177,8483,4322,4258,4258,4323,4323,6437,8550,16969,25519,25552,23472,21359,27665,27697,21326,10761,8615,8615,8648,8583,6436,2145,6534,6372,10695,19278,8583,8583,8550,8713,6470,8582,8582,8550,8582,8550,14889,14791,16807,18952,18985,16840,18920,16807,255},
{27699,27699,25618,23538,23538,23538,23538,23538,25586,27666,27666,27666,27634,27665,29713,35954,40082,33841,31761,31761,31761,29649,27600,27568,25520,25488,23407,23407,23407,23375,23375,25454,25455,27503,27502,27502,27470,27470,27502,29550,29550,31630,33742,35855,44208,52692,59063,56983,59063,54903,44405,44372,44372,42292,44340,44372,44340,42259,42259,42259,42227,40178,40146,40114,42194,44306,46354,44306,44273,46353,48433,48465,50513,50513,50513,48433,44241,42160,44206,42125,40014,35822,33742,35790,33709,29483,29450,29449,29417,29449,33609,35722,33642,31562,31561,33641,37868,42061,39949,39982,37934,27368,25224,31563,25290,25356,18985,29516,31694,16970,19148,27567,25454,23342,10663,8550,8518,12776,14856,17002,23309,19083,23243,25356,21163,12743,4323,8550,12776,12776,14889,21163,16970,12809,16970,16970,19083,19116,19083,14889,12776,14857,12777,12776,14857,19115,10631,12711,12744,12744,16905,14824,14856,14856,14824,19116,14857,14857,19051,14857,16970,14889,12776,19083,19115,16970,16970,17035,16970,14922,17002,19115,19115,14889,16970,14889,14856,14856,10598,6404,4291,8517,12776,21260,21196,19083,19115,17002,6403,2177,2177,97,97,97,6370,8483,6338,4258,4290,8484,19049,19082,14824,27567,34167,32119,29974,27860,36247,36215,21359,15052,6470,8582,10663,10662,2209,64,4291,4258,12841,15085,8550,10663,8615,10728,8550,8582,8582,8582,8582,8582,14889,8420,14759,14759,16872,16807,18888,16775,255},
{29779,27699,25618,23570,23570,23538,23538,23538,23538,27666,27666,27666,27633,27665,31761,35954,42226,42162,38001,33841,31761,27601,27600,27600,25520,23440,21359,21327,21327,21294,23374,25454,25455,27503,27502,27502,27502,27470,27502,29550,29549,31630,33742,35855,44208,52692,59063,59031,59063,50710,44405,44405,44372,44372,46453,46452,44339,44340,44339,42259,42227,40178,40146,40114,42194,44306,44306,44306,44274,46353,48433,48465,50513,50513,50513,48433,44241,42160,44207,42093,37901,33741,35790,35822,35789,31595,33708,31530,29449,31529,33609,35722,33675,31529,31561,37835,39981,37868,39981,39981,42095,31562,29450,29483,18983,16871,25356,29549,31727,19213,19213,25552,21261,21294,10631,8485,8550,14889,10630,16970,21196,21163,23211,21131,14889,12809,6437,8517,10598,12711,12743,16970,8517,6339,8550,10631,12777,16970,16970,10664,10664,12776,12744,10696,14857,17003,10598,10598,10631,8550,12711,12711,10663,10631,10663,19115,10696,12809,16970,12777,12776,12744,12744,16970,19083,19083,14889,12808,12776,14856,12808,12743,10630,6403,10630,8485,8485,12743,10598,12710,12743,14856,16970,23341,19115,19083,21196,17002,6403,2145,2177,2145,2177,65,4290,8483,6370,6371,6403,8484,12743,12743,19017,29778,32087,32055,25780,29941,36215,34102,19246,12874,4356,10663,17068,19180,2177,97,6338,6338,15052,17132,14986,10663,10663,10663,10631,8583,8583,8582,8582,10663,17002,14694,16807,16840,16807,16807,18920,14694,255},
{31859,27699,25651,25618,23570,23538,21458,21457,23538,25586,25586,27666,27634,27633,31794,38034,42194,46354,44242,38002,29681,27600,25520,27600,25520,23440,21327,21327,21294,23374,23374,25455,25455,27503,27503,27502,27502,27502,27502,29550,29581,31630,33742,35855,42160,54772,61143,59031,59063,50678,44405,44373,44372,44372,44372,46452,44339,44339,44339,42259,42227,42227,40146,40114,42194,44306,46354,44306,44274,46354,48433,48465,50513,50513,50513,48465,44273,42160,42127,42093,37933,35789,33709,35789,37902,31595,33708,31562,31530,33610,33641,35722,31529,29449,31529,37868,39981,37836,39981,42062,40046,31561,31627,31628,16870,14758,27469,27469,23374,13168,13167,15215,15215,15215,13070,13005,13004,15117,12874,17068,21228,25389,23276,16937,10664,10663,8582,10695,12776,17002,19083,19116,14824,12711,12711,12744,16970,14857,10630,8518,12744,12776,12776,12743,12776,21195,12711,12743,12711,10598,10630,8550,10663,10631,12744,17067,12777,14954,12809,10663,8582,8582,8549,8517,10630,14857,6404,6372,10597,12743,14856,10663,12775,14856,16937,14889,14856,14889,17002,17002,17002,17002,19115,23342,19083,19115,21196,19115,6371,2177,2177,2177,2177,65,6371,8483,8516,10596,8484,6371,6404,10630,14857,29876,32087,32055,25748,32054,36248,31957,14955,17067,10696,12776,25520,12776,64,2177,8517,6371,17231,12906,12809,10663,10663,8615,8583,8582,8582,8550,8550,12776,16936,12613,16840,16872,16840,18921,18921,16807,255},
{31859,31859,29779,25651,23570,23538,21458,23505,23538,25585,25585,27666,27665,27665,29713,35922,40114,42194,40114,35921,31761,27601,25520,25520,25520,21392,21327,21327,21294,23374,25423,25455,25422,27503,27502,27502,27502,27502,27502,29550,29581,31630,33742,35855,40048,52660,61143,59063,56983,48598,44373,44373,44372,44372,44340,46452,44340,42259,42259,44307,42259,42227,40146,40114,42194,46386,46354,46354,46354,46354,48433,48465,50513,50513,50513,48465,44273,42160,42126,40014,40014,35822,33741,35789,37902,31595,31563,31530,31530,33642,35722,35721,29449,29481,31529,33675,35788,35756,37869,39982,39981,33642,33675,31628,19016,14791,19050,27567,21423,10989,10990,11022,11054,11055,13135,13135,15215,17263,17263,21391,21423,15150,17198,17133,14987,12809,6470,8550,12744,19083,19083,21196,19083,17003,17003,16970,17003,17003,17035,14889,17002,17002,16969,17002,19115,19148,14857,12776,14856,12744,10663,12776,14855,12742,12743,17067,14922,21228,14889,12743,8517,8549,12776,16970,19082,19082,16970,14889,16970,17002,14922,17002,19083,19083,17002,14922,14889,17002,17035,17003,19148,23309,23374,25487,17035,21229,25455,21261,12742,6403,2209,2177,2210,2177,12710,10597,14856,10565,8452,10663,21260,21095,12776,29941,32087,32055,23700,34135,36248,27763,17100,17133,12874,12808,14889,4290,2144,2210,12711,8550,19408,8615,8583,10663,8615,8583,8550,8550,8550,8550,8550,10695,10597,10500,16807,18953,18953,21034,21098,23146,255},
{33939,33939,33972,29812,23571,23538,23538,23537,25585,25585,27633,27665,27665,29713,29713,31793,35922,38002,38034,35954,33873,27601,25520,25520,23440,21360,21327,21327,21294,23374,23375,25423,25422,25422,27502,27502,29550,29550,29550,29582,31630,31630,33742,35855,40015,48499,59063,61143,56983,46485,44373,44373,44404,44372,46452,46485,46420,44339,44307,42259,42259,42227,42194,40114,42194,46386,46386,46354,46354,46354,48433,50513,50513,50513,50545,48465,44273,44208,42127,40014,40014,37902,37869,35821,35821,31563,31562,31530,31562,35722,35722,37802,29416,29449,29449,29417,37868,39981,33675,33674,33674,31562,29417,23144,21129,19016,10533,23341,15052,4390,4487,6568,6600,6601,6665,8746,10891,15085,17133,27697,19441,8942,11022,11022,19246,27502,25323,16969,14889,23309,21261,21228,19116,17003,17003,14890,12777,12841,14922,14890,14890,16970,16970,16970,19115,12809,12744,10664,10664,10663,10696,12777,14889,14889,14954,21260,12809,21228,17003,14889,14889,12776,12809,17035,19083,19083,17002,14922,14922,17002,14922,14922,17003,14921,12809,12776,10696,12841,14954,14922,23309,23342,19115,23309,17068,19181,23342,19115,21196,14888,8549,10630,8517,10565,10598,17002,17035,10696,14922,21294,27632,16838,17035,32054,32087,32054,25780,36215,36248,23537,19245,6535,10696,12808,14921,6403,2144,2145,6469,8713,17295,8550,8615,8583,8583,8582,8550,8550,8550,8550,8550,14889,12646,14694,16840,21066,18920,16840,18953,16840,255},
{42326,40246,42359,34005,23570,23538,23538,25586,27634,27665,27665,27665,29714,29713,29713,31761,35922,38034,35954,33874,33842,29681,25521,25520,23440,21360,21327,21327,21294,21326,23374,25422,25422,25422,25422,29582,29582,29582,29582,29581,31629,31662,35790,35854,37967,48467,59031,61143,52790,46485,44405,44405,44405,46453,50645,50613,46452,44339,44339,44307,44307,42227,42194,40146,44274,46386,46386,46354,46354,46354,48433,50513,50513,50545,50545,48465,44273,44240,42126,42094,42094,35821,35821,35821,35789,31595,31562,31529,33610,35722,35754,37802,31497,31563,33675,35756,42061,39981,39948,31561,31529,33642,31561,23144,12710,12678,14791,23374,14987,2277,4389,4389,4357,4324,4324,4324,4389,8615,14824,23601,13167,6764,8909,8909,19181,21358,23276,16969,14856,23341,19148,12776,10663,16969,12776,10630,12711,16904,14792,12711,12712,10664,10631,8583,14922,14857,12744,12744,12744,10663,8583,10663,10696,10696,17035,21260,10664,19148,12809,12809,12809,12776,14889,10695,8517,14856,12743,8550,8549,12776,10663,10630,12775,4323,6403,10663,10696,14922,17035,17035,17003,21228,19083,14890,8616,14955,17035,21261,23374,10663,17002,14889,10598,14824,14791,17035,19180,21293,27535,25454,23276,12679,21326,32087,34167,29974,27861,36248,36247,23472,15085,8714,10729,12809,10630,12808,19245,8550,2211,10826,15117,8550,8583,8582,8582,8550,8550,8582,8550,8582,8583,19115,16839,18888,18953,18953,16808,16808,16807,10500,255},
{46617,46617,46617,40311,25651,25618,25586,25586,27666,29714,29714,29714,29714,29714,29713,31761,35954,42194,35954,29681,29713,29713,27601,25520,23440,21360,21327,21327,21327,21326,23374,23374,23374,25422,25390,27502,29582,31662,29582,29582,31630,31662,35822,37934,40015,46418,59031,59063,46485,44373,46485,46485,46485,46485,48565,52725,48564,46420,44307,44307,44307,42259,42226,42194,44274,46386,46386,46386,46354,46354,48433,50513,50513,50545,50545,48465,44273,44240,42126,40013,39981,42061,39949,35788,35789,31595,29481,31529,33610,35722,37802,37770,31497,33675,37901,35788,42062,39948,39948,39948,31528,31496,33674,23176,10565,14823,25421,25454,12874,2277,4390,4390,4389,4324,4356,4357,4357,4389,8582,23601,8778,2277,2309,6534,27501,19343,13069,10891,14823,23308,12743,6436,6404,8484,8484,12710,21130,25323,23243,23211,23243,23211,19050,14857,17002,21163,21131,16938,16970,14889,12744,12776,12776,12777,19115,17035,12809,17035,14890,14954,6469,10695,12808,6436,4323,6436,8549,4323,6436,14888,8516,6403,4323,4289,4290,6436,10696,12777,12809,14922,17035,19083,19115,12809,14988,12810,17003,19180,19148,12744,19180,14922,12776,19050,12744,17002,19050,16969,21098,21130,23243,10630,25585,34168,34168,27893,29974,36248,36183,19344,15085,15020,10696,14889,12775,21326,23603,8648,2178,17230,12939,8550,8582,8550,8582,8582,8582,8582,8550,8583,10696,19083,16775,18920,16839,16807,18920,21098,18952,14791,255},
{46585,46585,46617,40311,27731,25618,25586,25586,27633,29714,29746,29714,29714,29714,31761,31761,35922,40082,31794,27633,29681,29713,29681,25520,23440,23408,23408,23407,23407,23375,23374,23374,23374,23374,25390,25422,29582,31662,31662,31630,31662,33710,35822,40014,40047,46386,56918,61143,48565,44405,44405,44404,46453,46485,46453,48532,50613,46452,44339,44307,44307,42259,42226,42194,44274,46386,46386,46386,46354,46354,48433,50513,50513,50545,50545,48465,46321,44240,44174,42093,40013,42061,39949,37869,35789,31595,29449,31529,33610,35722,37802,35721,31496,33675,33643,31529,37900,39948,37868,42061,33641,31496,31528,23175,12677,16936,25389,27534,17035,2277,2309,4389,4357,2276,4324,4357,4357,4389,2276,19082,12776,2276,2276,6437,10630,4357,8550,14823,21097,16969,4324,6404,8484,8517,16936,19082,19083,16970,16970,16970,16970,16970,17002,16970,19050,25357,25389,25389,21196,21228,21228,21196,21163,19115,19083,10630,10695,12808,14922,17035,6436,10630,12742,6403,4291,4323,6403,4323,6403,8516,6403,4322,2209,2209,8484,10630,17034,12841,17067,14987,19116,17035,23342,17100,12777,17035,19115,17002,17002,19115,19115,17100,16970,23276,10630,6404,6404,21130,23243,23275,21162,10663,31956,34200,34200,27861,34167,38328,34070,17165,10793,8615,10728,14889,17002,27763,19344,10566,10566,19409,10728,8582,8583,8615,10663,10663,10631,10663,10631,12744,16937,18952,18855,21001,18888,16807,18855,18952,16904,16904,255},
{42424,44472,46617,46617,36085,25618,25585,25585,25585,29714,29746,29746,29714,29714,31794,31793,31793,31794,29713,29681,29681,31761,29681,27601,23440,23408,23407,23407,23407,23375,23375,23374,23374,23342,23342,25422,27502,31662,31662,31662,33710,33742,37902,42094,42128,46386,54838,61144,52758,44405,44373,44372,44372,44372,44404,44404,46484,48532,44339,44339,44339,44307,42226,42194,44274,46386,46386,46386,46386,46354,48433,50513,50545,50545,50545,50513,46321,44240,42127,42093,42061,39980,40013,37901,35821,31594,29448,31529,33610,35722,35722,35721,31528,33674,35755,33642,37836,37868,37835,37835,37802,31528,31496,27368,21129,14758,25388,27436,23209,14823,14823,12743,10630,8549,8518,6437,4389,4390,2277,14889,19016,14790,14790,14823,8550,4324,10597,21065,21130,14857,6404,10597,23210,23243,21163,17002,17035,17002,17003,19083,17003,19115,12809,14889,14825,12744,16938,29713,33971,19115,21196,25389,25421,25421,21195,6403,6403,6436,8517,10630,8549,14856,19082,10629,8484,12710,8548,6403,8548,8516,6403,8548,4258,4323,12710,14888,14856,8517,14922,17133,19213,17068,19213,19246,12874,12842,21196,17002,16937,21195,12809,19115,19115,17003,16969,12743,21163,25388,23276,21163,19050,17002,34135,36280,36248,27861,36248,38361,29876,15118,12874,10663,12776,14889,17067,27731,15053,6372,10664,19409,8615,10663,8583,10695,12776,10663,12711,16872,16872,18985,21066,21001,18920,21001,18888,18888,20968,18985,23178,16905,255},
{40311,42391,46584,42391,40278,29812,25618,27699,27666,29714,29746,29746,29746,29746,31794,31761,29714,29713,27633,27633,27601,31761,31729,29681,25520,23440,23407,23407,23407,23375,23375,23374,23374,23374,25390,25390,27470,31630,33742,33742,33742,35822,37934,42127,44208,48466,52757,59095,52758,44373,44373,44405,44372,44372,44372,44372,44372,48532,46420,44339,44339,44307,44274,42226,44306,48466,46386,46386,46386,46354,48465,50513,50545,50545,50545,50513,46353,44240,42127,42061,42093,39981,39949,37901,35821,31530,31496,33609,33610,35722,33641,35689,31496,33642,35788,37901,37869,39981,39981,37867,37867,33608,31528,29449,25355,14790,16936,16904,27436,27468,29516,29580,29547,27434,27369,25256,25288,23208,21096,18983,16871,23143,25191,10629,8516,10597,16903,14791,6404,6404,14823,23275,23244,19083,19083,19115,19148,19116,19115,19083,19083,19148,14922,21196,19083,14857,25455,33972,27633,8518,10663,16937,19050,21163,14888,6403,4291,4291,4291,8484,8484,10597,14889,19114,14888,12709,10597,10597,12742,8516,4322,12710,8484,8484,10630,8484,6436,6436,10695,17068,17100,14988,19213,25618,17133,12809,19148,21196,17002,19115,14857,21196,19115,19084,21195,14889,21228,23309,23309,19115,19050,25454,38328,38361,36248,29941,38360,38361,27698,15085,12906,10728,12776,14889,21293,21424,12842,4258,10729,17263,8550,10663,8583,12744,14825,14792,16872,21033,18953,21066,21098,21001,18921,18888,18855,18920,18920,18952,14791,16904,255},
{31925,34037,40311,34005,36118,31892,27699,31892,29779,27698,29714,29714,29746,29714,29714,29714,27633,27633,25553,25553,25553,29681,31761,29681,27601,25488,23439,23407,23407,23407,23375,23374,23374,23374,25422,25390,25422,29582,33742,33775,35822,35854,40014,44207,44208,46353,54805,56951,46485,44405,44373,44405,44404,44404,44372,44372,44372,46452,46452,46419,44339,44307,44274,42226,44306,48466,48466,48434,46386,46386,48466,50513,50545,50545,50545,48465,46353,44240,44174,42093,42093,40013,39981,35821,35821,31529,31529,33609,33610,35722,33642,35689,33641,35723,35788,35755,35755,42061,35722,39947,35721,33576,35756,31563,27435,14790,12678,14823,23308,23308,19083,27567,27599,25486,21196,14856,25453,12709,14790,23209,25355,33675,21031,8452,8452,16904,14823,6404,10630,16937,21163,16970,12809,17003,19115,21196,17002,14889,14890,14890,14889,14922,12777,12809,14889,19116,29746,31891,19148,6405,8518,12744,16969,19050,10598,6404,6404,6403,4290,4323,4291,6404,4323,8549,8516,8516,8516,12710,14823,6403,2177,6403,8516,6403,6402,2209,4290,6435,8517,14921,12906,10729,17068,23374,19116,21261,21261,21196,19082,16969,14921,21196,21196,23309,21195,16970,19115,21228,21228,19115,16937,27567,34102,32022,29909,29974,38328,36247,21391,19245,10663,12776,12808,17035,36182,21424,12809,8420,15052,17198,8550,8583,10663,19115,25454,25324,18920,18920,21066,21099,21066,18921,21033,18888,18823,21033,21098,21163,21162,19114,255},
{25618,29779,36085,40278,40278,36085,34004,33972,29779,27666,27666,27666,27665,29714,29714,27634,25585,25585,25553,25553,25553,27633,31761,29681,27601,25520,25488,23439,23439,23407,23407,23375,23374,25422,25422,25422,27470,27502,33742,35823,35855,37934,42127,44239,44207,48401,54805,52790,44405,44405,44405,44405,44405,44404,44372,44404,44372,46452,46420,46420,44339,44307,44306,42226,44306,48467,48466,48466,46386,46386,48466,50545,50545,50545,50545,50513,46353,44240,44174,42093,42093,42093,39981,35821,35821,29481,31561,33609,33609,35722,33609,33642,33641,35722,37868,37868,35755,37867,37802,39915,35689,31528,35821,31628,23209,27534,19115,14856,25389,23308,16969,21228,23341,25486,19148,14889,25421,8517,14824,21163,25356,23243,12678,16838,10597,21064,18951,14791,21162,19050,16938,14857,12777,17003,14922,19083,17002,14890,17003,14922,14889,14890,10729,12777,10696,21294,23440,34036,21229,10631,12744,14857,16970,14824,14857,16937,16937,12711,6436,8484,4291,4291,4323,4290,2210,4323,6403,8516,10661,4290,2209,2177,2210,2210,4322,2209,4290,6403,4258,8517,10728,8648,17165,12875,17035,23374,21228,16970,17002,19147,19115,21228,21228,23309,21228,14889,17035,19148,19116,19115,21163,27469,10794,10859,12776,17100,21326,14954,17100,19278,10663,12776,14922,27665,36215,23570,12776,6307,17231,12971,8583,8583,10663,23179,27438,25357,21001,21000,21033,21066,21098,21034,21066,18888,18888,21163,17002,23341,25421,23341,255},
{29779,29812,36085,44471,44471,34005,38165,36085,29811,29746,27666,27666,27633,27666,29714,25586,25553,25553,25553,25553,25521,27601,29681,29681,27601,25520,25488,25487,25488,25488,25455,25423,25422,25422,25422,27470,27470,27502,31662,35887,37935,42127,46320,46320,46287,48433,54805,48598,44405,44405,44404,44405,46452,44404,44404,44372,46452,46452,46420,46419,44339,44339,44307,44274,46354,48467,48466,48466,46386,46386,48466,50546,50546,52593,52593,50513,46353,46288,44206,42093,44141,42061,37900,37869,35788,29449,31561,31561,33610,33642,33577,33609,31528,33641,37868,42095,46387,46354,44207,39948,39948,29548,25323,25355,23210,29647,23341,16969,25389,25389,19082,16970,14889,23341,21228,21228,23308,10630,16937,21196,23211,21097,14759,33774,21096,10597,21097,23276,21163,16970,14857,14858,12777,19083,14922,17002,17003,17003,21196,19083,17003,17035,14923,16970,16971,31891,27601,29811,17002,12776,19115,19116,19083,16970,16970,16970,16970,16937,14824,16937,10597,4258,6371,4290,2210,4323,4290,6467,4354,2209,2177,2145,2177,4290,4322,4322,4322,4289,4290,4323,8583,12841,25585,19214,21293,19115,19115,19115,19115,17035,19115,21261,23309,23341,23341,14922,21228,23537,19246,17002,23276,23308,10761,10761,10695,19180,19147,12743,21359,19311,14955,10696,12809,25552,32022,21457,10630,8485,19408,10761,8583,8550,14791,23114,21033,25324,20968,18888,21001,21033,21099,21066,21033,18887,18920,21163,19115,27567,27567,23407,255},
{40279,42391,44472,48664,44471,31924,36085,34037,27699,25586,27666,27666,27634,27666,27666,27634,25585,25553,25553,25553,25521,25553,27601,27601,29649,27568,25488,23407,25487,25488,25455,25455,25422,25422,25422,27470,27470,27502,31662,35855,37935,44208,48433,48432,48400,50481,52724,46485,44405,44405,44405,46453,46452,44404,46420,46420,48532,46452,46420,46419,46419,46387,44307,44274,46386,48466,48466,48466,46386,46386,48466,50545,52594,52594,52593,50513,46353,46320,44206,42093,44141,39948,37868,37901,33675,29449,31529,33609,33610,33609,33610,33609,29416,31529,35787,40047,44306,42160,44175,42094,37901,31760,27502,25389,23308,23276,21131,19082,19115,16970,14857,17002,14857,16970,21261,27664,23341,10598,21163,25422,23243,14758,10565,31596,21097,23176,25323,19051,16970,16970,14857,14857,14922,17035,17003,19083,19115,21163,19051,16970,17003,14923,17036,19083,25456,40376,29779,27665,14825,10663,17035,21261,23309,21196,19115,19083,19083,14889,10662,16937,16969,12743,8484,2210,2210,4355,4355,6435,4354,4290,2177,2145,4322,6467,4354,4322,4354,4289,6403,10597,12775,14955,23472,15021,17036,8551,17035,17035,21261,19148,17035,21228,23341,23341,12842,21261,25487,34135,17198,21163,25421,21163,10826,10760,12808,21358,19115,12743,21456,23570,17165,10696,12775,12742,12906,10728,8452,12808,21521,10696,10663,10663,16872,23081,21033,27535,23211,21001,23146,21066,21131,23179,23178,21065,21098,19050,23374,25552,25487,27600,255},
{46617,48729,48697,48697,44471,27763,27731,27699,25618,23505,23505,25586,25586,27634,27666,27634,27633,27601,27633,27633,27601,27601,27633,29649,29681,27601,25488,25488,25488,25488,25487,25455,25422,25422,25422,27470,27502,27502,31630,35823,37935,44208,48433,50513,50513,50545,50612,44405,44372,46453,46453,46453,48533,46485,46452,46452,48565,46452,46419,46419,46419,46419,44307,44306,46386,48466,48466,48466,48434,46386,48466,50545,52594,52594,52594,50513,46353,46320,44206,44141,44173,39980,37900,37868,33675,29449,31561,33610,33609,33609,31496,31594,29416,31529,33675,37836,44208,44208,42095,42062,35788,27501,27566,31760,31793,33873,33873,33874,31793,21196,14889,12744,8518,8485,17002,25520,21196,8485,21196,25422,27437,16872,10564,25257,25323,27403,16938,16970,14857,14857,14890,19083,27469,31629,29484,25290,27338,29484,25258,25291,27436,23276,19148,17003,31859,34005,23440,27600,12744,12744,14857,19116,23341,27470,23309,19116,19083,17003,17002,17002,16970,17002,17002,12743,8517,6403,4355,4355,4322,4355,2210,2210,4290,4290,4290,4322,4354,4290,4322,12743,14889,19181,21360,15020,14955,10728,14890,14889,19083,21261,23374,17035,25422,23342,14954,21261,25487,31859,19181,23276,27469,19049,10794,10663,12809,21358,14856,12776,25683,25650,10696,12808,12741,8481,2176,8517,12743,15020,23569,17035,14922,17002,21001,18790,23081,23179,19083,23211,23146,25389,27535,25389,21098,21130,21130,21163,23374,25455,27633,27633,255},
{48730,50778,50778,42423,36086,29812,27731,23538,25586,25586,23505,21425,23505,25586,27634,29714,27634,27633,29681,29713,29713,27633,29681,29681,29681,29681,27568,27568,27568,27568,25487,25455,25455,25422,25422,27470,27502,27502,31630,33774,40015,44240,50514,50546,50545,52626,48564,44404,44372,48565,46485,46485,52757,52725,50613,46452,48565,48532,46419,46387,48467,46419,46387,44306,48466,48466,48466,48466,48466,48434,48466,50545,52594,52594,52625,50545,46353,46320,44206,44174,44173,42061,39949,37868,33643,29449,33610,31561,31529,33609,29448,31562,27336,27336,33675,33674,35723,42061,42061,37834,31595,19050,10630,12743,14824,14889,17002,19115,27535,23374,17035,12809,10630,8485,19148,27633,14889,8485,21163,23309,27470,16904,14757,18951,27437,21131,14889,16970,16970,19083,29549,31564,29516,29516,29484,29484,31597,33743,33775,33743,33743,29582,27469,27502,42456,31794,29713,23407,12776,10664,10664,14890,19115,23276,23309,23309,21228,17035,19115,19083,19115,19116,19083,17002,21163,19082,14889,8549,4355,4323,4290,4258,4290,4290,4290,4322,4354,4258,4258,8452,12744,19148,14955,14955,21261,17067,17035,17035,19083,19115,21261,19116,23374,25454,14922,19148,23374,23341,23374,23309,27501,14856,10827,10663,14922,21293,14824,14922,23504,10728,10728,12809,12741,8449,6403,14954,14922,19344,21391,19148,17035,19115,21065,18920,18953,18985,17002,23244,25357,25454,27600,21228,21163,21196,21195,27567,25455,23342,27633,25552,255},
{48730,50778,46617,34037,29812,29812,25651,23538,23538,25618,25618,21425,21425,25586,29714,33842,31794,29713,31762,31762,31761,29681,29713,31761,29681,29681,27601,27601,27568,27568,25487,25455,25455,25422,27470,27470,27502,27502,31630,33742,40015,44273,50579,52626,52658,52692,46485,44405,44404,48533,48533,46452,48533,52725,54805,50645,50613,50612,46419,46387,48499,46419,46387,44306,46386,48466,48466,48466,48466,48434,48466,50546,52626,52594,52626,50545,46353,46320,44207,44174,44142,39948,37900,37868,37869,29449,33610,31561,31529,31529,31562,31562,27336,29416,33675,35755,35754,37867,42028,39948,31628,16970,10598,10598,10598,10598,10598,12743,25487,27600,19148,14922,12776,10630,14890,27568,14824,10598,25389,23341,21163,10630,12645,31563,25389,21163,19018,19051,25356,31629,29450,27338,29549,33775,35889,35922,33809,35954,38067,40147,40147,40147,38002,38067,42424,35920,36019,17035,10663,10664,14857,14857,17003,16970,21228,21229,19083,19115,19115,17002,19116,19148,17003,17002,19115,21229,23309,23308,16969,10630,8484,8484,6403,4290,4290,4355,4322,2209,4258,6404,14922,17067,8615,17035,25455,21294,19115,17003,21228,17002,25454,21261,23342,21260,12809,21261,23374,23374,23374,23341,27501,12809,10794,10663,14954,19148,14856,17034,19212,10728,12841,12808,12707,6368,6502,21424,14955,19344,17133,19148,17035,19148,21163,19050,17002,17002,27567,27503,27535,27600,25487,25422,23309,21261,23341,31761,27600,23407,23439,23374,255},
{50778,50777,44471,31860,31827,29779,25618,23538,23538,23538,25586,23506,21425,21425,31794,35922,33874,33874,33874,33874,33842,31761,31761,29713,27601,25520,25520,27568,25520,25488,25488,25455,25455,25454,27470,27470,27502,27502,31662,35822,40015,48499,56918,52724,52659,54772,46485,46453,46485,48565,46485,46485,46484,46452,50645,50645,48532,50612,48500,46419,48499,46419,46387,46354,46386,48466,48466,48466,48466,48466,48466,50546,52626,52626,52626,50546,46353,46320,44238,44174,44174,39981,39981,37869,35788,31529,33610,33610,33609,33609,33675,31562,29449,31529,33675,35755,39948,37867,39915,44174,33708,12743,12646,12678,12678,12678,10630,14889,27567,29713,23439,14987,12874,10729,16970,21163,14824,18985,23244,21228,19050,12644,35722,27436,17002,17002,23244,25389,23178,25258,27436,31695,31728,33841,35987,35954,35922,35954,38034,40147,40147,38034,38067,42391,44472,31761,33972,29517,14823,12743,17002,16970,17035,14890,14889,19148,19116,17003,19115,17002,14889,17035,14890,14890,17035,23374,21228,23341,23309,21261,19115,14823,19016,14855,6403,6403,6403,4290,4290,6404,14954,19214,14922,19181,23374,17035,12776,14922,21228,19115,25454,23374,27633,14955,8616,23309,23374,23374,23341,23341,23308,10761,12841,14954,27731,29811,25520,10565,6469,10728,12809,12808,10626,6401,8550,17165,21391,25715,17100,19180,17035,21293,19148,17035,19115,19115,25455,27503,25390,27632,23374,23406,23342,12809,21261,25487,25455,21294,23407,19213,255},
{50778,50778,40343,31892,31827,27699,23538,23538,23538,21425,21425,21425,19345,19312,25553,33874,33874,33874,33874,35922,33874,33842,31761,29681,25553,23472,25520,25520,25488,25488,25488,25455,25455,25422,27470,27470,27502,29550,31662,35822,40048,48499,54870,52725,52659,52725,46485,46485,50645,50645,48533,48533,48533,48532,50645,50612,50613,50645,48532,48467,48499,48467,46419,46386,48466,48466,48466,48466,48466,48466,48466,50546,52594,52626,52626,50546,48401,46320,46287,44174,44141,39981,39981,37901,35755,31529,33642,33642,33577,35690,35755,33643,29448,31529,35755,35755,37835,42061,39980,44174,33708,14792,10597,10598,10630,12678,12710,17002,27567,27567,21327,14988,12874,12907,10696,16970,21163,25356,21228,19083,12711,29384,42029,17002,17003,23276,25389,21065,23145,29517,31728,33809,31696,31728,31728,29648,29680,29680,29680,31761,31760,33874,35986,42456,40245,31761,38165,38067,31695,16937,19050,21195,17035,19115,14922,14890,21196,17035,17035,14857,10598,19050,21195,17002,17003,14889,17002,19083,21196,21196,23309,16969,14791,19082,8548,6403,6434,6434,4257,8517,19148,19181,17068,19181,21261,10696,14922,21195,23309,21228,23406,25422,23374,14955,17067,23374,23374,23373,23308,25389,21195,10794,10728,19278,38361,40473,31989,21326,17067,10729,27698,27631,8481,6402,8615,19343,19311,23635,17068,19181,17035,17068,19148,19148,19148,17003,23309,25390,23342,23407,19181,21294,21294,19116,19181,21294,19181,17036,17068,17036,255},
{50778,50778,44536,34005,29812,25651,23538,23538,21458,19377,19345,19313,19312,19312,19344,25553,29714,31794,31794,31794,33842,33842,29713,27633,25521,23472,23472,25520,25488,25488,25455,25455,25455,27503,27470,27502,27502,29550,31662,35822,42128,48499,52757,52692,52660,52725,50645,50645,50645,48565,48533,48533,48533,50645,50645,50612,52725,50645,50612,48499,48499,48467,46387,46386,48466,48498,48498,48466,48466,48466,48466,52594,52626,52626,52594,50546,48433,46320,44206,44173,44141,39981,37868,37868,35755,31529,33642,33609,31529,37802,35755,35756,33609,31528,35755,37835,44174,44206,42028,39947,33642,14824,12646,10598,10630,12711,12711,19082,23276,25422,23439,19246,12939,12940,10761,14889,23276,25422,17002,10598,12645,41995,27371,16970,25389,29582,23177,25291,31663,33841,29615,25422,23244,21131,16970,19050,16970,19050,19051,19051,21196,21229,25488,38263,29681,33907,40245,38035,38067,31696,23243,19082,14889,17067,17003,17003,21196,19116,19116,17035,21392,19213,25225,21131,14889,14857,17002,17003,17035,19116,21228,17002,21260,23341,21196,12775,10596,10594,4257,10630,25422,19115,17035,23374,21261,8583,19115,19115,23309,17035,19180,23374,25422,19180,25487,25487,21261,21195,23308,27567,17002,10826,10728,23537,38361,40441,25618,23504,12776,10761,34102,23372,8481,4256,6501,21457,19377,21522,14890,12874,14922,17035,19148,19148,19148,19115,19051,16971,16938,17003,17036,17068,14956,14923,14923,14923,12874,14955,14987,14987,255},
{50810,50778,46617,36118,27732,25619,21458,21458,21458,19377,19345,19313,19312,19312,19312,19344,21392,23473,27633,27601,29713,29681,25553,25553,23473,23472,23472,25488,25488,25488,25487,25455,25455,27503,27502,27502,27502,29550,31662,37902,42128,50645,54936,52725,52724,50645,52725,52725,52725,50645,48533,48533,48565,52757,50645,50612,50645,52693,50612,50579,48499,48467,46387,46386,48466,48498,48498,48498,48466,48466,48466,52594,52626,52626,52626,50546,48433,46320,44142,42061,44173,39981,37900,37868,35755,33609,33642,33609,33609,41995,35722,35723,37868,37835,37835,37802,46222,44174,44109,39915,33641,33643,31563,27469,16936,19049,14824,14823,12678,29648,19246,21359,12841,8583,8550,12743,16937,23276,16904,12645,18918,31531,21131,25324,31694,23177,25291,31695,27470,21163,21131,19083,19050,19050,19083,19083,19050,19050,19083,19050,19050,16970,25487,34037,19181,31891,27600,31728,31761,33841,31663,27469,23243,25389,19115,17003,17035,23342,19148,17068,19181,19148,21229,17002,8550,8549,12809,14922,14922,17035,19148,21229,21261,23341,27633,21293,25454,14856,12710,21163,25422,23439,14955,23374,19148,14922,21229,19083,21228,17035,21261,25454,23309,16937,25422,29811,21261,25454,25454,25421,14889,10859,10728,27828,38361,40441,23472,23471,10696,14987,34167,29777,19048,6369,6403,19344,21522,32022,23504,10696,12841,17068,17068,17068,19116,19115,16938,14825,12712,12713,12777,12777,12777,10697,10697,12777,12809,14987,14987,14955,255},
{50810,50778,46584,40279,29812,25619,21458,19410,19410,19377,17265,17264,17264,19312,19312,19312,19312,21392,23472,21392,23472,25553,23472,25521,23472,23472,23440,23440,25488,25488,25487,25487,25455,27503,27502,27502,29550,29582,31662,37935,44241,50678,57017,56983,56951,50645,50580,52725,52757,52725,48565,48565,48565,52725,50645,50612,50644,52692,52692,50612,50579,48499,46419,46386,48466,50546,50546,48498,48466,48466,50546,52626,52626,52626,52626,50546,48433,46352,46254,44173,44141,40013,37868,35755,35755,33609,35690,33642,35722,39882,33577,35722,39948,37802,37834,37770,46255,44174,46222,44173,37801,39948,37869,29581,16871,14790,19082,25389,21195,29648,12940,17165,14922,8550,6372,12711,14824,21163,19017,14693,27337,21098,23244,33743,25291,23178,27470,21163,19050,19083,19083,19083,19083,17003,19083,19083,16970,17002,19083,19050,19050,16970,29713,27633,23342,36084,21228,16937,19017,21130,25356,29549,29517,29549,27502,21228,19181,21229,21229,19116,19116,17002,19181,29844,19181,8550,6404,6469,10695,12874,19148,21229,19148,23342,21228,23341,25422,19050,19050,23276,23341,23440,17068,23374,17035,12842,21261,17035,19148,14955,14955,23341,21196,19083,23341,27665,21228,23341,25454,25389,12809,10794,12809,34167,40442,40409,21359,21326,8615,21326,36247,36182,31793,10595,6370,10793,17296,36215,21490,10696,14955,19148,21261,19180,19116,17002,14825,14825,14825,14857,14890,14890,12777,12712,12777,12744,14890,14922,12777,14857,255},
{50778,50778,46617,44504,31925,25651,23538,21458,19410,19377,17265,17264,17264,17264,19312,19312,19312,21392,21392,21392,21392,23440,23440,23440,23440,23440,23440,23440,25488,25488,25487,25487,27503,27503,27502,27502,29582,29582,31662,37935,44273,50678,54904,59064,59096,48532,46419,50645,50677,50677,50645,50645,48565,50645,52725,50612,50612,52692,52692,50611,50580,48499,48467,46386,48466,50578,50546,50546,48498,48466,50546,52626,52626,52626,52626,50546,48433,48400,46286,44173,44173,42093,39948,37835,37835,33641,35722,35722,37802,37770,35689,33609,37867,37867,37802,39915,48401,46221,44173,46253,37833,37835,33676,16903,21129,12678,21162,33841,27502,27567,17101,17068,14922,8550,6372,10630,16969,19049,12678,14790,25322,25291,29549,27404,21097,25356,21131,19051,21163,19050,19083,19083,19115,17035,14955,14890,14889,14890,14890,16970,19050,16970,31826,21261,29681,31826,16937,16937,16904,14823,19082,23243,27436,29582,31695,31696,25455,19116,21229,19116,19116,19116,19148,23538,23505,21359,14954,6436,6403,6501,14954,17067,19180,23406,21261,21228,19148,25454,25487,19116,21228,21326,21294,23407,14955,8583,21229,21228,21293,21261,14955,21228,23341,25422,23341,23341,23308,19082,25454,21228,14922,14954,12776,25617,27697,23439,19246,19245,10696,12874,17035,17034,16969,14822,8450,6338,17133,25780,12907,12874,23439,27600,21294,14987,12841,16937,14857,10663,10630,10631,12743,14856,14889,14824,12776,12808,14953,12840,14954,12776,255},
{52858,48697,46617,36150,27764,25651,23571,21458,19410,19378,17265,17264,17264,19312,19312,19312,19312,21392,21392,21360,21392,21392,21392,21392,23408,23440,23440,23440,25488,25488,25487,25487,27535,27503,27502,27502,29582,31662,33742,37967,46353,50613,54871,56951,56951,50612,46419,48500,50645,50645,50645,50645,50645,50677,54805,52692,52692,52724,52692,52692,50612,48499,48467,46386,48466,50578,50546,50546,50546,50546,50546,52626,52626,52626,52626,52594,48433,48400,46286,44173,42093,42093,40013,37835,37835,33641,35722,35722,37802,37802,33609,31528,37835,39948,39915,42028,48334,46221,46221,46221,37801,35721,35789,19016,23242,12678,23275,31728,25389,25454,19148,14955,10663,6404,6372,10630,19017,16871,8420,16936,21130,33677,31597,21065,23243,21163,21163,16970,21163,19083,14889,12744,14922,14987,10696,8583,10663,10696,12776,12809,14889,14890,31891,21261,29746,23374,14889,14824,16970,14888,14824,19050,21195,27469,31663,29583,21196,19148,23439,19116,19148,17035,19116,19213,21393,10762,27698,19213,10727,6436,6436,8582,14954,19181,19148,21261,17035,23342,25487,17035,19148,21358,19213,27632,19180,14922,23374,23309,23374,21261,12842,12874,23341,23341,23341,25422,27502,21227,25421,19082,16969,12776,12776,21358,17002,12808,23471,17067,10696,12808,14889,16969,14856,14856,19082,8482,8516,12874,8647,19180,27665,27633,21294,12906,10663,12678,8485,2178,32,33,2146,4291,8517,8550,8550,8582,8550,2276,10761,6437,255},
{48665,40311,34005,25651,23539,23571,21490,21458,19410,19378,17297,17264,19312,19312,19312,19312,19312,21360,21360,21392,21392,21392,21392,21360,21360,23407,23440,23440,25488,25487,25487,25487,27535,27535,27503,27502,29582,31662,33742,40015,48499,50677,54903,54871,52757,52724,48499,48466,48499,50645,50677,52725,52725,50677,54805,56918,56885,54804,54805,54772,52692,48531,48499,48467,48466,50578,50578,50546,50546,50546,50546,52626,54674,54674,54674,52626,48433,48400,46286,44173,42093,42060,39948,35787,37835,33642,35722,37802,37802,35721,37867,31528,35690,39916,42060,41995,42028,46221,48334,48334,39914,35721,37869,25356,21129,14758,23276,31760,23341,25454,19148,14922,10696,6436,6371,14791,21130,21098,12645,19050,19018,31630,23178,21065,23211,21163,19050,21195,16938,12712,10664,12744,14922,14955,12809,10664,12809,10664,10663,10664,10696,14890,29746,17035,31891,19115,12711,12744,19050,21195,19115,14856,19083,21228,27502,29647,27567,21228,19148,17003,19116,19083,19116,14922,17036,14987,25552,19279,15020,6501,8516,6403,6436,8582,14922,19180,21228,19148,23342,21326,12810,10761,21293,25519,21261,19148,25454,27535,27568,25487,17133,19245,21261,23341,23342,23309,21195,19115,27502,16969,19147,12775,12808,23471,19050,12776,27664,14986,10696,12809,17034,19083,17002,14922,23374,10596,8517,4291,10663,21261,29745,27600,19213,14987,14987,14824,6437,2146,32,2145,2178,4291,4324,6404,4356,4356,4356,2243,2276,4324,255},
{31925,29812,27699,25651,23571,21490,19410,19410,19410,17297,17297,17265,19312,19312,19312,19312,19312,21392,21392,21392,21392,21392,21392,21392,21360,23407,23407,23407,23439,25487,25455,25487,25455,27503,27503,27502,29582,31662,33775,40016,48564,54871,52757,54838,52724,52692,50579,48466,48499,52692,52725,52725,52725,50645,50645,52725,54837,54805,52725,54804,50612,50580,48499,48467,48466,50578,50578,50546,50546,50546,50546,52626,54706,54706,54706,52626,48465,48400,46287,44205,42061,42060,39948,35787,37900,33641,35690,35722,37834,33641,37901,35722,31528,37835,42060,42028,44141,46221,48334,46188,39914,37802,33675,18983,16871,12678,19050,21228,23308,25454,19181,10728,10663,10598,10630,16937,19050,23244,19050,19051,25389,29516,21065,23275,23276,19083,19083,12777,12744,12777,12777,14857,14955,14987,12777,10697,14890,14857,10696,10696,12745,12777,23440,17036,34036,17002,12744,10663,16970,25389,21196,21196,19148,19115,19083,29680,33907,29680,21261,19116,17035,21196,19115,14890,14890,12776,14922,21425,25683,15020,8550,10662,6435,6467,6436,12775,17034,17035,25520,23375,10697,10729,17100,19148,19181,23309,23374,25454,25487,25487,21391,19246,19180,21261,23341,21261,23341,23309,25454,16969,19082,12711,14922,25487,19082,14954,27697,10728,10728,14922,21228,21228,19083,14954,14922,14954,17230,8582,14921,19115,25519,23406,17068,17101,29843,23504,6535,98,65,2178,2211,4323,4356,4356,4324,4356,4324,2244,2244,2243,255},
{27699,27699,27699,25619,27699,21490,19410,19410,19410,19378,17297,19345,19312,19312,19312,19312,19312,21392,21392,21392,21392,21392,21392,21392,23408,23407,23407,23407,23407,25455,25487,25487,25455,27503,27503,27535,29582,31662,33775,42194,50645,54871,54772,52724,52724,52692,50579,48498,48466,52692,52757,52757,50677,50645,50645,50645,50677,50645,48564,50612,50612,50612,48499,48467,48466,50578,50578,50578,50546,50546,50546,52626,54706,54706,54706,52626,50513,48400,46319,46253,42060,42028,39948,37835,37900,35722,33641,33641,39882,35721,39981,37868,33609,35690,39980,39948,42060,44173,46286,46221,37801,35689,27369,18951,12677,12678,23308,12743,17002,25455,17100,12842,10695,12776,10630,14824,16937,23276,19050,16970,29550,23178,23210,21195,21131,19083,12744,12777,12810,14890,12809,12809,17068,14955,12809,12777,12777,12809,12777,10729,10729,12842,19214,17068,34069,12841,10631,12776,17002,19050,25421,23309,21261,19115,12776,19083,27568,33907,27633,19148,19116,21293,17035,10697,12809,17035,12842,19246,19345,23603,21360,27633,17034,6435,6435,6403,16969,19083,17002,23407,14955,10729,17035,17100,17035,17035,21228,19148,21261,27567,19148,17035,17067,12874,21261,21261,21228,23309,27534,16936,16969,12743,19213,21293,16937,12776,8583,10696,10728,17002,21228,21260,17067,17002,14922,14988,8648,6437,19148,21228,25552,19180,10761,12939,14987,12841,10728,2211,97,2178,4324,4324,8615,6502,4389,6470,4357,2276,2244,4356,255},
{27666,27699,27666,27666,27699,21490,19410,19410,19378,19377,17329,19345,19345,19312,19344,19312,19344,19344,21392,21392,21392,21392,21392,21392,23440,23407,23407,23407,23407,25455,25487,25455,25455,27503,27503,27502,29582,31662,35823,44339,54904,56984,54838,54772,54772,52692,52659,50579,50546,50611,52757,52757,52725,50645,50645,50645,50645,50645,48565,48532,50612,52692,50579,48467,48466,50578,50578,50578,50546,50546,50546,52626,54706,54706,54706,52626,50513,48400,48367,46254,44173,42028,39947,37868,35754,33641,33641,35721,35721,33642,42062,37836,33641,35722,37867,39916,42028,44173,46254,44141,39881,35688,21030,18984,21130,12710,27567,27534,25454,29713,19180,12809,10696,12776,8517,10597,10598,21130,12646,21196,25324,21097,25356,21163,19083,12777,14825,14890,14890,14922,14890,12810,17068,14923,12776,12777,12777,12809,12809,10697,10664,12842,21326,23407,31923,10664,10728,12776,14922,19115,17002,25422,23341,23309,23341,12776,10630,23341,33940,29713,19116,19148,17068,17133,10696,12809,17035,14922,19214,19377,19312,12875,25520,23406,10629,6403,8516,8484,10695,21261,17068,17068,17068,17068,17100,19148,21228,19148,21196,23341,19082,19050,10761,6601,21261,21261,19148,23374,27501,14855,14855,12775,21358,19180,14889,6372,4291,10728,10761,17067,21228,21260,19115,14922,14922,15020,4422,10728,21228,19082,21260,10662,14986,17264,15053,17198,19311,15020,10761,10760,12841,6437,2211,12972,19409,19376,19344,19311,19311,10891,255},
{27666,27666,27666,27666,27666,23538,19410,19410,19410,19377,19377,19345,19345,19344,19344,19344,19344,19344,21392,21392,21392,21392,21392,23440,23440,23407,23407,23407,25487,25487,25487,25487,27503,27503,27502,27534,29582,31662,35855,46452,57049,57050,56984,54804,54805,54772,54739,54739,52626,52659,54805,56918,54870,52725,50645,50645,50645,50645,50645,48564,50612,52660,50547,48498,48466,50578,50578,50578,50546,50546,50546,52626,54706,54706,54706,52626,50513,48432,48367,46254,44141,39947,39948,37867,35755,33674,33641,35722,37802,35754,40013,40014,35754,35689,37835,39916,42029,44141,48334,44107,37801,37769,31628,23275,27567,16904,29647,27535,23341,31695,27502,12809,10728,14955,14889,14823,14791,21098,10598,25357,19017,25324,23244,19083,14825,14890,14858,16971,14890,14890,14825,14857,17068,14922,12777,12777,12809,12809,12809,10729,10696,12810,19214,23472,27730,8550,6437,12777,14922,14954,21196,19083,21228,27599,23374,23342,12744,8452,19082,29746,27633,19149,14923,10762,10729,19149,12809,14987,12809,17100,14988,14988,29778,23472,27600,14823,6370,6403,14856,23342,25520,19214,14987,17067,17067,14955,19148,21228,21196,21261,17035,21196,14987,8682,19181,19180,17100,38132,29614,16902,14822,14921,21326,17034,14889,8648,6470,10696,12841,19147,21228,21228,17035,17067,15020,8649,6470,19180,19180,17002,10663,8517,19311,21555,25781,27861,27828,25715,25780,23635,25650,6535,4520,19539,23733,21653,21620,23701,21522,4650,255},
{27666,27666,27666,27666,27666,23538,19410,19378,19378,19377,19377,19345,19345,19344,19344,19344,19344,21392,21392,21392,21392,21392,21392,23440,23440,23407,23407,23407,25487,25487,25487,27535,27535,27503,27502,29582,29582,31662,35855,44372,52889,57050,54936,54805,56885,54804,54771,54771,54771,54739,54837,59063,61111,54838,52725,50677,50645,50645,50645,50612,50580,50579,48499,48498,48498,50578,50578,50546,50546,50546,50546,54674,54706,54706,54706,52626,50513,48432,48367,46254,44173,39980,39948,39948,37868,35722,33641,35721,39882,35722,37900,42094,37867,35688,37835,39948,44142,46254,48367,46253,39849,35656,33708,21130,25421,16969,31728,25454,25422,29648,27535,10696,10696,8583,16937,14791,14824,19018,14792,23244,21130,25389,21196,14890,14890,19115,14922,16938,12743,10630,10630,10630,14791,14856,14824,14824,14857,14857,12777,10664,8616,10729,23375,25585,25585,6470,6437,8518,12777,14954,14922,19148,19115,23309,27568,23341,21261,14889,6372,14792,27568,27633,21261,12809,8616,14955,12809,12842,14955,14889,12777,19148,36117,29844,25552,27633,17002,8484,19115,23374,17035,17068,14955,17035,17067,14955,17035,17035,19115,21293,23375,19148,14987,8714,21261,19148,19148,40278,25356,16903,14822,17002,17002,14856,14954,21457,10761,10696,12841,19115,23309,21228,19278,25715,13005,2277,14889,23374,19212,10761,4388,12840,21489,23700,27926,25780,27861,29941,27828,23635,15085,196,13070,25846,25846,21652,23733,25846,12973,196,255},
{27666,27666,27666,27666,27666,25618,21458,19377,19377,19377,19377,19377,19345,19344,19345,19344,19344,21392,21392,21392,21392,21392,23440,23440,23440,23407,23407,23407,25487,25487,25487,27535,27535,27535,27535,29583,29583,31662,35855,44339,48565,50677,52757,52725,56950,56917,56885,56917,56884,54772,56950,61111,59030,54870,54838,52726,50645,50613,50612,50612,50612,50580,48499,48498,48498,50578,50578,50578,50546,50546,50578,54674,54706,54706,54706,52626,50513,50480,48367,46254,44141,42060,42061,39948,35787,33641,33641,35689,35722,35722,37868,39916,39948,37801,39915,39980,42028,46222,48334,46188,39881,35688,29449,14823,16904,14791,29615,29647,23341,33874,27568,14922,10696,8485,19050,12711,16937,16969,16905,19050,23211,21228,17002,12744,14922,12809,12711,12711,10630,12841,14922,12809,12743,14823,12710,10597,6437,4587,8714,14857,10696,12777,25552,27698,21359,6438,6470,8551,8551,12777,17003,14922,19116,19116,23309,27599,21261,21261,19083,8452,10598,21261,29746,21294,10729,10696,10729,10729,12809,14955,14922,14890,21261,29811,31989,23505,29811,21229,23341,21294,17068,19148,17068,14955,14923,8616,17035,19148,25552,17035,21229,17067,12809,12874,19180,17067,19181,40278,21129,18983,16903,19115,16969,14824,17100,21423,10696,10728,14954,19147,21261,19180,25715,17296,8649,10696,19148,31923,17132,4421,10662,17066,19278,34135,27861,25781,32120,29909,17166,19214,17100,10794,23668,27959,25813,23765,27894,25813,17165,8648,255},
{29714,29714,29714,29714,29714,29714,23506,19377,19377,19377,19377,19377,19345,19345,19345,19345,19345,21392,21392,21392,21392,21392,23440,23440,23440,23439,23407,23407,25487,25487,25487,27535,27535,27535,29583,29615,31663,31662,35855,42193,44241,48467,50580,50612,54870,56983,56950,56918,56950,56884,58998,61143,59063,54838,54838,52758,52725,50613,50612,48532,50580,50612,50547,48498,50546,52626,52626,50578,50546,50546,50546,54674,54706,54706,54706,52625,50513,50480,48399,46253,44141,42060,42061,42029,37900,35753,33641,33609,33609,37802,37834,37802,39882,39881,42060,42061,42060,44140,48301,46188,41961,35721,21063,16871,10565,12743,25356,16969,21228,27600,19181,14922,12808,10597,19050,16905,21131,16937,14792,19017,19018,21196,14857,12777,16970,10729,8648,10697,17068,23505,31956,16971,21229,19147,6404,6404,6404,2506,4521,10566,14857,14890,27698,31924,19213,6438,6470,8550,8551,8583,10728,17035,14922,19115,19083,19083,27599,23374,23341,19148,8484,8517,21293,31859,23439,10761,10697,10729,10729,10729,17035,14954,21261,19181,27633,31956,27698,16970,25454,23505,17133,17068,19181,19148,17035,17067,21229,19116,23439,19116,19083,8517,4291,8615,14954,14954,23374,38197,18984,16903,16935,17034,14921,12776,19278,19278,6469,10728,17035,14954,19148,19180,21489,10892,4422,12874,17068,25584,14955,10727,21195,14921,21326,38327,27861,32120,34233,23471,19180,31890,31956,19343,30007,27861,19377,23635,25813,23635,15052,15117,255},
{29714,29714,29714,29713,29713,29713,27633,21457,19345,19377,21425,21425,19377,19345,19345,21393,19344,21392,21392,21392,21392,21392,23440,23440,23440,23440,23407,25487,25487,25487,25487,27535,27535,27535,29583,29583,29582,31662,35823,40048,42161,46354,48466,48499,52692,57016,59129,56950,56950,56950,59031,61143,59095,54838,52758,52758,50645,50613,50612,50580,50612,52692,50579,48499,50578,52658,52658,50578,50546,50546,50578,52626,54706,54706,54706,52626,50545,50480,48399,46286,44173,42060,42061,42061,39948,37834,35689,35721,35721,35721,37867,39947,39914,41962,44107,44173,44141,44108,46188,42027,41994,33642,21098,23211,16872,21163,25389,21130,19115,23406,10728,6502,8550,12710,12710,14791,23276,14824,14824,21130,19050,19116,14890,16970,19115,17133,21425,17134,17166,17166,27730,17068,27731,14987,4356,6404,6437,6404,6372,6405,8485,14890,29778,34037,17068,6502,8615,8615,8615,8583,8583,10728,17035,17035,17035,19083,21228,27567,25454,21261,21261,10598,8452,19115,29811,23440,19148,10696,10761,10696,10761,17068,17035,19116,21228,19181,21294,19116,25487,23504,19246,14988,14987,17100,19148,21261,21260,12809,10729,14922,17035,8517,2178,4356,10761,12842,27632,36019,14823,14823,14888,14954,14889,12776,21391,15052,6502,10761,17035,19147,19180,17100,17132,8648,10728,14987,19279,19213,10728,14889,21195,14856,23504,34134,25781,36313,32055,23407,29745,31890,29778,23570,27796,12776,10695,12808,21358,17132,21424,19311,255},
{29714,29681,29681,29713,29713,29681,29681,27633,19377,19377,21425,21425,21425,21425,21425,21393,21392,21392,21392,21392,21392,21392,23440,23440,23440,23440,23440,25487,25487,25487,27535,27535,27535,29583,29583,29583,29582,31662,35823,37968,42128,48466,50547,48498,52692,57016,61209,56983,56950,56982,59063,59096,59095,54838,52758,52758,52725,50645,50612,50612,50612,52724,50579,50547,50578,52658,52658,50578,50578,50578,52626,54706,54706,54706,54706,52626,50513,50480,48334,46253,44173,42060,42060,39980,37835,35754,35721,37802,35754,35721,37835,37867,42060,41995,42028,44173,44173,44141,46221,44140,39914,29450,21066,18953,18985,23276,29647,27567,25454,25487,25455,21294,21294,16937,12645,14758,23277,14824,18985,19050,19051,17035,14890,19083,21261,23407,29876,23505,17166,12907,19180,19180,25651,14954,16936,21162,14824,10630,10630,10663,8583,10663,25519,34069,14922,4389,14922,12777,10664,10696,10664,8583,12809,19148,14954,17002,19115,21196,31793,27600,21261,23406,12711,8452,16969,27568,23374,10729,10696,10761,10696,12809,17100,17100,19148,14955,14922,21261,23406,21391,17166,17068,14987,14987,17068,23374,10662,2242,6534,10761,14922,12776,4323,2210,6501,12874,19213,21228,16936,16904,14889,14889,12809,12808,17197,10793,10696,12841,14954,8583,10728,14954,14987,2244,8583,14987,12939,17100,10663,12743,10597,8517,21457,32022,30007,36346,29876,25519,33971,31891,23537,23667,19278,12808,12808,19114,19115,17100,19310,10761,255},
{29714,29681,29681,29681,29681,29681,29681,29681,25553,23473,21425,21425,21425,21425,21425,21425,21393,21392,21392,21392,21392,21392,23440,23440,23440,25488,25488,25488,25488,25487,27535,27535,27567,29615,29615,29583,29582,31662,33775,37935,42128,48434,48466,48498,52725,59064,61209,59096,59031,56983,59096,61176,61176,54870,52725,52758,52725,50645,50612,50612,50644,52692,50611,50547,50578,52659,52658,50578,50578,50578,52626,54706,54706,54706,54706,52626,50513,50480,48366,46253,46221,42028,42061,39980,35754,35754,35722,35721,35754,33641,35689,35689,44141,44108,42028,44141,44142,42029,46221,39915,33642,23112,16839,18985,19017,25356,29615,25454,31891,29746,27503,16905,16937,12711,10597,21098,23309,16904,16904,19051,14857,17003,19084,17003,14955,25520,31989,25553,17166,17133,19116,17035,19312,17068,23308,27468,19017,12743,12744,10729,15053,12809,23374,34037,10696,6470,10696,14955,12809,14955,10664,8583,8583,12842,17068,12842,17003,21196,21228,31826,29713,23342,25454,12743,6371,14856,27632,23407,21295,25520,12809,10729,10761,17068,19180,17035,14922,17035,21326,19213,19181,19213,14955,14987,17100,25422,6436,4291,2243,6535,10761,14954,14857,6371,2178,8582,12842,12809,12776,10631,6437,4324,6469,8550,10663,10696,10728,10728,12841,10696,12808,10761,21326,8681,17068,17100,19246,17132,10663,12809,10630,8582,23537,25650,27861,30007,27731,27632,27664,25584,19343,15085,10728,10695,17002,27566,19115,19277,17133,12744,255},
{29714,29681,29681,29681,29681,29681,29681,29681,29681,29681,27601,21425,21425,21425,21425,21425,21393,21393,21392,21392,21392,21392,23440,23440,23440,25520,25488,25488,25488,25487,27535,27567,29615,29615,29615,29615,29582,31662,33775,37936,40048,44241,44273,46354,50612,56983,61209,61209,59096,56983,59063,61176,61176,54838,52725,52725,52725,50645,50612,50644,52724,52692,50579,50579,52627,52691,52659,52626,50578,52626,52626,54706,54706,54706,54706,54706,50545,50480,48399,46286,46221,42060,42061,39980,35754,35721,35722,37802,37802,31529,23177,27467,33774,35821,37901,40014,42095,39982,35756,23145,25259,21097,21065,21097,21098,25389,29647,27535,23341,21195,19050,12679,12679,10598,10565,21163,23309,14792,16904,19018,14825,21229,36118,25618,14988,29811,31924,23439,17068,19148,25389,17003,19311,21294,31793,21129,14856,8517,6469,6535,10729,14954,25585,34036,10663,14825,14890,12874,14955,17068,10696,8551,8583,8551,12841,17067,17068,19148,19148,19148,23406,21228,23309,25487,12776,6371,14824,29680,23375,10729,10729,10697,10729,10761,14987,17068,14955,19181,21261,17068,21261,19181,12907,14987,19181,25487,10662,4323,2210,4356,10728,14890,14922,12711,4258,4258,6469,6502,8550,8550,8550,8517,8518,8550,8615,10728,10728,8648,12841,12841,10760,10728,17100,15053,21359,23472,17133,12874,12873,10695,10663,19147,36214,23342,8551,8648,27698,27698,25551,25552,17133,12874,8517,8517,25421,27566,17034,23504,21358,10630,255},
{29713,29681,29681,29681,29681,29681,29681,29681,29648,29681,31729,25585,23506,23473,23505,23473,21425,21425,21425,21392,21392,23440,23440,23440,25520,25520,25520,25488,25488,27535,27567,27568,29615,29615,29615,29615,29582,31662,33775,37935,42096,44241,44241,44241,48467,56950,61177,61209,59096,56983,59063,59096,54870,52725,52725,52725,52725,50645,50645,50644,52725,54772,50611,50579,52626,52659,52658,52626,52626,52626,52626,54706,54706,54738,54738,54706,50545,50480,50447,46286,46221,44140,42060,39980,37802,35689,35721,44074,37834,33674,19017,16871,19049,21162,23243,23275,23308,25421,27469,29582,29615,29647,29615,29582,27502,25421,21195,25422,25389,23243,14857,21163,19082,18985,18985,23276,19083,12679,16937,16937,19084,27666,44569,29844,31989,29909,31957,23472,17101,17100,14889,12776,12842,21293,14920,6468,8517,4356,4323,6502,6502,8615,25553,36117,19213,17002,21130,12842,14955,14955,12777,8583,8615,8583,8583,14954,19181,19213,21228,19115,17002,19115,25454,21229,23407,14856,6371,14791,33807,23342,8616,8648,10729,10696,10696,14955,17068,21326,19181,17100,21294,17100,12907,14955,21294,25454,10695,4355,2210,2242,6437,10728,12841,14889,8517,6371,4291,4323,4357,6437,6437,6437,6469,6470,6502,8615,6535,10696,10761,10696,10728,8583,12842,19245,15019,12907,19213,8615,8614,6436,8516,14987,23504,27600,8518,8583,25650,27763,27698,19180,12939,12906,8517,6437,25453,25486,17099,21359,12874,6404,255},
{29714,29681,29681,29681,29649,29681,29649,29648,29648,31729,31761,29713,27666,23538,23506,23505,23505,23505,23473,23473,23440,23440,23440,23472,25520,25520,25520,25520,25488,27536,27568,29616,29615,29615,29615,31663,31630,31663,35823,37935,42096,44241,44209,44208,48434,54837,61177,61209,59096,57015,59063,59096,56951,52758,52725,52725,52725,50645,50645,50612,52724,54804,52659,50611,52658,52659,52658,52658,52658,52626,52626,54706,54738,54738,54738,54706,52593,50512,50479,46253,46221,44140,42028,39980,37834,35721,37801,44140,39915,37834,18984,12678,14790,16871,14790,14790,14791,16871,16904,23275,31727,33808,33808,31728,31760,27502,12711,21130,25323,27469,31630,25356,21163,21130,27437,23276,21163,10598,16938,14857,21294,29811,44569,27731,38296,32022,31957,29779,29811,23407,12809,19115,19148,17034,6436,6404,4355,4323,4291,4388,8582,8648,25585,27698,19181,14857,16839,19018,17035,12777,17035,10729,8616,12809,12809,8551,17067,17100,21261,19148,17002,23309,25487,23341,19148,21326,14921,6371,12710,29615,21261,8616,8616,8648,10696,10729,12874,21261,17068,17100,17101,17068,14955,14987,19180,12775,6436,4355,2210,2210,4290,6469,10729,12841,10663,6404,6404,4323,4324,4291,4291,6404,4356,4356,4356,8615,10696,14987,14954,10761,10696,10761,25585,19279,10860,8649,8616,8616,8615,8549,6437,8615,12809,12841,6470,4357,6470,6503,10761,6469,6470,12940,8680,10728,8550,12743,10761,12874,8615,6469,255},
{29713,29681,29681,29681,27601,29714,29681,29648,29648,31729,31729,29681,29714,25618,25586,23506,23505,23505,23505,23473,23472,23472,23472,25521,25520,25520,25520,27568,27568,27568,27568,29616,29615,29615,31663,31695,31663,31663,33775,37935,42128,44241,44209,42160,46353,52692,61209,61209,59096,59063,59063,59063,59096,54870,52758,52725,52725,52725,50645,50644,52692,54804,52691,52659,52659,52659,52658,52658,52658,52626,52658,54706,54738,54738,54738,54706,52593,50512,50479,48366,48301,44108,42061,39980,37867,35722,39915,42093,39915,37769,14790,12645,12678,14759,14791,12678,14791,14791,14823,21163,29647,31728,31760,31727,31727,31727,27534,25356,18952,31662,37968,21195,21163,23178,25357,25389,21131,10598,12777,14922,23407,31924,44569,29844,38295,29941,25618,21392,29843,25519,25487,21261,25487,14888,6404,6404,4356,4324,4324,4388,4356,6502,23472,23504,21326,17035,14758,18952,16937,12777,12842,17101,10697,8615,8583,8583,10663,19180,21261,21228,17035,17035,23406,29712,31760,19115,23374,14856,6371,12678,21228,17067,8616,8616,8648,8616,8616,19181,17068,14955,19181,17068,14987,14988,19180,10662,8549,4323,2177,4355,6435,4323,8550,8583,8517,4291,2210,4323,2243,130,2210,4291,2243,2243,2178,2210,6502,19213,23406,23439,17067,8518,25519,21522,21522,19442,19474,21587,21587,21587,21555,21522,19442,19409,19376,15183,13005,15150,19278,10695,2211,2308,4389,10794,6470,8648,12972,10827,6503,2210,255},
{29713,29681,29681,27601,27601,29746,29746,29746,31794,31793,31728,29648,29681,27666,25586,25586,23506,23505,23505,23505,23473,23472,25553,27601,27601,27601,29681,29681,27568,27568,27568,29616,29616,29616,31663,31663,31663,31663,33775,37903,42160,44241,42160,42160,46321,52692,61176,61209,59128,59063,59063,59063,59096,54838,52757,52725,52725,52725,52725,52725,52724,54772,52691,52659,52659,52691,52658,52658,52658,52658,52658,54738,54738,56786,56786,54706,52593,52560,50479,50446,48366,44140,42061,42061,39915,37802,39915,42028,39914,31561,12645,12646,12646,12678,14758,21062,21063,18983,18984,23210,27501,27534,29582,29582,29582,29615,25357,23308,19018,23243,27502,16937,21130,23211,27437,25356,25322,25253,21161,12907,21261,25520,36182,25618,31989,31989,17101,12777,19181,23373,19147,17002,17035,14823,6436,6404,6436,21294,17100,6502,4388,8615,19246,23440,12874,10728,12678,21032,21097,17003,12874,17068,17133,10729,8583,8583,8551,10664,21293,25487,12809,17003,17067,31760,40212,31760,19083,23439,14888,6371,10565,21228,17067,6535,8616,8615,10696,21261,16971,10632,17133,14987,14955,14955,21293,12808,4323,4291,2210,6435,6435,4290,4290,4290,6403,4291,8517,2210,2178,4323,2243,2178,129,2242,2243,130,6469,8582,6469,14954,12906,8517,6372,2212,6503,14954,8616,6535,6568,8714,12939,17166,19344,21424,21456,19376,19409,21490,15020,6437,6404,2276,4487,17296,17230,17198,25813,30039,17100,6470,255},
{29713,29681,29681,27601,27601,29714,29746,29746,31827,33874,31761,29616,29648,29713,29746,27666,27666,27666,27666,25586,25553,25553,27601,27633,29713,31761,31793,31761,31729,29648,29648,29648,29616,29616,29615,29615,31663,31695,33775,37903,44208,44241,44208,42160,44241,50611,59096,63289,61176,59063,59063,59064,59063,54838,52757,52757,52725,52725,54805,54837,52724,54772,54772,52691,54739,54739,52658,52658,52658,52658,52658,54738,56786,56786,56786,54706,52625,52560,50479,50446,48366,44173,42061,42093,39980,37802,39914,44108,37834,35721,31528,31495,31527,31496,29415,35688,35689,31496,31497,27369,31596,29549,29549,29549,27469,29582,29615,25356,18985,21130,29648,23244,27404,23244,25389,23243,33705,31459,33804,19344,23407,23440,23440,17101,34037,29778,19213,14955,21261,27600,23407,19148,21260,12775,8484,6436,10663,31859,19246,12809,14889,23374,27633,23375,12842,6469,12710,16871,21130,25487,12809,10761,19214,12809,8583,8615,8550,8550,14890,21326,12809,10728,17003,21228,36018,35987,29680,17067,23439,14856,6339,12711,19148,17035,8583,8616,12841,21261,14890,14923,19181,21294,17068,14988,23374,12776,97,2243,4291,6435,4355,2210,2210,4322,4290,4290,4290,4290,4291,4291,2178,2210,2210,2210,2210,2243,2243,2210,2210,2211,6469,14824,21097,16903,17001,21259,19180,12776,8648,17165,10761,4422,12808,23373,25454,23406,23406,23406,21325,21293,19180,17034,17067,19245,19278,19375,19408,23635,19377,15151,255},
{29713,29681,29681,29649,27600,27600,27666,27666,27666,29746,31826,31794,31794,31729,31794,31794,31826,33874,33907,31826,27634,27633,27633,27633,27633,29681,29681,31761,31729,31729,31729,29648,29648,29648,31663,29615,31663,31663,33743,37903,44241,46321,44208,42160,44208,50579,61144,63289,61176,59063,59095,59095,59095,54838,52757,52725,52725,52693,52725,54837,52724,52724,52691,52691,54739,54739,52691,52658,52658,52658,52658,54738,56786,56786,56786,54706,52625,52560,50479,50414,48333,46221,44141,42093,42028,37834,39947,44108,39947,37834,35754,35754,42061,42061,44206,44108,42060,41962,46155,44043,44043,44044,39915,39915,37803,35756,29516,23178,18953,21163,29648,27436,29517,25389,23244,23243,27434,33603,29578,17263,29843,23472,12777,21327,36182,25520,21359,19213,19214,34037,25585,27633,29745,23373,14921,10663,17067,27763,21391,19213,19148,27632,34004,27666,29811,29713,12809,12679,16872,23341,21261,10697,10794,19213,10696,8583,8583,8583,8551,17067,25552,19148,14890,14890,21228,31825,33906,29648,17035,23406,12744,6404,10662,19147,14954,10696,14954,19181,17068,17068,17101,17101,19213,17101,21294,8550,97,4356,8550,19115,6468,4290,2177,4290,4290,4290,2178,4290,4323,2178,2178,2242,2210,2177,2242,2210,2210,2243,97,2178,6437,19082,23275,23242,25387,21195,12874,14987,19213,21424,23504,23373,23341,23341,25486,25454,25486,25454,23373,23373,21325,21260,19179,19179,17067,14953,12841,17198,21522,15183,255},
{29681,29681,29681,29681,27568,27601,27666,27666,25618,27666,31826,31826,31794,31729,31761,33874,33874,35922,35955,35987,31826,27633,27633,27633,27633,27601,29681,29681,29681,29648,31728,31728,29648,29616,29615,29615,31663,31663,33743,35855,46289,46321,44208,42160,44208,48434,59031,63289,61176,59095,61143,61144,59095,54838,54805,52757,52725,52692,52692,52724,52724,52724,54772,52691,54739,54739,54739,52658,52658,52658,54738,54738,56786,56818,56786,54738,52625,52560,50479,50414,48333,46221,42061,42061,42028,37834,42028,44108,39947,37834,37867,39948,42094,40013,40013,40014,39980,42028,46221,46254,44141,39949,29450,18951,21097,16838,21032,21098,23243,23244,27405,29582,27437,25389,23211,23276,27534,31594,14855,15052,34037,27665,14922,21326,31924,21326,23375,19181,19149,29778,19246,27600,21261,25486,19115,12744,14955,23537,21392,15020,21326,29778,36084,29746,34004,42457,27633,12809,16937,21130,25487,14955,8649,12907,17100,8583,8616,8583,10664,8551,21359,34069,21294,14889,12744,21228,31826,35987,27567,14955,21358,10696,6372,12678,17035,12809,17035,21327,23505,15020,17068,14988,14987,17100,21261,4324,2276,10761,12777,27633,21358,8516,8483,4290,2177,2210,2145,2210,4290,4290,2178,2177,65,2242,4354,2210,2177,2177,2145,4324,6470,19082,27533,27500,25388,25420,14986,19246,23472,25617,25552,27566,25421,23373,25486,23406,25486,23405,21293,21293,21260,19147,19147,19147,17002,12808,12775,12776,14954,10728,255},
{27633,29681,29681,29649,27600,27633,25618,25619,25618,25618,25586,23506,25553,27601,31762,33874,33874,33874,33874,31794,27633,25521,23473,25521,27601,27601,29649,29681,29648,29648,29648,29648,29648,29616,29583,29583,29615,31663,33743,35855,44240,46321,44208,42128,44208,48401,56917,63257,61176,59095,61144,61144,61143,56950,56918,54838,52725,52692,52692,52724,52724,52724,54772,54739,54771,54739,54739,54738,54738,52690,54738,56786,56818,56818,56818,54738,52625,52560,50479,50414,48333,46221,44141,42093,42028,39914,42060,44141,41995,37802,39948,42061,42029,37836,37868,37901,37802,42028,44141,46222,44174,42062,31564,16871,21097,19016,16870,29517,23243,21130,25356,31662,25324,23243,23243,23342,34037,31924,23472,17100,29811,23407,12841,21294,29746,25520,25520,21326,19148,27666,17101,29714,29680,25455,23406,23373,21261,27763,25715,23570,19246,29778,36052,29746,34004,40376,38230,27698,17166,16937,12775,14922,8616,8616,15020,14987,8583,8616,8616,8551,10696,25617,21326,25519,17100,10663,23374,36019,33906,25454,14955,21359,10695,6371,12711,14922,21261,27666,25684,14988,17068,14988,14987,19181,19148,2211,2211,8583,14922,19149,25617,21293,12710,4322,2177,4291,6436,6436,6370,4290,2210,2177,2145,4290,4290,2210,2145,97,2145,6600,8551,8485,8485,10630,25387,27435,14856,14857,21228,25519,23439,25454,25453,25486,25486,25486,25518,23405,23373,21293,21260,19179,19147,19147,14953,12743,12710,12710,12711,12808,255},
{27633,29681,29681,29681,29681,27666,25619,25618,25618,25618,23538,23506,23473,27634,29746,31794,29746,25586,25553,23505,23473,23473,23440,23440,25520,27601,29649,29649,29648,29648,29648,29648,29648,29616,29583,29583,29583,31663,33743,35823,44208,48401,46288,44208,44208,48400,56885,63257,61176,59095,61176,61176,61144,56950,54837,54805,52757,52692,52692,52724,52724,52724,54771,54771,54771,54771,54739,54739,54738,54738,54738,56786,56818,56818,56818,54738,52625,52560,52527,50446,48365,46220,42093,44141,42028,39915,42028,44108,42027,37834,37835,39981,39949,35755,37901,37835,35722,39948,44142,46222,44142,39982,33710,21097,16871,21129,14758,25323,14791,16937,29549,27404,23244,23210,23243,23407,21327,17166,15052,17100,25552,21261,17002,23374,23407,27698,21327,17003,21229,29811,23375,31859,29681,21228,25454,25454,21293,19181,14890,10696,10728,25487,23309,14955,34037,44569,34036,21358,12841,8549,4323,4291,6502,6502,8649,21359,10761,8584,8616,10729,8583,10761,25650,32021,32021,17133,8616,25454,27600,31793,21261,12842,19278,8582,8517,12776,19148,17101,17101,17100,17068,14988,14987,21294,17035,98,2210,8583,12776,12842,23439,25520,21293,4323,4290,2178,8550,10663,6403,4258,2177,2177,97,65,97,6434,4290,2177,2145,6599,10728,17100,12874,12874,17099,17035,14889,16969,16969,17001,14921,19148,23406,25519,27599,27599,27599,23405,23406,23406,21325,21292,21260,21260,17002,14856,12743,12743,12711,14922,255},
{27633,29681,29681,31761,29714,27699,25619,23571,25618,25618,23506,21425,23473,25586,25586,25586,23506,23505,21425,21425,21425,23473,23440,23440,25488,27568,27600,29648,29648,31728,29648,29648,29648,29616,29583,29583,29615,31663,33775,35823,42128,48433,48400,46288,44207,48400,56884,63257,61176,61144,61144,61176,61144,54870,54805,54838,52757,52725,52725,52724,52724,52724,52723,54771,54771,54771,54771,54739,54739,54738,54738,56786,56818,56818,56818,54738,52625,52560,52527,50446,48365,44140,44141,42061,39947,39882,39947,44140,46221,39947,37835,42061,39949,35755,42095,39948,37835,39948,42094,44174,42062,37902,31629,21130,16871,21097,18984,21130,12710,16936,23244,25324,23211,23178,21163,25553,19246,10794,10761,14987,23472,14955,17068,23374,25520,25585,17101,16970,33971,19214,21262,23341,23309,25486,27599,21260,23439,25520,21294,14955,19180,21261,19148,10696,23505,38295,27665,10695,6468,6404,2243,2210,6404,6470,6503,15020,21359,10696,8616,15019,8616,10696,21359,34102,36215,31923,15052,12907,15020,21326,21293,14987,10794,19278,6469,6437,19148,15020,15020,17101,15020,14988,14987,21326,12808,98,2243,8583,10663,10663,14889,19180,8614,6403,4291,2178,4291,8582,4322,4322,2210,97,97,2177,4322,6434,6402,6434,2210,2209,2210,2210,2210,2210,8647,8647,8517,10663,10728,10728,12808,14987,15019,19180,19180,19212,23373,19147,17034,17066,17002,17002,14921,17001,12776,16969,16968,16969,14856,14987,255},
{27633,29681,29713,31762,29746,27699,25619,23571,23570,23570,23506,21425,21425,23505,23505,23505,23505,23505,21425,23473,23473,23473,23440,23440,25488,27536,27568,29616,29648,29648,29648,29648,29648,29616,29615,29615,29615,31663,33743,35822,40015,48433,50513,50480,46319,48400,56884,61177,63257,61144,61144,61176,61144,56918,54805,54838,54805,52725,52725,54805,54804,52724,54771,54771,56851,56819,54771,54771,54739,54738,54738,56818,56818,56818,56818,54738,52625,52560,52559,52494,48333,44173,44141,44141,39947,37834,39947,44108,44108,41995,39915,42029,37867,37835,42095,37900,37867,39981,42094,46255,42062,35790,29517,21098,21098,23178,23178,21097,18984,23243,25324,23244,23210,23178,19083,21424,14987,6405,8518,17068,27730,21164,23407,27600,25552,21326,17035,21163,36052,21359,23374,16935,16904,27566,25486,21261,27698,25553,25650,21326,21327,23439,23439,19213,19279,21457,21326,10695,6436,6404,4291,2210,4291,8518,6502,8616,19278,17133,8584,6503,8616,8584,10762,34069,36182,40310,19311,10794,8648,8681,12874,14987,12874,10794,17165,10696,19181,19246,17165,17133,15020,14988,14988,21294,8518,2178,4357,8583,10728,10696,10696,14987,12776,6437,8484,8484,4258,4323,6436,4290,2177,65,2210,4322,6467,6498,6434,2177,2209,2177,2210,4290,97,4258,8581,6436,2178,4356,6437,4389,6502,6502,6535,6502,6470,4389,4389,8582,4324,10663,6306,6307,4226,4226,4226,10597,12742,12775,14856,19149,255},
{27633,29681,29714,29714,29746,27699,25619,23570,23570,23570,21458,21425,21425,23505,23505,23506,23506,23505,23505,23473,23473,23473,23440,23440,25488,27536,27568,27568,29616,29648,29648,29648,29648,29616,29616,29615,29615,31663,33743,35822,40015,48433,54673,52593,50448,50480,56917,61209,63257,61144,61144,61176,61144,56950,54805,54837,54837,52757,52757,54837,54805,54804,54804,54803,58931,56851,54771,54771,54771,54738,54738,56818,56818,56818,56818,56786,54673,52592,52559,52494,48333,44140,44109,42061,39915,37769,39914,46221,44140,44107,41995,42060,39980,39949,42095,39949,37835,39981,42061,46254,42062,33709,27404,23211,25356,25324,23211,25324,27404,25324,23244,23211,23178,21163,12842,14988,12809,8550,12842,23505,17199,27502,25552,23407,31924,21327,14955,23276,29648,21327,25453,21097,19115,29679,27599,21325,27665,21327,21391,15020,10729,25683,25585,8681,12973,15085,15053,12939,6502,6436,6436,6404,4291,8485,8583,6503,12875,21424,14955,10761,8648,14987,15020,36150,34069,42423,27697,12907,10826,6600,8649,6536,12907,10794,10794,14987,17101,14955,14955,17166,15020,14988,15020,21294,6436,65,4357,8648,12809,12809,12809,10696,12841,12776,14921,12711,10597,2178,6404,4323,2145,65,4258,4290,6434,8546,6402,4258,2145,2209,6467,4290,2177,4258,8516,6371,6371,6437,6404,6437,6470,6535,8648,6535,8615,6470,4324,6470,8582,12744,6372,6339,4226,4225,4225,12645,12742,10630,12743,14955,255},
{27633,29714,31762,31762,29713,29714,27699,25618,23570,23570,23506,21425,21425,23505,23505,23538,23538,23506,23505,23505,23473,23472,23440,25488,25488,27568,27568,29616,29616,31696,31696,31696,31696,29648,29616,29615,29615,31663,33743,35822,40015,48401,54706,54673,52593,50513,56950,63289,63289,61176,61176,61176,61144,56918,54805,54837,54805,54805,54837,54837,54804,54804,54804,56851,58964,56883,54771,54771,54771,54739,54738,56818,56818,56818,56818,56786,54705,52592,52559,52526,48333,44108,44141,44141,37802,35721,39882,46188,44107,44107,44107,42028,42028,42061,42094,42061,39980,44207,42061,44141,39982,31629,27404,18985,18984,25324,23179,23211,25356,23243,23243,23178,23243,21326,17166,23439,19246,17133,17100,23505,8682,21360,34005,21294,21262,27698,19213,27632,27535,12810,25422,29713,29745,27567,25486,21260,21293,23439,29778,27632,21293,15020,21392,6633,13005,13037,12940,8615,4388,6404,8516,6404,4324,4291,6437,8583,17068,17068,23472,10729,8616,12842,23439,36182,34069,42390,38230,17165,10826,10826,6535,4487,8681,15019,10729,10761,17068,12842,12907,17101,15020,14988,17100,19181,4291,97,2211,8615,12842,12842,17068,10729,4357,8583,19115,14857,12744,4323,2178,6403,2177,2145,4322,4322,4322,6402,4322,4257,2177,6402,6466,6402,4322,2209,4258,4290,6371,4323,6437,6470,6502,8648,8648,6503,6503,4357,6437,6502,6469,6437,8648,19213,21293,21228,10630,10598,12808,8517,12776,10664,255},
{29681,29713,29713,31761,29681,29681,27666,25618,23570,23570,23538,21458,23505,23505,23506,23538,23538,23538,23506,23505,23473,23473,23440,25488,25488,27568,27568,29615,29616,31696,31696,31696,31696,31696,29616,29615,29615,31663,33743,35823,37935,46320,52626,54738,54705,52593,56982,63289,63290,61176,61176,61176,61144,56950,56918,54838,54805,52725,54837,54804,54836,54804,58964,56883,58963,56883,56851,54771,54771,54770,54770,56818,56818,56818,56818,56818,54705,52592,52527,52494,48333,44108,44140,42028,37769,35721,39882,44107,44107,44075,44075,44107,44108,46255,42094,44207,42126,44240,42061,42061,39982,31629,27404,18952,21098,25324,23211,23243,23244,25324,25323,23243,23276,23407,17133,27665,21326,17100,21293,29811,17166,19247,38230,21261,21261,25487,25520,31923,25487,12809,25520,29713,25519,27632,27599,23405,23374,21326,27632,27665,21359,17101,19279,4488,23537,27861,23602,15052,4356,6404,6436,6404,4324,4324,4356,6535,8583,10794,21359,19245,8616,8616,27763,36182,36149,40342,42391,34036,15117,15150,8746,4422,6568,10826,19245,12874,12907,12940,15020,17101,15020,14988,19181,17035,66,98,2243,4390,8648,10762,14987,14987,6437,12809,17035,14857,14857,6404,2145,4258,8484,8484,6435,6402,6434,4289,4257,4290,4322,6434,8515,6403,6402,4322,4322,6370,6371,4258,6437,10728,12777,19116,17068,8746,6535,6470,8616,8583,6502,6469,4422,6535,10761,14954,10728,8582,2243,4389,19213,14987,255},
{29681,29681,29681,29681,29681,29649,29681,25618,23570,23570,23538,23538,23505,23505,23506,23538,23538,23538,23538,23505,23505,23473,25520,25488,25488,27568,27568,27567,29616,31696,31728,31696,31696,31696,29616,29615,31663,31663,33775,35823,37935,46353,54739,54771,56819,52626,56885,63257,63290,63256,61176,63256,61176,59030,54837,54837,52757,54805,54804,54836,56884,56884,58964,58932,61012,58931,56851,54771,54771,54770,54770,56818,56818,58898,56818,56786,54705,52592,52526,52526,48333,44140,44141,42060,39914,35688,39882,44107,44107,44107,46220,44107,46221,46287,44207,44207,42094,44207,42094,39981,37934,31661,27404,18952,23211,25356,29582,27437,27404,27403,27404,23275,23276,23374,17068,25584,23471,19213,14954,14955,17100,21327,34037,23406,23407,25520,31891,36215,29778,12842,27665,31858,21326,23374,19148,12809,21294,25487,25487,17165,21326,27633,21359,13005,21392,21424,21424,15085,6469,6502,6469,4323,4356,6436,4323,6470,8583,8583,14987,23471,17035,8616,27795,34102,36149,42391,42391,40310,29876,17295,15150,8713,6567,4455,10794,10762,12875,12907,17133,17068,14988,14987,17100,12777,33,130,2244,4422,6535,10729,12874,12809,14889,12776,10663,12776,14857,12744,8517,4291,10597,12776,10662,4354,4322,4289,2209,6403,8547,8515,8547,6435,4322,4322,4322,6370,4290,4290,4290,12776,10631,16937,16970,6405,4324,6470,6535,8615,6470,6470,6470,4389,4389,4357,6437,6469,6469,6502,8648,10729,255},
{27601,27633,27601,27601,29648,29648,29648,27633,25618,25618,25618,23538,23506,23506,23506,25586,25586,25586,25586,23506,23505,25553,25521,25520,27568,27568,27568,29615,29616,31696,31728,31728,31696,31696,29616,31663,31663,31695,33775,35823,37935,48532,56984,56950,56884,54706,54804,63257,63289,61176,61176,63257,61176,59030,54837,54837,54805,54837,54836,56884,58997,58965,58964,58964,61044,58931,56851,54771,54771,54770,54770,56818,56850,58898,58898,56786,54705,54640,52559,52526,48333,44140,44140,44140,41995,37769,37801,39914,41994,44140,48334,44108,44140,44173,42094,42126,42062,42061,44174,39980,35822,31629,27404,16905,21131,25356,29517,40081,44306,40080,31662,21163,23309,29713,25552,25520,29876,19246,17068,10696,12809,23505,21392,27633,31891,23341,34037,34102,25553,12842,21326,29745,23439,27600,23406,19148,25585,14922,12776,21293,36019,33906,19279,15118,19278,23439,21326,19213,17067,12809,2276,4356,6469,6469,4356,4356,6503,6535,8681,21359,23407,23440,23537,32021,36149,40343,40310,38230,36149,27828,21521,13005,4487,4389,4390,10826,10826,12907,17101,19246,15020,14955,14923,10663,65,2178,2276,6503,6535,8616,10761,12874,16970,18985,14758,6405,17067,21261,14857,4291,2145,6436,12775,6435,4289,4322,4322,4290,8515,12708,10596,8483,8548,6403,4290,4322,6370,8549,8615,12841,19082,14857,12809,10663,6372,4389,6567,17034,6437,4357,6470,12842,6535,8615,6502,4389,6437,6469,4389,4389,255},
{25521,27601,27568,27568,29648,29648,29648,29616,27568,27601,25618,23538,23538,23538,23506,25586,25586,25586,25586,25586,25553,25553,25553,27568,27568,27568,29616,29616,29616,31696,31728,31728,31696,31696,31696,31695,31695,31695,33775,35855,39983,48532,57049,61177,56918,54772,56852,61177,63257,61176,61176,63289,63256,59030,54837,54805,54837,56949,56917,58965,58997,61077,61077,61044,61044,58931,56851,56851,54771,54770,56818,56818,58898,58898,58898,56818,54705,54672,52559,52526,48333,44140,44140,42028,39915,39882,39914,39914,41995,42028,42061,39915,39947,39980,42062,42094,42094,42094,44142,42061,37869,29549,25323,14791,19018,21131,25323,31630,46387,37968,23243,21163,16937,27535,21294,29746,34102,25585,19148,19148,17035,12841,17067,25487,27633,27600,36150,38328,21392,8649,12776,23406,25519,17100,21326,14922,17068,8550,4291,19180,33938,33971,21360,17166,15020,12841,17067,25519,25519,21326,12874,6535,8615,10695,6436,4323,4356,6503,8616,21359,23374,23342,14988,17133,38230,40343,38230,36150,34101,32021,32022,23602,10989,8746,6535,10794,8714,12907,15053,19214,19246,19181,21261,6437,2178,2243,2309,4422,6503,6536,8681,12842,12842,12841,14824,6437,19148,23342,14890,6404,65,4226,8516,8516,4322,4257,4323,8516,6403,12677,14790,12710,12710,2177,2210,2178,8582,17165,12875,14922,23374,19148,21293,19148,17002,12906,8681,6502,2244,4324,6535,12874,10826,17198,17132,10760,4324,2211,2243,6568,255},
{25520,25520,27568,27568,27568,29616,29648,29681,29681,27633,25618,25618,25586,23538,25585,25586,25586,25586,25586,25586,25585,25553,27601,27601,27568,29616,29616,29616,31664,31696,31728,31728,31696,31696,31696,31695,31695,31695,33775,35855,39983,48467,54871,59064,56950,56950,56917,61209,63257,61176,63256,63289,63256,59031,54837,54804,54805,56885,59029,58997,58965,61045,61077,61077,61044,56883,56851,56851,54771,56818,56818,56850,58898,58898,58898,56818,54705,54672,52558,52494,48333,46221,44108,41995,39914,39914,42027,42028,42028,42060,37867,37803,39949,40014,40014,42095,42095,39982,39948,39981,35756,25290,25291,21163,19018,21098,21163,23243,27404,23243,23243,14824,8517,19148,21294,25552,38328,25552,19148,21293,14987,8550,23406,23374,29746,42457,36183,31989,25553,19116,19018,14987,27665,25519,27665,23471,15019,10695,6404,17035,25519,27632,25650,23570,10794,12906,19213,25585,19245,23439,23471,15019,8615,6501,4388,4323,4323,6502,8681,15020,23472,19116,17003,10696,34004,40343,36182,32021,31989,31989,32021,31989,21456,8778,8680,8680,8713,10859,15053,15020,15052,19213,19180,4324,4324,6535,12906,6568,6536,6535,8648,6535,10729,12809,10729,10696,14922,14955,12809,6404,16870,16837,8484,10629,10662,8550,10696,12842,6470,6437,12743,16872,6306,2145,2210,6534,6534,6535,10957,10827,17068,14954,21261,19181,19180,8648,8681,12842,4389,4324,8647,8615,10695,6503,4422,6502,4389,4324,4356,15085,255},
{25488,25520,25520,27568,27568,27568,29681,27698,29747,27699,27666,25618,25618,25586,25586,25586,25586,25586,25586,25586,25585,25553,27601,27601,27600,29648,29616,29616,31696,31696,31728,31728,31696,31696,31696,31695,31695,33743,35823,37903,40015,46354,50612,54837,56950,59096,59063,61209,63257,61176,63256,63257,63256,59063,56917,54804,52724,52724,56884,56917,58997,61045,61044,58964,58964,56883,56851,56851,56851,56818,56818,56850,58899,58898,58898,56818,54705,54672,52559,52494,50381,46220,44140,44141,39914,39914,44075,44108,42060,42028,39916,35722,40014,40015,42095,42094,40015,37934,35756,33675,33676,27403,25291,25357,21131,19050,21130,21130,21131,23243,25258,22982,21000,25389,23374,27633,29778,21294,23407,27665,19181,8583,27664,21326,33939,46682,36183,36150,21294,17003,12712,10729,21326,29777,27633,25618,21358,8549,6436,10695,19148,25520,27698,25585,12776,6535,21392,27731,12906,15052,21358,19245,10663,6436,6500,6500,6468,6469,6535,6535,17165,23439,17002,14922,31858,38295,34102,29941,27860,29909,31989,34101,29908,6632,8583,8616,8681,10859,15053,15020,15020,19181,19148,6470,6437,8583,10794,6503,6536,6568,12874,6535,8616,8648,10761,12842,10729,12842,12809,8583,25290,23176,6372,8484,12742,12841,8583,14955,17035,10631,8583,12743,14759,4258,64,2177,129,2211,15151,10795,17265,17330,19181,21261,19180,10696,6568,8616,6567,8680,10826,6503,12874,10729,8681,13168,13004,10696,6536,4422,255},
{25520,25520,25520,27568,27568,27568,27568,27666,27699,27699,25618,25618,25618,25586,25586,25586,27634,27634,25586,25585,25585,27601,27601,27601,27601,27600,29616,29616,31696,31696,33776,33776,31696,31696,31696,31695,31695,33775,35823,37903,40048,44241,46385,50546,54804,61176,63322,63257,63257,61176,63256,63257,63256,59063,54837,54804,52724,52724,54772,54804,56884,56884,61045,58964,58964,56851,56851,56851,56851,56851,56818,56851,58899,58899,58899,56818,54737,54672,54607,52526,50381,46220,44140,44108,39882,37802,39914,42027,44141,42060,39980,35722,40014,39983,40014,39982,37869,35756,35757,31563,29515,35855,29516,21131,23244,19050,21131,23244,21163,19051,25161,33253,31239,23211,21261,27600,25487,19180,23374,29746,27665,17035,29746,25487,23374,34005,27666,29843,25520,23374,10630,6404,8582,23341,27665,27697,19213,14921,8582,8549,14922,25553,17198,23472,6438,2309,8811,12972,12906,15019,12841,12841,10694,6468,6468,8581,4388,2243,8648,6568,10762,23472,21293,19050,21326,36215,34134,29941,27860,29941,32021,36182,25715,6567,8615,8648,10794,12907,15053,15020,14988,23472,17100,6404,33,2146,8615,12907,6503,6535,6568,6535,8616,8649,10729,12809,12809,12809,12874,12841,16937,21130,12711,10598,6404,6404,12776,10663,10696,12809,10696,10631,12743,6404,97,97,97,4356,14856,14922,23440,17100,17035,12776,19115,12842,10826,10827,6568,8648,8713,6600,15085,17198,14955,19181,21131,14923,4492,329,255},
{25520,25520,25520,27568,27568,27568,29616,29649,27666,25618,25618,25618,25618,25586,25586,25586,25586,27634,27634,27634,25585,27633,27633,27601,27601,27568,27568,29616,29616,31696,33776,31728,31728,31696,31696,31695,33743,33775,35855,37903,40048,44208,44240,48465,54772,61144,63322,63290,63257,61176,63224,63257,63256,59063,54837,54804,52724,52724,54772,54804,54804,56884,58996,61044,58964,56851,56851,56851,56851,56851,56851,56851,58899,58899,58899,56818,54737,54672,54607,52526,48333,46188,44108,44108,39914,39882,39914,39915,44141,42028,39948,37868,37868,37901,37869,35821,33643,33676,33741,31629,33709,35855,31630,19017,19050,21131,19050,21131,19051,16905,27208,33221,31239,21098,21294,25455,23439,19116,23439,29810,27632,19181,29811,25519,21261,21359,19213,27633,31924,31891,21326,14922,6437,6437,21293,23438,8582,8550,10728,14889,19148,19311,15085,21424,12809,4455,6666,8811,6698,13004,10760,8516,8549,6468,6436,8581,6469,2243,8582,10761,8616,17133,25585,19083,17003,25585,34134,29941,27860,29973,32021,36214,17295,6534,8615,10728,12940,15053,15052,15020,15020,23505,15020,6437,33,32,2113,6469,12907,8681,6535,6503,8616,8616,6535,8648,12874,12842,10761,12874,14922,14922,25422,8550,4324,4258,8517,12809,12809,10728,12744,10696,10663,8550,2210,97,97,14889,14889,15020,19278,19213,17002,16969,17002,19082,17034,14954,12841,10761,8779,10892,12972,12939,15020,14987,12777,17068,21165,8616,255},
{25520,25520,27568,27568,27568,27568,29648,29681,27666,25618,25618,25618,25586,25586,25586,25586,25586,25586,25586,25586,27634,27634,25585,25553,25553,25520,27536,27535,29616,31696,33776,31728,31728,31696,31696,33743,33775,33775,35855,37935,40015,42128,42160,48433,52691,59030,63290,63290,63257,61176,63256,63289,63257,59063,54837,54804,52724,52724,54804,54804,56884,56884,58964,58996,58964,56851,56851,56851,56851,56851,56851,58899,58899,58931,58899,56818,56786,54704,54639,52493,48301,46220,44140,44108,39914,39882,33708,33708,35789,35789,35789,35789,33741,37902,33741,35822,31596,33709,33742,42161,44242,35855,21097,12710,16904,21098,19083,21164,19018,21130,29223,22820,25096,23212,23407,21326,23374,21261,21359,27730,27632,19181,29746,27600,40245,23407,21327,27665,29746,25552,25552,25552,8582,6404,10728,23438,12841,8517,10663,17133,21327,21359,15085,19214,23407,19181,2309,4552,4585,8811,8581,4291,4291,14921,14888,10662,6469,6469,4388,12842,8648,10762,21359,19278,14923,14922,21424,27893,27893,32021,32021,36182,12971,8582,10696,8648,10826,15052,15052,15020,17101,25585,14955,6437,4356,65,2113,2145,8582,14987,6535,4455,6535,6535,6535,6535,8648,12907,10793,8681,12842,14922,14922,6405,4291,6372,4258,6436,10728,10696,10696,10728,10696,10696,8550,2210,4257,17067,14922,15085,15117,15020,17132,16970,14922,12841,14922,14922,14889,10696,8681,6633,19311,6535,8615,10761,12842,12841,10761,12874,255},
{25520,25520,27601,27601,27568,27568,29649,27666,27666,25618,25618,25618,25618,25586,25586,25586,25586,25553,25553,25585,27634,27634,25585,25585,25553,27568,27568,27535,29616,31696,33776,33776,31728,31696,33776,33775,33775,35855,35855,37935,40015,42128,42128,46320,52658,56950,63289,63290,63289,61176,63256,63289,63257,61143,56917,54804,54772,54772,54804,56884,56884,56884,56884,58964,58964,56851,56851,56851,56851,56851,56851,58899,58931,58931,58931,56818,56786,54704,54639,52493,50381,46220,46221,44140,39882,39882,29581,29582,29582,31662,31695,29614,31695,33775,33807,33808,33807,33808,33807,33677,37934,35790,23209,12678,14759,16937,19050,19083,16938,29452,35465,27177,25194,14857,21294,12842,14922,19148,23504,21359,23406,21293,29680,33938,36019,27567,21294,31891,29811,21359,19213,19180,10662,6436,4323,14921,25454,19180,14922,17101,27699,21327,15020,19279,29811,38296,12874,164,2342,6568,8582,4323,6469,27632,29679,25453,14889,12776,4356,10695,10793,8648,12907,21391,17100,12777,12842,17165,27828,32054,34102,29908,8713,10663,12776,10728,12875,15020,17068,15020,17101,21326,14954,4324,6470,8647,2145,4226,4290,10663,12939,6503,6503,6503,6503,6535,6568,8648,14955,12842,8648,10729,14987,12776,8452,12678,4291,2145,4323,12809,10696,10696,10696,10696,10696,6469,14986,21326,14955,10794,15085,12809,10728,10696,14922,4488,10926,4424,8616,6372,8583,15085,23504,4422,4389,4356,6437,4389,6535,10794,255},
{25553,25520,27568,27600,27568,27568,27633,27698,25618,25618,25618,25618,25586,25586,25586,25586,23505,25553,25553,25585,27634,27634,27634,27633,27601,27569,27568,29616,29616,31696,33776,33776,33776,33776,33776,33776,33775,35855,35887,37935,40015,42128,42128,46288,52691,59063,63290,63290,63289,63256,63256,63289,63289,61143,56917,54804,54804,54804,54804,56852,56884,58964,58932,58964,58964,56851,56851,56851,56851,56851,56851,58899,58931,58931,58931,58898,56786,54704,54639,52526,50381,46220,46220,44108,39881,39914,29549,27501,27501,29582,31695,31695,31695,33808,35921,35888,35921,35921,35920,31564,35757,31629,23307,16936,16904,16969,21131,19050,16969,27274,35661,29779,25585,17133,19245,14890,12776,12776,29745,25519,17002,14889,31858,44503,31858,25487,25520,29778,25552,23407,25552,23406,8582,6436,6436,17067,29712,25551,21325,23439,34005,27731,21359,10827,23407,38263,23407,10695,8583,8550,10695,8518,12842,29778,29647,27566,17067,27665,23438,6469,10728,8616,8681,19246,19278,12874,21326,23537,25650,29876,36182,23602,8616,14921,12841,12809,12907,17101,15052,15052,14988,17100,12842,4324,2179,10859,10761,2178,4258,8452,12776,14955,6503,4455,4455,6568,6535,6535,8616,12874,12874,8680,10729,12874,14922,14889,8550,8484,4225,8582,12841,8583,6437,8615,10663,8550,19343,19246,10794,10859,12875,17100,10729,12809,12842,10893,23604,17038,16970,12679,10729,15052,21326,17067,17001,8484,2210,6502,10761,12907,255},
{27601,27601,27568,27568,27568,27568,27601,25618,25618,25618,25618,25586,25586,25586,25586,25586,25553,25553,25553,27601,27633,27634,27634,27633,27601,27601,27568,29616,29616,31696,33808,33808,33808,33808,33808,33808,35856,35856,35887,37935,40015,42096,42127,46288,54739,59096,63290,63322,65370,63257,63256,63257,65337,61176,56949,54804,54804,54803,54803,56851,56884,58964,58932,58964,58964,56851,56851,56851,56851,56851,56851,58899,58931,58931,58931,58898,56786,56753,54639,52526,48333,46220,46221,44140,39849,39882,31662,27469,25389,27436,29517,31629,31630,31662,33775,31662,33743,33775,35855,39984,33644,29549,23406,21262,23342,19114,16969,21196,25455,23341,23342,25585,21359,14955,21261,12776,14922,12809,27665,31891,23406,17035,29713,36117,23341,21229,27730,29778,27633,25487,23439,25519,14954,10630,6404,10695,21293,25519,23406,25552,27665,34037,38328,23636,23570,29778,27535,21195,21195,19115,17002,12776,19148,29777,31791,27534,14954,17067,17034,4323,6437,8648,12907,17133,19278,17133,12744,14954,10697,14987,36182,15150,10663,21228,14922,12874,15020,23504,21424,15052,14987,19181,12841,2243,4324,4422,15118,10761,6339,6371,8484,12776,12907,4455,4422,4455,6503,6503,6535,8648,12842,12907,8681,10729,12874,12874,10728,10565,8451,10663,10662,12841,8615,8615,10696,10663,12874,12777,8615,10793,12874,10761,14922,12777,12777,23407,33973,19085,23244,10599,8681,196,163,10696,12841,10630,8582,8582,12874,15052,255},
{25553,27601,27601,27600,27568,27568,29616,27666,25618,25586,25586,25586,25586,25586,25586,25586,25553,25553,27601,27601,27633,29681,29713,29714,27633,27601,27568,29616,29616,31696,33808,33808,35856,35856,33808,35856,35856,35856,37936,37936,40016,42096,42127,46287,54804,63290,63323,65403,65403,63289,63256,63257,65337,63224,56917,54804,54804,54803,54803,56851,56884,58964,58964,58964,58964,56851,56851,56851,56851,56851,56851,58899,58931,58931,58931,58898,56818,56753,54639,52525,48300,46220,46188,44108,37801,37801,33741,31662,31662,29581,31662,33807,33808,33808,35888,35888,35920,38001,38000,35757,29483,27436,25421,27633,27633,23309,21228,21229,25585,31891,25520,25520,21327,12841,19148,8583,17067,23439,25617,29778,21294,17034,23374,25520,16938,16938,19213,17100,17067,19180,29811,25552,23406,21259,17001,10662,12776,27599,29778,25585,19279,21424,29909,34135,25716,19312,21228,14856,14856,14856,12808,10696,23407,29712,29678,14856,10662,6469,6436,4323,8515,10694,6568,6536,15085,19278,14987,12711,14922,8583,23504,10859,10696,23342,14955,14955,19213,25649,25649,21391,17133,17100,8616,4389,4324,8583,6535,17231,12809,4258,6371,10564,14856,12907,4455,6503,4455,6503,6503,19247,17101,10761,12874,10729,10729,10729,10794,12809,12842,12744,8550,8517,12809,10696,10696,10696,10696,8583,8550,8517,10728,17035,21261,14922,25259,25227,19019,16938,14824,8551,6600,2244,6470,14954,12841,8582,12809,12809,12874,15052,255},
{25553,27601,27633,27633,29648,29616,29616,29648,29681,27633,27633,27634,25586,27634,27634,27666,27666,27633,27633,27633,29714,29714,29714,29714,27633,27601,27601,29648,31696,31696,33808,35856,35856,35888,35888,35856,35888,35888,37936,37968,40016,42096,42127,46287,54804,63290,65403,65436,65403,63289,63256,63289,65369,61175,54869,54804,54804,54803,54803,56851,56883,58964,58964,58964,58964,56883,56851,56851,56851,56851,56851,58899,58931,58931,58931,58898,56818,56753,56719,52525,48332,46188,46188,42027,37769,37801,37801,39948,44142,42094,39982,39981,37869,37901,42095,37935,35887,38000,37935,35756,31564,27436,25357,21163,21228,19050,23341,23407,29746,31859,27600,21228,23374,14954,14922,8583,21325,31858,23406,25486,23374,14889,25519,27600,23244,23407,23472,14955,10696,17100,25650,19245,17002,19114,17002,12808,10663,17035,23504,19279,21359,17133,21327,25520,38263,29843,19213,14922,10696,8550,4324,6438,25552,29744,29646,8549,6468,6436,6436,4356,2243,4291,4389,4455,8681,19246,19246,12809,12776,12809,8616,6502,12841,23374,14988,19246,25715,27828,27828,29908,21359,10826,4454,4455,6600,8648,10728,8648,17230,8582,6338,8452,10565,12808,12907,4487,4390,4422,6535,8616,12842,6503,10761,12842,10729,10729,10761,12809,14922,12776,10663,6436,10663,12776,10728,10696,10696,10663,10663,8517,2177,2242,4356,8550,16806,23145,16871,16871,10598,12776,12809,14889,17067,14922,8615,10728,17165,21391,12939,17132,255},
{25553,27601,27633,29681,29681,29648,29648,31696,31696,29647,31696,29681,27633,27633,27633,27666,29714,29713,27633,29681,29714,29714,29714,29714,29714,27633,29649,29648,31696,33776,33808,35856,35888,35856,35888,35888,35888,37936,37968,37968,40016,42096,42127,46287,54837,61242,65403,65403,65403,63289,63257,63289,65370,63224,56917,54804,54804,54804,56851,56851,58932,58964,61044,61044,58964,56883,56851,56851,56851,56851,56851,58931,58931,58931,58931,58899,56818,56753,56719,52525,48333,46220,46221,44108,39881,39881,37769,37802,46188,46254,44141,42028,44174,42093,39948,39949,35756,40048,35789,31563,31597,25324,25421,21195,27535,31728,29614,25519,25487,25487,23341,19116,23406,21326,14922,6502,21326,31858,21261,10695,8517,10663,33972,34005,23244,25520,23537,14987,12874,17165,21424,12906,12743,8582,6437,8583,12841,6437,17100,19246,19246,10761,6502,19149,25520,34069,29811,27697,25584,23471,12874,14922,27665,27599,19146,8517,6436,6436,6436,6404,6404,4323,4356,6502,6535,15020,21326,19213,14922,19148,10664,6438,14922,21262,12842,12907,23536,25649,27730,31891,29810,10859,6600,6567,6633,4422,8680,10729,10761,17263,8550,6338,8484,10565,12776,12940,4455,4389,4454,4454,4422,6535,6535,10728,10761,10729,10761,10762,14955,10761,8550,4356,14921,8582,12809,10728,10663,10728,10696,10695,4355,128,2177,4258,65,8517,12710,16936,21130,19083,17035,17067,15019,8615,131,17100,23472,23472,17133,15020,255},
{25553,27633,27633,27633,29681,29681,29681,31696,31696,31696,31696,31696,31729,29713,29714,29714,29746,29714,29681,29714,29714,29714,29714,29714,29714,29681,29681,31729,31728,33776,33808,35856,35888,35888,35856,35856,35888,37936,37936,37936,37968,42096,42127,46287,54837,61242,65403,65403,65403,65370,63257,63289,65370,63256,56917,54804,54804,54803,56851,56851,58964,63125,61044,61044,58964,58931,56851,58931,58899,58899,58899,58931,58931,58931,58931,58899,56818,56785,56720,54573,48332,48268,46221,44108,39881,39881,37769,39882,42028,46254,44141,42061,44142,42061,39916,39949,33642,40015,35822,27436,31630,27469,25324,21131,25422,36019,27502,23341,25487,27633,23341,19148,19180,23407,23341,19083,29680,29681,21261,14922,8517,19050,25520,34037,23244,19050,17100,17067,14922,12809,17133,29810,31923,25616,21358,10728,10695,6404,4324,14889,12842,12776,8550,21326,25552,29810,21294,21294,19213,17100,17100,33971,25552,19179,10629,8549,6404,4324,6436,6436,6436,6404,4291,6470,6535,8681,21326,21359,19245,12809,10728,8616,14955,21294,12842,17133,25617,25649,29810,31858,36084,17132,8713,6600,6568,6568,2309,8680,8648,10826,17231,6437,6338,8484,10564,12776,12875,4422,6503,4454,6503,6535,6535,6503,8648,10761,10729,10729,10729,10826,8648,6437,10761,14889,10663,12808,10729,10664,10696,10696,10663,2210,2209,18917,10531,8451,4323,4356,8582,14889,10695,8646,6501,4323,4291,12907,29811,31826,14987,17068,255},
{25585,25585,27633,27633,27633,29713,29713,29713,31728,31696,31728,31729,31761,31794,29714,29746,29746,29746,29714,29714,29714,29714,29714,29714,31762,31761,31729,31729,33776,33776,33808,35888,35888,35888,35856,35856,35888,37936,37936,37936,37968,42096,42127,44207,52691,61209,65403,65436,65435,65370,63257,63289,65370,63257,56949,54804,54803,56851,54803,56851,61012,65206,61044,61044,61012,58931,58931,58931,58931,58931,58899,58931,58931,58931,60979,58899,56818,56785,56720,54574,48300,48268,46221,42027,39881,39881,37769,37769,37769,44141,44141,44108,44141,41995,39883,39949,35722,35756,33775,23276,21196,23244,21130,18985,21163,35986,33873,25454,29746,27600,31859,23406,14954,27633,19082,14889,27600,31859,21261,17002,12743,21196,21327,29778,25389,16969,10630,21228,16969,17003,23439,27665,29777,27665,23504,19212,8549,6404,8517,8485,6404,6437,14922,29811,31859,21261,21326,19148,19180,12874,17067,33938,27599,8581,8517,8516,4323,4291,4291,4324,4324,4324,4356,6437,6535,6568,17100,23439,17035,2243,4389,10761,19181,21359,19213,21391,25649,27697,29810,31891,38164,27665,8745,10826,6632,6600,4519,4422,12841,8648,12940,17198,6404,6339,8484,10564,12776,12907,6503,4422,6535,8681,4422,6503,6503,8615,10729,10761,10794,10761,12841,10761,17198,12808,12743,10630,12809,12809,10696,10696,10696,8550,2177,64,10531,18886,14725,12643,12708,16837,160,160,128,14817,14785,4322,10793,19245,15019,17067,255},
{25585,25585,27633,27633,27633,29713,29713,29713,31761,31761,33809,31761,31794,31826,29778,29746,29746,29746,29746,29746,29714,29714,29713,29714,31762,31761,31761,31761,33809,33808,35856,35889,35888,35888,35888,35888,35888,37936,37936,37936,37968,42096,42127,44207,50578,59129,65403,65468,65436,65370,63257,63289,65370,65337,58997,54836,54803,54803,56851,56883,61044,65238,63125,61044,61012,58931,58931,58931,58931,58931,58899,58931,58931,60979,60979,58899,56818,56785,56720,52525,50380,48268,48268,44075,39881,41995,41995,39882,35689,42029,41996,39882,41995,42027,39948,39981,39982,35789,35888,25422,23341,21196,19017,21131,19083,29647,23308,23341,27698,25487,29746,23407,19213,29779,14857,12808,25519,23374,23374,19083,19148,21261,23439,23439,31825,33905,29647,29745,16970,21293,19115,27567,31890,29777,25584,21358,10695,12808,21228,23308,16937,6437,17068,31891,23406,17035,19148,17035,17035,14954,23439,33905,29614,10630,6470,6634,17067,8550,8582,4356,4356,4356,6436,4323,6470,6568,12874,21294,8647,2275,2243,6502,19213,19247,17101,23536,25649,27729,29810,34003,38164,38132,17165,8713,10794,6600,6600,4487,4454,14954,6567,12972,15052,6371,6371,10532,10564,12743,14987,4455,6568,23472,8583,6502,6502,6567,6535,8680,10729,10761,12842,10729,12841,12841,12744,6372,10631,12776,12841,10696,10696,17068,12874,2210,96,2209,6370,10595,4321,2241,128,128,129,2240,8513,8480,128,6502,17100,17067,255},
{25586,25585,25585,27633,27633,27665,29714,29713,31761,33809,33841,33842,31826,31826,29746,29746,31794,31826,31826,31826,29746,29714,29713,29713,31761,31761,31761,33809,33809,35857,35856,35889,35888,35888,35888,35888,35888,35888,35888,37936,37968,40047,42127,44207,50545,59128,63322,65403,65403,65370,63224,63289,65370,65337,59029,56884,54803,54803,56851,58964,63157,65238,63157,63125,61012,58931,58931,58931,58931,58931,58931,58931,58931,60979,60979,58899,56818,56817,56752,54574,48300,48267,48268,44107,41929,44075,41995,39915,37802,39948,37834,41995,42027,44108,39948,44175,44207,37869,35887,25357,21163,25454,23341,25421,19115,21228,23309,23374,25552,29746,27633,21326,23406,29811,21261,19148,23406,19116,21196,19115,14890,19148,25520,25520,33840,40179,33873,29648,23309,21261,17035,10695,27567,23406,19180,19213,23438,25519,21261,19147,10695,4323,14954,34004,31858,23373,19115,14922,12809,8583,27632,31759,25388,14824,8715,8945,25683,8648,6568,8582,6469,6437,6469,8484,8485,6568,10761,15020,8582,4356,4324,4324,19213,19214,17101,23536,25617,27730,31891,36084,38164,36084,31890,12939,8680,8745,4487,4487,4520,8680,14954,6535,15084,15019,6339,6371,10564,10564,14856,15020,6503,8615,6503,4422,8681,8648,6470,6502,8616,8681,10729,10761,8648,10728,14922,12809,17035,14922,10663,12809,10696,10729,17133,8615,2242,96,96,128,128,129,128,96,96,64,96,129,128,10760,15019,12939,255},
{25585,25585,25585,27633,27633,27665,29713,29713,31761,33809,33841,33842,31826,31826,29746,31794,31826,35986,38067,35954,33874,31794,31794,31794,31794,31761,31761,33809,33809,35889,35889,35889,35888,35888,35888,35888,35888,35888,35856,37936,37968,40047,44175,44207,50545,59096,61209,63290,65403,65370,63256,63289,65370,65370,59030,56884,56851,54803,56884,58964,63157,65238,63157,65205,61044,58963,58931,58931,58931,58931,58931,58931,60979,60979,60979,58931,56818,58866,56720,54574,50380,46187,48267,44107,41962,44075,41995,41962,39914,37835,39915,39947,39947,42061,42093,42061,42094,37934,37969,21130,21098,23308,12711,14792,14824,14825,21196,23309,25553,25520,29746,19181,12743,23407,17068,23309,23341,19115,23373,25487,21293,19148,23374,23439,21260,27533,31825,27535,29713,29778,23406,6436,19115,29648,19083,14922,34004,31923,27632,21358,17067,10663,21260,29777,23471,21294,21293,19180,17067,17067,31826,31791,27533,16969,8747,8879,31957,31990,15053,19246,14987,12809,8615,4356,4291,8615,8616,10761,8648,4356,4388,8549,19213,19246,17133,17166,25584,29843,31891,36084,38196,36052,34004,27697,12939,6535,4389,196,4487,8648,10761,12874,6535,17165,14954,6338,8484,10597,10596,16969,15020,6535,4390,4422,8681,17100,4422,6502,6503,6535,8680,8680,10761,8648,8615,10696,17068,17100,10696,10663,12809,10728,10696,10695,8582,4355,2145,96,96,96,96,96,64,96,129,128,2209,12906,15019,12939,255},
{25553,25585,25585,27633,27633,29681,29713,31761,31793,33809,33809,33842,31794,31794,31794,31826,33906,40147,44275,38035,33874,33874,31826,31794,31794,31761,31761,31729,33809,33841,35889,35889,35888,35888,35888,35888,35888,35888,35856,35888,37968,40047,44175,46287,52659,59096,59161,61242,65403,65403,61143,63256,65370,65370,61110,56884,56852,54803,56883,58964,65238,65238,63157,63125,61044,58964,58963,58931,58931,58931,58931,58931,60979,60979,60979,58931,58898,58931,56720,52493,50380,48267,48235,46188,41994,41995,41995,39882,39915,37835,37802,35722,39916,39948,42094,42062,44240,40014,35888,31662,25357,23244,10533,14889,23406,21261,19115,19115,23374,16971,21261,21261,12743,21229,17035,21261,21163,19050,25454,31859,23374,19116,21261,25552,21326,19116,23341,27568,31826,29745,12872,6437,25519,34004,29745,19180,29843,36149,27632,19148,14954,10695,19147,27795,29941,25715,25682,23569,19311,14954,31825,29678,27501,23373,31825,23439,34037,38295,19344,21424,23504,17165,8615,6436,4356,6469,8616,8681,10761,12841,10694,10662,17101,21424,21489,25683,23570,27763,31890,36084,38164,36052,34004,29810,25616,10891,6600,4389,4390,14986,8680,8680,12841,6567,19246,12841,6371,8484,10564,12644,14856,17068,8648,4390,6503,6502,4422,6502,6535,6567,4454,8616,10761,8681,10729,8648,8615,12874,17035,14921,8518,12809,10761,10663,10696,10663,6437,4323,2210,97,64,64,64,96,129,96,6501,17132,15019,15019,255},
{23505,25553,25585,27633,27633,29681,29713,31761,31793,33808,33808,33841,33874,31794,31794,33874,33906,42195,44307,35954,33874,35986,35954,31794,31794,31793,31761,31729,31761,33809,35889,35889,35888,37937,35888,35888,35888,35888,35856,35856,37936,40015,42127,46319,54837,59096,59161,63290,65403,65435,63223,63224,65370,65370,63223,56916,56852,54803,56851,58964,65238,63157,63157,63125,61044,58964,58964,58931,58931,58931,58931,58931,60979,60979,60979,58931,58899,58932,56752,54573,50412,48267,48268,44108,41995,41995,39915,39882,37834,35721,33576,35722,37901,37835,35755,39949,42095,37901,31596,31695,29648,25389,14824,21196,17067,17067,17067,12809,19115,21261,21261,21196,12777,19148,19083,29713,23243,16937,25454,38165,21261,12744,29713,25552,23375,36117,12776,27567,33906,23405,8581,6404,10663,29746,27697,14953,27698,34004,27567,19115,12809,10631,17067,31989,27893,27860,25780,25781,19376,17067,31825,29646,23340,27697,25584,17034,38328,36183,19376,21457,23505,23570,14986,4355,4324,6404,10729,8648,10762,17100,14888,10695,19213,17101,14988,23472,21360,21326,36019,38164,36084,34004,31923,29810,27730,23536,15084,6600,4389,12874,8680,2309,10793,10761,8648,19278,12776,6338,8451,12645,12645,14856,17035,8648,4422,6503,4390,6535,6535,6502,4422,4422,10826,10761,8648,10729,8648,6567,10729,14954,10630,6371,10663,10761,8615,10696,10696,8583,8550,8517,4323,2177,96,2177,64,64,8582,17067,17132,15052,255},
{23505,25553,25585,25585,27633,27633,29713,31761,31761,33808,33809,33841,33841,33842,33842,33874,33874,40114,46354,42226,42194,44275,42194,35954,33874,31793,31761,31761,31761,33841,35889,35921,35889,35889,35888,35856,35856,35856,35856,35856,37903,40015,42095,48400,56982,59064,61209,61242,65403,65435,63256,63224,65370,65370,63223,56916,56851,56851,56851,58931,63157,63157,63125,63125,61044,58964,58964,58931,58931,58931,58931,58931,60979,60979,60979,58931,54705,54672,54606,52461,50380,48267,48268,46189,44108,42027,39915,41963,37769,35688,35721,35755,37836,35755,35755,37868,40014,42095,33709,29516,31695,29615,27502,19115,8582,8550,8550,8615,8615,25487,34037,23472,21229,25454,19115,23341,33840,27502,25455,31859,21261,10728,29811,31924,17035,34004,17101,17100,25487,25454,12775,8549,6469,25552,21293,12808,36084,36084,25487,21260,23407,23439,14921,19114,23406,25519,23439,23439,17034,21260,31824,29646,23340,27730,12873,8648,36247,34037,19312,15020,19246,21457,21424,8615,6436,6404,10696,10729,8681,17100,17100,12809,23375,25520,12875,17133,25553,17068,29713,40277,36116,34004,29843,27730,25649,25617,23504,17197,8713,4389,4389,4455,2374,12874,10761,8681,19278,10663,6338,8484,12645,12644,14823,14955,10761,6535,12972,4455,4422,10761,17068,4422,4422,4454,8615,8648,8648,8681,8616,8583,10501,6307,4259,8582,12841,10696,10663,10695,8615,12809,10631,8550,6404,4258,32,32,10728,17034,19213,17132,255},
{23505,25553,25553,25553,27633,27633,29681,29713,31793,33808,33808,35889,35921,35921,35922,33874,35922,40114,44274,50578,48467,46387,44307,40114,33874,31761,31761,31729,33809,33841,35889,35921,35889,35889,35888,35856,35856,35856,35856,35856,37903,40015,42094,48400,56983,59128,61209,61242,63322,65370,61110,63224,65370,65370,61143,56884,56851,56851,56851,58931,63157,63157,63157,61076,61044,58964,58963,58963,58931,58931,58931,58931,60979,60979,60979,58931,54640,48268,48267,48299,50347,48234,48268,46188,44042,39881,39882,37802,37834,37768,39947,39916,35755,33676,33643,35788,40014,42127,33709,27403,31662,23210,23243,14890,8582,10631,8583,8615,10663,23374,23375,21294,19181,23407,27600,16970,14922,21131,21261,25520,17068,17035,25520,29811,19083,23439,15020,10696,23374,29713,25617,14921,10663,27698,21261,10662,31826,33971,23406,21293,29778,27600,17068,6469,6404,8550,8550,10663,10597,14954,29712,29680,21261,29811,10728,10793,40441,27796,19344,21229,21261,23537,27763,17133,8582,4356,14954,14988,10729,12842,14987,14955,27633,31827,21327,23472,21359,17068,27567,40277,36084,34003,29842,29843,27763,25715,25715,23635,17230,10826,6633,8714,10826,10859,14987,10729,10794,17198,8550,6338,8483,12645,12644,14856,17067,12939,21392,10794,4454,6503,10729,6502,6502,6535,4422,6535,8648,8680,8648,10696,8550,8420,6372,8517,12776,12841,12808,8615,10728,10696,8583,6502,6502,6436,2210,4356,14987,17099,19245,17034,255},
{23505,25553,25553,25553,27633,27633,29681,29713,31793,33841,35856,35888,35921,38001,38002,35954,38002,42162,44274,44274,44306,42226,40146,38066,35922,31761,31729,31761,33809,35921,35889,35889,35889,35889,35856,35856,35856,35856,35855,35855,37903,40015,42095,46320,56983,59161,61210,63290,63256,63191,61110,65304,65370,65370,61110,56884,56851,56851,56851,58964,63157,63157,63157,61077,61044,58964,58963,58963,58931,58931,58931,58931,60979,60979,60979,58931,58899,50413,48267,50348,50348,48267,48268,44107,44075,39849,37768,35688,39915,35688,44109,44109,37835,35757,31563,33675,42127,42160,40048,27371,27469,23275,21163,19083,8550,8583,10663,10663,12808,25487,16970,10663,17002,27600,21228,17003,12744,16904,23374,21326,14954,19148,27600,27665,29811,27665,23439,17100,17067,31891,25487,8549,6436,8615,10695,10662,31858,31825,23373,25454,38197,27534,23375,17100,8549,6436,4323,6404,8550,19214,29844,19149,25585,29811,12775,19246,38328,25683,17166,25454,23374,21359,17165,15019,12842,17035,19116,21294,19214,12842,12875,21326,23407,27601,33939,29779,27666,21294,23342,36083,36084,31923,29842,27729,25617,23537,23504,21391,21423,23504,12971,4389,4422,8713,8713,17099,10761,12874,19245,8517,6338,8484,12645,12644,16969,17100,14987,6535,4422,6535,4422,6535,6535,4422,4422,4422,4454,6567,8648,8648,8648,8615,8615,8615,12808,6469,12776,12841,12841,10761,10728,6502,6470,6502,6502,8648,17165,19245,19180,14855,255},
{23505,25553,25553,25553,27601,27633,27633,29681,31761,33841,35888,35888,35888,37969,38001,37969,38001,40113,42162,42194,46387,42194,40114,38034,35954,33874,31761,31761,33809,38002,37969,35889,35889,35889,35856,35856,35856,35856,35855,35855,37903,39983,42094,46319,56983,59162,61242,63322,63224,63191,63256,65337,65337,65370,61143,56884,56851,56851,56851,61012,63157,63157,63157,63125,61044,61012,61012,61011,58931,58931,58931,58931,60979,60979,60979,58931,58898,56785,54672,52493,52460,50347,48300,44074,44074,41995,39882,35689,39915,35656,44141,48335,42028,35821,31595,35756,40014,42127,37935,31630,25389,31793,21131,21196,19116,12809,10631,10631,16969,31859,23374,12841,12776,27535,23341,19115,12743,16904,19147,8550,10663,14955,23407,25552,25584,29810,27697,23471,17100,27632,25519,12743,8549,8517,6436,14921,29811,23472,21228,19082,31793,31891,23504,14955,6469,6469,6436,6404,8583,23505,34103,23408,21359,29843,16968,27698,40409,23635,15085,12841,21359,19246,19278,15019,10858,17133,17100,19213,21326,12907,12842,21294,25552,23407,25487,25552,27698,25585,21294,21261,34003,29842,29778,27697,25617,23504,21423,21359,23471,23504,25584,17100,2276,4356,6567,12906,19180,10761,15020,19246,6404,6338,10532,12645,12677,19147,19213,17100,8648,4390,4422,4422,4422,4422,6502,4422,6503,6502,6502,8616,8648,8648,10728,8648,8648,8647,6501,8549,14954,12874,8615,6502,8615,4421,4421,6502,12841,14954,14954,19212,255},
{23505,25553,25553,25553,27601,27633,27633,29681,33809,33841,35888,35888,37968,37969,37969,38001,38001,40049,40081,42194,44275,40114,40114,38034,38002,35954,33841,33809,33841,35922,35922,35889,33809,33809,35856,35856,35856,35856,35855,37903,37903,39982,42094,46287,56918,61210,61210,63322,63322,63256,63256,65337,65337,65370,61143,56916,56851,56851,56851,61044,65205,63157,63157,63157,61044,61012,61012,61011,58931,58931,58931,58931,60979,60979,60979,58931,58898,58931,58865,54605,52493,50315,48268,44074,44042,42027,39916,35689,35688,35688,46221,50447,44174,39982,35789,39982,37901,40015,42194,35921,27470,33971,16937,25389,33874,17036,10696,8550,19083,23342,19180,12809,14857,23309,29680,27600,21196,21130,21162,12677,12710,21294,21229,23374,31858,25519,25487,23374,17002,8550,19181,25585,19148,10630,4356,25617,38360,34135,23505,25520,27666,34037,27731,21359,10728,6469,6437,6437,10631,27699,32022,34038,25552,17034,8516,21423,38296,21457,17133,8615,10728,19247,23537,17132,10759,6502,8647,8615,17100,12874,6503,19246,25520,25488,27600,27600,25585,21359,19213,4356,23438,29810,27729,25617,25617,23504,21391,21391,21423,23504,25584,27665,17100,4324,8583,8713,17100,19180,10761,17133,19213,6371,6371,10564,12645,14790,21260,19213,19245,10794,4422,4422,6503,4389,4422,6502,6502,6535,4422,4422,6503,8648,8648,8680,8648,8648,10728,8583,10761,10696,10695,6502,4422,4389,4389,4389,4357,6469,8549,6469,255},
{23505,25553,25553,25553,27601,27633,29681,31761,33809,35889,35888,35888,37968,37969,38001,38001,38001,40049,40081,42194,42227,40114,38034,35954,35954,38034,35922,33841,33841,33841,33841,33841,33809,33808,33808,35856,35856,35856,35855,37903,37903,39982,42094,46287,54804,61209,61242,63322,63322,65370,65370,65369,65337,65370,61110,56884,56851,56851,56851,61044,65237,63157,63157,63125,61044,61044,61011,61011,58931,58931,58931,60979,60979,60979,60979,58931,58898,58931,58865,54573,52492,50315,48268,46155,44042,42027,42029,37769,37769,41962,48334,50414,46254,39949,39982,37901,39982,42161,40114,31663,29550,27534,12711,21195,35954,23276,10663,10631,23342,29648,19050,12744,19083,27567,36019,27600,25389,19049,23274,14790,12645,14888,23342,21228,23341,19083,16970,14824,10630,14856,19116,25552,21228,17002,8550,21424,25618,34037,31989,25617,27698,31924,27665,27664,21293,14954,12808,6469,8582,29812,31990,34005,25520,14823,8516,25617,31957,15118,12874,12874,12841,23570,19311,12873,8582,4356,4356,6469,12841,12907,6503,23440,25520,23407,25553,27601,23439,12874,14955,2146,6469,25552,27697,25617,23536,23536,19311,21391,21423,23504,25584,27665,15051,2211,8518,10761,10794,19213,19148,10761,19245,17099,6371,6371,10564,12644,21163,23374,23374,23406,14987,6503,12907,8746,4421,6502,6535,4422,4422,4422,4422,4422,6535,8648,6568,8648,8680,8648,8615,6534,10696,14954,8615,4421,4389,4389,4389,4389,4356,97,255},
{23505,25553,25553,25553,27633,29681,29713,31761,33808,35888,35888,37968,37968,37968,38001,38001,38001,40049,40081,42162,44307,42227,38034,33874,33842,38034,33874,33809,33841,33809,33809,33809,33809,33808,33808,35856,35856,35856,35855,37903,37935,40015,42094,46255,52658,61177,61242,63290,63322,65370,65403,65370,65337,65369,61110,56884,56851,56851,56851,63125,63157,63125,63157,63125,61044,61044,61011,61011,60979,60979,58931,60979,60979,60979,60979,60979,58898,58899,58931,54573,52428,50314,50348,46187,44042,42027,41996,37802,41995,48300,50446,52494,50414,44142,42062,37869,37868,42094,44242,29582,31728,21130,21163,16937,29648,25357,14825,12777,27632,27535,23309,14889,25454,29680,21261,21196,17097,23438,19148,8549,10695,17100,13038,17101,21229,19116,25487,27665,19114,10662,14922,17068,21260,27567,19148,14954,21359,21294,29778,38230,29745,21326,31891,29745,29777,25584,25519,14921,8517,19279,31990,29779,29811,19147,19082,29811,17165,15085,23504,25617,21327,17134,17101,19245,6469,6469,2210,6404,8550,12712,10664,25553,19214,12907,25520,25488,23374,12874,12842,2211,2244,8615,23471,25617,23504,21456,19310,21423,21423,23504,25584,25584,8680,2211,2211,10696,12907,12972,21326,19148,12810,19278,17002,6339,6371,10564,14823,21195,21260,23406,25487,17100,15053,19279,4422,4422,4422,4422,4422,4422,4422,6535,4422,6470,6535,8615,8615,8648,8680,8680,10761,14922,14955,10761,6470,4389,4389,4357,4389,6501,255},
{25554,25553,25553,25585,27633,29681,31761,31728,33808,35888,35888,37968,37968,37968,37969,40049,40049,40081,40082,40082,38034,40115,38034,33842,31793,33874,33841,31761,33809,33809,33809,33809,35889,35889,35856,35856,35856,35855,35855,37935,37935,39982,42094,46254,52625,61143,61242,61242,63290,65402,65403,65370,65369,65369,63191,58964,56883,56851,56851,63158,63157,61077,63157,63124,61044,61044,61044,61011,61011,60979,60979,60979,60979,60979,60979,60979,58898,58898,58931,54573,52428,50314,48267,46187,44074,44075,39915,37834,44075,52461,54606,54606,54639,50447,42095,37869,35724,42062,40015,27469,29582,27502,25454,19050,19050,31728,27665,25553,25552,25389,21131,14824,25454,29648,27567,19082,19179,34036,23439,10630,17132,27829,21490,19181,23343,23310,29778,21261,12743,8550,12776,14922,19082,23309,21261,14857,25520,25488,29746,33939,14889,10663,25585,25552,19212,19212,19147,10663,8581,8648,21391,21327,25519,23308,25519,17165,2308,10793,27730,29843,31891,21392,12907,17165,6501,6534,4389,4356,4356,12776,10729,25552,21294,21294,23439,23407,23375,19181,12809,8583,6503,4390,8615,21326,23504,21391,19310,21423,23503,23504,25584,21326,8550,4324,4291,4291,14954,15053,19246,25421,17002,14922,21358,14921,6338,8451,10564,16904,21162,23341,25454,27600,19213,10794,4422,4389,6535,6502,4422,6470,6502,4422,4422,4422,4390,6470,10728,8616,8648,10794,10794,10761,10761,14954,12874,8648,4389,4357,4389,4389,255},
{25554,25585,25585,25585,27633,27633,31761,33776,33808,35888,35888,37968,37969,37969,38001,40049,40081,40082,40114,40082,35954,38002,33874,31794,31761,31761,33809,31761,31761,33809,33841,33809,33809,35857,35856,35856,35856,35855,35855,37935,39983,39982,42094,46254,52593,61143,61209,61242,63290,65370,65403,65402,65370,65369,63223,61077,56883,56851,56851,63190,63157,61077,63157,61076,61044,61044,61044,61011,61011,61011,60979,60979,60979,61011,60979,60979,58898,58898,56752,54605,54540,50379,50348,46187,44042,42027,37769,39882,39849,50413,56719,54639,54607,48335,42062,37870,37902,42095,37903,29550,25389,19050,21228,17035,19083,31826,34102,34102,29876,25421,21163,16970,25422,25454,33939,23309,25422,31793,27600,10630,21326,27731,23439,36117,34004,17036,34004,23341,14824,8550,10663,6437,10630,12743,8452,19115,31858,25488,36150,29745,19115,14856,27664,25519,17067,17035,12776,4356,8581,8549,10727,14922,21261,19148,21359,12906,2308,10760,29810,25584,29713,25552,8647,4388,2275,2211,8615,6601,2342,12809,12809,19214,23472,21392,23374,23375,23407,19149,12809,14922,14987,19278,17231,19311,25650,23537,19311,21423,23503,23504,27664,14954,6436,10598,4324,4356,8583,21261,23374,17035,17035,17035,17003,23407,14857,6338,8451,10564,16903,23308,23340,23341,25487,21293,15020,8616,4389,4389,4422,4422,6502,4422,4422,4422,4390,4390,6470,4422,8615,10728,10729,10761,10794,10761,10761,12841,10729,6535,4357,4356,255},
{23505,25553,25585,25585,25585,27633,29681,31761,33808,35856,35888,37968,37969,38001,40049,40081,40082,40082,40082,38002,33874,33874,31794,31794,31761,31761,31761,31729,31761,33809,33841,33809,33809,33808,33808,33808,35856,35855,35855,37935,40015,40014,42094,46254,50512,59029,61143,61208,63290,65370,65403,65402,65402,65369,63223,61045,58931,56851,56883,63158,61044,61044,63157,61076,61044,61044,61044,61011,61011,61011,61011,61011,60979,60979,60979,60979,58898,58898,56686,54573,54541,52460,50348,48268,44108,42028,39882,39915,35689,39882,50381,54639,56720,48335,40014,40047,42161,42063,37838,31631,27567,14856,12776,12776,14792,31826,25552,23374,21326,25454,19050,27568,21229,12777,25520,21294,25422,27567,23439,17035,23504,25618,23407,38263,38263,19116,23309,29647,29713,21326,12874,6469,8518,10631,6371,14922,35987,27600,31956,31793,27567,23471,23439,23406,19180,19148,14922,6469,8549,8581,8614,8582,19245,17035,25618,23472,4324,14986,29778,25519,25519,25486,6501,4355,4323,2211,4388,6568,2377,10761,17068,19279,25683,19279,23439,14955,14923,21261,17067,14954,19180,12809,10728,6535,10794,19278,23504,23504,23503,25584,25551,8615,4324,10662,12711,6437,10729,8583,23341,14954,19115,21196,19148,17035,21358,12743,4258,8451,10564,19016,25388,23341,25454,29680,27599,19213,12842,6502,4357,4390,6502,4422,4389,2276,4357,4422,6535,4389,8648,6535,8615,8648,10761,12874,12842,10728,10729,10729,8616,6470,255},
{23505,25553,25585,25585,25585,27633,27633,29713,33808,35856,35888,37968,37969,40049,40081,40081,38002,35922,35954,35922,33874,31794,31794,31761,29713,31761,31761,31729,31761,31761,33809,33809,33808,33808,33776,33808,35856,35856,35856,37935,40015,40014,42094,44174,50512,58964,58964,59029,63257,65370,65403,65403,65402,63191,58964,61044,58964,56851,58931,63158,58964,61044,63157,61076,61044,61044,61044,61011,61011,61011,61011,60979,60979,60979,60979,60979,58898,58898,56686,54573,54541,52460,50347,46187,46189,44109,39882,37801,35688,33576,41994,50445,54672,52592,50480,44208,42160,42095,33676,23243,27535,12744,10598,10598,14857,25553,29778,25553,23440,25421,19050,25520,23440,10631,21229,25520,25520,21293,21359,17100,23472,27665,21294,36117,34004,17035,16937,31825,31924,32022,23569,17198,12874,10663,10630,19115,21261,27665,31924,38132,25487,23472,25553,21261,17035,12874,10696,8583,14954,12840,8613,8549,12873,14889,25651,15052,4356,19245,27633,27665,27632,23406,8581,4355,2243,2275,2243,4389,2409,10729,19344,19247,21359,25520,25552,17100,17035,17003,27534,19180,12809,14954,10696,6502,17067,10793,10728,21358,25584,25616,19277,4421,6437,6502,14921,10695,10728,8550,10630,14857,21228,23341,27633,19180,17067,21326,12743,6338,8451,10564,19016,25356,23341,25454,29680,27567,21293,14987,8648,4389,6502,6502,4389,2308,4389,4422,4389,4390,6502,4421,4389,6470,8648,10761,12874,12874,12841,10728,10728,10728,255},
{23505,23505,25553,25553,25585,27633,27633,29681,33808,35856,35888,37969,38001,40049,40081,40081,35922,33842,33874,33874,33842,31762,29714,29714,29713,29681,31761,31761,31761,31761,31761,31761,33809,33808,33808,33808,35856,35856,35855,37935,40015,42062,42062,44174,50512,58996,58964,56851,59029,63289,65370,65402,65370,61044,58931,61012,58964,56851,58931,63157,58931,61044,63157,61076,61044,61044,61044,61043,61011,61011,61011,60979,60979,60979,60979,60979,56785,56752,56654,54573,54573,52427,50379,46187,44108,44109,39914,37768,35689,35689,39915,48333,56752,54640,50447,48400,46320,42094,29482,21097,25422,12711,10598,12678,14824,23375,27666,25521,25488,25389,21196,23407,23472,19083,21196,27633,31891,23406,23439,17068,27698,21261,12809,34004,25553,19181,19050,29713,27568,23439,25617,21424,17165,10663,17100,25519,17034,19181,25585,40278,29778,27665,23407,25552,27730,23536,10728,6469,14921,12775,8581,8516,6436,10630,17165,4356,4356,23536,25618,27633,27599,23374,8613,4355,2275,2275,2210,6470,4587,10762,19213,12842,19214,29811,25552,21294,23374,23374,33841,36117,17068,14954,17067,8615,21325,12938,6535,6535,21358,27665,12906,4356,6469,8582,10728,14954,10695,10663,8550,8550,17002,23407,31793,27567,14955,17035,23374,12743,6338,8451,10564,19016,23242,23308,25454,27600,25487,14954,17100,12906,6502,6535,10761,4389,2276,4389,4389,6535,8615,4389,4421,4422,4389,6502,10696,12809,12841,12841,12841,12809,255},
{23505,23505,25553,25553,25553,27633,27633,29681,31761,35888,35888,37969,40049,40049,40081,38001,33874,33842,33842,33874,31794,29714,29714,29713,29713,29681,29681,31729,31761,31761,31761,31761,33809,33808,33808,33808,33808,35824,35855,37935,40014,42062,42062,44174,50447,58964,56851,52592,54705,61109,61077,65304,65369,63157,61044,61043,61012,58931,58964,63157,58931,61076,63157,61076,61044,61044,61044,61043,61011,61011,61011,61011,60979,60979,60979,60979,56752,54573,54572,56620,54573,52460,50347,48267,44108,44108,41995,37736,37769,35689,39915,39915,37836,37835,39981,40046,37902,37869,25289,25323,23276,23243,19017,14823,12678,14824,25552,25519,27534,23308,21228,25553,23472,27600,17035,23374,38197,21293,23472,29681,29811,16970,8517,21261,27665,25487,27535,38165,25487,27731,32022,27828,21457,23406,21358,34037,29746,23407,27600,36085,34037,29779,25487,21293,21358,12874,4323,8549,10662,8549,8516,6436,6404,6469,8615,10663,17035,17036,27666,31826,27632,17035,10793,10760,8646,4355,2243,8582,4554,8713,17035,21261,25617,25552,27665,14955,23407,27600,25520,36117,34037,15020,14954,12842,21325,17132,6600,6567,6470,21293,8615,4324,6437,8583,8647,12907,10663,10630,10663,10663,8550,14922,21261,27534,21228,14922,17003,23406,12711,6338,8451,10564,18984,25323,25388,23406,25487,21261,12841,8583,12906,12972,23538,12940,2277,6470,4389,6502,4389,4421,4389,6502,4422,4389,4389,6502,8615,10696,10728,12809,255},
{23505,25553,25553,25553,25553,27633,27633,27633,29681,33809,35888,37968,37969,37969,38001,35921,33841,33842,33842,31794,29714,29714,29714,29713,29713,29713,29681,29681,31761,31761,31761,31761,33809,33808,33808,33808,33776,35823,35855,37935,39982,42062,42061,44174,50447,56819,52625,50480,52624,56818,56850,61077,65303,63158,58963,61043,61044,58931,61012,61077,58931,61076,63157,61076,61044,61044,61044,61043,61011,61011,61011,61011,60979,61011,60979,60979,58898,56686,54572,54573,54573,54540,50347,48268,44141,42061,42061,37769,35688,33608,39916,35724,18984,19016,19017,16936,19017,19049,19050,23244,29583,29615,33776,23243,16904,21196,23342,25454,23309,21098,23374,27665,21261,29713,23406,23374,31826,23341,29779,27501,12743,12711,12710,12711,33906,31826,38100,33938,29681,27633,21294,14988,17100,27600,25520,33972,29746,29778,42391,34004,34004,29778,29778,23439,19212,10695,4356,8581,8581,6436,6468,6436,6404,4356,4356,25453,21228,10696,14890,21196,25487,21358,25487,12874,8615,4388,6436,6436,4421,10761,19148,21326,21294,23407,31891,27600,25487,25520,25554,23440,40278,34037,19246,14955,27664,19213,10827,4422,2276,4389,4324,2244,4357,6470,10696,17132,14987,10663,10696,10663,10663,8550,17002,23308,25421,23374,14889,17035,23406,10663,6338,8451,10564,19016,25355,25388,23374,21326,8582,65,4324,10761,12940,10761,2309,4389,4389,8647,4389,6470,6502,4389,4389,4389,4357,4389,4389,4422,8583,8615,255},
{23505,25553,25553,25553,25553,27601,27601,27633,29681,33809,35888,35888,35889,35889,33841,33841,33842,33842,33842,31794,29714,29714,29714,29713,29713,29713,29713,29681,31729,31761,31761,31729,31729,33776,33776,33776,35856,35888,37935,37935,39982,40014,42061,44173,48367,50512,50479,50479,52592,54704,58865,61011,65271,63157,58963,61044,61044,58931,61077,61077,56850,61076,63157,61076,61044,61044,61044,61011,61011,61011,61011,60979,60979,60979,60979,60979,58898,56752,56719,56654,54573,52460,50314,48266,46221,46221,44108,37768,35656,35721,37803,31531,18984,19016,19017,19049,19049,19049,16937,25356,38034,29615,31793,23309,19083,27535,23341,23341,25389,21163,23407,27633,25487,31793,29746,23374,27599,27665,25519,19048,10565,12710,14856,14791,29713,25455,33906,35954,33939,31924,23504,19278,19278,25487,23341,29713,27666,27601,38198,34037,25520,17068,29713,25486,8549,6469,6436,6468,6469,6436,6436,6436,6436,6436,8550,14890,16970,10664,12777,10697,14889,21325,17067,6469,6469,6469,6436,6436,4485,12873,17100,23439,12907,23374,21294,27665,23342,23374,23440,25424,25488,38198,36150,27698,29778,12907,12939,4389,2244,2276,4324,4324,4324,6470,16807,10793,17165,12874,14922,12809,10696,10696,10631,17002,25454,25422,19148,14890,17035,23406,10662,6306,8451,10564,18984,25355,25355,23275,14856,10663,2178,2146,12743,17067,12842,4422,6502,4389,4357,4389,4389,4389,4389,4389,4357,2309,6502,4422,2309,4389,255},
{25553,25553,25553,25553,25553,27633,27601,27633,29681,31761,35889,33841,33841,33841,33841,33842,33842,33842,31826,31794,29714,29714,29714,29713,29713,29713,29713,29681,29681,31729,31729,31729,31728,33776,33776,33776,35856,37935,37935,37934,39982,39982,42061,44173,48366,50480,50479,50479,52591,54672,58898,61011,65271,63157,63124,63125,61044,58931,63157,61077,58931,63124,65238,63124,61044,61044,61044,61043,61011,61011,61011,60979,60979,60979,60979,60978,58898,56752,54573,54540,54540,52427,52395,48268,46188,44108,44108,39849,35656,37770,39884,33611,18984,19016,21162,19049,21162,21130,16937,25389,33874,31663,31728,16969,16905,25422,23342,23277,27470,25324,25455,34004,29778,33906,25552,19246,21293,21228,12776,8517,6404,8485,8485,14889,31826,21228,25389,33873,31826,29843,27698,25618,25585,25486,14954,29713,27600,21294,33971,38197,31891,27633,17067,17001,8549,6469,6404,4323,14889,19147,10662,10662,8549,10663,14922,14889,21294,19213,17101,17068,8616,14922,17035,8614,6501,6436,4323,10630,8970,15019,19181,21326,17035,25455,19148,21294,25422,23309,27437,27341,21165,23375,31859,36149,19246,13037,8616,8583,4324,2276,4389,2244,4357,10761,4390,6503,12874,10761,10696,19180,12776,10696,10696,10663,14921,17002,19180,21294,10729,14955,21326,10662,6306,8451,10564,16903,25322,25322,25322,21162,14888,6404,4258,19016,21227,17035,12842,6502,4357,2276,6470,4389,4357,4357,4357,4389,4389,4422,2308,2276,255},
{25553,25585,25585,25585,25585,25553,27601,27633,29681,31761,31761,31761,33809,33841,33841,33842,33842,31794,31794,29714,27666,29714,29681,29681,29681,29681,29681,31761,31729,31729,31729,31729,31728,33776,33776,33775,33775,35855,37935,37934,39982,39981,42061,44141,48366,50479,50479,50479,52559,54672,56785,63092,65337,63190,63157,63157,61044,58931,61077,63190,61044,63124,65238,63157,63124,61044,63092,61043,61011,61011,61011,61011,61011,60979,60979,60978,58898,58898,56752,54540,54540,52427,50347,50348,46155,46221,46221,39849,35656,37802,29549,25389,21196,21228,23341,21228,21260,23341,21228,27600,31794,27567,27567,19083,16937,21261,23342,23374,25455,21196,21196,33939,31858,31826,36019,31858,25454,10598,8484,10630,19213,14922,8517,19083,36052,19081,23340,27534,27632,27698,25552,21294,21294,21261,29745,23374,12776,10662,19148,31793,31793,29713,21261,14824,8517,6436,4356,4324,21293,29811,19213,15019,17133,14987,12809,14922,21294,17133,17067,19214,17068,23407,27730,19213,12809,8582,8550,19050,9068,17100,21261,23374,25488,27568,21261,23342,31728,23308,29550,29551,21099,21326,23375,29778,12971,21456,10696,8615,6502,2276,2276,2276,2276,2277,2309,4422,6535,14987,17067,17035,17067,12809,10663,12776,8582,14922,21293,25520,21261,10729,14922,23406,12743,6306,8419,10532,16870,23209,23242,25322,23242,21162,14790,16870,23209,21162,17002,14954,10761,6503,2244,4357,4357,4357,4357,6470,4357,4357,6567,2309,255},
{25585,25586,25586,25585,25553,25553,25553,27601,27633,29713,31761,31761,31761,31793,31794,31794,31794,31794,31794,29714,27633,29714,29681,29681,29649,29681,29681,29681,31729,31729,31729,31728,31728,33776,33776,33775,33775,35855,37935,37934,37902,39949,39981,44141,48366,52559,50479,52559,52559,54639,56784,63091,65369,65337,63190,63158,61044,58963,63157,65304,63158,63157,65238,63157,63124,61044,63092,61043,61011,61011,61011,61011,61011,60979,60979,60978,58898,58865,54540,54540,54572,52427,52427,50348,46186,46188,46221,37768,35656,39883,23308,19116,21229,21228,19180,19181,21261,19181,19213,19213,21294,21294,21261,21261,19213,19181,19181,19246,21327,17035,19116,33874,36019,31793,33939,31858,29713,16969,8485,8485,14922,14923,19148,21261,29746,27665,25486,23276,31891,29713,21261,17035,19180,27632,23374,21261,12776,10728,4356,10695,14856,16937,29648,33906,10662,8516,6436,10630,29746,27731,17101,15020,10728,6502,8517,14922,16969,14856,14953,15019,23439,36182,44602,27731,21327,17068,19148,23406,9005,19148,23374,27568,25488,25487,23342,27567,29647,19115,27470,23309,21196,21229,34003,19245,15117,19279,14987,8615,6535,6535,2276,2244,2277,2309,2309,4357,6503,8616,15019,17100,19213,19180,10728,12776,12776,10631,14922,23374,27600,21293,12777,12841,21358,12808,4258,6371,10532,14822,25322,25355,25355,25355,25354,25322,25322,25289,23241,23275,19115,12842,6535,2309,2276,2308,4357,2309,2308,2309,2309,2342,255},
{25586,25586,25586,25585,25553,25553,25553,27601,27633,29681,29713,31761,31761,31793,31794,31794,31794,31794,29746,29714,27666,27633,29681,29681,29649,29681,29681,29681,31729,31729,31729,31696,31696,33776,33776,33775,35823,37903,37935,37902,37901,39949,39981,44141,48366,52559,52559,52559,52591,54639,56751,63091,65369,65370,65304,63158,61044,58963,63157,65304,65270,65238,65237,63125,63124,63092,63092,61043,61011,61011,61011,61011,60979,60979,60979,60946,58898,58865,56654,54540,56621,52459,50346,50380,48235,44107,46221,37768,35655,37803,23308,23341,21261,25585,25585,25585,25585,25617,25585,25585,25617,21294,23440,23505,23472,21424,21392,21359,19246,21262,19116,35954,35986,25421,21163,23277,31826,25487,8485,8517,6404,10696,34037,34037,25585,31859,23341,23340,27631,36019,27534,17002,19115,29746,23439,12809,4356,6436,10696,17002,19115,21196,21228,33906,25453,10662,6436,8550,33972,27698,17133,10760,8614,4356,6436,17035,17067,17100,19213,17132,14922,38295,42554,42489,23504,21327,17036,21260,17163,25422,27568,21229,25455,25487,23342,29680,27567,23277,19018,21228,19051,27600,29842,10826,17198,12939,12939,8680,10761,10761,8648,2276,2277,2309,4390,4422,4390,6535,6535,12874,17132,19180,17035,12809,12809,12841,10631,12777,23374,25487,21261,10729,12841,21358,14921,6306,6371,8483,14790,23242,25355,25355,27403,27402,27402,25322,25289,25289,23241,23242,17067,12874,6535,2276,2276,4422,4422,2308,2276,2276,255},
{25618,25618,25586,25585,25585,25585,25553,27633,27633,27633,29681,29713,31761,31793,31794,31794,31794,31794,29714,27666,27666,27633,29681,29649,29649,29681,29681,29681,29681,29681,31696,31696,31696,33776,33776,35823,35823,37935,37935,37902,37902,39949,39981,44141,48366,52591,52591,52558,54639,54639,56751,63091,65336,65369,65337,63190,61044,58931,63157,65304,65303,65238,65238,63124,63124,63092,63092,61043,61011,61011,61011,61011,60979,60979,60978,60946,58898,58898,58832,54540,56620,54507,52394,50347,50348,46155,46221,39816,35656,35722,23309,27502,14857,23374,25487,23342,23407,23505,25553,27633,27633,23472,21424,23570,23570,25618,23570,21425,17134,23341,21131,27535,33841,27502,23243,25357,31794,23439,14922,12711,8517,14857,29778,29779,29778,27633,21326,27633,31826,36052,38131,31760,25519,31891,33971,29713,21293,12776,10631,17100,29811,27665,17035,27599,36051,17033,6436,14921,27730,25552,17100,4323,6469,12808,17100,21458,17133,12874,14955,17133,17132,19245,40376,44602,36150,17133,14955,23341,31760,29712,25487,17069,25422,23341,21261,27567,27535,23341,16873,21164,12745,27664,31794,33681,35697,33453,31307,21067,12874,14955,14987,6568,2309,4390,4422,4390,4390,4390,8616,8616,15019,17100,17035,19213,12809,10729,14954,10663,12776,17067,23407,23374,12809,12809,21326,17034,6339,6338,8451,12677,23209,25355,25354,27402,27402,27402,25322,25289,25289,23209,23241,21194,17035,12841,6502,2276,4357,2276,2276,2276,255},
{25618,25618,25586,25586,25585,25585,25553,25553,27601,27633,29681,29713,31761,31793,31794,31794,31794,31794,29746,29714,29714,29681,29681,29649,29649,29649,29681,29681,29681,29681,31696,31696,31696,33776,33776,35855,35855,37935,37935,37934,39982,39981,39981,44141,48333,52559,54639,54638,54638,54638,56751,63124,65303,65369,65271,63158,58964,58931,61077,65304,65304,65238,65238,63124,63124,63124,63092,61043,61043,61011,61011,61011,60979,60979,60978,60946,58898,58898,58930,58832,56620,54507,52394,48234,50348,46155,46188,39848,37736,35722,25324,25389,12743,19083,17068,17035,19083,19148,19148,19148,17068,14922,14890,17003,19050,19083,14955,14956,14955,23244,21131,19083,25454,25454,29648,29713,31891,25585,19213,12809,8485,16970,23440,25520,23374,25520,19149,25487,31826,33939,40212,29680,27698,36084,36084,31793,29713,19083,14889,12808,27730,25552,14922,19115,23273,8548,4323,14986,29908,19311,15052,8615,8583,21326,29942,29974,32054,23407,21293,14955,17133,15052,19245,42521,36150,17068,19148,21327,25552,29680,27567,17036,21261,25454,25487,27567,25455,23341,16938,21229,12744,21261,37939,60858,62836,58414,60176,35600,14955,19181,19213,17100,6568,2309,4390,4422,6503,4390,4390,8584,8615,14954,19213,23407,21326,12809,12841,14922,10631,10696,21261,25519,23374,12841,10696,19213,19147,6371,6338,8451,12644,21096,25354,25354,27402,27402,27402,25321,25321,25289,23208,23208,23209,21162,14987,10761,6470,2276,2244,2276,255},
{25618,25618,25586,25585,25585,25585,25553,25553,25553,27633,29681,29713,31761,31793,31794,31794,31794,31794,29746,29714,29714,29714,29681,29649,29649,29649,29681,29648,29680,31728,31728,31696,31728,33776,35856,35888,37936,37935,37935,40014,39981,39981,39981,44140,48333,52558,54639,54638,54670,54638,58799,65204,65271,65238,63190,63157,58964,58931,63157,65304,65336,65238,63157,63124,63124,63124,63092,61043,61011,61011,61011,61011,60979,60979,60978,60946,58898,58898,60979,60978,56620,54507,52394,50314,48235,46155,44075,39848,37736,41996,25324,25357,14824,21164,21196,19083,19148,19149,17101,17101,17003,14791,12679,12711,12679,12679,10631,10599,10599,10599,10599,12810,19116,27502,27567,23341,21326,25552,25519,17067,8518,10663,19116,31826,23407,21327,23407,29778,36117,38165,29680,25454,29713,31891,33972,29681,27568,17002,19083,14889,23406,25487,17002,14856,16933,10660,6436,19213,27763,15019,8582,8582,8615,19213,31891,27763,27828,23406,14824,12776,14955,19245,14986,25551,29811,17068,19148,12907,19214,25454,25487,25487,29648,25487,27535,27567,21261,19148,25422,23439,21359,21294,36020,29487,31534,31533,29423,14793,14889,17003,23374,21358,19246,8616,4390,4422,4454,14955,10762,4390,6535,6535,14987,21326,17100,21293,14922,12777,14922,10663,10663,19148,25487,23407,12842,10664,19213,21325,8517,6306,8451,10564,18983,25322,25322,25354,27402,25354,25354,25321,25289,23209,23208,23176,23209,19115,14987,10761,4422,2244,255},
{27698,25618,25586,25585,25553,25553,25553,25553,25553,27601,29681,29713,29713,31761,31794,31794,31794,31794,31794,29746,29714,29714,29681,29649,29649,29648,29648,29648,29648,31728,31728,31728,33776,33808,33808,35856,35888,37935,37935,39982,39981,39981,39981,44140,48333,52526,56751,56751,54670,54638,58799,65237,65369,65304,65271,63157,61044,58963,63190,65304,65336,65270,63157,63124,63124,63124,63092,63091,63059,61011,61011,61011,60979,60978,60978,60946,58865,56719,56719,58799,56620,54507,52394,48234,48235,46187,44075,41962,37736,54606,52560,29550,14857,19148,19181,17035,19115,21196,21196,23276,21196,16969,19083,23309,23341,23341,23309,23308,21228,21196,17036,15087,14890,21196,27600,25519,23439,25585,27600,29713,17035,19180,25520,27568,21229,29746,36149,31956,34004,38165,29713,25519,27535,27568,31826,29713,25487,12743,10630,8517,19115,21293,17002,21294,19113,10660,6404,21326,19213,14888,8516,6404,10663,21326,29810,19116,14857,12744,10630,10598,12842,14921,12774,10662,12906,12907,12808,8550,23308,23341,25487,23374,27567,25454,25454,23341,10661,10662,23374,21423,15019,21293,31891,19245,12875,14923,14922,6438,10696,12809,17068,23407,23471,19245,6535,4422,4422,10794,10794,4390,8616,8681,6535,10729,14922,21261,21293,14922,12776,14922,12744,8582,14954,25519,25454,14954,10696,17100,23439,10695,4258,8419,10532,16870,23209,25322,25354,25354,25321,25321,25289,25289,23209,23208,21128,21096,23242,19147,12939,8681,255},
{27698,25618,25618,25585,25553,25553,25553,25553,25553,27601,29681,29681,29713,31761,31794,31794,31794,31794,31794,31794,29714,29714,29681,29649,29649,29681,29648,29648,29648,31696,31728,31728,33808,33808,33808,35856,35855,35855,37935,40014,39981,39981,42061,44172,48333,52526,56751,58831,56751,56718,58799,65237,65435,65369,65271,63190,61044,61011,63190,65304,65336,65270,63157,63124,63124,63124,63092,63091,63091,61011,61010,61011,60979,60978,60978,60946,58833,54573,54540,54539,56620,54507,52395,48234,46154,46221,46156,41961,37736,58832,65169,40014,27436,25388,25324,27437,27436,23243,19051,19083,19083,16937,16969,21196,25389,25357,23308,23276,21228,21196,14955,13071,21228,17003,31826,25520,27665,21359,27567,27600,23374,31859,25585,21261,21228,33939,36052,29746,33972,36085,29713,27600,23309,17002,27567,35986,36019,33905,25421,12743,12809,8582,6437,14889,14857,6436,10695,29811,25682,12807,10596,8484,12776,23406,23407,14922,10566,12678,12678,10598,10729,19081,12709,12807,12873,12874,17264,13005,21130,27567,25487,14922,25422,25422,21228,6500,4354,4322,6437,6469,2243,8615,29810,21391,10762,12842,16970,14857,10631,14955,14955,19181,23407,23472,17101,6503,4390,4422,4422,4422,8648,10762,6503,8648,12874,17100,14987,21261,17002,12744,14922,12776,8550,14922,23374,19181,14987,10696,12842,21358,14921,6338,6338,8483,12677,19015,23176,23209,21128,25289,25289,25289,23241,23209,23176,23176,21096,21096,21162,17099,255},
{25618,25618,25586,25585,23505,25553,25553,25521,25552,27601,27633,29681,29681,29713,31794,31794,31794,31794,31794,29714,29714,29714,29681,29681,29681,29681,29648,29648,29648,31696,31728,31728,33776,33776,33776,35855,35855,35855,37935,39982,39981,39981,42061,44172,48333,52558,58832,58864,58831,56718,58798,65270,65435,65402,65271,63190,61044,61011,63190,65304,65336,65238,63125,63124,63124,63124,63092,63091,63059,61011,60978,60978,60978,60978,60978,60946,58866,58898,58865,58864,56653,54507,52394,50314,46155,46287,46188,39816,35655,52461,65138,60912,60912,58833,58833,54641,54706,46321,25324,19018,19018,16937,16969,23276,25389,23309,23308,23276,21196,21262,4751,10926,25422,14858,27633,27666,29843,17165,27535,29680,29745,29778,23439,19214,10696,27535,33906,27600,33939,33971,25454,23341,21228,27535,33873,33873,35985,33873,27567,16971,17100,14955,10664,19050,21066,10630,12841,25553,25617,12840,8484,8484,14922,33872,27599,12743,10565,10565,10565,8517,10696,14987,15019,12841,15051,14954,13071,17068,25388,23341,21196,23341,25454,27601,25422,14921,10662,4291,2210,8517,6436,8583,27697,23471,12874,10729,6470,12809,8518,8550,14890,14988,19181,21326,23439,15020,4455,4422,4455,4455,4455,4455,4422,6568,10761,10794,12874,12874,19148,19115,12776,14922,14889,10630,12809,21293,25487,19148,10696,10728,21326,19148,6403,6306,8451,10564,16870,21128,21128,25289,25289,25289,25289,23209,23209,23176,21096,21096,21063,21096,255},
{25618,25586,23537,23505,23505,23505,23473,25520,25520,27600,27601,27633,27633,29681,29713,31794,31794,31794,29714,29713,29714,29681,29681,29681,29681,29681,29648,29648,29648,31696,31696,31728,31728,33776,33776,35855,35855,35855,37935,40014,40013,39981,42061,46220,48333,54606,56751,56751,58831,56750,58830,65237,65403,65402,65369,63223,61044,61011,63157,65304,65304,65238,63124,63124,63124,63124,63092,63092,63091,61011,60978,60978,60978,60978,60978,58898,58866,58898,58898,61011,58766,54507,52394,50314,48235,46188,46155,39848,37736,41962,48335,25421,27470,29615,29647,29615,29582,27502,25389,23308,19083,23276,16969,23276,25357,23308,23308,23276,21196,23374,2638,17199,29712,25455,21262,29811,31956,19181,25454,25487,27567,25487,21261,29648,14857,29713,29713,33906,31793,23341,10630,8518,27567,27534,31695,29614,29647,25421,25520,19148,14890,17035,17068,27404,19082,8550,8615,25585,23472,10662,8484,6404,14890,27600,25552,10630,10630,10630,8517,10598,10728,14987,14955,19180,14954,10662,12808,19017,23276,23309,21229,27567,27567,29649,23342,25455,17035,4356,4323,12776,16937,8485,25519,23504,10826,6567,6470,8616,8550,8551,8583,10696,12875,17101,21391,21391,14987,4422,4455,4455,6535,4455,4422,4422,6536,8649,12842,14987,12841,19180,19148,12776,14889,14889,12776,10663,19148,23374,21261,12777,10664,19181,21326,10630,6306,6371,10532,14757,21128,25289,25289,25289,25289,23241,23209,23208,23176,21096,21096,21063,255},
{25586,23538,23505,23505,23505,23473,23473,25520,25520,25552,27601,27601,27633,29681,29713,29713,29713,29714,29713,29713,29681,29681,29681,29681,29681,29681,29648,29648,29648,29648,31696,31728,31728,33776,33808,35856,35855,35855,37935,39982,40013,42029,42061,46221,48333,54606,56751,56718,58831,58863,60911,65204,65402,65435,65435,65336,61044,61011,63157,65304,65304,65238,63124,63124,63124,63124,63092,63091,63091,61011,60978,61010,60978,60978,60978,58898,58866,58898,58897,60979,58766,54507,52394,50314,52395,44041,41961,41929,37768,39883,25291,21326,23439,21359,21327,19214,19149,19149,21261,21261,21228,23309,16970,23308,25389,25357,23309,23341,23277,23407,525,21327,31825,36052,19148,31859,36117,27632,27600,27567,21261,25455,16970,27666,18986,25487,27698,34003,29778,25487,19082,19083,27371,31695,33808,33808,31695,27502,27567,25454,14889,12841,14889,14791,6436,4324,10728,34005,25552,10662,10597,8550,14987,25585,19213,6371,10630,10598,8485,10598,12809,17036,27600,29746,21261,8581,4323,18984,23308,25454,23309,27600,29746,23375,23309,25422,12776,4355,6500,8581,12776,8583,23471,25649,8681,8615,8550,10729,4390,8583,6535,6503,8616,14955,23472,21359,21359,14954,4422,4422,4422,4455,4455,6536,4390,6535,8648,10729,14922,12874,19180,21228,12809,12809,14987,10728,10696,16970,25454,23374,14922,10664,14987,21358,14889,4290,6338,8451,12644,19015,23209,23241,23241,23241,23209,23208,23176,23176,21128,21096,255},
{25586,25586,23505,23505,23473,23472,23472,25520,25520,25520,25552,27601,27633,29713,31761,31761,29713,29714,29713,29713,29681,29681,29681,29681,29681,29680,29648,29648,29648,29648,31696,31728,31728,33776,33808,35856,35887,35855,37935,39982,40013,42029,42061,46253,50413,54638,56751,56718,56750,60911,62992,63123,65402,65402,65435,63255,61044,61043,63189,65304,65304,65237,63124,63124,63124,63092,63091,63091,63091,63059,60978,60978,60978,60978,60946,58898,58865,58898,58897,60978,58733,56587,52394,50282,50282,48235,44074,41961,39914,37868,23276,16970,17035,17003,14955,14987,17068,17068,17068,19083,17003,14955,17035,17003,17002,19051,19050,23374,25455,17198,2734,23439,27502,33939,21164,23375,29746,29713,27600,25552,21262,25455,21294,25650,29681,25552,29778,31891,31858,29680,25454,25454,31597,35888,33807,31727,29614,25421,23342,29714,25487,23438,10662,6404,6404,4323,12874,36085,23472,14921,8517,12809,19213,27730,23472,12808,10630,6372,6405,10599,10729,14922,29681,29779,12942,17067,12809,18985,25389,27535,27567,27568,19247,23374,21293,10630,6436,4355,4355,2242,6534,8746,23536,25649,10794,8583,4291,8615,6503,6470,8616,8616,6503,8616,14988,23472,23472,21358,12874,4422,4422,4422,6503,21327,8616,6535,6503,8648,8648,12874,14987,19148,21261,14922,12841,17035,12776,8518,12776,21293,23406,17035,10696,12809,19245,17067,8452,4258,6371,8483,14822,21128,23209,23209,23209,23209,23208,23176,23176,21096,255},
{25586,25553,25553,23505,23473,23473,25520,25520,25520,25520,25552,27601,27633,29713,31761,31761,31761,29713,29713,29713,29713,29681,29681,29681,29681,29680,29648,29648,29648,31728,31728,31728,31728,33776,33808,35856,35887,37903,37903,39982,39982,42061,44141,48301,50413,54638,58831,56718,56750,63025,65138,65203,65402,65435,65435,63190,61044,63124,65270,65304,65304,63189,63124,63124,63124,63092,63091,63091,63091,63059,60978,60978,60978,60978,60946,58898,58865,58897,60946,58832,56652,56588,52394,50282,48202,48235,44042,41929,42028,39981,21130,16905,21131,19115,17068,17035,17036,17035,17068,19116,19083,19051,17003,16971,14923,14923,17003,17003,16938,15053,6862,23472,21195,29680,19051,19053,19148,23374,29680,36085,31891,33939,27698,25618,33972,27665,25552,31859,25552,23374,17035,23309,27436,33775,38034,35954,31760,31793,21196,25487,31859,27665,14921,8549,6436,6372,15019,34005,21326,12742,8484,8583,19181,31956,27730,21392,19148,16904,12776,10794,21098,16969,29680,17135,265,14955,21228,23210,23341,27535,27567,27567,23375,21294,21260,12743,6403,4323,2242,2210,4356,4421,21390,25649,12874,10826,8583,12809,17035,8616,6503,8648,8681,4455,8648,15052,27633,25519,21326,12874,4422,6503,4455,6535,6535,6503,4422,6503,8616,8648,14922,17035,17067,19213,14954,12809,14889,14857,8550,10630,19115,23374,19148,10729,10696,17067,21293,12743,4258,6338,8451,12676,21063,23208,23208,23208,23208,23176,23176,21128,255},
{25586,25585,25553,25553,25553,25521,25520,25520,25520,25520,25520,25552,27601,29681,29713,31761,29713,31761,31761,29713,29681,29681,29681,29681,29681,29648,29648,29680,29680,31728,31696,31728,31728,33776,33808,35856,35887,37935,37935,39982,42062,42093,44141,46252,50413,52525,56686,56718,58799,65171,65203,65237,65402,65435,65468,63190,61043,63124,65303,65304,65303,63189,63124,63124,63124,63124,63091,63091,63091,63059,60978,60978,60978,60978,60946,58865,58865,58898,58767,56653,56652,54539,52427,50314,48234,48235,44042,41962,42029,39981,19050,14889,21164,21196,21196,21163,21163,19083,19083,19116,19116,17036,17036,17035,19083,21131,21163,19083,16970,27600,8780,15053,29680,36052,29713,23407,19181,27600,27600,33972,38132,34004,29746,25553,29811,25585,29746,29746,27665,25487,23342,25520,27502,25422,31760,38067,38132,33873,33938,29712,25553,12906,10662,8517,6404,8549,21359,27730,19213,8549,6404,8550,14889,23374,42424,27535,23179,19017,10598,10892,12874,17002,31858,12942,233,12875,23341,25356,25454,27535,27535,27535,25455,25454,25422,19181,10663,4323,4323,6436,4324,4291,19212,27762,10729,12939,12939,14987,12874,19181,10729,6503,8681,8681,4455,6568,17100,29713,25519,21326,12874,4422,4422,4422,6568,4454,6470,6502,4422,8616,8648,12809,12842,14987,19213,19083,12776,14857,14922,10663,10598,14889,19180,19180,12841,10663,12841,19213,14986,6404,4258,6370,10531,14789,21063,21128,21128,21128,21128,21128,255},
{25585,25585,25553,25553,25553,25521,25521,25520,25520,25520,25520,25552,27600,27601,29681,31761,31761,31761,31761,31761,29713,29681,29681,29681,29681,29648,29648,29680,29680,31728,31696,31696,31728,33776,33808,35855,35855,37935,37935,39982,42062,44141,44141,46252,48333,50445,52525,54637,58831,65171,65204,65335,65402,65435,65403,63157,61043,63157,65304,65304,65304,63157,63124,63124,63124,63124,63124,63091,63091,61011,60978,60978,60978,60946,60946,58865,58865,58897,58767,58733,58733,54507,52427,50314,48234,48235,44009,41995,42094,42029,35855,31661,33742,29517,31662,27404,27469,29680,29713,27567,25421,27535,23276,23309,25422,21261,21163,16970,19018,23406,6700,12973,27567,31858,34004,29746,17035,27567,27632,27698,29746,27600,17035,17035,27665,23406,19147,14856,14922,21033,27470,29811,25422,25421,23276,31760,31793,19082,23308,29745,23407,19115,10597,6436,6404,6437,27665,27633,21262,17100,14955,14922,19214,14987,29680,16937,10565,6404,8517,8681,4651,19278,33939,15023,201,12875,23145,29549,25454,25455,27535,27567,27535,25487,25455,29745,23374,6437,8582,8550,4324,4324,19180,29843,10794,14987,6534,17034,12841,12875,19279,10762,6568,8681,8648,6535,6827,9134,19440,23407,21294,12874,4422,4422,6568,4422,6535,6503,6535,4422,6568,8648,10793,12906,17067,19148,19115,12809,12809,14922,12776,10598,12744,17067,19181,17068,10728,8583,14987,21293,12743,4258,6338,8419,10564,14789,18983,18983,19015,21096,255},
{25553,25585,25585,25553,25553,25521,25521,25520,25552,25520,25520,25552,27601,27601,27633,29713,31761,31793,31761,31761,31761,29681,29681,29681,29648,29648,29648,29648,29648,31696,31696,31728,31728,33776,33776,35856,35888,37935,37935,39982,42094,44141,44141,46252,48332,50413,52493,54605,58831,65204,65270,65369,65435,65402,65402,65271,63124,65271,65304,65304,65304,63157,63092,63124,63124,63124,63124,63091,63091,63058,60978,60978,60978,60946,60946,58865,58865,58865,58897,60946,58766,54507,52426,50314,48201,48235,46155,44042,44141,44142,31564,23243,25389,25421,25454,23309,25357,27535,27535,25422,23309,27503,21196,21164,23309,23277,19083,14824,12711,17035,6732,10861,25454,31858,33906,29745,17003,12776,19116,21294,31793,25422,23309,21228,19148,14857,12711,14922,19213,19051,21163,29745,27567,25422,23276,19050,19050,19050,10597,16937,27698,21229,19147,10630,8549,10663,29778,25487,21261,17068,12874,14987,29843,21327,17035,6436,4324,4291,8517,6600,554,23472,33971,12909,266,19180,25323,27469,27535,27502,27535,27567,27567,25455,23406,29778,25487,19148,12808,17068,21294,8550,23439,29842,10794,19279,10826,21189,23339,10794,12907,19279,12875,6535,8681,8714,4811,746,11053,29745,25487,21293,12842,6535,6503,4455,4455,4455,4422,4422,4422,6535,10761,10729,10794,12842,14954,14954,14922,12776,14889,14922,10663,10696,14922,21293,19180,12809,8583,12809,19212,17034,6404,4257,6338,8451,12677,16902,19015,21096,255},
{25553,25553,25553,25553,25553,25553,25553,25553,25553,25552,25520,25553,27601,27601,27633,27633,29681,29713,29713,29681,29681,29681,29681,29648,29648,29648,29648,29648,29648,31696,31696,31728,31728,33776,33776,35855,35855,37935,39983,40014,42094,44141,44140,46220,50381,50413,52493,54573,58864,65171,65237,65401,65435,65402,65369,65303,63092,65303,65336,65303,65303,63157,63091,63124,63124,63124,63091,63091,63091,63058,60978,60978,60978,60946,60946,58865,58865,58865,58865,60978,58799,54507,52426,50314,48234,48268,46188,44041,39849,39948,19050,17166,19311,21424,23472,23374,23276,23277,21228,21228,21228,21229,21229,21229,19148,19148,21228,19051,16938,21196,2572,17199,27567,27632,31793,31859,21327,8551,10664,17068,31826,25519,27664,29713,23341,8517,6372,12744,21327,31891,29680,33906,27535,25390,23277,23276,21130,19018,12678,10630,23439,27665,29777,21293,17002,17067,31826,23374,19083,8550,12874,14955,34037,36150,23407,14856,8485,6436,10630,8680,6697,21391,31891,6670,2378,19181,31662,27470,27502,27535,29615,27535,27567,25455,29681,25519,10694,12809,23471,21327,21359,19278,23439,29843,10794,17166,17101,14954,10794,19213,15020,10794,17166,10827,8681,25586,8649,6535,6503,17100,29745,25552,19213,12874,4454,4422,4455,6503,4422,4422,4422,4390,6502,8616,8616,10729,12842,12809,12809,17002,12808,14889,14954,12873,10630,10695,14954,19180,14954,10664,10663,17034,21261,12776,6371,4258,6338,8483,14789,21063,255},
{25586,25553,25553,25553,25553,25553,25553,25553,27601,27601,27601,27601,27601,27601,27601,27633,27633,27633,29681,29681,29649,29681,29648,29648,29648,29648,29648,29648,31696,31696,31696,31728,33743,33775,33775,35855,35855,37935,40015,40014,42094,44141,44141,46220,50381,50413,52493,54572,58831,65237,65302,65401,65435,65370,65337,65336,63156,65303,65336,65304,65303,63157,63091,63124,63124,63124,63123,63091,63091,63058,60978,60978,60978,60946,60946,58865,58865,58865,60913,60978,58799,56587,52426,50281,48234,48268,44074,41928,37768,35723,21163,19115,19115,21131,19083,19082,17035,17036,14988,14988,17036,19083,19051,19050,19050,17002,19148,19083,19083,21228,12908,14988,25422,29680,29745,31826,31826,23342,14857,17035,27632,25520,23406,21260,12743,10663,10630,12711,17035,34005,38198,40343,38165,33972,31794,27567,27468,19082,16937,12808,14922,29778,34004,31826,21261,17100,29811,21229,17002,10663,12842,19181,34037,34004,19180,12742,6372,6372,8582,8713,8745,23440,17199,331,6570,17003,31662,25389,27502,27535,21195,21228,27535,25487,25487,27600,10695,14954,36149,25520,23504,23504,21358,25650,10762,17133,17068,10761,15085,12842,19115,12874,8648,10794,10762,12908,6568,10729,6503,4454,14987,27665,25519,19181,12842,4454,4422,6568,4390,4454,4422,6503,4422,4422,8616,6568,8680,12874,8615,8550,16970,14922,12809,14954,14954,10695,8550,12808,17035,17067,12809,8583,12776,19148,19147,10695,8452,6338,6371,10564,255},
{27634,27633,27634,27633,27633,27633,27601,27601,27601,27601,27601,27601,27601,27601,27633,27633,27633,27633,27601,27601,27601,29648,29648,29648,29648,29648,29648,29648,31696,31696,31696,31696,33775,33775,33775,35855,37935,40015,40015,42094,42094,44141,46221,46252,48332,50413,52493,54572,58798,65336,65237,65336,65435,65369,65336,65336,65271,63190,65303,65304,65336,63157,63091,63124,63124,63124,63124,63091,63091,63058,60978,60978,60978,60945,60945,58865,58865,60913,60913,60978,58832,56587,54474,50281,48233,48203,46154,44009,39881,35722,19017,12776,14890,14923,14955,17035,19083,19115,21131,21131,19083,17035,17035,17036,14955,14955,17101,17035,21163,27469,31662,25356,16904,25454,29746,27633,23407,21228,17002,17003,17035,27600,23374,17002,19180,27665,21195,14889,21293,31891,31891,31793,31727,27534,25421,23308,23275,23243,21130,19050,27534,33971,25487,25519,8517,8550,25552,25455,21229,12906,14987,21262,23375,27600,19213,10630,6404,6372,8582,8648,10826,27665,15021,2376,10794,21228,33775,25390,25454,27535,21196,23309,27535,25487,23375,17100,12840,21292,29648,27567,29778,31989,31989,29876,25683,25683,23537,10762,6666,17198,10729,6437,6470,6535,10794,10794,6600,6535,8681,6535,4422,12874,27633,27632,21261,12874,4454,4390,4422,4422,6535,4422,4422,4390,4422,6568,6568,8616,10729,6470,6405,14921,17034,12841,14954,17002,12776,8518,10630,14922,19148,14955,10696,10664,14954,19213,17100,10695,6371,6338,255},
{27666,29714,29714,29714,27666,27633,27633,27633,27633,27633,27633,27633,27633,27633,27633,27633,27633,27601,27601,27601,27601,27600,29648,29648,29616,29616,29648,29648,31696,31696,31696,31695,33775,33775,33775,35855,37935,40015,42063,42094,42062,44141,46221,46252,48332,50413,52492,54605,58798,63124,65237,65402,65402,65369,65336,65337,65304,61043,65270,65336,65336,63157,63091,63124,63124,63124,63091,63091,63091,63058,60978,60978,60978,60945,60945,58865,58865,60945,60912,58733,58700,56587,54474,50281,48201,48235,46122,44041,41929,33609,16969,14857,19018,19050,19083,21163,21164,21196,17036,14956,14988,17003,17035,19083,19083,21163,31793,27599,27567,27566,27599,27567,10631,21228,25455,25455,29746,25585,21327,23374,19083,27600,25487,16969,10598,19115,27567,23341,25487,29778,33939,29648,29679,25453,23308,29680,29680,29647,27567,23373,27534,31760,25519,23374,12841,14987,14955,25455,25585,21424,14955,29779,36052,25487,34003,17002,14921,8517,8517,6600,10858,29778,17167,12973,17134,25389,35921,25422,25454,25455,25454,25487,29647,23374,19148,6630,4548,25485,31695,29647,29647,27697,29876,21458,25683,23635,23635,27731,8747,6699,17263,10826,6502,6501,8746,8713,8680,6568,6568,8648,6536,4422,8681,25520,29745,21293,12874,6503,4422,4422,4422,4454,4422,4357,4357,4390,4455,4487,6568,10761,6535,8583,14922,14954,12809,12776,14889,14889,10630,8517,12744,17067,19148,12841,8615,10696,14987,17100,14954,8582,255},
{31794,31826,31794,29746,29714,29714,27666,27633,27633,27633,27633,27633,27633,27633,27633,27633,27601,27601,27601,27601,27600,27600,27600,27568,29616,29616,29616,29615,31695,31696,31728,31727,33775,33775,35856,35856,37935,37935,40015,42094,42062,44141,46221,46252,48332,50412,52492,56652,58798,60911,63123,65402,65403,65369,65336,65337,65336,61011,65270,65336,65336,63157,63091,63124,63124,63124,63091,63091,63059,63058,60978,60978,60945,60945,60945,58865,58865,60945,60913,58766,58733,56588,54474,50280,48201,48268,46155,44041,41961,37802,33677,31597,27469,29583,25389,25422,29616,27568,27600,27535,27535,27470,25324,23276,21164,29648,38132,27600,19083,19083,19082,23373,23309,25455,25423,23374,21261,19148,17068,19181,19083,23374,29647,17002,4291,12711,25389,21261,14954,31859,29778,27600,29647,27534,25454,36051,42423,40310,40310,38197,25519,25486,17035,12841,12842,29811,21359,21294,19213,12874,19116,25585,25552,14921,12743,8549,10631,8517,6404,4356,12874,29779,10861,19214,17035,25324,31695,23309,25454,25455,29616,25454,25454,21261,14986,4484,6596,12742,12743,21195,23308,23439,25617,27764,19345,23603,19474,25715,25618,4553,6731,15216,8746,4323,6469,8648,8649,8713,4455,6600,6568,8680,4390,6568,23407,29713,23374,14922,6535,4422,4422,4422,4422,4325,2244,4422,12907,15086,6568,6568,8648,10729,10728,10761,14922,14921,12743,12808,17002,12808,8550,10598,14889,17100,17035,12809,8583,10728,17100,17164,255},
{35955,33875,33875,33907,33874,31794,29746,29714,29714,29714,27633,27666,27633,27633,27633,27633,27601,27601,27601,27601,27568,27600,27600,29616,29616,29616,29615,29615,31695,31696,31727,31728,33776,33776,35856,35856,35855,37935,40015,42062,42062,42061,46221,48300,50380,52492,52524,56685,58830,60911,63090,65402,65403,65369,65336,65369,65369,63124,65270,65336,65336,63157,63091,63124,63124,63123,63091,63091,63091,63058,60978,60977,60945,60945,60945,58865,58865,60913,60945,60913,56653,56587,54474,50281,50282,48235,44009,44009,39882,37801,42062,39949,35756,35887,29549,31597,31728,29648,35987,35954,31695,27469,21097,21130,21163,27469,33906,25389,19049,16969,19083,23341,23309,23309,19116,31826,31858,27632,21326,19181,23374,23309,27469,23210,6436,10598,21197,19213,23439,29680,29647,27535,25421,27599,19148,27567,33906,31825,31793,29745,25552,14921,8550,8550,6437,34037,31956,19181,16969,12809,19181,21392,12874,14889,12743,6436,4291,6404,10696,10728,19245,31859,10829,19180,14889,25356,27470,23277,25454,27503,29648,27567,25454,21293,12970,6629,23406,27632,23406,10630,6404,21260,10889,29876,27764,27796,27828,27796,29876,19311,2504,6666,10859,10794,6502,6437,8615,6568,8713,6568,6568,6535,8681,4422,6536,19246,29745,23406,14954,6535,4422,4422,4422,4422,6502,4390,8681,17166,4422,6535,8616,8648,10761,12874,12809,12776,12841,12776,12776,16970,17002,10663,8518,12809,17067,19180,12841,10663,10663,12841,255},
{38035,38035,38035,38035,38035,35955,31826,31826,31794,31794,29714,29714,29714,27634,27633,27633,27601,27601,27601,27601,27568,27568,27568,29616,29616,29616,29616,29615,31695,31696,33776,33776,33776,33776,35823,35855,37935,37935,42095,42094,42061,42061,44141,48300,50380,52492,54572,56685,60911,60911,65203,65402,65402,65369,65336,65370,65435,65303,65303,65336,65303,63156,63091,65204,65204,63123,63091,63091,63091,63058,60978,60945,60945,60945,60913,58865,58865,60913,60913,58799,56619,54474,54474,50281,50282,48235,46122,41928,39849,37802,44209,37902,37903,33710,29517,35889,31696,31793,35954,33841,31695,27436,23178,16937,23243,29582,31793,25389,25422,23309,27632,25422,19115,21196,21196,33971,36116,34036,29778,17035,21229,23342,23276,23308,8516,8517,19083,14824,21229,27502,31760,33906,31794,29680,23342,29713,29745,29681,29680,25455,19148,10663,6405,8551,14889,31924,42456,21327,19115,14890,17036,33972,27665,33939,17002,6436,4323,4291,10696,17100,25487,25553,8683,19147,14791,29582,25422,23309,25422,27535,29647,27567,23374,23407,12937,17196,29778,31923,31891,19180,6371,14921,2532,17261,34069,31989,31956,31956,29908,29843,10858,6600,10827,19377,12972,6567,6436,8582,6568,8680,6600,4455,6568,6535,8681,8648,15020,29713,25455,14987,8616,4422,4455,4422,6535,4422,2341,6503,4422,4390,6503,10696,8648,10729,10729,10728,10728,17002,16970,12776,14857,17002,14890,10728,10663,12808,17002,17003,12776,10663,255},
{38067,38067,38035,38035,35987,35987,33907,33874,33874,31826,31794,29746,29714,29714,27633,27633,27601,27601,27601,27601,27568,27568,27568,27568,29616,29616,29615,31663,31696,31728,33776,33776,33775,33775,33807,35855,37935,37967,42095,42094,42061,42061,44141,48300,50380,52492,54604,58765,60943,60911,65237,65402,65402,65369,65336,65402,65468,65402,65368,65336,65303,63156,63091,65204,65204,63123,63123,63091,63090,63058,60978,60945,60945,60945,60913,58865,58865,60913,60912,58700,56619,54474,54474,50281,48200,48235,46154,41928,41995,37803,44241,35822,35823,31629,29549,33808,33776,31663,31728,31696,29647,29615,27502,18985,23211,25324,31728,25422,25422,21261,25455,27567,25422,31826,31891,29810,29778,27665,25584,25519,25552,27633,27600,25552,23407,23406,27665,23407,27633,31859,31859,31859,29746,27601,27601,33972,31892,31891,31891,29778,25584,19212,17100,19181,25552,31924,31924,23472,21391,25585,23440,34005,36150,29746,14921,12808,10728,10728,12874,17133,27698,25553,12908,23341,19017,29648,23342,23374,27535,27567,27600,27567,23407,19310,10856,19244,27633,31923,29745,27730,8615,8614,2532,8840,27698,21261,21229,21261,27567,40343,27730,12972,12972,15150,17328,8712,4387,4355,10728,8648,6600,6600,6535,6568,10826,6568,2374,10794,23439,25519,17100,8680,4422,4422,8746,15118,4422,17166,19214,8616,4389,4422,8616,8616,8648,10728,12841,12841,14954,19115,14889,12776,14922,17035,12841,8550,8550,12808,17035,14922,255},
{38067,38067,38067,38067,35987,35955,35955,35955,35955,33874,31794,29746,29714,29714,29713,27633,27601,27601,27601,27601,27568,27568,27568,27568,29616,29616,29615,31695,31696,31728,33776,33776,33775,33775,33807,35855,37935,40015,42095,44174,42061,42061,44141,50380,50412,52492,56652,60878,60943,60911,65302,65434,65435,65402,65336,65402,65468,65434,65402,65369,65270,63124,63091,65204,65204,65171,65171,63091,63058,63058,63025,60945,60945,60945,60913,58865,58865,58865,60913,60913,58734,54474,52393,50248,48168,48202,46122,41929,44109,37803,39982,35723,33709,31662,31662,31630,29517,29549,31663,31728,31728,31761,38197,19050,25291,25324,25389,14857,16905,14857,25422,25454,23342,27665,29843,25617,27698,25553,25552,25585,25617,27698,27666,25618,25619,27698,27698,27698,27666,25618,27666,27698,27665,27698,27698,27697,27666,27698,27698,27665,27697,27730,27698,27698,27698,25617,25618,27698,27698,27698,25618,25618,23537,25585,25618,25618,23538,23538,25618,25618,25618,25618,25618,25618,25617,25617,25584,25552,25552,23472,23472,23440,21392,19343,8775,10857,12842,12907,21327,25649,8647,6469,419,4678,23406,31465,27239,23079,19051,44537,29778,8779,17296,15117,10793,4420,2274,2274,4355,17132,10826,8649,6600,8681,10762,8649,4487,6633,8714,21359,27632,19181,8680,6502,4422,8681,4422,4423,8616,4390,4455,2341,4389,6535,6568,8616,8680,12841,14922,14954,17067,17002,12809,12809,17067,14921,10663,8518,10630,12809,255},
{40115,38067,38067,38067,38035,38067,38035,38035,35955,31826,31794,31794,29746,29714,29714,27633,27633,27601,27601,27601,27600,27568,27568,27568,29616,29616,31696,31696,31728,31728,33776,33776,33775,33775,33807,35855,37935,40015,42095,44174,42093,42061,46221,50380,52492,54572,56684,62991,63024,60911,65335,65468,65435,65402,65369,65435,65468,65402,65369,65368,65204,63123,63091,65172,65204,65171,65171,63091,63058,63026,60977,60945,60945,60945,60913,58865,58865,58865,60913,58799,56619,54474,54474,50281,48234,46121,44008,39816,42028,37803,35756,33611,35790,29517,31662,35856,29451,29549,25323,29582,27502,29648,31826,18985,25389,21131,16970,14824,14792,14791,23309,23277,29680,31924,31957,25617,27730,25553,25585,25585,25585,27698,27698,27666,27666,27698,27697,27665,27665,27665,27665,27697,27697,27665,27697,27665,27666,27698,27666,25618,25618,27698,25618,25586,25618,25618,27666,25618,25618,25618,25618,25618,25586,25586,25586,25617,25585,25585,23537,25617,25617,25617,25617,25585,23537,25585,23504,23504,23472,21424,21392,21360,21393,17263,4582,8711,10794,8649,8649,23504,8647,8614,2468,6792,21293,18917,37770,23112,25455,38198,25585,8746,8714,12939,10859,8648,6502,4421,4388,8648,19311,12972,6633,10826,8681,6535,6568,13005,10891,4487,19214,27665,21293,12809,6503,4422,4455,4422,4422,4454,4389,4389,4390,2309,4422,8616,8616,8648,12809,12841,14922,17035,17035,14857,10695,12809,17002,14857,10630,8518,255},
{40115,40115,40115,40115,40147,40147,40147,38067,38035,35987,33907,31826,29746,29714,29714,27633,27633,27601,27601,27601,27568,27568,27568,27568,29616,29648,31696,31728,31728,31728,33776,33776,33775,33775,33775,35855,37935,37935,40015,42094,42061,42061,46221,50412,52492,54572,56684,62991,63024,62991,65336,65468,65434,65402,65369,65435,65435,65368,65303,65335,65237,63123,63091,65204,65204,65171,65171,63091,63058,63026,60977,60945,60945,60945,60913,58865,58865,58865,60913,60880,56620,54474,54474,50281,48234,48202,44009,37736,41996,39950,37902,37870,35855,29516,33742,35889,31500,31597,31695,23211,29648,31794,27567,18985,29648,25421,23276,23275,21163,19050,23309,21228,27470,31793,36117,25617,27730,25584,25615,25583,25584,27698,27698,27665,27633,27665,27665,27666,27666,27665,27665,27666,27698,27666,27666,27666,27666,27666,25618,25650,25618,25617,27698,27666,27666,27665,27665,25618,25618,25650,25650,25617,25617,25617,25617,25617,27665,25617,25617,25617,25617,25617,23538,25618,25586,25586,23537,23505,23473,21425,21393,21392,19312,15151,2469,10824,12842,8649,6568,21391,15019,10760,2499,8872,19148,6307,35721,14825,25456,34070,21391,15020,6535,6535,8648,6568,6535,10924,15085,8746,6633,17165,17133,10859,8713,4455,6600,4455,8681,4422,6503,17003,21294,21293,12874,6535,4422,4422,4422,4422,4422,4389,4357,4389,4357,4389,6535,6568,8616,10728,12809,14922,14922,17035,14922,10695,10663,14856,16970,12776,255},
{42227,42227,42195,40147,42260,42260,42227,40147,40147,40147,33907,31826,29746,29714,27666,27633,27633,27601,27601,27600,27568,27568,27568,27568,29616,29648,31696,31728,31728,31728,31728,33776,33775,33775,33775,35855,37903,37935,40015,40014,42094,44141,46220,50412,52492,54572,56684,60910,65105,63056,65369,65435,65402,65401,65369,65434,65369,63090,63091,65336,65303,63123,63091,65204,65204,65172,65171,63091,63058,63026,60977,60945,60945,60945,60913,58864,58864,58864,60913,60879,56587,54474,54474,50281,48202,48202,44009,37768,41997,40015,37903,37903,35822,33775,31662,35889,31532,27437,27470,21163,33874,31826,21163,27470,29648,23276,21130,21130,19017,16904,25356,23243,16905,23244,34004,27698,27698,25585,25585,25552,25585,27665,27634,25585,27633,27665,27665,27666,27665,27666,27665,27666,27698,27665,27665,27730,27665,27666,27697,27698,27665,25585,27665,27665,27665,25617,25617,25617,25617,25617,25617,25618,25618,25618,25618,25617,25618,25585,25586,25586,25586,25586,23538,25586,25554,23538,23537,23505,23504,21457,21424,19312,19312,17262,4549,15019,12874,6568,6536,17133,21294,10727,386,10953,17035,6339,35657,10663,19214,31990,17198,12906,10761,6535,4455,6568,6535,4390,13005,17231,10859,6600,14987,19278,8681,8713,6568,6535,6568,8648,8616,4357,10729,25390,25422,14987,8616,4454,4422,4422,4389,2244,4422,4389,6503,4422,2309,4454,6535,6535,8648,12842,14922,14954,17002,19115,12776,10663,12744,14889,255},
{46420,44340,44307,44307,46420,46420,44340,40179,38067,35987,31826,29746,29714,29714,27633,27633,27633,27601,27568,27568,27568,27568,27568,27568,29616,29616,29616,31696,31696,31696,31728,33775,33775,33775,33775,35823,35855,37935,37935,40014,42062,44141,46220,50412,52492,54604,56684,60910,65170,65137,65368,65402,65369,65369,65369,65402,65302,60944,63058,65401,65336,63123,63123,65204,65204,65172,65171,63091,63058,63026,63025,60945,60945,60913,60913,58864,58865,60912,60913,60945,58701,54506,54474,50281,48201,46121,44042,37769,39915,39950,37902,37968,33710,31630,29517,27436,27437,25357,19050,18985,25487,27665,16904,25324,27470,23275,21163,21130,21098,19017,21098,25389,21196,21228,31891,27730,25650,27697,25552,25551,25552,25584,27633,27665,27665,27665,27665,27664,27664,27665,27665,27665,27665,27665,27665,27698,27665,27665,27698,25618,25586,25586,25618,25586,25586,25618,25586,25585,25618,25618,25618,25618,25618,25586,25618,25585,23570,23538,25585,25585,25585,25585,25585,25585,25585,23537,23504,23472,21424,21424,21424,19311,17231,15117,4517,17132,17068,12874,8616,12875,19180,12905,354,13002,17035,6373,12678,6405,19279,29941,8615,2244,8616,6568,10794,19279,14988,6470,8648,15183,17296,10892,6568,10793,19245,10826,6600,6568,10794,8681,6535,6567,4390,6535,21260,25421,17068,10729,6535,4390,4389,2179,4389,6503,4390,4390,4389,2309,12875,10794,6568,10729,10761,12841,10761,10728,12809,17035,12776,12743,255},
{48468,44340,44308,46420,50612,48532,44340,35987,33875,31794,29714,29714,29714,29714,27634,27633,27633,27601,27568,27568,27568,27568,27568,29616,29616,29616,29616,29616,31695,31695,31695,31695,33775,33775,33775,35823,35855,37903,39983,40014,42062,44141,46220,52492,52492,56652,58764,60910,65235,65203,65368,65402,65368,65369,65369,65369,65303,63091,63091,65401,65335,63123,63123,65204,65204,65204,65171,63090,63058,63026,63025,60945,60945,60913,60913,60912,58865,60912,60912,60945,60879,56554,54441,50248,48202,46121,44042,41963,37803,37836,37902,37968,23178,14759,16840,14792,14792,14792,14760,12712,12712,12712,12711,19017,29582,25324,25323,23243,21130,21098,19018,14791,14824,25454,29909,27730,25617,27730,25520,25552,25552,25552,27666,27666,27634,27698,27666,27665,27633,27698,31924,27731,27731,27699,25553,25586,25618,25586,27666,27666,27666,27634,27634,27666,27633,25618,27698,27697,27698,27666,27698,27666,27698,27698,27665,27665,27698,27698,27697,27698,27698,27697,27665,25585,25618,25618,25617,25586,23505,23473,23537,21425,19312,15085,10824,21358,21326,25585,23472,19181,21293,15018,6693,15115,25552,23471,23439,25519,23504,23472,8551,6470,12874,12940,17198,21391,19246,8681,12875,15151,17296,15183,10924,6502,6469,19245,15052,6568,12972,23505,6535,8648,6535,4390,12708,21095,19213,14987,10761,8648,4390,4389,4389,4389,4422,4454,4357,2309,15053,17199,4422,8615,8616,10728,10761,10728,12841,14954,17067,16969,255},
{46420,46419,48532,54773,54773,50580,42227,33875,31826,29746,29714,29714,27666,27666,27666,27633,27633,27601,27600,27568,27568,27600,27568,29616,29616,29616,29616,29615,31695,31695,31695,31695,33743,33775,33775,35823,35855,37903,37935,40014,42094,44141,48300,52492,52492,56652,60845,62991,65236,65269,65401,65401,65336,65336,65369,65336,65368,65270,65236,65401,65303,63091,63123,65204,65204,65204,65171,63090,63058,63025,62993,60945,60913,60912,60912,60912,60913,60913,60912,58766,58668,56554,52393,50249,50315,44041,44009,41996,37836,33611,35855,37935,23210,14727,14791,14791,14792,14792,14792,14760,12712,12679,12679,21130,27437,27371,31630,33743,27437,25324,19017,21098,19017,25421,29876,27731,25618,27730,25552,25584,25552,25585,25618,27666,27666,27666,27666,27698,25585,33939,36019,23570,23602,25617,19214,21358,21325,19245,23471,23471,23472,25487,25487,25520,25488,25520,23505,25552,25520,25520,25520,23505,25520,25520,25520,25552,25553,25552,23440,25520,25488,25520,25520,25520,25553,25585,23505,23473,23473,23472,23504,23472,23505,23503,23504,23504,21424,23472,23472,23472,23472,23440,23471,23472,21424,21425,21392,21392,21360,19311,19344,19279,21359,21392,23570,21490,19409,17167,6601,13071,12973,17231,19377,10794,6534,6502,17133,19246,10761,8648,6535,8648,4455,8681,4390,2341,10761,19181,17100,10794,10761,4422,4390,4390,4389,4422,4422,4357,2309,6503,4357,4357,6535,8616,8648,10761,12874,14922,12841,14922,255},
{50580,56885,63224,63224,58998,54772,46420,38035,31826,29746,29714,29714,27666,27666,27634,27633,27633,27601,27601,27600,27600,27600,27600,29616,29616,29616,29616,29616,31696,31696,31696,31696,33743,33775,33775,35823,35855,37903,37935,40014,44142,46221,48300,52460,54539,56684,62990,65136,65269,65335,65401,65369,65335,65303,65368,65336,65369,65402,65335,65401,65303,63091,63123,65204,65204,65204,65171,63090,63058,63025,62993,60945,60912,60912,60912,60912,60913,60913,60912,58799,56619,56555,52394,50282,48202,44009,41929,39916,37903,31531,35855,37968,25323,14759,16872,14792,14792,14792,14792,14792,12712,12679,12711,23243,29582,27404,29583,29582,27470,25324,23211,23276,12711,25422,31989,25585,27697,27698,25552,25551,25551,25584,25618,27665,27633,27665,27698,25585,29810,33841,33905,23602,23570,25618,19213,23406,21326,19279,23472,23505,23505,23472,25520,25520,25520,25520,23473,23472,25552,25520,25520,23504,25553,25520,25520,25520,23440,25520,23440,25520,25520,23505,25553,23472,23472,23472,23504,23504,25553,23504,23504,23504,23504,23503,23472,21424,23504,23472,23472,23505,23505,23505,23472,21425,21425,21424,21392,19279,19312,19279,19376,21392,23440,21392,21522,21522,19442,19312,8681,13071,17264,17198,17198,21424,15085,8746,6568,12874,21358,12907,8681,4455,6600,4455,6568,6567,6600,10794,15020,17067,12907,12874,6567,4390,4422,4422,4390,6567,4422,4357,4422,4389,2309,4422,8648,10761,12874,14922,12841,12809,255},
{58965,63224,65370,61143,56917,59030,54773,44308,33874,29746,29714,29714,29714,27666,27633,27633,27633,27601,27601,27601,27600,29648,29648,29616,29616,29616,29648,31696,31696,31696,31696,31696,31695,33775,33775,33775,35823,37903,37934,40014,44142,46221,48332,52460,54571,58764,65071,65169,65335,65402,65402,65369,65303,65303,65336,65336,65369,65402,65368,65401,65270,63091,63123,65204,65204,65204,65171,65138,63058,63025,62993,60945,60912,60912,60912,60880,58864,58865,58832,54507,56586,56587,54474,52362,48202,44041,44042,37835,33707,33675,40048,38033,27469,16840,16840,16840,14792,14792,14759,14792,12711,12679,12679,23211,31631,31630,29551,29615,25389,27373,29615,33841,14889,27567,36183,25650,27698,25650,25585,25552,23440,23504,25585,27665,27633,27666,27698,27698,35987,29615,29713,23343,23408,25650,21262,23407,21294,19312,21392,23472,23472,23472,25520,25520,23472,25553,23505,25553,25552,25520,25520,23504,25553,25520,25553,25553,25553,25552,25520,25521,23471,25552,23505,25520,25552,25553,25585,25584,23505,23504,23504,23505,23472,23504,23505,23473,23537,23505,23505,23505,21424,21424,21392,21392,21424,21392,21392,21392,21490,19279,19376,19344,19311,19311,21489,21522,21490,10860,6535,8681,12973,15118,14987,25451,25614,15118,10892,6568,8616,21261,17100,8681,6535,4422,6568,4455,10794,6536,4422,10761,12907,14987,12939,8648,4422,4455,4390,8713,21523,8648,2309,4389,4389,4389,4422,6535,10761,10729,8616,10728,255},
{63191,59030,54805,50580,54772,56885,50580,42228,33906,31794,29714,29714,29714,29714,27633,27633,27633,27601,27601,27601,27600,29648,29648,29648,29648,29648,31696,31696,31696,31696,31728,31728,33776,33743,33775,33775,35823,37903,37934,40014,44142,46253,48332,52460,54571,60844,65103,65202,65335,65434,65402,65369,65335,65303,65336,65369,65369,65434,65401,65368,63123,63091,63123,65204,65204,65204,65171,65138,63058,63025,62993,60944,60912,60912,60912,58832,58864,58832,58800,56653,58700,56587,52394,50249,48202,44042,44042,33641,29449,31595,40016,37969,35856,18985,16872,16872,16872,16840,14791,14759,14792,12679,14792,25357,29550,31695,29583,29615,31695,31761,33907,33841,25422,31826,34037,21424,27730,25649,27698,25520,23441,25585,25585,27632,27632,27633,27665,36019,31695,25356,27599,27471,23440,27698,21261,23439,19278,21359,21391,23505,23472,23472,25520,25520,23505,23537,25520,25520,23504,25552,25520,23504,23505,25520,25552,23472,25520,25520,25552,25552,25550,25585,25584,25551,25552,23472,23505,23537,23505,25553,23505,23505,23505,23505,23505,23440,23505,23472,23472,21424,21392,23472,21425,21425,21425,21392,21392,19311,19344,19279,21457,19311,19279,19246,21424,19377,21490,23602,10826,4454,4422,6568,12841,23337,33797,23404,17199,15053,10729,8550,17067,21293,8681,6568,6568,6568,12940,4455,8616,4390,6568,12907,15020,12907,8681,4455,4422,4422,10827,6568,4389,4389,4389,4455,6567,4389,4422,6503,6535,6535,255},
{54772,50611,46419,44307,46419,54772,46420,38035,33874,31794,31794,29714,29714,29714,27633,27633,27601,27601,27601,27601,29648,29648,29648,29648,29648,31696,31728,31696,31696,31728,31728,31728,33776,33776,33775,33775,35823,35854,37902,39982,44141,46221,48300,52460,56651,60844,65169,65334,65401,65435,65402,65369,65335,65303,65336,65401,65401,65401,65401,65336,63123,63090,63091,65204,65204,65204,65171,65138,65106,63025,62993,60944,60944,60912,60912,58832,58864,58865,54540,52393,56586,56587,54474,50280,46122,44009,41929,35690,29450,31530,35822,40115,35922,33808,31662,23210,21130,18985,19017,21098,25324,16904,18985,29550,29583,27405,27502,27502,31728,27535,27503,29583,23244,33841,42424,25683,27730,25617,27730,25552,25552,25585,25553,27634,27633,25585,27698,27535,25389,21261,29680,27470,23343,25520,21294,23407,21261,21359,21359,25552,25553,25552,25585,27633,25553,25585,25553,25552,25520,25552,25520,25552,23505,25552,25584,25585,25584,25552,25585,25584,25552,25553,25552,25552,25552,25553,25585,25585,25618,25585,25553,25585,23473,23505,23473,23473,23505,23472,23505,23505,23505,23505,23505,23505,21424,21424,21392,21327,21391,19311,21392,21359,19279,19278,21424,21424,23602,12939,8648,6535,4455,4455,6503,17033,31751,35911,27595,19213,15020,6500,6403,10695,19213,14987,6568,8681,8681,4455,8648,8648,6568,4422,8681,12939,12907,12874,6535,4422,4390,4390,4389,4389,4422,15118,8649,4390,4357,2276,4389,4454,255},
{48499,50612,46387,44275,44275,50612,48532,40147,33874,31794,31762,31762,29714,29714,29681,29681,27633,27601,29681,29681,29649,29648,29648,31728,31728,31728,31729,31728,31728,31728,31728,31728,31728,33776,33775,33743,35823,35822,37902,39982,44141,46221,48300,52460,56651,62957,65268,65400,65435,65435,65402,65369,65335,65303,65336,65401,65402,65369,65402,65401,65237,63090,63091,65204,65204,65204,65171,65138,65138,63025,62992,60944,60912,60912,60912,58832,58832,58832,58832,58832,60912,56587,54474,50314,46122,44041,41929,39915,39950,37837,35855,35889,33776,35889,31695,19017,18984,16872,16905,19018,25323,14759,23211,31630,23276,23276,25324,25357,25324,21065,18952,25324,23211,33873,48729,25683,25650,25617,27729,25552,25552,25551,25552,27665,27633,25586,27666,19116,19213,25584,25487,27601,23375,25423,21261,23407,21229,23440,21392,25585,25618,25553,25553,25553,25553,25520,25552,23472,25519,25520,23472,25551,23505,25551,25583,25585,25583,25584,25585,25584,25585,25584,23504,25552,25552,25585,25585,25586,25586,25553,25585,25585,23505,23505,23473,23473,23473,21392,23473,23473,23505,23505,23505,23505,21457,23505,21392,21359,21391,19312,19312,21392,19279,19279,19343,21457,23569,10826,12907,6568,6535,6567,4487,4487,14953,33865,29607,23305,19147,8550,10728,10761,8681,19213,19213,14987,8648,6568,8648,8649,10762,8648,4390,6535,12875,12907,12939,10761,4455,4454,6503,4389,4389,6535,6470,2308,4357,4357,2276,4422,255},
{50579,52692,44339,40147,40115,44307,46420,44307,38067,33874,31794,31762,29714,29713,29713,29713,29681,29681,29681,29681,29649,29648,29648,31761,33809,33809,33809,33809,33809,33809,33776,31728,31728,33776,33743,33743,35823,35822,37934,40014,44141,46253,48300,52460,58732,63023,65334,65433,65468,65435,65402,65369,65336,65335,65336,65401,65402,65369,65401,65401,63156,63090,63091,65171,65204,65204,65171,65138,65106,63025,62992,62992,60912,60912,60912,58832,58832,58832,58832,58832,58799,56554,56522,50348,48269,44042,39849,39948,39950,37869,37935,33808,29615,25422,23309,21196,19148,21229,19148,21229,23342,21229,21294,25455,21261,25455,23374,21293,21229,21196,21196,21229,21229,35987,48698,23570,25683,25617,27698,25584,27632,25519,25552,25616,25585,25586,25586,23472,29811,27665,29777,27633,23310,25455,23374,23407,21262,23440,19376,25553,25553,23472,23505,25488,25520,23472,25520,25520,25552,25520,25552,25584,25584,25584,25584,25585,25584,25584,25584,25583,23505,25552,25552,25553,25585,25585,25585,25618,25586,25553,25585,23537,23505,23505,23473,23473,23473,21424,21425,23473,23505,23505,23505,21457,23505,23505,21392,21392,21359,19312,19312,19344,19279,19344,19376,21489,25715,17197,12874,6568,6535,6567,4487,4519,4520,10761,27560,31719,23404,13005,10761,10761,17133,10794,19213,21326,17068,10761,6536,10761,6568,6568,8713,6535,4422,8648,15020,17198,12907,6568,4422,4422,4389,4357,4357,4389,4357,2276,2276,6502,255},
{50579,48500,42227,40114,38034,38034,42195,42195,38035,35922,31794,31762,31762,29713,29713,29713,31761,31729,31729,31729,29681,29648,31729,33809,35889,35889,35889,33809,33809,33809,33776,31728,31728,33744,33743,33743,33775,35823,39982,42062,44141,46221,48300,52492,58764,65104,65401,65467,65435,65435,65402,65401,65368,65335,65368,65402,65369,65336,65369,65368,63156,63090,63091,65171,65204,65203,65171,65138,65106,63025,62992,62960,60912,60912,60912,58832,58832,58832,58832,56718,56587,56554,56554,50315,46123,44075,41963,39981,39950,35789,31727,27568,23374,23439,25585,25585,27666,27698,27698,27698,27698,27698,25618,27666,27698,27698,27666,27666,27730,25650,25650,25618,25585,36020,44504,25618,29811,27698,25618,25585,25520,23472,25552,25552,27633,25585,27666,31891,31827,27632,27697,27568,23148,25455,23374,23374,21261,23406,21261,25520,23473,23472,23471,23440,25519,25520,25520,25583,25552,25552,25551,25553,25551,25584,25553,25552,25552,25552,25552,25552,23505,25552,25552,25553,25585,25585,25585,25585,25585,23537,23537,23505,23505,23473,23472,23473,23472,23473,23505,21425,23505,23472,23505,23505,21457,23505,23440,21424,21392,21424,19344,19408,19312,17296,17328,19441,23635,12971,4422,6502,6535,6568,4487,4455,6568,6568,8681,21290,21356,558,10990,12875,19213,14987,12874,17133,23504,17100,12874,8681,6536,8616,6535,6568,10761,4422,6535,12939,15020,12939,8648,4454,4422,4389,4357,4357,4389,4357,2276,2276,255},
{54870,54805,46420,42227,40115,38034,38002,38034,35954,33842,31794,31762,31761,31761,29713,29713,31761,31761,31761,31729,31729,31729,31729,33809,35889,35921,33841,33809,33809,33809,33808,33776,31728,33776,33743,33743,33775,35823,37902,42062,44141,46221,48332,52492,58764,65103,65400,65468,65435,65435,65402,65401,65368,65368,65368,65434,65369,65336,65368,65336,63156,63090,63123,65171,65204,65203,65171,65138,65105,63025,62992,62960,60912,60912,60912,58832,58832,58832,58832,58832,56588,56586,54473,50281,44041,44074,39882,37836,40048,29517,27535,29681,23342,21229,25488,23375,23407,23440,25520,23472,21326,21326,23439,23440,21392,21392,21262,21228,29745,25552,25520,25552,25520,36052,38231,29714,35987,31858,29778,31858,31858,31825,31826,31825,31826,31793,31826,33972,27633,31890,38196,29713,25358,25455,23374,21293,19212,23405,19245,25550,23569,25551,25550,25520,25550,25551,25584,25582,27633,25583,25583,25553,25551,25552,25520,25551,23504,25552,25552,25553,25585,25553,25553,25585,25585,25585,25586,25586,23537,23505,23505,23505,23505,23472,23472,23473,23472,23505,23505,21425,21457,23537,23537,23505,23505,23505,21392,21424,21391,21424,19311,21392,19344,19344,19409,19441,19409,25683,25650,19051,10696,6535,8615,10663,10761,10826,8681,8681,8779,2670,2670,13038,14954,8615,6470,6502,12874,17133,19246,12874,12842,6568,6568,6568,6503,8681,8649,4422,6567,10826,12907,8681,4422,2309,4357,2309,2309,2309,4422,4357,255},
{52725,54805,44339,40115,40115,38034,33874,35922,33874,33842,33842,31761,31761,31794,31761,31761,31761,31761,31761,31761,31729,31729,31729,35889,35921,35889,33841,33809,33809,33809,33776,31728,31728,33743,33743,33775,33775,35823,37902,39982,44141,46221,48332,52492,60845,65136,65368,65469,65468,65402,65434,65401,65369,65368,65401,65435,65369,65336,65336,65335,63156,63091,65171,65171,65204,65203,65171,65138,65106,63025,62992,62960,60912,60912,60912,58832,60880,58832,58832,58832,56620,56521,54474,50281,46122,44010,39850,37868,37935,31629,31728,31794,21228,19018,19116,16969,16969,19050,19148,17002,12711,12711,14857,17002,12777,12809,12744,16937,25487,23374,21228,23341,23342,36020,33907,31794,33940,29714,31826,31827,29779,29778,31826,31826,31794,29713,29713,34005,34037,27632,27632,29712,23244,25454,25488,21323,21292,21357,17230,25551,23537,23504,23504,25520,25519,25552,25552,25519,25520,25551,25552,25552,25552,25552,25552,25553,25553,25553,25585,25585,25585,25585,25585,25585,25585,25553,23505,23505,23473,23472,23472,23473,23505,23473,23505,23505,23505,23505,23504,23537,23505,23504,23537,21457,21457,23505,21392,21391,21359,21424,19311,19311,19343,19312,21457,19376,19344,23602,25683,12809,6470,15020,8549,10596,8548,10695,14987,8713,8681,8746,8878,13006,8583,8550,4389,8680,6502,66,10794,21391,17100,10729,6568,6535,6568,6535,6568,8681,4422,4390,8648,10794,8713,6535,2309,8681,4389,2276,2309,2309,255},
{48500,46387,40115,38034,35954,35954,33874,33842,33842,33874,33874,33842,33842,33842,33842,31793,31761,31761,31761,31761,31729,31729,33809,35889,35921,35889,33809,33809,33809,31728,31728,31728,31728,33744,33743,33743,33775,35822,37902,39982,44141,46221,48332,52492,60845,65202,65434,65469,65435,65368,65402,65401,65369,65369,65402,65468,65369,65336,65336,65303,63124,63091,65171,65203,65204,65204,65171,65138,65105,63025,62992,62960,60912,60912,60912,58832,58832,58832,58832,58832,58767,56554,54474,50281,46154,44075,37802,37836,40016,35790,33874,31760,21163,19018,17003,18951,23046,16838,14889,10663,10663,10663,10565,10663,10663,10598,10598,14824,25487,25487,23374,25487,25486,33907,23309,35987,31794,31794,31794,31827,31827,31794,31794,31794,31761,29681,29681,33972,36118,23472,23406,29713,23407,25617,25552,21260,21293,23374,19245,23472,25520,25520,23472,25520,25520,25552,25552,25553,25553,25553,25585,25585,25553,25553,25553,25585,25585,25585,25585,25553,25553,25553,25553,25553,25553,23472,23473,23505,23505,23505,25585,25553,23537,23537,23537,23537,23505,23505,23505,23505,23504,23505,23505,21457,21456,23472,23472,21391,19311,21391,19311,19311,19311,19311,19376,19408,19376,19311,12907,6600,4422,10826,10695,10629,6436,6435,12808,17165,8713,8713,8714,15085,14955,6502,4357,10858,8746,2309,2276,6503,17198,19279,12842,8615,6502,6567,6568,4422,6567,6535,2309,4422,8681,10794,6568,8778,10794,2244,2309,2276,255},
{44339,42195,40147,35986,33874,33874,33842,31793,33841,33842,35922,35954,35954,35954,35954,33874,33842,33842,31761,31761,31761,33809,33841,35921,38002,38002,33841,33809,33809,31729,31728,31728,31728,33776,33743,33743,33775,35822,37902,39982,44141,46253,50381,52492,60844,65301,65500,65468,65435,65402,65402,65401,65369,65401,65434,65468,65369,65336,65336,65303,63091,63091,65171,65204,65236,65236,65171,65170,65105,63025,62992,62992,60912,60912,60912,58831,58832,58832,58832,58832,60880,56587,54474,50314,46122,46188,39949,37836,40015,35757,31663,29582,21130,23309,21230,25224,29351,21031,14824,12775,12808,10630,10565,12743,12743,12809,10597,12678,25486,27567,25454,23374,23373,33939,33939,33874,31761,31794,31826,31794,31794,33842,33841,31761,31729,31729,31729,33939,36118,23439,23374,29746,21262,23537,25585,21261,23375,23375,21327,23472,25520,25553,23472,25520,25520,25520,25520,25553,25553,25520,25521,25520,23505,23473,23472,23473,25520,25553,25520,25553,25521,23472,25552,25552,25553,25553,25553,25585,23537,23537,25553,23505,23537,23505,23505,23505,23505,23505,23505,23505,23472,21424,21424,21424,21424,21392,21424,21359,21359,21391,21391,19279,21359,19279,17296,19408,21489,15020,4324,6535,4454,4422,6469,8582,8517,4322,10695,21359,12940,10794,10794,8713,17198,17133,4422,6600,6632,2374,4487,4487,2276,12907,21391,14987,8648,6535,6502,4422,4422,6502,8648,2309,2309,4487,8713,6633,4454,2244,2276,2276,255},
{38066,38034,40115,38067,33874,33842,31794,33842,33842,35922,38002,38034,38034,38034,38034,35954,35922,35922,33842,33841,33841,33841,33841,37969,40082,38002,35889,33841,33809,33809,31728,31728,33776,33776,33743,33743,33775,35823,37902,39982,44141,48301,50381,52492,58732,65269,65501,65435,65435,65435,65402,65401,65369,65401,65435,65468,65336,65303,65270,65303,63091,63091,65203,65204,65236,65236,65171,65170,65137,63025,62992,62960,62960,60912,60912,58831,58832,58831,58831,58832,58799,56555,54474,50282,46122,44076,42062,37837,39983,35790,29582,27470,21066,25325,23277,23210,21032,16872,14856,10630,12711,10630,10598,12743,10663,10663,10533,12645,27469,25421,25356,23308,25389,38132,36020,29714,31794,31794,31794,31794,31794,33842,31793,31761,31761,29681,29681,27633,29746,25520,27664,29778,21068,23440,25650,19213,21359,21294,21327,23440,23537,23505,23472,23472,25520,25520,25552,25553,25520,25520,25520,23439,25552,23504,23472,23472,23440,25520,25520,25552,25553,23440,23472,23471,25553,23472,23505,23472,23472,23505,23505,23505,23473,23472,23505,23473,23473,23473,21424,23473,21424,21425,21424,21424,21424,21424,21424,21359,19279,21359,21392,19246,21391,21359,17296,17361,19376,19278,10793,8616,6535,4454,6502,10696,10728,10728,17100,25585,25585,10827,12940,12907,15085,19279,19278,8680,2243,2308,4487,6666,8648,8615,14987,23504,19245,12809,8615,4389,4422,6567,4422,4389,6535,2309,2341,6567,8681,6600,4389,2276,255},
{40147,35986,38034,40115,40147,38035,35954,33874,35922,38034,38034,38034,38034,38066,38066,38067,38034,35954,35922,35921,35921,35921,35889,38001,40082,38034,38002,35921,33841,33809,33808,33776,33776,33776,33776,33775,33775,35823,37902,39982,44141,48301,50412,52492,56651,65170,65468,65435,65435,65435,65402,65369,65369,65402,65467,65435,65336,65335,65302,65335,63091,63123,65236,65236,65269,65236,65171,65138,65105,63024,62992,62960,62960,60912,60880,58831,58831,58831,58832,58799,54475,56554,54474,50314,46154,46189,39949,35756,27403,25323,27600,27568,19050,25357,19051,16904,16936,16839,16904,14824,14824,16937,12645,12677,12677,12677,12613,18918,25257,23112,21031,21064,25258,38099,31826,31793,33873,33874,33873,33873,35921,35888,33840,33840,33808,33808,33775,31858,25585,21359,23439,31858,21360,23505,25650,19214,23407,21261,21294,23407,23537,23537,23472,25520,25487,25520,25520,25519,25487,23505,25552,25520,25552,25520,25552,25552,25520,25553,25520,25553,25553,25553,25553,25552,25553,25553,25553,23504,23472,23505,23504,23473,23472,23472,23472,23472,23472,21424,21424,23472,23472,21424,21424,21424,21424,21424,21424,21390,19311,19278,19277,19246,19311,19279,17263,17360,21456,19279,15020,10794,6666,4586,12939,12874,19213,14987,21391,27698,27731,14988,15020,17133,17166,12940,12939,12907,10728,8583,10761,14988,15020,15020,17100,17101,19213,17133,14987,12906,6535,4389,4389,6503,4454,6470,6307,2244,2341,6600,8681,4455,255},
{46518,40179,44340,46485,40179,38034,38034,38034,38066,38066,40147,44372,44340,40115,38034,38034,38034,38002,38002,38002,38002,38002,37969,37969,40082,40114,40114,40082,35921,35889,35889,35889,35856,33808,33808,33775,35823,35823,37902,39982,44141,48301,50412,52492,58731,65170,65467,65402,65435,65435,65402,65401,65401,65434,65468,65402,65336,65336,65368,65303,65171,65171,65302,65269,65269,65236,65171,65138,65105,63024,62992,62960,60912,60912,60879,58831,58831,58799,58831,58831,58734,56554,54473,50314,46155,42029,42095,35789,27468,25323,29615,29615,27469,23309,14825,10565,8452,10533,12678,14759,18952,18985,16838,16837,14692,16773,16773,14692,14660,14660,12612,12580,14758,25356,23308,23308,23341,25389,25389,25389,25389,25389,25421,27502,25421,25389,25421,27633,23472,23406,23374,27632,25682,21522,25650,19181,23407,19213,21326,21358,23536,23505,23438,23439,23439,25486,25520,25519,23470,23472,23471,23471,25520,25519,23472,25519,23471,23472,23470,23472,25552,25551,25553,23504,23504,23473,23504,23505,23505,23505,23505,23505,23505,23505,23505,23504,23505,23505,21424,23473,21424,21424,21424,21424,21424,21424,21424,21391,21391,19311,19279,17198,19311,19279,17230,17361,19440,19343,23602,15084,10925,4553,10827,10794,14955,10728,14987,25520,21294,12874,15020,10958,4719,8879,12907,10696,10761,12907,12907,10827,10827,10827,10859,10827,10827,12875,10761,15019,17133,10794,4422,4389,4357,2243,4194,4227,2341,2276,4422,8681,255},
{50842,52890,57051,61243,46518,38034,38034,40147,46453,44373,46453,57017,59163,48598,42260,38066,38034,38034,40114,42194,40082,38001,38001,38001,40082,40114,40081,40081,40082,38001,37969,35889,35889,35888,35888,35856,35823,35855,37902,39982,44141,48301,50412,52492,58732,65202,65435,65402,65402,65402,65402,65369,65402,65435,65468,65401,65335,65336,65369,65204,63025,65203,65334,65269,65269,65236,65171,65138,65105,62992,62992,62960,60911,60911,60879,58799,58831,58799,58799,58799,60912,60847,54474,52427,48268,44142,46289,35789,25323,27371,27403,27404,29549,25390,14825,12678,10598,10598,14791,14759,14791,16904,16937,14824,14824,14857,14889,14890,16970,16970,14889,14922,14987,14954,14954,14922,14955,17036,19116,14955,14988,14955,14955,17068,17068,17036,17068,23472,23406,16970,14857,27632,25651,21490,25651,19149,21327,19181,21327,19279,23472,21457,23439,25487,23407,23439,23408,23439,25487,23440,25520,25520,25520,23505,23472,25520,23472,23472,25520,25520,23505,23473,23505,23472,23472,23440,23472,23472,23472,23472,23472,23505,23472,23472,21424,21424,21424,21392,21392,21392,21392,21392,21392,21392,21392,21392,21392,21359,19311,19279,19279,19247,19311,19279,19279,17361,19474,19376,21457,15117,8714,8779,8714,6567,6535,8648,8616,10729,8616,8649,14987,13104,8945,4719,15119,21195,17067,12939,12940,12940,12940,12907,12940,12940,12940,10827,10761,17100,19278,19278,17133,8648,2276,2244,2276,2244,4454,2341,2309,2277,255},
{50842,52922,57083,57083,57050,57018,52824,52824,57083,57115,57083,59196,63356,59130,50710,42259,40114,40114,40114,42162,40082,38001,37969,38001,40082,40049,40081,40081,40081,40049,38001,37969,37969,37969,37968,35888,35855,37903,37902,39982,44141,48333,50412,54540,58764,65202,65435,65401,65402,65402,65402,65369,65402,65435,65435,65302,65302,65335,65369,63058,60911,65203,65335,65302,65269,65236,65171,65137,65072,62992,62992,62959,60911,60911,60879,58799,58799,58799,58799,58799,58831,56719,37802,33611,31563,31596,33709,29516,23243,23210,23211,21163,21131,19116,17035,17035,17035,17035,17003,17003,16970,16969,19116,17003,19084,17068,19148,14922,17101,19181,17003,17068,17165,17132,17165,14955,17035,17035,17068,19181,17036,14955,12874,17068,17035,14987,14987,23439,21261,14889,25454,36084,29843,29844,29844,27666,29778,27698,29778,29811,31858,31858,31826,31826,31826,31826,31826,31858,31826,29810,31858,31858,31826,31858,31858,31859,31858,31858,31858,31858,29778,29811,29811,29778,29778,29778,29778,29811,29778,29778,29778,29778,29810,27730,27730,27730,27698,27698,27698,27698,27665,27698,25617,25617,25617,25617,25617,25585,25585,25617,23569,23537,23537,21424,21391,19344,17263,17198,17166,10761,6534,8615,6534,8681,10729,8648,6568,6536,8648,8681,10826,13039,6929,6897,10959,14921,14889,14955,12972,12972,12972,12940,12940,12939,12940,10827,8681,17100,21327,23439,21391,19246,12907,6502,2244,2243,163,2244,6535,4357,255},
{50842,52922,57051,57083,59163,61308,63389,59196,57115,57115,57115,59163,61276,61211,54903,50645,48565,44307,42227,44275,40114,40114,40114,40082,38001,38001,40081,40081,38001,38001,38001,38001,37969,37936,35888,35888,35855,37903,37902,39982,44141,48333,52460,54572,60845,65301,65467,65401,65402,65402,65435,65402,65434,65435,65435,65302,65302,65368,65368,63090,60944,65203,65334,65334,65269,65236,65170,65137,63024,62992,62991,62991,60911,60911,60879,58799,58799,58799,58766,58766,60879,37835,21097,21131,19017,16904,14824,14824,14857,16937,16970,16970,19083,19083,17035,16970,14922,14890,16970,16970,17002,14890,17068,14922,17003,17068,14922,14857,14955,17068,14890,14922,17067,17035,17100,14954,14922,17003,17003,17068,17036,14922,14923,17101,17068,14987,14955,21326,23406,21261,36052,31892,29811,29811,29810,29843,29811,29811,31859,31891,33939,33938,33938,31890,31890,33938,33938,33938,31890,31890,31890,31890,31890,31890,33939,31890,31890,31891,31858,31891,31859,31858,31858,31858,31859,31859,31858,31858,31858,31858,29778,29778,29778,29778,29778,29745,29745,27665,27665,27665,27633,25585,25585,25585,25585,25585,25552,23472,23472,21359,19310,19278,17197,17165,15020,12906,10761,6535,4389,6436,6501,6469,8582,8648,8648,6535,6503,6503,8648,10794,8714,10893,4817,656,15086,16969,12809,12874,12907,12939,12972,15053,12972,10827,10826,10858,10794,19214,19278,19278,21359,23440,21359,17165,10794,4389,2211,131,2243,2276,255},
{50842,52922,57051,57083,59163,61276,63357,61244,57083,57083,57083,59163,63356,63356,59096,56951,50677,44307,44339,44307,42194,40114,40049,38001,38001,40081,40081,38001,37969,40081,38001,37969,35888,35888,35856,35856,35855,37903,37902,39982,44141,50381,54573,58765,62958,65334,65435,65369,65369,65402,65435,65402,65435,65435,65435,65402,65369,65369,65368,65236,62992,65203,65269,65302,65269,65236,65170,65137,65072,62992,62991,62991,60911,60879,60879,58799,58799,58798,58766,56718,58799,33643,21130,25324,25323,21097,18985,16937,14824,19018,21130,19082,21163,25323,25356,14889,14889,16937,16969,17002,17002,16970,19148,17035,19148,17068,14890,14890,17068,17036,14858,14922,14954,17002,14954,17002,17035,14890,14955,14890,17003,17035,14923,14955,17100,14987,12842,21294,27600,33971,31956,29811,27763,27731,27763,27763,27763,29843,29811,31859,31859,31859,31891,31859,31859,31891,31858,31891,31891,31891,31891,31890,31891,31891,31891,31891,31891,31891,31891,31858,31858,31858,31858,31858,31858,31858,31858,31858,31858,29778,29778,29778,29778,29778,29745,27697,27665,27665,27665,27632,25584,25552,25552,23504,23504,23472,19213,10760,14987,12906,12874,12842,12874,12842,10761,6534,2211,2211,4356,6468,6469,6502,6502,4422,8616,10728,6470,8583,10696,12842,10794,12973,8879,6864,14988,17100,19246,17133,15020,12907,12972,23472,23407,21424,10826,10826,12874,19213,14987,17133,19246,19246,21359,21391,19278,15053,10729,4324,163,163,255},
{50842,52922,55003,57083,59163,61276,63357,61244,57115,57083,57051,59163,63389,65437,65469,63323,50678,42194,44307,44275,40082,38001,37969,37969,38001,44209,44273,40049,37969,38001,37969,35889,35888,35856,35856,35855,35855,37903,37902,42062,44141,50413,56685,62991,65136,65302,65402,65368,65369,65402,65435,65435,65435,65435,65435,65402,65369,65369,65369,65204,62992,65203,65269,65301,65269,65236,65170,65137,65072,62992,62991,62959,60911,60879,60879,58799,58799,58766,56718,56718,56686,27370,23211,25324,25356,25291,21098,23244,16937,19018,16969,19050,27436,27403,27436,23243,19050,16937,16969,17002,19083,19083,19116,16970,17035,19148,14922,14890,14988,14988,14955,14922,14922,14954,14890,14954,14955,14890,12809,14890,14890,14956,17068,14922,17068,17035,14890,21262,33971,34004,31891,31859,29811,29811,29811,27764,29812,29811,29811,29811,29811,29811,29811,31891,29811,29843,29811,29843,29843,29843,29843,29843,29843,29811,29811,29811,29843,29811,29811,29811,29810,29810,29810,29810,29810,29810,29810,29810,29778,29778,29778,29777,29777,29745,27697,27697,27665,27664,27632,25584,25552,23471,23504,23504,21358,15051,6565,2274,14954,21326,17133,17133,15052,15052,15020,6437,2178,4291,4356,4356,4421,6535,4390,4390,4422,6502,6502,14922,14922,10729,10795,23539,8747,8747,21359,36149,38296,38328,23406,25585,29876,29778,27567,25617,17231,10794,12841,15052,15020,17068,17100,19246,19246,19246,19246,21359,19246,15020,8616,2244,255},
{50842,52922,55003,57083,59163,61276,63357,61276,59163,57083,55003,59163,63356,65469,65403,59063,48532,44307,44307,42226,40114,40082,38001,37969,40049,42160,46352,42161,38001,38001,37969,35888,33808,35856,35856,35855,35855,37903,37902,42062,46221,50413,58830,65137,65334,65368,65368,65336,65369,65434,65435,65435,65468,65435,65435,65402,65369,65369,65368,65237,63024,65236,65269,65301,65269,65236,65203,65137,65072,62992,62991,62959,60911,60879,60879,58798,58799,58766,56718,56718,56686,29483,23243,25324,25324,27436,27436,23211,21163,21130,21097,25323,31629,29451,25356,29550,29517,25291,21130,21163,19050,16970,21229,19115,21228,17035,14890,17003,17068,17036,14987,14955,14922,14987,14987,17068,15020,17068,14955,17003,17036,17101,17068,19116,19181,19181,19149,21327,31859,27697,29745,27665,27665,27665,27665,25585,25585,27665,25585,25553,25585,25585,25553,25553,25553,23472,25552,25520,25553,25553,25552,25520,27665,27666,25585,27698,25585,25552,23472,23472,25520,25585,25617,25553,23407,23407,23439,23439,21359,21359,21326,21326,21294,19246,21326,23471,23406,19147,14986,15019,21456,23699,17132,12872,6500,2338,4386,2274,4420,21325,21391,21359,19310,19278,19246,14987,2178,2210,4323,4388,4389,4389,4389,6567,8616,6535,8583,14889,12776,10762,17232,17232,15118,15151,17198,25553,23473,21327,21229,19181,21359,29811,14955,10761,15052,6502,6404,12809,21489,25715,21391,17100,17100,19214,19246,21326,21326,19246,17165,12907,255},
{50842,52922,57083,57083,59163,61276,63389,61276,59163,55003,55002,57082,61211,65469,65403,56918,54837,52692,44306,44274,42194,38001,37969,37968,40048,44208,48432,46321,40049,38001,35889,35888,33808,35856,35856,35855,35855,37903,37934,42061,46221,50413,60944,65171,65303,65336,65336,65369,65434,65435,65467,65435,65435,65435,65435,65402,65369,65368,65336,65302,65138,65269,65269,65269,65269,65236,65170,65105,65072,62992,62991,62959,60911,60879,60879,58798,58798,58766,56718,56718,54606,29483,21163,23276,23276,25323,27404,23243,19050,19017,21130,27404,27469,21163,29517,27437,27404,25291,23211,25324,29484,29451,25356,19115,19149,19116,16970,17035,17069,14955,21197,36019,29811,29811,29843,29811,29843,29843,29811,29844,31924,31924,31892,29844,29844,29811,27731,25651,25586,25586,25553,23505,23473,23440,23439,21391,21359,21359,21358,21359,21359,21326,21326,21326,21326,21326,21326,21294,21294,19246,19246,19246,19246,19246,19246,19246,19246,19214,19214,19246,19246,19246,19246,19246,19214,19214,19213,19213,19213,17165,17165,17133,17133,17133,15085,17133,15019,6469,2242,8646,8680,10956,6468,4419,4419,4451,4419,4387,2242,12840,23504,21391,21423,21391,19311,19311,10728,4356,2210,2210,2177,2145,2178,4324,10728,12874,8550,10631,12776,12907,23702,12973,12940,15119,6666,8714,15053,17068,19116,25390,21261,10663,10664,23602,15118,4356,2178,6404,8517,15020,23700,23635,19279,15052,17133,19246,19213,19213,19246,17165,255},
{50842,52922,55003,57083,59195,61244,63357,61276,59163,55003,54970,57050,59130,63356,63322,56917,61176,59063,48499,44306,40114,37969,37969,40049,44240,50545,58998,48499,40049,38001,35889,35888,35856,35856,35855,35855,35855,37903,39982,42061,46221,52493,63091,65204,65303,65303,65336,65435,65435,65468,65468,65468,65467,65467,65468,65402,65369,65336,65303,65335,65170,65203,65269,65301,65301,65236,65170,65105,65072,62992,62991,62959,60911,60879,60847,58798,58798,58766,56718,56686,56718,31563,21164,23276,23276,21098,21130,21196,19083,19051,19083,21164,21229,21229,23309,23276,23275,27403,25323,25291,29484,29516,29516,23244,21164,17035,17003,17035,17036,14923,25422,33971,31858,27665,29778,25552,27665,25617,25585,27697,27698,27698,27698,27698,27698,27698,25618,25586,25521,25520,23440,21361,21360,23407,21360,21328,21359,23407,23407,21359,21327,21326,21327,21294,21326,21326,21326,21326,21326,21294,21326,19246,19246,19246,19246,19214,19246,19214,21294,19214,19214,19246,19246,19214,19214,19214,19214,19213,19246,19246,19246,17166,17165,17165,17165,15085,15020,10793,4388,2274,4355,6468,4323,4484,4484,4451,4354,4387,2242,6501,23471,23536,23536,23504,21424,21391,19343,12972,4356,2178,2178,2178,2178,2145,4291,15019,10696,8550,10664,15086,23669,10859,15053,19344,21393,12973,6601,14987,19116,16937,6436,6437,10761,12973,12939,8615,8583,8517,6371,4259,6470,17231,25781,23602,17166,12939,15052,15052,15052,17133,255},
{50842,52922,55002,57083,59196,61276,63357,61276,59195,55003,54970,57050,61211,63323,61144,54837,56950,65403,59096,44274,38001,38001,37969,40048,48400,63257,65436,48499,42129,40081,37969,35888,35856,35856,35823,35823,35855,37935,39982,42061,46221,54606,60977,63091,65336,65336,65336,65336,65435,65435,65435,65468,65435,65468,65468,65402,65369,65336,65335,65269,65170,65203,65302,65302,65301,65236,65170,65105,65072,62992,62991,62959,60879,60879,60847,58798,58798,58766,56718,56718,56718,29515,21196,23309,21196,21131,21131,23277,21228,21163,19083,19116,21196,19051,19083,21228,19083,21163,23243,21163,21195,27404,27437,27437,23276,21163,21196,21229,21229,27470,27567,27535,27666,23505,25617,25455,25520,23471,23471,25552,27665,27665,27664,27633,25585,25585,25553,25553,23473,23440,23408,23407,23407,23407,21327,21327,21327,21357,21326,21326,21326,21293,21294,21294,21294,21293,21294,21294,21294,21294,19246,19246,19246,19214,19214,19214,19214,19246,19214,19214,19214,19246,19213,19214,19214,19214,17165,17165,19213,19245,17165,17166,17133,17133,17165,17133,15053,12940,6534,2307,4387,4452,4419,8646,8646,4451,4354,2242,2242,2275,17132,27730,25617,23569,23505,21424,21424,12907,4291,4291,2210,97,97,97,2145,10696,12874,6503,8616,19345,23604,12777,15020,19312,21392,17199,6568,8649,19148,14889,6404,19180,31990,15118,10793,6437,8615,6404,6371,8517,8484,4291,10761,21489,25748,19311,8745,8713,10827,12939,255},
{50842,52922,55003,57115,59195,61244,63357,61276,59196,55002,54970,57017,61178,61176,56917,56950,56918,63290,65436,52726,40081,38001,37968,44208,52658,61209,65468,54804,42161,40081,37969,35888,35888,35856,35855,35855,37903,39982,40014,42061,46221,58864,63090,65237,65369,65336,65336,65369,65435,65435,65435,65467,65468,65469,65468,65402,65369,65336,65237,63057,65137,65236,65367,65334,65301,65236,65170,65105,65072,63024,62991,62959,60879,60879,60846,58798,58798,58766,56718,56718,56718,29516,19148,21229,21229,21163,23244,27437,25357,23244,21164,19116,21229,21229,23309,21196,19083,17002,19083,19115,19115,19083,21163,21196,21164,21163,21164,23309,25390,27469,38034,31696,23407,23504,25553,23407,23375,21326,23439,23439,25585,25552,25552,25552,25552,25552,25585,25585,23472,23440,23439,23407,23407,21326,21326,21326,23374,23374,21326,21293,21294,21293,21293,21293,21293,21293,21293,21261,21261,21261,21261,21261,19181,19181,21293,19213,19213,19213,19213,19246,19213,19213,19213,19213,19213,19213,17133,17133,17133,19181,19213,17165,17100,17100,17100,17100,15052,15020,8583,4387,2339,4452,8711,4388,6469,6565,4387,4354,4387,2210,10825,25714,25682,25650,23569,21456,21424,15020,4291,4291,2211,2178,2178,2145,2145,6469,14987,6535,8649,23603,23505,23243,21228,19312,19344,12940,6568,8649,14987,12809,12675,27665,32022,15118,8680,8550,10663,8517,12710,16904,10565,6404,6372,6437,17198,31957,23537,10794,6568,8681,255},
{50842,52922,55003,57115,59196,59196,63357,61244,61244,59163,61177,54837,56918,59063,54837,52692,59031,61177,63355,63257,52692,46354,50546,61110,63256,63323,65469,56885,44241,40048,37968,35888,35856,35856,35855,37903,37935,40014,40014,42029,48301,63092,65271,65369,65402,65368,65368,65402,65468,65435,65435,65435,65469,65469,65468,65402,65369,65303,65171,63024,65170,65236,65367,65334,65301,65236,65170,65105,65072,65072,62991,62959,60879,60879,60847,58798,58798,58766,56686,56718,56718,29516,19149,21262,21262,21229,19116,21197,19148,21229,21229,23276,23309,25389,25422,23341,23309,21196,19083,21163,21196,19116,19115,21229,19149,19116,17068,17035,14857,16970,44373,40115,23342,23472,23472,25520,21294,21359,23439,21294,25520,25520,25520,25553,25553,25553,25552,23503,23471,25519,23407,23405,23439,23374,23374,21325,21326,21326,21294,21293,21294,21294,21261,21293,21261,21261,21261,21261,21261,21261,21261,19213,19213,19213,21293,19213,19246,19213,19181,21261,19213,19213,19213,19181,19181,19181,19181,19181,19180,17132,17132,17132,17132,17100,17100,17100,17100,15020,10761,4420,2339,4452,6598,12939,4586,8679,4419,4418,4354,4322,12873,21391,27795,25682,23602,21489,21424,17263,10793,2211,2243,2178,2178,2178,2145,6404,14955,6568,12874,27796,25553,23276,33807,27568,19312,10827,6535,12809,17067,17002,12742,31891,29909,10924,6599,8550,10630,10630,14791,12743,8484,4258,8484,6437,10794,10729,25552,29876,17198,8681,255},
{50810,52922,55003,59163,59196,59196,63357,61244,61276,65436,59030,48531,44338,46386,46387,48499,56918,63289,65403,65403,63257,56884,61077,65304,65370,63323,61209,50546,52626,48465,46320,42160,44208,42160,40047,40015,42062,42062,39982,42061,48333,63092,65369,65402,65402,65336,65368,65401,65435,65468,65435,65435,65468,65468,65468,65402,65368,65302,65203,65236,65268,65203,65367,65367,65334,65236,65170,65105,65072,65072,62991,62959,60879,60878,60846,58798,58798,56718,56686,56686,56718,29516,19149,21294,21294,21262,19181,23374,21294,21262,21294,21262,21261,23342,23342,23309,23309,23309,21196,21196,25389,21228,21196,21261,23375,21262,17100,16969,10631,16969,46421,44340,23374,21424,21424,23505,21326,21391,23407,21261,25488,25488,25521,25553,25552,23472,23472,23471,23439,25519,23437,23406,23374,21294,23342,21294,21294,21327,21294,21294,21262,21261,21261,21261,21261,21293,21293,21293,21261,21261,21261,19213,19213,19213,19213,19246,19246,19213,21261,19213,19181,19181,19181,19181,19181,19180,19180,19181,19180,19180,19212,19180,19180,17132,17100,17100,17100,17100,14954,8647,4388,4452,8712,21554,15445,6631,6532,4515,4450,4419,10662,10793,25682,25682,23634,23569,21456,17263,15150,6469,2210,2210,2178,2178,2145,6436,12874,8648,12841,12841,19148,31662,33775,38000,27600,15118,10728,12776,19115,17002,8485,12808,14987,10859,6502,8615,8517,10598,14856,14856,8484,2145,6371,4291,8582,12776,8550,14889,25650,25651,255},
{50842,52922,55003,59163,59195,61244,61308,61308,65436,61176,48532,42227,40146,42194,44274,44306,50579,56950,63224,56917,56950,56884,58964,61110,63256,63290,56885,46385,54738,65303,61110,56851,56819,61144,59063,52626,54738,48432,42061,42061,48300,60977,65369,65402,65402,65336,65368,65369,65369,65468,65501,65469,65468,65435,65436,65402,65368,65269,65170,65368,65367,65235,65367,65400,65334,65235,65170,65105,65072,65072,62991,62959,60878,60878,60846,58798,58798,56718,56686,56686,56718,27436,21229,21262,21294,21294,21294,23375,23407,23407,23407,23375,23375,21295,21294,21327,21327,21294,21261,21261,23342,21262,23310,25455,25520,21228,14792,14824,10598,19083,48501,46421,27600,23472,21392,25552,21197,21359,23439,21261,25520,23440,25488,25488,25520,25521,23505,23440,23439,23407,23405,23407,23374,23374,23406,23342,21293,21326,21326,21294,21326,21294,21294,21294,21294,21294,21294,21294,21326,21294,21294,21262,21294,21294,21294,21294,19278,21294,21294,21294,19214,19213,19214,19214,19213,19213,19213,19213,19180,19180,19212,19181,19180,19180,17132,17132,17132,17100,14987,10826,8583,8613,8679,6502,15052,8678,8677,6563,4515,6564,8613,8549,19278,25747,23634,23602,21489,19344,17231,10826,2178,2178,2178,97,2145,8583,8681,8649,12841,8648,14922,27469,31662,31695,36149,27828,19148,21163,16905,16969,14824,14856,8550,10793,6469,8583,6404,10630,14888,14889,8484,8516,10598,8452,6404,6339,4226,10565,8485,14922,255},
{50810,52890,54970,57083,59163,59196,63356,63389,63290,46452,40115,38034,38034,40114,40114,40114,42193,46386,50579,50578,50611,52658,54771,56851,61078,63289,54772,48433,52657,63158,63289,58964,56851,63290,65469,63289,61045,54705,48399,44173,48333,58896,65336,65403,65403,65369,65336,65369,65369,65435,65468,65469,65469,65468,65436,65402,65335,65137,63056,65401,65401,65301,65401,65434,65334,65235,65169,65105,65104,65072,62991,62959,60878,60878,60846,58798,58766,56718,56686,56718,56718,27436,21229,21294,23375,23407,21294,21326,21327,23408,25520,25488,23440,23440,21392,23440,23440,21359,21327,21359,23440,23407,23375,25487,25455,21261,16970,21195,10631,19115,48533,48533,29615,23472,21359,25520,21229,23439,23439,21229,25488,25520,25520,25520,25520,25488,23440,23440,23440,25488,23407,23407,23374,23374,23374,23374,23405,23373,23374,21293,23373,23374,23407,21326,21326,23342,21294,21294,21294,21294,21326,21294,21294,21294,21326,21326,21326,21294,23374,21294,21294,19214,19246,19246,19181,19214,19246,19181,19181,19181,19213,19181,19181,19181,17133,19213,17132,17132,15052,8681,4389,4388,4452,8582,10695,6532,4419,4451,6595,6563,6531,4290,10793,25715,25715,25650,23569,21456,17263,17198,4389,97,2178,2178,4357,10761,8681,10762,12874,14955,14922,14922,27502,27534,29974,21489,19213,25356,12678,16904,16969,10663,10761,6567,4356,10663,8485,12743,14889,12775,6371,10597,10597,10565,6372,8485,4291,6339,8485,6339,255},
{50810,52890,52890,52889,57050,57082,61243,59163,52823,38099,35954,35954,35953,38001,38033,40081,40081,42161,44273,44273,44273,48465,52690,56851,56884,63289,59030,50545,54705,58964,63289,58997,54771,63290,65436,63224,58931,48399,48334,48365,52526,60977,65303,65435,65403,65369,65336,65369,65434,65468,65468,65435,65434,65468,65435,65335,65170,63024,62992,65368,65435,65367,65401,65434,65334,65235,65170,65137,65104,65072,62991,62958,60878,60846,60846,58798,58766,56718,56686,56718,54639,29515,25389,23407,25520,25552,23440,21327,21359,23440,25520,25520,25520,25552,23472,23439,23407,23407,21261,21196,21228,21196,21196,19050,19083,19083,16937,19114,10631,19115,48533,50614,29615,21391,21326,25520,21260,21390,23438,21228,23407,25520,25519,25519,25488,25487,25487,25520,25520,25488,23407,23375,23375,23375,23375,23374,23374,21294,21326,23375,23375,23374,23374,23374,23374,23342,23374,23372,21326,21326,23374,21325,21294,21326,21326,21359,21294,21294,23374,21326,21294,21294,21294,19246,21262,19246,19279,19214,19214,19181,19213,19213,19181,19181,19181,19213,17133,17133,17101,17100,6501,4355,4516,6501,6533,6532,8581,8645,6595,6595,4450,4290,6436,21391,27796,25683,23602,23569,21456,19344,15020,4324,4324,4324,4389,8615,6568,12907,25716,17166,17002,21228,21196,27535,25553,31957,17133,17002,12645,14791,12744,23472,14988,2308,2242,6436,2178,8517,8582,6437,6404,8485,8517,8516,6371,8517,8452,4225,4226,6371,255},
{50842,52922,54970,52857,57050,54937,52856,50711,44405,35986,35954,35921,35889,35921,37969,38001,38001,40080,42161,40080,40048,46321,50578,52625,56851,63223,63355,52691,50545,52658,61176,61143,54771,59030,63256,56884,52625,48399,48366,52559,56751,63123,65434,65468,65435,65369,65336,65369,65468,65468,65468,65302,65302,65435,65402,65269,62991,60845,63023,65368,65368,65334,65401,65401,65334,65235,65169,65137,65104,65071,62991,62959,60878,60878,60846,58766,58766,56718,56686,56718,54639,29548,25487,25552,25552,25552,25552,25487,23374,23309,23309,23276,21131,19050,21163,21163,21098,19083,19050,16937,16937,19018,21163,21196,31662,25454,19083,21195,12743,21228,50581,50646,25422,23440,21327,25520,21196,21326,21326,19148,25455,25487,25487,25487,25487,25486,25551,25519,25519,23406,23375,23375,23375,23375,23375,21327,21326,23374,23407,23375,21327,21295,21295,23374,23407,23407,21326,23374,21326,21326,21326,21326,21359,21359,21326,23405,21295,21294,23374,23373,21326,21358,21326,21326,21294,19246,21294,19214,19213,19246,19246,19246,19246,19214,19214,19214,19214,19214,17133,15052,8582,4323,4516,6596,6596,8743,6436,6468,6596,6563,4482,8643,8484,14986,25682,25715,25682,23602,23569,21489,21424,8583,2211,4357,4389,6470,8583,8616,21425,25781,12874,14889,23341,19083,19019,36085,25422,14856,10564,14791,12809,17133,8681,4389,4356,6437,2145,4258,2178,2178,6404,6437,10598,8484,4291,6404,4258,4258,4226,6338,255},
{50842,52922,54970,57050,54970,52824,48631,46518,40212,35954,33873,33841,33809,33840,35888,35920,37968,38000,42129,40048,40048,42128,46320,50545,58997,63257,65469,52724,46321,50513,61143,63257,56916,56851,56818,48431,44206,42061,48366,58897,60977,65335,65468,65436,65435,65369,65369,65401,65434,65435,65468,65402,65368,65368,65302,63089,60878,58796,65137,65368,65302,65368,65435,65401,65334,65235,65169,65137,65104,65071,62991,62958,60878,60846,60846,58766,58766,56718,56686,56718,56719,31595,23242,27403,29484,27403,23178,23178,23178,21097,21065,21097,21098,19017,19017,18985,19050,21130,21130,21163,21131,19051,21196,23276,37968,23341,19116,27567,12743,19115,50580,52661,27534,23439,21326,25520,21229,21326,21294,17165,23439,25487,25488,23407,23407,25487,25488,25520,25487,23438,23407,23439,23406,23375,23375,23406,21357,23407,23407,23406,21358,21327,23375,21359,23440,23407,21326,23375,21359,21359,21359,21327,23407,21327,21327,21327,21327,21326,23407,23374,23374,21326,21326,21358,21326,21326,21326,21325,21326,21326,21294,21294,21326,19246,19246,21326,21326,19278,17133,17101,8647,4355,4387,6564,6596,10728,15085,8713,10790,6595,6530,8643,17000,27535,33972,21261,12809,14922,14921,12808,12809,12776,8582,8582,6502,6470,8583,14921,8616,23636,23635,14987,19050,27469,25389,23309,25421,14823,12677,14791,14922,14987,6567,6470,4324,10630,16968,16937,14889,10630,8549,8550,12743,8517,6371,4258,4226,4258,6306,6338,255},
{52890,52890,54938,57082,57050,54937,48631,40180,35987,33874,33841,33809,33808,33808,33808,35856,35888,35888,40048,42128,40015,40047,42160,48432,58996,65370,65436,50612,44241,48433,59030,63257,59062,63322,56851,48367,44206,48366,52526,56752,60945,65368,65468,65403,65403,65369,65369,65369,65170,65269,65435,65468,65435,65402,65269,65137,60910,60877,65104,65335,65401,65468,65435,65401,65333,65235,65169,65137,65104,65071,62959,62958,60878,60846,60846,58766,58766,56686,56686,56686,56719,33609,25223,27336,29449,29450,27370,31564,27403,27371,29516,29484,31597,33710,31629,29549,29550,25323,25323,27437,27437,25356,27469,27469,42161,23243,16970,10860,12679,19050,50580,54740,29614,23439,21326,25520,21229,21293,21293,19212,25487,25487,25487,25488,25487,25519,25487,25487,23407,25487,23407,23407,23375,23375,23375,23407,23406,23439,23407,23373,23405,23407,23407,23406,23405,23407,23407,23407,23407,21359,21327,21327,21327,23375,23375,23343,21327,21295,23407,23375,23375,23375,21359,21359,21326,21326,21294,21326,21326,21326,21326,21326,21326,21294,21294,21294,21326,21326,19246,17165,8713,6436,10694,8613,6597,12873,23667,15216,8710,8707,8675,8676,27697,36118,34005,16937,10597,12711,10630,10630,10662,8582,8582,8517,6469,6436,6502,14922,8648,12940,30007,17199,17035,19050,25324,27437,17035,10632,12678,14889,21326,17132,8680,6502,10695,14823,19082,19114,19115,10663,8517,6436,6404,6404,6371,4225,4226,4226,4226,4258,255},
{52890,52890,55002,57083,59163,52824,44405,38067,33874,33841,31761,33809,33808,33808,33776,33808,35856,35856,37968,42128,42128,40047,42127,48432,58964,63191,65501,54870,44273,48433,56884,63225,61144,65371,63256,58997,54705,56817,56784,56752,60945,65336,65469,65403,65403,65402,65401,65401,63090,65237,65434,65435,65435,65435,65369,65171,63056,65104,65235,65401,65401,65468,65467,65401,65301,65235,65169,65137,65104,65071,62959,62958,60878,60846,60846,58766,58766,56686,56686,56718,56719,52559,48334,37803,39916,42063,40015,42129,37902,37870,42128,35823,37903,37968,37968,37936,37937,29483,27370,25258,29485,27437,33808,31629,42226,21163,14792,8583,10598,17035,50547,54740,27469,23439,21359,25520,21164,23342,21294,21260,23406,25487,25486,25486,25487,25455,25487,23407,23407,23407,23407,23407,25455,25455,23407,23375,23407,23407,23407,23407,23406,23406,23406,23405,25451,25487,23375,23406,23407,23407,23407,23407,23375,23375,23374,23375,21326,21327,23439,23375,23375,21295,21327,21359,21327,21359,21359,21326,21294,21326,23374,23374,23405,21326,21326,21326,21326,21327,21327,19247,10826,8549,10695,8582,8645,12872,8615,8647,6532,8708,8707,6531,23472,25650,25552,16937,12710,10630,10598,8550,8582,8549,8549,8517,8517,6469,8583,14922,10729,8616,23635,25716,17134,19182,16970,21196,25422,19148,14824,19147,33972,21359,6633,6469,19082,14823,16969,19082,17002,12743,14856,10663,10630,8517,6404,4193,4225,4226,4258,4258,255},
{52890,52922,54970,57050,52857,40212,36019,33874,31793,31761,31761,33776,33776,33776,33776,33775,33775,35855,37936,40048,42128,42127,42127,46287,54705,63158,65501,56950,46353,46320,52691,61176,61176,63322,63223,65403,65337,63191,54672,54671,60978,65401,65469,65435,65435,65402,65402,65402,65236,65303,65434,65434,65468,65468,65435,65269,65169,65267,65368,65435,65401,65468,65467,65433,65301,65235,65169,65137,65104,65071,62958,62926,60878,60846,58798,58766,56718,56686,54637,56686,56719,58864,52559,37803,37836,40015,39950,40016,37902,39983,40015,40049,37968,35823,35790,33709,29451,23177,29517,21065,25291,27436,25323,31662,44306,23211,14792,10565,10598,14889,46354,52627,27470,21359,21327,25520,21261,23342,23374,21262,25488,23407,23407,25518,25520,25487,25519,25488,25488,25488,23407,23407,23407,25487,25487,23407,23407,25488,25488,25520,23407,23407,23439,23438,23436,23407,23407,23439,23439,23439,23472,23439,21359,23439,23407,23407,23407,23407,23407,23407,25487,23407,21359,21359,21359,21359,21391,21359,23406,23407,23407,23407,23406,21359,21359,21359,21359,21359,21326,21294,15020,21294,12776,6436,6532,8613,12742,16968,10693,8644,8643,8643,12903,34102,29778,16969,12743,10598,8517,8517,8549,6469,8582,6469,6404,6436,10696,14923,10762,10697,15021,27927,15118,19279,21327,19181,27600,17035,10663,14922,27633,21327,6600,10630,21194,14823,14856,19082,14888,10630,10630,10663,10663,10662,10598,4226,4226,6372,6339,6306,255},
{52890,52922,54970,50776,38132,33874,33874,31761,31761,31729,31728,31728,31728,33776,33775,33775,33743,33775,35855,37967,42127,42095,42127,46319,50512,58931,63224,59031,48466,46385,50513,52658,56852,63290,61110,63322,65502,65468,58963,54639,58832,65368,65469,65436,65435,65403,65402,65402,65368,65401,65434,65402,65468,65468,65468,65368,65268,65236,65368,65468,65434,65468,65401,65401,65301,65235,65169,65137,65104,65039,62958,62926,60878,60846,58766,58766,56718,56686,54638,56686,56719,56752,50414,37803,37804,37869,37903,40016,37870,39983,37935,37935,37968,35823,35823,37935,33710,25323,27404,23210,23177,25291,23177,33808,44274,23243,12711,10565,12646,14922,42194,48467,27535,21359,21359,25520,23342,23342,23407,23374,25488,25520,25519,25518,27600,25488,25519,25520,25552,25520,25487,25487,25487,25520,25519,25487,25487,25519,25487,23439,23439,25486,23439,23439,23407,23407,23407,23439,23439,23407,23407,23439,23439,23440,23439,23439,23439,23407,23439,23407,23439,23439,23439,23407,23407,23439,23440,23440,23439,23439,23439,23375,23407,23407,23439,23407,21359,21359,21327,19246,19213,23342,21325,10695,8581,10725,10693,12806,10693,6468,8644,6595,6595,25649,29876,12743,14889,21358,21326,21358,21358,21358,23439,21358,12906,25617,21359,17068,10762,10729,10729,27797,23603,15086,21360,23472,27698,19311,10728,8583,6470,10794,6470,8517,12743,10597,12710,19049,12775,8582,6437,8582,8582,10695,10598,6339,4258,6502,12808,8452,255},
{52890,54971,52890,42325,33907,31794,31761,29681,29680,29648,29648,31696,31695,31727,33775,33743,31695,33743,33775,37935,42095,42095,42127,48367,52593,52625,61078,61176,50578,50546,52626,48432,52625,58997,56884,63290,65501,65403,52657,50479,54638,63189,65501,65468,65436,65435,65402,65402,65368,65402,65434,65434,65468,65501,65468,65369,65335,65368,65401,65468,65434,65467,65401,65434,65301,65234,65169,65137,65104,65039,62958,62926,60878,60846,58766,56718,56718,56686,54638,56686,54638,56752,54639,37802,35723,35756,37902,40048,33643,37870,42162,37936,37903,35823,35855,35823,33710,29484,29549,35954,33808,21064,25290,29517,44275,23211,12678,10565,12646,12711,33807,42161,25455,23439,21359,23439,23341,23342,23375,23310,25520,25519,25487,25487,27600,25520,25487,25520,25520,25520,25487,25486,25520,25552,25519,25487,25519,25519,25519,25519,25487,25487,25519,25519,25519,25519,25487,25488,25520,25488,25487,23439,25487,25520,23439,23471,25487,25487,25488,25488,25488,23440,25487,23439,23439,23472,23472,23472,25520,23440,23440,23440,23440,23439,23471,23439,23440,23440,21391,21327,19214,23406,19179,10662,10630,10693,10756,10789,12870,10662,8613,6596,6562,14984,31892,12710,14954,27730,27763,25617,25650,25650,25650,25682,21391,25618,36248,14988,10729,10729,10729,19247,30040,15151,19247,38296,36248,23505,6470,10663,10728,17100,12776,14823,12710,6404,8517,8549,4324,6404,4324,4324,4324,6404,4259,6338,8452,4258,4258,4258,255},
{52922,54971,44471,33907,31761,29713,29681,29648,29648,29648,29616,29615,31695,31695,33775,33775,33743,33743,33775,37935,42095,42095,42127,46287,50512,54705,63290,63323,52691,52659,52691,50513,52658,54739,52690,63257,65502,61143,48431,48399,54638,63157,65469,65469,65436,65435,65402,65401,65402,65434,65435,65434,65468,65469,65468,65369,65335,65368,65401,65468,65435,65467,65401,65401,65300,65235,65202,65137,65104,65039,62958,62926,60878,60846,58766,56686,56686,54638,54638,56718,54638,56720,54640,37803,35723,37837,37837,37837,35724,35756,37936,40049,35822,35790,33644,25257,29516,27371,31564,31662,31662,25323,25323,27371,44242,21130,12678,10565,10598,12679,25421,29649,29648,23407,23439,25487,23374,23405,25518,25454,27568,27568,27600,27568,27599,27599,27600,27600,27568,29648,27568,27600,25552,25520,27600,27632,27600,27600,27568,27600,27600,27600,27600,27600,27600,27600,27600,25520,27600,27600,25520,25552,25520,27600,25552,25552,25520,27601,25552,25552,27600,25552,25552,25552,25552,25585,25584,25585,25553,25553,25552,25553,25552,25521,25553,25553,25553,25552,25552,23439,23439,21359,17002,8549,10662,12774,14918,10789,10727,14954,6469,10791,10821,8740,21259,10597,21228,23406,29843,23537,23537,23537,23537,23537,23602,17133,34135,25683,15118,10762,10762,14923,25684,17199,17134,25586,23440,19214,10728,19115,23504,15019,12775,25388,19049,12743,19082,14888,10662,10630,10630,8550,8517,6404,4291,2146,2145,4258,6339,6339,255},
{52923,48696,33939,29713,29681,29681,29648,29648,29648,29616,29616,29615,29615,31695,31695,33775,35823,33775,33775,37903,40047,42127,44207,46319,48400,52593,63290,63323,50611,50578,52659,52658,52626,52626,52658,63257,65501,54771,48399,50479,54638,65171,65435,65468,65436,65435,65402,65401,65434,65435,65435,65435,65468,65468,65469,65401,65336,65401,65402,65468,65467,65435,65401,65400,65300,65234,65201,65137,65103,65039,62958,62926,60846,60814,58733,56686,56686,54638,54638,56686,54638,56719,56752,39883,33610,35756,35724,35756,35790,37902,37903,40049,35790,33710,31564,31564,33677,33709,31564,27338,23177,25290,27403,23210,35855,21163,19017,14791,12646,12678,23309,31826,29648,25487,25519,25487,25519,25487,25519,27600,27601,27600,29681,29681,29680,29711,29680,29680,29681,29712,29713,29713,29713,29713,29713,29746,31794,31793,31793,29745,29745,31793,31793,31793,31793,31793,31793,31794,31793,31825,29745,29746,31826,29778,29714,29746,31794,31826,31826,31826,31826,31826,29778,29778,31826,31826,31826,31826,29746,31793,31794,29745,29745,29745,29745,29714,29713,29746,29713,27665,27600,23439,23406,19049,25355,16969,14856,12838,17001,25617,8712,12872,12934,10819,8579,4258,16937,14889,27600,38002,37937,37970,37970,40050,33908,19279,19311,27861,25781,12908,10697,12810,12842,12843,15053,21328,16970,17035,14922,14857,19180,8582,12743,19146,16969,12743,19049,12775,12743,10663,10630,10630,10598,10597,8484,4290,32,32,10532,12710,255},
{52922,42358,31826,27633,27600,27600,29648,29648,29616,27568,29583,29583,29583,29615,31695,33743,35823,35855,35855,37935,40015,42095,46287,48367,48400,50480,54771,61176,50578,50546,50546,50578,48465,50513,52658,61111,65370,52625,48399,50478,54638,63090,65237,65368,65435,65435,65401,65369,65402,65434,65435,65435,65468,65469,65501,65402,65368,65401,65402,65435,65468,65435,65401,65367,65300,65234,65201,65136,65071,65039,62958,62926,60846,60814,58733,56686,56686,54638,54637,56686,54638,56719,56752,41963,35690,35723,33643,35724,37935,37902,33676,37968,37936,33710,33710,33678,31597,31630,27371,23145,33775,27404,29516,33743,25356,21130,25356,23210,16904,16904,25324,38100,31793,29712,31793,31793,31793,31826,31826,33874,33874,31793,31761,31793,33874,33874,33873,33873,33905,33873,33873,33873,33873,33841,31793,31793,33841,33841,31761,31761,31760,31728,31728,29648,29648,29615,25422,25421,23308,25389,27534,25454,23341,23309,29811,31859,31826,25520,25520,25455,27568,25584,15181,21164,19115,21228,27600,29713,23309,14890,16970,21229,14857,19083,19083,21163,19050,19083,21131,21229,23407,12744,14856,19147,14823,14856,16969,19081,12872,6502,6437,10725,8706,10819,10724,8548,10662,8452,21196,54513,58545,56434,45967,44052,52535,27667,17133,25683,19377,10859,8648,10761,12843,12811,12843,19215,14890,6372,6437,19213,14889,8517,19114,19114,14888,14856,16969,8549,10695,8550,8517,10598,8517,8452,4387,4516,2080,32,4225,10531,255},
{50810,38100,29746,27601,27568,27600,29648,29648,29616,27567,27535,29583,29583,29583,31663,31695,33775,35855,40015,39983,40015,42095,46287,48399,50512,50512,52625,61110,52659,50578,48498,48465,48432,50512,52625,50512,54737,50512,48367,50478,56751,65302,63058,63123,65435,65435,65402,65369,65402,65434,65435,65435,65468,65469,65501,65434,65401,65434,65301,65268,65501,65435,65401,65367,65300,65234,65201,65136,65071,65038,62958,62926,60845,60813,56685,56685,54638,54638,54637,56686,54638,56719,56752,42028,33610,35723,33643,35756,40048,37902,33676,33709,35855,33710,33677,29516,29516,33743,35921,27436,33742,29516,27468,31694,33775,27403,23210,31760,25422,23275,27404,27437,27470,27502,27469,27469,27469,27502,27469,27437,27437,21130,16872,21163,25389,25357,25389,25357,25356,25357,23308,25356,25356,23276,23276,23276,23276,23276,23244,23243,21163,21163,21163,19083,19051,16938,12744,10565,10597,12678,10598,12711,14824,10631,23505,27665,25487,14954,19148,19214,21229,17359,4778,12744,12744,12777,19115,25487,25423,14857,8551,14857,14889,10663,14857,16937,14824,16905,16969,19050,21294,25455,10631,17001,14856,10630,17002,21228,17065,17001,12806,10821,10819,10787,10724,12838,12839,10597,14856,33745,60726,56402,43887,41838,52339,46390,21359,21293,34135,12842,8615,10729,12843,17134,23538,21294,17101,6372,6470,19246,10630,10662,21162,19049,10662,14856,16936,12776,12776,6437,6436,6404,6404,4258,2210,2274,32,32,4225,8418,255},
{44503,31826,29681,27568,27568,27568,27568,27568,27568,27535,27535,27535,29583,29583,31662,31662,33742,35855,39983,40015,40015,44175,46287,48399,52593,52625,52658,59030,56885,50546,48466,48433,48432,50480,52593,48367,48366,52559,50479,50478,56751,65335,63156,63090,65402,65435,65434,65401,65401,65434,65435,65467,65468,65401,65302,65401,65434,65368,65268,65268,65501,65434,65401,65367,65300,65234,65201,65136,65071,65038,62958,62925,60845,58765,56653,54637,54638,56686,54637,56686,54638,56686,56752,44109,33577,35691,35723,35756,37870,35789,35854,35856,35856,33808,31662,29484,25258,27404,38034,31662,35856,23177,23145,23177,33775,23210,21097,33906,33874,29615,25323,19017,25324,25324,25292,23243,25324,25324,25324,25324,25324,14759,10565,19050,25357,25357,25389,25389,25389,25389,25389,25389,25421,25389,25389,25389,25389,25389,25389,25389,23276,23276,23309,23276,21163,19083,14824,8452,12678,14856,12743,12743,12710,12776,21294,25585,19018,21196,19116,27731,19181,23537,21391,14857,12776,14857,14890,23309,25520,23342,10663,8551,19083,12776,14824,16969,16937,16905,16969,19050,19083,29713,21261,10663,19114,8517,10630,12776,10758,23340,21226,8739,8739,8706,10755,8675,10724,18984,12677,21228,52404,64790,64952,54582,37612,40018,27536,23277,31892,21294,8616,10761,12810,17069,29943,21326,19279,14955,12874,17132,8550,19049,23274,14855,10597,16968,14856,16969,14856,8550,10630,10695,10663,4226,2145,4258,2112,32,32,2113,255},
{42325,31826,29713,27568,27568,27568,27568,29648,27568,27535,27535,27535,29583,29583,31663,31694,33742,35823,39983,40015,42095,44207,46319,48399,50512,52657,54771,56916,56917,50546,50546,48433,48400,48400,48432,44206,44206,48398,52559,52591,54670,63123,63058,65204,65402,65435,65434,65401,65401,65402,65435,65468,65468,65367,65202,65335,65434,65301,65368,65401,65501,65434,65401,65366,65300,65234,65201,65136,65071,65038,62958,62925,60845,58733,56653,54605,54638,56686,54637,56686,54638,54638,56751,44108,33610,35723,37804,37869,31498,29418,31564,29583,31695,31695,29484,25258,23145,29517,27436,31629,35922,23178,27403,29517,29517,27403,23210,27502,29615,27437,27437,27437,29550,29550,27470,27470,27469,27470,27469,27437,25356,19018,19018,23276,27470,27503,27502,27470,25389,25356,23276,23243,25356,25356,23276,25357,25324,25356,23243,21162,27502,23276,16936,21163,29583,19050,12711,10598,16937,21195,10597,6371,8451,8517,14889,16970,16872,23374,14921,27698,19213,11085,21358,21196,12777,14857,14890,16970,23341,27568,19083,8550,12809,23341,12744,16937,16970,16937,16937,19050,27535,21228,31793,21196,12840,10661,6371,8550,8581,12902,14983,8739,8739,8674,8674,8674,21225,35855,23177,16968,33777,58515,62805,58874,44084,43985,44374,34004,31826,36052,27633,21326,19181,14923,23571,19409,6991,4748,17165,12873,8517,23275,21162,12742,14823,19049,12743,16936,12710,8582,8549,8550,6372,4258,2178,6371,2145,32,2113,2178,255},
{40212,35955,29713,27601,27568,27568,29648,29648,27568,27535,27535,27503,29551,29583,33743,33743,33742,35855,40015,42095,44174,46255,48367,50479,50512,56852,56884,56917,56884,50578,48466,48400,44207,42095,42095,42062,44142,44141,50446,52590,54638,60944,63057,63123,65369,65435,65434,65402,65369,65402,65435,65467,65468,65368,65301,65400,65468,65435,65468,65502,65501,65434,65401,65366,65300,65234,65201,65136,65071,65038,62958,62925,60813,58733,56653,54605,56686,56686,56685,56686,54638,54638,56719,46189,33610,37804,37804,37869,29451,23145,18919,18951,21032,21064,21097,29549,27371,29549,27371,23112,31630,27436,31662,33808,25290,27371,23177,23211,29583,25292,21131,23211,23211,23211,21098,21130,21098,19018,19050,19018,19018,16937,19018,16937,19051,23342,19116,16970,12678,12645,8452,6371,14725,21097,16872,16872,25324,27567,16839,14758,29615,23243,10563,25356,29616,14890,8484,16904,16937,19083,8484,8484,10597,6403,10597,12776,23374,21131,19180,19148,23439,19180,19115,25389,14889,12744,14857,14890,21195,25422,25487,14857,10664,19083,21195,10598,16937,16969,16937,16969,21163,19115,21228,27600,19114,10629,8548,8549,10662,8677,6659,8738,6658,6626,6561,10755,21225,16967,21162,10629,19180,46195,60726,48309,54746,41807,58775,33940,19213,19181,19149,17100,21326,23440,25586,29910,13135,8973,21293,12776,12710,23274,16968,12710,16968,16969,14823,16936,12775,10663,8582,4291,4226,6307,4291,4259,6339,2113,32,2145,255},
{40147,38067,35986,31761,27568,29648,29681,29681,29648,27567,29615,31663,31695,33775,33775,33742,33742,35855,40015,42094,44174,46287,48367,50480,52625,61176,61143,58998,59030,50579,50514,46352,40015,37935,39982,39982,40013,39981,46253,52526,54670,58831,60944,63090,65335,65368,65402,65434,65402,65434,65467,65435,65468,65467,65368,65401,65468,65434,65435,65502,65468,65434,65401,65366,65300,65267,65201,65136,65071,65038,62958,60845,60813,58733,54573,54605,56686,56685,54637,56686,54638,54606,54639,44141,33610,37804,35755,37902,31564,27404,25291,25323,27404,27404,27469,33743,27403,18951,21065,27404,29517,29516,31695,31630,29582,31630,18919,23243,31761,23244,23243,25357,21131,21131,23211,23210,25324,25324,19017,16904,16905,23309,19017,14824,19083,25454,16970,12678,8484,8452,10565,8452,8452,14791,16839,14758,21163,23341,12677,14790,25324,27469,10628,31695,25422,12776,16904,18985,18985,19049,14824,12677,10597,12710,10597,19115,27633,21066,21229,16969,23439,19115,10597,16937,23308,12776,12777,16970,17003,21196,25487,23374,12744,10664,23276,16937,10631,16969,16969,16969,19050,19050,17002,19149,27600,21259,10694,6403,8582,8549,8708,12999,25681,23600,12935,12903,14919,6499,14920,14823,12776,29648,58677,46163,52665,37808,50258,52631,25585,17133,29876,14955,8551,10696,12875,23538,21294,19017,25258,18919,18951,25289,16904,14856,19081,16969,12710,16937,14856,10695,8614,2145,2080,2145,6372,6372,4259,4226,32,2145,255},
{40147,38067,38067,31793,29681,29681,29681,31761,33841,35889,35888,35888,35888,35888,35856,33775,35855,37935,40015,42095,44175,46287,48367,52625,59030,63257,56949,61143,56950,48466,44241,44208,37903,35854,37902,37902,39981,39981,46254,50478,54606,63025,63025,60976,65269,65401,65435,65435,65434,65435,65468,65468,65468,65501,65367,65334,65236,65302,65468,65534,65468,65434,65401,65367,65333,65267,65201,65136,65071,65038,62958,60845,58765,58733,54573,54605,54638,56685,56685,56685,54637,54606,54606,46188,33610,37836,37836,37869,29581,29614,29549,29517,27469,29549,29582,29581,29549,23178,31663,27469,25324,27469,27437,23243,29582,31695,21129,23210,29647,21163,25357,31728,25356,21195,21195,23211,25389,23308,16937,16904,16905,25389,19017,12646,16937,25487,12710,8451,10532,8484,10565,8484,8451,6339,14725,16839,16937,14791,12678,19016,19016,29582,19016,33809,21197,10629,16904,14824,16905,16937,12677,6403,6371,8484,12678,21261,21359,21163,21164,17067,12743,10663,12776,12776,21163,21196,12777,14890,17003,17035,23341,25487,19116,10631,14857,25422,12711,12744,16970,16969,16970,16970,19050,16970,19148,27599,12774,6403,10726,10662,12936,36150,42457,44537,36248,27829,29876,23471,19148,21163,14856,19180,46226,56531,39890,54746,43791,60757,36021,19278,23570,29877,10729,8648,12842,17069,17003,17034,19049,12645,21064,23176,20999,20999,23111,21065,16970,14889,14857,10663,8550,8615,4291,2113,65,6339,2146,2145,2145,4258,255},
{38067,38066,38034,33841,33874,31761,29616,33809,35889,35888,35888,35888,35888,37936,37936,37935,37935,40047,42095,44175,44206,46287,48367,56819,63257,65370,59063,54772,48465,44241,37936,35823,35823,35822,35790,35822,39982,46254,48366,52526,54638,58864,60977,65137,65301,65434,65435,65467,65335,65170,65203,65236,65401,65368,65367,65235,62924,65136,65501,65534,65468,65434,65401,65367,65333,65267,65201,65104,65071,65038,62926,60845,58733,56653,54572,54605,54638,56685,56685,56685,54605,52525,52526,46189,35690,29483,29516,29516,29549,27469,27469,25291,23178,25356,25388,23243,23275,23243,23275,23243,21195,21195,23276,23243,21131,21163,19082,19082,19050,19083,19050,16970,16937,16970,16937,17002,16970,14889,14857,14889,19083,19116,16937,12646,16970,21228,10565,8419,8484,8484,10564,8484,8451,6371,16773,21032,14791,12710,12710,14790,12677,25389,31728,31729,16970,14824,21098,19050,19050,16904,10628,8451,10565,10564,12677,14856,12744,12646,16937,23407,19148,12743,10663,14889,14857,25389,19083,14890,16970,16970,19116,23341,25487,14857,10664,19051,25454,12712,14857,19050,16970,19018,16970,25389,16970,19181,12808,4322,6468,8549,23503,38328,27731,25520,38133,34103,27829,36281,25618,14856,10565,12775,29615,60724,44017,52633,46165,52143,54646,25618,15020,32022,21392,8616,10761,15020,21294,23374,14823,10597,19048,21096,14758,16838,18950,19016,25519,27600,25487,17068,12874,25617,17132,12611,12577,12610,16770,16770,16770,16770,255},
{38034,38067,38034,33874,33874,33841,31761,33841,33808,33808,35856,35856,35888,35888,37936,37936,40015,40047,40014,44174,46254,46286,48399,56884,65403,65534,61176,46321,40048,37968,35855,33743,33742,33742,33710,33709,37869,44174,46254,48333,52559,52526,52558,58798,65203,65468,65468,65401,65301,62957,60844,60779,62991,63023,65367,65202,62924,63023,65501,65534,65468,65435,65401,65367,65333,65267,65201,65103,65070,65038,62925,60813,58732,56652,54572,54605,54638,56718,54605,56685,52460,48267,50380,41996,31498,25258,27469,25388,29550,27469,29549,27403,25258,25356,23276,18984,21065,23177,23210,21130,23178,21130,19017,19050,19050,19050,16937,16937,16970,19018,16970,16970,14857,16938,14857,14889,14889,14889,14857,14857,16970,16938,14824,12711,19018,12711,8451,8451,12677,10596,10564,10564,8451,6371,12645,25258,21065,14790,14855,16969,12742,21130,31761,27536,14857,19050,16969,23244,21196,14791,8484,8516,14791,12710,10597,8484,6371,6339,14727,17002,19213,14921,10597,12776,12776,19050,27502,16970,12809,14890,17003,19083,25422,23341,12744,12744,23309,21131,10566,16969,19115,19083,19050,23276,19050,14922,19213,12774,6467,8549,31989,32054,14987,14955,14923,36118,27472,31925,25520,21033,8548,8548,14986,46324,62935,58840,52568,43919,64983,38101,25617,29942,23473,8583,8615,10794,21294,21261,10597,10629,21161,21096,12710,14822,16871,10597,10663,14921,17002,17067,14954,17166,21392,18982,18882,23043,23043,23043,23075,20995,255},
{38066,38067,38034,35922,33841,33841,33808,33776,33808,35856,35888,35888,35888,35888,37936,37968,40016,40047,42095,44174,46286,46286,50512,58932,61144,59064,46353,42160,37968,37936,35855,33742,33710,33710,33710,33709,35789,39981,44141,48333,52559,50479,50446,54606,62992,65335,65335,65202,65104,62925,60844,58731,58731,58730,65269,65268,65004,65104,65502,65534,65468,65435,65401,65367,65333,65267,65201,65103,65070,65006,62925,60812,58732,56652,54572,54605,54638,56718,54605,56685,54573,54573,52493,41996,31466,25257,27435,29484,25258,25225,31563,29450,25192,29450,25224,21031,23111,27303,23078,21031,25257,23144,21031,21098,16905,16937,19051,19083,16970,14824,14824,16970,19051,16970,14857,12776,14856,16937,16938,14857,14890,14824,14792,14792,16905,14791,8451,8452,12678,10564,10564,10564,8484,8419,8452,21097,23210,12677,19016,12678,12710,16904,25389,25422,14824,21130,14856,12710,12677,10564,6371,8517,10597,8484,6371,6339,4258,8549,14888,8484,19180,14920,4289,8483,14856,14888,23276,25422,12777,14857,17002,16970,21196,25454,21196,10663,14857,25422,12744,10631,16970,19050,19050,21131,19082,16970,19116,19147,8547,10662,34103,25716,12874,19246,19214,21294,33778,27342,33681,25162,14628,12645,10728,25454,60656,64818,64757,62610,64755,58841,29746,31989,17068,4357,6535,12842,19180,17034,8517,14823,23242,19049,12709,19016,14790,10630,10662,10662,8517,10695,17165,10696,12744,14921,6305,6305,6305,8418,8386,6306,255},
{40147,42260,40180,35921,33776,33809,33808,33808,33808,35856,35856,33775,35888,35888,35888,37936,40015,40047,42095,44174,46286,48399,50480,46321,44240,44240,40048,40016,37968,35855,33743,33710,31662,31662,33678,33709,35757,39949,44141,48334,50479,50446,50414,52493,58766,63024,62991,65169,65104,60844,58731,58699,58698,58698,65237,65467,65135,65235,65502,65502,65468,65467,65434,65400,65333,65267,65169,65103,65070,65006,62893,60812,58700,56652,54572,54605,54637,56718,54605,56653,54573,54573,42029,23178,25290,27370,27370,25258,25258,27370,27338,25259,25259,27436,23177,16903,18984,19017,18952,19017,19017,16872,16872,19050,19083,16970,14825,14857,16937,16970,19050,16970,14824,14824,14857,16970,14889,14824,14857,14857,14890,14856,12678,16970,19018,16872,6371,10597,10597,10565,14758,10597,8484,8451,8452,16870,23210,18951,14789,8484,10532,10564,21163,27502,18984,21131,16937,10597,8451,8484,8484,8452,8484,10565,14823,10565,6371,12776,10695,6371,14856,12743,6403,6371,10597,12743,16969,25389,23276,12809,16970,16970,19148,21229,23374,14857,12744,19083,25389,10598,12743,16970,19050,21131,19050,16969,17002,17035,4323,12743,32088,23603,19246,14987,21326,17100,36150,23473,36151,29584,22917,29389,29713,25552,44080,54353,50258,48241,40046,52341,33875,27730,27828,12940,6633,10728,21260,17001,8485,14855,19048,14855,12709,19016,14823,19049,12743,12743,14758,14791,6437,10597,8485,12743,4226,65,2145,6339,2146,2178,255},
{42260,44373,40179,35921,35888,35921,35889,35856,35888,33808,33775,33775,35855,35856,35888,37936,40015,40047,42095,44175,46286,50447,48400,40015,37936,37968,37936,37936,37935,35855,33743,33710,31662,31630,31629,33709,35757,37869,44141,46253,50446,50446,50414,50413,52493,58765,60813,62958,62925,60812,58731,58699,58698,60779,65302,65534,65168,65301,65502,65502,65468,65467,65434,65401,65366,65267,65169,65103,65070,65005,60845,58732,58700,56652,54572,52525,54638,56718,56653,56653,54573,54605,37836,21098,23178,25290,27369,27403,27436,27403,29451,29484,29485,27436,25323,18985,18985,18985,19017,19050,19082,16970,19018,19083,19051,16970,16970,16937,17002,17035,17002,17002,16970,16970,16938,14824,14825,16970,14889,16937,14857,12711,10598,16905,19051,14824,8419,14791,10565,8451,10532,8451,8451,8419,10532,12677,19017,16838,12676,10564,8452,8484,19017,27502,21130,19017,21163,10597,8451,8484,8452,8452,6371,14824,23308,21260,10662,10630,10597,6339,10597,17067,12809,12776,12743,19083,16969,10597,23276,21196,14857,14890,19083,19083,23374,23309,12744,14857,21196,19083,10631,14857,16970,21131,19050,19050,23276,16970,8549,12840,36248,23635,19213,14889,25422,19246,27698,23538,34135,29974,17035,16904,19083,21294,27698,29811,29714,27342,27406,27601,25585,25552,31924,19278,360,6535,19082,12775,10565,19016,21128,14790,12709,16903,12710,14791,12678,16838,20966,8386,4193,12776,12907,14857,6372,2113,4226,8387,2145,2178,255},
{42260,40147,38034,35921,35921,35889,33808,33776,33776,33776,31695,33775,33807,35888,35887,37935,40015,40015,42095,44174,46286,48399,52624,48433,35855,35887,35823,35823,37936,35855,33743,33743,31662,31662,31629,33677,33677,37836,42029,46221,50446,50446,50446,50413,52460,56652,60813,62893,62893,60844,60811,58731,58698,60811,65368,65468,65234,65367,65502,65502,65501,65467,65434,65401,65366,65266,65168,65103,65070,62925,60812,58732,56652,56652,54573,52525,54638,56718,56652,56653,54573,54573,39948,23178,25290,27370,29483,29516,31597,31629,31662,31629,27371,25323,25356,19017,21098,21130,19017,16904,19050,21131,19083,19050,16969,16937,19018,19018,16970,16937,16937,16937,16905,14857,14824,14792,14792,14792,14792,14792,12711,14824,14792,14791,16905,16905,14824,16970,12677,14791,12710,10564,10532,8452,12677,8451,8419,10564,16903,10596,8451,10564,14823,29583,27470,16937,16937,14823,10565,8484,6371,10565,19083,25422,29648,27600,14823,8549,12743,10629,8517,21261,21294,17067,10629,12808,14921,16969,21163,29615,19050,14857,17002,16970,23407,23374,19083,12776,14889,21228,14824,10598,16937,16970,19083,19082,19082,16937,12743,17034,36281,25748,19246,25422,31565,23309,25520,27731,29877,34233,21457,10661,8484,8484,19180,29811,27633,27439,29454,29681,31924,29778,31891,29778,23309,17002,17066,10630,14823,21161,21129,10629,14855,14855,10630,10663,12710,16838,12678,6273,6338,10728,13006,4490,4293,2113,4226,4226,4323,4323,255},
{40147,38034,38002,35953,35889,31728,29615,29615,33776,33808,33775,33775,35856,35888,37935,37935,40015,42095,42127,44175,48334,48399,48367,40048,35855,35855,33775,35823,37935,37936,35855,33775,33743,31662,31629,33677,33677,35756,39948,44141,48366,46253,48333,50413,50412,54540,58764,62925,62957,62958,65070,62924,58698,62957,65434,65468,65367,65468,65502,65502,65501,65468,65435,65433,65366,65266,65168,65103,65038,62925,60812,58732,56652,56652,52492,52525,54638,56718,56653,54605,54572,54573,50413,39916,31563,27305,29451,29516,31565,31565,31596,27370,23145,29615,33939,16839,14726,16806,16806,16806,14758,16807,14726,14726,14726,14726,14758,18953,16872,16872,16872,14792,14759,14759,12679,12679,12679,12679,12679,10565,10533,12678,16937,14792,14824,14824,14824,16905,12677,16871,19050,14791,16904,14758,12710,6370,6371,8451,16871,14757,8419,12678,12677,27470,27502,21196,21131,21099,19050,19082,17002,14759,21229,25422,35987,25454,12742,6403,17034,19082,12742,14856,23439,17067,6370,8517,19148,21261,14888,21195,29582,16970,16970,14890,17002,21163,23341,14889,12776,14889,23276,10599,10631,16969,19050,19083,19050,16969,16970,23308,38329,27861,21327,23179,35856,23244,25488,31957,25651,34200,23538,10694,4322,6403,10662,23439,27763,27698,25650,27730,29811,29843,31924,33907,33679,27405,23179,16839,23276,23308,23308,16903,25453,21162,21162,23274,21129,21096,16837,10465,8416,14723,14854,10563,14658,14657,14690,12577,10562,12611,255},
{40147,35954,33809,31728,27535,25455,29583,31696,33808,33776,31695,33775,33775,33775,35855,37935,40015,40047,42127,44207,48334,50447,46287,37935,35855,33775,33775,35823,35855,35855,35855,33775,33743,33710,33677,33677,33677,35756,39916,44108,46253,44141,44141,46252,48300,54539,58732,62925,65071,65268,65335,63023,60778,63056,65501,65534,65502,65502,65534,65534,65501,65468,65467,65401,65333,65266,65200,65103,65038,62893,58732,58700,58700,56620,52492,52525,54638,56718,54605,54605,52492,54573,48300,31497,31498,25224,29451,31564,29451,31532,29451,23079,25225,27568,36117,16871,14693,16839,16871,16904,16839,16839,16839,18952,18985,16937,16937,16904,14791,14791,14759,14759,14791,14791,12712,19149,16938,16905,14857,14792,14792,16905,19018,14792,14791,14759,12678,10565,10532,10596,25421,16904,10597,19049,14791,6338,6338,6338,12645,16838,12677,21195,10564,23243,21163,21164,18985,21131,25422,27601,27633,16938,16937,16970,33841,14790,10596,8516,8484,10597,10629,8516,19181,23407,14889,10630,14889,19115,21260,23341,29582,27470,14857,14857,19083,19083,21261,23309,12776,12744,16970,21163,8518,12711,16970,19050,16970,19018,16969,19147,40409,30007,23570,19116,33776,31728,21261,31925,25618,32055,12939,8613,14854,10660,8515,12841,25585,25617,25585,23504,23472,23471,23471,25520,33940,31794,23114,20935,21131,10532,20998,25155,25155,23043,25156,25155,23075,23075,25122,23010,20961,20961,18849,18817,18849,18881,16769,14657,10497,12578,255},
{35986,33841,29616,27535,25454,29615,33808,33808,33776,31695,29582,31662,31695,33743,35823,37935,37967,37967,42095,46287,48366,50447,54639,48399,35855,33775,33775,35855,35855,35823,35823,33743,33710,33710,33677,33677,33677,35756,39916,44109,46221,44109,42028,44108,46187,52459,58699,62892,65071,65334,65434,65302,65203,65368,65534,65502,65502,65534,65534,65534,65501,65501,65468,65401,65333,65266,65168,65103,65005,60844,58732,58700,58700,56620,52492,52525,54638,56718,54605,54605,52492,37802,25224,25192,27305,27371,29484,27338,25257,25225,25257,27306,25225,25324,29648,21130,21065,21131,19082,19017,16937,19018,19050,21163,19083,19050,19018,16937,16937,16970,16938,14858,16905,14824,12712,19182,23277,16872,14792,16905,19051,16937,16872,14824,14791,12711,12646,8484,10532,10565,21162,14823,16838,25356,14856,6370,6371,6371,8452,20967,18919,12743,10597,23276,19050,19018,19050,21163,27568,33940,25455,19051,23309,21196,25388,12709,10564,10564,10564,8451,6371,12807,23472,23472,21294,17067,10662,17035,21228,23309,23276,29615,21196,14889,16970,17002,19083,23309,19115,12744,12744,21196,16969,8518,14824,16970,14857,16937,19050,19050,38198,36281,25683,19214,27568,35921,23309,31924,25585,32087,15019,4354,16967,12806,6468,14954,25584,23439,21359,23407,23406,23406,23374,23406,27665,23342,16905,14661,23407,21098,14724,18917,18949,16869,18950,18950,16869,16837,8418,6273,6305,4225,4193,4193,4193,6339,4193,2145,2113,4225,255},
{33841,31728,27535,25455,25455,33808,33840,33776,31695,29615,29582,29550,29582,31662,33742,35855,35855,37935,42095,46287,50447,52527,56784,48400,35855,33775,33775,35855,35855,35855,35823,33742,33710,33710,33677,33677,33677,35756,39916,44109,44173,42061,42028,42027,46187,52427,58699,62892,65038,65301,65434,65434,65268,65501,65535,65534,65502,65535,65535,65502,65501,65501,65468,65433,65333,65266,65168,65070,62957,60812,58732,58700,58700,56620,52492,52525,54638,56718,54572,54572,52460,27272,23111,25224,27305,33710,29549,23144,25257,25225,25257,25258,25290,23178,25324,21098,18985,19018,19018,19051,19018,16873,14792,16905,21164,23277,21196,19017,16937,19018,21131,19017,18984,18919,16904,17004,21196,14792,14792,14792,16937,19050,16905,16905,14856,14856,14791,10532,8452,12678,14823,16871,23080,18984,19114,8451,8451,8451,6371,20934,25160,10597,16904,25357,21163,21099,19050,23276,29681,27568,29647,33905,33905,31759,19081,8484,8451,6403,8451,6371,8484,21293,25520,23439,23407,17034,8548,12808,19180,23373,19115,19050,27469,19051,12776,14857,16970,21196,23309,17002,12744,14857,23309,14824,10598,14857,14856,16937,21130,19050,31793,40442,27828,17166,19181,31761,25455,34005,25650,27861,8613,4386,4355,14954,10695,14986,27665,25552,21294,21294,23406,23406,23374,23309,25357,23147,23114,19050,19148,18985,12678,14856,12710,12710,12743,10630,10597,8484,33,65,65,32,65,65,4194,4258,2113,2113,6304,10529,255},
{31761,31728,27567,25455,31728,33840,33776,31695,29615,29550,27470,27469,27469,29549,31630,33710,35822,37935,42095,48335,50479,52591,46319,40015,35823,33775,33743,35823,37903,37903,35823,33742,33710,33710,33709,33709,33709,35788,39916,44109,44141,42028,41996,41995,46154,52426,58699,62892,65070,65367,65435,65235,65070,65368,65468,65501,65501,65468,65502,65502,65501,65501,65501,65434,65333,65266,65168,65070,62924,60812,58732,58700,56620,56620,52492,52525,54638,56718,54572,54572,52460,44074,39882,37770,33642,33709,27339,21031,23112,23112,23144,23144,25258,25324,27502,21065,18985,19018,18985,16840,16904,16937,19019,19018,16905,16905,16937,19082,21163,21131,21098,16904,18984,18919,18985,17037,23342,16904,16905,14824,16905,19018,16937,16905,14856,14824,19115,14791,8419,12710,16903,14758,21031,12677,14823,14790,12677,8419,6371,14725,27371,21098,23243,21163,21195,19050,19050,19050,33906,29648,29680,36017,33905,29679,14855,8451,8451,8451,8484,6371,10597,16970,12744,17035,23439,8580,4289,8549,17067,23374,19115,21163,25421,29582,16938,14825,16938,16970,19115,21196,14889,12744,14857,23276,8517,10598,14857,14824,19050,19018,23276,40409,32055,19376,14955,14922,27665,34037,27796,30007,10792,4353,4355,23374,12841,19245,27633,25520,25519,23407,21326,23341,21099,27373,31696,25389,19050,14889,14857,14889,12710,16936,12678,14823,14790,12710,12710,6371,32,65,64,32,65,65,4194,2145,2145,2178,6305,6336,255},
{31761,31728,27567,29615,33841,33808,31695,31695,29615,27470,27437,27437,27437,27437,29517,31629,33742,35855,40047,46319,50479,44207,37903,35855,35823,35823,35823,35855,35855,35855,35823,33742,33710,33678,33709,33709,33709,35788,39948,42061,42028,41996,39948,41995,46154,52394,58667,62892,65070,65268,65301,65070,65004,65069,65168,65201,65234,65366,65502,65502,65502,65502,65501,65434,65333,65266,65135,65038,62892,58732,58700,58700,56620,56620,52492,52525,54638,56718,54572,54540,52460,52460,54540,46156,37803,37803,27337,27337,29418,29450,27337,27338,29451,23211,27502,21065,18985,19017,19017,16840,16872,16905,19018,19017,16937,16905,19017,19018,18985,18985,19083,16939,16872,18919,18984,16938,21163,16872,16905,16872,16872,16905,16905,14824,14792,14792,19083,19050,10532,10564,10532,8451,10564,10532,8451,23243,23275,16839,10598,8484,21195,23243,25389,23276,23309,19050,25357,23276,38165,38165,27567,23341,23308,14854,10628,8516,8451,8484,8451,6371,6371,6338,6338,10663,23439,17034,10629,10630,14922,21261,25454,27567,25389,29582,23308,12776,14889,16970,16970,21163,21163,14857,10631,16904,12710,6437,10598,16905,16970,16937,19148,36117,36314,25748,17101,10729,34037,29713,29615,29844,19115,10628,4321,12776,12841,25519,25584,25520,23471,23439,23439,23277,20937,18985,19115,12808,23374,17003,12744,14856,12742,14855,10597,12710,12710,10629,8484,2145,0,32,32,32,32,2113,4226,2112,2145,4226,2113,0,255},
{35921,31728,29616,31728,33840,33776,31695,31663,29582,27469,27437,27437,27405,27436,27437,29549,33710,35822,40015,42127,40047,37903,35855,35855,35855,35855,35855,35855,35855,35823,33743,33710,33710,33710,33677,33709,35757,37836,39948,42029,39948,39948,41996,42027,46154,50346,56618,64972,65069,65201,65102,65004,65004,65004,65036,65069,65068,65168,65502,65534,65502,65502,65501,65433,65333,65266,65135,65005,60812,58732,58700,58668,56620,56620,52492,52525,54638,56717,54572,54540,52460,52460,52460,46188,35690,35690,37803,37836,39917,37804,31497,29417,27305,23243,25357,21065,18952,18952,18952,18985,18985,16839,16872,16872,16872,21065,18952,16872,16872,16872,18953,18985,16871,18919,18951,18919,23210,23211,21065,18952,18984,18985,14791,14759,14792,14792,12711,12678,10565,10565,10532,8419,8419,8484,8484,16936,23243,25259,16970,8452,10630,23276,21163,23309,19018,21131,21195,27502,31793,29681,25520,23341,21130,12676,8483,8483,8451,8484,8452,6371,8484,21326,23407,14889,19115,23406,10629,6402,8582,17068,23374,23309,21228,25389,25389,12776,14889,14889,17002,21163,21196,19083,12743,12711,16936,12743,6404,10630,14889,14857,23439,21195,42424,34136,27828,31924,40246,29746,25291,27241,23077,12642,6337,14823,21228,27633,25552,25520,25519,23439,23439,23406,27600,21326,10695,8516,17034,25454,19147,12742,14823,14791,12678,12742,10630,6371,2211,230,198,197,197,197,131,2211,6404,6436,6437,6437,8550,4292,255},
{35921,31728,29615,33808,33808,31695,31663,31663,29582,27470,27437,25389,25357,27404,27436,29517,31662,33774,37903,37935,40015,37935,35855,35855,35855,35823,35823,35855,35823,35823,33743,33710,33710,33710,33709,33709,35757,37836,39948,42028,39916,39916,41995,42027,46154,50313,56585,64972,65102,65168,65102,65036,65004,65037,65036,65069,65035,65201,65535,65535,65502,65502,65501,65433,65333,65233,65102,62924,60812,58731,58700,56620,56620,56620,52492,52525,56686,56685,52492,52460,52460,52427,52460,48267,35657,35658,35723,35723,35691,35691,27272,31499,25225,25291,23210,21065,21032,21097,21065,21065,21097,21065,21065,21098,23178,21065,21065,23211,23244,21131,21066,18952,23144,23111,23112,21031,20999,18918,18885,16806,18919,18919,14726,12678,14824,14824,12711,8452,10532,10532,10532,8451,8419,12677,10565,19017,29550,25259,23375,12809,12711,19050,23243,23276,19050,23276,31727,31727,25421,31794,29680,14792,10565,10596,10564,10564,6403,6403,8452,8484,10564,23472,23407,17001,14855,21326,10662,4290,6371,14922,21228,23342,23374,14889,17002,12776,14889,14857,14889,19050,19083,23276,16970,12711,12710,16904,8517,10598,12743,21261,17067,10663,31695,33647,35956,44473,31665,29746,17100,14791,25224,23078,25126,29549,29745,29746,25519,25520,25520,25487,25487,21261,19148,17100,10760,6371,12710,14823,12710,10597,14855,10597,14823,10629,6371,6404,4291,132,132,164,198,263,198,2407,6470,10663,8615,6502,8583,6437,255},
{35921,31696,29615,33809,33776,31695,31663,31663,29582,29550,27437,25389,25356,27404,27436,29549,31662,33742,35855,37903,40015,37935,37903,35855,35823,35823,35823,35823,35823,35823,33742,33710,33710,33710,33709,33709,35757,37836,41996,41996,39916,39916,41995,44043,46154,50313,56585,64939,65102,65168,65135,65037,65036,65069,65200,65134,65068,65267,65535,65535,65534,65502,65501,65433,65333,65233,65070,62892,60780,58731,58700,56620,56620,56620,52492,52525,54638,56685,52460,52492,52460,52459,52459,48235,33609,35690,37803,37804,35690,37803,31465,29450,27337,25291,25291,21097,21065,23211,21162,21130,21130,21098,18985,19018,21131,19050,19050,16937,19018,21098,21131,23211,21097,18984,18952,21032,21032,18984,18952,18984,21065,18985,14759,16839,16872,10597,10565,10532,8452,10532,10564,8451,8451,10565,12678,16936,16904,25357,27568,10630,12678,19050,23243,19018,21163,25389,23309,16970,21196,33939,23342,8485,8452,12710,14822,10596,8483,8451,6371,6371,10564,12743,12743,14823,14822,19147,21326,14922,8549,12743,19181,23374,23341,12710,14856,19083,16937,12744,12776,17002,17002,21195,23276,14856,12679,16904,12743,8550,12743,25585,10631,10630,16968,19016,23145,27274,27144,23080,23115,21228,25357,29550,29484,31695,33971,33971,29518,27405,27437,25454,25487,14922,8550,8615,19311,6501,8484,8517,10597,10597,14823,10597,14855,12743,6371,6371,4291,32,32,32,32,32,2113,4291,4194,4193,2113,64,2145,2113,255},
{35889,31728,29615,33808,33776,31695,31663,31630,31630,29582,27470,27437,27436,27404,27436,29549,33710,35822,35855,37903,40015,40015,37935,35855,35823,35823,35823,35855,35823,33742,33742,33742,33742,33710,35789,35789,35789,39916,41996,39916,39916,39915,41995,44043,46122,50313,56585,62891,65167,65233,65168,65069,65036,65101,65233,65200,65100,65301,65535,65535,65535,65502,65501,65434,65333,65200,65037,60812,60780,58699,56620,56620,56620,56620,52492,52525,56686,56685,52460,52492,50314,48233,46154,41994,33610,33577,33642,33611,33578,31498,33577,31497,33578,27403,25290,21064,18951,21032,18984,21064,21097,23177,21064,21097,19017,16905,19018,19018,21131,21163,19083,19017,19017,19050,21130,16938,23276,23178,21098,21098,18985,16872,16872,16872,14758,12678,10564,10532,8452,10532,16839,16904,12645,8451,10532,10532,14726,25324,19082,10564,10597,19018,23276,19050,21163,19050,25421,23374,21294,29746,16937,8420,8485,16904,14823,12677,10597,8484,6338,4290,8483,6370,10629,12742,12709,12775,23407,21261,17035,10630,17067,21261,19115,17001,14823,19115,16970,12744,12744,14889,16937,19050,23276,23244,12743,10598,14823,10565,19148,23407,8517,12743,12742,8546,4289,4289,12644,23048,29356,29681,31826,35955,33841,29615,27633,25552,27503,27470,27405,29452,27339,18919,14758,10728,15085,15019,14790,14823,19016,16903,14823,16936,10565,12742,12742,14823,12743,8484,32,32,32,32,32,4194,2113,6338,4225,2113,32,0,255},
{35856,31696,29583,33776,31696,31663,31663,31663,31663,29582,29550,29517,27437,27436,29516,31597,33742,35822,35855,37935,40015,40015,37935,35823,35823,35823,35823,35855,35823,35791,35790,33742,33710,35757,35789,35789,37837,39916,39948,39916,39916,39947,41995,44042,46154,50345,56585,62890,65266,65332,65266,65102,65069,65101,65134,65166,65100,65335,65535,65535,65535,65502,65501,65434,65333,65167,62925,60812,58732,58699,56619,56620,56620,56620,52492,52525,56686,56685,52459,52460,52459,54507,52427,48267,35690,33577,33577,29384,27304,25192,33544,33610,33643,29484,25290,23145,21032,21097,21097,21097,21097,21097,18984,23177,21098,18985,21163,19050,19018,19083,21163,19082,19050,19017,21098,12778,25488,21163,19050,21098,16937,19050,19050,19018,16937,14824,10564,8451,10532,10564,12645,14791,12677,10564,8484,8419,18919,29648,25454,19050,19050,23276,23244,21130,25357,21065,25291,27698,21229,27502,10598,8452,12646,16937,12678,10597,8516,8452,8517,12743,12742,8483,8484,10597,12677,8516,19148,23407,23374,10662,12743,19115,14855,6402,6403,12743,19050,21196,14889,12776,14857,16938,19050,23276,21163,12711,12711,16937,23440,17035,8485,14856,14822,8514,4290,4257,8548,19113,12709,14855,27567,38067,38067,35987,27373,25325,25487,25520,25487,25487,18985,14595,12547,23081,21033,23439,17001,19016,16903,18984,16871,14823,14823,8484,8517,10695,12743,6404,2210,65,65,2145,2178,6405,2145,2145,4258,2145,2112,2113,255},
{33808,29615,31696,33776,31695,31663,31695,31695,31695,31663,31662,29582,29549,29517,29549,31629,33742,35822,37903,37935,40015,37935,37903,35823,35823,35823,35823,35823,35823,33775,35790,33742,33709,35789,35789,35789,37836,39916,39916,39916,39916,41996,41995,44042,46154,50345,56553,62890,65334,65399,65300,65167,65101,65133,65167,65166,65133,65367,65535,65535,65535,65535,65501,65434,65300,65102,62924,60811,58731,58699,56619,56620,56620,56620,52460,52525,56686,56685,52459,52492,54507,54539,54507,50379,37770,35625,37770,35690,33609,35657,33544,33675,31563,25258,23210,21097,18984,21130,21130,23178,21130,21098,21065,23178,25291,23243,23276,23276,23211,23211,23211,25291,23178,21098,21065,12647,23375,21098,16807,14792,14759,19018,19083,16905,14792,14824,12678,10532,10532,12644,10532,10564,10532,8484,10532,8451,21032,31826,21228,14791,21163,25357,21131,23276,25357,23146,35922,36150,17003,21163,8452,8452,12711,16937,10565,4258,8484,17002,21326,17068,17001,8483,6371,8484,8484,10565,14889,23439,21326,14888,8548,23407,19181,14888,6403,10630,12743,19082,19115,12744,14889,16970,21196,19050,21196,19050,10598,19115,25488,12744,8517,14856,21162,14822,16967,12742,17001,14918,10659,12709,19049,31695,31727,31793,27405,27341,31761,31891,29778,27632,14921,14922,10696,14824,23276,27665,25519,25519,27534,23243,21032,16871,19017,14889,8681,8681,14823,14757,21063,18983,18951,18982,21030,18949,18916,16804,14691,16835,18915,18915,255},
{33776,29615,31696,33808,31695,33743,33743,33743,31695,31695,31695,31662,29549,31597,31630,33742,35855,35855,37903,37935,39983,37935,37903,35855,35823,35823,35823,35823,35823,33710,33710,33710,33710,35789,35789,35788,37836,39916,39948,39916,41996,41995,41995,44042,46154,52393,56552,62890,65334,65400,65366,65199,65134,65166,65231,65231,65165,65366,65535,65535,65535,65502,65501,65434,65267,65069,62892,58731,58699,58667,56619,56620,56620,56588,52460,52493,56686,56652,52459,54540,54540,54507,54507,52459,41962,33577,37738,35658,33609,31562,31530,31596,31563,29484,27371,25258,27436,31630,27403,29549,31728,33775,31630,35856,35888,33808,33809,29550,29485,27372,33776,31597,25193,18919,18919,16872,19149,16872,16840,16905,16872,16937,21163,19018,16905,16970,16937,19050,12645,10564,10564,12644,10532,10532,12645,14725,20967,27437,31859,23276,25324,27470,21164,23277,23244,21164,36020,42424,25455,16937,10565,10565,14791,14791,8485,6372,12776,23440,25683,19246,17035,10662,6370,6370,6371,19082,17002,23374,21293,10662,14954,31924,23374,12774,6369,6403,8516,14823,19082,19082,12744,14857,16937,14857,19082,21195,14889,21359,23374,16904,10565,14791,16904,14791,21129,40212,31825,8547,6434,12742,25388,31695,31793,25552,25520,25520,27665,29778,31859,25552,25422,25293,19084,23375,29844,31989,19246,19083,27469,31826,19050,18918,18917,18983,23143,23109,23043,23075,25155,23043,20995,23043,20962,20963,20963,16803,16803,14723,14690,12642,255},
{31728,27503,27502,29615,33808,33775,33743,33743,31662,33743,31695,31662,31630,31630,31662,33742,35822,35822,37903,37935,39983,39983,37935,35855,35823,35823,35823,35823,33743,33710,33710,33710,35757,35789,37837,37836,37868,39948,41996,39948,41996,41995,41995,44042,46154,52393,56552,62857,65366,65468,65401,65232,65166,65199,65265,65265,65231,65367,65535,65535,65535,65534,65501,65433,65233,65037,60844,58731,56651,56619,56619,56619,56620,56588,52460,52493,54637,56652,52459,54572,54572,54539,54507,54507,41994,33544,35690,35690,33643,27435,27371,27370,29451,29516,27371,27371,27371,29451,29484,33775,33743,35888,35887,29549,31662,31598,33710,29485,33776,29517,27404,27372,27437,18886,18919,16937,17102,21163,16872,18953,16872,16904,19050,19018,16905,16937,16937,14824,12645,10564,10564,12644,10532,8451,10532,14693,23178,35987,36052,29615,25357,27470,23309,23244,33874,27666,29649,36085,23310,12678,12710,12678,14791,8420,8485,10631,21229,25585,23472,17068,10631,12743,6403,6338,10630,23341,27600,19049,16968,17002,19181,16970,23309,23307,12741,8484,10630,12743,14856,23275,16937,14824,14824,14857,14857,19050,21261,25520,17035,14791,10565,14824,14791,12711,14823,35986,27566,8547,8514,12741,29582,31825,27665,25520,25552,25552,25552,25552,21293,17068,23342,27503,31664,29454,27438,23342,19017,20966,20934,25389,29810,20997,20963,20996,23075,23075,20963,23043,23042,20930,18882,20929,18849,16769,14657,8385,4193,32,65,65,255},
{29615,27503,27503,27535,33776,33775,33775,33775,33743,33743,31662,31630,29582,29549,29549,29549,31597,33710,35790,37902,39983,40015,37935,35855,35823,33775,35823,35823,33742,31630,33710,33710,35757,35789,37837,37836,37868,39948,42028,41996,41996,42027,44043,44042,48233,52393,56584,62857,65400,65535,65502,65299,65231,65232,65299,65332,65266,65367,65535,65535,65535,65534,65501,65400,65167,65005,60812,58699,56619,56619,56619,56619,56588,56588,52460,52493,54637,56652,54539,54572,54571,54539,54507,54539,41962,31496,35657,35690,33610,29516,29516,31596,31597,31597,31597,33710,29484,27370,27371,31662,33776,38001,33742,33742,31597,31662,33775,31662,33809,31695,27469,33841,27437,16773,18886,18952,14858,23244,18952,16872,16937,19018,19050,19017,16905,16872,16905,16872,12678,12645,12645,10596,10564,10532,14693,20999,27469,27437,21130,23275,27470,23276,23276,27470,38132,29681,27535,27568,21164,16904,14791,12678,10565,6339,12744,17035,25487,21293,10565,10565,10565,10631,8484,6339,21229,27633,31859,19082,17002,21294,14791,10565,19050,25454,25422,19083,10630,12743,14856,16937,21163,16937,12744,14856,19050,14857,23374,25520,16969,12678,8517,12711,12711,12711,12743,23307,21162,10693,25420,23275,31727,29745,25552,25552,25520,25552,27632,21294,14987,27796,23570,23537,31859,21067,23147,25325,20934,20900,25192,17003,17002,21029,23109,20996,18883,18916,18917,16804,18917,14724,8418,6337,6273,6338,10597,6338,32,32,65,2145,255},
{31695,29615,27503,29583,33776,33775,33743,33743,33743,31662,31630,29549,29549,29549,27436,27436,29484,31597,33709,37870,39982,40015,37935,35823,33775,33775,33775,35823,33710,31630,33710,35790,35757,35789,35788,37836,37868,39948,42028,41996,41996,42027,44075,46154,48233,52393,56584,62890,65435,65535,65535,65366,65265,65299,65367,65367,65265,65399,65535,65535,65535,65534,65501,65366,65102,62924,60812,56651,56619,56619,56619,56587,56588,56588,50412,52493,54637,56652,54539,54572,54539,56587,52426,54507,39849,29350,33577,37770,35658,31563,31531,31563,31596,31564,33710,31597,25225,27403,27371,31630,33874,29549,29515,35855,33775,38001,33776,31663,31695,33776,29517,33776,27404,16773,18886,18951,18951,23243,23211,21065,18984,21097,21130,21065,14791,14759,14759,14791,14759,10564,12645,14757,10564,8451,16773,27208,31533,23243,14791,19049,23243,16904,23276,29583,33874,23277,27567,27470,16905,14759,10565,10565,6371,6339,10631,21229,23374,12678,10564,6371,6371,10597,12711,10630,19115,27536,29616,16937,21229,31826,14824,12678,14758,21228,25422,21261,12710,14857,19115,19049,21130,21195,12744,14824,16970,16905,25455,25520,14889,12679,10565,14823,10598,12678,12678,16936,29582,29582,27566,29680,31826,27600,27600,27600,25552,23439,21293,15019,21424,36216,21457,23472,23212,20935,16774,21034,12680,17002,16970,10663,10663,16936,14790,16903,12677,10597,14790,10597,12710,14856,10630,8485,6404,2178,4324,19081,8516,0,6338,10564,255},
{35856,31695,29615,33776,33776,31662,29582,31630,31662,31630,29550,29549,29517,29516,27404,27404,27436,31564,33677,35822,39982,40015,37935,35823,33775,33775,35823,35823,33710,33710,35790,35757,35757,35757,35788,37836,37836,39948,42028,42028,41995,42027,44107,48234,48265,52424,56584,62890,65468,65535,65535,65399,65299,65366,65435,65467,65300,65401,65535,65535,65535,65535,65501,65300,65069,62892,58732,56651,56619,56619,56619,56587,56588,56588,50412,52493,54605,56652,54539,54572,56619,56619,54506,54507,37736,27270,35657,37770,37803,31464,27271,31497,33676,31563,31662,31629,27371,31629,33775,29549,31663,18918,23079,31597,31597,35888,35888,31727,29485,31630,29484,31662,25226,23078,25158,25158,23111,20999,18918,18918,18885,18918,21032,18951,14726,14726,14726,14726,14758,10564,12645,18983,12644,12677,18919,27339,29420,25356,16904,21130,21163,16936,23276,31760,29615,21196,25422,27535,8452,8452,8452,8452,8452,6371,8452,21196,17002,8483,10564,6370,6338,8451,10597,12678,21130,27470,25325,19050,16937,23309,19017,14791,12645,16904,23341,23340,12709,8516,12743,8516,12710,16969,14889,14824,14857,16970,25455,25454,19083,12711,10565,12710,12678,10565,10598,12743,25388,31792,33906,31793,29680,27632,27600,27600,27568,25487,19180,19278,21457,34103,25586,27503,25358,25455,23342,17068,6635,2443,21327,21261,12776,6339,14823,21162,12710,10565,8484,4291,4324,6437,6404,4291,2178,65,2211,10728,25387,10597,12644,25353,255},
{35888,35888,35856,35888,31663,29582,29517,29550,31662,29582,29549,29517,29517,27436,27403,27403,27403,29516,33709,35821,39982,40015,37935,35855,35823,35823,35823,33775,33710,33677,33710,35789,35757,35756,35788,37836,37836,41996,44108,42028,41995,42027,44107,48234,50313,52424,56583,62922,65501,65535,65535,65434,65366,65400,65501,65501,65366,65467,65535,65535,65535,65535,65468,65234,65037,60844,56651,56619,56619,56619,56587,56587,56588,56588,50412,52493,54605,56652,54540,56652,56619,56651,56586,54506,35688,27304,29417,31497,31497,29417,29417,29417,31498,31530,29484,31597,31630,31662,35855,33710,27403,18951,27402,27370,33709,35855,31663,29582,29550,31630,29517,31696,27470,23210,23112,23111,21032,21065,21064,21097,21032,23144,23177,18984,21064,16839,16806,12613,14758,14726,16871,19016,12678,16936,12677,21129,29517,33809,23276,27469,23243,19049,25356,29616,31761,23277,31826,25389,12646,12646,12711,12678,8484,6370,6338,16937,23471,10629,8451,8451,8451,12646,16872,14792,21098,23243,16871,14823,14824,16970,19082,16903,12677,12645,21196,19113,8514,4257,8484,12775,14823,17001,12743,14856,10663,17002,23374,21261,14857,12776,10598,10597,10597,10597,10630,12776,12743,23276,19082,16937,19082,27502,23276,23308,25389,14856,8550,10728,19181,23212,29584,25423,25618,25520,10663,12777,13072,266,331,8648,8517,4258,12742,14855,14823,6372,4323,4356,4323,4291,4259,2178,2146,65,65,2276,12775,25387,14823,25288,255},
{37936,35888,35856,35856,31695,31630,29517,29517,29550,29549,29517,29517,29517,27404,25323,25323,27403,31564,33708,37902,39983,39983,37935,35823,33775,33775,35823,35823,33710,33677,33709,35757,35757,35756,35756,37836,37835,41995,44108,42027,41995,42027,44106,48234,50313,52424,56583,62955,65501,65535,65535,65468,65400,65434,65501,65501,65401,65501,65535,65535,65535,65535,65434,65200,65005,60812,56651,56619,56619,56619,56587,56587,56587,56588,50380,52493,54605,56652,54572,56652,56651,56651,54506,54506,33575,23144,27338,27338,27370,29451,29451,29418,29450,31530,25225,33776,38133,35888,33774,33743,27403,27403,31629,33742,31596,33774,31663,25291,27437,23210,31630,33842,33809,18918,14693,18920,23146,27470,23178,31662,31495,29284,23076,16773,18951,21032,21032,14725,14758,12645,14758,21097,18984,27437,14757,14757,19017,21130,23276,27470,21098,21162,25356,25324,29648,27503,29713,19116,14889,16938,16970,16970,14857,10564,6370,12711,27698,17034,8484,10565,14823,18985,21130,12678,19017,21098,16871,14758,19017,21131,16937,14821,12677,10564,14823,21194,8547,8483,6403,14856,12742,8516,14823,19050,14824,17002,21262,21261,12711,10630,10598,12678,10565,10597,12710,12711,8517,10598,12711,12679,12711,19050,21163,14791,23309,16937,6404,6534,12841,23212,23473,21392,29811,27698,25487,19213,13007,267,2444,15019,6371,2178,6370,8451,10596,10597,6404,4291,6404,4291,4259,4291,4291,2178,65,2178,4389,14856,12677,6371,255},
{35888,33807,33775,33775,31695,29582,27469,27469,29549,29517,29517,29517,29516,27404,25323,25323,27403,31563,33708,37901,39982,37903,37903,35823,33742,33775,35855,35790,33710,33677,33709,33709,33708,35756,37804,37835,37835,41995,44108,41995,41995,41995,46154,48233,50313,52392,58632,62922,65468,65535,65535,65501,65467,65468,65502,65501,65468,65535,65535,65535,65535,65534,65367,65134,62924,58731,56651,56619,56619,56619,56587,56587,56587,56588,50380,52492,54605,56652,54572,56652,58732,58699,54506,54506,33543,23176,27370,27370,27370,29450,27305,29418,31531,31563,27370,33710,33776,27404,33742,33710,29517,31597,31596,33677,33710,33775,29549,23177,29517,18919,31630,35954,29517,16805,12611,21000,21066,21230,25357,25356,27371,23177,21097,21098,19017,21130,23211,19018,16904,10564,8451,10531,16904,27502,23275,23276,14856,14757,21130,23243,21097,23145,14758,19017,25422,23374,23407,19148,19148,19148,19116,17035,17003,21195,14791,14792,25487,14889,14824,21164,18985,23211,21097,12678,14791,12710,14824,14759,19050,21131,19049,10628,12709,10564,10532,19115,21196,21196,12776,10663,14889,16969,16969,14823,19050,19148,21229,21228,12711,10598,12711,12743,10598,10565,12711,12743,8485,8517,10630,12711,12711,17002,29713,16937,16905,25389,16969,21260,10663,10696,23668,15151,29843,27828,21392,31924,19280,2443,10926,12808,2177,4291,10662,14790,12643,14790,12775,8517,19017,6371,4259,6469,6436,4291,2145,65,2145,4291,4258,33,255},
{35888,33775,31695,31695,31662,29582,27469,27469,29517,29516,29516,29516,27436,27403,25323,25323,27403,31563,33708,37901,39982,37902,35822,35823,33742,33742,35855,35790,33710,33710,35789,35757,35756,35756,37804,37835,37835,41995,44108,41995,41995,44043,46154,48233,50280,52392,56584,62856,65434,65535,65535,65502,65501,65502,65534,65502,65502,65535,65535,65535,65535,65501,65300,65069,60844,58731,56651,54539,56587,56619,56587,56587,56587,56588,50380,52492,54605,56684,56652,56684,58732,58699,54506,54506,39848,25191,27337,27337,29417,29417,29417,31530,31530,31530,29451,29483,27338,23144,23177,33775,33775,38001,29484,27338,33775,33840,31662,27371,18951,14693,25323,38099,29647,18918,14725,16806,12645,14956,27568,18953,18920,16872,16872,19018,21131,16905,16904,14824,14791,14791,12645,10532,12645,18984,31793,33971,23275,18984,25388,23210,23144,27240,16838,19017,27502,25487,21261,19116,19148,19116,17035,16970,19050,27502,25389,16905,19050,16937,21131,21130,18984,16870,6371,8483,14791,14758,10565,14823,19050,16937,23209,19015,10596,12709,8451,14758,21228,23342,21261,10597,12743,14856,10630,6371,14824,23374,25455,19148,12744,10598,12743,14791,12678,8485,10565,12710,10598,8485,10598,12711,12711,12743,19018,19082,25389,16970,25421,27534,14856,10663,23570,23603,23505,25650,19246,36150,29876,27763,25618,10663,4258,12743,17002,12743,14754,21058,10695,10695,8484,4291,6404,10663,8550,4259,65,32,0,32,2178,65,255},
{35888,35855,33743,31695,31662,29550,27469,27469,29517,29484,29484,29516,27436,25323,25323,27371,27403,31563,35756,39949,40014,37934,35822,35855,35822,35790,35822,35790,35790,35790,35789,35757,35756,35756,37835,37835,39915,42027,44076,41995,41995,44042,46154,48233,50312,52424,56583,60808,65434,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65467,65233,65037,60812,58731,56619,54539,54539,56619,56587,56587,56587,56587,50380,52492,54605,56684,56652,56684,58732,58699,56586,54506,46121,31463,31495,37802,35722,33576,31464,33611,31529,29418,29451,29549,25225,21031,23144,29516,33709,31663,25323,20999,31630,33743,33776,33841,27468,21032,23112,29549,25257,23079,29418,21032,16871,14858,23277,16840,18953,18985,16904,19050,23243,19017,16937,16937,14792,21229,21196,12677,10499,16773,31564,36019,25356,16936,25356,23146,27371,29353,14725,16903,27534,29647,19149,19116,19148,19116,17035,16938,21195,27469,25356,23243,25323,12709,16969,19016,10563,6370,8451,14790,19017,14823,14791,16937,19050,14824,16870,18983,10564,12710,8451,8451,19082,19148,23374,10629,6371,10597,10630,12776,16937,23342,29713,21228,12743,8517,12711,10630,12711,10598,8452,8485,12742,10598,8485,10598,12711,12679,12711,12743,23276,25421,16969,27470,19082,19083,19213,36215,34102,27796,21457,31989,38263,36182,19278,6404,4258,16903,12710,17002,14821,12675,10629,8549,10662,6404,6469,8549,6469,6437,2178,2178,2146,32,65,32,255},
{35856,33775,33743,31695,31662,29550,27469,27437,27436,27436,29484,29516,27404,27371,27371,27371,29451,31563,35756,39981,42094,40014,39983,37903,35822,33742,35790,35790,35822,35790,35789,35757,35756,35756,37803,37835,39915,44107,42027,41995,41995,44042,46153,48201,50312,54472,56583,60776,65401,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65367,65167,62956,58763,58731,56619,54539,54539,56587,56587,56587,56587,56555,50380,52492,54605,56684,56652,58732,58732,58731,58699,56586,44041,31463,31430,46188,39882,31430,29383,29450,23177,25257,29451,29516,20966,25224,27370,31596,35855,31663,23177,21031,29517,23177,33776,33874,31695,27403,16773,23144,23145,29452,27338,18886,21064,14924,21229,14759,16905,16937,16904,18985,23243,21098,16937,16937,16904,23308,14791,12612,10532,18853,33644,33873,21130,19017,25324,21097,25356,21031,14756,16804,25225,27404,21163,19017,14823,12711,16937,19082,23243,29713,23243,25356,21129,8483,8483,12676,8450,6370,6370,10532,14791,16872,14791,16904,14856,14823,12709,10564,8451,10597,8484,8451,8516,14888,21228,10662,4257,6404,12776,19083,21261,27633,19181,21229,12711,6437,10631,10598,8517,12711,8517,8452,10565,14823,10598,8517,10630,10663,12711,12711,14824,25455,14857,12711,23309,27535,25455,27731,38295,40474,32023,23570,40376,36150,19245,6371,8452,16903,10532,12809,12675,20992,14723,14822,8451,4291,6436,6437,6404,8517,6437,2146,2178,65,0,2113,255},
{33743,31662,33743,31694,29582,29550,29517,27436,27436,27436,29484,29484,27436,27403,27371,27371,29451,31563,35788,42061,40014,39982,37902,35822,33742,35790,35790,35790,35789,35789,35789,35789,35788,35755,35755,37835,41995,44107,42027,41995,41995,44074,46153,48200,50312,54472,56583,60711,65235,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65501,65299,65102,62924,58763,58699,56619,54539,54539,56587,56587,56587,56587,56555,50380,52492,54604,56684,56684,58732,58764,58731,58666,54506,39881,29416,29449,37836,37804,31530,31562,27337,23177,23177,29549,27403,23079,27338,29484,35856,35888,29549,21031,21063,33774,25290,29517,31630,27436,27468,14724,18919,25357,25389,18951,18918,20999,16938,23342,21098,16904,16937,16904,18985,19018,18985,19017,16904,12678,14822,12611,12612,10564,10532,21096,19016,14758,21130,23210,21064,23209,21064,18917,14692,18885,27337,23177,18919,14725,14822,29648,14856,19049,29680,21130,19016,12644,8451,10531,10531,8451,8419,10531,12677,16904,16872,14791,18985,14823,10596,10628,12708,10627,12741,8516,8483,6370,10597,19147,19115,10662,4258,8550,17002,21228,25487,23374,23374,12776,6404,10663,10598,8517,8517,10631,8517,8452,10598,14823,8517,8517,10631,10663,12711,12711,27600,23309,19050,16937,27502,27567,25487,21392,23505,36248,32055,42521,29844,15019,8516,8452,8484,6372,14856,10596,10530,14757,25321,12644,6371,4356,6437,10662,4324,8517,6404,98,2178,2146,2211,255},
{31662,31662,33742,31662,29582,29549,29517,27469,27436,27436,27436,29484,27436,27403,27371,27403,29451,31563,37836,39981,39982,37902,37902,35822,35822,37870,35822,35790,35757,33709,35757,35757,35788,35755,35723,39882,41995,42027,41995,41995,41994,44074,46153,48200,50312,54504,56551,58663,65167,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65433,65200,65004,60844,58731,56651,54571,54539,54539,56587,56587,56555,56587,54507,50379,52492,54572,56652,56684,58764,58731,58699,56618,54537,31496,25256,29418,29450,29450,31531,31563,25257,23177,25257,27403,29484,29451,29516,31630,37969,31662,23177,23144,20998,35920,35921,31695,33808,31695,33776,23177,18919,29516,35822,18918,16773,20999,21065,19017,21098,21098,21065,21097,23211,23243,21097,18984,14790,12644,10531,12611,12611,12644,12612,12676,12676,14790,25291,23178,25257,25290,23111,20998,14725,14692,23110,16837,14724,12677,27534,33873,23276,21098,18984,12644,8451,8450,8451,8451,8451,8418,10499,12645,18952,14791,14791,16904,21131,19017,8548,12774,14854,12740,14885,14854,8483,6371,8484,21228,19180,19180,4290,4257,10663,17002,23374,23374,21294,12744,6372,17035,10663,8485,8485,8517,10663,8517,10566,12678,14823,10598,10598,10631,10631,12711,14824,14824,21195,21195,14824,23276,27568,17002,8550,19246,21424,31989,25650,12840,6403,6404,8549,6404,14790,19016,10598,8485,16902,23175,10595,8484,6437,6469,8550,6404,8549,4324,2178,4291,2178,255},
{31662,31662,31662,31662,31630,29549,27469,27436,27436,27436,27436,29484,27436,27403,27371,27403,29451,31563,35755,39981,37902,37870,39982,37934,37902,37902,35822,35790,35789,33709,33709,35756,35788,35755,35755,39882,41995,42027,41995,41995,44042,44074,46153,48200,52360,54472,56551,58663,65167,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65434,65167,62924,60844,58731,56651,54571,54538,54539,54539,56587,56555,56555,54507,50379,52460,54572,54604,56652,56684,58699,56650,56618,52425,25190,25191,27304,25223,25223,27304,27336,25256,25257,27337,27337,29483,29516,33742,35823,33742,31597,27404,25225,25257,29516,33775,31695,35888,29582,31695,31629,23145,25290,37935,23111,18853,23112,23145,25258,25258,23177,23111,21063,21063,23176,20999,16838,12611,10531,10531,12611,12611,14725,16838,16837,12676,18983,18984,16903,18982,21031,23079,18885,18951,10563,16868,12675,12643,14790,25389,33840,29647,19049,10531,10563,8450,6338,8450,8451,8451,8451,10532,18951,19016,19017,14791,16936,19050,14790,8515,8547,10627,12739,12772,10628,8451,8451,8451,12743,23373,17067,10630,6371,8484,12776,21261,23407,23439,12809,6372,12776,8550,8485,8453,8518,10598,12712,10631,8485,14791,14824,10598,10630,10630,12711,10663,12711,14824,23341,23309,14857,25422,17002,10631,14922,19279,15118,12873,6403,6371,10695,12776,10598,12677,18983,16903,6404,4258,16902,12709,8452,8485,4324,8550,10662,6404,8517,6437,2210,2178,255},
{31630,31662,33710,31662,31630,29517,27436,27436,27436,27436,27436,29484,29483,27403,27403,29451,29482,33643,37835,39981,39982,37902,42062,39982,39982,39982,37870,35822,35789,35789,35757,35756,37804,37803,37803,39882,44075,44075,42027,44075,44042,44073,46153,48200,52392,54472,56551,58663,65200,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65400,65200,60843,60811,58731,56651,54571,54538,54539,54506,54506,56555,56555,54507,50379,50412,52492,54604,56652,56684,58698,58698,56585,52393,25157,23110,27271,27303,27335,27335,29384,29416,29417,27304,25224,29451,33710,35920,33774,25224,29548,29516,27403,27370,29483,21031,25290,35888,31662,31629,31564,27371,31565,27338,25191,27205,27238,29385,25224,21031,23111,25192,23112,25257,27370,25258,16871,12644,12611,10531,12644,16903,14757,25258,21064,18983,18983,14725,10531,12611,12611,16804,14724,14692,12612,18983,18983,23177,21097,21098,33808,29680,25454,14757,8450,10531,10499,8418,10563,8451,6370,8419,10564,16871,18952,16871,16904,14823,12742,10660,12805,14886,14918,12772,8515,8451,8484,8452,8484,17001,21294,19148,19115,14857,10631,17035,23407,23439,12744,6372,19083,19082,8485,8453,8518,8518,8550,10663,8485,8517,14791,14823,10598,10630,10630,10631,10631,12711,14824,25389,25422,14889,23341,25454,25454,21261,17263,12841,12710,8517,6633,17002,6404,12710,18983,16936,16969,4259,4291,4291,6404,12743,8484,4259,6436,6437,4259,8582,4356,2178,255},
{29549,31662,33710,31662,31597,29517,29485,27436,27404,27404,27404,29483,29483,27403,27403,29450,29482,33642,37835,42029,39982,39982,42094,42062,42062,42062,39982,37870,37869,37837,35788,35756,37803,37835,37835,39914,44075,44107,44075,44074,44074,46153,46153,48200,52360,54504,56551,58663,65135,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65334,65101,65069,60811,58763,58731,56619,54539,52459,52458,52458,54506,56554,56555,54507,50379,50412,52492,54572,56652,56651,56618,56618,56586,54505,44008,44041,46186,56719,50413,35656,29350,31463,33609,27271,29450,33742,33677,35855,33709,25224,31564,33677,31596,27337,33742,23144,21031,35888,31661,25257,29516,31629,31597,31629,29484,16805,23177,23145,25291,27404,27371,29517,27371,25323,25291,19016,14724,14724,12643,10531,16837,16871,18951,23177,23177,23209,19016,23145,20998,18885,12643,14724,16870,14757,12611,16838,21097,25291,21098,19050,31728,33906,27632,19082,16968,19081,21227,19114,23340,23340,21260,21293,21293,25487,25520,29713,25520,23471,23439,27665,21391,23406,21260,19049,8516,8483,8484,8452,8484,10564,19115,19180,21261,19148,14921,12808,21326,23440,10663,4292,16970,16970,8420,6372,6405,6437,8550,10663,10631,8517,8517,14791,14824,10598,10598,10630,10631,12711,12711,12744,23374,17002,12776,25422,27567,25454,25487,23603,15020,10597,10630,23243,19017,16969,25386,10859,12807,16903,6469,4356,6470,8713,10695,8484,8485,8549,10630,8517,8549,4323,255},
{29517,31629,33710,31662,29549,29549,29517,27436,27404,27404,27403,29451,29451,29451,29451,29450,29482,33642,37835,42061,42062,42062,42094,39982,42062,39982,39981,39949,39949,37869,37836,37836,37835,39883,39915,41994,44107,44107,44075,44074,44074,46153,48200,48200,52359,54503,56551,58663,65069,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65334,65036,62924,60811,58763,56651,56619,54538,52458,52458,54506,54506,56554,56554,54506,50379,50411,52459,54572,56652,56651,56618,56618,56585,54505,54506,52394,54539,63057,54640,35655,31430,29383,31496,29416,31595,33676,33675,31531,31596,23111,33708,31628,33709,27403,31629,23112,21031,31596,27338,23111,29550,31662,33742,31629,33742,25225,27370,25291,35856,29484,25258,29516,27339,27404,25290,14692,12611,16870,14691,16805,14757,21064,23079,18918,14692,16870,23177,23144,25191,27272,14756,12643,12611,12644,12676,21063,31792,29680,33971,27665,27633,27665,27698,27633,23407,21359,21359,27665,21294,19213,19181,25585,17068,14955,14987,25552,12907,8680,6600,21326,12874,12808,16872,19018,10629,8483,8483,8484,8451,8452,10565,21293,19180,23374,17067,8550,17068,21359,10696,4291,14856,14824,10533,6372,6405,6405,8518,10598,10598,10631,8517,8517,14823,14791,10598,10598,10631,12743,10631,10630,21294,27600,14857,14922,27567,29647,27535,25520,21457,17068,14757,16904,21163,23307,44238,19114,14987,23206,14822,2145,4291,4389,6666,4389,8517,8484,6372,4323,2178,2210,255},
{29517,31597,33742,33710,31630,29549,29517,27436,27404,27403,27403,29451,27403,29451,29450,29450,29450,33610,37803,42060,42094,40014,40014,37902,39982,39982,39949,39949,42029,39981,39948,39916,39915,41963,41995,44075,46187,46155,44107,44074,46122,48201,48200,48199,52391,54503,56583,58695,65069,65534,65535,65535,65535,65535,65535,65535,65535,65535,65400,65134,62955,60843,60811,58731,56651,54570,54538,52458,52458,54506,54506,54506,56554,54506,50379,50379,50411,52492,56652,56619,56618,56585,54505,52425,52425,50313,54506,63023,52559,35623,31462,27270,33544,31497,27304,35723,35755,29483,31596,23110,31530,31596,35822,29483,33774,23144,25224,31596,25289,23143,31662,31663,31695,18918,29549,29451,16804,21030,35888,29483,35790,29517,29517,29517,25356,14692,16806,23145,14757,21097,14724,27338,27240,25257,18951,25258,27404,21096,23144,31532,21096,10499,14757,21065,18984,35854,40147,23243,31760,19116,16970,12809,14987,23406,12809,12841,12874,23472,14922,14954,14922,23439,12874,8648,10761,19213,17068,10729,8680,14987,17132,12841,8517,10663,10662,6403,8451,8451,8484,8451,8451,12710,27567,19148,19180,8549,10695,17068,14922,4291,12776,12743,12743,12679,8485,6437,8517,8518,8518,10630,10631,6437,8485,16872,14823,8550,10598,10663,10630,10631,12776,16970,21163,23341,21195,29615,27535,27535,25749,21523,12808,14791,23276,14921,31693,37963,21127,23175,21061,12678,2145,2146,2341,8778,21128,12677,6339,2178,4291,4259,255},
{31597,33710,33710,33742,31662,31629,29516,27436,27404,27403,27403,27403,29451,29450,29450,29450,29450,33610,37835,44140,44141,40014,39982,37902,37870,42062,42061,42061,44141,42061,41996,39948,41995,44075,44107,46187,46187,46155,44106,46154,46154,48233,48232,48232,52391,54503,56583,58695,65168,65501,65535,65535,65535,65535,65535,65535,65535,65535,65267,65101,62923,60811,60811,58731,56650,54570,54538,52458,52458,54506,54506,56554,56586,54506,50347,50379,50379,52491,54571,54571,54538,54537,54505,52424,52393,48200,54507,65072,54639,35655,31462,31430,33543,29383,29416,33643,35756,35724,33676,29417,27271,33676,35854,25257,33775,27370,29483,31661,25290,25289,31597,33775,27404,20966,29516,29516,16772,16804,29483,33775,42129,33710,31662,31629,29517,18951,14757,21064,23209,29582,16870,25257,27272,21031,16870,25290,25291,21063,25257,29484,25323,14758,16904,23210,27436,42194,35953,27436,29582,23309,14922,14889,17035,25552,17067,14987,14987,25584,21261,19245,21294,25552,23472,19246,19278,23472,27665,23472,23472,23504,27698,21392,19246,17067,10662,6403,8483,8483,10564,10564,8419,8452,16937,17034,19180,10662,6436,12874,14987,4324,12776,12711,10630,12743,14824,8550,8517,8517,8517,8518,10631,10631,8517,10598,16936,14791,10630,12743,10598,10631,10631,10630,12711,25421,23309,21196,27534,27567,27600,23668,15053,14921,21163,10761,8681,29644,40010,21096,16936,18984,10597,2146,2178,12808,23274,14823,10630,8517,8484,4259,255},
{33677,33742,35823,33742,31630,29549,29484,27436,27404,27403,27403,27403,29451,29450,29450,29450,31530,33642,39947,46221,46222,42094,39982,37902,37870,37869,39949,42029,44109,44108,44108,42028,44075,44107,46187,48267,48267,46187,46154,46154,48202,48233,50312,50280,52391,54535,56583,60743,65335,65535,65535,65535,65535,65535,65535,65535,65535,65535,65300,65135,60842,60810,60811,58731,56618,54538,52458,52458,52426,54506,54506,56586,56586,54474,50347,50379,50379,52491,54571,54538,54505,54537,54505,50344,50312,46152,52426,63023,58865,41993,31462,33576,35656,33609,33676,33676,35789,35625,31497,33675,29417,35821,35822,29483,33709,25224,31564,37968,33709,33709,37902,33710,23144,20966,20998,27403,20998,14691,23144,40114,42227,37936,31597,29516,27436,21032,18951,23144,18950,21096,16804,21031,21063,14724,16837,21065,23177,21063,23177,18950,12644,21065,19050,25323,40016,40081,33776,36019,29713,31891,23472,25552,27665,29843,27665,25552,23439,27665,27633,23439,23439,21391,27665,15052,15052,17100,25520,14987,12907,12874,21359,12842,10663,6372,8549,8516,8483,8484,10564,10597,8484,8484,8484,16970,17067,17002,8517,12809,10728,10631,12743,10630,10565,10630,14889,14857,10631,6437,8485,8518,10631,10631,10663,8518,12711,16937,14824,12711,10598,10630,10630,12711,12711,12743,21131,19017,16936,25421,27567,27666,23636,14986,14921,6404,6470,12777,27305,16740,18953,19017,16904,10630,4324,10662,21163,19115,8550,6339,10565,4291,255},
{33709,33742,35822,33710,29549,29516,27436,27404,27403,27403,27403,27403,29450,29450,29450,29450,31530,35722,44075,48301,46222,44142,42062,39950,39949,37869,37869,44109,44141,44140,44108,44108,46187,46187,46187,48267,48235,46186,46154,46154,48233,50313,50312,52359,54471,56583,56583,60809,65434,65535,65535,65535,65535,65535,65535,65535,65535,65535,65468,65135,60810,60810,58730,56650,56618,54538,52458,52426,52426,54506,54506,56554,56554,54474,50346,50346,50379,52459,52490,52458,54505,54537,54505,50312,48232,46152,48265,62958,58832,46219,33510,33543,35656,37803,33709,35756,33610,33577,37869,33676,31563,33675,37903,31629,20965,20997,29483,31564,31629,31629,33644,31628,23144,16739,14691,23144,31630,25225,27403,40114,38034,33742,29548,29516,27371,16838,21097,25225,18916,12643,14723,12610,16837,18950,18918,23177,18983,14756,16869,10562,10530,12644,19017,29483,44241,37903,46452,33874,21163,27600,12874,10793,17035,21326,19181,14922,10729,14955,21326,12809,10729,12842,23439,12842,10761,12842,21358,12842,8648,10761,17100,14955,10728,4323,8517,8516,8484,8483,10564,10596,10564,10597,8451,10597,19180,21261,19148,12841,8550,12776,8517,8516,6371,8550,10663,14921,12776,10695,8517,8518,10630,8518,8550,8518,8550,14824,16904,14824,10598,10630,10630,12743,12711,10631,14792,16969,14824,16969,25454,27567,27731,17198,10695,10630,21159,19046,27239,14499,10403,12646,17003,16969,6436,8517,21228,19148,14889,8484,6371,10566,255},
{33741,35822,37903,33742,29517,27436,27404,27403,27403,27371,27371,29451,29450,29450,29450,29450,31530,35722,44107,48333,44173,42061,42061,39949,39949,39949,39917,39948,44140,46188,46188,46220,46219,48267,48267,48267,48266,46154,46121,48234,48233,50313,52392,52391,54503,56584,56583,62890,65367,65434,65535,65535,65535,65535,65535,65535,65501,65400,65435,63022,60777,58730,58730,56650,54570,54538,52458,52458,52458,52426,54505,56554,56554,54474,50346,48266,48298,50411,52458,52457,52425,54537,52424,50312,50312,48233,48299,58765,56720,48299,33541,33543,33543,33576,29350,37803,35722,33609,39949,33642,31530,35789,37870,35790,20964,20997,31597,33677,33775,29549,27338,33677,25257,18917,18917,21031,33775,35824,33710,42195,38001,33677,29484,29483,25225,21032,23177,27305,18916,14723,14691,12610,18918,18918,21032,25258,14756,12611,14723,12611,10531,12643,18950,40015,40049,37935,40049,38067,21163,25421,14922,14922,14954,17068,21294,14922,14922,14987,25520,14987,14922,17035,23472,19181,17100,17133,23472,21359,17133,19278,21391,23504,19278,19181,17067,10630,6403,8451,8451,10564,10564,10564,10564,8452,17034,19180,21326,14954,10630,10597,8451,6370,4258,6404,8518,12776,12777,14922,14889,8518,8517,8517,8518,8550,12744,10598,12711,18984,12743,10630,10598,10631,10630,10630,12711,12679,14824,12711,16937,27502,27535,25618,15085,12776,23237,21124,25218,14723,2114,6307,10696,16970,16904,14823,19115,19180,12777,12776,6437,6437,255},
{35789,37902,37902,33742,29516,27436,27404,27403,27371,27371,27370,29450,29450,29450,29450,31530,33610,37802,46188,48365,46253,44141,44141,39981,39949,39948,39948,39916,42028,44140,46220,48300,48267,48267,48267,48234,48266,48233,46153,48233,50313,52392,52424,52391,54503,56616,58664,60809,65068,65135,65501,65535,65535,65535,65535,65468,65267,65101,65004,60842,58729,58697,58698,56650,54570,54538,52458,52458,54506,54473,54505,56554,56553,54441,50346,48266,48298,50379,52458,52425,52425,54505,52424,52424,50312,50312,54572,58765,54607,48300,35622,33542,35623,35656,31495,33609,37803,33577,35722,31496,29417,31498,33643,35821,20964,18884,29483,31596,35887,31661,31564,33677,27337,20998,20998,21031,29549,35888,29516,27371,35888,31596,29484,27403,23144,23145,23112,21062,16836,12643,14723,12611,14691,16837,25225,25290,14757,12611,12643,12611,14724,18918,27368,42161,33709,50547,33742,35921,25421,29712,25519,23439,23407,23472,29810,25519,25520,25584,29778,25520,23472,23439,27665,21359,21294,19213,23472,19181,14987,14954,19246,14954,10663,8550,8550,10598,6371,6371,8451,8483,10564,10564,8484,8452,12743,21261,21294,14954,10728,8549,6402,6338,4225,4226,6404,10631,12744,12809,23374,17002,8550,8517,8518,8550,14857,10631,8518,12711,19016,12743,10630,12776,10598,10598,10663,14824,16970,12711,12743,16937,27567,27600,25716,19279,23239,16868,8418,25249,12611,4227,8420,10598,16871,19050,14889,8648,8681,8583,14856,8550,255},
{35821,35822,35790,31629,29516,29484,27404,27403,27371,27371,27370,29450,29450,29450,31498,31529,33609,37802,46188,50413,50446,50414,46253,42029,42029,41996,41996,41996,42028,44107,46188,48300,48299,48267,46186,46154,50346,48233,48201,48232,50312,52392,54471,54438,56583,58696,58696,60809,65135,65101,65435,65535,65535,65535,65535,65367,65068,65036,62955,60842,58729,58697,58697,56650,56618,54538,54506,52425,54505,54505,54505,54473,54473,52393,50346,48266,48298,50378,52426,52457,52457,52457,52424,52392,50312,52425,54605,58765,58799,54606,39814,35589,37703,33543,35657,35722,35722,33577,33577,35690,29384,31465,35756,37935,23110,20964,27304,29449,31596,33709,35823,31596,27338,20998,20966,25225,27338,33742,31596,29516,40146,33775,29483,25257,21031,18918,14723,16803,14723,14723,14723,12643,12578,16804,27337,27337,16804,14691,12643,14757,16838,23112,42128,35823,44241,42096,44208,46419,31826,27567,27632,19180,17132,17100,27633,14856,12743,14889,19148,10696,12809,14922,19181,12809,12842,14955,17165,14922,14922,14987,17068,14922,12841,10663,8518,10630,8516,8483,6371,8451,8484,10564,8484,8484,10597,19180,19213,14954,12841,10629,8450,4290,4225,4291,4291,8582,10663,10696,12809,21261,19116,8551,8518,8550,10663,10598,8550,8518,12711,18984,12743,12711,10598,10630,12711,12711,21163,19082,14791,12711,19083,27534,27600,25781,21291,16902,8485,10530,27330,14659,8355,10468,12614,14824,10598,6470,2342,6470,12743,14856,255},
{35789,35790,33709,31629,29517,29516,27436,27403,27371,27371,29418,29450,29450,29449,31497,31529,33609,39882,46220,50445,52526,52494,44141,42061,42028,42028,42028,42028,42027,44107,48267,48299,50347,50347,48234,48234,50346,50313,50280,50280,50311,52391,52390,54470,58663,60809,60777,60808,62955,65168,65501,65535,65535,65535,65535,65334,65068,62955,62922,60842,58729,58697,58697,56650,56618,54538,54505,52457,54505,54505,54473,54473,54473,52393,50346,48265,48298,50378,52458,52457,52425,54505,54505,52424,50312,52425,56653,58797,63024,58799,41861,35588,35622,33575,37802,37769,35656,37803,29350,31463,31464,31497,37901,35822,29483,23110,27304,29449,40081,40081,33710,35822,33710,29516,25225,31564,29484,23144,31629,33709,42227,35921,35889,33776,25323,18950,21063,18884,18916,14723,14691,14691,16804,16837,25224,27338,21030,14724,14691,14756,25289,33709,44242,35790,48402,40048,42128,42194,33809,23276,27567,12808,12841,17035,23342,19148,14889,17035,14921,14889,16970,19148,12776,12743,12776,17068,10630,10598,8550,14987,8517,6404,6404,8452,10598,12711,10630,6403,6370,6338,6371,8516,10564,8484,8484,17002,17100,14954,8582,8516,8450,4257,6371,8517,8517,12776,12776,10728,12842,14922,21229,23342,10664,8550,10598,8518,8550,8518,10631,14823,18984,12711,10598,10630,10663,10631,12711,14824,12711,14856,14791,14824,23276,23407,21489,14888,14856,10630,21158,27329,12578,10435,10533,16970,19050,16936,14889,14857,8452,16970,255},
{31629,33677,33709,31629,31564,29516,29484,29451,27403,29451,29450,29450,29449,31497,31497,33577,35689,39882,48268,52493,52493,52493,48333,46221,44108,44108,44108,44075,44107,46220,48299,50347,50346,50346,48233,48265,50345,50313,50312,52360,52391,54471,54470,56550,58696,60842,60809,62889,62954,65400,65535,65535,65535,65501,65201,65201,65102,62955,62922,60810,60777,58729,58697,58697,56618,54570,54537,54505,54505,54505,54473,54473,54473,52393,50346,50313,50345,52426,52457,54505,54505,54505,56585,54473,52392,54505,56685,58765,60944,50379,39781,35588,37735,39849,39915,33543,33543,37802,27236,29350,33641,37902,33609,37902,33742,23077,31530,33676,40048,35855,31629,40049,33710,31629,29549,33709,29516,25225,29483,31662,35855,33808,35921,33808,29549,23144,23176,18917,18917,14723,14723,14723,16804,21030,25257,29483,25289,14724,14691,18918,33742,35823,33710,50546,42095,44208,46353,29549,35921,23276,27632,19148,19180,21293,25487,21293,8517,14889,8484,8452,10630,19115,8517,8485,10630,17100,8550,10598,10630,17067,10663,8517,8517,10565,8517,10630,10630,6403,6371,4290,6338,6371,8452,8452,8451,14921,17068,14922,4291,8516,8483,4258,4258,4258,4226,8485,10663,12809,14987,19181,14922,19180,21261,12744,10630,8518,8550,8550,12744,10630,14791,16903,10630,10598,10631,10631,12711,12743,12711,12743,14823,12678,12743,23308,21392,19377,10630,12678,23273,31586,16802,14693,16872,21228,25454,25421,21228,21424,6569,15118,255},
{31596,31597,31597,31564,29516,29516,29516,29483,29451,29451,29450,31498,31529,31529,31529,33609,35721,41962,48300,52493,52525,54606,54574,50413,46221,46188,44107,44107,46155,48267,50379,50347,50346,50346,50313,50313,52393,52425,52424,54472,54471,54503,56550,56582,60776,62922,62922,62922,65035,65434,65535,65535,65535,65268,65035,65300,65135,62955,62922,60842,60809,60809,58729,58729,56649,56617,54537,54505,54505,54505,54505,56553,56553,54473,52425,50345,50377,52425,54505,54537,56585,56584,56585,56585,54505,56618,60812,58798,56783,44040,35588,35589,35589,39816,37802,33543,33576,35656,29349,35689,33609,37902,33642,37935,37936,23077,33675,35855,35822,40048,35855,35888,35856,35856,35856,33775,31662,29484,27404,33775,25290,29516,27435,27370,25290,23177,21064,16837,14659,14723,14723,14691,16804,27369,18949,18949,16836,14756,14724,21031,35823,37903,31663,40047,44208,44207,37902,33774,40147,31826,31858,29713,25552,25520,25552,25552,10630,17035,10597,10630,12711,19148,10663,10663,10663,17067,12776,12743,12711,14889,14889,8517,8517,8485,6339,6404,10630,6404,6338,4258,4258,6403,8484,8484,8452,14889,17067,14954,4324,10662,8516,4258,4225,2145,2177,6436,10663,12809,14922,17068,19181,14955,14890,14890,12776,8518,8550,10598,12776,8550,8550,16904,25421,12711,10598,10630,12743,14824,12711,12743,12711,14823,12678,16969,27534,25683,17166,6372,19047,18946,14823,14823,14857,19181,19147,25454,25422,27600,21392,21457,255},
{31597,31596,31596,31564,29516,29516,29516,29483,29483,29451,29450,31530,31529,31529,31529,33609,37769,41994,48268,52493,54606,54638,54606,50413,48300,48268,46219,46187,46187,48235,50347,50346,50346,50345,50345,52425,52425,54504,54504,54504,56583,56583,58662,58662,62889,65003,65002,65002,65100,65400,65469,65502,65502,65234,65134,65333,65167,65068,65035,62955,62922,60842,60809,58730,58729,56649,56617,56585,56585,56585,56585,58633,58633,56553,54505,52425,52425,54505,56586,56617,58665,56616,56617,58698,56585,60778,52426,37701,37701,35588,33508,35655,33541,35623,37802,33576,35657,35690,31528,37900,35722,35755,42128,37902,35757,35822,37936,37935,35855,37968,35888,35888,35888,35921,35921,35921,31662,31597,25258,25323,25290,29548,27402,27337,27337,27337,25257,18918,12578,14691,14691,14659,16836,29450,16836,14723,16804,14723,14691,21096,46321,50546,33775,27403,48466,42095,27337,44175,40081,19050,23308,23341,14921,12841,12841,25552,12743,17001,10630,12711,10662,14922,12776,10663,10630,12809,12776,10631,10631,10696,12776,10631,10631,10630,10598,8550,8550,10630,8484,8485,10663,10630,6403,8451,8451,14856,17133,15020,8582,8582,6371,4226,2177,4258,4291,8517,12744,12776,17067,23407,14890,14955,17035,12776,12809,12776,10631,8550,10630,8550,8518,10631,25422,25454,10630,8550,12776,12776,12743,14889,8550,10631,12711,10598,14856,25422,25618,10826,8517,14889,12743,23307,12809,10761,16937,25422,23341,23308,23407,21392,255},
{33677,33677,31597,31596,29516,29516,29484,29483,29483,29483,29450,31530,31529,31529,33609,35689,37801,41994,46219,50412,56686,56686,54605,52525,50413,48300,48267,48299,50347,50314,50346,50346,52425,52425,54505,54504,54504,56584,56584,56616,58663,58695,58695,60742,65003,65101,65035,65100,65233,65468,65468,65502,65535,65367,65266,65300,65233,65167,65101,65068,65035,62955,62890,60842,60810,58729,58697,58697,58697,60745,60713,60713,60713,58633,56585,56585,54537,56585,56618,58698,58697,58665,58665,60746,58698,52393,41895,33476,33509,33541,33509,33542,31429,31397,33575,33543,33576,33544,29382,37868,37835,35689,39982,37902,35756,40016,35790,35855,37935,33742,33774,33742,33709,33676,31596,31595,33677,31629,18950,25258,29484,29450,29450,29450,27369,25256,23143,16804,12611,12611,12610,16771,20997,23143,14723,14723,14756,14723,12643,23177,50481,54673,40048,25324,35789,35788,33708,29516,31662,19082,16937,25454,12841,14954,14954,23439,17002,12776,14857,14857,14889,14922,14954,14954,14955,14987,14987,17035,17067,17068,17068,17068,15020,15020,15020,14987,12809,10696,12841,16970,17003,16969,8452,6371,6371,14889,19213,17100,12841,12809,8484,4258,2145,2145,4291,8550,14857,10631,14922,19115,8518,14890,19181,12809,8550,10663,10695,8518,8550,8518,10598,10631,10663,19148,14954,10630,10663,12743,12743,12776,19147,10598,12711,14791,12678,14856,25454,25650,15118,8583,10630,21128,6504,10696,19081,27567,25454,21228,23472,17100,255},
{35789,33742,33677,31597,31564,29484,29483,29483,29483,29482,31530,31529,31529,33577,33609,35689,39881,44074,48267,50380,54605,56718,58766,56685,52493,50380,50379,50379,50378,52426,52426,52425,52425,54505,56617,60877,60876,56615,58664,58696,58696,60775,60775,62855,65134,65300,65134,65233,65434,65535,65535,65535,65535,65468,65335,65300,65367,65333,65233,65167,65101,65068,65035,65003,62955,62922,62890,62857,62857,62857,62825,62825,62825,60745,58665,58665,56617,56617,58698,58698,60778,60777,58697,60778,60811,37735,31429,33510,33542,33510,33510,33542,33510,29316,31397,33543,33543,33543,33576,31495,37770,35657,35722,35788,35723,39950,35855,35822,35822,33676,29450,29384,27336,27336,27336,29417,33709,29549,16837,21031,37969,27370,29449,27336,23111,21030,21030,16771,14691,16771,14691,16771,18949,23142,14723,14723,14691,14723,14691,25290,50448,54640,46320,27502,21064,31496,23208,25454,27567,29745,25487,31891,27633,27633,27698,29811,25552,21293,23407,23439,23440,23472,25552,23472,23472,23472,23472,23472,23472,23440,21391,21359,21359,19279,19279,19279,14922,12809,19115,23277,21196,21163,12710,6371,6371,12808,17067,17100,17035,12776,8550,6403,4258,6436,8550,12776,12776,8550,10696,8615,10664,19148,21229,17003,14857,10696,8550,8550,8550,8518,10598,10663,10631,10696,14954,14954,12776,10663,10663,12743,17002,12743,12744,14792,14824,12678,14856,21228,23537,17231,12678,23209,12744,19082,23275,27502,23406,12874,23505,14922,255},
{35790,35790,33677,31597,31564,31564,31531,31531,31531,31530,31530,31529,33577,33609,35689,37769,39881,48235,50380,50412,52492,56685,58798,58765,54572,50379,50379,52458,52458,52458,52458,54505,54505,58730,65269,65534,65367,62955,60776,60776,62856,62888,62888,65002,65300,65434,65267,65367,65502,65535,65535,65535,65535,65535,65501,65434,65468,65501,65434,65368,65333,65333,65267,65233,65167,65133,65068,65035,65003,64970,64938,64938,64906,62825,60745,60745,58697,58697,60810,60810,60810,60810,60810,62890,60810,37668,31428,33509,33542,33510,33542,33542,33542,37736,35623,37769,39915,37769,35656,33543,39882,35689,31495,39948,35722,29350,31497,35756,37902,35756,29417,31562,31562,31562,33675,29417,39982,37967,23144,16804,27403,27370,27369,25223,23110,23078,21029,16771,14723,14691,14691,16771,18949,23143,16803,14691,16836,21063,16837,25290,52560,52561,50481,31695,16936,31726,16936,25455,29713,31859,23406,25520,21229,19148,17035,17068,29843,27633,27698,27698,27666,27666,25618,25585,23504,23440,21359,21327,19246,19181,17101,17100,17068,14987,14955,14955,10663,14824,21196,23276,21196,21196,16969,6403,6371,12776,17067,14955,19246,19115,14889,10663,8550,12776,14857,16970,10631,8582,10696,10696,14890,14922,14889,17034,19083,16970,16970,10664,10663,8518,8550,10631,12744,12743,10631,14954,14954,10631,10663,12743,12743,12776,14824,12743,10631,12678,12678,12678,27502,27666,19312,12875,19244,21359,19181,17100,12841,12841,19148,12744,255},
{35789,33709,31629,31596,31564,31564,31563,31531,31531,31530,31530,33577,33609,35657,35689,37801,41993,50347,54572,56685,56685,58765,60878,56685,54540,52459,52426,52458,54538,54506,54505,54537,56584,62956,65535,65535,65534,65267,62921,62888,65101,65034,65034,65166,65435,65535,65468,65501,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65501,65467,65367,65299,65199,65133,65068,65035,65003,64970,64938,64906,60777,60777,60777,60777,60810,62858,60810,62890,62890,62923,60810,54537,54669,44007,39782,39845,41925,41927,39814,39847,39815,44041,42027,39882,33574,35688,39913,33608,29382,37867,37803,29383,29415,35788,37935,37935,25223,35789,35756,35755,35756,31562,37869,35821,23110,18852,35822,33676,29449,27336,25255,25191,20997,14690,14690,14658,14658,16836,33807,29614,16836,14723,16837,23177,21064,25291,52561,50448,50514,33840,16937,27534,27534,25487,29778,31858,21293,21293,21261,17002,12809,12874,27698,21294,21326,21326,21294,19214,19213,17133,17068,14988,14955,12907,12842,12809,10729,10729,10696,10663,10663,10631,8517,12711,21196,23276,21196,21196,19050,8517,6338,12776,17035,21294,21360,23472,16969,8583,17002,19148,17003,14857,10630,6437,8517,10696,19246,19279,17100,21227,14921,16969,17002,19083,14922,8550,8517,8550,10631,12711,8550,10631,14954,14922,10630,10663,10663,12776,14889,12744,23374,14955,14791,12711,16904,25421,27666,19443,6858,21456,12940,15086,6502,14922,16937,12679,255},
{33709,33709,31629,31596,31596,31564,31563,31563,31530,31530,33578,33609,33609,35689,37769,39849,44073,54572,58831,58863,63057,60911,60910,58764,54539,54539,52490,52458,54538,54537,54537,56617,56616,62889,65401,65501,65401,65233,65133,65067,65401,65401,65301,65333,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65501,65433,65332,65264,65198,65133,65068,65035,65003,64970,62890,62858,60810,60809,62858,62891,62891,62923,62923,62923,62923,62955,52490,41928,41961,41961,39881,39881,39848,39881,39882,41962,41995,35656,33542,37769,37801,33576,31463,35689,33641,31495,23076,31497,40080,33709,29449,35822,35789,31562,33676,31563,33643,35822,25256,25256,37968,35854,31563,33675,29450,23110,23110,16803,14690,14658,16771,18884,29549,33840,18982,21096,29614,25323,23177,25323,50481,54673,54673,38000,19050,25388,33840,25454,25519,27665,21261,19180,27632,21261,21294,21326,29746,16970,12776,14857,12809,12809,12776,12776,10696,10663,10663,10631,10598,8550,8550,8550,8517,8517,8485,8484,6371,12678,21131,23276,21163,21196,23276,12711,6338,12743,17067,23407,19279,21424,14823,12809,17035,19115,14857,8517,2178,2177,2145,4258,12841,15019,17133,17067,23340,16969,14922,14955,19148,19148,12744,8517,10630,10663,10630,8517,10663,14987,12874,10631,10663,12743,14856,12743,19083,23472,12776,14791,14759,14824,21130,27666,19409,10858,21360,19246,12777,16903,21097,14857,255},
{33709,33709,33677,31596,31596,31563,31563,31563,31562,33610,33610,33609,35689,37737,37769,41929,46153,54572,56717,58831,63090,63090,62991,60877,56651,56651,56618,54537,54537,54537,56616,58696,62890,65135,65334,65400,65133,65299,65401,65334,65435,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65501,65433,65332,65265,65199,65165,65100,65067,65003,64938,62890,62858,62858,62891,62891,62923,62923,62923,62924,62956,60875,44007,39815,41928,41928,37802,35656,35656,35656,35689,37769,37802,35722,35722,35722,35689,33576,29350,29383,31528,29415,25156,29383,35756,33741,37934,33709,33644,27336,33676,33643,37869,37934,29449,35822,35822,33709,23144,27370,37935,27370,23111,23142,14690,14690,23044,16803,27403,35954,27501,25323,31760,23242,16837,23177,48433,54673,54673,42128,21163,25356,33905,23341,21261,23406,31858,27632,31891,23439,23406,25519,25520,17034,8484,10565,10565,8517,8517,8517,8485,8484,8485,8485,8452,8452,8452,8485,8452,6372,6371,6339,6338,10565,16936,23244,21163,21196,21228,12711,6338,12711,17035,27567,25422,12809,8484,14889,17068,12744,12776,8517,6404,4258,4258,8517,19180,27763,25617,31924,17002,21195,17035,6830,10893,17068,21261,14889,10630,8550,10630,8550,8517,10663,14987,14954,10663,10663,14889,12743,10663,14856,10663,10630,14791,14791,12711,19050,27666,19377,8681,12874,8582,19016,25355,16970,255},
{35757,35789,33708,33644,31596,31595,33611,33611,33610,33610,33609,35657,35689,37768,39848,41960,46153,50346,52459,56684,63058,63157,62991,58764,56650,60844,63023,56650,56617,56617,58696,62890,65134,65333,65333,65334,65199,65434,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65501,65434,65365,65297,65231,65166,65133,65068,65003,64970,64938,62890,62858,64971,64971,64971,62956,62923,62923,62924,62956,56749,44007,39847,41928,37769,35689,37769,37769,39883,39916,37835,37835,37803,37868,33609,33543,33609,35723,37901,29383,23076,29383,33675,35822,42194,38000,33675,23109,33675,35723,39981,35821,29450,35822,33676,31563,23143,23143,35790,27337,25224,27305,16803,14690,16803,16804,27403,35921,31728,27470,29615,18918,16836,21063,48401,54673,52560,40015,23244,23275,31728,23243,21228,25487,25454,16905,25487,14954,12841,17067,17035,21293,8419,10564,8451,8419,8452,10630,8484,8452,8452,10630,10630,8484,8484,10630,14922,10630,10630,10597,12710,12744,14857,19083,21164,19083,21163,14791,6371,10630,17003,27502,21064,8452,8452,12809,14922,10663,14922,10728,12809,12776,10662,17034,14922,25650,32022,34102,29811,17034,23308,12874,15185,21392,17067,21228,14921,8517,8517,8550,8550,8550,10696,14955,14922,10663,12744,12743,12743,10662,10630,14921,8583,12678,14823,14824,18985,23439,17296,6601,15118,21261,25389,14921,255},
{35789,35789,35757,33676,33643,33643,33611,33610,33610,33610,35657,35689,37769,39848,41928,44040,48233,52457,56684,60910,63057,65270,63024,58829,58730,60942,65301,63022,60843,60810,62956,65036,65069,65133,65266,65366,65401,65534,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65468,65400,65332,65264,65231,65165,65101,65068,65003,64970,64938,62890,62858,62923,64971,62923,65004,62923,65004,62956,62924,63055,50345,41894,41928,37801,37769,37801,37802,39883,39948,37802,37803,31496,37802,31496,31463,37835,37901,37934,29383,29416,31496,31529,35756,35789,35788,20996,20996,33610,33610,33675,35788,29417,33741,33676,29450,21030,25223,25223,25256,27304,25223,25191,18884,18916,23109,29450,35921,29582,23210,16838,14757,29516,25323,42127,56753,52560,37935,23276,21064,25290,21130,23276,23276,27600,19050,23406,21326,17035,14922,14922,25552,12710,19082,14856,14888,14921,21261,19180,19180,19213,21326,25552,21358,23407,21359,23504,21391,21359,23504,21359,37998,39979,35721,35723,29482,25322,12710,6339,8484,14889,21196,12645,12645,12711,12743,10663,10631,14889,12809,12809,14889,6501,14954,29810,15020,23570,23537,27730,29843,14823,19081,17034,21392,17166,14954,19116,12776,6437,8485,8550,10695,6469,10663,14987,14954,12776,10663,14889,23439,8583,12711,19181,14857,18985,25356,19050,16904,23341,21424,21392,21326,23309,14889,255},
{35789,35756,33676,33644,33643,33643,33642,33610,33610,35658,35689,37769,39849,39848,41960,46120,50312,56650,60910,63056,63123,65304,65402,65468,65302,65335,65401,62956,62923,65036,65102,65069,65100,65166,65299,65368,65501,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65534,65501,65434,65365,65297,65231,65166,65133,65100,65067,65002,64938,62890,62858,62890,62890,62923,64971,65004,64972,65005,62957,65004,54571,39781,41927,41927,41927,39816,37801,37801,37802,39883,39882,37770,33543,35689,33544,33576,39915,39949,42096,35789,29416,29351,31496,33642,29416,33609,27270,27335,35721,33608,35754,42094,37835,39982,39981,39981,31528,33609,33610,37902,37902,35822,35822,27369,25223,27303,25224,31695,21096,16870,12611,21096,25323,21064,37902,54641,54640,37935,23276,25224,31529,25322,21097,23276,31760,23374,29713,27665,25552,23472,23472,29811,27633,27665,25585,27665,27698,19278,19278,19246,25585,19213,15020,15020,17133,19213,12842,6567,8615,19279,10761,33641,35620,37734,39881,37802,27337,10564,6339,6371,19148,17002,12678,12677,14759,12711,12711,8518,10663,14922,14922,12808,4355,10695,25585,29811,17100,21391,12808,17034,14856,8484,8517,8550,15053,19344,14955,17034,10696,6404,6437,8582,8518,6437,10696,14955,14922,10631,10631,25487,29547,12645,10663,10663,8517,19082,29550,19082,14856,21228,25421,25421,25389,14921,255},
{35756,33676,33643,33643,33643,33643,33642,33610,35690,35689,37737,37769,39848,41928,44040,48200,52392,60844,65137,63122,65270,65337,65436,65502,65469,65535,65468,63021,62955,65134,65232,65199,65232,65333,65433,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65534,65502,65468,65434,65366,65299,65232,65166,65133,65100,65067,65035,64970,64937,62857,62857,62858,62890,62890,64971,64971,64971,64972,62956,65004,60910,41926,43975,44007,44007,41895,39782,41927,44042,44075,44042,37768,33542,39882,35623,35689,42028,42027,46256,42061,31494,31462,35688,39949,37835,37868,37869,35788,29416,27303,25223,31596,31662,29581,29582,25388,16870,16870,16871,25389,27502,27502,27535,23211,21064,23209,25290,29582,29582,16870,16870,27436,21096,10530,27403,50448,54673,33742,23243,37869,33675,31563,14758,31596,44339,27600,25390,27632,19148,14954,12874,23406,19180,14955,14954,14987,23472,8713,8680,12874,19246,14954,8648,8616,10729,21326,8616,8583,10728,17133,10793,10729,4292,6437,10663,8548,12776,10630,6371,10630,19116,16970,16935,16870,8484,12678,19083,17036,12874,12841,10696,10663,6501,10728,10761,14921,8515,8484,4323,2145,2178,2177,2145,2145,4259,15020,19279,14987,14954,10663,6404,8550,8518,8518,6437,10696,12907,14890,10598,10663,21063,21029,12711,8517,14824,21196,21163,23244,12744,10663,16970,23309,23309,19115,255},
{35724,33643,33611,33643,35691,35691,35690,35690,35689,37769,37769,39880,41928,44008,46120,50279,54504,62924,65170,65302,65336,65370,65435,65535,65535,65535,65535,65234,65100,65200,65300,65334,65400,65467,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65501,65435,65400,65333,65298,65232,65166,65132,65100,65067,65034,65002,64937,62857,62857,60777,62857,62890,62890,62891,62923,64971,62923,62923,65004,62990,50346,41895,43975,44007,44006,43941,46120,48234,44041,41928,39848,33508,25189,23209,18919,27369,27337,25322,23209,18917,16837,16805,21096,25357,23309,23309,23277,14791,14758,14791,21131,25422,23342,25390,23341,19050,21130,21195,25422,25422,25422,25422,25422,25389,27502,27501,29615,27502,21065,23210,27501,14789,8418,18984,42095,52594,31662,23211,33708,40013,29483,18984,37869,40081,29648,21131,27632,17002,14889,10761,17068,23374,17003,12841,14922,23471,14955,12841,12874,15052,19246,10794,10794,12874,21423,10794,10793,15020,19246,21359,19246,14987,14954,10630,6402,12775,16969,6404,12776,14922,17002,10597,6339,4259,8484,14922,12744,10534,12711,10695,10693,10695,17035,12809,10662,6435,6338,4258,4258,4290,2178,2177,2145,4258,6436,6469,19344,21425,14954,10663,8517,8550,8517,8518,6437,10696,19180,19115,8518,10631,10631,23374,14955,16970,23341,19050,12711,16969,14857,8517,19083,19115,21196,255},
{35723,33643,33611,33643,35690,35690,35690,37770,37769,39849,41928,44008,44040,46119,50279,52391,58664,65103,65302,65336,65402,65403,65435,65535,65535,65535,65535,65402,65233,65299,65400,65468,65501,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65468,65400,65331,65264,65198,65165,65100,65067,65035,65002,65002,64970,64905,62825,60776,60777,60777,62858,62858,62891,62891,62923,62923,62923,62923,58731,41928,41928,43976,44007,46087,43941,43974,46087,44008,41928,39848,39848,23176,21098,18985,21098,19082,21163,19050,16872,16904,16905,19050,23276,23276,23276,23277,21195,21196,23277,23341,23309,23309,23341,23342,23342,23342,25422,25422,25455,25487,27535,27535,27535,27534,25389,25389,23276,21163,25389,23242,12611,10498,16837,31662,40048,31662,29581,31596,37967,31597,37935,42162,31663,33873,16937,27600,19116,17100,19213,19246,27698,19213,19213,21358,27665,23504,23439,23472,23504,27763,23505,23504,23472,23569,21392,17165,19246,17133,23472,15020,12841,8550,8549,8515,10629,12711,8517,10630,14922,12841,12776,6339,4259,6404,10663,8518,8485,10630,10630,4322,8549,25519,14987,8516,6403,6403,4258,4290,4258,2177,2145,2145,2145,8549,6371,6502,23603,21391,14922,10696,8518,6469,8550,8518,6469,16970,31793,19083,8550,10663,10663,19148,19115,25422,23309,14824,8517,12743,12711,10631,12744,19116,255},
{35691,33642,33642,35690,35722,37770,37770,39849,39849,41929,44008,46120,48199,50279,52391,56551,60776,65202,65402,65336,65469,65469,65469,65535,65468,65535,65535,65502,65468,65467,65501,65534,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65469,65434,65333,65265,65198,65133,65067,65035,65002,65002,64969,64969,64937,62857,60776,60744,60744,60776,60777,60810,62858,62891,62891,62891,62891,62891,62989,52524,41928,46153,48201,46054,41860,41861,41894,43975,44008,41961,42028,23177,21098,18985,21130,21130,21130,21131,21163,23244,23244,21196,21195,23309,23341,23341,23374,25422,25454,25455,25455,25487,25487,25487,25519,25519,25487,27567,25487,25454,25422,25454,25454,25454,25390,25390,23277,21131,23210,12675,10530,10563,12675,25355,31663,29549,31629,44339,33774,33742,42193,27502,31696,38132,29713,31859,29746,27665,27633,25585,31924,25552,23407,23407,21326,25520,19181,14987,14987,23472,12907,10826,12874,15020,17132,8648,8615,10696,19246,10728,10663,4291,8517,8548,6435,8549,10597,10630,14922,12809,17002,8484,8518,8518,6404,8550,10663,10663,6404,4291,6404,10663,19180,6403,6370,6370,2177,4290,4258,2177,2145,2145,2145,4290,6403,6436,10793,17231,15052,14922,8583,6404,6437,8518,8517,8550,21196,31761,17002,8550,10598,10663,19115,23374,23309,14824,12711,6404,8485,10630,10598,10663,255},
{35690,35690,35690,35722,37770,37802,39849,41929,41961,44040,46120,48199,50279,52391,56519,58663,62856,65168,65368,65435,65502,65502,65502,65502,65468,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65534,65502,65502,65501,65434,65367,65299,65231,65133,65067,65034,64969,64969,64937,64937,64937,64904,62824,60744,60744,58696,60744,60745,60777,60810,62890,62891,62891,62891,62891,62924,62992,56750,52492,50346,46053,41860,43974,44007,43975,41928,41993,41995,25290,19050,18985,21098,19050,21131,21131,21163,21163,21163,21196,21196,23341,23341,23341,25422,25422,23374,23374,23309,19050,16970,19082,23374,23342,23342,23374,16969,12711,12711,16970,23374,23341,23309,21261,21229,19050,16903,10531,8482,8450,10562,14789,27469,23210,23209,33808,33775,42194,35953,25356,40212,42326,19083,23309,25519,14922,12841,17035,25519,17100,12842,12841,12842,23472,14922,10761,8680,17133,15052,12874,10761,10794,21359,12809,8615,8648,14987,12874,10760,6371,8517,10629,6402,10597,16969,12711,14921,14889,14922,14889,10631,6372,6436,8517,10631,14987,8550,6404,8550,6469,21293,12743,6370,6338,4225,4226,4258,2145,2112,2145,4258,4225,4290,10695,12808,12906,23668,17101,14889,8518,6404,6437,8518,8550,8518,21228,31793,17002,8550,12743,17003,23342,21228,12711,12743,12711,10598,10631,10663,10630,255},
{35690,35690,37770,37770,39850,39881,41929,44009,46088,48168,50280,52359,54439,56519,58631,60743,62921,65168,65368,65501,65502,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65468,65435,65435,65434,65367,65332,65264,65166,65100,65035,65002,64937,64936,64904,64904,64904,64872,62792,58664,58664,58664,58664,58696,60777,60810,60810,62858,62891,62891,62891,62957,65104,48232,39748,41861,41893,41893,43974,46088,44040,39847,39880,37800,27435,19017,19017,21130,21130,21131,21131,21163,21196,21196,21196,19050,12710,12678,12678,21196,23341,23341,23342,19050,12613,12645,12678,21228,21229,21228,21196,16937,12646,12645,14791,19050,16937,16970,14889,16970,12645,8451,10531,10531,8450,8482,10531,10564,10531,18982,25356,35920,40179,27469,35922,36019,31793,25519,19083,27665,12809,12873,14954,19213,21358,12842,12809,12842,23472,14954,12874,8680,14987,21391,15020,14987,17100,25617,27632,19245,17165,21359,23504,21326,19181,19181,12743,6402,6435,14856,12711,12743,14922,14889,17002,8517,8550,6436,6436,10631,14922,10663,12874,12841,10728,14955,17067,8549,6371,4290,2177,4258,2177,4258,4290,4225,2145,2177,2145,8582,8582,15053,23668,15020,12841,6405,6404,6437,10631,8550,8517,19115,27535,16970,12776,14922,19148,19083,10630,12743,12711,12744,12743,10663,8485,255},
{37770,37770,37802,39850,41929,41961,44041,46120,48200,50280,52360,54471,56551,58631,60743,62856,65002,65233,65468,65535,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65400,65333,65365,65333,65298,65264,65199,65133,65067,65002,64969,64937,64904,64904,64872,64872,64872,60712,58664,58632,58664,58664,58664,58697,60778,60810,60810,60843,62891,60811,62924,63023,52458,39747,39748,41861,41893,41893,41926,44007,41927,39847,39880,31563,19017,19017,21130,21130,21130,21130,21131,21163,21163,21130,16937,10564,10564,10565,19017,19082,19050,19050,19018,10565,10565,12645,21130,21163,21163,23276,19017,14726,14758,16936,23341,21229,19083,19083,19083,14791,8418,8450,10531,8450,8418,8451,8418,8450,12676,29614,35953,33873,29583,40180,31826,25422,31794,21163,29746,19180,19245,17132,21358,29778,25520,25552,25585,29843,27730,27698,25617,27731,27730,23472,21391,23472,27665,23276,17067,17068,23439,14922,10695,8517,10630,8483,6370,8451,14791,12710,8419,14889,12841,17002,12776,8550,4258,8582,10663,14889,17100,17133,14987,12776,17035,21391,19147,8484,6403,4225,4258,6371,8484,8451,4258,2145,2177,2177,4258,6404,6404,12973,6864,10827,12776,6404,6404,8518,8518,6437,6470,19277,29680,17002,14922,17068,14857,10598,12743,12743,12711,12776,12743,10598,255},
{37802,39850,39882,41961,44009,44041,46120,48200,50280,52392,54472,56551,56583,58663,60808,62889,65100,65333,65501,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65501,65334,65264,65232,65231,65230,65198,65133,65100,65035,65002,64937,62856,62856,62824,64872,64840,62791,60711,56584,56583,56584,56584,58664,58697,60778,60778,60810,60811,60811,60810,62892,62957,54571,39747,39780,41861,41861,41893,43974,41893,41926,39814,41961,35789,19017,16871,16872,16839,16871,16839,16904,16904,18985,18985,18985,12645,12645,12677,23210,25356,25356,27436,25290,18984,21097,21129,27437,29517,27469,27469,25356,25356,25388,25356,23309,23309,16904,18985,16937,16871,10531,8450,8450,8450,6338,6338,6338,8450,8450,31727,35954,29648,40180,36019,29680,33874,36052,29778,34004,27698,27665,25553,31891,27665,21326,21326,25520,29778,19181,17100,19181,27666,17100,14955,14987,23407,17100,19115,17003,19213,14922,10663,10663,12743,8451,6338,4290,8484,12711,6371,6371,14856,14921,17002,14889,10630,10663,14987,12874,12776,14889,17067,12841,17035,14889,21326,14889,6370,4290,4290,4290,6339,6371,6371,4258,4225,2177,2177,2177,4291,4291,8550,6831,8976,14955,12777,6437,6404,6437,8517,6566,4648,21261,27567,14954,17035,12776,10598,10630,10630,12711,12743,12743,8517,255},
{39882,41962,41961,44041,46121,48201,48232,50312,52392,54472,56551,58631,58663,60743,62889,65002,65134,65366,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65501,65501,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65467,65266,65165,65132,65132,65132,65100,65100,65035,65002,64969,62889,62856,62824,62824,64840,62791,62791,58631,56552,56552,56552,56551,56584,56616,58697,58697,60778,60811,60778,60778,62924,56619,37700,37667,37699,39780,41860,39780,44007,44040,41927,39814,39815,35723,21065,21065,21129,21129,23210,23210,25323,25323,27404,27404,25323,23178,25290,25323,27436,29484,27436,27436,27436,29516,29517,29516,27371,25290,25258,29483,31596,31596,27404,18985,25389,23342,14726,10532,10532,8419,10499,12611,8418,12677,16871,16936,19016,16903,14791,27501,25389,35921,38100,33906,35954,46551,27567,25487,27600,19181,19213,23407,29746,21294,21261,23407,29746,21294,19213,19213,27665,19149,14987,14987,23472,17068,10729,19181,23407,14954,10695,10663,8517,6371,4290,6370,10597,21195,21260,21228,21260,23374,23439,23439,27730,27730,27730,27730,27698,25584,25584,19181,10761,17100,17100,16936,8484,4290,6338,4290,4290,6339,6371,6403,6338,2177,2178,2145,2178,14987,10728,6404,10760,21458,21490,14987,12841,6437,6404,6437,8518,6437,10631,21228,21196,17002,10631,10598,10598,8550,10630,10630,10630,10630,255},
{41962,44041,44041,46121,48201,50280,50312,52392,54472,56551,56551,58631,58663,60776,62889,65035,65199,65367,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65469,65467,65468,65469,65501,65502,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65433,65199,65099,65066,65066,65034,65034,65034,65002,64969,64937,62856,62824,62824,62824,64840,64839,62759,58631,56552,54472,54471,54471,56552,56584,58665,58697,60778,60778,60778,58730,60844,52426,37635,37667,37667,37699,39780,39748,41926,44007,44040,44107,39881,33610,21097,23178,23242,25258,25290,25258,25258,25258,25258,25290,27403,29515,29516,31596,27402,27337,27337,33643,39982,37868,37835,37802,31495,31594,31627,39981,46286,33642,16805,12612,27436,25487,12612,12580,12612,8418,10531,12611,14725,25356,25356,25422,25389,18985,14791,25388,27469,40147,33906,29680,46454,33841,27567,27600,19180,19181,21261,29778,21293,19181,19213,27665,23407,17133,19214,25553,21327,15020,15020,23440,17100,10761,10761,23439,21293,8583,8517,12808,10597,6371,8517,10630,12743,14824,12743,12743,12776,14889,14986,14922,27730,29876,29875,29875,29811,29810,27730,23504,15020,12906,12809,14758,6338,4290,6371,6371,4290,6371,4258,6371,10597,8484,4258,4291,6372,17133,17198,8517,8485,12841,21490,19312,14955,12809,6404,6404,6437,8518,8550,10663,23309,19148,12711,8517,10598,8550,8517,10598,8550,10630,255},
{44042,46121,46121,48201,48232,50312,52392,54472,56520,56551,58631,58663,60743,62856,64970,65068,65199,65400,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65534,65502,65502,65401,65401,65434,65435,65468,65469,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65299,65132,65034,65001,65001,64969,65001,65002,64969,64937,62857,62856,60776,62792,62792,62791,62791,62759,58599,54504,54472,54471,52391,54471,54504,56617,58697,58698,58698,58730,58731,62924,52458,37668,37668,37700,37700,37701,37667,35587,39814,44073,44075,39881,35688,33675,33708,33708,31562,27336,27304,27336,29415,27269,33608,39980,39979,37867,39948,39981,40015,37934,35757,39982,29482,25190,18918,21064,31695,29582,33741,46287,21063,12612,14725,25323,27600,14758,12611,10531,10498,12611,14691,27469,27502,25389,25422,23374,23309,21261,25454,42293,36019,33841,40179,40180,27567,27600,23374,21261,21294,29746,23406,21261,21261,29713,25520,17100,17100,25520,23472,14987,14988,21326,21326,12842,12842,19181,19115,19082,8582,12776,31891,16969,14791,12743,8517,8517,8517,8516,8517,10598,12776,14986,14987,23471,29876,29843,29811,27762,27698,25617,23504,19278,12874,12874,10662,4290,4322,6371,6371,4290,4290,2177,4258,10597,8452,6339,6372,10695,17133,21457,14987,8517,8517,14922,17232,17232,14955,10728,4324,6404,8517,10631,10663,17003,21228,16937,10663,8517,8550,8517,8517,10598,10598,255},
{46122,46121,48201,48233,50280,52360,52392,54472,56551,56551,58631,58663,60775,62889,65003,65068,65167,65367,65535,65535,65534,65502,65535,65535,65535,65535,65535,65535,65468,65501,65467,65367,65367,65401,65433,65434,65468,65501,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65434,65199,65067,65001,64968,64936,64936,64937,64937,64937,62857,62856,60776,60744,62792,62792,62791,62791,62759,58599,54504,54472,52391,52359,52391,54472,56585,56617,58698,58698,58698,58731,60811,56651,37668,35587,37667,35587,37668,37667,35554,37701,41928,41929,37767,39881,42027,42027,42028,39882,39915,42061,37835,37802,25188,25189,29448,29416,31530,29450,31596,35854,35822,29450,27337,29450,27337,16838,16871,29549,29550,35789,39981,25225,14692,12612,21096,29713,16904,16838,12612,14725,20998,27269,35855,29582,25486,23374,23341,21261,21293,23406,36052,31826,35953,46486,25422,27567,23406,19181,19213,25520,27633,21261,21294,27633,27632,21261,19181,25552,25552,15020,14987,21326,23439,12842,10761,17068,19148,10663,16904,10597,23374,40311,27535,19050,16969,12710,12710,12710,12710,12711,14888,14889,17034,17067,21424,23537,25585,23536,23537,19310,21456,21391,19246,12874,12841,8582,4290,4290,4290,4290,4258,2177,2177,2145,4258,4290,4291,8484,10663,12841,19279,19311,10598,8485,8517,14955,23604,19312,14922,10695,4324,6405,8518,8550,14890,19083,17002,29648,12743,8517,8550,8517,8517,10598,255},
{46153,48201,48201,50281,52360,52392,54440,54472,56551,56551,58631,60743,60776,62889,65002,65100,65233,65401,65535,65535,65535,65535,65535,65535,65535,65535,65502,65469,65434,65501,65468,65333,65334,65367,65434,65435,65467,65501,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65399,65132,65034,64968,62888,62855,62855,62856,62856,62856,62824,60776,60744,60744,60744,62792,62791,62759,62759,56551,54472,54440,52391,50311,52359,54472,54505,56617,56618,56618,56650,58731,60812,54505,33474,33474,35555,35587,35587,35587,35587,39814,41895,39815,35654,41962,44108,37768,37768,39915,37835,39981,37835,37835,27269,23076,31562,31563,33708,31563,29449,31529,35756,29450,23078,31497,37869,21031,20998,33741,35855,40080,42094,29417,23077,23109,25255,29582,21131,21130,19050,23243,31496,52458,48334,37968,29713,21228,21228,21228,21261,21293,31826,27632,44406,29648,27568,25519,19181,19181,23407,29713,19181,19213,23407,29746,21293,19213,23439,25585,19181,17101,21359,23440,12907,12842,19181,19213,10696,12775,14822,16968,38198,33809,36020,19115,19082,16904,16936,14823,16969,14823,19081,17034,25552,23471,27762,27795,27763,27763,27730,25650,25650,25650,19278,10761,10696,10728,6403,4290,4290,4258,2177,4290,4290,4258,2177,4291,6404,6404,6436,6403,8517,6436,6404,8517,8517,8582,15052,23636,19246,14922,10631,6372,6404,10729,17068,14890,10663,29648,31696,12711,8517,8517,8517,8518,255},
{48201,48201,48233,50312,52360,52392,54472,56520,56551,58631,58663,60743,60776,62857,64970,65133,65300,65400,65502,65535,65535,65535,65534,65502,65535,65535,65434,65435,65468,65502,65502,65400,65300,65366,65468,65502,65467,65468,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65333,65067,64968,62887,62855,60775,60743,60776,60776,60776,60776,60744,60743,60712,60712,62760,62760,62759,62759,56552,54472,52392,52359,50279,50311,52392,54505,56585,56585,56617,56618,58731,58731,56651,50312,50345,54539,52459,41860,37699,35587,39847,39847,37734,37735,39881,41994,35622,37735,39882,37834,39916,37835,35754,33576,27236,31529,33642,35755,35722,37867,37802,39948,39948,35787,37835,33609,27303,25223,31628,29581,29582,27502,25356,16870,16871,14791,21163,23309,23309,23309,25357,41962,65370,54705,44206,29680,23308,23308,21228,19115,16969,29647,38067,36019,27600,27600,21294,21294,21327,29746,21293,21293,23407,31826,21293,19213,21294,27665,19213,17100,17100,21325,17034,14921,12840,19147,14823,10661,8548,12773,31858,38101,18920,33874,21260,14889,12743,12710,12742,12743,12775,12775,19147,31923,31924,29843,29843,29843,27763,27763,27730,25682,25650,23504,12841,10728,12809,10663,6370,4290,4290,4258,4290,4290,4258,2177,4290,6371,6371,8484,8516,2177,2177,2177,6339,10598,6436,8550,12842,15086,15020,14889,10631,6437,12809,17133,12809,6437,12743,31728,29615,10630,8485,8517,8518,255},
{48201,48233,50280,52360,52392,54472,54472,56552,56551,58631,58663,60743,60808,62889,65003,65134,65267,65400,65502,65535,65535,65535,65502,65502,65535,65535,65402,65402,65501,65535,65535,65534,65435,65469,65535,65535,65501,65469,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65468,65298,65034,62887,62855,60775,60743,58695,60744,60744,60744,60744,58664,58664,58663,60711,62759,62759,62759,62759,56520,54472,52392,50311,50247,50279,52392,54472,54537,54537,56586,56618,56650,56651,58764,62957,60845,58798,58765,41891,41860,35619,39847,35621,37735,39848,35654,35622,33609,31464,35656,39882,37802,35755,35755,33642,31529,29449,27368,23110,23078,21030,25355,27469,25389,25389,23276,12677,12678,12645,19083,23342,23341,23342,23309,16937,16969,16970,23309,23341,23309,23276,25389,48334,65270,50411,33742,27502,21195,19115,19082,17002,16937,27534,42325,27535,27600,23406,19213,19180,21261,21196,19082,17034,17002,16969,14889,14824,12742,10660,8579,8579,8546,6466,8514,8546,8546,16902,12677,10563,4321,19113,38165,29583,25291,23212,29778,12841,10598,12776,25552,27665,27698,29778,29811,29811,29811,29843,29811,27730,25617,23504,21391,21326,19245,25617,14987,10728,12841,10728,8516,4290,4290,4290,4290,4290,2177,2145,4257,2209,4290,4322,4258,2177,2145,2145,2177,6371,8484,6371,10630,15053,23636,17068,14922,8550,12841,14988,10696,8518,6405,12743,29615,27502,10598,6437,8517,255},
{48233,50281,50313,52392,52392,54472,54472,56551,56551,58631,58663,60744,62857,62922,65035,65134,65266,65400,65502,65535,65535,65502,65469,65468,65502,65535,65468,65435,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65501,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65502,65433,65232,65001,62855,60775,60743,58662,58663,58696,58696,58664,58664,58664,58632,58631,60711,60711,60711,60679,60679,56520,54473,52392,50311,48199,48199,50312,52424,54505,54505,54538,56586,56618,56651,58731,58764,58764,60878,58798,43940,41859,35554,37734,37701,41961,39848,37735,25190,19017,14758,21097,21097,21097,21130,21163,21163,21163,21195,19049,12645,14725,14726,21130,23309,23309,25357,25389,21163,21195,23276,25422,25454,27535,25487,27535,25487,25487,27567,25487,25454,23374,21228,25356,33609,46088,35721,27469,23308,21163,19050,16969,16969,16969,19082,21228,19148,17034,16937,12678,6371,6338,6306,6370,8419,16936,17002,17002,12743,6402,6434,6434,6434,6433,6466,8514,8546,8546,14821,16871,6370,8516,33939,33874,16904,23210,16807,36052,17035,8484,10630,25551,23439,23439,21293,21326,19212,19180,19115,17034,14921,12808,12808,10695,10662,10695,23439,21326,10728,12873,17198,15019,6403,4290,4290,4258,4258,2209,2209,4257,2177,4322,4322,4258,2177,2145,2145,97,4258,4291,6404,6404,10696,19311,19344,12842,12776,12874,14922,8550,8550,8517,6405,12776,31728,25389,8517,8517,255},
{50281,50313,52392,52392,54504,54504,56552,56552,56551,58631,60744,60776,62922,65036,65069,65167,65299,65435,65535,65535,65535,65502,65436,65435,65469,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65468,65435,65468,65535,65535,65535,65535,65535,65535,65535,65535,65535,65534,65468,65366,65198,65001,62823,60775,58663,58663,56615,58663,58664,58664,56584,56584,56552,58632,58631,60712,60711,60679,60679,54472,54473,52392,50279,48167,48199,50312,52392,52457,54505,54505,54538,56618,56618,58732,58764,58764,58797,60879,46053,41827,35586,39847,39815,35621,37702,37768,25224,19050,18985,19050,19050,21130,21130,21131,21163,21195,21195,23243,23243,25388,25389,27502,27502,27534,27534,27534,27535,27535,27535,27535,25454,25454,25454,25454,23374,23342,23342,23341,21229,21196,23341,25356,23177,29516,25290,25388,27501,23276,19017,14856,14791,12710,12678,10597,10597,10597,10598,8484,6338,6338,4258,8419,8484,14823,21163,19050,12775,8483,4290,4289,4321,6401,6434,6466,8546,8546,10660,18984,6371,23373,38100,23178,10532,10533,10500,31762,19180,4226,6404,12808,8582,10662,8549,12776,14921,14888,14889,12808,12808,12808,12743,12776,8582,10663,19213,23504,12874,12873,15019,14922,8516,4322,4289,4290,4290,4322,2177,2177,2112,2177,4322,4258,2177,2177,2177,2145,2177,4291,6371,8484,6436,10793,15085,19345,12907,12874,12842,6437,8517,8517,8517,8517,14856,31695,14824,8485,255},
{50313,52392,52425,54505,56585,56585,56552,56584,58632,58664,60776,62890,65036,65102,65167,65234,65366,65469,65535,65535,65535,65469,65435,65403,65469,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65468,65367,65366,65401,65468,65469,65502,65535,65535,65535,65535,65535,65502,65501,65434,65298,65164,65001,60775,60743,58695,56615,56583,58664,56584,56584,56584,56552,56552,58632,60679,60679,60679,60679,60679,54472,54473,52424,50279,48167,48199,50280,50344,52425,52425,52457,54506,54538,54570,56619,58732,56684,58732,60911,44006,39747,35554,39847,39815,33475,35621,39849,27370,19018,18984,19050,21098,21098,19050,21163,21131,21163,21163,21163,23276,25389,25389,25389,23341,23341,23309,23309,23309,23308,23309,23341,23341,23341,23308,23308,23342,23342,23342,23342,21196,16937,16937,23243,25355,27469,23275,23243,21162,19017,19050,17002,16970,16969,16969,16970,17035,17035,17002,8484,6338,6338,4258,6338,10597,12742,19082,10597,6370,10565,6370,6370,6402,6434,6434,8514,8546,8546,8546,14790,19049,38133,27470,16871,10532,10598,14824,25292,23374,2145,6372,6404,4258,2210,2210,6436,19180,12841,17067,12841,17034,12840,14889,12808,10728,8583,12874,23504,15052,10761,10761,8615,8548,4322,6434,6434,4322,4290,2145,4225,32,65,2177,2177,2177,2177,2210,2177,4290,6339,4226,6404,6404,8517,12873,19410,23603,12874,12809,6437,4324,6405,8518,8550,6405,16904,19050,8517,255},
{52393,54473,54473,56585,56585,56585,56584,56584,58632,58696,60777,62923,65069,65167,65266,65333,65400,65501,65535,65535,65502,65435,65402,65403,65468,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65300,65231,65299,65366,65400,65434,65501,65502,65502,65502,65502,65502,65501,65467,65366,65264,65099,64969,60743,60776,60809,58696,56616,56616,56584,56552,54504,54504,54472,58600,60679,60679,60679,60679,60679,54440,54473,52424,50279,46119,48167,48232,50312,52393,52425,52425,52458,54538,54538,56619,56684,56651,56684,56717,41861,37667,33474,35621,37735,35589,39881,39881,27370,19017,18985,21098,19017,19018,19050,21163,21163,21163,21163,21163,21163,21196,21228,23276,21196,21163,21163,21163,23309,29680,23341,27534,27534,23308,14791,14823,23342,25454,23374,25422,23308,21131,21195,25388,25388,25420,25388,25356,21195,21195,23342,21229,19115,19082,19082,19115,21229,21261,19148,8451,6338,6338,4258,6371,10565,21228,16969,10597,8484,12711,6371,6402,6434,6434,6434,6434,6434,6434,8515,8515,31793,38068,23342,19050,12613,19051,27600,16873,29681,6404,4291,8517,4291,4259,2211,2211,14986,17067,17132,17067,19213,17067,19213,17132,19278,17165,19278,23505,21391,8680,10728,12939,8613,4321,6402,8515,8515,4290,4257,4225,2113,64,2113,2177,2177,2177,2145,2145,2145,4258,6339,6404,8485,6371,8517,10760,19409,17264,10761,10696,6404,4324,6437,8550,8485,8485,10598,10598,255},
{54473,54505,56585,58666,56585,56584,56584,58664,58664,60744,60809,65003,65102,65200,65299,65332,65400,65502,65535,65469,65436,65403,65402,65403,65436,65502,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65469,65266,65232,65265,65298,65365,65400,65467,65468,65468,65468,65501,65468,65467,65400,65331,65198,65066,62888,60775,65068,62890,58696,56616,56584,56552,54504,54472,54472,54472,56552,60679,60679,60679,62727,60680,54440,52425,52425,50279,46119,46119,48200,50312,50345,52425,52425,52458,54538,54538,54571,56652,56651,56652,58798,44008,37700,33442,35621,39848,35654,39914,39882,27370,18984,18985,19017,19017,21098,21131,19050,16936,16937,16872,19018,21196,21196,21196,23276,19050,16872,16904,23276,23243,29647,27469,29582,23275,27469,21097,23276,29615,29680,29614,29614,29582,27502,27469,27501,27469,25388,25388,25421,23341,23309,25487,25487,23374,21228,21228,21228,21196,21196,21228,14856,6338,6338,6338,8484,10564,14791,12710,8484,8452,10597,6370,6370,8514,8482,6402,6337,4257,4225,4258,19082,38165,23211,21229,23374,17002,16937,29746,12614,29648,12776,4291,8550,10728,12874,17067,19213,23472,27698,27730,27762,29811,29810,29810,27762,27762,27763,25682,23570,23569,12906,8647,10793,10694,6402,6434,10628,6402,4258,4290,4258,2177,2113,2177,2145,4290,6339,2177,4290,4324,6437,8550,23472,10663,8517,6371,6436,10761,19442,19344,12841,10761,4324,6372,8517,8485,6437,6437,8517,255},
{54473,56617,58730,60811,58698,56585,58665,58664,58696,60744,62857,65036,65102,65201,65267,65333,65433,65534,65535,65468,65403,65402,65435,65403,65435,65501,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65501,65367,65266,65232,65265,65331,65366,65434,65434,65433,65434,65467,65434,65400,65365,65264,65132,65033,62855,63020,63021,58696,58664,56616,56584,54504,54472,54472,52424,52392,54472,60679,62727,62760,62727,62728,54440,52425,52425,48231,46087,46119,48200,48232,50345,50345,50345,52426,52458,52458,54571,54571,54571,56685,58799,44040,35587,33474,37734,39914,37735,37768,37769,27403,16904,19017,19017,19018,21131,21130,16871,12612,12612,12612,14791,21163,21163,21163,23276,23309,25454,27502,27534,27502,29647,23242,27501,25388,27534,23243,27469,27469,27501,25389,25389,25389,25388,25389,27534,29582,29582,29614,27534,27534,27567,29713,23439,25487,23341,23374,25454,25454,23406,23406,23373,12710,6371,8419,12677,12742,12677,10596,10564,6306,8451,8451,6402,6402,8450,8482,6402,4258,4257,6371,31793,29583,10532,16970,25552,21261,10565,12711,8419,25324,19115,8517,8517,14954,23472,25617,29810,29811,29811,29843,29843,29843,31923,29810,27730,27730,27762,25650,23569,23569,17198,8647,8648,10695,6402,8515,6435,6403,4290,4322,6338,4290,4258,4258,4290,6371,6372,6371,10630,17067,8550,8517,23504,19213,6372,8550,4291,6404,10761,17264,8713,12841,10728,6372,6372,6404,6404,6404,6404,255},
{54505,56617,58730,58730,58698,56584,58665,58697,58696,60744,62890,65037,65135,65201,65267,65366,65434,65535,65535,65436,65403,65402,65435,65402,65468,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65468,65400,65367,65199,65198,65231,65297,65332,65400,65399,65367,65400,65400,65367,65365,65298,65230,65099,65001,62855,65199,60842,56583,58696,56616,54536,54504,52424,52424,52392,52392,54440,60679,62727,62760,62727,62727,54440,52425,52425,48231,46087,46119,46120,48232,50313,50345,50345,52426,52458,52458,54539,54571,54572,56684,54605,44040,33475,33475,37702,37735,37735,37833,39882,29515,18985,18984,16904,16872,16904,16871,16871,12612,12580,12580,14758,21130,21163,21065,18984,23243,27534,23308,25388,23276,25388,23242,27468,23243,27469,23243,25388,27469,27469,27502,27534,25422,27502,25422,27502,29582,27469,25388,23243,25357,29746,29746,29778,31859,25487,25421,25486,27534,27534,25454,25454,21195,12710,10597,12742,14823,10597,10596,8483,6338,8419,8483,8450,6338,4257,8450,8515,8483,4258,6403,31728,21066,10533,14856,25519,25421,8484,8420,8452,18951,27632,10663,8485,10630,25552,25552,29810,29810,29810,29810,29811,29778,29810,27665,27665,23471,25650,21359,23537,17198,21456,8615,6470,12841,8483,6434,6402,4290,6370,6402,4290,4290,2145,2145,2145,4291,10630,10630,8550,15019,14987,8517,17067,23537,6404,8484,8517,4291,8517,10826,15183,15150,14954,10728,4324,6372,6404,6404,6404,255},
{58731,58698,56617,58698,58697,58697,58697,60778,60745,60744,62890,65036,65135,65200,65300,65367,65435,65535,65535,65436,65402,65402,65403,65370,65436,65535,65535,65535,65535,65535,65535,65535,65535,65535,65535,65468,65401,65266,65232,65166,65166,65230,65264,65331,65366,65365,65333,65365,65365,65332,65298,65264,65165,65066,64968,62822,65002,58729,56583,60777,56584,54504,54504,52424,52392,52392,50312,52392,58599,62727,62727,62727,62727,52392,52425,52425,48200,46087,46087,46120,48200,48265,50313,50345,50378,52426,52458,52491,52491,52491,54572,54605,41961,31394,31394,33541,37735,39848,39881,37835,31628,16904,16838,16871,16871,18984,19016,18984,16838,16838,16871,19017,23276,25356,23276,23276,25356,27534,25356,25388,25389,25389,25388,29615,29614,29647,31695,31695,27435,27435,25322,19049,19017,16969,14823,14823,12710,12678,12711,14791,21196,31858,27600,36052,31923,27632,25356,27469,27501,27501,27502,25421,16936,8418,6338,8451,8484,6371,12677,8483,6338,6338,8483,8451,4257,6338,8450,8450,8482,6338,4258,27469,27372,23309,23342,23309,23275,12612,8452,8452,14724,33938,16970,10630,10597,17067,23439,23439,29778,23439,29777,23406,27664,23438,25552,23471,23439,23504,21391,21456,17198,21456,12939,6534,17035,14888,6402,6369,4289,4289,6370,4290,4290,2177,32,64,4258,6404,6371,4291,10696,17132,10728,10663,23537,12776,6306,8484,8484,6404,10761,12940,21524,17199,14922,10695,4324,4324,6404,6404,255},
{62924,58730,56585,60778,60843,58730,60777,60778,58696,60744,62890,65069,65135,65233,65367,65401,65434,65534,65535,65436,65369,65402,65468,65435,65435,65535,65535,65535,65535,65535,65434,65368,65502,65535,65534,65401,65333,65167,65166,65166,65166,65198,65231,65298,65332,65332,65331,65331,65298,65297,65264,65198,65100,65034,64936,60742,62856,58664,58664,58696,54536,54504,52424,52392,52392,50312,50312,52360,58568,60647,62727,62727,62728,52392,52425,52425,48200,44007,44039,46120,46152,48233,48265,50313,50346,50378,52426,52491,54539,54572,54604,52525,44106,31395,31395,33541,35655,39881,37801,35754,33643,18952,21098,23210,23211,23210,23211,23243,23243,23243,23276,23308,23243,25323,25323,29549,31662,31694,31694,33773,29449,29449,31595,37934,37901,37869,35755,44174,35820,42093,31529,14725,10564,12677,12645,14856,14824,14824,12711,14791,25454,31826,27567,36052,29778,25454,25388,27501,27501,27501,27501,25356,12710,6370,8418,6338,8451,10596,12676,10564,8483,6370,8450,14822,10564,10564,10563,6370,8482,8483,4290,23242,37904,23309,29713,21163,29614,12645,8452,8419,23242,29745,14889,12711,10598,8517,21293,21326,27665,23374,29745,21326,27665,21293,29777,21326,27664,19246,25617,19278,21424,17198,21359,8615,19148,14888,8515,8547,6370,6370,6370,4258,4257,4290,10696,14954,10663,10598,10598,6437,6469,12873,12841,8484,14954,17067,6339,4258,6404,6404,6404,10761,12907,17363,10893,12874,10663,4323,4324,6404,255},
{62892,58698,56585,60778,60810,58729,60778,60810,58696,60744,62922,65069,65135,65234,65367,65367,65401,65534,65535,65468,65369,65435,65469,65436,65436,65535,65535,65535,65535,65501,65267,65233,65434,65467,65268,65200,65266,65068,65068,65134,65165,65165,65198,65265,65298,65297,65265,65265,65264,65231,65198,65132,65067,65001,64903,60742,58662,54503,56583,60777,54536,54504,52424,52392,50312,50312,50312,52360,58567,60647,62727,62727,62728,52360,52425,52425,48167,44007,44007,44040,46120,48233,48233,48265,50346,50378,52427,52459,52491,52491,54572,52492,44073,33508,31428,33509,37736,37801,35688,33608,31529,25257,27370,27403,25290,25258,27403,29548,31596,31595,33675,31561,31494,35688,35688,39948,39948,35787,29449,31562,27336,21063,27370,23144,21031,21031,18951,35821,37967,39982,37868,23210,16937,19050,16970,16969,14791,14824,12710,12678,21195,27567,25486,31891,29713,25388,27501,27501,27501,27501,25421,21130,12677,8451,8419,8418,10563,10596,10596,10596,8483,6370,8450,14790,19049,16903,10596,8450,6370,8450,10563,23275,42195,23179,21228,16904,33776,21098,6371,16838,35986,23375,21228,10630,10598,8484,14922,23407,21326,25584,23439,25552,23439,23439,27664,25552,27632,21358,27698,19278,25585,19278,23504,14954,12809,14921,14889,8483,6402,6370,6371,4290,4225,12776,25552,21293,16969,14791,14824,8582,4258,2177,6436,4290,6403,17100,8517,2145,6371,6404,6371,6404,6501,8747,591,6732,12874,8582,6404,6437,255},
{60778,58697,56617,58665,58665,58697,60810,60810,58696,60744,62890,65036,65102,65200,65267,65300,65367,65469,65535,65468,65370,65502,65502,65469,65469,65535,65535,65535,65535,65368,65168,65135,65200,65135,65069,65101,65069,65002,65035,65101,65101,65133,65166,65231,65232,65231,65231,65231,65199,65166,65133,65099,65034,64968,62855,60710,56582,54471,56616,62890,56584,52424,52392,50312,50312,50312,50280,50312,58567,60647,60647,62727,62728,52360,52425,52425,46120,44007,44007,44040,46120,46153,48233,48233,48266,50346,50379,50378,50378,52491,54572,56686,46220,33540,29347,33509,35688,35688,33574,33575,39915,39948,35722,35787,35788,37836,37802,37834,35657,29350,25189,20963,20963,31562,29449,29482,27401,27369,27337,25289,25289,18918,16805,16837,23144,25258,23177,27402,54673,52528,37902,19082,19082,19083,19083,16937,16970,14857,10597,12645,16936,25388,23275,29713,25453,23210,21162,21129,19016,16871,12677,10532,8450,8418,8451,8451,8483,10596,10596,14790,10597,6338,10563,16837,16936,16903,12677,8418,6370,6338,19049,21130,42194,29517,10532,12678,33743,31695,12612,31695,27633,17035,25388,14856,10598,8484,12776,23471,23439,29746,23439,29745,25519,25519,23406,25519,25552,23406,25552,23439,23439,23471,17067,10695,10728,12808,12808,12775,6435,6370,4290,4258,2177,8484,23439,21293,12742,6371,8516,6403,2177,97,64,2145,2177,8582,8549,2113,4290,4258,6404,4291,97,6567,6764,6896,13005,12873,8582,6437,255},
{56585,56585,54504,54504,56584,58665,60777,60778,60777,60745,60809,65003,65069,65135,65234,65267,65334,65467,65535,65436,65370,65469,65502,65502,65469,65535,65535,65535,65468,65201,65102,65070,65004,65003,62955,62890,62889,64969,65003,65101,65101,65133,65166,65198,65166,65166,65198,65198,65166,65133,65100,65066,65001,64936,62822,58662,56550,52390,58665,62922,56616,52424,50344,50312,50312,50280,48232,52360,58567,60647,60647,62727,62728,50313,52393,52425,46120,41959,41959,41960,44040,46153,48233,48233,48266,50346,50346,50378,52459,54572,54572,54638,50413,35620,31428,33509,35656,35655,31429,35688,35754,37802,37835,37868,37836,35755,33577,29383,25124,25124,25189,18850,20931,31562,29449,29482,29449,29449,29449,27369,25256,23110,18885,18918,29549,25323,23177,27403,50513,37868,29516,23276,23276,23276,19083,19050,14824,12711,12678,14758,27469,21162,18984,16904,10563,8450,8418,6370,8483,8418,6370,8450,6338,6338,6338,6338,6370,8483,10564,14791,16904,8451,16804,18885,6370,6370,6338,6338,4225,10629,25388,23243,35888,37936,10565,10565,25355,35855,27435,31823,16970,33906,29647,14855,8516,8484,19148,27632,25552,25519,27600,25487,27633,23341,23341,25487,23407,25519,23439,25519,23439,19213,10695,12809,12809,10630,12776,14922,8549,6468,6404,6371,4258,6371,8549,6436,2177,2177,2209,2177,2177,64,64,97,64,2210,10663,2113,4226,4258,6371,8484,2210,6469,8615,15053,21588,15020,12841,8582,255},
{52392,54504,54504,54504,54504,56584,58697,58697,58696,58696,60777,62923,65004,65102,65201,65267,65334,65468,65535,65436,65370,65468,65502,65502,65469,65502,65535,65535,65302,65070,62989,62956,62923,62923,62923,62858,62857,62889,65002,65036,65068,65100,65133,65166,65166,65133,65133,65133,65133,65100,65067,65034,64969,64903,60742,58629,56550,54470,60810,65003,58697,52424,50344,50312,50280,48232,48232,54440,60647,60647,60647,60647,62728,50281,50345,52393,46120,41927,41927,41960,44040,46153,46153,48233,48266,48266,50346,50378,50411,52459,52492,52525,50445,33540,31428,31429,33575,35656,31461,35689,37868,37835,37836,37868,35722,35722,37836,27302,20962,23043,23044,20963,20964,29448,33675,35822,31628,23077,31497,29416,23078,18884,18852,18950,31662,27435,25257,29417,31595,23209,21096,23177,21097,14791,14823,12678,10532,14758,14791,21195,23243,16871,16904,10564,6338,6338,8418,6338,10531,8483,8451,10531,8418,6338,6338,6338,6370,8484,14823,12677,14790,8451,10531,10563,8450,6338,4257,4258,6338,23243,25388,29549,29581,44243,14758,12612,18951,31563,31760,19179,21294,33874,23243,10597,8516,16969,27665,25519,27600,25519,25487,27600,23407,25454,23341,23406,23439,23374,25487,23407,23374,10696,10695,12776,12808,10598,14889,8550,10728,15019,10728,6404,6339,6371,6403,6435,2177,4257,4257,2209,2145,64,2145,2177,2145,64,2113,2145,4258,6339,6339,6403,8484,6339,4291,8550,15086,21523,14987,12841,255},
{52392,54504,54504,54504,56585,56585,58665,56584,56584,58664,60777,62890,65003,65069,65168,65267,65334,65468,65535,65469,65402,65501,65502,65502,65469,65501,65502,65402,65136,62989,62923,60843,60810,60810,60843,60809,62857,62889,65002,65035,65035,65067,65101,65133,65133,65100,65100,65100,65100,65067,65034,65001,64936,62855,60742,56549,56550,58631,65069,65036,60777,54504,50345,50312,48232,48232,48232,56487,60647,60647,60647,60647,60648,50281,50345,52425,46088,41927,41927,41960,44040,44073,46153,46185,48266,48298,48298,50379,50411,50379,50412,52492,48267,35621,31428,31429,35688,31430,29349,31495,33609,33609,35756,35755,33610,35756,35756,29383,29382,23043,23044,20930,20964,31528,37901,35888,31629,25289,31530,29416,27271,23111,23111,20998,31662,27436,23177,23111,23143,16836,16804,21030,18918,12644,12613,10532,14758,21064,14758,14791,12645,10564,8483,8418,8418,8418,8450,6337,8418,10531,8451,8451,8418,6338,6338,14692,18918,14791,12742,12644,8451,8483,10564,8483,8450,6338,6338,4257,14823,25389,27501,29549,29647,42260,23178,27403,18950,31693,27468,21228,27600,21163,12678,10597,10630,27600,25519,27568,23406,25487,25487,23374,23406,23341,23308,25454,23439,25487,23439,25487,12776,8550,8550,12743,10663,8485,8485,6404,8517,12906,12939,6437,6339,6371,4290,4290,2177,2177,2209,2177,2145,64,64,64,64,64,2113,2113,2113,4258,4258,6371,8485,8485,6371,6371,10631,15020,12907,10794,255},
{52392,54472,54472,54504,56585,58665,56584,56551,56551,58631,60744,62858,62923,65036,65103,65301,65367,65435,65535,65468,65402,65502,65535,65501,65469,65469,65469,65268,62989,60876,60811,60778,60778,60810,60843,60777,62857,62889,64970,65002,65002,65035,65101,65101,65068,65067,65067,65067,65035,65034,65002,64969,64904,62823,60710,56517,58663,62955,65134,65036,60777,54504,50344,50312,48232,48232,50280,56519,60647,60647,60647,60648,60648,48233,50345,52425,44040,39847,39848,41928,41960,44073,44073,46153,48266,48266,48299,48299,50411,52492,52492,54605,50446,35655,29348,29348,35721,33608,31495,33609,29382,31463,33609,37836,37901,35723,35723,27270,25189,23043,23044,25157,29416,27303,33709,35888,33710,31596,33676,29384,27336,33643,31597,25257,31629,29516,25257,23143,25224,18885,18885,16805,14692,10499,10531,14758,21032,21032,14791,16904,12711,16969,16904,14790,8450,8450,8450,8418,6338,10531,8451,8418,6338,6338,6338,20933,20998,16903,10596,14790,16904,10597,21228,14855,6370,6337,6338,8483,23243,27469,31662,29549,31760,35987,35921,31859,31694,29646,23176,38100,27502,16904,10597,10630,25454,27600,27600,25454,27600,25487,25520,25487,23374,27567,25421,25552,25552,25520,25552,14921,10663,8582,12775,12743,10630,6371,4258,4226,4226,10793,15117,8582,6371,6338,4289,4289,2177,2145,2177,2177,2145,64,2145,64,64,32,32,2113,2145,2178,4291,8550,8517,8485,8484,6339,6404,8582,12940,17297,255},
{52392,52392,54472,54472,54504,56584,56584,54503,54503,56583,58696,60809,62890,65004,65102,65300,65434,65501,65535,65468,65402,65502,65535,65469,65435,65436,65434,65137,60876,60811,58730,58730,58729,60778,60810,60777,62857,62889,64937,64970,65003,65068,65068,65036,65035,65035,65034,65035,65034,65002,64970,64937,62855,60743,58630,56517,60809,65102,65134,65036,60810,54504,50312,48232,48232,48232,50280,54440,60647,60647,60647,60647,58600,48201,50313,50345,44040,39847,39847,39880,41960,44041,44073,46154,46186,48266,48299,48299,50347,50379,50379,52492,46220,33576,29348,29348,35689,33543,35690,37868,33609,29382,31463,31496,37836,29415,33642,29448,31496,33643,37902,37902,35822,27335,31595,35855,27337,29450,33676,31530,31529,27336,25257,29483,31596,27402,23144,21063,25257,23144,21064,21065,19017,19017,18985,16937,16904,18951,14823,21196,14857,14857,25487,25421,8483,10531,8482,8482,6370,8483,8450,6338,6338,4225,8418,25093,20998,16904,12709,8516,10597,21163,27567,25454,8451,4257,4257,19016,23210,31662,31694,27436,27501,29680,40343,31924,29745,16937,29549,33775,19016,10629,10597,19147,29745,27600,27600,29713,27600,27665,27600,27632,27600,25454,25421,27600,25519,25552,17034,12743,12743,12743,16904,14790,12677,8452,4226,4193,6404,10760,17198,10728,6404,4322,2209,2177,2177,96,2177,2177,2145,64,97,97,97,65,97,4323,4421,4454,4519,4454,4324,6404,8484,8452,4258,2178,6502,15119,255},
{50312,52392,52392,52391,52391,54504,56552,54471,54471,56551,58664,60777,62890,62956,65069,65267,65468,65502,65535,65435,65402,65502,65535,65468,65402,65402,65335,62990,60811,58731,58730,58698,58697,60778,60810,60777,62825,62857,64938,65003,65036,65036,65036,65035,65002,65002,65002,65002,65002,64970,64937,64904,62823,60742,58597,54436,60842,65134,65135,65004,62858,54537,50344,48232,48232,48200,48200,50280,58567,60647,60647,60647,58568,48201,48265,50345,44040,39847,39848,39848,39880,41993,44073,46154,46186,48266,48298,50379,50379,50379,50412,52525,52526,33609,31495,31429,35722,31495,33609,35755,35755,35689,31463,31496,33642,29415,37869,33643,33642,35756,37935,37935,37935,29416,29449,37935,27304,31563,35788,31595,33708,31563,27370,27402,27403,27371,27371,27371,25323,25291,23210,21097,19017,16904,14823,14823,12678,14791,16839,16969,14856,16970,36051,33906,14822,10531,8450,8450,6338,6370,6370,6370,6370,6306,6306,23013,23046,16903,14823,6371,6403,16936,25487,27600,17034,6403,12677,16937,23243,31694,27468,27436,29582,27567,29843,38263,23439,17067,31826,23242,12710,12678,14856,29778,27600,29713,27600,29681,25454,23308,21195,21195,25453,25355,21064,23307,23275,21129,16870,14822,16903,16903,16903,14789,12709,16969,10630,6404,6372,8582,8615,4291,4258,4290,4290,4290,2242,2242,2242,4290,2177,2178,2210,2243,2210,2210,2308,4421,2341,2406,2406,260,195,2211,8517,8484,6371,4226,4291,8615,255},
{50312,50312,52359,52359,52391,54471,54472,54471,54471,56551,56616,60777,60842,62956,65037,65267,65500,65534,65535,65403,65403,65534,65502,65436,65401,65368,65236,60844,58731,58698,58698,56617,58665,58730,58697,60745,60777,62857,64971,65003,65003,65003,65003,65002,64970,64970,64970,64970,64970,64970,64937,62856,60743,60710,56549,54437,62890,65134,65069,65004,62890,56585,50345,48232,48232,48200,48200,48200,58567,60647,60647,60647,58568,48201,48266,50345,44040,39847,39847,39848,39880,41961,44073,44106,46186,46186,48267,48299,48299,48266,48299,50412,46187,33576,31462,29381,33609,33544,33576,35723,35723,35722,35689,31528,31496,35754,39981,33675,31529,35789,37967,37967,40015,31562,27335,37869,25223,33675,44173,31595,27370,25289,23177,21064,18983,18984,18951,16871,14790,14757,14758,14758,14823,14790,14791,16872,14758,14791,16871,19050,19050,27600,40245,31825,23308,16903,8451,8450,6338,6370,8483,8450,6370,6338,4258,20933,25093,18918,18919,16871,12710,14790,25454,27632,23374,19115,19049,14792,27436,29581,23177,31727,31727,19049,23407,31990,25520,17100,27567,23308,25487,14823,25421,27501,29581,27436,25388,25355,21097,18952,12612,14725,23177,23242,21096,23242,21161,14790,14823,14856,12743,14823,14791,8549,14856,14954,12841,10695,4291,6404,2210,2243,4356,6469,4356,2308,2341,2276,2308,2243,2178,2178,2210,2210,2210,130,130,228,2373,2373,2406,293,195,130,6404,8484,6371,4291,4226,4291,255},
{48232,50279,50311,52359,52391,52391,54471,52391,54471,54503,56584,60777,60842,62924,65036,65234,65468,65535,65535,65435,65468,65501,65469,65435,65369,65335,63122,58731,56651,56650,56650,56617,56617,58730,58697,60744,60776,62858,64971,64970,64970,65003,64970,64970,64970,64969,64969,64970,64938,64937,62856,62823,60711,58630,56517,54437,62923,65036,64971,65004,62891,58665,52393,48233,48200,48200,48200,48200,56487,60647,60647,60647,58568,46153,48266,50345,44040,37767,37767,37800,39880,41993,44041,44074,46186,46186,48267,48299,48299,48299,50379,52492,48333,33575,27268,25155,33576,33576,33576,35788,35755,33576,33576,25124,29415,35689,37802,31496,33675,35822,40048,37967,40016,35854,29482,37869,31529,42029,42094,29516,14691,16837,18983,18951,21064,21129,21129,23210,23210,23243,23243,23243,21162,21163,19050,19017,14791,14758,14791,21130,21162,36084,25388,27502,31728,23243,10564,8418,8418,6370,10563,8483,6370,6370,4258,16772,25093,20965,18918,18951,14790,10564,23341,27633,23374,19115,14791,16904,27437,35954,25323,29614,31727,12710,14889,29909,23309,23275,25389,33874,31728,21130,25290,27403,29483,27435,25355,27436,25323,23211,21097,21163,23308,25421,21227,19147,8647,6469,6469,6502,4421,4389,2275,2243,2275,2275,162,2243,2211,2178,2178,2275,2308,2308,2275,2276,2308,2276,2243,2243,2243,2243,2210,162,2243,2210,162,195,2308,2406,2373,2243,162,130,2210,4291,4323,4291,4290,2178,255},
{48199,48231,50279,50279,50279,52359,52359,52390,52390,54471,56583,60777,60842,62924,62956,65235,65501,65502,65469,65468,65435,65402,65469,65435,65336,65302,60943,56651,56650,56619,56618,56585,58666,58698,58697,58696,60745,62890,62890,62890,64938,64970,64970,64970,64937,64937,64937,64937,64937,62857,62824,60743,60710,58598,54437,56517,65069,65070,64971,64971,64939,58697,52425,48233,48201,48200,46152,48200,56487,60647,60647,60647,58567,46121,48234,50345,44040,37768,37768,37800,39880,41961,41993,44073,46154,46186,46186,46219,46219,48299,48331,52525,50446,33608,33576,31495,31495,33576,31462,29383,33642,31529,31528,31497,33676,33609,37803,27303,29449,37903,40113,40048,33741,33741,29449,33675,33610,29415,33708,31628,14724,25290,27403,25323,25323,25323,23243,23243,23243,23210,23210,21162,21130,21130,19049,16936,14823,16872,16904,14791,14856,33874,23308,19017,38066,21129,10564,8450,8450,6370,8482,8482,8451,8450,6338,8450,20932,12579,12611,18885,10563,8418,16969,25552,25519,17001,12775,16936,33808,38100,31728,29646,21162,8484,10630,29877,25553,19017,16969,29680,21195,25389,25388,25388,23308,21195,21227,19114,12808,10695,10695,8550,6437,6437,4389,4356,4422,4486,4421,2276,2309,2243,163,130,163,2276,2243,2243,2243,97,130,2308,2308,2308,2308,2276,2308,2341,4421,2373,2276,2308,2275,2243,2243,2275,2243,163,195,2276,2308,162,2210,2243,162,2210,2243,4356,4388,4356,255},
{46119,48199,48199,48199,48198,50278,50278,50310,52358,54471,56583,58696,60842,62924,65037,65301,65501,65501,65402,65401,65235,65302,65468,65402,65303,65269,60976,56683,56651,56619,54538,56586,58699,58698,58665,58696,60745,62858,62858,62890,62890,62890,62889,64937,64937,64905,64905,62857,62857,62856,62824,60711,58630,56550,54437,58630,65134,65201,65004,64971,64971,60745,54473,48233,48201,46152,46120,48200,54440,60615,60647,60647,58568,46121,46186,50345,44008,37767,37768,37768,39848,39913,41993,42025,44106,46186,46186,46219,46218,46219,48299,50445,50446,37802,33576,31527,35689,33640,29382,25157,35723,31562,29351,31529,33676,31528,35722,27302,27302,35855,40048,37967,31628,33708,29416,37869,33642,16770,33676,33741,16772,25258,25290,23242,23242,23242,23242,23243,23210,23210,23210,21130,21130,21130,19050,16904,21163,23309,23276,23309,21229,27600,29614,21130,35953,18984,21162,19017,12709,8450,6370,8418,8450,6370,8483,12676,14757,12710,16903,16935,19081,12677,14823,27633,27632,12742,16969,25356,33775,33905,31760,25356,8517,6436,8517,17100,17132,8517,8549,12840,8615,8582,6534,6502,4356,4356,6436,12709,8516,2243,2276,2308,2243,2276,4356,4454,4454,2374,2374,2308,2341,2276,2243,2243,2211,2243,2276,2308,2276,2276,2308,2439,2341,2276,2340,2308,2276,2308,2373,4454,2308,2276,2276,2243,2211,2275,2275,2243,162,162,163,98,130,2243,2275,162,162,2276,4356,2211,255},
{46087,46119,48167,48166,48166,48166,50246,50278,52358,54438,56551,58696,60842,62924,65070,65334,65534,65468,65303,65203,62990,65269,65435,65369,65270,65237,63090,60845,56684,54538,54506,56618,56618,56617,58665,58664,60744,60744,62857,62858,62858,62857,62857,62889,62857,62857,62857,62857,62825,62824,60743,58663,58598,56518,54405,58696,65167,65234,65004,65004,64971,60777,54505,48233,46153,46153,46120,48200,54408,58567,60647,60647,58568,46121,46186,50313,41960,37767,37768,37768,37800,39913,41993,41993,44106,44106,46186,46187,46219,46186,46219,48299,46220,37802,29382,29382,35721,33576,25188,25156,33642,31529,25157,27303,33608,31528,29448,31529,33642,35789,35855,33676,29482,29483,31530,42160,35821,27304,31595,37935,16805,23177,25323,25290,25291,23242,23210,23210,23178,23210,21130,21130,21130,21130,19082,14791,21163,25389,19082,16904,14823,16936,19017,21162,25356,19049,27568,27567,16936,14758,10564,8450,6337,8451,23242,31759,31727,29679,29679,27534,27502,16936,12743,14889,14856,10662,10630,14824,14856,12808,10662,6436,6404,4323,4324,4323,2243,2243,2275,4421,2276,2276,4389,4389,2276,2276,8549,8517,8516,2276,2308,2340,2308,4324,4356,4421,4454,2373,4487,4487,2341,2243,2276,2308,2276,163,2243,2275,2211,163,2308,2536,2374,2276,2275,2308,2308,2308,2341,2406,2373,2308,2275,2243,130,2243,2275,2243,130,162,162,130,97,162,2243,2243,162,162,2308,2275,255},
{44007,46086,46086,46118,46086,46118,48166,50246,50278,52390,56551,58664,60842,62956,65070,65367,65502,65369,65237,63024,60942,65303,65369,65303,65237,63123,63057,65203,60976,52458,54506,56586,56585,56585,58633,58664,58664,60744,60777,60777,62857,62857,62857,62857,62857,62824,62825,62825,60776,60743,60711,58631,56518,54438,54405,60745,65135,65102,64971,64971,64971,60778,54505,50313,46153,46121,46120,46120,54408,58567,60647,60647,58568,46121,46186,50313,41960,37767,37768,37768,37800,39881,41993,41993,44074,44106,46186,44138,46186,46186,46218,50412,48365,35721,31495,31495,33641,31527,27237,27302,31496,31496,23044,25190,33642,27270,27303,31530,33642,33708,33741,29417,29385,27338,33709,42160,31595,29417,33708,40015,18917,23144,25323,23210,23210,23210,23242,23210,23210,23243,23210,21162,23211,21163,21130,19049,23276,23276,21162,23276,23308,23308,23276,19017,14823,14791,25421,25422,14790,12644,10563,8482,6337,16902,31727,29647,29614,27534,14791,8484,6404,4291,2210,4356,8681,12875,10761,2211,4389,4356,4324,4324,10596,10596,2275,2275,4323,2275,2243,4421,4421,2276,4389,4389,4389,4356,4356,4389,4421,4388,2308,4421,4389,4356,4356,4421,4454,4519,2374,2374,2341,2341,2276,2275,2276,2243,163,2243,2211,130,2341,522,2569,2308,2243,130,2308,2243,2308,2373,2374,2373,195,2275,195,162,2243,98,32,97,130,130,130,98,162,2243,2243,162,162,2276,255},
{44006,44006,46086,46086,46054,46086,48166,48166,50278,52391,54503,58664,60809,62923,62989,65301,65434,65303,63156,60943,63024,65303,65336,65270,63123,63058,60976,63090,65236,56652,52425,54538,56586,56585,56617,58665,58664,58664,60744,60744,60777,62857,62857,62857,62857,62824,62825,60776,60743,60711,58631,58598,56517,54438,54405,60777,65135,65102,65004,64971,64939,60778,56553,50313,48201,46121,46120,46120,52360,58567,60647,60647,58568,44073,46154,48265,41960,37735,35688,37768,37800,39881,39913,41994,42026,44074,46187,44138,44138,46186,48299,50412,48365,37801,31495,33576,31495,31496,29350,31496,29415,27302,18850,27270,33642,25158,27271,31530,31529,33676,33709,27369,27304,27305,33675,37933,35789,35822,33741,40079,23110,21063,27436,25323,25355,25323,25355,25323,25323,23243,23243,23210,23210,21129,23210,27534,25389,23276,23309,29712,29680,25486,23341,16904,10532,16904,25324,19017,10596,8482,8482,8450,8418,23210,31727,29614,27534,31694,14823,2145,2145,2113,65,4324,19311,25618,21360,6503,2308,4389,4388,4356,10661,10629,2275,4356,4388,4356,4291,4356,4486,4421,4389,4421,4421,4389,2308,4421,6534,4486,2276,2308,2308,4356,2275,2340,4421,6730,2406,2341,2341,4486,2340,2243,130,97,162,2243,2243,65,261,554,587,261,2243,163,2406,4519,2341,2308,2341,2341,195,2276,2308,195,163,130,97,97,97,98,97,32,98,2211,2243,2211,162,130,255},
{41926,43974,44006,44006,44006,46053,46085,48165,50278,52391,54503,58664,60810,60843,62989,65236,65368,65270,63057,60910,63025,65237,65270,65237,60977,60977,60944,63024,63057,56652,52425,54506,56586,56618,58666,58665,58664,58664,60712,60744,60777,60777,60777,60777,60777,60777,60777,60744,60711,58631,58631,56518,54438,54406,52357,62890,65135,65135,65004,62891,62890,60778,56585,50313,46153,46121,46120,46120,52328,58567,60615,60647,58568,44041,46154,48265,41960,35687,35688,35720,37800,39881,39913,39914,41994,42026,44106,44106,44106,46187,46219,48332,48365,39946,29415,29382,29415,33610,29416,29415,29415,27270,23076,31529,33642,27271,29481,25189,27303,29482,37968,35888,35921,37969,35788,35755,35822,37903,33741,37967,23143,18950,25322,25290,25257,23176,23144,21096,21063,21031,18951,21064,23144,25257,21064,29614,27502,25421,21195,19017,19017,16904,12710,12645,10564,18952,25356,27535,25454,10563,8450,8450,14790,29582,29614,35920,33840,31694,19017,2146,65,65,65,2211,12874,19246,23505,12874,4356,4389,4421,4421,4389,4356,2275,4356,4356,4323,2210,2243,4421,4389,4356,4389,4421,4389,2276,4388,4453,2308,2210,2276,2276,4356,2211,2276,2340,6697,6697,2341,2341,2406,4487,2243,162,163,130,162,2243,195,2308,489,2635,326,130,195,2471,4552,4454,2308,2308,2341,2276,2243,2308,2308,130,2210,2275,2243,97,97,98,32,65,130,2243,2243,163,130,255},
{41894,41926,41926,43973,43973,44005,46085,48166,50278,52391,56584,58697,60810,60843,65070,65236,65335,63156,60944,60911,63058,65270,65237,63123,58831,60944,60976,60976,63057,54571,54506,54506,54505,56585,56618,58665,58633,58664,58664,58664,60744,60745,60745,60745,60745,60745,60745,58664,58631,58631,56550,56518,54438,52358,52357,62956,65234,65300,65037,62891,62858,60777,56585,50345,48201,46121,46120,46120,52328,56487,60615,60615,58567,44041,44106,48233,41960,35688,35688,35720,37768,37833,39881,39914,41994,41994,42026,42026,44106,44106,44139,46219,48365,39947,29415,29382,31496,29415,29415,27302,25189,27269,25189,29448,33674,29481,31595,20996,27336,29450,37968,38001,37935,35821,33642,35755,35854,33708,33676,31595,25256,23143,23143,23110,25223,27337,27304,25257,20997,14723,14691,16771,14723,27369,20998,29581,29680,25356,23243,14791,14823,14791,12678,10532,14791,16871,23275,25389,23340,14789,10531,8450,23243,31728,27501,33840,33839,27468,14955,8517,2145,2178,2178,2210,4356,19247,25651,23473,4389,4388,4356,4388,4356,4356,2243,2243,2243,2243,2178,2243,4389,4389,4323,4356,4389,4389,2308,2275,4453,4453,2276,2308,2276,2308,4356,4356,2308,4454,4551,2374,260,2373,2438,2276,195,195,130,130,163,163,2341,2471,2569,391,228,97,293,358,163,2276,2308,2341,2341,195,2276,2308,163,65,162,2211,162,97,162,130,65,97,162,162,162,162,255},
{39814,41894,41893,41893,41925,43973,46085,48166,50278,54472,56617,58730,60811,60843,62990,65203,65237,61043,60943,61009,63156,63123,63090,58864,56750,58896,60944,60976,63056,56652,54506,54473,54505,54505,56586,56618,58633,58633,58664,58664,58664,60745,60745,60745,60745,60745,58664,58631,56550,56550,56518,54438,54406,52358,52358,65003,65200,65299,65069,62890,62858,60777,56585,52393,48201,46121,44040,46089,50248,56487,58567,60615,58535,44041,44106,48233,41928,35688,35688,35688,37769,37801,39881,39881,39914,41994,41994,42026,42026,44106,42026,44107,46285,44172,27302,27302,29415,29415,29382,27270,27270,31496,27335,29416,31529,33675,33708,23109,29449,29450,35822,35822,35821,33676,31497,33642,33675,33708,29449,18883,20964,25256,25223,18851,31530,33675,29417,27369,23110,14722,14690,16803,23143,31628,27304,25322,29647,23243,23276,16872,14791,14791,12710,10564,14823,16871,18984,27534,23308,14790,8418,10531,25356,29615,27469,31694,31726,23275,10859,19082,4323,6436,6437,6437,2243,10696,21392,19214,12874,2308,4356,4356,4356,4356,4323,2243,2243,2243,4323,2243,4389,4389,2308,2211,4389,4388,2308,2275,2308,4486,4486,2276,2276,2276,4388,2243,2276,2373,2373,2341,228,260,2406,2341,2243,2275,195,130,162,163,2276,2276,2439,359,260,162,130,261,293,293,195,2308,2341,2243,162,2276,2275,162,2243,130,65,65,2178,162,195,130,97,162,195,195,255},
{39813,39813,41893,41893,41893,43973,46053,48165,50311,54472,58698,60844,60876,60876,62957,63056,63090,60977,60911,63123,63124,60944,60977,56718,56750,58897,58896,63057,60911,54539,52426,52425,54473,54505,56553,56585,56617,58665,58632,58632,58664,58664,58665,58697,58664,58664,58632,56551,56518,56550,56518,54438,52358,52326,52358,65069,65266,65234,65102,62890,62826,60746,56585,52393,48201,46121,44040,44041,50248,56455,58567,60615,56487,41993,44074,46153,41928,35688,35656,35688,35721,37801,37833,39881,39914,39914,41994,42026,42026,44106,41994,41994,46253,46220,27301,27302,29415,33642,29416,27302,27270,29416,31562,29417,29450,29482,31628,29450,29450,27336,33742,33774,35821,33643,29416,31562,33675,35788,23142,16737,23142,33742,27304,21029,29482,31563,29450,27336,25224,23110,18883,16803,35855,40048,27304,23177,25421,27469,23308,19049,19050,19017,16904,12645,14758,14758,16838,29680,29680,16903,10531,23242,31727,25453,27534,31727,31726,21227,10892,17100,8517,4291,4291,2210,2211,2276,8681,21393,15020,2308,4356,4388,4389,4356,4389,2275,2211,2178,2178,2210,2276,4389,4356,2178,4324,4388,2308,2276,2243,4389,4453,130,2211,2276,2308,2243,2243,2340,2373,2341,2276,260,2373,2276,162,2275,195,163,162,163,2275,2178,195,2373,228,2276,130,260,293,326,163,2276,2341,2308,130,195,2276,2276,163,162,97,97,2210,162,130,130,65,98,162,195,255},
{37733,39813,39813,41861,41893,43973,44005,48166,52359,54504,58730,60844,60811,60843,60909,62991,61010,58863,58863,61010,60912,56749,58863,56718,56750,58864,60944,63123,58831,52393,52393,52425,54473,54505,54505,54505,56585,56585,56584,56584,58632,58632,58665,58665,58632,58632,56551,56518,56518,56518,54438,54406,52358,50278,52358,65134,65266,65234,65103,62890,60778,60745,56585,52393,48200,46121,44041,44040,48200,54407,58567,58567,56487,41993,44073,46153,41928,35688,33608,35688,35721,37801,37801,37833,39914,39914,39946,41994,41994,42026,42026,39946,46286,46253,29350,27302,27302,33641,29449,27336,27303,25223,27303,31530,33807,29482,31595,29482,29450,20964,31563,33741,33741,31563,29384,31497,33675,29449,20996,16802,27402,31596,21029,29449,35789,31562,31595,31563,25224,21030,23143,18884,35821,42193,27304,25257,27436,29549,25322,21097,16903,14791,12645,10564,10564,12645,14758,29680,29680,21163,21195,29582,31727,27469,31727,31694,31694,19115,10957,10859,12711,2113,2145,2146,2146,2276,10794,21327,19311,8680,2276,4356,4356,2276,4421,6566,2243,2243,2178,2211,2243,2276,4324,4323,2210,2308,2308,2308,2210,2276,4454,2308,2243,2243,2275,2276,2276,2308,2341,2341,2373,2276,2276,2276,2243,162,2211,162,162,163,2243,2275,2178,2243,2276,2276,130,163,293,293,261,163,2276,2373,2438,2341,2243,195,195,97,163,2243,162,65,130,130,97,65,130,162,255},
{37733,39781,39813,39813,41893,41925,44005,48198,52391,56585,58730,60844,60843,60843,62958,60976,61010,58929,58929,60977,58764,56717,58863,56718,56718,58864,60977,63123,56685,52426,52426,52426,52425,54505,54505,54505,56585,56585,56552,56552,56552,56584,58633,56584,56584,56552,56519,54438,54438,54438,54438,52358,52326,50246,52358,65134,65233,65234,65135,62858,60745,58665,56585,52393,48200,46120,44040,44040,48168,54375,58535,58567,56488,41961,44073,44073,39880,35688,33608,33608,35688,35721,37801,37801,39914,39914,39914,39914,39946,39881,37833,37801,37834,37801,29383,29415,27303,33642,31497,25223,25190,23077,25223,29449,29482,27271,29416,29515,29483,18884,31595,33741,35822,29417,29384,29417,29449,23109,16802,20997,31629,31629,23110,25223,33708,27335,23077,16803,16803,21030,21029,23143,35822,42160,25223,23110,37835,27337,12644,10531,10498,10532,12645,16903,19016,21129,23243,23243,23275,21195,21196,16904,23210,31662,31760,27566,29581,17035,10924,6666,14889,4258,2145,2145,2145,2178,4422,19279,25586,21327,2308,2276,4356,2276,2210,2178,97,2276,2275,2275,130,2243,2243,2275,2243,2275,2308,2308,2308,2243,4421,4518,4389,2211,2276,2275,2276,2243,2276,2308,2308,2341,2243,2276,2276,2243,2243,2243,195,2275,195,2243,2275,2276,2341,2340,4290,2275,2341,260,293,195,163,2373,2503,2471,2308,195,195,162,98,163,163,65,65,130,130,65,97,130,255},
{37701,37733,39781,39813,41893,41925,46085,50278,54504,56617,58698,58763,60844,60844,60877,60944,58930,58963,58963,58831,54604,56717,56750,56718,54605,58863,61009,63058,52491,52426,52458,52458,54505,54505,54473,54473,54505,54505,54504,54472,54472,56552,56585,56552,56552,56519,54471,54438,54438,54438,52358,52326,50278,50246,54438,65003,65069,65135,65070,62858,58665,58665,56553,52392,48232,46120,44040,44040,48168,52328,56487,58567,56488,41961,41993,44041,39848,35656,33608,33608,35688,35721,37801,37801,37834,37833,39914,39914,37833,27270,27271,27270,27302,27302,29415,29415,27335,33610,27304,23077,23077,20997,25191,29416,23110,25223,29417,29450,29548,23110,33708,33676,29450,20996,29384,27336,29450,27336,16770,20997,29516,33709,25223,20997,33676,27303,16770,14657,14658,21030,21029,25223,33676,23110,14690,14723,33608,29449,8418,10499,16838,21097,25291,33807,35952,35920,29647,19017,12644,21130,16969,10564,18984,23210,25454,14823,12644,14922,10925,6666,12842,10597,65,2145,2145,65,2276,17133,19214,21360,8648,2276,4356,4356,2243,2243,2243,2276,2308,2341,2210,2178,2308,2308,4356,2243,2276,2308,2308,2243,2276,4421,4388,98,2243,2275,2276,2275,2243,2276,2276,2308,2243,163,2275,2243,162,195,2275,163,97,195,2308,2406,2471,2373,195,2341,4486,260,228,293,228,195,2373,4584,4519,2308,195,195,130,162,162,130,130,130,98,130,130,130,255},
{37701,37733,37733,39813,39813,41925,46086,50311,54504,56585,56650,58763,60844,60844,58796,58896,58963,58963,58930,54572,52491,56750,56750,54604,54572,58863,61009,61009,52459,50345,52393,52425,54506,54473,54473,54473,54505,54504,54504,54472,54472,56552,56552,54504,54471,54471,54439,52358,52358,52358,52358,50278,50246,48198,52358,62824,64970,65003,65003,60777,58665,56585,56553,52392,48232,46120,44040,44008,46088,50248,54407,58535,56487,41961,41961,41961,39848,35656,33576,33608,33640,35721,35721,35721,37833,37833,39914,39914,35753,23077,23077,23109,25157,25189,27302,29383,29383,31529,27336,27336,25223,25191,23110,27336,27304,27336,29482,27337,31596,21029,29514,31563,27336,18884,29449,27336,29482,27369,16770,23110,29515,31661,25256,20997,29450,29449,18883,16803,16804,23144,23176,23176,29549,23210,25290,25323,25289,23144,10531,14725,29614,29615,23210,33807,31726,29581,25356,21129,10531,16937,19050,14758,16870,14823,25422,12677,10531,12906,10892,6568,15183,14889,2178,2210,2211,2243,2244,8616,19246,19213,19213,2308,4356,4356,4324,2243,2308,2276,2308,2308,2243,130,2243,2276,2308,2243,2211,4356,2308,2276,2243,2341,4454,2308,2275,2243,2243,4421,4421,2243,2276,2243,2276,2211,2243,195,163,195,195,97,33,130,195,325,488,326,228,293,2373,260,261,293,325,195,228,4454,4551,4519,260,2308,2308,2275,163,2243,195,130,98,130,130,65,255},
{35653,37701,37733,39813,39813,41925,46086,48230,52424,54537,56650,58763,58796,58764,58797,58897,58963,58963,56849,50411,52492,58897,54637,50411,54572,58863,63123,60977,52459,50345,50313,52393,52425,54473,54473,54473,54473,54504,54472,54472,54472,54472,54472,54472,54471,54439,52358,52358,52326,52326,50278,50246,48198,48166,50278,58631,62857,62824,62857,60777,56584,56552,54504,52392,50280,46120,44040,44008,46088,48168,52327,56487,54407,41961,41961,39913,37800,35656,33576,33576,33608,35689,35721,35721,37801,37801,37834,37834,37801,25189,23076,25189,27270,29415,29415,29415,31529,31529,29417,27370,27369,27369,27304,25190,29449,23142,25256,29482,29483,18916,27336,31596,29515,25256,31562,27304,29417,29515,18916,27369,29483,33676,31629,27370,27403,29516,27436,27436,27468,27469,27436,25356,25323,23242,23177,21064,16870,16870,12644,14724,31662,29646,23243,31694,33839,33807,29614,27501,14758,14791,21163,14823,10531,14790,27600,16872,16904,12939,10924,6567,17263,19181,8517,4324,4356,4324,4324,2243,2211,2276,8615,130,2243,2275,2275,2243,2276,2243,2275,2373,2308,195,2243,2308,2243,2178,2145,2275,2308,2308,2243,2275,2373,4486,2243,2210,2211,2243,130,2210,2276,2243,2243,2275,2243,195,227,2308,195,2211,97,130,195,358,586,553,293,293,2438,2438,293,293,423,325,195,2341,2406,2406,260,2373,228,227,163,162,162,130,65,98,130,65,255},
{35621,37701,37733,37733,39813,41925,46086,48198,52391,54537,56650,58731,58763,58764,58764,58863,58931,58963,54671,50379,50411,56783,52459,50346,52524,58896,63057,54540,50346,50346,50313,52393,52425,52425,52425,54473,54440,54472,54440,54472,54472,54472,54472,54472,54439,52391,52358,52326,50278,50278,50246,48198,48166,48166,50246,60744,62857,60744,60744,60745,56584,54504,54504,52392,50280,46120,44040,41960,44008,46120,52295,56455,54408,39913,39913,39881,37800,33608,33575,31528,33608,33640,35688,35688,35753,35721,37801,37834,37801,35721,33641,37866,39980,44206,37801,27303,29448,27303,29450,29482,23142,23110,27303,23109,23109,27303,27368,27369,27337,16803,21030,31629,33774,27370,23110,25191,29450,29450,23078,29449,31563,35787,31563,25322,23242,23209,21096,19015,18950,16837,14757,14724,14724,14757,12644,12611,12644,16838,14757,14724,27403,25289,23242,27468,31693,27467,25354,29614,25355,23209,25355,29580,10563,8483,23406,17002,19017,12972,8811,6568,17133,19311,12776,2243,4323,2275,4324,2178,98,17101,19278,6535,2211,2276,2275,2243,2275,2308,2243,2373,2373,2340,2276,2308,2243,2242,4323,2243,2276,2276,2276,2243,2275,4486,2308,97,2211,2243,2210,98,2243,2243,2211,2243,162,2243,2276,2374,2308,195,2243,195,195,260,390,488,358,261,325,326,325,260,358,358,195,228,260,195,163,260,260,195,195,162,162,162,130,65,97,97,255},
{35621,35653,37701,37733,39813,41925,46086,50311,52424,54569,56650,56650,58731,56683,56684,56783,56882,56817,52492,50379,50411,54605,50346,48265,52492,60944,52459,48266,48266,50346,50346,52393,52425,52393,52425,52393,52392,52392,52392,52392,52392,52392,52391,52391,52359,52359,50278,50278,50246,50246,50246,48166,48166,48166,50278,60776,62857,60712,60712,58664,56552,54472,54472,52392,50280,46120,44040,41960,44008,46088,50247,54375,52328,39881,39881,39881,37768,33607,31527,31528,33608,33640,33640,33640,35721,35721,37801,37801,37801,37834,37834,42026,42027,44174,37801,29481,31562,29448,31562,31563,25223,27303,27303,25190,29482,27369,29449,27336,29482,18916,23143,33774,31628,25255,25190,27368,31595,31563,31530,31562,31594,35722,23142,16804,14724,14756,12644,14757,14724,12644,16838,14757,14724,14725,14790,16838,18984,18984,14757,10530,23208,21063,18918,16838,14790,10564,16903,35919,33741,29547,27402,27434,16934,10564,21326,23504,19082,12939,8746,6503,10728,19376,17035,6404,2243,2275,2243,2243,2179,21294,8551,17133,4324,2276,2276,2275,2275,2341,2276,2308,2341,2308,4291,4290,2308,2340,4356,2243,2275,2308,2276,2275,2243,2308,4421,2340,2275,2243,2308,2308,2243,2210,2243,2243,162,162,195,358,423,228,163,163,163,130,195,293,325,260,2406,293,293,228,359,358,195,163,228,195,97,130,260,195,195,162,98,130,130,65,33,65,255},
{35621,35621,37701,37733,39813,43974,46118,50343,54472,56617,56683,56650,56651,56650,56684,56783,56849,52590,48298,50379,52491,52491,50346,48265,54572,54572,48234,48234,48234,48265,50346,50345,52393,52393,52393,52393,52360,52360,52359,52359,52360,52392,52359,52359,52359,52359,50278,50246,48166,48198,48166,48166,48166,52358,54471,56583,60712,58631,58664,58632,54504,54472,54472,52392,50280,46120,44040,41960,44008,44040,48168,52327,50248,39881,39881,37801,37768,33608,31527,31528,33576,33608,33608,33608,35689,35689,35721,35721,35721,35721,37801,39914,39915,44207,33608,29416,29417,33607,33641,33674,25223,25223,25223,27336,29483,23110,29482,27369,27336,20996,23110,29482,25256,25255,25223,23142,20997,18884,18884,16771,14690,16803,25191,23143,14757,18951,18984,21129,21097,21162,25356,25356,25389,27469,27470,27470,25389,16870,10530,10497,21063,23143,18885,27469,29648,14790,19016,33742,29516,31661,35887,31628,25354,21097,21162,27665,19115,10924,6665,4422,4356,19279,19246,10630,2243,4324,2276,2275,2178,6502,6567,19279,10663,2211,2275,2243,2275,4421,4421,2308,2341,2340,2340,2308,2276,2308,4453,4421,2243,2243,2276,2308,2243,2275,2373,2373,2340,2211,2276,2276,162,162,2243,2243,2243,130,162,228,456,358,195,162,162,130,162,195,2341,2341,2374,228,260,326,358,391,326,195,162,195,162,162,195,162,130,32,32,98,130,65,65,65,255},
{33573,35621,35653,37733,39813,44006,48230,52392,54505,56618,56650,56650,56650,54570,54603,56718,56784,52491,50378,54571,54603,52458,50346,48265,52491,50378,46154,48234,48233,48233,48233,48233,48233,50313,52393,50312,50312,50312,50279,50279,52360,52360,50311,52359,52359,50279,50246,48166,48166,48166,48198,48166,50278,54471,56551,52391,56551,56583,58632,58632,54504,52392,52392,52392,50280,46120,44040,41960,41960,44008,48168,50247,50248,39881,39881,37801,37768,33608,31527,31496,33576,33608,33608,33608,33641,33640,35721,35721,35721,35753,37801,37834,39915,44207,33641,29416,27368,23109,27303,31561,23143,25223,29482,29515,27369,25223,31595,31595,25255,23110,25255,27337,18917,12545,12577,14658,12577,14658,16803,21096,23177,25323,29549,27469,27469,29550,29550,27502,27469,27436,25356,25355,23243,23210,21129,21097,19016,16837,10530,10498,21063,25224,18885,25389,33939,19016,16903,19049,29647,31695,33774,18982,14756,12676,16871,27600,17002,10892,6666,8713,4389,12907,21424,12841,4324,2276,4324,2275,2211,2211,19279,25553,10761,2243,2275,2243,2276,4421,4454,4454,2373,2373,2340,2308,2308,2308,2341,2373,2243,162,2243,2275,2243,2243,2340,163,2373,2341,2276,2243,65,65,162,130,130,97,130,162,359,424,228,163,195,163,130,163,163,260,260,195,2211,4454,2439,358,423,358,227,130,195,195,195,130,130,33,0,33,97,130,130,33,255},
{33540,35620,35621,37733,39813,44005,48230,52424,54537,56617,56618,56618,56618,54538,54538,54604,54670,54538,54538,54537,54537,52425,50345,50313,50346,50346,48234,48265,48265,48265,48233,48232,48232,50313,50313,50280,50280,50280,50280,50280,50312,50312,50279,50311,50279,50279,48198,48166,48134,48166,48166,48198,50311,54439,52391,50279,54439,56551,56551,56552,54472,52392,52392,52392,50280,48200,44040,41960,41928,44008,48136,50247,48168,39881,39881,37801,35720,33576,31495,31495,31528,33608,33608,33576,33641,33641,35721,33641,33641,35721,35721,37834,37867,44207,35722,25255,27336,23142,27303,31529,23143,23143,29516,31628,27369,29482,31628,33741,29515,27401,29449,29482,23110,12546,12578,14690,14690,14658,20997,31630,27437,23243,21130,25356,27469,23177,21096,21064,21064,18983,18984,21064,19016,18984,18984,18983,18984,18952,14756,12610,21031,23144,18918,25356,33842,21129,16903,16936,31728,31728,31727,16869,10563,14789,14790,25520,14889,8746,4487,12907,4422,10892,19312,17101,6404,2146,2146,65,65,2243,6567,15053,21425,10761,2243,2243,2340,2373,2373,4421,2275,2341,2276,97,2178,2276,2308,2373,2308,162,2243,2275,2243,163,2243,2308,4453,4453,2276,2276,65,32,130,2210,2243,162,98,130,195,424,326,162,162,162,98,98,130,260,2406,2275,2210,4356,2373,325,359,391,325,2341,162,163,195,162,97,65,0,0,65,97,65,33,255},
{33540,33540,35621,37733,39813,44005,50278,52391,54537,54537,54537,54537,54537,52457,52425,50378,52491,54538,52457,48232,48231,50345,48233,48233,46152,46152,48265,50313,50313,50313,50313,50281,48200,50313,48232,48200,48200,48199,50280,50312,50312,50280,50279,50279,50247,48198,48166,46086,46086,48166,46118,48198,50311,50311,50279,48199,52359,56551,56551,56552,54472,52392,52392,52360,50280,48200,44040,41960,41928,44008,46088,50216,48168,37801,37801,37801,35720,33576,31495,31495,31528,33608,33608,31528,33608,33609,33641,33641,33641,33641,35721,37834,37866,42127,35722,27303,27336,25223,25255,27368,25223,23110,27370,31628,25223,23143,27369,27336,31595,29482,27369,25223,20997,12578,12578,14626,12578,12577,18884,31630,21098,10565,12614,21098,27469,18951,18951,18983,18951,18951,18983,18984,18983,18951,18984,18984,18951,18951,16903,18983,21096,27468,27436,35920,31761,21162,12709,14823,29648,31761,33808,27435,23241,23209,21162,27568,14856,10859,10761,15118,15118,17231,21391,19279,12711,65,65,65,97,2211,4356,17133,23506,8648,98,2243,2308,2373,2373,2341,2243,2276,260,163,2243,2276,228,2308,2308,2243,2243,2276,2276,2243,163,4389,6534,4388,2243,2275,130,32,33,2178,2211,130,130,97,162,293,456,228,162,2276,228,195,98,195,2373,162,130,2210,292,390,358,359,358,293,98,162,130,98,65,98,32,0,0,65,97,97,255},
{33509,33540,35621,35653,39813,44038,50278,52424,54537,54537,54505,52457,52425,52425,50345,48264,50345,50345,50345,48232,48232,50313,48265,46120,44039,44040,48200,48233,48233,50313,50313,48200,48200,48233,48232,48200,48200,48200,48200,50280,50280,50279,50247,50247,48199,48167,48167,46086,46086,46086,46086,50279,50279,50279,48231,46119,50311,54472,54471,54471,54472,52392,50312,50312,50280,48200,44040,41960,41928,41928,46056,48168,46088,37801,37801,37801,35688,33576,31495,31495,31528,31528,31528,31496,33576,33609,33609,33609,33608,33641,35721,37834,37834,42094,39948,37835,25223,27336,25223,23143,25223,18916,25256,29515,25256,16771,21030,29450,31628,25256,27337,21030,21030,12578,12545,12578,12578,14658,18884,29549,23211,16838,16870,21097,27502,18951,18951,18951,18983,18951,18951,18984,18984,18984,18984,19016,18983,18984,21129,23274,18982,31694,27469,33775,29648,23275,12677,14758,25388,29582,31695,31694,29580,25355,23374,23439,10696,8713,8714,17263,15117,19376,21326,21391,14954,4356,2243,2275,2276,2276,98,12907,23440,19278,6469,2211,2276,2308,2373,4454,2373,195,260,260,260,195,195,195,195,163,2211,2276,2275,2275,162,195,130,97,130,2243,2211,65,32,97,130,32,32,65,130,260,521,424,163,2373,2503,2438,162,260,195,32,32,130,162,260,2439,358,326,293,195,163,163,33,65,65,65,0,0,130,97,97,255},
{31461,33541,33541,35653,39813,46086,48230,52391,52424,52457,52425,52424,50344,50344,48264,46152,48264,50312,50312,48232,48232,48233,46153,44040,44007,44039,46120,46120,46120,48200,48233,48233,48233,48233,48233,48201,48200,48168,48168,48232,50280,48199,48199,48199,48199,48167,46119,46087,46087,44006,46086,50279,48199,48231,48199,46119,50312,54472,54471,54471,54472,52360,50312,50312,50280,48200,44040,41960,41928,41928,44008,48136,46088,37801,37801,37801,35688,33576,31495,31495,31496,31528,31528,31496,31528,31528,33609,33609,33609,33640,33641,37834,37867,42127,39948,37867,27303,27336,27368,25191,27337,18916,25223,27370,23143,16803,25256,33775,31628,27336,27336,23175,21030,20998,21030,25256,27336,29449,31594,31629,23275,16838,16837,18952,27469,18984,18951,18983,18984,18984,18983,18951,18984,16903,16903,18983,18951,16871,18984,18982,14787,25354,27469,33807,29615,23308,16903,16903,23242,23243,25323,31661,31661,29614,31891,17198,13004,13037,8746,19344,12907,19376,12940,17166,17165,8582,2243,2243,2243,2276,2211,2243,10827,23505,8583,130,2308,2341,2373,2341,2341,195,195,228,228,260,195,163,195,2243,2276,2308,2341,2308,163,162,130,162,2275,2243,2243,2211,32,32,2210,97,0,2178,130,195,358,521,228,130,2373,2438,2406,260,228,0,0,130,2275,130,2308,2405,228,228,293,195,130,97,65,97,65,65,0,162,162,97,255},
{31461,31461,33541,35653,39846,46118,50279,50311,52424,52424,50344,50344,50312,48232,46152,46152,46152,48232,48232,48200,48232,48201,44040,41960,44040,44007,44007,44008,44007,46120,48200,48200,48200,48233,48233,48201,48200,46120,46120,48232,48232,48200,48199,48167,46119,46087,46087,46087,46055,44006,44006,46087,48167,48232,46119,46152,50280,54472,54472,54472,54472,50312,50312,50312,50280,48200,44040,41928,41928,41928,44008,46088,44008,37801,37801,37801,35721,33576,31496,29416,31496,31528,31528,31496,31528,31528,31528,33609,33609,33609,33641,37834,35787,40047,39948,29416,25191,27368,27368,25191,25257,20997,25256,27402,25256,16771,25256,31629,29515,23143,23143,27336,25256,29481,29449,27368,27303,23142,25190,29516,25356,16870,16870,18951,25421,19016,18950,18951,18984,18984,18952,18984,18984,18984,18984,16904,16903,16904,19017,16935,14755,18982,29549,33807,29581,25323,23177,19016,23242,21129,23275,31661,31661,40048,33971,15052,12972,8746,8713,19344,8681,17165,17263,12907,19344,14889,2243,2243,2243,2276,2243,2210,14988,19279,15085,4356,2276,2308,4421,4454,2341,2309,195,228,260,228,227,195,163,65,32,163,2309,2308,195,195,195,2275,2275,130,2210,163,32,0,65,2178,97,2145,97,130,325,2504,325,130,2308,2438,2438,2406,260,32,32,65,195,130,2210,2275,195,195,260,260,228,228,97,97,97,97,97,130,130,97,255},
{31429,31461,33541,35653,39846,46119,50279,50311,50344,50345,50313,48264,48232,46152,46152,44072,44072,46152,46120,46152,46153,46120,41960,41928,41960,44008,44008,41959,44040,44040,46088,46120,46087,46152,48233,46153,46120,46088,46120,48200,48200,48168,46119,46087,46087,46087,44007,44007,44007,43974,41926,41894,44007,48232,46120,46120,48232,52392,52392,54440,52392,50312,50280,50280,48232,46120,44040,41928,41928,41928,43976,46088,44008,35721,37801,37801,35689,31528,31496,29416,31496,31528,31528,29416,31496,31496,31497,31529,31529,33609,33609,35754,35722,37935,37901,29416,21030,25256,25256,25191,18884,20997,25255,25223,25223,20997,25223,29516,29516,21063,23176,31563,21030,12578,12578,16805,16804,16837,16771,27403,27469,21097,18983,21097,25422,19017,18951,18984,19017,19049,19017,19049,19049,19017,19017,19017,19017,19050,19082,21163,21130,21130,18985,23275,16869,12611,10498,12644,25323,21129,21162,31660,37934,40048,38100,17231,12972,6535,10794,19311,6568,10827,19377,8746,17231,15117,6470,2243,2243,2275,2276,2178,4389,17134,21393,12875,163,2308,2373,2406,260,260,228,195,260,260,260,228,195,97,97,130,2308,2309,163,163,163,195,162,32,98,2243,97,0,0,2178,2210,2145,97,97,162,2373,292,97,130,2373,4551,4584,2308,97,33,130,130,130,130,195,2308,163,228,325,2439,326,228,130,97,97,97,65,32,163,255}
};

const uint16_t Bogota PROGMEM [320][241] = {
{27698,27698,25618,23570,23570,23571,19475,17428,19508,21556,21556,23636,29877,34037,36117,36085,31957,27797,34070,44537,46617,44537,42424,42391,40311,40343,40344,40311,40279,38230,38230,38230,40311,46585,46617,40344,32023,29942,32055,21457,359,391,392,359,359,359,359,4552,12873,10793,17034,19179,14953,8712,6632,6599,8680,8680,4519,4519,4519,8712,12905,12905,14985,14985,23340,25485,17066,12873,14953,10728,6599,8647,10727,2341,2341,8679,8646,6598,6566,12839,10727,8646,10759,8614,4421,4454,4421,4421,6534,8614,6534,10759,12807,14920,8646,6566,10726,10726,6501,4421,8646,6501,4356,2243,6436,2276,2243,2211,2211,131,14954,21163,2243,2211,2243,21292,8678,2340,2275,2211,2178,2243,2243,2243,2275,2211,163,8550,10728,10630,12711,10760,10728,8648,12743,14693,8549,6404,4291,2243,4356,10663,14824,31825,33906,31760,16969,29713,21130,23275,25453,21358,4454,6534,10695,19243,17098,14855,14758,41768,43816,43816,41736,46255,31560,10727,12807,19082,35953,44339,12776,6437,4486,12906,14888,27533,33807,31792,25453,31726,8583,38000,52432,54543,46222,48238,54414,52660,42194,19082,42292,54904,35919,8645,14984,21161,17034,19081,12806,4388,2308,4389,17034,36048,38130,38033,35919,33774,29646,42225,21194,40145,19081,40113,21162,35952,21227,31759,25388,19114,27500,29549,29581,40080,59065,59032,35888,44470,52792,31891,27533,35887,40179,56429,58345,45832,46322,63225,231},
{27730,27698,27698,25618,25618,23571,19475,17428,19476,19508,21556,23636,29877,36085,36118,34037,31957,29877,34070,44537,46585,44504,42424,42424,40311,38263,40311,40311,38231,38231,40279,40278,40311,42424,44537,40376,34135,29943,27927,25781,2505,359,391,359,359,359,359,359,4552,8712,10793,10793,12873,8680,8712,12873,14953,14953,10793,10793,4551,2439,2439,14985,14985,12873,14985,17034,14985,12873,12872,6599,4486,8679,10727,6566,2309,4486,8646,8646,6534,8614,8647,10759,8614,6502,4421,6501,4421,2308,6566,12775,6534,10759,12839,12872,14952,8646,17064,19144,14919,6533,4356,6533,2275,2276,2243,2243,2243,2211,2211,130,14987,40147,27435,12677,12808,21292,4452,4452,2340,2308,2276,2276,2275,2243,2211,2243,2276,17002,14922,14921,14823,12743,12743,12743,12743,14758,8549,4323,2178,2178,2211,10631,12776,29713,33906,33873,21195,25486,21162,23275,31760,31891,10728,10695,8550,21291,17099,19082,16936,23112,23112,23144,27435,46352,29580,10662,12678,14921,33839,46485,10695,4324,4421,8712,16936,27468,29646,33840,29646,35920,14953,40015,52399,56623,48271,52366,52400,54807,44306,35920,50679,54839,44305,21291,25451,48336,25356,27533,17032,6533,6469,2308,25485,36081,36081,38032,31694,42225,23307,38000,31694,40080,29613,38032,29581,38000,29580,35919,27468,23307,31726,33774,31661,52561,61112,52693,31760,50712,42292,40147,46387,29515,25420,43947,58346,43817,54805,52627,169},
{29779,27730,27698,25650,25618,23571,19476,17428,19508,23636,23636,23636,29877,36117,36117,34037,31924,29844,34070,42424,44504,44504,44504,40311,38231,38263,38263,40311,40279,38230,38230,40311,40311,42457,42424,38263,36183,32023,25847,25847,8811,327,359,359,359,359,359,359,359,6632,8712,6600,6599,6632,6632,10792,12905,17034,10792,10793,8680,4551,4519,4551,12873,8712,12905,14985,14985,10760,10792,4454,2341,6599,6567,2373,2341,2341,6566,6534,6566,10759,14984,12840,10727,6502,6534,10727,6534,4421,4421,12840,17033,6534,4389,12839,12839,6534,12839,19144,14951,8646,4421,2276,2243,2275,2243,2243,2211,2178,2178,2178,163,27632,40015,18982,21259,21291,2307,4388,4453,4485,2372,2340,2275,2243,2243,2211,4389,21260,19147,14986,12906,10793,10760,8615,4389,4291,6437,4323,98,2178,130,8550,12776,29712,33906,33906,27534,23340,16969,10695,29745,38263,31825,21227,10597,12677,21260,25290,25160,23079,18886,18919,27436,46285,23306,10630,14822,14888,38001,46485,23308,12743,8550,12841,16904,17002,16969,19147,25388,27534,8647,25257,52399,56591,50319,52366,50352,46452,37967,38066,54872,56952,59130,33937,46321,50450,31661,21226,8581,8614,8581,4421,29775,34032,36048,40210,33774,42226,25388,31726,33774,35919,27468,31726,29613,29645,27500,25420,25387,12808,27467,35952,37934,56786,54838,37967,33873,52825,38001,42293,50646,29418,27567,39950,43817,41769,29449,25191,103},
{29811,29779,27730,27698,25650,25651,19475,19476,21588,23636,21588,21588,27829,36085,36085,34004,31892,29844,34037,40311,42424,44504,42456,38263,38263,40343,40311,40311,40311,38230,38230,40279,40311,42424,38263,38231,36151,29975,25847,27928,19344,359,359,359,359,359,359,359,391,4552,10793,8680,6632,8712,6599,8680,8680,12905,14985,8712,10792,8712,8712,8712,10760,6632,8712,15017,12873,8679,2406,2374,261,4519,8647,6599,2309,2341,8679,6566,8711,10759,14952,14920,8646,8646,8647,8646,6534,4421,4454,8647,14920,10727,4421,10759,10759,10726,8646,12839,12871,10694,6501,4388,2243,2211,2211,2211,2211,2179,2178,2211,163,19180,25421,21260,25518,19178,162,4356,4453,6565,4485,4388,2275,2243,2243,2211,2244,23112,21097,16904,16839,8517,4324,4291,98,2178,2178,2178,2178,2178,130,6470,12776,29713,33938,33938,17066,12808,14823,4389,14987,38328,38230,21228,12710,10597,14954,29417,31400,27239,25127,18984,25290,39945,14855,10597,16871,14855,40146,35953,29680,21228,23243,21130,23341,21228,15020,19115,12841,17002,12808,21064,52399,56591,54447,50286,52694,50679,25420,35985,52791,57017,59164,48533,61079,42356,33708,10661,4420,2275,2307,10759,33968,34032,36081,48597,52758,54806,48500,46387,48500,46419,42161,37967,44306,31693,40080,29581,35919,19146,25452,27597,40079,42127,25355,14888,40179,46486,42292,40179,46485,42030,42195,35724,25159,23079,16805,18983,72},
{29811,29779,29778,27730,27698,25651,21555,19508,23636,23636,21588,21588,29877,34037,34005,31924,29844,29844,34038,38263,42392,44504,46584,42424,44472,44472,40311,38231,38231,38231,38230,38231,40344,40376,38231,38199,34103,27895,25847,25847,23701,4553,359,359,359,327,359,359,359,2472,8712,12873,10760,12873,10792,14986,17034,14954,10825,8712,12905,14953,14985,14985,12840,12905,10793,14953,14985,8712,293,2373,261,4454,8679,8679,4422,228,8647,6534,6533,10726,4453,10759,12839,10759,8646,10727,10727,6566,6566,6566,8646,12840,10695,14920,12872,10791,6501,8646,14984,6534,4421,2308,2275,2211,2243,2276,2275,2243,2211,2211,2178,2342,29777,21292,21260,8646,2275,4356,6565,4453,2275,2210,2275,2276,2275,2276,130,18854,23177,12710,14660,8419,2178,2211,2178,2178,2178,2178,2211,2211,2211,6437,12744,27632,33938,33873,12840,8582,12710,98,8746,40408,40343,23373,16969,16903,25224,41735,43815,43947,40081,35953,33840,38000,31760,25421,25421,23308,23308,19147,29712,29647,44307,52725,54871,54839,54839,54807,52727,52694,35789,16903,50350,54543,54479,50319,59066,54937,23307,44372,54871,61243,61146,52628,56918,42388,37966,8613,6533,4388,6500,19210,33968,34000,38161,56984,61178,59065,61146,61178,54937,57017,40081,33840,54839,40114,52758,50678,50613,44306,25484,21323,23371,27533,35888,19049,48631,40081,35986,48599,46453,46354,57018,48435,23079,25191,29384,25191,117},
{31891,29811,29779,27731,27731,25651,23603,21555,21556,21556,19508,23636,29877,34005,31924,29844,29811,29844,34038,38263,42423,44504,46617,44536,44504,44472,40311,38231,36150,34102,34071,34103,38296,38263,38231,38263,34103,25815,25815,25815,25879,10957,359,359,359,359,327,359,359,2472,6632,8713,12873,10793,10825,14986,19147,17066,8712,6632,10792,14953,17098,19179,12905,12873,10792,12905,12872,10760,2373,293,261,293,10760,10760,6599,2341,6566,6566,4486,6534,12807,10727,10727,6534,4421,8614,8614,4421,6566,8646,6566,12840,19177,14984,12871,8678,4421,4421,10758,8614,8646,6501,2308,2243,2211,2211,2243,2243,2243,2211,2244,6535,21325,14987,21293,4453,2308,2275,6565,6501,2243,2146,2178,2210,2211,2275,2178,2211,8517,8485,6371,2178,2211,2210,2211,2211,2210,2210,2178,2211,2178,6437,12744,29712,33938,31825,8614,6437,18919,98,15085,42489,36117,25486,23308,23013,43815,43815,43783,46158,38099,27600,33938,27600,29745,31825,29712,29712,33938,35986,35987,33874,42227,50645,54839,59065,59065,59065,61210,56951,29547,14823,44141,54544,52431,50417,59164,52792,31694,50646,52791,56951,48338,56853,54871,33935,27467,10758,6533,12807,8645,27629,34000,33968,42355,59065,59098,59033,59097,59097,57017,59033,44307,48533,50646,42194,54872,52857,46387,42226,27565,25517,25517,21355,35985,27533,44405,40080,31727,48599,46452,46452,57083,61277,46388,27371,31531,27207,114},
{31891,31859,29811,29811,27731,27731,25683,23636,21588,21556,21588,23636,31925,31956,31892,29811,29811,29844,31957,36150,40311,42424,44537,44504,44504,42423,40311,38198,36150,34070,32023,34103,40344,38263,38263,36183,29975,25847,25815,23767,25847,21555,2472,391,359,359,359,327,327,2439,6632,10793,12873,8712,8680,12873,19179,12905,6600,6632,10792,12873,19179,27533,27533,21259,25420,17066,12873,12905,2374,2374,2406,261,4454,4487,2341,6567,10759,8646,4453,4421,8646,14919,10726,8646,8614,6534,6534,6534,8582,8647,8647,4453,17065,14984,21289,10759,8614,2308,8646,8614,8614,8646,2308,4453,2275,2276,4421,2308,2341,2308,2244,4389,8745,12906,17099,2340,2308,2340,4485,2275,2211,2178,2178,2210,2178,2210,2211,2178,98,2178,2178,98,98,98,98,2243,2276,2211,2178,2210,2178,4356,12744,27632,33939,33906,6469,12645,25127,131,23537,42489,31891,23341,25388,12612,23013,33382,33317,39983,40212,29712,36051,27599,29745,31761,25519,27599,31793,33906,44438,38132,44372,54839,56984,59065,59065,56984,61210,44273,19048,21129,37836,52464,50384,52628,59197,54904,50679,35953,38000,37934,37869,50546,31790,12904,10758,10790,8645,10694,21291,29775,33968,34000,48630,59098,59065,59033,59098,56952,46453,56984,50646,56952,54839,59032,56985,59065,54806,40145,23404,23436,23404,15048,29742,44436,42258,35887,42259,46518,46420,46387,54938,61244,59164,48534,38066,23307,52},
{31891,31891,29811,29811,29811,27731,25683,25684,23636,25716,27764,29877,31957,31924,31891,29811,29811,29812,29877,31990,36150,40311,42392,42424,42423,40343,38231,36150,34070,27862,29975,38296,40376,38263,36183,32023,29943,27895,25815,23767,25847,25847,8844,359,359,359,359,391,359,359,4552,8745,10793,10793,8712,6632,12905,8712,6632,8712,12873,12873,14953,21260,29646,25452,29646,10793,8680,10760,6599,6567,4486,2373,293,2406,2406,4486,8679,8679,6566,4453,10727,14919,12871,12839,10727,8647,6534,8614,8614,8647,10759,6566,10759,10823,15048,19145,10726,2340,10758,14919,14951,10726,6501,8614,6501,2308,2243,2243,2308,2308,2243,98,8713,25453,10727,227,2275,2340,4485,4388,2211,2178,2178,2210,2210,2178,2210,2178,2178,2146,2178,2178,2178,2146,98,2179,2276,2243,2210,2210,2178,4324,12744,25551,33939,31825,10662,20967,25159,2211,19311,42489,29744,23405,23308,8485,12645,27141,27240,40180,40212,31825,29712,33938,36019,35986,33873,31793,31825,40213,46519,36019,38099,33873,38034,40146,48566,48565,50645,52562,23209,17000,27370,52431,50352,56920,61309,50678,31725,21194,21128,21193,23274,29579,6597,4485,4420,2275,2275,6502,33905,31824,31920,36081,52758,54872,56920,59033,59065,52791,46485,48500,23340,50613,29679,50678,46485,50678,42226,31791,23404,23404,21323,10918,29774,42258,23307,33839,46485,42259,44307,50646,59164,57051,52824,33611,29384,27304,91},
{33972,31891,31891,29811,29811,27731,27731,27763,25684,29844,31925,31957,34005,31924,31891,29811,29811,27763,25716,23669,31958,38263,40311,40311,40311,40311,38231,34070,27862,25814,36183,42424,42424,38231,34103,27895,27895,23767,23767,25815,25847,25879,21522,392,392,359,359,359,359,391,2472,4584,8745,10793,14953,10792,8712,6600,6632,8680,10792,10793,10792,8680,12906,12905,12905,12873,8680,8712,8679,8647,6566,6566,6567,4486,4454,6567,10760,10759,8646,4421,8646,12839,14919,12839,8614,6534,4421,2276,4421,4389,4357,6566,8678,8710,6566,12839,8679,6501,4453,14919,14984,12839,6533,6501,10726,4420,2243,2275,2308,2308,6502,8648,19212,23437,17034,2340,2210,2275,4453,2243,2275,2275,2211,2210,2210,2275,2275,2211,2211,2178,2178,2178,2178,2178,6371,2243,4356,2276,2243,2210,2178,4324,12712,25519,33939,33938,23308,20999,25159,4291,2342,34102,27599,23340,14953,2211,2211,4291,10760,40278,33906,36051,40212,29680,35986,38099,38099,33938,33906,36019,38132,40212,35954,21261,33775,35855,42292,31694,33676,52497,25323,19081,21097,52399,50352,59131,61276,44338,16966,10564,27371,31695,17001,17097,6629,6565,4517,4420,2211,10760,25518,33905,31887,40242,56952,56952,56919,59065,59065,59032,59032,54839,54839,54806,48532,54806,48533,52725,42258,25485,23404,23404,19209,17192,38129,33742,12775,25453,48566,42226,44307,56953,59196,54938,44208,27142,31367,29255,118},
{33972,31924,31892,31891,29811,29811,27731,27763,29844,34005,34005,31956,31924,31892,31891,29811,29811,29812,25716,21589,29910,36151,36150,38198,38230,38231,38230,31990,27862,34103,40376,42456,42456,36183,32023,29942,27895,23767,23767,27895,27895,27927,38231,10859,392,392,359,359,359,391,2472,2504,4552,6632,12905,17066,12873,4519,4551,4519,8712,8744,8712,8712,6632,4519,4519,8712,8712,10824,8679,6599,8647,6567,6567,4486,2374,2341,6534,10727,8646,2341,4453,6566,10759,12871,8647,6501,4453,4421,2308,2244,2308,4421,8711,4485,2341,12871,14952,10759,10791,10759,14951,14951,8646,6501,8614,2275,2211,2276,2308,4454,33971,36051,31890,14953,8647,2308,2210,2211,4420,2243,2178,2275,2308,2243,2178,2211,2243,2178,2178,2178,2178,2178,2178,4259,6437,2243,8517,21163,8550,2243,2210,4324,12711,27600,33938,25519,29679,25225,25127,6339,4389,29777,27566,8615,8582,8419,6404,6502,10696,42390,44406,44438,44438,40245,40245,40212,40212,40180,38099,48632,42325,42293,38067,31825,33774,35920,44339,25257,16773,14758,12710,21097,21129,50318,50418,61277,54872,29644,21160,25355,35986,38099,25453,10790,10855,8742,2340,2307,6468,14953,25550,36017,31855,44436,59065,59065,56984,59065,56984,44307,54839,54839,54871,54839,56919,56919,59032,59032,44338,21323,23404,23404,12968,19306,42322,37967,12742,29680,44339,44307,50483,59099,61277,57018,46354,25029,27207,27206,101},
{34004,33972,31924,31892,29811,29811,27731,27763,29844,34005,34004,34004,31924,31924,31891,31891,29811,27763,25684,23636,29910,31990,31990,36118,36150,31990,29910,27830,27862,34103,38296,40344,40344,36183,29975,27894,25815,23767,23767,27894,27863,32055,44505,25585,359,2472,2472,2472,392,391,2472,2504,2439,6632,6632,8745,12873,4551,6599,6599,6632,10792,6632,4519,6599,6599,4519,8712,8712,6599,326,4486,4486,8647,6567,4454,293,4454,6599,10792,8679,2373,2340,4421,6566,8646,6534,6566,6502,2276,196,196,2341,6566,10791,6598,4453,12871,14952,10727,10759,12871,15016,10727,8614,10694,6501,2211,2211,2243,2276,6567,31858,23471,25519,14954,4356,2243,2211,2243,4356,2211,2178,2178,2275,2243,2211,2211,2243,2211,2178,2178,2178,2178,2178,2178,2179,4421,10728,10793,10728,8680,8647,8647,10728,15019,17132,14954,19179,19017,16904,8550,8583,23373,19179,14986,16969,10532,8517,31858,33906,40245,50744,50777,50777,50777,52825,52825,52858,48632,33971,54970,42293,42293,36019,48632,37936,35888,46452,31564,16773,14693,16871,35855,37967,48271,50613,63390,40144,12805,25352,37935,35921,38132,33905,29679,17065,6565,4323,2210,12840,23372,29743,33903,29710,50710,59065,56985,56952,59065,52726,23275,52759,29647,48532,25388,46419,40146,48598,56985,33839,21291,23404,21291,8774,23468,40209,35983,19081,19147,40114,44339,46387,52792,61244,54904,54838,29320,27174,29384,97},
{36084,34004,33972,31924,31892,29844,29811,29812,29844,31957,34005,34004,33972,31924,31892,31891,29811,27731,25683,23636,23669,27829,31957,31990,31990,27830,23702,23702,29942,32023,36183,32055,32023,34135,29975,23766,23767,23767,25814,27894,25815,32055,42424,38198,6633,2472,2472,2472,392,392,2472,392,391,2472,391,359,10793,12873,17066,17099,8680,4519,2439,4519,4519,4551,4519,6632,8712,294,261,2406,4486,4486,6599,2406,261,8680,14986,14953,6566,2341,4453,4421,10727,10759,6534,4421,4453,4421,8614,6501,2341,6501,8646,8678,10791,14984,12871,8614,19177,8678,8646,10759,10726,12807,8614,2275,2243,2211,2211,6502,23373,8680,12873,21292,6501,4388,2211,2275,4388,2275,2210,2178,2211,2308,2243,2243,2308,8615,8550,2243,2178,130,130,2178,6372,10630,12841,8647,8647,8680,8648,8647,8680,8647,6567,8647,8647,8648,8680,8680,8680,8648,8648,10760,10728,8615,8648,38165,46552,50777,48632,50712,48664,48632,48664,46551,48632,46551,42325,44438,38099,38131,36019,48632,44240,40113,44339,40048,27240,23112,33774,61178,56886,50547,61277,61276,33772,14917,23274,35790,40016,57051,42391,10760,6469,12870,6468,4356,19115,19146,29743,35952,38065,56952,59033,56984,59032,59065,52726,48500,54839,44307,52693,35887,50612,38033,52759,52758,25484,23404,23436,17161,6597,19274,33902,40240,38000,10695,31759,44339,44307,46453,57017,54871,61243,42064,27141,33512,116},
{36085,36084,34004,31924,31924,31892,31892,31892,31924,34005,36085,36085,34004,33972,31924,31891,29811,27731,27731,25716,25749,27829,29909,31958,29910,27830,23702,23702,32023,34103,29943,25814,27895,32055,27895,21687,23767,25815,27894,27894,27895,30007,38264,44537,21359,2472,4520,2439,2472,2472,2472,391,359,391,359,327,2439,12905,19147,14986,8712,6632,4519,4519,4519,2407,4519,2439,262,229,229,326,4519,4518,8679,12841,10760,8680,2406,4518,10791,2341,4453,4486,10727,12872,12807,8614,8614,4421,10695,6566,2340,2341,8646,6566,12871,14952,8679,12936,12903,10791,4421,6533,10791,12839,10758,8646,4388,2211,130,8648,33905,23373,23406,23372,6469,4420,4388,2307,2243,2275,2275,2211,2275,2308,2211,2275,2275,10728,19114,14726,8419,10532,8419,8419,16773,10598,12873,25517,23436,19211,17098,14985,12872,10759,10760,10792,10760,8647,10760,8680,8647,6599,6599,6567,6567,6567,8647,10761,21326,44438,46551,50745,48664,50745,50777,52858,54938,52857,48664,42325,38131,35986,33906,48599,40047,38000,46387,56853,60948,54674,54773,56952,52627,54840,61310,57018,29610,12805,27403,37870,40082,61277,44569,6534,4388,12838,10725,8581,2210,4388,29710,42225,46355,46419,48500,48500,50580,50580,50613,52693,52693,54806,50612,54806,52692,54806,54806,44338,21291,17065,10727,6565,259,21291,42288,40240,42290,14921,21227,46420,44307,44339,44306,56950,61211,54807,27174,29287,118},
{38165,36085,36052,34004,31924,31924,31892,31924,31924,36085,36117,36117,36085,34004,33972,31891,29811,27731,27731,27796,29877,29909,31990,34070,29910,25782,23702,21654,25782,29975,25814,23734,23734,27895,23734,23735,23735,25814,27894,27895,27927,32055,34136,40376,36084,4552,4520,2472,4520,4552,2472,391,359,327,327,327,327,2472,10825,10792,6632,4552,6632,2407,2439,4519,2439,2406,294,294,262,4487,4518,6599,6599,10760,10760,6599,293,2341,4454,4486,2341,4421,8646,12839,12839,8614,8614,6502,4421,4389,2276,2341,6565,2276,6501,21257,31758,21322,10823,10823,8678,6533,10758,8613,10790,12871,10726,2275,2275,4486,33938,44406,44471,31759,6501,4420,6533,2372,2243,2211,2243,2211,2308,2340,2340,2372,2275,10728,21227,20967,18821,18821,16741,12548,20902,12841,10760,25581,25516,17130,23468,23435,23435,23468,23436,21355,19242,15049,13001,13001,12969,10889,8776,6664,6663,6664,2470,12971,27599,40180,38034,36019,33938,38067,40179,40180,40245,44438,54938,54938,42325,38099,38132,44340,29581,33774,50547,58836,58868,54675,56821,56952,50515,57051,61277,54872,40111,23303,33708,37837,46453,61277,46747,14954,12775,21159,10693,6468,4388,6501,29710,35919,42160,42161,40048,42096,42096,42096,42128,40048,35790,21162,14856,14856,14888,16969,16968,12775,6469,4323,4389,4388,227,21291,40207,38127,46484,27468,10728,40114,44339,44307,48434,56918,56985,57018,37707,27174,126},
{38197,36117,36084,34004,34004,34004,31924,31924,34004,36085,38197,38197,38165,36084,34004,31891,29811,27731,27731,27764,29876,31957,34070,31990,25782,23701,21654,21654,25814,32023,27862,21654,21654,21686,21686,21686,23735,23767,25815,25847,30007,29975,34135,40376,44504,19245,2472,4552,4552,2472,424,359,391,359,327,359,359,359,423,10825,10793,10792,8744,8712,6632,6632,4519,4551,6599,6599,4519,8712,8712,8647,6566,4486,2373,2406,2406,2373,228,2406,2341,2341,6534,10759,10759,8614,10727,8614,4421,4356,4324,4421,6533,4420,2308,21322,35918,25483,17096,12871,8678,4420,6533,15048,19240,14983,12903,8710,2308,4421,25486,29679,31824,29647,14953,8645,4485,2372,2210,2211,2275,2308,2340,2275,2436,4549,2275,4356,19082,23080,18821,20901,16741,10500,14660,10728,12873,23404,17129,17162,19210,23435,21355,21355,23435,23435,21323,21355,19242,12969,12937,10856,4616,6664,4648,4583,326,4519,27632,42325,42358,50712,46584,48632,48632,48632,46551,42325,48632,50712,48631,33841,35987,40114,29614,29613,46256,56722,58835,52562,56886,56952,52627,61310,61309,52791,40146,33739,37837,37838,52825,57149,44635,31858,44209,39882,8580,12774,6436,10759,21259,10660,50445,40045,31594,50511,31627,42092,31691,25321,8549,12709,8517,10597,6436,8517,4291,98,2178,2211,14888,12807,4420,23371,29645,29677,48532,38000,10695,27566,46420,48533,54903,54871,48598,54970,50515,29319,127},
{38198,38165,36085,36084,34004,34004,33972,31924,34004,36117,38198,38198,38165,36085,34004,31924,29843,27731,27731,27763,27796,31957,31958,25781,21621,21621,21622,25782,29943,27862,23734,21654,21654,21686,21686,21686,23735,23767,23767,25815,32055,29975,34103,42424,44537,42358,8713,6600,6632,6632,2504,392,359,359,359,391,359,391,423,2439,10825,10792,8712,6632,6632,4551,6567,6599,6599,6599,2438,4519,4487,4518,6566,4486,4454,4454,4454,8647,6566,2309,4421,4454,8647,8646,10759,10695,12840,10727,6501,4357,4389,4421,2308,6566,4421,14952,38031,29612,21322,19209,17128,12935,6533,17127,21320,10855,15048,10823,2243,2309,25518,31792,33839,36019,21260,10694,2340,2243,2210,2178,2211,2276,2372,2340,2404,4517,2307,163,10728,23210,21097,19017,16838,10565,10598,10728,14954,23436,21355,23500,23468,23500,23468,23435,27661,25549,23436,21355,17130,17130,12969,8744,8711,4551,6664,4583,2503,358,13003,31825,33906,38132,46519,42325,46519,50712,50745,42357,54906,48599,48599,40180,42325,42194,38033,42226,48401,54642,54642,52562,56952,54806,48435,48664,36018,17066,21227,35822,37805,37935,57051,54970,40409,36019,52562,33707,6468,8581,8613,21258,17000,19013,56784,23240,35752,40012,23175,25319,14852,19013,6403,18981,6371,16901,6371,14756,6371,2146,2178,4356,17001,12808,10791,21259,17065,21290,46418,42128,14921,19147,46452,29613,38032,61211,56985,52857,54872,33513,122},
{40278,38197,36117,36085,36085,34036,34004,34004,34004,36117,40278,40278,38197,36117,34004,33972,31891,29811,27731,27731,27764,27797,23669,19573,19573,19573,19574,21654,23734,21654,21654,21654,21686,21686,21686,21687,21687,23767,23767,23767,27927,32055,34135,42424,44504,46617,21326,4520,8681,6633,4552,392,359,327,359,391,359,359,391,326,6600,10825,6632,4519,6567,10760,8680,8712,8680,8744,6632,8712,6599,4519,4518,6599,8647,6534,4454,6534,10792,2373,4454,8679,8647,8647,10727,12840,10727,8614,4453,8614,6501,4356,2276,8646,6501,6534,19145,21226,19210,29644,17161,12935,12903,14983,15047,10790,12903,8646,2243,195,27632,48664,46486,36018,17066,4421,2308,2243,2211,2210,2210,2210,2275,2308,2308,2340,4421,17034,14954,25323,23210,19049,6469,2308,6502,14954,10760,12873,12905,12938,15018,17098,19211,17130,15017,17098,15017,15049,15049,15049,13001,13002,6664,2470,6696,2503,422,423,293,130,2309,8648,29712,29680,35822,46420,46518,40245,46552,46551,48664,50778,54938,40179,40179,44274,52562,56755,52529,54675,59032,54544,25388,29614,19081,8582,19147,42063,39917,37969,57051,46518,40343,31825,50481,14920,8647,8647,6534,23372,16968,31560,50478,14789,31527,14789,21062,14821,18981,14788,8515,14821,6403,16869,4291,14820,4258,2146,2178,6437,23308,21259,21259,23371,19178,23403,44241,44177,19180,12840,44274,31530,23339,44437,57018,54904,44306,33480,114},
{40278,38197,36117,36085,36085,36085,36085,34004,34004,36117,40278,40278,40246,38165,34004,33972,31924,29811,27731,27731,25683,23636,21589,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21686,21687,23735,23767,23767,23767,25815,27895,34103,42424,44504,46617,38165,6633,6600,8713,2472,392,392,327,359,391,327,359,391,294,294,4519,4551,4519,8712,8680,4455,2374,2406,2406,326,294,261,2374,4486,6567,6534,6566,4422,228,8711,8711,6567,10727,10727,12808,10727,10727,10727,4389,4389,4388,4421,4356,2244,4421,4389,12871,10823,19145,25482,29678,25579,21321,14983,12903,12871,8678,19208,10790,2243,131,8583,21325,29712,27567,21324,8645,6501,4356,2243,2243,2211,2210,2210,2308,2308,4420,4388,27305,31433,33448,33416,25127,4421,4421,2341,19179,12873,14986,10792,10760,10760,8647,6567,6567,6567,6535,4486,6535,6535,4487,6567,6599,6567,6599,6599,6567,4519,4487,2374,2276,4389,261,17067,33840,35757,40113,40212,21195,21196,38001,21227,17067,29582,33808,29646,42194,56690,58836,54642,54741,60916,58639,27534,31760,31628,23307,23307,35822,35855,44406,57018,48599,38262,48467,48401,17033,12840,14953,12840,23404,21095,35720,25287,16837,21062,10596,21061,8483,18949,8483,14756,10563,10563,12644,6371,12708,98,2146,2178,6437,14920,14951,10790,6533,4517,19146,29483,33874,27632,19082,48368,52463,16903,17002,52824,52824,52693,50351,126},
{40278,38197,36117,36085,36085,36085,36117,36085,34004,36117,40310,42359,40278,38197,36085,34004,33972,31891,27731,27731,27731,23636,19541,19573,19573,19574,19574,21622,21654,21654,21654,21654,21654,21686,21686,21687,23735,23767,23767,23767,23767,25847,34136,42424,44504,46585,46617,29746,6632,8745,2504,391,392,359,359,359,327,359,359,327,359,2439,4551,2471,2374,262,262,229,229,229,261,326,293,293,294,8647,8679,6534,2341,229,2341,10792,8679,10759,10727,8647,8647,10727,10727,6534,6534,4421,2308,2276,2211,2244,2308,10727,19145,31756,38062,17033,27627,29739,23401,14983,17064,10758,17064,4453,2340,4388,130,98,4389,2341,10793,8645,4420,2308,2243,2211,2210,2243,4323,2275,2308,2372,2243,10564,12709,12645,14823,25387,21260,8679,27567,17067,10728,10825,12905,12905,12937,10792,8679,10759,8679,8647,6599,6567,6567,4518,4519,2406,2406,2374,2406,2406,2374,2374,2374,4454,2341,2276,12841,33840,37870,40146,27567,4356,14857,46388,23308,21260,21194,21194,19081,42128,58770,58836,54675,56886,58803,60752,29549,29647,29451,14888,25420,37968,42063,54807,54905,50646,46387,65043,42160,19179,19081,17033,17034,19113,18949,21061,8484,18982,12676,12708,14788,10596,18916,6403,18916,6403,14756,8451,10563,10563,98,2178,2178,4356,12839,15015,6500,2243,2275,12807,14823,19344,33937,33741,62963,56689,23177,33644,54642,44372,50580,58672,180},
{40278,38197,36117,36084,36052,34004,36085,36085,34004,36117,40310,42391,40278,38198,36117,34004,34004,33972,29843,29811,27763,23668,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,21654,21686,21686,21686,23734,23767,23767,23767,23767,25847,36184,42456,44504,46585,46585,44537,31826,10793,4552,392,392,391,391,391,359,359,359,391,391,6632,2439,294,2374,2407,2439,294,326,326,4487,4519,293,261,2374,10792,12872,6599,4454,229,196,2406,8711,12872,12872,10759,6534,10694,12839,10727,8614,6501,2276,2276,2243,2244,4421,8582,8614,25451,21259,10695,23370,29707,27594,21257,25481,25513,29739,10758,4388,2243,2211,2179,2276,2308,4421,6566,4420,2275,2243,2211,2210,2211,6469,2275,2275,2308,2243,2243,163,163,358,27599,31825,23406,31825,21293,10760,8647,6534,4454,4454,4454,4422,2374,2374,2374,2373,2374,2373,2373,2373,2373,2374,2341,2374,2373,261,2309,2309,2309,2244,2243,10728,31694,37968,31760,14922,8550,25421,50549,27502,23373,21194,21194,21194,39982,56722,56723,50449,54839,54675,62832,40016,35953,31727,23276,27501,44176,54675,56723,52726,54741,60948,63061,35919,23372,23209,12807,17033,10629,8484,10596,6469,10629,4323,10596,6403,6435,8483,4291,12644,4291,10628,4258,10564,6370,98,2146,2178,6469,12872,6597,2275,2211,4355,10597,10631,13004,38162,42160,33643,25322,31694,54544,54512,27304,44143,56559,221},
{40278,40245,36117,36084,34004,34004,34004,34004,34004,36117,40311,42391,40310,40278,38197,36117,36052,34004,31892,29843,29812,25716,21621,19541,19541,19573,19574,19574,21654,21654,21654,21654,21654,21686,21686,21686,23735,23767,23767,23767,23767,25815,29975,38296,44504,46585,46617,44537,50778,35986,8712,392,392,391,424,391,2472,4552,2471,2471,4552,4519,4519,4519,4519,2406,2407,4487,6599,4487,4454,2406,293,2374,2374,8679,6599,2374,8679,4454,261,261,8679,10759,12840,12872,10727,8614,10694,12807,8646,6501,4453,4389,2308,4421,10727,8614,8582,10759,8646,2340,12904,25578,27594,25482,25481,31787,21353,6500,2179,2211,2243,2211,2178,2211,2276,8615,4453,2243,2243,2243,2178,2178,4324,4356,2275,2243,2243,2275,2243,2178,2341,36051,33906,27632,17099,17034,10760,25549,19243,19243,17130,15017,10791,8711,6631,6599,2405,325,2438,2406,2373,261,261,293,2309,2341,2309,2276,2244,2276,2211,2276,6502,29581,46453,33840,14987,12907,38099,46355,17034,17034,19147,21227,21194,33676,48336,46223,39950,29614,37804,60818,44307,31760,29647,33840,31726,50514,54609,52366,44209,50678,52627,58966,31726,29646,19081,10759,25420,14791,10629,10597,10630,8517,8516,6404,6436,4356,4324,4323,4323,2243,4291,4389,6469,2178,2178,2146,2178,4421,10792,6534,6469,4420,4388,8549,8713,10891,38162,33936,6534,27600,46518,56920,54806,31563,44012,54446,220},
{40278,40245,38165,36084,34004,33972,34004,34004,34004,36117,40310,42391,42359,40278,38198,38165,36085,36084,33972,31892,29844,25716,23669,19573,19541,19574,19574,21622,21654,21654,21654,21654,21654,21686,21687,21687,23735,23767,23767,23767,23767,25815,27895,38296,44504,44537,46617,44537,48697,50778,23373,391,392,424,2472,2472,6632,2472,391,6632,8712,8712,10793,10793,6599,4551,6632,4519,6599,4519,4519,326,326,2439,6599,10760,8711,8679,8711,8711,2373,229,2341,6599,8679,12839,8647,8646,6533,10726,12871,8646,8678,8614,6501,8646,10727,6469,4356,2308,4389,2340,8678,25514,27594,19144,27530,27594,19208,8678,4453,2276,2243,2211,2179,2178,2211,4421,4388,2211,2243,2243,2210,2210,2210,2178,2243,2210,2178,2243,2276,4389,8615,19278,23438,21325,12874,14954,14986,17066,14986,19147,17066,19179,19179,19146,14985,12905,12872,8744,10857,8744,6599,4486,4454,2373,2373,2406,2309,130,98,98,130,2211,2276,33841,52825,35985,17100,13038,48599,40081,10760,8680,19114,21194,23242,16968,10630,16969,10662,27337,52399,50580,42227,31727,27567,27534,33807,52562,40080,46158,40048,48598,38066,42292,23340,33839,8614,12840,21259,14823,16903,12710,12710,10695,10565,4324,8517,6436,4356,4356,4323,6437,6437,6436,8582,2211,2146,2146,2178,4357,10792,12840,10727,8614,6501,8550,8746,12938,38129,31823,12906,44471,38099,55003,57051,48500,48238,48206,173},
{42358,40246,38165,34004,34004,33972,34004,34004,36085,38165,40278,40311,42391,42358,40278,38197,36117,36085,34004,31892,29844,25716,23669,19573,19541,19573,19574,21622,21654,21654,21654,21654,21654,21686,21686,21687,23734,23767,23767,23767,23767,25847,34136,42457,42456,46585,46617,44505,48665,50778,38164,4552,392,392,359,2472,4584,2472,4552,12905,14953,12905,17066,17066,12873,6632,8712,10792,10792,10792,10792,4519,2439,358,2438,8679,10760,6599,6566,10824,6566,2373,2341,6567,8679,8614,8647,8646,4421,8582,10759,12807,10759,8646,4389,4389,6501,2276,2243,2243,2276,4389,6566,27627,29610,21256,17128,17095,12903,6565,2276,2243,2243,2211,2211,2243,2211,2243,2275,2210,2275,2243,2178,2178,2211,2178,2211,4388,2210,2211,2243,14954,17034,6861,2733,4846,4781,4846,2733,4781,6861,6861,4716,4650,6731,6763,8843,15051,13003,12939,12939,15019,14986,17067,14986,17034,14986,14953,4422,2276,2211,2179,2211,2276,6534,23373,48632,35887,14987,21457,48598,27435,16935,12775,19147,23242,19016,14920,10630,10630,8549,39852,60884,50581,40113,27501,21227,19114,29548,27499,25453,35855,46419,52759,29614,29614,25453,31726,4388,10759,17033,14888,16903,12742,14822,10630,10629,6436,8484,10662,10630,8484,4324,6469,6501,4324,4324,4291,2178,2211,2178,4291,10760,10695,10695,10695,8549,8583,6730,17066,38161,25484,10727,36019,33938,52890,54971,48500,52398,41964,155},
{42358,40246,36117,34004,33972,33972,34004,36084,36117,38197,38230,40310,42391,42391,40310,38230,36117,36084,34004,31892,29844,25716,23669,19573,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21687,23735,23767,23767,23767,23767,25847,36216,38296,42424,46585,46617,44505,46617,48698,46584,15019,392,392,359,391,2504,4552,6665,21260,14953,17034,19147,17066,14953,14953,12905,14953,14953,14953,17066,8680,326,358,2439,4519,4519,6631,4518,8744,8744,4486,261,2373,6599,8614,8647,8647,4421,4421,6501,8646,6534,4421,2244,4389,2308,2308,2276,2243,2243,2243,4421,29740,35884,19208,17095,19144,12838,4453,2211,2211,2243,4324,2243,10565,10597,2308,2276,2243,2243,2243,2210,2178,2243,2211,2178,4420,2307,4355,2211,17067,12840,6829,2798,2733,2766,6959,6960,2831,2798,718,686,653,685,750,686,2766,2831,718,588,555,620,2668,2635,4684,2635,4683,2570,2538,2505,2472,10760,6534,4389,14922,48632,46354,44273,48531,46485,21162,27368,25288,17034,21162,16968,16969,4356,8581,8582,33644,60981,40114,33905,29581,21129,14790,19049,23340,19082,31759,35920,46420,44274,31727,29614,25420,4420,19178,21258,17033,18983,12775,16903,10630,12710,10629,8517,12775,14920,10597,14921,8517,4323,4356,6534,6469,2211,2211,2178,2178,8582,12808,10695,8614,8517,6601,6730,19048,35952,25583,4421,21325,36018,46584,50744,46256,46224,48434,173},
{42358,40246,36117,34004,34004,34004,36084,36085,36085,38197,38230,40310,42391,42391,42359,40278,38165,36085,34004,31924,29844,25716,21589,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21687,21687,21687,23767,23767,23767,25815,25847,34136,36216,42424,46585,46585,44505,46617,48697,46617,25585,2472,424,359,359,424,4552,4552,12938,8712,14954,14953,17034,10793,17066,14953,10792,8712,8712,6599,4486,294,326,4519,8679,326,4519,6599,8712,10792,8711,4518,2406,6534,12807,8614,6566,8614,4421,6534,6501,4356,2308,4421,8614,6501,4453,4389,2276,2244,2243,2308,27595,35916,15047,21288,29642,14983,10790,6565,2275,163,10695,21032,27273,23144,4421,2243,2243,2211,2243,2276,2211,2211,2275,2211,2275,4420,6468,2276,21260,8615,6731,2603,2570,2602,6731,4650,2570,2537,6731,4585,2570,2602,4650,2603,2570,4716,4781,2700,587,555,2539,2603,523,523,588,555,491,458,457,6599,4422,163,17002,42292,46354,50613,46386,33840,16968,27369,21128,14888,21161,23209,16968,8549,4356,2276,27436,61046,52693,44372,29581,27338,23112,31726,38001,50581,27501,23308,44275,44307,23372,31759,19049,4453,23372,27565,23307,18984,10597,12743,14855,12775,14823,6469,12775,14888,10629,12808,8549,6404,4356,6501,6437,4323,2243,2211,4291,6469,12840,10727,8582,8517,4618,10825,12710,12775,12971,2243,10727,31760,29712,35986,52726,44274,46419,146},
{40310,38197,36084,34004,34004,36052,36084,36084,36084,38165,38230,40310,42391,42391,40310,40278,38165,36117,34005,31924,27796,25716,21589,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21686,23735,23767,23767,23767,23767,27895,34136,36216,40376,44537,46617,42457,42457,48697,42457,31989,6665,2472,392,359,391,391,4552,6632,8712,8712,14953,17034,17034,14986,12873,10792,4519,2439,4519,326,261,261,2374,4519,2406,6599,10792,8711,8711,8711,6599,4518,6599,12807,10727,8614,8614,8614,10759,4453,163,2243,4421,8646,8646,8614,6501,4388,2308,2308,4389,23337,35947,17095,25481,35916,19208,12871,12871,2308,163,8582,21064,25355,14856,2340,2275,2243,2243,2243,2243,2243,6469,6468,4388,2340,6533,4420,2276,17099,10760,8909,2766,750,718,2799,4879,4846,4846,2733,653,620,2668,2667,4748,2602,2602,2570,2602,2602,4585,2505,4552,2537,4585,4553,4585,4553,2439,2472,6600,6534,163,19148,40211,48499,42259,33872,38066,19179,16969,10728,21128,23176,21063,16902,12710,8680,6502,31629,63126,54774,46420,42128,33611,29418,35887,39981,42094,29515,40146,56920,46485,25420,35920,10662,2243,8615,33871,27533,19048,14855,14855,16936,10662,16935,10630,14790,8582,10630,10630,6437,10597,4356,6469,4324,6437,4356,4421,4356,6501,14921,12840,8582,8615,4650,10759,6403,2211,2276,2146,4389,29680,21194,33840,54839,52792,48501,142},
{40278,38197,36084,36052,36084,36117,36085,36052,36052,36117,38198,40278,40311,42359,40310,38230,38198,36085,34005,31924,27796,25716,21589,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21686,23735,23767,23767,23767,23767,25847,27895,30007,38264,44537,46617,38296,34136,40377,34136,40377,21326,2439,2472,392,359,359,392,8713,6632,358,8680,19147,17034,17034,14985,6567,6599,4519,2406,326,229,229,261,294,326,2406,8711,6599,10792,6599,6599,4518,8679,12840,8647,6534,4454,6502,8646,6501,2244,2276,8614,10759,8614,6533,4389,4389,6534,6566,2308,14952,33835,23336,33803,35916,14951,8678,8645,2243,163,10728,8582,4389,2275,2275,2308,2243,2210,2178,2211,2243,6469,12774,8613,4453,4453,8613,8614,14986,12841,8811,6828,6829,4749,4749,4781,2701,4814,621,653,621,588,653,652,621,588,653,621,588,2701,458,523,2701,620,555,490,490,2602,457,6567,6534,2244,12906,38001,46321,44274,46419,38034,21260,17001,10727,12678,10597,10565,8484,8484,6503,29451,56690,58933,54806,52759,37902,27337,31563,37934,42061,41997,27402,29647,50613,46485,35952,33872,6437,98,10760,33806,25484,19081,19016,19016,19016,10662,18984,14823,12742,14823,8549,12742,6437,10662,6436,8517,4356,6437,4291,2243,2211,4259,10727,12840,10695,6600,8777,10662,4291,2210,2178,2178,6534,10727,23275,40048,50679,54938,59164,176},
{40278,38165,36084,36084,36085,38197,36117,34004,34004,36117,38197,38230,40278,40310,40278,38230,38165,34037,34005,31957,29844,25717,21621,21621,19573,19573,19574,19574,21654,21654,21654,21654,21654,21686,21686,21686,21687,23735,23767,23767,23767,23767,25847,27895,36216,42457,44537,32088,27895,27927,27927,42489,36019,2472,424,392,392,391,392,4552,10825,17034,14986,12874,19147,19179,17034,12840,10760,10760,4486,2406,326,261,261,229,229,261,4519,8711,10792,2406,2341,6567,8646,8647,8647,10727,4421,2341,8646,12839,6501,2340,8614,10791,8646,6534,4389,4389,8614,10727,10695,17001,31755,23337,40076,33835,12903,4421,4356,2211,4357,12841,6567,4421,4356,2275,2211,2243,2243,2178,2211,2211,4356,10694,10726,4517,2372,4452,10727,14987,29647,23373,19147,19179,21228,21260,21260,21292,21293,21293,21293,19245,19245,17165,17165,15084,13004,13037,10957,8844,6731,8876,4683,4651,2570,2603,4715,523,457,393,294,4421,2276,15019,46256,58607,58672,52661,46322,25420,8550,10728,14856,10598,12678,10565,6339,8452,50254,58835,58933,54741,52759,44306,29482,31596,35920,42062,44109,29450,12841,44274,40145,33937,31726,12776,131,14986,46452,27533,14888,19048,19016,19016,14855,14855,19049,17001,16936,12808,16903,8549,10630,10662,8550,12743,16969,6404,2178,2211,2211,6469,10728,10663,8746,15018,12775,2210,2178,2146,2211,6567,4388,8516,33709,44373,48566,35920,116},
{40278,38165,36085,36052,36085,36117,36052,34004,34004,36085,38165,38197,38230,38230,38230,38198,36117,34005,31925,29876,27797,25717,21621,21621,19573,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21687,21687,23735,23767,23767,23767,25815,25847,25847,34136,42424,42457,30008,25847,25847,29975,40376,42391,8745,392,392,392,391,392,2472,8712,10825,17066,17034,17067,25420,23340,19146,14921,17033,14921,8647,2406,293,229,229,229,261,4519,10792,10824,6631,2406,4454,6566,8647,12840,10759,6534,2373,8614,10759,8614,6534,6501,10759,10791,8646,4453,2276,2243,2244,4356,6534,23402,17064,38061,35948,12870,2243,2211,2211,2308,10760,8614,4421,2243,2211,2211,2211,2275,2243,2211,2178,4356,8581,2211,2372,2405,2404,10793,29679,19115,12808,10695,10728,10728,10728,10728,10760,12808,12840,12841,14953,17034,17066,19115,19179,21260,23340,25421,25453,25485,27534,27534,27534,27534,25454,25454,23406,21293,19180,19179,19114,6469,8712,35822,46126,46191,50516,48468,27468,8517,12873,21227,29647,29614,29647,23341,31596,56559,58901,56886,37935,29548,33774,35855,40114,40146,37902,33675,29482,14888,35952,42226,33872,25452,25452,2276,23406,46452,14888,6501,6502,8550,8582,12775,10662,19081,14921,18984,23307,16968,17001,14888,14888,14921,12775,25485,10597,2243,2243,2211,14790,21128,19016,17034,19146,21161,10564,6371,4290,4291,6502,4356,8614,33709,31530,29482,25224,48},
{40278,38197,38165,36084,36084,36084,33972,33972,33972,36052,36117,38197,38198,38230,38198,38198,38198,34005,31924,29844,27764,23669,21589,19573,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21687,23735,23735,23767,23767,23767,23767,25815,25847,27927,38296,40344,32055,32055,34135,38296,42424,44536,23406,4520,424,424,391,392,6697,12906,8681,4519,2407,6567,10760,19147,25420,17034,14953,19114,14921,6567,4486,293,261,229,293,8680,10792,6631,8679,8711,4454,4454,6566,6534,8647,8679,4454,8614,8614,10759,12839,6534,6501,6534,8678,4388,2211,2179,2211,4389,6566,12904,14984,29642,23337,21192,6468,2211,4388,4388,8615,6501,2308,2243,2243,2211,2211,2211,2275,2243,2211,2243,4388,2210,2307,4517,2372,10728,29680,25453,25617,19441,23537,23537,23536,23504,23504,27632,25551,25486,21293,21260,21260,19180,17034,17034,14954,14921,14889,12841,12841,12840,12808,12808,12841,12841,12841,12840,12841,14954,17034,6534,2374,4454,8712,12873,44340,46420,37903,18984,19148,19115,27567,27534,29679,25454,31629,56657,58933,50547,27468,27499,21161,35953,38099,38066,35855,19048,4356,10760,31629,33741,35952,33773,27566,4389,25519,48533,19114,4389,4421,4389,4389,10727,14888,21129,14856,16903,16968,12742,16968,10662,12742,6469,10630,17034,10662,4324,2276,4324,46255,39850,37770,25224,23176,25256,27304,25256,25191,25191,23143,23142,31661,40145,31562,23209,14855,130},
{40278,38197,38165,36117,36084,36052,33972,33971,33971,34004,36117,38197,38198,38198,38230,38230,38198,34037,31925,29876,27796,23669,21621,19573,19541,19573,19574,19574,21622,21654,21654,21654,21686,21686,21686,21687,21687,23767,23767,23767,23767,23767,25815,25847,27927,36184,38264,40376,42424,42424,44504,44504,46585,44439,14987,4552,2472,2472,391,4585,19245,23373,19179,19147,14954,8680,4487,10761,19179,19146,19146,21259,10760,8679,326,261,261,261,2406,10792,10760,6566,8679,6534,4421,6566,6566,8614,8647,6534,6566,8646,8646,12839,12840,4421,2308,6533,6501,2276,4421,4421,6501,4453,10759,21289,17096,4421,10726,8613,4388,6469,2243,10696,23210,17001,6469,2243,2211,2179,2178,2243,2276,2243,2308,10727,4356,2308,4517,8677,8679,25486,23373,27861,21751,21751,19638,25911,27991,25911,27992,21750,21718,19605,21685,25813,34167,27893,32054,29909,25748,23667,25682,31924,25617,25617,25584,23471,23438,25551,17164,15019,17099,8648,2308,2308,8647,8746,12874,42194,48467,50450,31564,19180,14953,29614,31727,33840,31760,25421,52562,61045,50481,23274,27500,42292,48534,33873,33840,44372,35788,29450,27402,29483,35887,42226,48401,21226,6502,36018,46484,25420,8582,8582,8614,8582,10695,21259,23242,25388,23307,19048,10630,16936,17001,16903,14856,14855,8582,8582,6437,130,12775,52592,37802,39850,25354,17099,21260,23373,23340,16969,23274,27435,25355,35953,42324,33675,29581,14954,119},
{40278,38197,38197,36117,36117,36052,33972,33971,33971,34004,36117,38165,38197,38230,40310,40310,38230,36118,34005,31925,29845,27797,23669,21621,19573,19573,19574,19574,21622,21654,21654,21654,21686,21686,21686,21687,21687,23735,23767,23767,23767,23767,25847,25847,29975,38264,40344,46585,46585,44504,46585,46617,48665,50778,40212,8745,2472,6632,4552,4520,8745,21260,17067,12873,12873,17099,17034,8680,6599,14985,17066,21227,12872,10792,2438,293,293,293,261,6599,10760,8679,8679,6566,6534,8647,8679,8647,4454,2309,4421,10759,10727,14952,14952,8582,4388,2308,6501,6501,12839,10727,10694,6501,10759,21257,21224,8678,4420,10726,14886,6533,2308,8549,16871,4422,6502,2275,2211,2243,2211,2211,2211,2211,4356,4453,2243,2243,2372,6565,4356,23341,14986,25748,23700,15346,21620,27926,27959,25879,19605,27959,23831,19638,23831,27959,27959,25911,28024,30105,27992,21718,19540,27927,21653,21620,17460,17427,17459,17394,11055,11055,6797,2440,2243,2211,8583,12808,14954,23307,31661,23242,23307,14986,8647,19115,21195,25421,25453,21260,46288,50416,40048,31694,33775,50777,50712,35920,40179,44274,48335,50415,50447,44141,40015,56854,56788,25320,6500,25485,40178,29614,19146,14921,8614,6502,8582,19146,25387,23274,21162,21129,23307,21129,23340,19049,19114,21227,12742,6534,8549,2211,31661,42091,33641,37770,33675,23373,23406,21293,23341,21259,21259,25420,27533,44373,44405,35854,31661,12841,49},
{40278,38197,38197,38165,36117,36084,33972,33971,33971,34004,36084,36117,38165,38230,40343,42391,40311,36150,34037,34005,31957,29877,23669,21621,19573,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21687,21687,23735,23767,23767,23767,23767,25847,32055,42424,46585,48697,48697,46617,42456,46617,50810,48698,46617,50778,29712,6632,6632,6632,6632,6632,17099,31792,25453,19147,10760,8680,6599,6599,8712,14985,17065,14953,8679,4551,326,293,326,293,4486,8679,6599,12872,6566,2373,6534,10760,10727,6534,2341,4389,14920,12839,12840,10759,10727,12839,8646,6566,6501,10694,10726,10694,8646,12839,17032,17064,8646,6533,12871,8549,4291,2211,98,4389,14954,6534,2243,2211,2243,2243,2178,2211,2308,2243,4453,2340,2243,2308,4420,4388,27567,19180,23667,27796,21522,23635,23602,27763,25682,23569,27730,27730,23537,29811,27763,27730,29843,23602,25683,27796,21555,23603,23635,23635,23700,21555,19507,21555,19148,2178,4292,2244,2211,2211,2178,10695,12939,6567,2243,130,130,4422,4454,131,98,130,2179,2211,4324,10695,10630,17001,42194,42161,48664,52825,37968,46355,42095,48335,48367,37836,33643,27402,48631,52759,23209,10725,19211,33840,31727,29679,14985,14856,14823,14791,21194,29613,23209,16968,21129,25388,21129,19114,19146,16936,17034,12743,8582,10662,6469,50514,40044,35851,39850,35723,19114,14953,12841,10760,14888,16968,16968,27598,44437,42324,38000,23242,14953,46},
{40278,40245,38165,38165,36117,36084,34004,33971,33971,33971,34004,36084,36117,38198,42391,42423,40311,38198,36118,34037,31957,29877,29877,23669,21621,19573,19574,19574,19574,21654,21654,21654,21654,21686,21686,21687,21687,23735,23767,23767,23767,25815,27927,38296,46585,48665,50778,50778,48665,42424,46617,50810,50778,46617,46617,44471,23341,10825,6632,8713,10793,8712,14986,19179,23340,19147,19147,14921,12841,10760,12905,17097,17066,12873,8679,2471,326,326,326,261,2438,6599,4519,6566,2341,2341,6534,6566,4453,4454,260,8646,17032,6534,4421,8614,8646,10759,4421,4388,6533,8646,8614,8614,12872,17064,14984,2276,2243,2243,2211,2179,2179,2179,2211,4389,2308,2178,2211,2276,2211,2178,2275,2276,2243,2275,2243,2243,260,6597,8646,23405,10794,23799,30072,21783,23831,30105,25976,30105,30105,32185,27959,23830,30072,27959,27926,32087,27861,21652,25813,29909,23602,19409,21457,25650,27730,21456,21456,25453,2178,4259,4259,4259,4259,2178,10695,12872,2308,2243,8517,6437,6469,2341,2243,2178,98,98,130,98,98,66,12743,46355,35888,46518,50712,25487,42128,40048,44207,50415,23144,10629,14823,40179,52759,25289,12837,17032,21227,31759,29646,14952,21194,25289,23241,25290,19114,21161,21194,21129,23242,17001,19081,25485,16968,10695,10662,21227,17001,14855,42093,29642,44337,41996,37802,14822,4421,6534,4389,6469,18983,16903,38066,44373,42292,38066,29483,27369,125},
{40278,40246,38197,38165,36117,36084,34004,33971,33971,33971,33972,34004,36085,38198,40311,42391,40311,38230,36150,34038,29909,29877,29909,25749,21621,19573,19574,19574,19574,21622,21654,21654,21654,21686,21686,21687,21687,23735,23767,23767,23767,25847,29975,38296,46617,48665,48697,48697,46617,44537,44537,48665,46617,44504,44504,44504,36051,17066,12906,6632,12905,10825,8712,10760,17066,21227,19147,12841,10760,12905,14985,12937,17097,19210,12872,4551,2406,326,2406,293,2374,4518,6599,4518,2405,2373,4486,8679,6534,6534,2341,8646,12871,4389,4421,10727,6501,6534,8614,4421,2276,4356,4356,6501,6566,8678,10726,2276,2308,2243,2243,2211,2211,2211,2179,2211,2211,2178,2211,2243,2243,2211,2276,2308,2243,2275,2275,2243,2211,2404,2308,21228,15019,21555,21555,23668,25748,30006,27959,27926,23798,21783,23831,21653,27959,25976,21750,21783,23929,21784,17492,17557,15444,17460,19572,21685,19540,11154,13234,33873,4259,2211,4259,4259,4227,2178,10695,19179,6533,4388,17001,16968,14888,2276,4389,8517,8517,6437,6437,6437,4356,4324,8582,29614,31727,48599,44307,33939,40211,40146,42161,50481,35756,18951,23144,33807,46387,25159,23271,19143,19147,29711,27564,23371,40114,44209,27338,14791,12775,14823,14888,14855,14888,10695,14855,21227,16968,12775,8582,14856,10727,31628,33706,25515,54741,46190,37770,29482,19147,12873,6469,2211,12710,25322,44405,42324,40179,42291,61046,63093,240},
{40310,40278,40246,38197,36117,36085,34004,33971,33971,33939,33971,34004,36084,38230,40343,40343,40311,38230,36150,34038,29877,27829,29877,25749,21621,19573,19573,19574,21622,21654,21654,21654,21654,21686,21686,21686,21686,23735,23767,23767,23767,29975,27927,34136,46585,48665,46585,44537,44537,44537,46585,48698,46617,44504,46617,46585,44504,27566,14985,8713,10825,12905,12905,12905,12905,14986,21260,17034,14921,6599,2406,2406,4519,12937,15017,12872,2438,358,2438,6599,8679,8711,8712,6599,6599,4486,4454,6566,6534,4454,6534,12839,10759,6534,6534,14920,12839,10694,12807,6533,4356,4421,4421,4389,6501,4421,10758,2308,2308,2276,2243,2243,2243,2178,2178,2211,2243,2178,2211,2243,2243,2178,2211,2275,2275,2243,2243,2243,2211,2275,2275,6437,10762,19050,21130,17002,17034,17066,17066,17099,17099,17132,23438,27632,27664,25617,21423,21391,19376,21522,27763,17296,17329,17328,17361,17361,11088,13168,11088,42292,6371,4259,2211,2178,2178,2146,8485,23340,12807,4356,19114,19049,19081,16969,16936,21129,16968,16936,16968,14855,10695,10662,8550,27533,23209,38033,42194,42227,40146,40146,46486,48632,50646,44143,35757,31727,42227,33612,29513,12805,17099,29711,27565,33904,50614,46354,23209,10597,8484,6404,4323,4291,4324,2276,2276,2243,2243,2243,2211,6502,23340,52627,40045,35919,56755,46189,37802,37803,27501,21260,14986,12841,6404,31759,44405,42292,40179,52758,63093,61045,241},
{42358,40310,40278,40245,38165,36085,36052,33972,33971,33939,33971,34004,36084,38198,40311,40343,40279,36150,34070,31957,27797,27797,25749,23669,19573,19573,19574,19574,19574,21654,21654,21654,21654,21686,21686,21686,21686,23735,23767,23767,23767,29975,25847,29975,42424,46585,44537,44504,40376,42489,48730,50810,48697,46584,50810,50810,46617,44471,21260,12873,10825,8712,8744,10793,12905,14953,14954,19179,12905,261,229,229,229,294,4519,6631,2438,2438,2438,8744,12904,10792,10792,10792,6599,6566,4454,4486,2373,4421,8614,12839,12871,10759,8646,10727,14952,12839,12807,8646,4453,4389,2276,2243,4421,6533,12839,6501,4388,2276,2211,2276,2243,2179,2178,2211,2178,2243,2211,2243,2211,2178,2211,2211,2243,2243,2308,4388,2276,2243,4324,4356,2244,8550,10663,8518,4356,2243,2275,162,130,227,19049,35724,16936,4389,4421,4356,4356,6436,6502,17002,27305,27404,29615,31629,27469,21292,21326,48599,8452,2211,12742,14790,12678,12678,18983,21097,8549,4421,16969,19049,16969,19081,21161,16936,19016,19048,16936,16936,14855,12775,8550,35855,33513,29483,44307,36018,33872,38066,48599,57084,56855,56691,42259,31858,52825,59197,42259,17031,25484,31759,27598,42324,52760,31694,27435,25354,27435,25322,23274,25322,23241,23209,19049,19048,19016,16935,16903,12743,19049,46319,27562,37967,52562,48399,37835,37803,23274,19179,12808,4389,14889,42292,42324,40211,42259,58998,61178,61211,232},
{42391,42358,40278,40245,38197,38165,36084,34004,33971,33971,33971,34004,36084,38165,40278,40311,38230,36118,31957,29877,27829,27797,23701,21621,19573,19573,19574,19574,19574,21654,21654,21654,21654,21686,21686,21686,21686,23735,23767,23767,23767,27895,25847,25847,36216,42424,44537,42456,36216,42457,48698,52890,48697,48697,48730,50810,50778,48697,40245,8713,15018,12873,8712,12873,14986,14986,12873,12841,10760,6567,8648,8680,8680,8647,6567,6567,4486,326,2438,6631,12905,10824,8744,10824,4486,4454,2405,6566,4454,2341,8614,8646,14952,10727,14920,14952,10759,10759,14920,12807,12871,8646,4388,4388,4421,8646,17065,8613,8646,6501,2211,2211,2211,2211,2178,2211,2211,2211,2243,2308,2243,2243,2211,2211,2210,6469,10793,6600,4520,8745,4552,8713,6600,6600,6567,6567,4454,6534,4421,2341,2308,2308,10695,25290,10695,2308,2308,195,2211,130,130,10695,31662,42293,48664,46453,46486,27598,31857,54905,10565,2244,17001,21129,21129,21129,21161,21129,4324,6469,21194,29548,27467,23242,23242,21096,23242,21162,19016,19049,19016,19081,10662,29581,46223,44110,35822,19212,33872,40146,50680,61244,52693,56757,56920,50614,54970,44438,31759,23306,27531,38064,35952,48631,54938,38000,29515,16968,23242,23274,19081,27435,19114,25355,17001,23274,23274,17033,29548,23307,29515,35755,31626,21128,44143,50480,37867,35658,33740,31792,23340,6534,36019,48598,42259,40179,48500,61112,59197,61277,225},
{42391,42359,40278,40278,38197,38165,36085,36052,33972,33972,33972,36052,36084,36117,38198,38230,38198,36118,34005,29877,29877,25749,23669,21621,19573,19573,19574,19574,19574,19574,21654,21654,21686,21686,21686,21687,21687,23735,23767,23767,23767,27895,25847,25847,34136,40344,44537,42456,42424,44504,46617,52891,52891,52891,48697,48697,50778,46617,48697,25551,10792,14986,8712,10793,10793,10793,8712,17034,17033,21194,19147,21259,27501,17033,17033,12873,2406,293,2406,6631,10824,12905,10824,8679,4518,4486,10792,4518,4454,4453,4453,8614,12871,10727,8646,12871,14951,8678,14952,12840,10727,12839,6501,6533,4453,8646,17129,10823,8678,6501,2243,2243,2243,2211,2211,2243,2243,2211,2211,2243,2276,2275,2211,2178,2243,10727,14953,2505,426,523,2668,2733,2733,652,2733,2700,2733,4813,4813,6828,17196,19211,15017,10824,8647,8679,6566,4486,4486,2405,2373,14953,23308,25453,21228,19180,25355,21226,29646,40179,8485,4357,12840,16936,16936,16968,21129,19049,6469,12743,35887,42161,33774,14888,14856,19049,14888,14856,14855,16936,14856,14888,6469,27468,58901,54872,33774,35985,44373,40146,42293,57018,52628,54774,54676,46355,61309,59164,23340,23339,17065,40146,44339,48599,48598,38033,29580,23242,25354,25355,17001,25387,12808,21162,23307,21194,25322,10727,23274,14920,37967,52759,48498,12773,35724,54576,44238,33643,31530,31530,33610,29416,33774,42292,42259,40179,54805,61178,61277,61245,225},
{42391,42358,40278,40278,40245,38165,38133,36084,34004,34004,34004,36084,36085,36085,36117,38198,38198,36117,34037,31957,27797,23669,21621,21621,19573,19573,19574,19574,19574,21654,21654,21654,21686,21686,21686,21687,21687,23735,23767,23767,23767,27895,25847,25847,32056,40377,44537,42424,42424,44537,50778,54971,55003,52891,52890,50810,48697,46584,46617,44438,12905,10825,12873,8712,12873,6632,8712,10792,8712,19114,14921,10760,14921,14953,12840,6567,261,229,294,4551,12904,15017,14985,12937,12937,10792,15017,12904,4486,4454,8646,6534,10791,10791,6534,8614,12871,12871,14952,8646,4453,10758,6565,6533,8646,6501,17064,12870,6501,2243,2243,2211,2275,2211,2179,2243,2211,2211,2211,2211,2211,2243,2211,2211,2211,10760,10695,4553,2505,2570,4716,2603,2635,2668,2668,2700,2733,11053,11021,15181,19308,21355,19275,21355,21356,15049,12936,10824,10824,8744,6663,27598,19016,16968,4324,163,12743,16936,17000,21161,6404,4389,21195,31629,31596,21162,16936,25322,10630,6502,38032,44274,29646,14921,14856,10695,12808,10695,10662,8582,8582,10695,2276,19049,52694,48631,25419,40211,57018,46486,57051,59065,50482,52596,52562,48501,54971,40179,14953,25485,14919,29646,42292,46485,35920,44405,50613,44306,29515,29548,17001,21226,21194,19146,25387,14921,25354,14888,12807,14920,33774,54806,50513,16933,18983,52659,40175,31727,29581,19015,21064,14790,14888,38098,42259,44339,61079,61212,61277,59164,226},
{42391,42391,42358,40278,40245,38165,38133,36084,36052,34004,36052,36084,36085,36085,36117,36117,36117,36085,34037,31925,25749,21621,21621,19573,19541,19573,19574,19574,21622,21654,21654,21654,21686,21686,21686,21686,21687,23735,23767,23767,23767,25847,25847,25847,27927,38296,42456,42424,42456,46617,50810,52891,54971,54971,52890,50778,48665,46584,46584,46585,33906,10792,17066,10792,12905,10792,4551,4551,4551,12873,12840,12840,10792,17033,14953,12840,294,261,261,2406,8679,12937,12905,12937,12937,17098,15018,19179,12904,2341,4454,4453,10759,10727,8614,4421,8679,10759,12872,6501,6501,6501,10759,6598,6533,2340,14952,17031,6501,130,4388,4356,2275,2243,2178,2211,2211,2179,2243,2243,2211,2178,2243,2243,2211,10760,10728,4553,458,6829,4715,2570,2570,2570,2537,2570,4650,10890,12937,12937,10824,10824,12905,12873,12937,10824,12905,8679,8679,6599,8712,40146,16968,16904,6436,163,8550,10662,16936,23242,10597,2276,21260,27468,35887,31629,31661,38000,16968,6470,19082,17001,14888,12840,10695,8549,12776,10663,8582,6501,6469,8615,6502,4390,42390,50712,42160,50744,54905,50647,57051,50645,42094,39884,39820,54840,54938,27534,14921,25419,12839,21258,38099,50646,48565,48631,63258,46321,12775,29613,21194,17033,25387,19114,25387,12808,21194,12775,4421,23307,42194,58966,48368,16901,12708,44273,35981,33839,31727,25420,23340,14953,17034,33873,40211,50612,61144,61277,61277,59197,232},
{42423,42391,42358,40278,40245,38165,38165,38132,36084,36052,36084,36084,36085,36085,36085,36085,36117,36085,34005,29877,25717,21621,19573,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21686,21687,23735,23767,23767,23767,23767,25847,25847,27927,38296,42424,42424,42456,42456,46617,52890,55003,52891,50778,50778,48697,46585,46552,44504,44503,21292,14953,14986,10825,8712,14953,17099,12905,12905,17066,14953,12840,17033,19146,17033,4487,326,294,326,6631,12905,10824,8744,12905,14953,12904,10792,12872,4454,2341,2341,10727,14919,10727,4421,14952,12872,14920,8614,6501,4389,4421,4421,8646,6501,6533,6533,10726,2243,2308,2276,2275,2243,2211,2179,2211,2179,2211,2243,2211,2178,2179,2211,2243,8680,8647,392,393,2636,2701,686,653,653,2831,2799,4911,11087,19374,23501,25581,25549,21356,17162,15017,12904,10824,10824,8712,6663,10825,44340,40015,40014,21096,4389,29516,25354,19016,19081,10630,131,12775,16968,19082,16969,14888,16968,4356,4324,12743,10695,10662,10662,6469,6469,6469,6436,4356,4389,6469,6502,6535,6535,38164,48533,33775,38132,50679,50679,38066,42193,44208,33611,20967,37903,42292,23308,33807,31694,17065,19178,40211,50645,48402,48305,54611,37675,21032,44373,33741,33675,33740,33708,31627,29547,27435,27434,21129,35789,48500,56755,31530,12773,19014,50580,42287,33870,33807,27501,19114,19114,12808,23340,40179,56853,59066,59164,59164,59196,229},
{42391,42391,42358,40278,40277,38197,38165,38132,36084,36084,36085,36085,36085,36085,36085,36085,36085,34037,31957,29877,25749,21621,19541,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21686,21687,23735,23767,23767,23767,23767,25847,25847,30007,40376,42457,42456,42424,44504,50810,55003,57084,52890,52858,50810,48698,48665,46552,44504,44504,40213,17034,17066,10825,10825,10793,17098,8680,2439,14953,21194,17034,17033,19146,17034,6567,326,359,326,6632,14953,12937,8679,6631,12872,14953,15017,8712,6566,2341,2309,8646,14919,10726,6501,10759,12872,12807,10727,6534,4356,4356,4421,6534,6501,6501,6533,6501,2276,2276,2211,2243,2211,2211,2211,2211,2211,2211,2211,2243,2211,2179,2211,2308,8712,19147,17067,14987,12907,15052,13037,10957,10957,10957,8909,6861,6861,11022,10989,15083,19211,19275,19243,21356,21388,19243,14985,8743,8776,17163,40113,42194,44274,27435,14921,27501,19081,12743,19049,10598,163,12775,12807,14856,16968,14823,10662,2211,4356,10630,12743,10630,8549,6469,6436,4356,4356,4356,4324,4389,6502,2374,326,33971,52726,33644,35953,52824,50744,46484,44273,46288,37837,31530,46158,31629,19082,44274,31694,21258,21291,44307,44273,48206,39397,41445,43721,48206,44273,42093,48269,48301,48300,48301,46220,48268,48333,48333,35789,31661,42227,50515,50512,21127,40047,35949,33902,33807,29614,23373,23373,10727,10760,44339,58868,54740,54708,54740,52692,205},
{42391,42391,42358,40310,40278,38197,38165,38165,38132,36085,36085,36117,36085,36085,36085,36085,36085,34037,31957,29877,27797,21621,19541,19541,19541,19541,19574,19574,21622,21654,21654,21654,21654,21686,21686,21686,21687,23735,23767,23767,23767,23767,25815,25847,32056,40377,44537,44537,42424,46617,52923,59164,59164,54971,52923,54971,52858,48697,46584,44472,44439,44439,29712,17065,12873,8712,2471,6632,4487,4487,12841,19114,17033,17033,17033,17033,8680,326,358,326,6599,10792,14985,10824,2406,8679,14953,14985,12905,8679,2373,2341,4453,12839,8614,4421,8614,10759,12839,12839,6534,4421,6501,6501,6534,10759,14951,12806,17033,23273,4388,2243,2211,2211,2211,2243,2211,2211,2211,2211,2211,2243,2243,2179,2276,17099,25421,17066,12841,14921,14921,14953,17034,17034,17066,19114,19147,19147,19179,19180,19180,21260,21260,21260,23372,21292,23340,19179,19147,17098,23372,38000,42193,29516,14856,6437,10663,8614,8582,8582,4421,4356,8582,8582,8582,6470,6502,6469,4356,4356,4356,14888,19049,21129,19016,14855,19048,16936,12775,16903,12742,8549,10663,4389,17035,35888,27273,27370,44373,59196,56952,44208,44175,39884,46159,56757,33807,14921,40048,31694,19146,25453,52760,52791,56853,41542,39397,50484,54805,46188,46253,46253,48269,48300,44076,23209,31561,31529,27434,31694,14888,12808,23275,33773,29546,16901,21192,33901,37933,33708,33741,33773,27402,21129,52725,65206,63126,65174,63125,63093,239},
{42391,42391,42358,40310,40278,38197,38165,38165,38165,36117,36117,36117,36117,36085,36085,36085,36085,34037,31957,29877,27797,21621,19541,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,21686,21686,23735,23767,23767,23767,23767,23767,27895,34168,42457,44537,44504,42424,46617,54971,57116,59197,57084,54971,54971,50810,48665,46584,44471,42391,42358,40278,29679,14985,6632,2439,8712,14954,12841,10792,17033,17033,14921,12840,12873,12840,4487,2439,2439,4519,6599,10792,12937,10824,10760,12872,10792,12905,6566,4454,2276,2308,2340,8646,2308,8646,8646,8614,10759,10727,8614,6534,6534,6533,8678,21257,19144,21258,19113,2275,2243,2211,2178,2211,2243,2179,2211,2211,2178,2243,2211,2211,2211,4389,25486,17066,14987,12939,17100,14986,14986,14954,14954,12873,12841,12841,10760,10760,10760,10760,10728,10760,10760,10761,10761,12841,12841,12873,12873,17066,42194,35887,14823,14856,8550,10630,8582,8582,8550,4324,2243,4356,8582,6437,4324,8582,6405,4324,6469,2244,10727,23242,21161,23210,23209,21161,23209,25290,21161,21129,23242,25355,16903,6371,14725,18853,23079,35855,61277,50450,37837,39982,44045,54578,54872,27566,10728,33774,33807,27565,36018,48566,54872,61145,43752,41543,54873,61277,50513,46220,46253,46221,48300,46188,42027,42027,41995,38000,21227,19114,19114,27566,27500,27466,8547,19112,29707,29513,39883,33609,25191,27304,25256,35821,44176,48401,48433,50481,54739,217},
{42358,42358,40278,40278,40245,38197,38197,38165,38165,36117,36117,38165,38165,36085,36085,36085,36085,34005,31957,29876,27797,23669,19541,19541,19541,19541,19573,19574,21622,21654,21654,21654,21654,21686,21686,21686,21686,23735,23767,23767,23767,23767,23767,27927,38296,42457,44537,42456,44504,50778,55003,57084,57116,55003,52890,50810,48697,48665,46584,44471,42359,40278,40278,38164,21227,10792,8712,12905,17066,19146,17034,12873,19146,19113,14953,10760,10792,4519,4487,8680,8712,8680,12873,10792,8712,10792,14985,10792,12873,10792,6534,2341,2341,2308,4388,2276,12840,12872,8646,10726,12839,8646,8679,6534,2308,4453,17064,27498,6501,4356,2308,2211,2211,2178,2178,2178,2179,2179,2211,2178,2211,2243,2243,2211,2276,17067,23373,15183,4847,15282,13201,15314,17394,19507,21555,17393,19474,19474,23635,21489,29776,31823,31856,31824,25485,27565,23404,21291,21259,19179,19212,46452,40113,14888,19081,16936,21162,19049,17000,19049,12775,12710,16968,14888,14856,10662,12807,14856,16936,8582,4389,8614,16936,16968,16968,16936,16936,16936,19048,19016,16936,16968,19016,23177,35659,16838,23047,25192,35887,59131,48271,42030,33644,33710,48632,48631,17034,6534,29581,35887,31727,48631,37968,52758,56985,43883,43753,59164,61278,59131,48334,46220,46220,46220,46219,48301,48300,50480,42226,21227,21194,25420,33807,31594,12870,8612,16934,31788,27497,39883,37803,27467,23340,10727,8647,4357,16870,12709,4291,21194,161},
{42358,40310,40278,40277,38197,38197,38197,38165,38165,38165,38165,38197,38165,36117,36085,36085,36085,34005,31957,31925,27797,23669,19573,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,23735,21686,23735,23767,23767,23767,23767,23767,27927,40377,44569,44505,42456,46649,52891,54971,52891,52858,52858,52858,50810,48698,48665,46552,44471,42391,40278,40310,31826,21292,19178,10760,8680,10792,19178,17066,14985,14953,19146,12873,4487,8680,2406,294,2439,10792,8680,8680,6599,6631,10792,10824,12905,12905,12905,8647,6534,2341,2341,4421,6534,10759,12840,10727,6566,8646,6566,8646,4453,2308,2308,12936,19112,4356,4388,2211,2179,2211,2179,2178,2211,2243,2211,2178,130,2178,2243,2276,2211,163,10695,14921,13070,4847,15313,21587,15281,15346,19572,19572,13331,17525,25845,25845,29940,40372,42387,42387,44500,42387,40241,38096,33967,31887,31887,29840,40211,40081,12807,16968,8549,10662,10694,10695,16968,14856,12743,12775,12775,14888,6469,12808,16968,16968,6437,4356,12807,17001,16936,19016,14888,16968,16968,19048,16968,16936,19049,19048,27337,46191,44078,31465,31465,33742,54839,48238,44110,29548,14888,8615,8582,163,2244,27534,35855,44405,57083,42194,56984,50645,44110,48175,59229,59229,61310,56919,46188,46188,46188,46219,46188,46252,50546,42227,40146,40146,42259,42194,39981,21224,12870,14886,31723,23368,35755,39883,33741,29679,19146,10760,2276,10662,16903,2210,14921,133},
{42358,40310,40278,40245,38197,38197,38165,38165,38165,38165,38165,38197,36117,36085,34037,34037,31957,31924,31924,31924,25749,23669,19541,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,21686,21686,23767,21686,23735,23767,23767,23767,23767,23767,25847,40377,44569,42457,42456,46650,54971,54971,54971,52891,52891,52891,52890,50778,48697,46584,44471,42391,42359,42359,33906,27599,25484,17065,8712,6600,8712,15018,19178,14985,17066,19146,12840,4519,2406,326,4487,10760,10760,10792,8712,6631,6631,6631,8712,14985,10760,8647,10727,4421,2308,4389,10759,10727,10759,8614,2308,2244,2243,2276,2276,2243,2276,14984,10726,2211,6470,2211,2211,2179,2211,2178,2178,2211,2178,2178,2211,2211,2211,2243,2243,2179,10663,17067,10989,13102,19376,19409,15182,19376,21424,15183,15183,17263,25584,27663,27696,25550,29743,31823,33969,36081,33968,33968,29710,29742,31790,29742,33903,35953,10695,21162,14855,16936,16968,16936,14888,12743,19016,16936,16968,19081,8582,12775,19016,19049,8582,4324,14921,29580,29581,27468,27435,25355,25322,25355,21161,21129,21161,16968,46158,60818,54512,39884,39917,44111,48337,48238,42029,10726,2340,2307,2243,2211,130,17001,44307,46421,48566,42225,40080,27501,42193,52726,61277,59229,61277,57084,52626,46188,46188,46220,44075,42126,42160,38098,54937,59131,59098,40114,31661,42126,31658,21192,40109,21320,31626,39883,33642,17034,17033,8647,6469,8549,18983,8517,8614,82},
{42358,40310,40278,40245,40245,38197,38197,38165,38165,38197,38197,38197,36117,34037,29877,29877,29845,29844,29844,29876,27797,23669,19541,19541,19541,19573,19573,19574,19574,21654,21654,21654,21654,21686,21686,23767,23735,23735,23767,23767,23767,23767,23767,25847,38296,46617,44505,42424,46617,54971,57052,57084,54971,54971,54971,52890,50810,50778,48665,44504,42391,42391,42358,42359,38132,27630,23371,17033,12873,8680,8744,12937,12937,15050,17098,17066,10760,8680,4519,8680,12873,12873,10792,12873,8712,6632,10824,6599,12872,10759,8679,10759,4454,2341,2308,8646,10759,8647,6534,4389,2244,2211,2211,2244,2244,2276,6566,2243,2211,4388,2276,2243,2179,2179,2178,2178,2178,2211,2179,2211,2243,2211,2179,2211,130,8615,8648,621,4880,9171,13364,15444,19605,19573,19573,19573,21652,32020,38227,42387,40274,40275,36049,33903,31790,29710,31790,29678,29710,27597,27630,25517,21292,10695,19114,16936,19049,19016,21161,4357,4357,19017,19049,16936,10695,6501,14790,21129,19081,12710,2211,21259,42161,46452,48500,42161,46419,48499,42160,44274,48467,46386,44209,54447,58607,56592,35724,18984,23209,46158,46191,48271,16903,12840,14984,6533,4356,2243,12776,50711,46420,42292,31725,35821,19113,42227,57083,61277,61277,59229,55003,59098,48302,46188,46221,44207,48500,42259,42292,57018,57050,54905,31759,19082,48466,35884,19113,42223,21351,25385,39915,37803,21226,17099,12840,17099,12841,14822,19081,25486,61},
{42358,42358,40278,40278,40245,38197,38197,38197,38197,38197,38197,38197,36117,31957,25716,25716,25716,27796,29844,29844,27797,21621,19573,19541,19541,19573,19573,19574,19574,21622,21654,21654,21654,21686,21686,23767,23767,23735,23767,23767,23767,23767,23767,25847,34136,46617,46650,42457,44569,55003,57084,57084,57051,54971,54971,52890,52890,52858,48697,44472,44471,42391,42358,42358,44471,31825,23371,23371,12873,6600,6599,12905,10792,6632,10825,17098,12873,6599,8680,10792,12872,12873,10760,6599,8680,4519,6567,10760,10792,12840,10760,10759,8647,4421,2341,8646,10727,8614,8614,6534,4356,2211,2211,2276,2276,2308,4421,2243,2179,4356,2276,2243,2211,2178,2178,2178,2178,2211,2211,2211,2211,2211,2243,2276,163,8583,10793,8909,15150,10989,13168,17329,21522,17362,17362,19475,17427,17427,21587,29875,36081,38226,40274,42388,42420,40307,36048,33935,29839,31919,34000,29839,29679,12808,19081,16936,16936,19048,23242,10662,4356,19049,21129,16936,4389,8614,12807,23274,19016,12775,2309,25420,48467,50580,48435,48467,50613,48467,48434,48467,46354,44241,44273,41867,41737,37609,10565,6437,23210,48238,44110,50384,23144,27567,40145,21226,12807,2275,17067,61342,52825,48599,46453,42160,23274,40080,61014,61277,61277,59164,55003,63422,56919,44107,46189,44140,44240,42259,48631,57050,57050,50646,31759,8517,8582,12775,21225,21288,23432,29609,39915,37835,21096,6502,6501,6469,4389,12742,19048,27468,98},
{42391,42358,40310,40278,40245,40245,40245,40245,40245,38197,38198,38198,34037,27797,23636,21588,23668,25716,27764,27764,23669,21621,21621,19541,19541,19573,19574,19574,19574,21622,21654,21654,21654,21686,21686,23735,23767,23767,23767,23767,23767,23767,23767,25847,32088,46618,50778,42457,44537,52891,55003,57084,57084,54971,52890,52890,52890,52858,46617,44504,44471,44471,42391,42358,42423,38165,12906,23339,17066,10792,14985,12905,12905,8712,6632,6632,14985,10792,8680,12841,12873,12840,10760,6599,8712,8712,2374,4454,10760,12872,8647,6534,8647,2373,2341,8679,12871,8614,6501,6566,2276,2276,2276,2308,2244,2276,2243,2211,2211,2276,2276,2211,2211,2211,2178,2178,2179,2211,2179,2211,2211,2211,2243,2243,2211,2211,4388,4421,4421,8614,6502,6502,8647,8647,8615,8647,10696,8680,10761,12874,14921,14986,19179,21292,21325,23437,25517,25485,25452,23404,21324,23404,33905,17034,25355,21129,19048,21129,23242,12743,4389,16904,16936,14856,4421,8582,23340,48532,48467,42161,17067,33873,44274,48467,44242,40081,46386,48468,46387,50548,48499,44241,42226,41867,41737,37674,27337,17099,29548,48206,46158,48304,44175,42291,23372,6501,4388,2243,17066,61309,65503,63422,40146,40113,29548,40014,64879,61080,61310,57051,46486,52825,54937,58932,58900,58899,50579,40147,52824,57018,57018,44339,33840,16969,8549,19048,27531,14886,31691,29543,35722,39883,29449,10727,10695,8614,4421,6469,10629,12710,48},
{42391,42358,40310,40278,40278,40245,40245,40245,40246,40246,38230,38198,31957,25716,19508,21556,21588,23636,23668,23668,23669,21621,21621,19541,19541,19541,19573,19574,19574,21654,21654,21654,21654,21686,21686,23735,23767,23767,23767,23767,23767,23767,23767,25847,34136,46617,50778,42457,44537,52891,57084,59164,57084,54971,54971,54971,54971,50778,46584,44472,44471,44471,42391,42391,42391,40245,10793,12873,19146,21258,19178,12873,14953,12873,10792,6599,8712,17066,14953,12840,12873,12873,12873,6599,4519,8712,6631,8679,8647,14921,8679,6566,8647,4454,4421,10791,12872,8646,6566,8614,2308,4389,4421,2340,2243,2243,2211,2243,2276,2243,2211,2178,2179,2211,2211,2211,2211,2211,2211,2211,2211,2276,2243,2211,2211,2178,130,2275,2243,195,195,2243,2275,163,131,131,131,130,130,130,131,131,2243,2373,228,2276,12873,23372,16903,12646,14953,19180,33807,33807,52726,50580,50547,50547,50547,31693,8647,12775,14823,14823,6469,16936,31629,38032,44307,35888,17067,42227,44307,42259,44274,42193,40048,46387,44339,42194,44307,46419,44339,39852,46028,54545,56755,29712,35952,50384,48206,42030,63160,46452,14952,4453,2340,2275,10695,27598,29679,33938,42226,42257,35887,52528,64878,64880,61211,54971,57083,59164,61243,65370,65403,65434,48400,35986,57018,57050,54937,38066,33872,31726,27466,19014,16966,12676,31693,35818,31592,37803,37770,27500,19147,14921,6469,6469,8582,12840,49},
{42391,42391,42358,40278,40278,40278,40245,40246,40278,40278,40278,38198,31957,25716,21588,19508,19540,21588,21588,21589,21589,21621,21621,19541,19541,19573,19573,19574,19574,21622,21654,21654,21654,21686,21686,23735,23767,23767,23767,23767,23767,23767,23767,25847,30008,46617,48698,38296,36216,50811,59164,57116,57051,55003,57051,55003,54939,50778,46584,44471,42391,42391,42391,42391,44439,36051,10793,8713,17066,21291,21258,17098,19146,19178,14953,10760,4519,10792,12905,14953,14921,12873,12873,10792,8680,8680,10792,12840,10728,12840,10727,8647,6566,6534,4454,8646,14952,8646,8614,8646,6501,2276,4356,4389,2276,6533,2276,2211,4389,2211,2211,2211,2211,2211,2179,2211,2243,2211,2179,2178,2211,2308,2276,2211,2211,2178,2178,2243,2243,2341,2308,2308,2276,2211,2211,2211,2179,2179,131,130,130,131,2243,2276,228,2276,14921,27566,14888,4356,2373,2308,27534,25453,52726,48467,44209,44241,50547,27468,17066,44274,48434,46321,21195,16969,40048,46354,44274,35953,25453,42194,46387,46387,44273,44274,44274,48500,46387,48467,46386,44274,42161,31628,50351,58770,63061,42226,38033,50351,52464,29418,44340,54905,27533,10758,6533,4420,2340,4452,8613,6533,38163,48563,35853,56590,64911,64846,64978,54937,57051,52825,61177,65370,65402,61012,37834,42324,59131,59131,52791,35953,33905,23373,12775,18982,16934,12773,21194,54838,35915,35722,37770,29547,21260,19179,14985,14888,6404,19147,89},
{42423,42391,42358,40310,40278,40278,40278,40278,40278,40278,40278,38198,34037,27797,23668,19508,19540,21588,21589,21589,21589,21621,21621,19573,19541,19573,19573,19574,21622,21622,21654,21654,21654,21686,21686,23734,23767,25815,23767,23767,23767,23767,23767,25815,30008,46618,46617,36216,30007,42489,57084,57084,57052,57052,57051,55003,54939,50777,44504,44471,42391,42423,44471,44439,44439,36019,10793,12906,12873,19178,23371,19146,17066,21291,17066,6600,4519,2374,262,6567,12873,10760,10760,10792,8680,10760,10760,12840,6599,8712,14953,10727,6534,2341,228,4421,10759,12872,8679,8646,10727,4421,4421,4388,4421,6534,8678,4421,6533,4356,2211,2243,2243,2211,2179,2211,2243,2179,2178,2179,2243,2308,2308,2276,2243,2179,2178,2211,2211,4454,2308,2276,2243,2211,2211,2179,2211,2211,2179,2179,2179,2211,2211,195,163,2276,19147,21097,19114,17001,4420,228,12841,25454,52726,50580,48499,50580,54741,21194,19147,42194,44306,42161,14986,17001,38000,46354,46387,31760,29614,48500,48500,50580,50612,50612,50548,52660,48499,48467,44273,37935,31661,12710,21097,54577,58868,56755,42064,48304,54512,44209,54905,59163,27565,23339,27532,25453,27599,31792,27565,19211,38131,52855,46287,62798,64911,64879,64945,59000,50744,50711,63257,65370,65402,56786,31527,31821,36048,46483,42291,33872,27566,14921,12743,29581,48400,31626,16935,54740,40076,33738,39883,35723,31628,31628,25354,23241,14757,23242,111},
{42423,42391,42391,42358,40310,40278,40278,40278,40310,40310,40310,38198,34037,25717,21588,21588,21588,21588,21589,21589,21589,21621,21621,21621,19541,19573,19573,19574,19574,21622,21654,21654,21654,21686,21686,23735,23767,25815,23767,23767,23767,23767,23767,23767,34136,48698,44570,36216,27927,36249,55003,57084,57116,57084,57051,54971,50778,46585,44504,44471,42391,44439,46552,44471,44471,38132,10825,6665,8745,10825,21291,21291,19178,19146,19178,6632,2407,262,229,294,10760,12873,10792,12872,8712,10760,10760,8647,2406,6567,12840,10760,8647,2341,228,4421,10727,12840,10759,8614,10727,8614,4421,4389,4388,2308,8711,10791,6534,12871,6500,163,2243,2211,2211,2211,2211,2179,2179,2211,2276,2308,2276,4388,2243,2178,2178,2211,2243,6534,2340,2211,2243,2243,2211,2211,2211,2211,2211,2179,2179,2211,2179,196,195,4356,17099,16969,10662,8614,4453,228,6567,31792,50580,42161,48467,46387,44241,17001,21228,42161,46354,42160,10727,17001,35887,35855,35822,25421,31727,38000,37935,38000,38033,42194,42226,44307,37968,44274,42161,23242,14856,14823,12743,21064,25290,25355,33743,48305,56722,65208,61212,52792,21227,38000,46387,57051,63422,65503,63390,61309,59164,57050,61046,62831,58476,60654,61015,57018,52792,54871,65369,65370,65402,63191,35688,25447,27596,35886,33839,29679,21227,21227,17001,23307,42127,29610,14855,52660,39980,50578,61078,58932,58900,58867,56754,56754,54674,52528,197},
{44471,42391,42391,42358,42358,42326,42358,42326,42358,42358,40278,36118,31957,23668,21588,23636,23636,21588,21589,21589,21589,21621,23669,21621,19541,19573,19573,19574,19574,21622,21654,21654,21654,21686,21686,23735,23767,25815,25847,25847,23767,23767,23767,25847,38329,48698,44569,38296,30007,38361,54971,57084,57084,55003,54971,52858,48697,46552,44471,42391,42358,44439,46584,44503,44471,40245,14986,8745,10825,12906,19146,19210,23371,21259,19178,4519,2374,294,2374,2407,12873,12873,12873,10792,8680,8680,10760,6599,294,2374,10792,12840,8647,4454,4487,12873,12840,12840,10695,6534,8614,10791,6534,4453,2340,2276,4421,10823,12903,14984,10758,163,4356,6437,2243,2179,2178,130,2178,2179,2276,4389,2276,6501,2243,2179,2178,2243,2211,4453,4420,2211,2243,2243,2243,2211,2211,2211,2211,2211,2211,2211,2179,2211,2211,4389,12840,10695,12775,6501,4421,4389,6534,38099,46387,35855,35887,37968,35920,25453,35920,54741,52628,37968,14953,25388,50580,50613,48467,46387,46387,48467,50580,48467,46419,50612,48500,46419,46386,42161,35887,35822,19049,21129,16936,19016,16968,35757,42096,54675,63192,63290,44371,31727,19081,25420,57083,63423,63422,63390,63422,63390,63422,59196,61145,50384,31172,29288,50614,54873,54904,58998,65338,65337,65337,65370,42028,27464,40177,44307,44273,29646,23340,21227,14888,4356,6437,19175,31660,50547,42060,61078,65272,65239,65239,65239,65238,65272,65272,65239,250},
{44471,44471,42391,42391,42358,42358,42358,42358,42358,42359,40311,38230,31957,25716,23636,23636,23636,21588,21589,21589,21589,23669,23669,21621,19541,19573,19573,19574,19574,21622,21654,21654,21654,21686,21686,23735,23767,25815,25847,25847,23767,23767,23767,25847,40377,46650,42457,40377,30008,44570,55003,54971,57052,57084,52891,48697,46585,44472,44439,42391,42326,44439,48665,46584,44471,44471,25486,12906,10826,12906,6632,12905,21259,23403,21259,12873,14953,14953,12873,10760,10760,12905,10792,10760,10792,6599,8680,6567,293,261,10760,12872,8647,4454,4455,10760,12840,12839,10727,6534,4389,4421,10759,10759,8678,8614,2276,12871,10823,6566,4421,2276,2341,4421,2308,130,130,130,130,2179,2244,2276,4388,6501,4420,2243,2211,2243,2211,4453,4420,2243,2275,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2211,2244,2276,12808,29450,31596,12775,2308,4389,8647,29712,42226,40081,44339,44274,35822,17002,35952,52660,48467,29613,10728,27533,46355,48435,46386,48467,46387,46354,50580,46387,44306,50580,46387,46387,50580,31727,35887,42161,16903,21129,14823,18984,21097,52431,52497,63127,65272,63291,38031,14886,16966,27565,63423,63422,63422,63422,63422,63390,63423,61244,59098,48304,43914,33512,46421,59131,48533,52758,59098,50547,50580,61211,46288,29415,31690,42225,40145,21227,40146,40113,12775,8582,31595,39980,44207,46352,48432,65272,63191,63191,63159,65238,63126,63191,65272,65239,251},
{44472,44471,44439,42391,42391,42390,42358,42358,42359,42391,42391,42391,31989,27796,25716,23668,21588,21589,21589,21621,21621,23669,25717,19573,19541,19541,19573,19574,19574,21622,21654,21654,21654,21686,21686,21686,23767,25815,25847,25847,25815,23767,23767,25815,34168,46650,40377,40377,32088,48730,54971,57052,57116,57084,50746,46617,46585,46552,44471,42391,42358,44471,48697,48664,46552,46584,36019,12906,10825,8745,6632,4520,15018,21291,23371,21259,21227,14953,17066,17066,14953,12873,10760,10760,12873,8679,4519,8680,2438,293,6599,14953,12840,2341,196,196,4421,12839,10727,6501,4389,4356,2276,6501,6501,14952,17000,19144,12839,4421,2276,2211,2308,4422,4453,2276,2178,130,2178,2178,2211,2211,2244,2243,2211,2211,2211,2243,2243,6534,2340,2243,2243,2243,2243,2211,2211,2211,2179,2179,2211,2179,2243,2276,2276,2211,8615,25355,31563,2340,4421,4421,8615,21293,23339,31792,44405,23144,14725,14725,29516,37968,46354,33807,21226,38033,52660,54773,52661,50548,52693,52628,48499,54773,50580,46354,52660,50580,42226,29680,38000,44274,31530,33676,29450,29483,31531,56624,50383,44175,39917,52792,48532,29677,40079,25418,55003,63390,61309,61310,63390,63390,63390,50744,59098,54870,50449,39917,44307,54904,42226,54970,56986,31662,46486,38066,33742,29415,27464,38096,33872,27534,52792,48533,27467,21063,50514,60981,56853,40077,54804,58933,46321,42226,44274,50481,37836,35756,52627,44240,145},
{44504,44471,44471,44439,42391,42391,42391,42359,42391,42391,42391,42391,34038,29877,29877,23668,21588,23636,23668,23668,25717,25717,25749,21621,19541,19541,19573,19574,19574,21622,21654,21654,21654,21686,21686,23734,23735,25815,25847,25847,25847,23767,25815,25815,30008,46617,42457,34136,38296,52891,55003,57116,59197,57084,50778,48697,46617,46584,44504,42391,42358,44471,48697,50745,46584,46552,42358,17132,10858,12906,14986,8713,10825,19178,19210,21291,21259,21259,19146,19146,17034,12873,10792,12841,10760,8680,6599,4519,6632,326,2374,12872,12872,2373,196,229,228,8679,12839,6501,4421,4421,2276,12871,12839,19112,23273,23337,23369,6533,2211,2211,4487,8648,8615,6567,6502,4421,2243,2211,2211,2243,2276,2243,2178,2178,130,2244,4421,4388,2243,2243,2243,2211,2243,2211,2179,2179,130,2179,131,2179,2243,2276,2276,163,4389,23275,29613,10726,4421,6502,12873,25519,23275,25518,35888,18853,18853,18853,18886,20934,16805,14889,17034,46387,50580,44274,48533,46387,44306,52693,52693,48435,54741,52660,48435,52660,40080,19114,42194,48369,58737,58802,58802,56723,50482,48533,40146,40081,31661,48631,48599,46518,46387,35853,44405,57083,48598,35888,31727,31695,21195,21292,54904,54967,35885,19080,38000,48565,52792,50711,40014,25191,37901,25223,25288,33609,21225,38033,31759,40179,59163,46485,44273,44142,35854,31694,44208,46254,61144,54773,50481,50513,50514,50514,50546,52594,50514,48401,183},
{44504,44504,44472,44471,42423,42391,42391,42391,42391,42391,42423,40311,36118,34038,29877,23636,23636,23668,25716,27797,27797,25749,25749,21621,19541,19573,19573,19574,19574,21622,21654,21654,21654,21654,23734,23735,23734,23767,25847,25847,25847,25815,25815,23767,30007,40377,40377,40376,46617,52923,57051,59164,59197,57084,50778,48697,48665,46617,46552,42391,42391,44504,48697,50777,48664,46552,44471,23406,8745,15018,21291,17066,10825,17098,14985,17066,19179,23372,21323,17066,17033,17066,12873,12873,12873,10760,4519,4487,6567,326,261,6567,6567,2309,228,261,261,6566,6566,4421,4389,2308,2340,8646,14984,21289,19176,23369,27530,6533,2179,2243,2309,4389,4389,4454,6502,6534,2308,2211,2276,2243,2276,2308,2243,2243,2179,2276,4389,2243,2243,2243,2243,2244,2243,2211,2211,2179,2179,2179,2179,2179,2211,2211,2276,228,2308,23243,37935,33708,8614,8615,23373,29680,29712,19178,4452,6436,6436,8484,10565,12677,14823,2308,14889,42128,42194,48467,50580,50612,50580,50581,48467,48467,44274,46354,46354,44274,29646,33775,42161,50416,58770,58770,56690,58835,44208,42324,40179,44372,38066,50711,40147,54905,23274,25451,50744,54938,50679,40146,31694,33840,14823,12841,50711,54936,37869,37803,35723,46420,50711,42259,52660,52561,54707,50448,50448,40045,31758,40147,38098,52824,57050,42259,44274,14757,6437,23242,46320,48530,61112,54708,46353,50546,54739,52627,50547,54740,54707,48401,214},
{44504,44504,44504,44504,44471,44471,42391,44439,42391,42423,42391,38230,34070,34038,31957,25716,23668,23668,27764,27797,27765,25749,25749,21621,19541,19541,19573,19574,19574,19574,21654,21654,21654,21686,23734,23735,23734,23767,25815,25847,27895,25847,23799,25847,25847,32088,38296,46617,50810,52923,55003,57084,59164,54971,50810,48697,48665,46617,46552,44439,42391,44504,48665,52858,50745,46584,46552,29745,10825,12938,14986,14985,10825,15018,17098,12937,17066,23339,19178,17066,17066,17034,14953,14953,14953,10792,8647,6599,6599,326,261,10760,10759,2341,261,228,196,4389,8646,6533,4421,4421,4389,2340,8646,8678,17096,21224,14919,4388,2244,2244,2211,2211,2244,2276,2178,2243,2243,2178,2276,4388,2243,2243,2243,2243,2211,2244,4389,2276,2244,2243,2211,2211,2211,2211,2211,2179,2179,2179,2179,2179,2179,2179,2243,195,2308,19114,33741,31564,12775,10694,29679,29712,21260,17066,2308,2275,195,6501,6502,8614,6501,6501,27370,44176,25421,8582,14888,27468,38000,39950,29385,40081,27468,33611,29451,25290,25389,29614,35854,52431,58737,58737,58770,58835,33742,27534,42292,46518,42292,40179,29712,38034,6436,31726,57051,48599,50679,35920,42260,38099,33807,19147,42325,42258,46354,48303,46255,48598,48533,46517,61211,61145,63292,61144,63258,50611,25449,21227,38066,54905,52792,40146,52694,35822,10565,35724,44142,56918,65272,48434,27435,48466,54707,35789,46321,58933,46321,44240,223},
{46552,46552,44504,44504,44471,44471,44471,44439,44439,42423,42391,36118,29877,29877,27797,25716,23668,25716,25716,27765,27797,27797,27797,21621,19541,19541,19573,19574,19574,21622,21654,21654,21654,21686,21686,23767,23735,23767,25815,25847,27895,25847,23767,25847,32088,40377,44537,48698,52891,54971,55003,57084,57084,54971,52890,50778,48665,48665,46584,44471,44471,46584,50745,52858,50745,46584,46584,31825,10826,12906,12873,12937,14986,14986,21259,21259,12905,19179,19178,19146,17033,8712,10793,12873,12873,12840,8712,8648,4486,261,229,6567,12872,6534,2341,2309,2276,228,8614,8646,6534,4453,2340,4453,12904,4453,6533,14919,4389,163,2211,2243,2211,2244,2276,2243,2179,2275,2211,2179,2308,4388,2275,2211,2243,2211,2243,2276,4356,2244,2276,2276,2276,2276,2211,131,131,130,131,131,98,98,98,130,2243,4389,23406,33873,25323,21130,12743,8582,27567,27566,14856,6501,2340,2276,2275,6469,8582,12743,12776,17033,29613,44339,21195,4389,10695,14921,31694,31531,25095,35888,17001,12645,14824,20999,19017,19146,29451,41900,33481,29353,29385,27338,14889,8582,23275,42227,31760,27533,8647,6469,130,29647,59131,42292,50744,50679,50712,46518,35953,19147,33906,33839,21225,38000,50645,52791,44371,52824,63226,61145,63291,61112,63291,58966,27529,14952,42325,59131,44372,44340,52693,46322,21162,46453,52627,63224,65305,58933,50546,61013,58900,46287,54707,63125,48433,48433,245},
{46584,46552,44504,44504,44504,44471,44471,44439,44439,42423,42391,36118,29845,25716,23668,23636,23636,23668,25716,27797,27797,27797,27797,21621,19541,19573,19573,19574,19574,21622,21654,21654,21654,21686,21686,23735,23767,23767,25815,25847,27895,25847,38296,44569,48730,48730,50810,50810,52858,52891,55003,57084,55003,52890,52890,50778,50777,48665,46584,44471,44471,46584,50777,52858,50745,46584,46584,33939,12906,10826,10858,19178,17098,17066,19147,21259,19178,19178,21259,21291,19210,10824,14953,12873,10792,12872,10760,6567,2406,294,261,6567,10727,6567,8615,6566,8647,4454,10727,4453,2341,4486,10791,10758,12903,8678,2276,19112,27465,12806,4323,2275,2276,2276,2276,2244,2211,2308,2276,130,4356,4388,2243,2243,2211,2211,2211,2243,2243,2211,2309,2276,10728,23339,23339,21259,19178,19146,19146,17033,14920,14888,14856,12775,10695,12710,19017,18984,14758,14758,12710,10662,17002,19049,16871,12742,4453,2340,2340,12775,16937,17034,12808,12841,23340,35953,23307,6534,14888,14954,25453,33709,27304,23308,8647,8550,10761,27370,18951,19082,10565,8452,8484,8452,6404,10630,10727,10695,35986,35953,38099,17033,6533,4356,4421,42357,54937,40147,46551,54970,52792,52824,42292,17066,23374,44339,25350,21225,44371,52792,44371,54872,50645,59098,56952,59032,61178,59031,35949,17064,48631,56985,33807,50614,52661,35822,25323,48468,29450,31562,33611,33643,35756,37836,39981,42095,44207,44207,48401,50481,199},
{46584,46584,44504,44504,44504,44472,44472,44471,44471,42423,42391,38198,31925,29877,29877,25716,23636,23636,25716,27797,27829,27829,25749,21621,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,23734,23734,25815,23767,25815,25847,27927,36248,50811,57052,54971,52891,54971,55003,52923,52891,54971,57052,54971,52890,50810,50810,50778,48697,46584,44504,44471,46552,48697,50777,48665,46584,46552,40245,15019,10826,10826,15018,19179,12873,12905,19147,19179,21291,21291,17098,19178,19178,14953,10792,12840,14953,10760,6599,4487,294,293,4519,12840,10728,8647,6567,4486,4421,6567,8647,6502,6566,12936,8678,8614,12871,8678,19177,38028,38060,27529,4388,2243,2308,2276,2244,2308,2308,2276,163,4421,12839,2243,2276,2308,2243,2211,2211,2276,2243,4453,2308,17033,31758,27565,27565,27565,27565,27565,27565,27565,27565,29645,17034,10695,14726,14693,12612,12645,14693,14725,14726,12710,14791,10630,6469,4420,4453,4420,12743,8517,17002,10696,6535,8648,23373,19114,17066,19081,10761,25421,42128,33709,19180,10793,8713,10793,27403,29418,21194,12678,14628,10565,12612,8484,12743,10695,10728,33906,23341,31792,12839,8645,6565,19178,54937,48631,35953,40179,46518,46551,46551,44372,17034,17067,42292,33706,19177,44340,38065,44404,44274,33774,54904,31629,52792,42226,37935,44306,14983,33872,48565,42161,52694,50581,46321,44046,48337,37836,37803,39916,35723,31497,31497,33610,29384,27304,29384,27304,25191,105},
{46584,46584,46552,44504,44504,44504,44504,44504,44472,44471,42391,38198,31957,31957,36118,29877,25716,25716,25717,27829,27862,25782,25782,19573,19541,19541,19573,19574,19574,21622,21622,21654,21654,21654,23734,23734,25815,25847,25815,25847,40409,55004,59164,59197,59164,57084,57084,57084,54971,52891,52891,54971,52891,52891,52858,52858,52858,50745,48665,46552,46552,46552,46584,48665,46584,46584,44471,40278,19245,10826,10826,12938,17099,14954,14954,14986,17067,21259,23372,23340,17098,14985,17098,14953,12840,10792,12840,12840,6599,2374,294,8680,12872,10727,4454,12840,6534,4454,8680,17066,14954,10760,8614,4388,196,2276,2276,8614,31755,27497,10661,4323,2243,2308,4421,2243,2243,2276,2308,163,6437,21194,195,2276,2308,2243,2211,2211,2276,2243,4421,2340,21227,31726,21259,19146,19113,19113,19113,17065,19113,19114,19179,12840,14921,18951,20967,18886,18886,20934,18886,18886,18951,25290,6501,195,2211,2243,8614,14823,4324,8615,8615,4454,8680,19180,12808,21260,14953,8550,21293,50547,44307,38099,14888,16936,19147,25258,31596,19082,18951,25094,23046,23014,14791,17001,10695,6534,33873,29647,33873,17032,12903,8677,31824,59098,44405,29679,42292,38099,23373,27599,23405,14953,14954,38099,37998,29646,46518,50678,50711,42161,46452,48533,37999,52792,40112,48532,50677,21287,21256,31725,46385,48499,52726,44210,29516,44241,50481,50481,27436,35920,48532,37967,35919,44273,42161,48499,44240,40015,150},
{46584,46584,46552,44504,44504,46584,46552,46552,46552,44504,42423,40311,36150,36118,36118,29877,27797,25749,25749,27862,27862,25782,25782,19573,19541,19541,19573,19574,19574,21622,21654,21654,21654,21654,23734,23734,25815,25847,23767,25847,50811,59197,59197,61277,61277,59197,59164,59164,57084,54971,52891,52891,52890,52891,52890,52858,52858,50777,48697,46584,46552,46552,46584,48665,46584,46584,44471,40278,29745,8777,8778,10826,14986,14986,14986,8745,6632,17066,21227,21259,17066,6600,6599,10760,10760,12840,10760,10760,6599,294,294,8680,12840,12872,8647,12840,10727,8647,2341,2308,2276,4421,10791,10791,8646,8646,4453,4421,14951,10661,6404,8581,4356,2276,4388,2308,2275,2243,2276,2243,4357,25387,12806,6501,2308,2308,2276,2243,2211,163,4421,23339,25452,29645,29646,29645,29645,29645,27565,27565,27533,27532,27565,25421,23340,27403,19081,21194,19048,23275,19048,21226,23307,21194,2308,2243,2211,2178,6437,19017,14856,10696,10695,6502,10761,12939,6535,23341,8647,17002,17035,40048,37968,31792,19147,17002,25453,23210,29516,16903,27272,29320,29352,29385,25225,16936,10727,8615,35953,33872,36018,29646,23338,12839,46517,57017,40147,31760,44438,27501,12808,10695,10793,10695,14954,29712,37968,38001,46486,54904,50711,46321,44339,46419,44273,48565,46386,48565,48467,29706,15014,16965,31754,29643,35919,42128,42260,48467,54707,40047,12873,29679,61244,40179,19147,57018,44372,19114,46550,50678,116},
{46584,46584,46552,46552,46552,46584,46584,46584,46584,46584,44504,42391,40311,38230,36118,29877,25717,25717,25781,29942,27862,25782,25782,19573,19541,19541,19573,19574,19574,19574,21654,21654,21654,21654,23734,23766,25815,25847,25847,27895,50811,59197,59197,59229,61277,61277,59197,59197,59196,55003,54971,52890,52891,54971,52891,52858,52858,52858,50777,48665,46584,46584,46584,48665,46584,46584,44471,40278,36085,21325,8745,10858,8745,17066,14986,17066,19147,17066,19146,19179,14985,8712,6600,8680,10792,12840,10792,8647,2406,294,261,2341,6567,14952,12808,10760,12840,8679,6534,6566,6567,8647,14953,19177,15016,8646,8678,8646,6533,8549,6436,4356,2243,2276,2243,2275,2275,2243,2243,2211,2244,10727,27467,12743,4421,4388,2276,2243,2211,130,10728,42226,23339,17066,23405,25453,19179,19179,25453,23372,25453,25452,27533,21227,25421,27403,23209,25322,25322,25290,23177,23210,25258,14920,260,2275,2211,2178,2243,6469,4324,2243,4357,14856,17001,19147,10728,23373,6502,12841,21195,33841,44307,14921,4454,21293,29680,25421,27435,23144,27239,27240,27240,25224,16871,14888,14888,10695,33905,35985,31825,25486,25486,17034,52824,59131,38033,33905,44438,17001,14954,8582,10760,12808,17066,19115,44340,42227,48598,52791,56984,46353,46485,52692,44241,54806,44273,48533,54741,38030,19240,16967,44239,52593,46255,52726,54840,54707,54707,19049,10760,44470,48631,23373,35953,57050,25388,23373,57051,33840,104},
{46584,46584,46552,46552,46552,46552,46584,46585,46585,46584,44504,42424,40311,38230,31989,27797,25716,25717,27830,29943,27862,25782,25782,21621,19541,19541,19573,19574,19574,19574,21654,21654,21654,21654,23734,23766,23767,25847,25847,25847,44570,59197,59197,61277,61277,61277,61277,61277,59164,54971,54971,52890,52923,54971,52890,52890,52890,52858,50777,48665,48665,48697,46584,46552,46552,46584,44471,40245,36085,33939,15019,8745,6665,10826,17067,14986,19147,17066,17099,19147,14986,14986,15018,12905,12873,10792,12872,6599,261,261,229,229,4486,12872,14920,12840,12840,12840,10759,4389,2309,4421,8647,19177,10759,10791,8646,12871,12871,4420,4356,8549,6501,4389,4421,2340,2275,2211,2211,2211,2276,4389,8582,2276,10695,12871,2308,2275,2276,2211,4389,23372,17034,4519,17132,17099,6599,4486,10825,10793,19245,12809,14954,12906,25388,27337,21097,23242,23242,23209,21129,21097,21097,19048,4485,2340,2243,4356,17034,12808,2243,2211,2276,23341,31727,27566,27502,25486,12873,8583,16904,31727,44275,12841,4454,17066,25486,31825,29516,23112,27239,27240,25159,23111,14790,21195,19082,6502,25454,33905,27567,21292,27566,35953,50711,59164,35953,33873,25453,4421,4421,4356,4356,10761,14986,12775,40212,48566,56985,56985,61178,52627,57017,52659,48500,61112,44208,56985,50547,37933,21320,14919,42191,56951,61014,40048,42096,54707,48368,8517,19147,59131,27501,12808,52825,46420,8581,40211,59131,42293,160},
{46584,46584,46584,44504,46552,46552,46552,46552,46584,46552,44472,42391,40311,38230,31957,25717,25717,25717,27830,27894,27862,27830,27862,21621,19541,19541,19573,19574,19574,21622,21622,21654,21654,21654,23734,23734,23766,25847,27895,25815,36249,57116,59197,61277,61277,61277,61277,61277,59197,57084,57051,54971,52890,52891,54939,52890,54939,52858,50778,48665,48665,48697,46584,46552,44471,44472,44471,40278,36084,34004,29745,12906,8777,8778,10826,15018,17066,19147,19147,17098,17066,14986,12905,14985,12873,10792,10792,2406,261,261,261,229,6567,14920,14953,6566,2341,8679,10759,12808,8615,10760,19177,23338,14952,10823,8614,10694,25482,23401,8581,25385,23272,8647,17066,4453,2275,2275,2211,2211,2276,2308,163,2211,6501,17064,4421,2243,2276,2211,2276,2308,14921,8680,8712,10793,6567,2406,10793,4454,6664,4486,10761,10760,19146,16936,21162,25290,29549,29548,27403,23177,31531,25257,12774,4485,4421,4421,8582,2244,2178,2211,2276,21293,33905,31793,29712,27599,23373,10695,21065,19050,52792,23307,17001,21260,25519,44438,35887,27370,25257,25160,35660,37935,25356,38066,29614,27534,29647,42324,33872,31759,21260,50679,48598,52825,35985,29646,10662,6469,4388,6469,2275,10761,8550,10597,23243,27469,46452,59065,59032,52725,52726,50613,52758,54806,54806,56919,56886,50611,23401,16999,27497,46387,50547,29450,44175,54707,33708,6534,38131,52791,14921,31728,59164,44372,31759,57018,57116,52890,211},
{46584,46584,46552,46552,44504,44504,46552,46552,44504,44472,40343,40311,40311,38198,34038,27797,25716,23669,27862,29942,25782,25782,27862,21621,19541,19541,19573,19574,19574,21622,21622,21654,21654,21654,23734,23766,23766,25815,27895,25847,30008,46650,59164,59197,59197,59197,59197,61245,59197,59197,59164,57084,52890,52890,52890,52890,52890,52858,50777,48697,48697,50745,48665,46552,44439,44471,44471,42358,36084,33972,31891,25552,15018,12938,8778,12938,17066,17066,19147,17034,10825,14986,14986,10792,10792,12873,12873,2374,261,261,261,229,6534,14953,14953,8647,261,6534,8647,8647,6534,2341,8679,17064,17097,10791,8646,8614,12871,23402,21192,12774,4324,4389,12840,6566,2308,2308,2276,2211,2243,2244,2211,131,4421,10759,4388,2243,2276,2276,4356,6533,10793,8713,10826,8615,4454,2374,6567,6567,12906,6600,6599,4486,6567,6567,14986,18984,33840,38066,38033,27436,40047,27403,8582,4389,2275,2243,2276,2211,2211,2211,6469,21261,31793,31793,31792,29680,21325,14986,21227,25389,29680,21260,10727,23340,25518,40212,44438,23341,16969,18886,48305,48566,31727,46518,31694,46486,27533,42325,42259,48566,21195,40212,33807,42293,35953,42292,35920,40147,33807,35985,31727,35953,31727,35921,23307,29614,29613,46453,35888,27501,21129,19049,10630,8549,14888,21193,21194,29548,25450,14886,27497,40080,42095,39949,48368,52594,31596,25323,54905,44242,19048,46518,52759,27533,44438,59098,35985,40178,226},
{46585,46584,44504,44504,44504,44504,44504,44504,44504,40311,36150,36150,36150,36118,31957,25749,23637,23669,27862,32023,27862,27862,27862,23702,19541,19541,19573,19574,19574,19574,21622,21654,21654,21654,23734,23766,23766,25815,25847,25847,25847,29976,42490,50843,48730,50811,50843,55003,59164,57116,57084,57051,52890,52858,52890,52858,52858,52858,50777,48697,48697,48697,46584,44504,44471,44471,44471,42358,36084,33972,31891,29811,23438,14986,15051,12938,15019,17099,19179,14986,8712,4551,8712,10792,8712,10792,10792,2374,261,261,261,261,229,8679,17033,14953,10760,12840,10727,12840,6534,2308,4421,12839,14984,10791,8646,4453,2340,14952,40173,31626,2275,4357,23340,6566,2276,2211,2243,2211,2243,2243,2211,163,4356,4421,2340,2308,2308,2308,2308,4421,19146,17066,12808,6534,6534,6534,4421,6567,8647,8647,8615,4422,6534,6534,12841,16936,35986,38099,35953,29548,33806,25388,8550,4421,2243,2243,2244,2211,2211,4324,14889,23341,29680,29712,27566,27501,25421,14888,21195,40212,48631,27500,14856,25388,25453,33840,27567,17034,19115,25323,50484,46518,27468,42260,31694,40179,31694,38099,40113,40179,33807,38066,38001,38066,40114,38034,38001,33840,40114,35953,42259,38034,44307,40179,35952,31792,38000,35920,29516,29582,35887,29646,12743,4323,6468,8549,2276,12808,31659,14950,21224,48434,54773,54674,54674,56754,54674,54674,56755,54674,54674,54675,52594,48367,52627,54740,50449,52659,218},
{46617,46584,44504,44472,44472,44504,44504,44472,42423,40311,36118,34038,34038,31957,29877,27797,23669,23669,29910,32023,29943,27894,27894,23702,19541,19541,19541,19574,19574,21622,21654,21654,21654,21654,23734,25815,23767,25815,25847,27895,27895,27927,30008,32088,34168,32088,32088,42457,52891,52891,52923,54971,52891,52858,50810,50778,52858,50810,50745,48697,48697,48665,46584,44472,44472,44471,44471,42358,38132,36052,31891,29811,31891,23471,15018,15019,12938,17099,19179,14986,10793,6632,4519,6632,6632,8712,6599,294,261,261,261,261,196,6567,12872,10792,6534,6502,10727,21259,6566,8646,4453,8679,8711,8646,10759,8614,17064,27594,40109,42157,19112,12710,6437,2276,2276,2211,2211,195,2244,4421,163,228,2244,2276,2276,4389,2308,2308,196,8614,29646,27532,19146,17033,17001,14953,14920,14920,12840,12840,12808,12808,10727,8614,10727,18984,35954,40244,29647,19081,14953,25420,16968,6534,2275,2276,4389,4356,163,4357,4422,21293,29680,31792,21162,18918,20999,20999,18919,35921,61277,35920,25355,25355,21228,44438,42260,25421,29647,35920,29647,48631,31727,36018,40114,35986,46453,38099,46453,40147,46485,40146,44340,33808,44339,33807,40179,23373,44340,33807,42259,31694,42259,35888,42226,31726,40146,31727,38033,29613,35887,19081,23242,4323,4356,4291,2244,12808,31691,23402,35919,50448,56820,65370,61111,50612,59031,63191,52660,56885,65272,61046,61047,65239,58965,58933,63126,61013,230},
{46585,46552,44504,44472,44472,44504,44504,42423,40311,38230,36118,34037,29877,27797,29877,29877,25717,23669,29942,36184,32055,29943,27894,23702,19541,19541,19541,19573,19574,21622,21654,21654,21654,21654,23766,25815,25815,25815,25847,27895,27895,27927,30008,32056,30008,30008,29976,42489,50810,48697,48730,52890,52891,52858,48730,50778,50810,50778,50745,48697,48697,48665,46584,44472,44471,44471,44472,44439,38133,33972,31859,29811,31924,36151,19245,17066,15051,12938,19179,14986,12905,10760,8712,8712,10792,10793,8680,261,261,261,261,261,2341,14953,14920,6567,261,261,6566,8647,6566,4356,2308,8646,8678,4453,6566,2308,19176,31788,40141,35948,23337,18983,8549,2276,2276,195,10760,19179,19147,17034,12808,10760,2308,2243,2275,2308,2341,2308,10760,33806,29581,29678,29678,27597,27565,27565,27565,27533,27533,25452,25452,23372,23372,17065,6534,16904,35986,46519,25421,19081,16968,14823,6502,4389,2308,6566,25388,25355,23275,21195,19082,27566,27533,25453,19049,20999,23144,23112,21031,29582,54971,44340,33872,33840,38099,50712,42292,23341,33808,39984,29550,59196,52791,54970,50679,48631,57050,54938,59163,54937,54937,44372,57083,50712,57018,48533,54937,36017,54970,44405,52825,44340,52792,42227,50711,40146,50647,44340,46485,40146,44307,21096,33774,6371,4356,8452,6437,10695,33741,23336,21256,40109,63159,56820,42062,27435,39982,42062,23209,35821,48368,27403,35789,52594,31596,33709,56820,31694,100},
{46585,44504,44472,44472,44472,44504,44472,42391,38230,36118,34038,31957,29877,27797,29877,29877,27797,25717,29942,34136,32055,29942,27894,23702,19541,19541,19573,19574,19574,21622,21622,21654,21654,23734,23766,25815,25815,25847,25847,27895,27895,27927,30008,32088,30008,32056,38328,46617,50810,50810,50810,52890,50810,50778,48697,50778,50777,50745,48697,48665,48697,48665,46584,44504,44471,44471,46552,44471,38165,33939,31859,29811,31956,36248,34102,17099,15019,15019,15018,14986,8712,10792,10793,10793,10792,10792,10760,261,229,261,229,261,261,10792,17065,8679,2374,2341,8647,6534,10727,6534,6534,10759,10727,8646,12839,12840,25482,29675,40109,38028,29642,21128,21227,10727,2276,2276,21260,27599,27566,27566,25486,23405,14985,4388,163,6469,6533,2308,14986,40178,25387,25420,25453,21227,19146,25453,27533,29646,27565,27501,23340,23340,27501,19146,12840,19016,29581,25454,23308,33741,10760,10630,2308,4421,2340,14954,38033,35855,35887,35887,37968,35887,33774,33742,23275,16838,23112,23112,20999,25291,50744,52824,48631,48566,48566,50777,40180,29679,35920,43949,48175,61277,54937,61342,57050,63390,59131,63389,61244,61309,63357,63357,61276,59164,63357,59163,63389,59163,63389,57051,63357,59131,63357,56985,63390,57018,63390,61211,63357,59164,61244,44241,38034,8484,8484,6436,8517,6502,29613,31690,16965,40078,63191,52562,48368,50449,52562,46288,48434,50481,48368,46255,48368,48335,44175,46287,46255,39982,161},
{46584,44504,42423,44472,44472,44472,44472,42391,40311,38198,36118,34038,34038,34038,31957,29909,27829,25717,27830,32023,32023,29943,29943,23702,19541,19541,19541,19573,19574,21622,21654,21654,21654,23734,23766,25815,25815,25847,25847,25847,27895,27927,30008,30008,30008,40377,48698,52891,55003,55003,55003,52891,50810,50778,50778,50810,50778,48697,48697,48665,48665,48665,46584,46552,44472,46552,46584,46552,40245,33971,31859,31891,34070,36248,38394,27730,14986,17099,17099,14986,8680,8712,10760,12873,14953,12905,10792,293,261,261,229,261,261,4454,10792,10760,6567,4454,6566,8614,10727,8647,6534,6534,4421,8614,4421,4421,21257,23369,40077,38061,33836,29578,10694,2244,2243,2309,27599,33873,31792,29679,25486,25453,25453,10760,6502,14920,8614,4421,23372,35920,23242,21227,23308,16969,14856,16969,21227,25421,25388,23243,12808,14856,21227,21228,19147,23177,16969,16969,23275,27467,6534,14758,6437,8614,2373,23406,40113,33806,33807,33806,35919,35855,31693,33774,21162,18951,25224,25224,25192,23177,42292,52857,54905,52759,50581,48599,46518,25486,29614,58576,54513,35855,21129,40016,23210,40082,29581,42227,27469,42292,40081,46486,40147,48566,42259,50712,40147,48664,48598,52825,50712,54938,50679,54905,54905,57018,54905,54970,59164,59164,57050,50646,33742,21129,16936,16936,12710,12808,23275,33739,16966,50547,61014,52594,52594,52594,54675,52627,54707,54707,52627,54675,56787,54707,52627,56820,54707,50546,218},
{46552,44472,44472,44472,44472,44471,44472,42391,40311,40279,36118,36118,38198,38198,36118,31957,29877,25749,25749,32055,32023,29942,27862,23702,19541,19541,19541,19573,19574,19574,21622,21654,21654,23734,25815,25815,27895,25847,25815,27895,27895,27927,30008,32088,38296,48698,50810,54971,57084,57116,57084,55003,52891,50778,50778,50810,50810,50778,50777,48697,48665,48697,48665,46584,46552,46552,46584,46552,42326,36084,31859,31891,34102,36281,36313,38361,25584,14986,17099,17099,14986,10760,8712,10793,14986,14953,10792,2406,261,261,229,229,261,2374,6567,14953,12840,4486,2374,14888,14920,10759,8614,4421,2308,2308,6566,6501,21225,23369,35916,38029,25418,27562,27497,8549,2308,2276,17099,31792,29679,25453,23373,19147,21292,19147,17099,23372,19146,17098,38065,27501,23275,19146,14921,16969,21227,17001,17001,21260,21163,19082,14856,14856,12808,8647,10728,21097,12775,14824,25323,29581,10826,21064,14953,4357,8679,25519,38001,27533,27501,31662,27501,29549,27468,27500,19082,19049,23209,23177,21129,19016,19016,21194,36019,29680,19213,23308,38034,29581,41901,56463,52367,33415,31400,37608,31433,33448,35626,35495,31432,35528,31465,35560,31498,35593,31465,33481,21031,31433,27305,31465,27305,29418,27338,29386,27402,29483,21096,29516,33742,35823,25290,31695,54904,35887,23242,31726,19082,31694,16937,37934,29578,61112,63191,61079,61080,61079,58965,54773,58933,58900,52594,56787,58933,56787,54739,58933,56821,56852,224},
{44504,44472,44472,44472,44471,42423,42423,42391,40343,40311,36150,36118,38198,38230,36118,34070,29909,27797,29910,34136,32023,27862,27862,23702,19541,19541,19573,19573,19574,21622,21654,21654,21686,23766,25815,27895,27895,25847,25847,27895,27927,27927,32088,48730,52923,52923,52923,52923,57084,59164,57084,57084,57052,54971,52858,52858,52890,52890,50778,48665,48697,50745,48665,48633,46584,46584,48632,46552,42390,38132,31891,31891,34070,34201,36281,38361,40376,27567,14986,17099,14986,12873,8712,6632,8712,12873,12905,6599,261,261,229,229,261,8712,12873,14953,14921,6534,261,12840,17032,14952,8647,4356,163,196,2276,2309,23338,35948,38028,29642,4388,2276,29610,21225,6566,2308,15019,27599,27566,25454,25486,25453,21292,19212,10792,4421,6534,19179,35984,23307,23340,23308,16969,21195,21195,19114,14921,21227,23308,19082,14921,16969,16969,12840,21194,23210,17034,16936,27370,21162,2374,12743,10695,2276,12905,23373,29614,14920,17001,19049,16969,16968,16936,14856,21162,16968,16968,16968,14856,8582,6469,12742,23406,21260,4487,10696,46388,52368,60559,56464,52368,37609,39786,43914,37706,43882,41900,45929,39786,45962,44045,45995,44045,48075,39851,43914,37771,43946,39852,43914,39819,43946,41964,41833,39885,39786,35658,37640,42030,39721,31400,35659,52726,48565,33774,44372,25420,42259,21195,42161,48400,65338,65272,65305,65337,65305,65305,65337,65272,65272,65304,65272,65272,65272,63224,65272,65272,65240,250},
{46552,46552,44472,44471,42423,42391,42391,42391,40343,40311,38198,36150,36150,36150,36118,31990,27797,27829,32023,34103,29943,27862,27862,23734,19541,19541,19573,19574,19574,19574,21622,21654,23734,25814,25815,27895,27895,27895,27927,27895,27927,30007,46682,57084,55003,57084,57084,54971,55003,57084,57084,57084,57084,57084,55003,54971,54971,54971,50778,48665,50777,50777,48697,48665,48665,46584,46584,46584,42391,36084,31891,31924,34070,34201,36281,38328,42457,52858,25486,15018,15018,10793,6632,6600,8712,10792,10792,6567,261,262,261,229,261,326,10760,12872,17033,10759,2341,8614,12839,14952,12807,6501,4421,4389,2276,2309,23338,38061,38061,25418,19080,14951,35916,33868,6597,12873,27599,29679,29647,25486,25486,27599,33872,27566,31759,8614,195,14953,35952,21162,17067,19212,15019,14986,10793,19180,17067,21292,19180,19179,27500,27500,27435,25387,29580,25355,25355,25355,27435,21162,14888,17001,19114,14888,33840,40048,35919,35887,35854,33774,35854,35854,35854,33741,31661,31628,27467,25355,21194,12742,6405,12709,4357,6633,8779,23406,57051,54513,56496,58609,52367,37641,43947,41834,37673,43947,46125,43881,39754,45962,43979,45995,44045,46027,41932,45995,39851,46059,46190,45995,44012,48139,44045,46027,41932,46060,41932,46027,48336,48140,37771,39885,57018,61244,54872,59163,40147,54937,33873,52824,52595,63094,63126,63192,63192,63225,63258,63257,65272,63224,65272,65272,65272,65273,65272,65272,65305,65304,251},
{46552,46552,44472,44471,42391,42391,42391,42359,40311,40279,38198,36118,36150,36150,36118,31957,27829,25749,29910,32023,32023,27894,27894,23702,19541,19541,19541,19574,19574,19574,21622,21654,23734,25814,25815,27895,27895,27895,27927,27927,27927,44570,57084,57084,57084,59164,57084,54971,52891,55003,57051,57051,57084,59164,57084,57084,57051,55003,52858,50745,52858,52826,50777,48697,48697,48665,48632,46552,42391,36084,31891,33972,34103,34201,34233,40376,42456,57116,57050,27566,12873,12873,10793,8712,10760,10760,12873,10792,326,261,261,229,229,2374,4519,10760,17033,19146,10727,2373,10695,19048,6469,2308,4421,6534,6534,6469,23338,33868,38028,14952,27563,35948,38028,33803,4453,25519,35953,29679,27567,25486,25454,27567,29679,23405,31759,25452,8581,10695,14920,23275,15019,15051,15051,10793,8713,10858,19245,17132,17132,19180,29614,31726,31661,31660,31660,33741,31660,29580,29547,29547,29580,29548,29580,27435,31727,40113,38032,35887,35855,33774,35855,35887,35887,35855,35822,35822,33741,31628,27435,19016,10597,12709,4323,2505,9039,27566,44405,50646,52694,50548,48337,31498,35627,33579,31433,33578,31433,37706,33513,37706,37707,37641,35626,41834,35593,39753,33545,41834,41932,39721,37738,43914,41932,45994,39884,43947,39819,43946,46191,43946,37772,35855,59164,59065,59098,52791,50712,48533,46519,44209,25029,46124,56689,39949,35887,52825,61244,61244,63357,59098,63389,65437,65437,65437,63389,61178,50513,50546,220},
{44504,44504,44472,44471,42391,42391,42359,42359,40311,40278,38198,36118,34070,34038,34038,34038,29877,27797,29942,32023,32023,29975,29943,23702,19541,19541,19541,19573,19574,19574,21622,21654,23734,25814,25815,27895,27895,27927,29975,27927,38329,52891,57052,57116,59164,59164,57084,52891,52891,54971,57051,54971,57051,57084,57084,57051,57051,57051,54971,52858,54938,52858,50777,50745,50745,48697,48665,46584,44439,36084,31891,33972,34103,34201,34233,40376,42424,52923,61309,52857,19179,12873,10793,8680,6600,10793,12841,12873,4487,261,261,229,261,2374,6599,8712,12873,14953,6534,261,27404,39950,19113,12839,8581,6501,8614,6534,17065,29675,33836,10727,25482,35916,37996,40141,10758,25551,31760,35986,35986,31760,25454,25453,29679,23405,38065,27565,12807,10759,8614,19016,21227,21194,23243,16968,19114,19114,21227,19146,27533,21194,25420,29580,31628,31628,33741,33741,33741,33741,33708,33741,33773,33741,33709,31661,40146,54904,48532,31661,31661,29580,29581,31661,31693,31661,31661,21096,23112,25224,25192,18919,18951,16870,8517,6698,17165,29614,38066,50646,50613,48435,54872,59163,54971,52824,38033,54872,42064,54904,48401,54872,44340,52760,46420,50646,42129,46420,25388,44275,31629,42161,31596,40048,35789,39983,29451,37837,27338,35756,33644,33643,25257,48566,61277,56985,61276,46485,57083,52792,57050,41966,52433,56723,56754,48434,31694,50744,61309,61276,59164,61244,65502,65502,65502,63389,59065,46321,33641,46452,233},
{44472,44472,44472,44471,42391,42359,42359,42359,42391,40311,38230,36118,34038,34038,34038,31990,29909,27829,29910,29974,32023,29943,29975,23702,19541,19541,19541,19573,19574,19574,21654,21654,23734,23766,25815,27895,27895,29975,30008,30007,48730,55003,55003,57084,57116,57116,57051,52891,52858,54971,54971,54939,54971,57051,57051,57051,57051,57051,54971,54939,54938,52858,50777,48697,50745,48665,48632,46552,44439,36084,33939,33972,34070,34201,34233,40376,42424,40409,55036,61244,31792,12905,10793,10760,8680,8712,10793,12873,10760,2406,261,261,2406,4487,10760,12905,14985,8647,14985,12872,14888,31661,23275,8711,8614,6469,4421,6501,17065,25482,33868,6566,10759,31755,38029,25449,2340,29712,29647,31793,33906,35986,31792,27566,29679,21292,33839,25420,8646,12839,12840,19049,23307,21162,12743,14855,16936,12775,16936,21162,35854,31660,35919,44339,44339,44306,40080,27467,25323,23210,23242,23242,23274,23274,25355,25355,29614,46518,48598,31694,33806,33806,33774,31694,31693,31661,31629,16871,18918,23111,23112,18919,18919,18951,21162,27566,25421,35920,50712,54872,52759,42161,48599,61277,59197,52792,42292,61146,52727,61210,56821,61277,52825,61309,55003,61276,50678,59196,40277,59196,44308,61244,42195,59196,50711,61244,46452,59132,40179,59164,54905,57050,37967,52825,35822,35790,35855,33742,40081,37903,40114,31531,42064,56788,40014,29483,31694,52857,61244,61309,57018,63390,65470,63422,65503,65470,59033,52660,33708,57051,238},
{44472,44472,44472,42391,42391,42391,42359,42391,42391,40311,38198,34038,34070,36118,31957,27829,27797,27829,27862,29942,29942,29942,29942,21653,19541,19541,19573,19574,19574,21622,21622,21654,23734,23734,25815,27895,27927,30007,32088,34168,52923,57116,57052,54971,55003,55003,54971,52890,50810,50810,50810,50778,52858,54971,55003,54971,54971,54939,54938,54971,52890,52858,50777,50745,48697,46584,44504,42391,42358,36084,33971,34005,34136,34201,34233,40376,42456,38329,52923,59196,48664,14986,10793,10760,8712,8680,12873,12873,10792,4519,294,261,2439,6599,8680,12872,12872,10760,12840,12840,6599,10760,19114,8647,6534,6534,10759,8646,8646,14951,23370,8614,2340,17096,35948,33868,17031,31824,35953,12808,12841,12808,14954,21292,27566,31759,40113,25420,8678,8678,12840,31726,23306,17000,12807,12807,10727,10727,10727,21260,50646,50612,52791,61243,63259,63290,46386,31660,33708,31628,31628,29515,29515,29482,27402,27402,27435,27402,42260,33774,31694,33807,31726,29613,31694,33742,29581,21096,20999,23111,23112,18951,16871,21129,40179,35953,19147,46486,61277,56985,52759,48532,50679,52825,61277,59163,50679,46486,48566,52824,52759,54938,50744,54938,54971,57051,52824,54938,42326,57083,46518,59163,48566,59196,52759,59196,50711,59131,42227,61309,57083,57018,42226,54873,25224,23210,21064,21129,18983,21097,35985,23177,31466,54674,25319,35658,42129,52825,61276,61244,59131,65470,63422,65502,59098,52726,37967,54806,52726,61276,237},
{44472,44472,44471,42391,42391,42391,42391,42391,42391,40311,38198,36118,36150,36150,31958,25749,25749,25749,25782,25782,27862,27894,27894,21653,19541,19541,19573,19574,19574,21622,21654,21654,23734,23734,25814,25815,27895,30008,32055,36248,55003,59164,57084,52923,52891,54971,54971,52890,50810,50778,48730,48730,50778,52890,52890,52890,52858,50778,52858,52858,52858,50810,50778,50745,48665,46584,44471,40278,40245,36084,33972,34037,34168,34201,34233,40376,42424,36281,52923,59196,52858,17099,10792,6600,10760,8680,8680,10793,12873,6599,293,261,294,2438,6567,12840,10792,12872,10759,6566,2341,261,14953,14985,8647,8647,12840,6566,4453,6501,10694,8581,2308,6598,27563,40109,31722,25485,31760,21227,21228,21227,19147,19114,17002,38000,23339,12872,8678,17065,29645,31693,31726,29613,25452,25419,23339,23306,23306,25485,52791,56919,52693,48500,50613,50580,31628,23241,23209,21129,19048,21096,21129,21128,21096,21129,23241,23209,44373,38033,35887,35919,35887,33806,35854,35854,35855,33676,18886,21031,23080,18919,16838,19049,42292,38001,29614,38033,48566,56887,52726,46387,44307,42226,59164,61276,42161,21227,23373,27533,19147,25453,25421,23308,29646,25389,27502,29614,25454,31792,31760,31760,35953,33873,38066,38066,35986,40179,38066,38099,48631,57050,46420,27469,12677,12710,14758,10597,12645,14791,21129,27175,44013,52626,29515,42096,35854,36018,61277,57018,63357,65502,65470,63128,46125,31595,27402,46387,59131,61276,239},
{44472,44472,44472,42391,42391,42391,42391,42391,42391,40343,40311,38230,38230,38198,36118,31957,27829,23669,23701,23701,25782,29942,29942,23701,19541,19541,19541,19573,19573,19573,21654,21654,21654,23734,23734,25815,27927,32056,30008,36216,55003,55003,52891,52891,52858,52890,52858,50810,50778,50778,50778,48730,48698,50778,50778,50810,48697,48697,50810,50810,50778,50778,50777,48697,48697,48664,44471,42391,40245,36085,36085,36117,34135,34201,34233,40344,42424,38329,52891,57084,54970,21260,10793,8680,8680,8712,10793,10760,12841,6567,229,229,294,2406,6567,8712,6567,10760,6599,2374,2406,8679,19146,10760,4454,4421,8647,6534,2341,2276,2276,6534,2308,2341,12871,38029,25449,17031,27566,42292,42325,44405,38066,23373,14954,33839,10695,228,6501,23405,38000,21227,25485,21292,23340,25485,23339,25420,23372,25485,44372,50613,54839,52758,54806,48434,23176,19048,16936,14823,12743,12775,14855,12742,12742,14823,14823,14855,38099,48565,42226,35920,37968,42161,40081,40080,37902,37901,16805,18919,20999,18919,14726,12776,42292,44339,31695,33840,42161,56821,38066,42260,57018,56985,61244,63357,48500,21195,19147,27566,19114,23372,25453,19115,25453,19081,14953,27468,17034,21260,19081,12808,23340,21227,21227,29614,27566,25420,23307,27533,48533,48500,48500,38000,35887,35887,35887,35854,33742,12742,6404,25258,39982,54773,56820,46321,27468,25453,52857,61211,65502,63422,61014,58672,50350,16935,12710,40146,63357,61276,240},
{44471,44472,44472,44472,44471,44472,42423,42391,42391,40311,38231,36150,36150,36150,36118,31990,27797,21589,21621,23701,25782,29942,29975,23702,19541,19541,19541,19573,19573,21622,21654,21654,21654,21686,23734,25815,27927,32056,29975,30008,50811,55004,55003,52923,50810,50778,50778,48730,48730,50778,50778,50778,48697,48698,50746,48697,46585,48697,50778,50777,48697,48697,48697,48665,48697,48665,46552,44439,40278,38165,36085,36117,36150,34200,34233,38296,40376,36281,48730,59164,48664,12906,8712,4519,4520,8712,10825,8712,10760,4519,261,229,2374,2439,8712,8712,4519,8679,2406,2406,4486,8679,12872,12840,2341,4421,8614,4453,2373,2308,2308,4389,4421,4421,8678,35948,23304,17064,29712,42292,40147,35986,27534,21228,14921,38065,19114,2308,6501,8647,19114,17067,14987,6599,6632,14986,15018,17099,17099,8713,31825,52791,50645,44307,42194,42160,27403,23274,19048,19048,21161,16968,16968,16903,14855,14823,16935,16936,35986,59098,56985,54872,54839,54806,52758,54774,52660,52627,33677,16871,16903,16871,12710,6502,42324,48565,33808,29646,33807,54741,50744,57051,63390,63357,63325,61309,48533,27533,25453,33807,29614,27566,29613,21227,27566,29614,25453,29613,19081,19146,27501,21259,25453,25420,21260,29613,25420,21259,27533,40178,50646,46322,52759,52791,46485,50614,44340,48533,42226,33741,14758,21032,33675,37901,56886,35822,12808,19114,42292,63390,63389,60981,56559,56559,44044,12710,19081,52824,61277,61309,240},
{44471,44472,44472,44504,44504,44504,44472,42391,42391,40311,38198,36118,31957,34038,36118,34038,27797,23669,23669,25749,25750,29942,32023,23701,19541,19541,19573,19573,19573,19574,21654,21654,21654,23734,23734,25815,29975,30007,29975,40409,52891,57084,55003,52923,50810,48730,48730,48730,48730,50778,48698,50778,50778,48697,48697,48665,48665,48697,48697,48665,48665,48697,48665,48665,46585,48665,46552,44471,42358,38165,38197,36150,34168,34201,34233,38296,38296,38329,50843,61277,44438,10793,8712,6600,6600,8712,8712,10792,10825,4487,261,229,294,2406,6567,8679,4487,12873,8647,6599,8679,4454,8679,6534,4453,6534,8614,4454,2341,2276,196,196,4389,6501,14919,35948,23304,10694,25486,40179,35920,29646,29646,29646,19115,31760,35887,4453,4421,2308,8582,12874,12874,10793,12873,12906,14986,17099,14986,10826,17132,33938,52758,25323,21162,23307,27501,27533,21194,19081,31693,27468,27468,23307,19049,19081,21162,19049,38066,61211,56953,56952,56985,59098,59065,56887,56952,56920,46420,14855,10695,10662,6469,6502,33906,48566,40179,29646,19212,25453,50711,63325,63357,61276,59163,46518,40146,38000,33840,33872,33872,31759,33839,31791,31759,33839,31727,31726,31727,29646,31726,29614,29613,31694,27566,29646,29646,25453,27533,44307,48565,48533,59131,57051,59131,59131,57051,54937,48566,42226,35854,39950,35723,35755,42128,29515,12775,21227,50711,65535,61047,56494,54446,52399,52694,48500,52759,61244,61276,63357,240},
{44504,44504,46552,46552,46552,44504,44471,42391,40311,38230,36118,31957,29877,29877,36118,36118,29909,25749,25749,25781,25782,29943,32055,23701,19541,19541,19573,19573,19573,21622,21654,21654,21654,23734,23734,25815,27927,27895,30008,50811,54971,54971,52923,52890,50810,50778,50778,48730,50778,50778,50778,50778,50778,48697,48665,46617,46617,48697,48665,46617,46617,48665,46617,46617,48665,50777,48665,46584,42358,38197,38230,36183,34201,34201,34233,36249,36281,38329,48730,61277,52825,17066,10793,10792,8712,8713,8712,8680,8712,4487,261,261,2406,6599,4519,10792,6567,8679,10760,10760,12840,10727,12840,8646,10695,8647,8614,6534,2341,2309,8615,8614,10695,10695,21193,33803,8581,6567,31792,40179,35921,29646,35953,46485,27501,25453,33839,14984,6566,2276,4421,14987,12906,17067,12873,15019,15019,17099,19179,14987,17132,21325,50678,29549,23307,23307,25452,27500,21194,19081,27533,25355,23274,23307,14888,19081,23242,19081,29614,42226,38000,38000,38033,40114,44340,37935,29515,33676,29515,25289,25257,25257,23176,21195,33905,40179,50679,31759,17099,21293,52825,57051,61244,63325,61244,52825,54905,54872,50711,50711,50712,50679,48598,48598,46518,48566,46518,46485,44372,44372,44339,42259,40178,42226,40146,40146,38033,35953,38033,48598,48500,52824,61277,54905,59164,48533,59131,52759,48566,35920,29678,25290,23080,27402,21097,23242,10630,27468,46486,52825,54741,54446,56526,54610,61309,65470,59098,61276,61309,63357,240},
{46552,46584,46584,46585,46584,46552,44472,42391,40311,38230,36118,31957,31957,31957,36118,36118,34038,29909,27797,25781,27862,32023,32055,23701,19541,19573,19573,19573,19573,21622,21654,21654,23702,23734,23734,25815,27895,25815,32056,50843,55003,55003,54971,52891,52858,50810,50810,50810,50810,50810,50778,50778,50778,48697,46585,46585,46585,46617,46617,46584,46584,46584,46584,46584,48665,48665,50777,48665,42359,38230,38230,36216,34201,34201,34233,34233,36281,36281,46617,61277,48631,14986,10793,10793,8712,8712,4519,6600,8712,4487,262,294,2406,8680,10760,10760,8680,4486,4454,4454,8647,4519,12840,12872,8646,8646,6534,6534,2276,4389,21259,23340,23340,23339,29645,31691,6501,10728,35986,40146,35920,29614,31793,52825,29646,25453,27532,19146,4453,2276,2276,6534,12872,10727,6534,6567,8647,12841,19147,12873,17066,21227,35986,27468,19114,23242,23307,27501,19114,17001,25421,27435,21162,23274,14856,19049,19081,19081,19016,19049,21161,23275,16969,14888,17034,25290,31465,31465,29320,29320,29320,29352,35822,29613,33872,40212,48631,31759,17099,25486,48631,44437,54938,61277,61309,61277,59196,57051,54938,57051,57051,54970,57083,54970,54938,57051,54970,57051,57051,52890,57018,55003,54970,57018,52857,54937,54970,52890,57083,61244,52759,57018,61277,61244,61244,61212,61277,54938,46420,40113,29646,23242,18984,19016,16903,19016,14790,16904,19048,17000,35821,56559,56559,54708,63390,59163,59163,61276,63357,63357,240},
{44504,46584,48665,48665,46585,46552,44472,42391,40311,38230,36118,34038,31957,29877,34038,36118,34038,29909,25749,23701,25782,29975,34135,23702,19541,19573,19573,19573,19573,21622,21654,21654,21654,23734,23734,25815,25815,25815,36248,54971,57084,57116,57084,54971,52891,52890,52890,52890,52858,50810,50778,50778,48697,46617,46585,46617,46617,46585,46584,46552,46552,46552,46552,44504,44471,44504,48697,46552,42359,38230,38230,34168,34201,34201,34233,34233,36281,36281,44570,59197,50777,19179,10760,10793,8712,8712,6600,8680,10792,4519,294,294,326,4487,6567,8679,10792,10760,6599,4486,4519,6567,12872,14952,8646,6534,4453,2341,2276,2276,2276,2309,4421,8647,17032,29611,14886,2308,27599,40179,35920,29614,40212,54937,29647,27566,27565,17032,2340,2275,6469,8582,8678,6597,4421,2308,4453,4453,17033,17001,27468,29580,29548,29548,31660,33741,33741,33741,31660,31628,31661,33709,31628,31596,27435,25354,25354,27435,25322,25322,23242,25322,21129,16968,14921,27337,35626,33513,29320,29320,29320,29353,40114,44306,48532,40146,38066,29679,21292,23373,36018,50744,50776,59164,63357,61309,59163,54970,52890,57083,54938,54938,57051,54970,54970,54970,52825,54970,54971,54938,54970,50809,52890,54970,52857,54970,52857,50777,59196,61244,59196,54905,56986,59163,61212,48566,33873,42259,44339,44339,31759,33806,29516,25355,25289,25355,23306,27533,21161,6501,23242,54577,54609,56985,63358,57018,61276,61309,63389,63357,240},
{46584,46585,48665,48665,46585,46552,42423,40311,40278,38198,34037,29877,29877,29877,34038,34038,31957,29877,27829,25749,25782,32023,34136,23702,19541,19573,19573,19574,19574,21622,21654,21654,23702,23734,23766,25815,25815,23767,42489,55003,59164,57084,55003,52923,54971,50810,52891,52891,52890,52858,50810,48698,48665,48665,48697,50778,50745,46585,46585,46585,46617,46585,46552,44504,44472,46584,46584,44471,42391,38231,38231,36216,34201,34233,34233,36281,36281,38329,36281,48730,59164,38066,10792,10793,10792,8712,8680,8680,10792,6632,294,294,326,2439,326,4519,12872,8679,6599,6631,8712,14985,19145,14984,10759,6534,4454,2341,2308,2276,196,2276,2276,4421,12839,17032,27465,4388,4454,21260,27566,25421,42325,57018,35953,27566,27533,6566,4420,2276,10694,8614,6533,6597,8646,4421,4388,4453,8582,33611,44209,50645,40080,29548,21194,25420,25387,27467,27435,27467,29580,29580,29548,29548,29548,29515,29515,29515,29483,27435,27402,27402,19081,25225,27240,31433,31433,31433,31433,29352,29353,29353,46453,59163,57050,38033,38001,33807,25453,19179,36018,54938,48631,59131,61309,61276,57083,52857,52857,54970,52890,54970,54938,52825,54970,54970,52890,57051,52890,54938,55003,54970,57018,52857,50744,54970,52890,54938,61277,59164,59131,38001,54905,57018,38097,10822,19179,42259,42227,44372,40146,33807,31661,27468,29548,21129,27435,16969,19048,21064,25322,48336,54675,59164,59163,59131,61244,61309,63389,63389,240},
{46585,46585,46617,46617,46585,44504,42423,40311,38230,36150,34038,29877,29877,29909,36118,36118,31989,29877,29877,27830,27862,32055,34135,23701,19541,19573,19573,19573,19573,21622,21654,21654,23702,23734,23766,23766,23766,23734,42489,54971,55004,52891,46617,46617,50810,52891,54971,54971,52890,52890,50810,48697,48697,50778,50778,52890,50810,48697,48697,48697,48697,50745,48665,46552,46584,46617,46584,44471,42391,40311,38231,36248,34201,34233,34233,36281,36281,36281,36281,48762,57084,48632,10825,8680,8680,8712,8712,6632,10792,10792,2406,294,326,6600,4519,6599,10792,10760,6567,4486,17098,14985,19177,17065,14952,8679,6534,4453,2309,2276,2308,2276,2309,6501,10726,8646,33868,23337,21260,29646,31727,27501,44405,59131,38033,38034,29646,2341,2340,4421,10727,4421,2276,6597,10823,10792,10727,6502,19016,37869,40048,56952,61178,42160,14888,21194,23242,23307,21194,21226,23275,25387,21194,21162,19114,23307,23274,23242,25355,25387,17001,25387,21162,25224,33416,33480,31400,31400,31401,29320,29320,29320,44275,54938,54840,42226,38033,35920,23372,19179,40244,52857,50744,59163,61309,61244,54938,50777,54937,46453,42292,52857,54970,52890,52792,42292,50712,33840,25454,27599,29712,31792,33873,38066,52824,48598,46518,57051,61277,61244,46485,42292,57017,25516,15112,12999,25485,40146,35920,48533,38066,33807,35919,33840,35887,31727,33806,23275,25355,31694,35887,39983,61178,61244,56986,61276,61309,63389,63389,63389,240},
{44504,44504,46584,46585,46552,44472,42391,40311,38230,38230,36150,34070,31990,34070,36150,36118,34038,31957,29909,27829,27862,32023,32055,21653,19541,19573,19573,19573,19573,21622,21654,21654,23734,23734,23766,23766,25815,40409,50810,46650,46649,50778,44504,44504,48698,54971,57052,54971,54939,52890,52858,50778,50778,50810,52858,52890,52890,52858,50810,50778,48697,48697,46584,46552,48665,46617,46584,44472,42391,40343,38263,36248,34201,34233,34233,34233,36281,36281,34233,50875,57051,52825,19212,10792,8712,6600,8680,8712,8712,8712,6567,326,326,2407,2407,4519,8712,10792,17098,10792,17098,19178,19210,21290,10759,8647,6566,4453,4421,2308,2341,2341,2341,2341,6566,12871,27498,10727,31792,35953,33840,33808,42292,46453,33840,42259,40113,4421,163,2276,8582,4388,2276,6598,6598,6566,14954,16969,21194,29581,37968,52726,50646,46419,16968,25420,25290,29548,27436,25388,25420,27500,27500,27467,25355,27500,27468,25355,27436,25355,21129,21195,23308,35789,39819,33513,29320,29352,29353,29352,29352,29320,27370,33873,42227,44372,38033,35953,25453,21292,36018,50712,54970,54970,61309,59164,46518,42260,52792,33840,38066,50712,42293,50712,42227,33905,48598,14823,8550,10630,10630,10598,8517,17034,48598,35985,44405,59164,61244,59131,33808,54905,48564,12967,10887,23531,27565,25388,31760,48565,42226,35952,21097,10597,12678,12678,12678,10597,8517,16969,21227,19082,56952,57051,59131,61276,63357,63389,63389,63389,241},
{44472,42423,44504,44504,44472,42391,42391,40310,38230,38198,36150,34038,34038,36118,36118,34038,34038,31957,29877,25749,25781,29942,32055,21654,19541,19573,19573,19573,19573,21622,21654,21654,23734,23734,23734,23734,38329,57084,54971,46585,48730,48698,42424,44504,52891,57051,55003,54971,54971,52890,52890,52890,52890,50810,54971,54971,52891,52890,50778,48697,48665,44504,44504,46585,48665,48665,46617,46552,42423,40344,38264,34201,34233,34233,34233,36281,36281,36281,36281,52955,59164,52890,38132,17099,10760,8712,10792,10793,8712,6599,6599,358,326,326,294,294,326,17066,33872,25485,21291,17130,15049,19210,12807,8647,10727,6534,2276,2244,2276,4454,14953,17001,14953,23339,19113,10759,27599,33840,31727,31727,29646,27534,38066,44372,42193,4356,2276,4388,6501,2308,228,8679,14887,2276,12808,25387,25323,27436,23275,25323,29647,40114,14888,23275,27500,27436,27500,27468,19114,29613,25388,23274,21194,23307,25387,19049,19081,19114,19049,19146,29679,60981,58770,29483,31368,31400,29320,29320,29320,29320,25258,35986,35953,46452,38033,38033,25453,14953,19212,50744,54937,44437,61309,57018,35953,42325,52792,42292,48631,40179,38099,52857,50712,48631,54905,48599,48566,46517,44372,46453,44373,44437,48533,35953,48631,61277,61276,46453,38034,59131,54871,33966,12967,17193,31822,27500,31759,48566,44339,40113,35887,35853,35756,33709,25387,29580,23274,21162,2439,10760,29581,46485,61309,61277,63389,63389,63389,63389,241},
{42391,42391,44472,44472,42391,40311,40311,38230,38198,38198,36118,31957,31957,34038,34038,31957,29877,29877,27829,27829,25781,29942,32023,21653,19541,19573,19573,19573,19573,21622,21654,21654,23734,23734,23734,23734,42489,55003,48698,44537,48698,42456,42391,42424,52891,55003,54971,54971,54971,54971,54939,55003,57084,57051,59164,57051,52890,52858,50778,48697,46617,44504,44504,48665,48697,48697,48665,46584,42424,40344,36248,36249,34233,34233,34233,36281,36281,36313,36281,52956,61277,59164,50744,17099,10793,10793,10793,10793,12873,8712,8680,2406,326,294,294,294,294,23340,46454,42292,21323,17162,17129,12872,10759,10727,10759,6566,2308,2276,2276,2276,8583,10728,17065,23338,19113,25453,31760,38066,38033,33872,33808,25453,40179,46485,40113,21194,4453,4421,6534,2244,163,6501,19016,8550,10695,29581,27468,29516,23243,16969,21228,46485,44306,48467,50580,48499,48499,46452,40145,44339,42225,40113,38000,38032,40112,35855,27468,23242,23210,23307,31694,48402,50450,27435,29287,29288,29320,27207,29320,29288,25258,38164,50679,50646,38033,38066,29646,17034,19212,52890,44437,29712,61244,54905,42292,50712,44372,38067,50712,42292,42325,54938,55003,54970,54970,52858,54970,54970,52857,54970,52890,54938,42292,42292,54970,61277,59099,33807,50711,59131,59098,40177,19337,19306,27724,40178,40146,48598,46387,44339,44339,29483,23176,25322,21129,25354,23242,21161,6697,8680,27501,57083,61277,63357,63389,63389,63389,63389,241},
{40311,40311,40343,40311,40311,40311,40278,38198,38198,36150,36118,34037,34038,36118,36118,31957,27797,25749,25717,23669,23701,27862,32023,23701,19541,19573,19573,21621,21621,21654,21654,23702,23734,23734,23734,23734,40377,52891,52891,50810,48698,42424,40311,40343,48698,52923,55003,55003,55003,54971,54971,57051,59164,59164,59164,55003,52890,50810,50778,48697,48665,46552,46585,48697,50777,48697,48665,46552,42392,38296,36216,34201,34233,34233,34233,36281,38329,36281,36281,48763,61309,59196,36019,12873,10793,10792,10793,10793,12873,10825,8712,358,326,294,294,294,294,23340,44373,27566,14985,17130,19242,14984,12839,10727,10727,4453,2308,2276,2244,2211,196,2308,12903,12903,8614,29679,38066,33873,29679,31760,33840,23276,38034,46420,27565,12872,6533,2276,4421,2308,195,4421,23242,23210,21162,31694,25323,25355,29548,27500,25420,46452,50547,52660,52660,54773,54773,52725,54806,54805,54773,54773,54773,54773,54741,54773,44175,31563,29482,27402,25322,29581,33840,33742,39917,39884,37804,35724,35691,29385,25257,38066,48565,52758,38033,38066,33840,25453,27566,54970,31792,21325,57050,46453,35986,52825,44405,44406,48598,33873,46518,54970,52857,54938,54938,52857,54937,52825,52825,54938,52857,52824,35953,40211,59196,61277,46453,35953,57018,59098,50646,16968,10759,17065,31822,33872,48566,52791,48500,54937,59098,48336,44143,44110,42030,39950,35691,14725,16838,21162,44372,63357,61277,63389,63389,63389,63389,63389,241},
{40311,38230,40278,40278,40278,40278,38230,38198,36118,36117,34037,34038,36118,36150,38198,34038,29877,25717,21589,21589,23669,27894,32023,21621,19541,19573,19573,21621,21622,21622,21654,23702,21686,21686,23734,23767,44570,52891,52891,50778,44537,40343,40343,42424,48697,52891,54971,57084,57084,57051,57051,57084,61277,59164,57084,52891,52890,52858,50778,50777,48665,46552,46585,48665,50777,48697,46585,44504,40311,36216,36216,34201,34233,34233,36281,36281,38329,36313,36281,44602,59196,57051,25486,8712,12905,12873,10792,10760,10793,12873,10792,358,326,294,262,262,326,19147,50745,29679,6599,21259,15017,12904,14984,10759,10726,4421,2276,2244,2211,2211,131,163,10823,10758,4453,33938,38098,31727,25454,29647,33840,21195,31760,46420,23371,4485,4453,2340,2308,2244,4421,14953,23275,31662,44274,31661,19017,25388,37968,33774,33807,46452,46386,52693,48467,52726,52693,50580,50612,52758,50612,52758,50612,50613,50612,48500,42160,46321,42160,46419,33742,25485,38033,44274,58998,59064,56951,56951,50612,25322,12743,38066,46485,52726,42194,38066,35920,27566,27598,33905,8647,8647,50744,48566,44373,52792,40179,48599,50679,40179,52792,57083,54970,57051,52890,54938,57050,54970,54938,54938,52890,50679,40179,50712,61277,59131,33872,46517,61211,52726,27500,23274,25387,27501,40146,38033,50679,59064,46387,54839,59098,61178,61178,61210,61210,50580,48238,25094,33317,50483,59131,61276,63357,63389,63389,63389,63389,63389,241},
{40279,36150,38198,38230,38230,40278,38230,38198,36117,34005,31957,31957,31957,34038,36150,34070,29877,23669,21589,21589,21621,27862,29942,21621,19541,19573,19573,19573,21622,21654,21654,23702,21686,21686,21686,27927,52891,55003,52891,48698,44504,42391,42392,44504,48665,48730,50778,55003,57084,57084,57084,59164,61277,59164,54971,52890,52890,52858,50810,50810,48665,46552,44472,48665,50778,48697,46585,42424,40311,38263,36216,34201,34233,34233,36281,36281,38329,36313,36313,52923,57084,55003,35986,12873,14986,14953,12905,12905,14986,14986,12873,2439,358,326,294,294,326,8745,35921,17099,4487,29613,19177,14984,12872,12872,10727,4453,2308,2244,196,163,163,163,6501,4421,4421,27599,35953,31759,25486,38066,44340,29614,35986,42259,19178,12904,6566,2276,2308,2276,2308,10791,29614,52661,42129,33742,27403,25355,33742,31661,31662,48500,52693,52725,50612,52660,50612,52726,54839,56919,50613,52758,54871,50645,50613,50613,52693,52693,50580,52725,21227,23373,48467,54773,56885,48532,48434,42128,27467,14888,6468,18886,35823,52759,59098,59131,52727,25485,17099,12841,6567,10760,29679,29647,33905,35986,31792,33905,33905,38066,42292,42325,42325,44438,44438,46518,46518,46551,48631,46551,48664,40211,35953,52857,61277,50679,35952,50711,44339,27501,29645,46419,42226,44274,33579,33612,50613,54805,54872,61178,59130,59098,59098,61178,61145,46223,35691,18886,35561,52792,61276,61277,63389,63389,63389,63389,63389,63389,240},
{38231,34038,36118,36118,38198,40278,38198,38165,36117,34005,31925,31925,29877,31957,34038,31957,27797,21589,19541,19541,21621,25782,25814,21621,19541,19573,19573,21622,21654,21654,21654,23702,21654,21686,21686,29975,50811,54971,52891,48730,44504,42424,44472,46585,48665,46617,48698,57084,59164,57116,57084,59196,61277,59197,54971,52890,52858,50778,50810,50777,48697,46584,46552,50778,50810,48697,44537,42424,40311,38264,36248,34201,34233,36281,36281,36313,36313,36313,40441,50810,48698,48697,33906,10793,12873,14954,15018,19179,17066,14986,12841,2406,2406,2438,326,262,294,6631,19115,10793,8680,46451,31756,19177,12840,10759,12872,6534,2308,2308,2244,2244,2276,2244,163,163,4421,10760,31792,27567,23341,35986,52857,33873,33906,35953,19146,15018,12873,4389,4421,2276,196,4453,31727,42064,27435,42161,37967,38000,52661,50613,44242,54871,59065,61145,59065,59031,58999,59097,61178,59065,56952,58999,59064,56853,54805,56886,58966,56886,56886,54773,19114,21228,52726,52660,52692,50514,46320,46353,35821,14855,2340,14660,27338,52791,61277,63357,59066,29614,19147,21260,12808,14921,14953,10760,14954,6534,12841,12808,10728,14921,8583,14953,14986,17034,19147,17066,12808,14953,14986,12840,19147,19147,23340,33873,54938,31694,33872,50678,27500,33839,48532,42226,44339,46289,33383,25061,27239,37837,44307,40114,44372,40015,25387,40048,60916,48271,23079,25192,44210,59163,61276,63357,63389,63389,63389,63389,63389,63389,242},
{40343,36150,36118,36118,38230,40278,38198,36117,36085,34005,31925,31957,31925,29877,25749,25749,23669,21589,19541,19541,21621,25782,25782,19573,19573,19573,19573,21622,21654,21654,21654,21654,23702,21654,21654,34136,50843,55003,46617,42424,42424,42391,42423,46585,46585,44504,50810,57116,59164,59164,57084,59164,59197,59164,52891,50778,48665,48697,50778,46585,46552,44504,46585,50778,50778,46617,40377,38296,38264,36248,36248,34201,34233,36281,36281,36313,36313,40442,52891,42424,36183,36117,15019,10825,12906,12905,14986,19147,17034,14986,10793,2406,326,2439,326,294,2406,4487,4487,2374,12840,33870,31821,19209,10759,14952,12871,4453,2276,2276,2244,2244,2244,2244,2276,2308,2276,6534,29679,23340,21260,36051,50744,35953,35986,31759,8679,2373,4454,6534,4421,2276,2276,4421,19081,31596,35757,40016,35757,35856,52694,50581,52629,42193,38000,37968,37936,37935,37968,37936,40048,37967,38000,37968,38000,38000,40080,40048,40080,40048,35887,35887,17034,21260,48500,44273,48433,46353,40047,46353,35821,8549,260,12645,25160,52792,61277,63325,59098,35920,29711,27598,25453,23340,25453,21292,23340,19147,19147,19179,19147,19147,14953,19147,21259,19179,21259,19146,12840,19146,19146,12808,14921,14953,21226,21227,25420,17033,19113,35920,42226,52726,42193,44339,54807,62834,52172,29385,25192,18951,16805,23210,48566,44306,29547,44175,62996,40048,38001,46452,42292,61244,61277,63389,63389,63389,63389,63389,63389,63389,242},
{44472,40311,38230,40278,40311,40278,38198,38165,36085,34005,31957,31925,29877,27797,19508,19540,21589,23637,19541,19541,21621,23702,23702,19573,19573,19573,19573,21654,21654,21654,21654,21654,23702,25782,29943,36184,44537,48698,42456,42424,42424,40278,40311,44504,44504,44504,50810,57116,59164,59164,57116,57052,57051,57051,52890,46585,46552,48697,48697,50777,50778,48697,46585,48697,48697,44537,36249,36248,36248,34200,36248,34233,34233,36281,36313,36314,36314,46715,54971,40343,34070,36117,15019,10793,17066,14954,12873,17034,17098,17066,12873,358,358,2407,326,294,326,8712,12873,17066,25451,29710,23404,17097,8647,12840,12872,6566,2308,196,2244,2276,2276,2243,2308,2308,196,12841,38099,27534,27566,40212,48599,29679,29679,25420,4486,2340,2308,2340,4421,2308,4453,6566,4389,16968,27436,42194,27338,25355,31629,29516,31661,25388,21097,14824,16936,14856,12710,12710,14823,12678,14823,10630,12711,8517,8550,8550,6469,6469,4356,6533,10792,14889,16936,19049,19048,27402,25322,21096,8582,6501,2308,6501,20967,52825,63325,59131,48566,35953,25518,25486,27631,25518,25486,21292,23372,23373,21292,21260,21259,21292,23372,23340,23372,23340,25420,23372,17033,19179,23372,17033,17066,21291,25419,23338,19113,19177,19112,31725,44371,54871,50612,50678,56789,64752,58837,42259,31629,21097,23144,25322,55003,48566,42063,46224,46321,35855,23210,33742,50679,61277,61309,63389,63389,63389,63389,63389,63389,63389,240},
{44504,42423,42391,42391,42359,40278,38198,38165,34037,31957,31925,31925,29845,23636,19508,19508,23669,21589,19541,19541,21589,23701,23702,19573,19541,19573,21621,21622,21654,21654,21654,21654,23734,34103,42456,42424,42424,40343,42392,44504,44504,40311,40311,46584,44504,44504,46617,52891,55003,57084,55003,54971,54971,57051,54971,48665,46617,50778,48665,48697,50778,50778,46617,48665,48665,42457,36249,36216,36216,34200,34201,34233,36281,36281,36313,36314,38394,46617,36183,34070,34070,29810,10825,10825,14986,14986,10793,14986,19179,17066,12905,2439,326,2407,326,326,294,15084,44438,40114,29676,25517,19212,17097,10792,14952,12872,10759,4421,2308,2308,2373,2341,2276,2276,2276,2276,17067,33938,31760,29647,31760,23341,17067,31792,19114,2308,2340,2340,4421,4453,2276,6533,8678,6534,10727,31629,29614,23210,35855,44209,33677,25322,23210,19016,16904,14855,12743,12710,10630,10630,8550,8550,6469,6469,4357,4389,4357,4324,2276,2276,12838,14952,10727,10695,8550,6437,10662,8517,6437,4357,8615,2308,4421,16773,31760,48631,52825,48598,40146,19147,17066,23340,17066,23341,14953,17066,19147,14986,19147,12841,17066,19114,17034,21195,12841,21227,17066,14921,17034,14953,12808,12840,19146,25451,27530,21193,21257,23337,42258,46418,52726,54872,56952,60722,64752,56724,42063,27239,20933,22981,33742,55003,33774,18885,18886,38001,38000,25290,18885,48599,63389,63357,63389,63389,63389,63389,63389,63389,63389,223},
{44504,44472,42391,42391,40278,40278,38198,36117,34005,31924,31924,29877,27797,21588,19508,21589,21621,21589,19541,19541,19541,21621,23702,21621,19573,21621,21622,21622,21622,21654,21654,21654,23702,32023,42456,46585,44504,42424,44504,44504,42424,40311,42423,46584,46584,44504,42424,46585,48697,48697,50778,52858,54971,57084,57084,52858,48698,48665,44472,44504,46585,46585,46617,50810,48697,40409,34233,36248,36216,34201,34201,34233,36281,36281,36314,36314,38329,34070,34037,34038,34038,36118,17132,10825,12873,14986,12873,12873,17098,17066,10825,4519,326,359,2407,359,326,326,25617,40210,33934,37967,29548,17130,14952,23275,12840,12872,6566,2341,2308,2341,2341,2276,2244,2244,2276,2341,4486,25486,29679,29647,25453,27534,35953,8614,4421,2373,2341,2308,4421,2340,2308,2308,2341,4389,21162,27468,27436,25388,35790,18951,12678,19017,33905,35888,29581,35854,37935,23241,10662,12840,19082,23275,19114,16969,14888,12775,10663,10662,10695,17000,12872,8647,6502,4389,4389,6469,6437,4356,2309,10728,6436,2340,14693,17033,40212,57018,61276,46452,19147,19147,23340,14953,23340,19147,17066,19179,10760,19147,17001,19114,17034,10728,19147,14921,19147,14953,10728,14953,14921,12840,10727,12808,19113,25450,19112,14952,25419,48533,50613,44242,48533,37838,58446,64752,60657,50287,31400,23013,27174,31532,42357,44241,35789,44175,44240,40014,37902,44175,61244,63389,63389,63389,63389,63389,63389,63389,63389,63357,198},
{44504,44472,42423,42359,40278,38198,38165,36085,34005,31924,29844,27764,25716,21588,19508,19508,21589,19509,17461,19541,19541,21621,23701,21621,21621,21621,21622,21654,21654,21654,21654,21654,21654,29943,42424,46617,46585,44536,46585,42424,40311,40311,44504,46585,46585,44504,42423,42424,44504,44504,46617,54971,57084,57116,55003,52890,50778,48665,44504,42424,42424,44536,48665,50778,46617,38329,34201,34201,34201,34201,34233,34233,36281,36314,36314,36313,38263,36118,34070,34037,34070,34005,17132,10825,10825,12905,17066,12873,10793,14986,14953,6600,326,2439,358,2407,358,326,2439,27598,36014,35854,21162,19210,25451,27566,19113,10759,4453,2308,2308,2308,2308,2276,2308,2341,2341,4453,2341,6567,29712,27566,33873,38033,29581,10727,4453,4453,2373,2308,2340,4421,4421,2340,4453,4421,6534,25356,27501,31661,37870,27403,27370,33742,48599,48566,31662,27436,27468,27435,27500,31694,33839,35888,33807,33807,33807,31726,31726,31694,31726,29581,16968,12775,4421,4389,4356,4324,2244,2244,2244,10728,12677,2340,12709,14985,38099,54938,59163,52726,19114,12873,23373,19147,23373,17066,12841,21259,14954,21227,14953,12841,21227,14921,21227,12840,14921,19114,12841,14921,17034,12808,12808,12808,14953,21257,23338,14952,31725,40113,42128,42129,48534,35693,50060,64752,58544,52367,37673,27207,29287,27272,35887,48500,27435,46255,48368,46255,42094,52758,63390,63389,63389,63389,63389,63389,63389,63389,63389,59098,174},
{46552,44504,42423,42359,40278,38198,36117,34037,34005,31924,27796,25716,23636,21588,19508,19540,21589,19541,19509,19541,21589,21621,23701,21621,19573,23701,27862,29910,27862,23702,21654,21654,23702,32023,44537,46617,46585,44537,44504,42391,40311,42391,44504,48665,46617,44472,42423,42423,44504,46585,48697,54971,59164,57084,57051,52858,48698,46617,42456,40376,38296,44505,46617,48697,46617,38329,34201,34201,34201,34233,34233,34233,36281,36314,36314,36313,38263,36150,34069,34037,34069,34069,29778,17099,10857,8745,12905,17066,14953,12873,14986,2439,326,326,326,294,294,294,2407,19211,33901,31726,17034,31726,23339,17131,29613,8679,4453,2341,2341,2341,2308,2276,2308,4389,4421,2276,2308,260,12874,33905,33873,31759,38001,10662,2308,4421,2308,2276,2340,2308,2308,4388,8646,8646,4389,14888,19082,40048,33742,33774,33742,31629,29516,31597,33741,31596,33709,31628,44307,25420,27501,29614,29614,27533,27533,27533,29581,27533,27533,17001,10695,19048,16935,12743,4356,2276,4356,2243,2211,10728,14693,8484,12710,14855,33840,54970,61211,56953,33807,29679,31792,31792,31759,29646,27534,29646,27566,27566,25420,23340,25485,23404,25453,21227,21227,25420,21292,17033,19147,19114,17001,21227,23306,19112,21258,17000,35919,33806,37838,46388,50614,42162,39658,60559,46224,56561,46028,25126,25094,22981,37935,52726,35887,37901,42095,46255,42095,52792,63390,63389,63389,63389,63389,63389,63389,63389,63357,50711,169},
{46552,44472,44471,42391,40310,38230,36117,36085,34005,31925,27796,25716,21556,21556,19508,19508,19541,19541,19541,19541,21589,21621,21653,21621,19573,25750,34103,36151,29942,23702,21654,21654,25782,34135,48665,48698,48665,46585,44504,44472,44471,44472,46584,48665,46585,44472,42424,44472,44504,46585,48697,52891,57084,57116,55003,50810,46617,44537,40377,34200,34169,36249,40409,44537,44537,40377,34201,34201,34201,34233,34233,36281,36281,36248,36216,38296,40343,36150,34037,34069,36118,36118,36150,17132,8745,10793,12905,19146,17066,12873,12905,6632,358,326,358,358,294,262,326,19212,19178,29613,14921,12938,35951,38063,27565,12872,10727,4421,2341,4421,2341,2308,2308,2341,4453,2308,4454,4421,6567,19212,23406,23405,10760,2276,2276,2373,2373,2308,2340,2373,2308,196,2276,6533,19081,31661,16969,29549,29549,31662,31629,29548,29516,29549,33774,27403,31629,25225,29418,23080,25258,27370,23145,23177,25290,25257,25258,25258,25290,16903,12710,18983,18983,16903,10597,6437,6404,4291,2243,8647,10565,20967,14920,14790,31630,57018,61276,61211,42259,38099,50744,42324,50711,42260,38066,50711,44405,48631,38099,36051,48598,46453,50646,38066,42292,48598,42324,35952,19114,12873,12808,17001,27565,40144,29643,29612,31726,29580,31467,50582,52727,48501,33612,37676,35823,56561,52367,39983,40015,35757,40048,52694,38000,31660,46288,46288,37967,44340,63390,63357,63389,63389,63389,63389,63357,63389,59131,46453,169},
{44504,44472,44472,44439,42391,40310,40278,38165,34005,31925,27764,25716,21556,19508,19508,17460,17460,19509,21621,19541,19541,21621,21653,21621,21621,29942,34070,34103,32023,25782,21654,21654,25782,40344,50778,50778,50778,48698,48665,46585,44504,44504,44504,46584,46552,44472,44472,42424,44504,44504,46617,50810,57051,57051,52891,48730,46649,44537,38329,32121,32121,34201,36249,38329,40409,38329,34201,34201,34201,36281,36281,36281,38296,36183,38231,38231,38263,36150,34069,34037,36150,36118,36150,23439,8713,6665,12906,21227,14954,14986,10792,6632,359,358,326,294,294,262,294,8712,8712,23406,17034,2438,19178,40176,29677,14920,12839,6566,2308,2341,2308,2341,4453,2341,6534,6598,6598,6598,4421,2373,4421,6566,4453,2341,4421,4421,2340,2340,2373,2341,2308,228,2308,8647,31662,42161,14856,27436,27468,31629,31629,27435,25322,25290,29581,23242,27468,18886,22949,25029,33611,33644,20901,23046,29353,27272,25159,25159,23079,23047,23046,25127,25159,27272,23079,20966,18886,16773,6404,6567,14693,21130,21324,16805,27371,54970,61276,57050,42260,46453,46486,33873,52792,42292,42324,44437,31825,50712,42260,44405,44405,38099,52792,38098,44470,46486,40212,48565,31661,23275,23274,19017,31793,40179,25483,31724,31791,19343,33612,54677,50646,50646,42161,27436,27501,50319,54709,63390,65503,50646,39983,48532,35887,33741,46321,42160,42127,46517,63390,63357,63357,63389,63389,63357,63389,61276,50679,44373,166},
{44472,44472,44472,44471,44439,42359,40278,38166,34037,31925,27764,25716,23636,19508,19508,17460,17460,19541,21621,19541,19541,21621,21621,21621,23701,32022,29910,27862,27862,23734,21654,23734,25814,40376,50778,52890,52858,50810,50778,48665,46584,44504,44504,46584,44504,42423,44472,42424,44472,44504,46585,50810,52858,48697,44537,44537,42489,40409,38329,38329,36249,36249,38296,40376,42457,38329,36249,36249,44570,48697,42424,40344,38263,38263,40311,38263,38263,38230,36117,36118,40343,38230,38230,33971,8745,4584,10858,21259,17066,14953,10793,8712,4552,2439,326,262,294,294,326,10858,21260,10826,17034,6566,4519,27597,33936,25387,10759,6566,2341,196,2244,4421,12775,10759,8679,6598,12871,12904,8712,10793,8712,6534,2276,2244,2308,4486,2341,2308,2341,2276,4389,2308,4453,8678,27469,35887,21162,37968,33774,33742,37902,37935,37967,31628,35855,33742,33709,39852,37706,33480,33677,35790,18853,18886,18918,18918,16838,16838,16806,14725,16838,18886,16806,18886,16805,14725,14725,12645,6372,6502,12645,14726,10760,31367,35627,52890,61244,54872,31727,42325,48566,40212,50711,31760,44437,48533,42259,48566,33873,48631,44372,42325,46486,33905,50744,44372,44405,54774,54773,54741,56822,31629,40212,21227,17032,48564,31823,23405,48337,60853,52695,48566,44340,33710,33807,42128,59164,63422,63390,61277,52563,46387,48500,31596,44240,48499,48499,40080,52889,63390,63357,63357,63357,63389,63357,48598,44405,44372,181},
{44471,44472,44471,44439,42391,40311,38230,38166,34037,31925,29844,25716,21588,19508,19508,17460,17460,17461,19541,19541,19541,21621,21621,21621,21621,27862,25782,21654,21654,21654,21654,21654,27862,42424,50778,52890,52890,50810,50778,48697,46585,44504,44504,44504,44472,42391,42423,42391,42391,42391,44504,50778,48697,44537,42457,42489,44537,42457,42457,44537,40409,40376,40376,40376,40376,38296,36249,36281,42489,48730,48697,48697,44504,44504,42424,42423,40343,40310,38198,38231,38231,36150,36150,36150,15051,2472,2504,19179,19179,17066,10793,4551,10793,6599,326,294,294,326,261,4519,10825,10858,8745,6567,10760,25420,46387,40113,21194,8614,4453,2308,2276,4421,10695,19080,17032,4356,8646,10823,10759,4453,2308,4421,4453,2340,2308,2341,4421,2341,2308,2276,2244,2244,8614,6533,17002,42227,48500,61179,59130,59098,61146,61146,61211,52694,59098,59065,56952,33742,18886,25030,25258,31564,18854,20966,18886,18886,18886,18886,20966,20966,20966,20966,16806,16773,16806,16806,14725,14725,8484,6469,12742,10532,4356,10564,14823,48632,61212,50679,38066,50712,38066,40212,50711,42227,50711,35953,40212,48598,40179,48631,35953,46518,48534,42292,50679,40179,50679,54741,54741,54741,50548,23307,44372,12775,16936,46452,50677,48370,56659,58772,56757,46388,50679,44144,40048,44373,59196,52857,44373,46486,50580,50613,50613,50580,54773,56886,59065,44241,44339,63389,63357,63357,63357,63389,54904,40179,44405,44405,201},
{44472,44471,44471,42391,42359,38230,38198,36118,34037,29845,25716,21556,21556,19508,19508,17460,17460,17461,17461,19541,19541,19541,19573,19573,21621,25782,23702,21622,21654,21654,21654,21654,34103,44537,48698,50810,50778,50746,48697,46617,44504,44472,44504,44472,42391,42391,42391,42391,40311,40311,42424,48698,50810,48698,46617,46617,46649,46617,44537,44537,44504,42424,40376,40343,38296,38264,36248,38329,50811,52890,52891,54971,52890,50778,46585,44504,42423,40343,40310,36150,34069,34070,36118,36182,21358,4552,2472,10825,19146,14986,8712,6600,6600,4551,326,294,326,2439,326,4519,10858,25551,21422,6599,12840,31695,52792,38000,19146,10695,6566,4421,4453,2341,6534,14920,10694,2276,4453,12903,6534,2276,2243,4421,4453,2308,2308,2308,4421,4421,2341,2276,4421,2308,10727,23274,19049,44275,42162,46387,46420,50613,50614,48533,46420,52694,56953,52759,54872,37968,16838,25030,31532,35887,31564,33742,31596,33709,31629,31596,21097,12710,16969,14823,12678,10598,8517,8517,10598,12710,4324,6437,14758,10500,8452,8420,10565,42325,61212,42259,33872,52824,42292,48631,40179,33906,52792,40179,48631,38034,40179,52791,42259,52792,35953,44405,54937,48631,52759,54741,54741,56822,40016,27599,42259,31694,33807,46485,56952,54579,58740,58740,56659,44308,59163,46289,54513,46355,50744,44372,23275,33742,40080,50613,48500,61145,63291,63291,58999,56854,58999,61212,61309,63357,63389,57050,37967,42292,44405,50712,212},
{44504,44472,44471,42391,40311,38230,38198,36085,31957,27764,21556,21556,21556,21556,19508,17460,17461,17461,17461,19541,19541,19541,19573,19573,21621,23702,21622,21622,21654,21654,21654,21654,34103,40344,42456,44537,44537,44537,46584,44504,42424,42424,44504,42391,42391,42391,42423,42391,40311,40311,42424,48698,50810,50810,48730,48730,50778,48697,46585,46617,46585,44472,42391,42359,40310,38263,36248,40409,54971,57051,57084,59164,57051,52890,48665,44504,42424,42423,40311,38230,36150,36118,36118,36150,33972,10858,2504,6633,17066,12905,8712,6600,2407,2439,358,326,6631,10792,326,6600,4519,12938,25584,6664,6599,35888,42227,35887,29547,14952,6566,6566,6534,4453,4453,10759,6598,4485,4485,12871,6566,4389,196,2276,2340,2276,196,2308,4421,4453,4453,2340,2341,2341,21260,48402,37870,40016,42162,52693,48500,52726,54807,52693,44274,50548,56952,52759,56920,44274,31466,37707,37935,50482,56690,56690,52497,48304,41997,27305,12645,10565,10565,8485,8485,6437,6404,6404,6404,4324,4324,10500,14660,12515,12515,12515,10499,38067,59131,50744,50712,55003,54970,57051,50744,52824,57083,57051,57018,50679,52824,57083,57050,54970,44438,50712,48664,50711,52693,54709,54709,54741,25355,40180,19082,6469,6470,48566,52661,52466,58740,58740,52531,52890,61244,48337,54480,44144,48500,54839,44241,44307,48500,48468,52693,63226,63258,63291,58933,58966,61079,61145,61244,63389,63357,42226,35854,44372,44372,48631,213},
{46552,44472,44439,44439,42391,40278,38198,36117,31925,27764,25684,23636,23636,21556,19508,17460,17461,17461,17461,19541,19541,19541,21621,21621,21621,21622,21621,21622,21654,21654,21654,21686,29943,32023,29975,34135,36216,40344,42424,42391,42391,42424,42391,42359,42359,42391,44472,42423,40343,40311,42424,48697,50778,50778,48698,48730,50778,50778,48665,46617,46552,44439,42359,40278,38198,38231,36248,42489,54971,57084,59196,59196,57084,54971,50778,46617,44504,42391,42423,46584,44504,40311,36150,36150,36117,12938,6665,6665,14986,12905,8680,2439,4519,6600,2406,358,4519,8712,2439,4519,2406,6632,27664,10792,12841,46485,46485,50581,48401,17097,10759,6566,6534,4421,2341,12871,10823,14984,12839,10823,12936,6598,195,196,2276,2341,2341,2340,2308,4389,6534,4421,2308,2341,25420,50581,54741,38000,37968,44274,48468,46387,48500,50516,52661,54806,52726,52629,52694,46354,35626,39852,39950,29451,23177,23210,16871,8518,6437,4324,4324,6437,6437,4291,4259,4292,4291,4291,2211,2211,2211,6339,6307,8387,10467,8387,8387,31728,57051,52890,54970,57051,54970,59131,57083,57051,54938,50744,54970,57083,57051,54971,52857,52857,50777,48631,40212,40178,52628,52628,52661,50483,21195,40146,16968,12808,10662,44339,33774,35757,58740,56692,48435,54970,59164,46256,54577,58803,60883,60916,54610,44274,48500,46419,59032,63291,63291,63323,63225,63192,63192,58966,59098,63389,54904,35920,42194,44372,44372,52857,214},
{44472,44471,44471,44471,42391,40311,38198,36117,31957,27796,27764,25684,23636,19508,17460,17460,17461,17461,17461,19541,19541,19541,19573,19573,21621,21621,19573,21622,21654,21654,21654,21654,23734,23734,25815,29943,32023,36183,40311,40311,40343,42391,42391,42359,42359,42423,44472,42424,40343,40343,42456,46649,48730,48698,48698,50778,50778,48697,46585,44504,44439,40310,40278,38197,36117,38231,38264,44569,54971,57084,57084,59164,57084,54971,50778,46585,42423,40311,42391,46617,48697,42423,38230,38198,40343,21358,8745,12906,17066,12905,10792,8680,4519,2439,326,294,326,6599,6567,6567,326,4551,19212,12938,12872,31760,48566,40146,35887,14952,10759,8614,6534,2308,10662,14920,12871,12904,14952,10759,8711,4485,2309,2308,2276,2341,2373,2276,4389,6533,6501,4389,2341,2341,12872,33775,42161,25388,35822,40015,44209,46355,42161,42129,44274,46355,46354,46322,44274,48467,48435,46452,42227,21031,18951,12645,8517,8485,4356,4324,4324,4389,4357,2211,2211,2243,2243,2243,2211,2211,2211,2179,2178,6306,6306,6307,4226,23308,54970,54937,54938,54970,54938,52889,44470,44405,42357,46518,48696,44470,46518,44470,46518,44438,40211,36018,29744,35953,54741,54709,54741,40048,14921,25420,25420,23307,21227,35920,23242,25323,48306,52434,40147,61277,48533,52693,58868,60949,48303,31498,21064,38000,48500,44241,44273,52693,50645,52725,52725,54871,52724,44305,48598,57018,46485,38000,42259,42292,46550,54970,213},
{44472,44472,44504,44472,42391,40278,36150,36118,34005,29844,25716,23636,21556,19476,17428,17460,17461,17461,17461,19541,19541,19541,19541,19573,19573,19573,19573,21622,21654,21654,21654,21654,21686,23734,23734,25814,32055,40311,40311,42392,42391,42391,42359,42359,42391,44472,44472,42391,42391,42391,42424,44537,44537,46617,48698,48698,48697,48697,46552,44471,40310,38198,36117,36084,36085,38231,38296,38361,40409,46617,52891,57116,57051,52890,48697,44504,42391,40310,44504,50777,50777,44504,38230,38198,40343,27697,10825,12906,19147,14985,10825,8712,4519,2407,358,294,8745,10825,8680,6599,2406,6632,21325,10825,8712,31759,44503,35920,27501,10759,8647,6502,6566,2341,6469,6469,17000,12839,10759,17064,17064,6534,2341,2341,2341,2373,2373,2308,2308,4421,4421,2276,2276,2308,2341,2373,4421,4421,8615,29614,42194,40081,31629,16904,18984,40114,37903,27403,27436,21065,21097,40147,46387,46158,41965,21032,14791,12678,10597,10565,8517,8517,8549,6372,6372,6404,6404,4324,4324,4291,4291,2211,2178,4226,4258,4226,2178,10696,23438,23504,27632,38099,36018,29679,25518,25518,25486,27566,27599,27566,27566,25518,27599,27599,27566,25518,23373,29646,44242,44242,46322,23275,14986,23308,27501,31628,31563,35788,31595,29482,31596,44242,52727,59033,46421,50712,44339,48533,25127,16773,16838,40146,48533,33708,16902,29449,21063,23176,21095,27500,44240,40111,25451,29613,35953,35920,40114,42292,52857,54938,212},
{44504,44504,44504,44472,42391,38230,36150,34037,31957,29844,25716,23636,19508,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19573,21621,21654,21622,21654,21654,21654,21654,21686,23734,23734,27895,38263,38263,40311,42424,42391,42391,40311,42391,44472,44504,44504,42391,42391,42391,42424,44537,42457,44537,44537,44537,44537,44536,44472,42359,38198,36117,36084,34004,36085,38263,38329,36281,38296,42424,50810,57084,57084,52858,46617,44472,42391,40310,42423,42391,46584,42391,40278,38198,40311,25552,8745,10793,19147,14953,10793,6599,4551,4519,4519,4551,19212,25452,12873,10793,4487,4551,4519,6599,8680,38001,48729,35985,27402,17000,12840,8679,10727,4421,2309,6534,8582,10727,17064,21257,12903,6566,228,196,196,228,2308,2276,2243,2340,2340,2308,228,2308,6566,6534,6501,6534,6566,23308,27534,21228,23243,25323,23210,29614,21130,12678,12678,8517,8518,33841,39950,37772,37837,23144,14823,14790,14790,12677,12645,12677,10565,10565,8517,10565,10565,8517,8485,6404,6404,6404,4323,2211,2243,2211,2178,2178,2439,11121,19376,46583,54904,21227,14954,17034,14986,14986,12905,12905,12873,12873,12873,10793,10793,10760,14953,19049,16936,16936,14856,4421,6469,12840,38000,39981,39916,39948,39981,39948,35787,38000,54546,62899,37869,21290,21226,31531,25094,25094,23078,35855,37935,44273,52724,52724,52660,50612,50612,48466,44207,38031,29645,40146,50711,33807,38033,48631,54970,54970,210},
{46552,46552,46552,44472,40311,38230,36118,34005,31925,27796,23636,19508,17428,17428,17460,17460,17461,17461,17461,19541,19541,19541,19541,19573,19573,21621,21654,21654,21654,21654,21654,21654,23734,23734,27895,36183,40312,38263,40344,42424,42391,40311,40278,42391,44472,46584,46552,44471,42391,42391,42392,42456,40409,40409,40409,42489,44504,44472,42391,40278,38165,36084,34004,34004,36117,40377,42489,44569,44537,42456,46617,48697,50778,46584,44504,44472,42391,42391,40310,40311,44504,42391,40311,38230,38230,23439,12938,10826,19179,17066,10792,6599,6632,6632,6599,8680,6632,19178,14953,10761,8680,4519,10858,27598,10793,33775,44372,36050,56756,19113,10727,10759,10759,6566,6502,6501,4421,8582,21193,21257,23337,17097,4453,2276,196,2276,2276,2341,196,2276,2373,2373,4421,6566,14953,12839,10727,12742,10760,35921,31694,29613,31695,35789,27436,23308,27403,23080,12678,10565,6404,29647,33546,27273,14888,16903,16903,16936,16968,18983,19016,19017,18984,19016,14855,16903,14823,16936,12710,14823,14791,14823,23275,12710,12710,12710,14823,10597,10727,8615,21293,44438,50678,12872,14954,14986,14986,14986,14953,12905,12873,12873,12873,10793,10760,8680,12841,14888,14824,14824,10695,4389,163,21227,44307,37836,37836,39981,42061,39981,39949,48337,60884,65012,44109,10758,23176,33545,29287,27174,27207,31596,54839,63290,65371,65371,65371,65372,63323,50546,42159,35950,25418,14919,23340,27566,42259,54938,54938,54938,175},
{46617,46617,46584,42391,40279,38198,34037,31925,29844,25716,21556,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19573,19573,21622,21622,21654,21654,21654,21654,23734,25814,34135,40344,40312,38263,42424,42424,42391,40278,38230,42391,44504,46585,46585,44504,42423,42391,42391,42457,42489,42490,42457,44537,42424,40311,38165,36117,36085,34004,34004,34004,34037,40344,46650,46617,46617,44504,42424,42424,44472,44504,44472,42423,42423,44504,44504,46584,44504,40343,40311,40343,34004,19310,17165,10858,17099,23340,12873,10760,10760,10792,6599,2439,294,15017,25388,29516,14889,326,15084,25583,10825,21194,50645,31825,33807,27468,4454,6534,8647,8647,8679,6534,2341,8647,21225,19177,23370,21258,14985,6567,6599,6599,2308,2308,2276,2308,2341,6566,10760,10792,21324,10759,10694,16968,17033,48599,42227,31760,35953,44307,27566,25356,25257,27371,31564,29451,25322,38001,58835,35790,14856,20999,21031,14823,14823,21031,23177,21129,27436,23112,18983,14823,12710,20999,16871,14823,14823,23079,23210,12710,16871,20999,12743,14790,10695,10662,4487,19180,35951,10759,14954,17066,17066,17034,14954,14954,12905,12905,12873,10793,10793,10793,10760,10728,8582,6437,6502,6534,6502,38033,46452,44175,37835,39981,42061,39981,44142,60884,62997,62997,52530,16999,39885,41965,27207,27207,27239,29450,52726,54839,48500,46419,54806,56952,54839,52660,56952,48532,23336,21257,19080,27501,38034,52825,54970,52792,153},
{48665,48665,46584,42391,40278,38198,34037,31925,29844,25684,19476,17428,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,19541,19573,19573,19573,21622,21622,21654,21654,21654,21654,25782,29975,38296,42424,40344,40344,42456,42424,40311,38230,40278,42424,46585,48665,48665,46584,44471,42423,42391,42424,42457,42457,44537,46617,42424,38230,36085,34004,36085,36052,34004,34004,36085,38231,44504,46617,46617,44537,44536,44504,44504,44504,44504,44472,42391,44504,48697,48697,44504,40311,40343,44472,36085,19311,19278,10858,12906,12873,10792,14986,12840,12905,10792,2406,326,21323,23371,25388,17034,4487,4552,8744,10858,23308,48433,25453,31725,23307,8614,8614,8614,8614,8646,8646,4453,12872,27531,25418,23403,23338,10727,2276,2244,2341,2341,260,2340,2276,2276,4421,6567,6567,21324,21323,12840,17065,27533,46421,35921,33841,42293,21260,19180,19082,12710,8583,27468,44242,42128,35855,39983,23340,14888,14790,16871,21129,19016,16903,16871,12710,23210,21064,18951,14823,12742,14758,14790,14823,14823,16839,16904,12710,14791,21064,12743,12677,10727,14953,4389,14921,23339,14986,17066,19147,17099,17067,14986,14986,14953,12905,12905,12873,12873,10793,10793,10760,8647,8615,6501,4421,23275,44340,46420,44273,44175,48335,37836,35756,37804,56658,63029,63030,58804,35788,50287,54512,33578,23046,25158,23111,40146,46420,27467,18984,35822,46387,46387,52759,61244,57050,37966,38064,29645,27501,31727,44405,54970,52825,161},
{48665,48665,46552,42391,40311,38230,36118,31957,29877,25716,17428,17428,17428,17428,17460,17460,17460,17493,19541,19541,19541,19541,19541,19573,19573,19573,21622,21654,21654,21654,21654,21654,27895,36183,40344,42424,42424,42424,42424,42391,40311,40278,40310,44472,48697,50778,50745,46617,44504,42423,42424,44504,46617,50778,48697,44504,40278,36117,36117,36117,36085,34004,34004,34004,36084,38198,46617,48730,48697,46617,44536,44504,46584,46584,46584,44472,46617,52890,52890,50778,46584,40311,42391,44504,40278,21359,8844,8746,12873,14986,10793,4519,4487,19210,17097,2374,294,12937,10825,27501,25421,6568,2438,2439,2439,33708,54740,56985,48468,35953,14952,6566,6502,6534,4453,6534,6534,14984,21290,21290,25451,19177,8678,2308,2308,4454,4486,4454,4454,6534,6534,4453,228,2341,15017,23468,31759,12840,23177,48500,40048,38002,44340,19049,12678,25290,31499,31596,35724,41966,42096,19049,19049,21227,33806,37934,37934,37966,40047,35821,33709,31660,31628,31628,31628,29548,29548,29515,29483,29547,31595,27435,31596,29482,29482,29515,29483,27402,21194,23339,8550,25388,23340,17132,17066,17099,19147,17099,17066,17066,14986,14986,14953,12905,12873,12873,10793,10793,10760,10760,6534,12775,35854,42194,42193,42129,44209,37805,14758,10565,10565,46224,65110,63030,60916,44046,54448,56528,52432,31498,31563,31498,35920,46485,31661,18984,27467,46354,46387,50581,54872,52758,54904,46418,37999,23275,29614,33807,44372,46486,121},
{48665,48665,46584,44472,42391,40311,38198,34005,29877,23636,19508,17428,17428,17428,17460,17461,19509,19541,19541,19541,19541,19541,19541,19573,19573,19573,19574,21622,21654,21654,21654,21654,27895,38264,40344,42456,44504,44504,42424,40343,40311,40278,40310,42423,50746,52858,50810,48697,46552,44471,42424,46617,52858,54971,48697,40310,36085,36117,38230,38198,36085,36052,34004,34004,36085,40311,50778,52890,50778,48697,46585,46585,46585,44536,44504,42423,48730,57083,54971,50810,48665,42391,42391,46617,46584,13070,490,8778,12906,12873,6600,4519,327,12937,19178,2406,2374,8712,10825,29679,27501,14954,2406,4584,12873,10759,33871,42193,46387,46387,27434,14952,8647,8614,4453,4453,6534,10791,21354,19241,25483,17097,10727,163,2276,2374,4454,4454,4389,4454,6535,4486,2308,196,14953,25581,29646,8582,19017,44275,40113,35921,42259,25355,31499,42030,48272,48272,48174,48174,44144,25387,29614,27534,54806,56950,56918,56918,54838,54838,54838,54838,54838,54838,54870,54870,56918,56918,54870,56918,56918,56950,56950,56950,59031,59064,59096,56951,50612,33806,12775,23275,19147,17099,14954,17066,17099,17099,17066,14986,14986,14986,14954,14953,12905,12905,12873,10793,10760,8647,6534,25387,40113,42226,42227,37902,16838,14725,14757,12645,10532,37805,65110,65077,58739,50287,56527,58576,58576,48435,57084,59130,37935,46453,35920,12775,19049,42161,48468,50580,50580,54839,59131,42062,48434,29646,27566,37967,33740,27500,73},
{48665,48665,46584,44472,42391,42391,38198,34037,29877,23636,19508,17428,17428,17460,17460,17460,19541,19541,19541,19541,19541,19541,19541,19573,19573,19573,19574,21622,21654,21654,21654,27863,38264,40344,36183,42424,44536,44504,44472,42391,40311,40311,40343,44504,50746,52858,52858,50777,46584,42423,42424,50778,54971,55003,52890,42423,38165,36085,38198,38198,36117,36084,34004,36084,38198,42424,52858,52890,48730,48697,46617,46585,46584,44504,44504,42423,48730,57051,52890,50777,46584,42391,42423,46585,25585,522,555,6730,12906,12905,6632,6600,2407,12937,21290,6567,4519,12905,27566,35920,25518,25421,8680,4519,14985,8679,23404,35854,23340,39983,46221,25515,12872,19081,12775,4485,8711,10791,15049,21290,27531,17129,12839,2340,2276,2308,2341,2341,195,228,2341,2308,2308,2276,12904,23404,19114,8582,16969,42096,40080,46322,46485,33808,23177,25290,27338,27305,23080,23080,33742,33807,25421,25421,48532,56951,56951,56951,56951,56951,56951,56951,56951,56983,56951,56951,59031,59031,59031,59031,59063,59064,59064,61144,56951,50645,42193,33741,21129,14855,10597,21130,10760,12873,19179,19179,19179,17099,19147,17067,17066,17066,15018,14986,14954,14954,12905,12873,12873,10728,12808,40114,42227,23307,35985,40048,33708,40014,42094,40013,39949,46191,62997,54545,46126,46094,50254,56495,52335,21162,25486,42259,29483,44373,40146,14855,16936,40047,46386,50580,52661,61244,46452,37901,35855,38001,31759,44306,35788,21160,93},
{48665,46585,46584,44504,44472,42391,36118,31957,27797,21556,19476,17428,17428,17460,17460,19541,21589,19541,19541,19541,19541,19541,19541,19573,19573,19573,21622,21622,21654,21654,23734,29975,42424,38264,36215,44504,44536,44504,44472,44472,42391,42391,44472,46585,50778,52858,52858,48697,46584,44472,44504,52890,57051,54971,50810,42424,38198,36085,36085,36085,36085,36084,34004,34004,40343,48697,50778,48730,48698,48698,48665,46585,44536,44504,42424,42391,48697,52890,52858,50777,46584,44504,46584,29811,2603,2603,4683,10891,14986,12905,10793,6632,4519,17098,23370,6567,2406,8712,33775,40081,23374,29549,21228,12906,17066,12905,15018,42259,27566,33741,46287,29675,12872,25387,21096,10759,10823,8711,12904,12872,15016,21257,21289,8678,2340,2373,6567,6567,6567,6567,4454,2276,2309,2341,19146,25421,17033,6533,31564,41901,19017,21097,21162,16969,2341,8582,8517,8517,10597,8549,33841,29646,19179,21227,29581,35854,37934,37935,37935,37967,37967,37999,37967,38000,37935,40080,42161,42193,44273,42160,46386,48499,46419,40080,27467,21193,19081,23273,8549,8550,12775,17002,10760,14954,19212,19147,19179,17099,19147,17099,17099,17066,17066,14986,14986,14954,12905,12873,12873,10760,27468,44307,48500,23275,31661,42128,33740,40046,44207,44174,42094,44142,56658,48304,35692,39820,50254,54415,46126,33872,40179,23275,19016,40179,42259,21162,16936,40015,44274,50580,54806,61244,48435,35789,31661,40048,27468,46387,50645,48466,190},
{46585,46585,46585,46584,44504,40311,36118,31957,25716,19508,17428,17428,17428,17428,19509,21589,19541,19541,19541,19541,19541,19541,19573,19573,19573,19573,21622,21654,21654,21654,25814,32055,38264,38264,42424,44536,46585,46584,46552,44504,44471,42424,44504,46617,50778,50810,50778,48697,46585,44504,46585,54971,55003,50810,46585,40311,36085,33972,34004,34004,34004,34004,33972,31924,36150,42456,48697,48698,48697,48697,48665,46585,46584,44504,42391,40343,46617,52858,52858,50777,46584,48665,36085,4683,2603,4715,6763,6763,10858,10825,12905,10793,6600,17098,19210,2406,2406,8744,29711,38034,29679,35888,29549,25453,19179,8679,12905,46551,50679,44340,33838,33869,12904,12872,12904,10791,8711,10856,8711,8743,12904,17065,23370,10758,4453,196,2276,6405,4324,4389,10662,4421,2308,2341,21195,27534,23340,8614,41901,46061,12743,4356,6437,6437,2309,6437,6405,6404,6469,8550,25421,27533,23340,25420,29483,39950,41998,39885,37869,44111,39917,39950,44143,46224,46223,41998,44143,48304,46256,44175,35756,29483,25225,14790,12710,12710,10630,4422,8647,12808,14921,12938,8680,17099,21293,12905,14986,17066,17099,17066,17066,14986,17066,14986,14986,14954,12905,12873,12905,14921,29581,40113,52759,42193,50613,46354,37934,37933,42127,42094,42094,42062,44176,52432,39852,48141,54415,54415,50287,27533,42325,27566,12743,35921,44405,27468,12743,42161,48467,50580,59131,48467,49961,33579,40080,48434,25322,44339,59032,44273,196},
{46617,48665,48665,46617,46552,40311,36118,31957,25716,21556,17428,17428,17428,17460,19508,19509,19509,17493,19541,19541,19541,19541,19573,19573,21621,19573,21622,21654,21654,21654,25814,34103,34103,36183,44537,46617,48697,48665,46584,44504,44472,42424,46584,48697,48697,48697,48697,48665,46585,44504,46585,52891,48697,44472,40311,36117,31924,31891,31892,31924,31924,31891,31891,31892,34037,38231,46649,50810,48698,48697,48665,46617,46585,44504,42391,40343,48665,52890,50778,52858,48665,42391,8909,523,2603,4683,2603,522,8778,10825,12905,12873,10793,15018,19178,8679,2374,6599,25421,25356,29646,40081,29549,19147,12905,10792,12905,31890,50679,42194,25451,29742,10791,6566,12872,12937,10791,12904,17097,10791,4486,8711,21257,14951,8646,6469,4356,14726,8517,2341,6534,4421,16968,10727,14953,23373,27598,31629,46224,35757,10663,6437,8550,6437,2244,6469,6437,8517,8517,8485,17034,31759,25421,29613,39950,48337,50417,39950,42095,48336,48304,44241,52596,54676,54642,37902,54675,56788,52563,33774,18919,12710,10630,8582,10630,10598,8517,261,6567,10728,14921,10760,14953,19180,19180,2308,10760,17099,14986,15018,17067,15018,15018,14986,14986,12905,12873,12873,10792,10760,25388,39949,44242,50613,50646,46387,40048,37901,42126,44142,44174,42062,42063,52432,46190,39820,54415,54415,52367,40081,31629,29483,25224,33774,44405,31694,10662,40081,52660,56919,59131,45931,62541,56755,54738,52595,35691,40146,54806,42160,166},
{48665,48665,48665,48665,46584,42391,36118,29877,25716,19508,17428,17428,17428,17460,17460,17461,17461,17461,19541,19541,19541,19573,19573,21621,21654,21622,21622,21654,21654,21654,23734,25814,29975,42457,50778,50810,50810,48697,46585,46552,44472,44472,46585,48698,50778,48665,46585,46584,46584,44504,42423,42424,40343,40311,38198,34004,31892,29811,29779,29811,31891,31891,31891,31891,34037,38198,44504,50778,48730,48697,48697,44536,42424,42424,42424,42391,46617,52858,50810,52858,48665,19311,522,555,6763,6763,4651,4650,8778,10825,10825,12873,10793,10793,8712,6567,4519,8680,25388,25388,29582,29679,23373,10761,2374,6631,14985,19243,38099,31694,31726,27565,19178,10792,10824,8711,8647,21323,19243,15017,17065,8646,12839,14983,10759,23242,10663,14726,6437,2341,4421,8615,21260,14953,10793,21260,44405,46290,39983,8615,12743,10630,10630,8517,4357,8550,8549,8549,8517,10662,21260,27566,21260,31693,39982,48369,52530,35789,48402,54675,52529,35822,50482,54610,46256,25323,31596,27370,16904,10663,12678,12710,12743,10663,10597,10597,6404,293,4389,8615,17001,14986,21292,21325,12873,163,6502,2374,2374,2374,2374,2374,2374,2374,2407,2439,2342,2341,2309,4421,23307,52594,44142,25258,44339,46420,42161,35854,40047,39982,37934,31627,39982,50384,48304,35659,54415,54447,54448,41998,23079,27239,27239,29451,42292,38033,14888,38032,54773,57018,35855,49766,56464,54803,50546,52660,52497,44308,44241,48499,121},
{48665,48665,48665,46617,44504,40343,36150,29877,21556,19508,19508,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,19541,19573,21622,21622,21622,21622,21654,21654,21654,21654,23734,40376,50778,52890,52890,52858,50778,48665,46584,44472,44472,44504,46617,46617,46584,46552,44504,44504,42391,40311,38198,38198,38198,34037,31892,29811,27731,27730,29779,29811,29811,29811,31859,36085,38230,42424,48730,50778,50778,48665,42424,44504,44504,42424,42391,46584,52858,50778,52858,42326,6763,2603,4683,4683,2603,2603,4683,8745,10825,12906,12873,8712,12873,12873,10792,8679,12873,23341,21260,23340,27697,27632,17034,10793,2374,2406,14986,38000,37935,44307,38000,19178,14985,19210,15049,8711,10791,17129,10791,8678,6566,6501,14983,25418,27435,12775,14726,12645,8517,10696,12841,17099,14954,8712,17066,40179,44274,44209,6470,12743,10630,10630,8517,4357,6437,8550,10695,12808,10695,21227,31693,25420,33774,48337,50449,52529,46256,52595,54675,50450,46256,46257,29451,14790,8647,6730,10630,8517,8517,8517,8550,10598,8517,8485,8517,4324,261,6534,8582,12808,16968,27533,19212,4389,2276,4357,196,163,163,163,163,131,131,261,391,4324,4259,164,2276,29581,48467,42194,21161,42194,48533,50579,48499,50579,50580,48499,48434,52627,46223,46256,33611,52335,54480,52432,39787,23046,25159,27271,27305,42259,40146,23274,37935,56887,31793,25030,64654,52563,46287,48435,48499,44209,40146,46420,37967,125},
{46552,46584,46585,46584,44472,40311,34070,25716,21556,21588,21556,19508,17428,17460,17460,17461,17461,17461,19541,19541,19541,19573,23702,23702,21622,21622,21622,21622,21654,27862,29943,32023,44537,50778,52890,52891,52858,50778,50745,46617,44504,44472,44504,44504,44472,44504,44504,44504,42424,42359,38198,36085,36085,36085,33972,29811,27763,27730,27730,27730,29811,29811,29811,31891,36085,38230,42424,50778,52858,48697,46585,46585,46617,46585,44504,42423,44504,50778,48697,46584,17198,8811,6763,6731,2602,522,2570,4650,8778,8745,10825,10825,8712,12905,14985,10824,4486,14986,23340,10824,19211,38034,29647,19212,17099,8679,2374,12938,44339,27468,35855,42160,19178,14952,25452,23436,6598,6566,25387,21258,12872,8646,6501,6534,17033,25387,21064,27273,27273,21032,10696,8648,12873,17034,10760,17066,31726,44307,40081,23341,19016,14790,14823,14791,6469,10663,14823,21228,17328,8875,4552,12905,25485,35854,46322,48369,44176,44176,50450,48370,48402,46224,23144,10598,14791,8745,2634,8615,10662,8550,8517,8517,6437,6469,6469,6437,2276,4389,12808,12743,21096,23208,19082,10793,4324,4389,163,196,131,163,131,131,130,196,4520,8745,16903,21031,8582,8582,17001,46453,48533,23242,40081,54806,65404,65437,65436,65437,63258,61079,56886,46224,48304,37804,48206,54480,52432,52432,31433,25159,27271,25224,40114,42259,29548,35854,52759,19084,47784,48110,35855,48466,48435,44306,42193,40049,44339,33774,160},
{42423,42424,44472,44472,42391,38231,34005,27797,23636,21556,19508,19508,17460,17460,17460,17461,17461,17461,19541,19541,19541,19541,21621,21622,21622,21622,21622,19574,27862,38263,42424,46585,48665,48730,52858,52890,52858,50810,50778,48665,44504,44504,44472,42424,42391,44472,44472,42424,42391,40278,36117,34004,34004,31924,31892,29811,27731,27730,27730,27730,29779,29779,31859,31924,34004,38230,42424,52890,52890,46617,46585,48697,48697,48697,46617,44504,44504,48697,50777,29778,10859,10924,8843,4651,6731,8811,6731,12972,15019,12906,10793,6632,8680,14953,25451,17033,6567,23373,29646,10792,15018,33807,27566,19278,21293,6599,10760,15018,29743,17033,25420,33806,29676,23371,38001,27598,8679,10791,29581,23372,17097,8678,10727,12839,8647,27564,31466,33546,31466,21064,8680,10793,19147,25453,23242,23307,31662,38001,46159,25421,31596,33644,33644,31596,16936,29483,33709,42292,23536,17295,4650,424,23438,31726,27534,25388,33611,33546,37869,33611,35756,35659,33579,33514,35756,33675,15018,25289,31530,33546,33611,33546,31531,31465,31661,29613,29613,31694,33806,31661,31693,33774,27500,29613,29580,25387,25387,25387,23307,23274,21194,21161,19048,17033,23339,19113,12840,21031,25192,18951,12840,40114,46419,25257,35757,48304,52497,50417,50482,46289,54741,63225,59130,46289,48304,41965,44013,52367,54513,56593,50319,29385,33578,27271,33775,42259,37968,38000,42358,15054,48143,42096,25388,44306,50580,48500,23242,29581,44339,35887,158},
{40311,38230,40279,40279,40311,36150,31957,29845,25716,21588,19508,19508,19508,17460,17460,17461,17461,17461,19541,19541,19541,19573,19573,19573,19574,19573,25782,34135,38264,42424,44537,50778,50778,50778,50778,52858,52890,50810,50778,48665,46584,44504,42424,42391,42391,42391,42391,42391,40310,38165,36085,31924,31924,31892,29843,29811,27730,27698,27730,27730,27730,27698,29811,34004,36117,38230,42456,54971,54971,46617,48697,48697,48697,50778,46585,46552,44504,46617,44472,19245,12972,10923,15084,15084,12972,13004,13004,15052,12972,15051,12905,10793,10793,8712,23403,31792,33775,35921,23406,12872,29646,33971,27696,15019,19212,14986,19082,12873,27565,33872,19146,33806,33869,25484,35953,25453,12872,12840,17066,14985,6598,228,4486,17000,8582,23338,37773,31499,29289,23177,8680,10793,19147,23373,23177,25290,40016,25356,54513,37903,31596,33676,31563,23177,14856,23209,33710,44405,27664,15149,6730,2504,12939,29646,31727,29614,33807,35855,33806,35822,35855,33774,35887,35919,35920,35920,23340,33774,38000,38033,38000,40080,38000,40048,40081,40113,38032,38065,35920,35919,35920,38033,35920,35919,33839,35919,33839,33839,35919,33807,35887,35887,33806,33806,33774,27532,14920,21129,25322,21129,12808,33807,46420,37934,29254,29222,27142,25061,23014,39917,61112,63291,54969,42127,48271,48206,39852,54447,58608,56560,54480,50581,61244,33611,27436,44340,35822,44373,25651,19346,33842,46387,42227,48532,48533,40080,29515,23243,42194,38000,159},
{38198,38198,36118,34038,38198,36118,29877,27797,23668,21588,21556,19508,19508,17460,17460,17461,17461,19541,19541,19541,19541,19573,19573,21621,21622,29943,40376,44537,44505,44537,48698,50810,52890,50810,50778,52858,52890,50810,50777,48697,46585,44504,44472,42391,42391,42391,42391,42359,40310,36117,34037,31924,31892,31892,29811,27731,27730,27698,27698,27730,27730,27698,29779,34004,38197,38230,46585,57052,52891,46617,48665,46617,48730,48665,46552,44504,44504,46585,36084,15052,15084,15052,15052,17132,15084,13004,15052,15052,15052,12971,15019,12873,8712,8712,21291,29678,40081,40179,33970,31855,25452,21358,25584,21325,15019,21293,25388,19114,29712,50679,27532,29644,31692,27403,19082,19114,27533,14920,10792,25419,17193,6598,2341,163,8679,27467,33547,14791,18822,14856,8647,12873,21260,25453,21031,27305,37903,21065,44210,46387,25322,27435,27435,27468,21259,37967,33807,35985,21227,6632,2537,359,6665,10760,16968,8517,21129,29320,35692,33578,37772,37674,33676,35886,33806,31726,29580,31726,31726,33839,35919,38000,33774,33839,33839,35887,33774,33807,33774,35822,35855,35887,35887,33807,33774,33774,31694,31661,31694,33774,35855,35887,35887,35887,33774,29580,21161,29580,31693,29548,12775,27501,44339,40047,16806,27174,23079,23014,42095,63127,63160,59162,50709,48466,41965,46158,41965,39885,58576,54513,52497,59131,63390,35821,25257,42226,44307,40278,19378,21426,46451,46321,48500,54807,37968,16935,21129,19082,40081,44339,168},
{38198,38198,36118,31957,31957,31957,29845,25716,23636,21556,19508,19508,19508,17460,17461,17461,17461,19541,19541,19541,19573,19573,19573,19573,29943,50810,50778,48698,46617,46617,48698,52891,52923,52890,50810,50810,50810,50778,50777,48697,48665,46585,46552,44471,42391,42391,42391,42359,40310,38197,36085,33972,31892,31891,29811,27730,27698,27698,27698,27730,27730,29778,29811,34004,38198,40278,44537,54971,52858,44504,48697,48698,48697,46585,42423,44472,46552,44504,27665,13004,15084,12972,15052,13004,15084,15052,12971,15052,15084,15084,12971,12938,10825,8680,14985,40179,44274,35888,38065,35983,29646,25421,25486,23471,8713,14987,37936,17001,19212,46452,29613,40080,37936,50581,42129,29614,37967,14887,8679,19114,14984,10726,196,2309,6535,25354,33611,23112,4324,4421,8680,12841,17035,31727,39917,46256,42194,31466,33676,35822,27402,25322,33709,35855,25388,50580,33774,31662,23242,8647,6632,359,14986,10695,12775,6437,16936,23047,27370,25192,27337,27272,23209,25419,23306,23306,25387,25355,23274,25355,27468,29613,21194,21194,21193,21193,19081,21193,21129,25225,27403,27337,27402,27305,27370,25225,23177,25192,25225,29385,29418,29352,27337,29353,31466,29320,25224,27240,27337,27240,12775,21227,42226,46354,39982,42030,42030,42062,58966,61046,61178,54936,52693,50580,44208,46224,48304,37935,41965,56887,56953,59131,57018,52727,50646,50646,48599,27765,17363,25618,44273,52726,56920,44340,16969,12743,14823,14888,31662,50646,181},
{38198,38198,36118,31957,29845,27764,23636,23636,21588,21556,21556,21588,19508,17460,17460,17461,17493,19541,19541,19541,19541,19573,19573,21654,44569,54971,52891,50778,48730,48730,48730,52890,52891,52891,50810,50778,50778,50778,50778,50778,50746,48665,46584,44472,44471,44471,42423,42391,40310,38197,36085,33972,31892,31891,29811,27730,27698,27698,27698,27730,29778,29811,31891,36117,40278,40310,42391,50810,48697,46617,50810,50810,48697,46584,44472,46552,46584,42423,23439,12972,13004,13004,10923,13004,12972,15084,15084,15084,15052,15084,15052,15019,10793,10760,17066,44340,33710,31662,38032,23404,27501,19212,25519,19213,8647,17066,29614,17034,25518,50678,29646,35887,37936,44242,48534,35888,33774,17065,23371,10695,10695,2308,4421,4486,4454,12872,6535,4389,2244,6534,10728,12873,19147,31759,44175,52628,50613,33610,29385,27468,44307,46387,33774,21227,29516,50646,42193,29646,19081,6469,8712,359,12808,6469,14856,4324,16936,8484,16936,8452,16903,12677,19016,10565,16968,10565,19016,14790,16935,12743,16968,8550,17001,14888,17001,8517,16936,14888,14888,10695,19049,16968,21161,16968,19049,16969,19016,16936,19048,16903,18984,14855,16968,14856,16936,14888,16903,10597,14790,10597,10662,17001,50612,63225,65338,63290,65338,63192,61080,61112,57082,52789,52693,48499,46354,48304,52432,31629,31727,48599,38066,52824,56986,63357,65503,65470,50745,17429,17396,35986,37967,52759,54872,17035,4389,8549,12710,10662,25323,46452,197},
{36118,38198,36150,34037,31925,25684,19476,19476,19476,19508,21588,23637,19508,17460,19508,19541,19541,19541,19541,19541,19541,19573,19541,36216,54971,55003,52923,50810,50810,52891,50778,52890,54971,52891,52858,50778,50746,50778,50778,50778,50778,50745,46585,44504,44472,44472,44471,42391,40311,38197,36084,33972,31891,31891,29811,27730,27698,27698,27698,27730,29778,31891,34004,40278,42358,42359,42424,52890,52890,52858,50810,50778,50778,46585,46552,48665,46584,42391,27632,12972,10891,10924,15052,13004,13004,15052,13004,15052,15084,17164,17164,15052,14986,10793,12906,40050,37969,40082,38000,31726,19146,10825,21358,21326,21098,27501,33873,25454,31759,38164,40244,37935,40114,38066,44373,37936,35953,27599,25421,19081,14953,2308,2373,6566,8679,19113,12808,6502,2244,6535,8615,10825,19179,38066,44240,44176,50579,31563,8582,23275,52759,63324,38000,8615,27403,54872,46484,33839,33807,29646,29646,29647,31726,29646,31726,29581,31694,27468,29613,27468,29613,27500,29613,25420,29614,25388,21195,19114,25420,23275,27533,23275,19179,14986,27468,23242,27468,25420,27500,23274,29581,25388,29580,25388,27500,23307,27500,21194,27435,21194,25387,21162,27468,19114,23307,21162,23274,14856,21194,14856,19081,25323,59064,65338,63290,63290,63225,61111,61079,59130,52822,54806,50613,48467,44274,48304,52432,40048,42325,48599,38098,46453,61277,63422,63422,61277,34039,15349,23572,40114,40048,52726,42293,8714,2244,6404,16968,21162,19082,44340,205},
{31957,36118,36118,34037,31957,25716,21556,19508,19476,19508,21588,23637,21589,21589,25717,25782,21621,19541,19541,19541,19541,21621,38296,54971,57052,54971,50810,50778,50810,50778,50810,52923,54971,52891,50810,50746,48697,50746,50778,50777,50777,50778,48665,46584,44504,44472,44471,42391,40311,38197,36084,33972,31891,31891,29811,27730,27730,27730,27698,27698,29778,31891,36084,40310,42359,42391,44504,52891,54971,52891,50810,50778,50745,46584,46584,48697,46617,40343,29778,15052,10892,8811,8843,10891,13004,15084,13004,15084,17164,17164,15084,10923,15051,8680,10859,31695,33840,42162,44274,46322,33904,6664,10858,21260,23243,35856,31760,17100,23371,23437,46420,46354,46355,31728,44306,48435,46453,33905,25453,25420,12841,17033,23274,6501,8679,23209,18984,10695,8517,8615,12841,14954,19212,40212,54676,44209,46322,37934,10726,21260,44307,56953,33774,12840,29646,50679,48565,35919,35920,35952,35952,35953,33840,35952,38001,38001,35920,35920,33839,35920,33872,33872,33839,33839,33807,35920,25486,23405,31694,33807,33839,33840,27631,23405,27566,31759,29678,31759,31759,31759,33839,35952,33839,35920,33807,33806,33807,31726,31726,33839,33839,35920,38033,35952,38000,35920,35952,35952,35952,35952,35887,35919,42193,42161,40080,35887,29516,29548,35920,35919,38032,56919,50612,48467,46387,46256,52432,42030,29679,50712,27469,48599,65503,63422,63357,44439,21558,17397,38132,46354,46354,46388,29779,17166,12743,12742,14823,25322,21162,42162,183},
{25684,29877,31957,34005,31957,27764,21556,19508,19476,19476,21556,23637,25749,29910,34070,29942,25749,21621,19541,19541,19541,21654,46650,57084,55003,50810,50778,50810,50778,50810,52923,54971,54971,54939,52858,50810,48697,48697,50777,50777,50778,50778,48697,46585,46584,44504,44472,42391,40311,38198,36085,34004,33972,31891,29811,27698,27698,27698,27698,27698,29778,31923,36085,40278,42358,42391,44537,52891,50810,52891,50778,50810,50810,48665,46584,48697,48665,40310,19311,17132,12972,4683,522,522,6763,13004,10923,6763,4683,6763,8843,8843,10858,6600,17197,31662,23276,38001,40016,40016,19212,2439,21358,19245,29614,29614,10793,10696,19210,23405,46355,42128,46224,44208,42160,37903,27534,27599,27533,17033,6534,27468,27467,4389,2244,4356,10631,14824,14790,12743,8647,12905,19147,42292,50548,35856,54806,42161,19113,17066,44471,54839,31726,17034,46452,50614,48597,35919,35919,33839,35887,35888,33839,35920,35920,35920,31727,31531,33676,33676,35789,33676,33644,31661,31661,33709,27468,17067,21194,21259,19212,13004,21489,10956,6795,8909,6860,4813,4813,4813,4781,6893,6861,8941,8909,8908,10989,8908,10956,13004,13037,15117,17198,17197,17197,17197,19245,19245,21357,21325,19245,19212,17099,15018,10825,12840,8583,8614,21227,31758,27500,54806,50580,46387,42193,35822,52432,50319,31760,44438,52824,63390,63422,61277,35920,25652,17430,21491,44273,48433,46419,38100,21393,31825,25355,16968,14823,16871,21161,31694,159},
{21555,25684,29844,29845,27797,23636,19476,17428,17428,17428,19476,21588,23669,27829,31990,29910,27830,23669,19541,19541,19573,19541,29975,52891,52891,50810,50843,52923,50810,50778,52890,52891,54971,52890,52858,52858,50778,50778,50810,50778,50778,50810,50778,48697,48665,46585,46552,44471,42359,40278,36085,34004,33972,31891,29811,29778,27698,27698,27698,27698,27730,33972,38198,42391,44471,44472,44537,50778,50810,50810,52891,52890,52858,48697,48665,48665,48665,36117,15085,17132,17165,10924,6763,522,2603,4683,4651,522,2602,4683,6763,4683,6665,6632,15052,29647,19179,19277,29679,35856,21194,14986,31792,23536,27534,14953,8615,14824,12936,19211,40081,40146,50581,54872,54772,48434,44275,27601,31727,19049,12808,40146,29581,8582,196,2276,16936,19017,16806,12710,6501,8615,17066,44373,48436,29615,40048,52694,27566,27599,42390,56887,40048,39983,50679,52759,59131,57018,54904,52824,40308,52824,56985,56985,54937,56985,33938,33416,37674,37706,42029,37674,37641,23144,21130,25355,14987,13036,8713,10826,12938,6665,11021,17262,12971,15084,8843,620,2765,2765,620,652,684,652,685,652,685,685,2765,652,2733,652,652,652,652,620,619,652,2732,587,521,489,457,457,392,8680,16806,10630,19146,33840,23339,50613,50612,44339,31563,33610,50351,52530,31759,44438,63390,63422,57083,25453,14856,23507,17397,17068,35756,54674,42195,27699,19312,52857,31694,16935,14855,12742,19016,25355,211},
{27764,31925,29877,23636,19508,19476,17428,17428,17428,17428,17428,19508,23669,27829,27830,21621,21589,19541,19541,19573,19573,19541,32055,50810,52891,52891,52923,54971,52923,50810,52858,52890,52891,52890,52858,52858,52858,52858,52858,50810,50778,50810,50778,50778,48697,48665,46552,44472,40311,38198,36085,34004,33972,31891,31859,29778,29746,27698,27698,27698,27730,34004,40278,46552,48665,44536,44504,46650,50843,50778,50810,52890,52858,48697,48665,46617,46584,31924,8844,17164,17165,19213,10924,4683,2603,4651,2602,490,522,4651,522,2602,6697,4552,10793,19115,19179,38098,35921,44307,37968,25551,29744,29680,21260,8712,10696,10695,12969,10824,19179,27632,38066,52693,54740,54610,44176,25520,35985,31760,25454,35953,23242,10695,260,228,12743,33644,23048,18919,14758,8582,23373,46485,52563,35921,37902,52661,29712,36019,31858,52759,54676,58673,59098,61244,50679,52824,52792,50744,40472,52792,54905,54905,56985,52824,50678,37706,37739,33610,35788,35659,35626,14790,6534,23340,14987,10957,2537,458,523,490,652,4716,523,555,588,555,653,653,588,587,588,588,588,587,620,620,620,588,620,620,588,587,588,620,587,620,652,587,457,8843,14953,14954,6600,10793,19115,8615,19146,40178,23306,42226,52693,38033,38033,35724,46420,57083,63357,63357,61277,59164,29646,10662,23274,29614,27634,10663,37935,52660,35987,19345,33939,61244,38065,16903,16935,12742,18983,42194,147},
{34005,31925,25716,19476,17428,17428,17428,17428,17428,17428,17428,17428,21621,25749,25749,23669,19541,19541,19541,19541,19541,32023,50810,54971,54971,54971,55003,55003,55003,50810,52890,52890,52890,52858,50810,52858,52890,52890,52858,50810,50810,50810,50778,48697,48665,46585,44504,42423,40311,38198,36085,34004,33971,31891,31859,29778,29778,29746,27698,27698,29778,31924,40278,46585,50746,46617,44504,48730,52923,50811,52858,54939,52858,48665,48665,46552,44504,31891,4683,17165,17165,17165,15052,6731,4683,2602,490,490,2570,490,490,4650,8777,4519,15019,33742,29613,42357,46421,46355,42161,29712,31695,17067,12906,8712,19050,19049,8711,6599,10792,14986,31726,29580,33840,37934,41998,23408,44405,40179,23308,35986,31629,12775,2373,2308,8615,29451,16807,23113,29354,16871,19147,31727,44406,46518,35822,48501,46518,29679,27631,46420,46289,48402,56953,59163,44306,48532,44306,46452,42259,46452,46419,48500,48532,42194,61146,42194,50613,44274,48532,46387,50580,50612,39950,35789,33676,27501,31530,25322,21195,15084,21521,11022,522,555,588,588,653,685,620,620,588,620,588,620,620,652,620,620,652,652,620,620,587,652,588,620,620,555,425,13004,33840,29679,23373,15051,29549,12710,12841,44340,25452,29646,48533,38000,46519,44208,38001,42259,61277,57051,42292,19081,19048,21194,23274,31660,42128,23210,33807,48533,34005,19279,50744,59196,48565,19016,16935,14823,16903,40080,63},
{34037,25684,19475,19476,19476,19476,17428,17396,17428,17428,17428,17428,19508,21589,25749,23669,21589,19541,19541,19541,23702,50811,59164,57084,57052,57084,55003,55003,57084,52923,50810,50810,52890,52890,52890,52890,52890,52858,50810,50810,50778,50778,48697,48665,46585,46584,44504,42423,40311,38198,36117,34004,33971,33971,31859,29778,29778,29778,27698,27698,27730,31891,40278,48665,48697,48665,46649,50811,52923,50811,54939,54971,52858,48665,46584,44472,42391,31891,6731,17133,21293,17164,15084,8811,8811,4650,522,522,522,490,4650,10891,10858,6600,23471,46322,33774,31792,44470,42291,33807,40114,40049,25486,17067,23276,44177,37902,6566,4519,6599,14985,27533,19145,38066,40113,44242,27601,42260,44406,23341,12809,33742,25323,8614,2341,2309,25258,16775,27306,29418,19017,19114,29548,40147,46421,46256,46190,42194,17000,31629,23210,21195,33840,48468,54872,63389,63357,63357,63357,63357,63389,63357,63390,63161,61047,56952,33709,59000,39918,63160,39982,50515,54740,48239,33643,35691,33643,33578,31530,33578,27370,29744,23504,522,587,620,620,685,685,620,620,620,620,588,620,620,652,620,620,620,620,588,620,555,588,555,620,620,555,555,2603,8875,10923,6632,10793,42096,23047,12840,42259,33806,19114,40145,40179,42259,54905,63357,63357,61277,52792,29581,10694,27402,23274,25322,27436,40081,19082,38033,46387,44406,31826,59131,59163,54937,23242,16936,14823,14855,42227,86},
{31925,23636,19476,19476,17428,17396,17396,17428,17428,17428,17428,17428,17460,17461,19541,19541,19541,21589,21621,19541,25782,50843,57084,57084,57084,57084,55003,57084,59197,59197,57084,50778,50778,52858,52858,52858,52858,50810,50778,50777,50745,48697,48697,48697,46617,46584,44504,42423,40311,38198,36117,36052,33972,33971,31891,29778,29778,29778,27698,27698,27730,31891,40311,48697,48697,48697,50810,50843,50810,46650,52890,54971,50778,44504,44472,46552,46552,27698,6731,15085,19245,17132,17132,10891,12972,10891,4650,4650,4650,6731,8811,12939,12906,4551,19213,54643,46322,38033,42292,44242,44307,44176,40114,19277,17067,21163,39951,27435,2406,293,2438,10826,29646,23306,29646,33806,40080,31761,42227,36019,25421,14921,37968,27403,6534,2341,6534,25290,16807,29386,31434,21064,19049,33709,44307,58902,56788,50515,44208,35952,39983,18951,19081,29614,44307,46518,54905,48533,54905,50679,52792,46420,56920,52726,56821,58999,50645,44307,54806,46387,54839,44274,50482,37934,50546,42128,50613,46353,48500,48499,50613,44208,31759,15247,522,620,620,620,652,685,588,620,620,620,588,588,588,620,588,620,588,620,588,620,556,620,588,620,652,652,652,620,587,554,392,4650,39982,29256,17001,35953,35952,33840,40112,27435,42194,61309,61309,61309,63390,57050,29515,23274,25354,25322,19213,19246,27468,10662,38033,42161,40048,42292,59164,57083,59163,29613,16935,14823,27533,50712,98},
{27796,21556,21524,19476,17396,17396,15348,17428,17428,17428,17428,17428,17460,17461,17461,19541,19541,19541,19541,19541,25782,50843,57051,57051,57084,57084,55003,57116,59197,59197,61277,57084,50778,50746,50778,50810,50810,50778,50778,50745,48697,48697,48697,48698,48665,46584,44504,42423,40311,38198,36117,36084,34004,33972,31891,31858,29778,29778,29778,27698,27698,31891,44472,50778,48665,48698,48730,50810,48730,46649,50810,50778,46584,42423,42391,46552,44504,25617,4683,15085,19245,17132,17132,17132,15084,15052,10891,8811,10891,8811,12939,12972,12971,10793,21228,44242,48434,42259,35985,50613,46387,35822,21357,6697,10793,17035,35855,12840,261,229,261,2439,33808,38000,23371,21259,35887,44242,38001,38099,27534,21194,29581,21129,6534,4421,2373,21130,14759,23112,18952,21130,37968,46354,48434,37837,27371,35822,46354,40114,37935,10663,23340,35887,40114,33873,42259,40114,44307,38000,40179,33840,35888,42193,50646,54904,38099,38066,40147,48534,40147,46453,50614,50482,54772,46387,57017,44241,56985,50646,59097,46321,48631,25845,587,685,652,685,685,782,685,685,685,750,685,685,685,718,685,717,685,2797,653,717,653,717,685,717,684,684,652,652,684,652,554,620,29549,37870,21194,25452,33904,50679,42193,33741,57051,63390,61309,61309,63390,40048,27435,27468,27402,23242,15053,17166,27403,35887,42160,37868,35790,42325,59163,57083,61277,38065,16935,16935,35985,44405,99},
{23636,21524,19475,17395,17395,17396,15348,15380,15380,17428,17428,17428,17460,17461,17493,19541,19541,19541,19541,27862,44537,57052,55003,57052,57084,57084,55003,57084,59164,59197,61277,59197,52891,50810,50778,50778,50778,50778,50745,48665,48665,48697,50778,50778,48665,46584,44472,42391,40311,40246,38165,36084,36052,34004,33939,31859,31858,29810,29778,29778,29778,31891,42391,50778,48665,50778,50810,52891,50810,48698,50778,46617,42391,40278,40311,46584,44504,29811,4683,13004,19245,17132,15084,17164,17132,15084,15052,12972,13004,15052,15052,15084,15052,15019,17099,21260,23371,36018,38099,35952,35887,21259,12905,8712,14954,10793,21260,4454,2374,2406,8679,23307,37968,48468,27467,17066,42195,42161,27567,48632,42227,19049,17000,14888,12840,10727,4421,2244,2276,14791,12678,14955,37968,46224,46354,50482,29387,37837,37868,41996,39915,31431,37803,46157,39818,41931,39850,39948,50480,44076,40014,29416,29384,42061,56820,56952,48467,56854,44241,61080,48435,59065,58934,52660,44306,42292,50678,42258,52791,46517,54872,42160,42292,23764,620,652,652,685,653,750,685,685,653,717,653,652,620,685,620,685,620,717,588,685,620,685,620,652,620,652,619,619,652,620,522,457,2570,23307,19114,25453,46486,50711,44372,48630,61310,61309,61309,63422,52792,27435,31661,25354,23242,23242,15020,17231,40015,50712,44338,42094,33741,40212,57083,57083,61277,48566,19048,14823,44405,57018,140},
{23604,19476,17395,17395,17395,15348,15348,15380,15380,17428,17428,17428,17461,17461,17493,19541,19541,19541,25782,48730,55003,57084,57084,57084,59164,59197,59164,55003,57084,59164,59197,59164,57052,55003,50810,50745,48697,48665,48665,48697,48697,50778,50778,48697,48665,46552,44472,42391,40310,38230,38165,36085,36052,36052,33972,31891,31859,31859,29778,29778,29778,31891,40311,48665,46617,48730,54971,54971,52890,50810,48697,42424,40278,38197,40311,46585,44472,29811,2603,8844,21325,17164,15084,17165,17164,15052,15052,17132,15052,17132,17132,17132,15084,15051,15018,31694,23339,23405,33905,27534,33970,21226,12840,19114,23242,8647,8680,8679,6599,8712,19211,37968,44307,44209,35757,27501,38066,33775,31760,52890,50679,25355,23339,21162,6534,6567,12743,8550,4422,2341,4421,16969,23210,44078,52595,44339,23243,33741,41963,39949,48303,46190,35755,37868,42062,46189,37803,37868,48368,52561,50513,31529,35755,52495,58965,56919,52661,59000,52660,56886,52661,59000,48368,52692,38164,46518,42259,48598,44405,48631,38033,46387,57017,23634,587,620,653,717,652,685,685,685,653,653,620,652,620,652,652,652,620,685,620,652,587,652,652,652,619,2700,2699,2667,2667,2699,554,2667,13167,35920,19147,35953,50712,48598,42291,57083,61244,61309,61277,63357,31693,25388,35854,23242,21162,19082,15020,17133,44339,52857,46452,44207,37934,35986,57018,57083,61245,54937,21161,10629,31760,57050,151},
{19475,19475,17395,17396,15348,15348,15348,15348,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,38296,52891,57084,59164,59197,59164,59197,59196,59164,57084,57084,59164,59197,59197,57116,57084,55003,52858,48697,48697,50778,52890,52891,52858,48697,46617,46585,46552,44471,42391,40310,38198,38165,36085,36052,36052,34004,33971,31891,31859,29778,29778,29778,31859,38230,46650,46650,52891,57084,57051,52891,48697,44504,42391,40311,38197,40311,44504,44504,23505,523,555,17165,17165,17132,15084,17132,15084,15084,15084,17132,15052,15052,15084,17132,15019,14987,35888,42292,35855,33807,33775,31792,19146,14921,19147,23307,14921,8647,14984,17065,6567,14985,23373,40179,40081,42193,44307,50712,48631,48631,50712,46453,38099,40114,33677,4422,261,4421,8550,4454,4454,2373,21194,25356,42030,46322,48566,33775,42128,54707,31694,44144,44078,29614,23341,33807,27403,23243,31759,38001,50680,46519,25455,29648,44372,63324,63324,63324,63324,61276,61244,63324,59065,42128,52823,42324,54838,40112,56984,48565,56984,29515,42095,54904,29778,19342,21488,21423,23568,21423,25616,21456,25616,21423,27696,23405,29711,25551,31825,25551,31792,23471,31824,25519,29711,25551,31760,25551,31791,33839,35919,35919,33839,33839,35919,29646,40245,57051,50645,19114,46518,50711,46484,52824,63358,61309,61277,63422,50646,21161,29548,33806,21161,17001,17001,19082,29614,50712,46518,48598,42159,42126,35953,54938,59163,59196,59164,29613,14887,27468,44405,133},
{19475,17395,17395,17395,15348,15348,15348,15348,17428,17428,17428,17460,17461,17461,17461,17461,23702,42489,48730,50811,55004,59164,59164,59164,59164,59164,59197,59164,57084,59164,59164,59197,61277,61277,59197,59164,57084,54971,55003,55003,54971,50810,48665,46585,46552,44504,42423,42359,40278,38198,38165,36117,36084,36052,36052,36052,31891,31858,29810,29778,29810,31891,40344,50810,52891,55003,57116,54971,52891,50810,46617,44504,42423,38230,40311,44504,46584,19344,555,555,10924,17165,17165,15084,17132,17132,15052,15052,15084,17132,15052,15052,12971,12971,19212,29712,29842,31792,48468,48435,33775,14921,27468,29647,25486,8679,8679,14984,25419,12872,14953,29679,38001,40147,46387,42161,38001,50614,42162,52858,54905,31694,17001,29451,4421,4422,2341,2276,260,2341,17065,31596,25388,46322,44176,38001,40048,39949,50481,35986,44111,35724,27534,29679,23372,27435,16936,27533,42194,40147,44242,23340,31728,25454,40212,40212,40212,40212,40212,40180,40180,40147,50612,44274,38033,44306,40179,52726,50678,52757,35853,39982,54839,61244,61211,61211,61211,61244,61211,61211,61211,61211,61179,61211,61211,61211,61211,61211,61211,61179,61179,61211,61211,61179,61179,61211,61211,61243,61211,61210,61178,61178,61178,61178,38000,31727,50614,46419,44340,54872,40178,42291,61277,63390,61309,61277,61244,35854,27435,27435,31726,19081,16969,17001,23308,50712,54905,44405,50712,42160,42061,40015,50777,59164,59196,61277,38033,16968,46353,46353,177},
{17395,15315,15315,15347,15348,15348,15348,15380,17428,17428,17428,17460,17461,17461,17461,17461,21621,44537,52923,55003,57084,59197,57116,57116,59164,59197,59197,59164,57084,59197,59164,59197,61277,61277,59197,59197,59164,57084,55003,55003,54971,48697,46584,46584,44504,44472,42391,40310,38230,38198,38197,36117,36085,36052,36084,34004,31891,31859,29811,29811,31891,34004,40343,52923,57084,57084,57084,54971,54971,52891,48665,46552,42391,40278,40343,46552,46552,13070,555,2635,10924,15052,17165,17132,17132,17132,17132,15052,15052,15084,15052,12972,10891,8811,10891,23536,40211,31759,40147,59032,31694,21293,38001,40081,27533,14952,14952,17033,21162,23340,27533,35887,48467,40048,42128,44242,33775,39982,33742,31727,46420,52693,27468,33579,21097,17002,14823,2341,2373,8678,25451,27403,25388,39918,48304,37935,37935,48433,48335,38034,29549,21293,21324,17034,8615,35822,6469,29614,27598,27435,33644,23275,40212,29648,14954,2309,229,4422,2341,2341,2309,8615,46452,31694,44372,31694,46453,37967,52725,48500,48532,44143,59033,61212,61211,59131,61244,59163,59131,59131,61211,59099,61212,59163,59131,59163,61211,59163,61211,59131,61211,59164,61211,59163,61212,61244,57051,52858,52857,50809,48696,48663,50744,46485,12775,23242,48499,40080,52825,52726,29581,46551,63422,63390,61277,63422,48532,35821,27467,25354,29581,19082,14921,16969,31760,54971,54938,44405,52793,42225,42061,37869,48599,59196,59196,61277,46387,16935,42192,44272,159},
{15315,15315,15315,15347,15348,15348,15348,15380,17428,17428,17428,17460,17461,17461,17461,19541,17461,32055,48730,55003,59164,59197,57116,57084,59197,59197,59229,61277,61277,61277,59164,59164,59197,61245,61245,59197,59196,57116,57084,55003,52891,48665,44504,44504,44472,42391,40311,40278,38198,38198,38198,36117,36084,36084,36084,33972,31891,31891,31891,31859,31891,34005,40343,57084,59197,59197,59164,54971,54971,52890,46585,46552,42391,40311,42391,46584,46552,8909,555,555,6796,12972,15085,17165,15084,17132,15084,17132,15084,12971,15052,12972,12939,10859,12972,31922,31889,42260,46420,42161,17099,27567,33905,31695,27500,21225,17033,21226,31596,35888,33775,27501,31662,29580,25452,33774,40081,35886,14984,17065,35888,25388,21194,50319,27338,25388,29483,21096,21129,10727,6567,23275,25421,39885,54676,35790,29387,52628,52496,37967,14986,23307,27435,10662,27403,42096,23210,27468,19145,27468,35920,46518,44438,35986,31760,14921,164,196,196,196,2244,2244,4357,4389,6470,4357,2309,10695,35855,44306,48500,44339,59131,52792,59131,54905,61212,52792,57083,44634,57051,46682,59164,48762,57084,46747,57084,46715,57084,46714,57084,48795,57083,48795,57116,48729,36148,19408,15248,15312,15313,13168,13102,13070,21390,42062,42192,29645,44372,38066,48598,61277,63390,61309,61309,59098,40015,33741,27467,23242,23307,19082,14921,14921,42325,54970,54938,46486,48599,38032,42126,37837,38000,46419,40113,31760,35855,25387,37999,48466,153},
{15315,15315,15315,15347,17396,15348,15348,15380,15380,17428,17428,17428,17461,17461,17461,19541,17493,21654,38296,50811,57084,59164,57084,57084,59164,59197,59229,61277,61309,61277,59164,59164,59164,59197,61245,59197,59164,57084,55003,52891,48697,44536,42424,42423,42391,40311,40278,38198,38198,38230,38198,38165,36085,36085,38133,36052,31891,31891,31891,31891,31891,34005,42424,59164,61277,59197,57116,54971,57051,50810,48665,44504,42423,42391,42391,46617,46584,8909,555,555,2635,10924,12972,15084,17165,15052,17132,15084,15052,12971,12972,12971,12971,12971,10891,31826,29582,29646,42194,35953,23340,29712,21260,14987,33806,27499,23340,14953,42194,44241,27436,12711,31564,35821,25485,37968,33840,44306,31758,21292,33775,23275,21162,46257,48402,44242,42161,44144,29483,8615,2341,6502,19082,39983,44177,33547,33449,39918,48368,21063,2374,25355,18951,19016,31629,44340,48599,39918,27433,31629,25387,21228,33971,27632,29713,27535,17067,21261,23373,25422,23341,23309,23341,23373,21261,21261,21261,21261,29614,44339,48532,42227,44372,42226,44307,42227,44340,42227,42292,40244,44339,42259,44339,42259,42325,40244,42324,42325,42324,42325,42292,42325,42325,42357,44438,46550,50776,44372,48663,44438,52857,48566,52791,44339,48401,33676,42225,40112,46452,54938,65503,63390,63390,63390,63390,44274,40014,31628,27435,19081,17001,14921,14921,21195,50744,54938,54970,48598,33840,31727,42126,40015,42160,46353,33741,16969,37967,27435,33773,50546,141},
{17395,15347,15347,17396,17428,17428,15348,17428,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,21621,27895,48730,54971,55003,55004,57084,59164,59197,61277,61309,61277,59197,57116,59164,59197,59197,59164,57084,54971,50778,46617,44536,44472,42424,42391,42391,40310,38230,38198,38198,38198,38197,38165,36085,38165,38133,36084,33939,31891,33971,31891,31891,34037,40376,57084,61277,57084,57084,54971,54971,50810,48665,44504,42423,44472,44472,50745,46584,6829,555,555,2635,6796,13004,15052,15084,15084,17132,15084,15052,12971,13004,12972,12971,12971,8811,23504,35888,37968,33775,40048,31727,31825,27566,23242,29581,25451,40211,25388,33807,40048,31661,31694,48435,40015,17066,40081,37968,33775,37967,27532,52628,39983,12775,19147,50580,48500,37935,16936,8615,261,228,4454,21162,29484,39983,52530,56691,52596,48466,18982,293,23275,25290,23210,40081,48435,35887,41998,48337,42259,29515,21096,17066,18887,18887,18952,18920,18952,16904,16904,16904,16904,18985,18952,18952,18952,19017,16904,23210,42193,46387,40048,35887,35887,35854,35854,33774,35855,31726,33806,31726,33774,31694,33774,31726,33774,33774,33774,33742,33742,33742,33742,33774,33742,35887,48567,50679,52825,54904,50711,54904,44470,48630,46387,50482,44273,52660,31661,40178,57051,63422,63390,63390,65503,50678,44273,44241,31628,25322,19049,14921,12808,21228,44438,54938,54938,54970,42292,25453,27534,37934,39949,40047,46385,44240,40113,48466,42127,37934,48466,149},
{17395,15315,17395,19476,19476,17428,17396,17428,19508,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,21622,32056,42457,46618,46650,52891,57084,59197,61277,61309,61310,61277,59164,59164,59164,59164,57051,54971,52858,46585,42424,42424,42391,42423,42391,40343,40310,38230,38198,38198,38197,38165,36117,36085,38165,38165,38133,33971,33971,33971,31891,31891,36118,40377,48763,59164,57051,55003,52891,52858,50745,50777,46584,42423,44504,44504,52858,29811,555,555,555,2635,6764,10924,15084,17165,17164,17132,17164,15052,15052,15052,15052,15052,12971,12939,13004,23536,25453,33775,37936,42325,27664,23373,17034,29581,19145,29645,46387,44340,44307,33677,40049,33872,25420,8679,33905,42095,33774,35887,14888,33806,42128,23339,6598,8647,21162,23209,10695,6502,8615,21194,17002,21130,21162,33709,48207,58543,39918,46419,29417,8647,31596,37705,21097,44275,46354,33741,27338,29484,29516,20967,18853,16773,16773,14758,16838,12645,14758,14790,12678,12645,12678,14823,10597,10597,12678,19017,12678,21097,37999,48533,57018,54905,57018,56986,57018,57018,50843,50875,48794,50875,50842,52955,50842,55003,46714,55003,46714,54970,44601,55003,44634,57051,46714,50712,52825,50874,50777,46584,42455,36181,31956,21554,38131,37935,35887,50612,29580,35952,59164,61277,61277,50613,44274,35789,37934,33708,27435,29515,27435,23209,14855,19082,48664,54938,54970,50745,31793,23373,23373,33741,37869,48467,61178,61177,52726,46354,46353,35886,44240,167},
{17395,15315,15347,19476,19508,19476,17428,19508,19476,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,19541,19541,23702,27862,25782,44570,57084,59164,61277,61309,61310,61310,61277,59164,57084,55003,52890,50778,48697,46584,42391,40311,40343,42423,42391,40311,40310,40278,38230,38198,38197,38165,36117,36117,38165,40278,38165,33972,33939,33971,31891,31924,34037,38296,46682,57052,57084,55003,52890,48665,48665,50745,44504,42423,44504,46585,48665,8909,587,555,555,555,10924,12972,15085,17197,17165,17165,15084,15084,15052,15052,15052,15052,6731,4683,12972,21423,29679,29647,21261,36019,31792,27566,17033,23306,23338,25419,33742,44373,46420,33742,42129,33840,38000,14920,12873,35887,44436,46322,31628,25322,31532,33742,27532,21258,31628,12775,4421,6534,29679,31661,14824,14888,25355,23145,31661,33775,35921,46485,48270,31596,25388,16903,12743,42096,48370,35757,23275,23145,12612,14726,10500,16741,16838,14791,14758,12710,12743,16936,12710,12645,10565,14823,14791,12710,10630,19082,14791,21163,50678,59098,52792,59131,56985,61211,50842,59164,44634,57116,44634,57116,48795,57084,46714,57083,44666,55003,46714,55003,46714,50842,46714,52890,50809,56985,44600,55067,54871,59130,48533,61179,59065,40080,38033,23373,16838,25322,31596,37967,44339,27565,48631,46321,35723,33643,23242,21129,21162,29482,27468,27370,14888,19049,50680,54938,54971,46518,31792,21292,21292,29580,37869,44274,56985,63356,52726,46419,42159,21096,37967,175},
{17395,15315,15347,17396,19508,21556,19508,21556,17428,17428,17428,17460,17460,17461,17461,17461,19541,19541,19541,19541,19573,25782,25782,21621,32056,54971,57084,59164,61277,61310,61309,59197,59164,57084,52858,50778,50778,48665,44504,42391,40311,42391,42423,42391,42359,40310,40278,40278,40278,38198,38197,38165,38165,38197,40278,40245,36084,31891,33971,33939,33972,36118,38296,46650,52923,57116,55003,52891,48665,44504,44504,40278,42391,44504,50778,31924,555,2636,555,555,555,4716,13037,15085,17165,17165,17165,15084,15052,15084,15052,17165,15084,8811,4650,6730,13004,25584,25389,25454,27535,44307,37968,10727,29579,29611,29645,42194,50417,50548,33742,44241,35888,42129,12840,2374,6566,12873,42128,37935,37903,37772,31596,35855,44208,33709,8582,4421,21226,29581,25389,19082,14856,27435,37837,19113,17001,25388,40178,42062,21260,33676,18983,6469,35887,42063,44111,23340,19050,2243,6372,6339,14791,14725,12678,16903,10565,12678,21162,14790,12677,10565,14823,12743,12710,10598,19082,21130,14856,25421,46453,40147,46453,42260,44405,44405,44406,40245,40277,38197,40277,38197,38165,38197,36117,40245,36117,40277,36117,48664,48665,57083,50810,54872,59064,59064,50678,44340,50612,33774,54839,44307,46452,40146,25225,20966,18886,12612,21194,37967,25355,42292,37934,33675,25322,27435,21129,27402,27370,27500,25354,16968,27534,52857,52857,54971,48567,31792,23373,23373,25420,35820,35757,44373,44372,52759,48533,44240,29482,31628,190},
{19476,19475,17395,17428,19508,19508,19508,19476,17428,17428,17428,17428,17461,17461,17461,17461,19541,19541,19541,19541,19573,29975,36184,29975,32023,46650,54971,57116,59197,59197,59197,59164,57084,52923,52890,50810,50810,46585,42391,40343,42424,44472,42423,42423,42391,42359,42359,42359,40310,40246,38197,38197,38198,40278,42358,40278,38165,31891,31891,31891,34004,38263,40409,42522,48730,57084,55003,52923,44536,38230,38198,36085,38198,44472,48697,15151,2635,2636,587,2603,2635,2635,10956,15085,17133,17165,17165,17164,15084,15084,12972,15084,15052,12972,10891,6731,8746,29778,42129,27469,27566,44307,23307,29548,21194,8679,14953,31759,44208,40179,48533,42129,33677,27501,17066,12840,21226,23339,44338,40114,52693,56724,35822,31596,33709,44176,23209,12711,29516,31596,25389,23275,27467,25354,25387,14887,8615,21194,25420,12709,17066,35855,21064,12775,23504,40048,48468,21195,33677,37674,37706,33513,18984,16903,16936,16903,14790,14823,25355,19016,16903,10565,10630,10662,12743,14790,16969,21130,12743,12710,10662,10662,10662,8517,8550,10662,10630,12710,6502,6534,4389,2211,2244,2276,4454,2341,2341,2309,2374,21260,44339,44405,40179,40114,48532,52725,40048,44307,37869,35822,31629,19016,46419,42193,16838,16773,16806,12677,38033,44307,31694,27533,31693,31562,16903,29516,25388,25322,21129,27435,21129,21129,44405,54905,52825,54970,48631,31760,21260,21260,25388,35788,33676,38099,25388,48598,50646,44240,44240,42127,189},
{23636,19508,19476,19508,19476,17428,17428,17428,17428,17428,17428,17428,17460,17461,17461,19509,19541,19541,19541,19541,23702,36216,44569,40377,36216,40377,44537,50843,57084,59164,59164,57084,54971,52891,52923,52923,52858,46585,42391,42424,46552,46552,44504,44472,42391,42391,42391,42391,40278,40278,38198,40246,40278,42358,42391,42358,38165,31891,31891,31891,34005,38263,42490,42522,46682,50810,48730,48698,40311,36118,36085,34005,38165,44472,42391,6797,587,2636,2635,2635,2635,4683,10924,13005,13004,17165,19245,17197,17165,15084,15052,15084,12971,8779,10891,12939,10793,27665,44372,46323,35952,29646,19145,35820,25354,12841,17066,27598,38163,33872,35985,27533,29614,31759,21260,19179,38000,29614,33839,33840,44274,35790,31694,27500,17066,23340,35822,21194,23275,27533,21260,21195,23307,23339,23274,21194,19114,19114,17066,14953,17066,23372,23210,21195,21423,25519,25486,14986,25420,31629,31694,29613,19179,19179,25485,25453,25453,27566,27566,23405,19179,19179,17099,17066,19179,19147,16936,12645,12677,21195,19179,21259,19147,21227,19147,17099,19179,19147,14954,12906,10793,14953,12841,10793,8712,4486,4519,4486,4454,19147,46387,29451,25225,18919,18984,40114,37836,22981,20966,21129,35789,31595,40080,40015,31628,33676,31596,33774,52759,48565,50711,42259,27501,35789,29548,33774,31726,31661,29548,29548,27435,38034,54938,52825,52825,54970,50712,31760,23373,21260,23307,33740,31563,40147,23308,44373,50646,52758,56951,54838,182},
{23636,23636,21556,23636,19508,17428,17396,15380,17428,17428,17428,17428,17460,17461,17461,19541,19541,19541,19541,19541,29943,38296,46618,36184,32055,42457,40377,46618,52923,57084,59164,57052,57084,55003,52923,54971,50778,46617,44504,44504,46584,46552,46552,44504,42423,42423,42423,42391,40310,40278,40278,40278,42358,42359,42391,42358,38165,31891,31859,31891,34005,38263,42490,44570,48698,46617,44504,42424,38230,36117,36085,36085,40310,46584,33972,2635,587,587,2636,2635,4683,4715,10924,10924,13005,13004,17197,19245,17165,15052,13004,15084,15052,10891,8811,8811,10826,25551,38131,44340,46387,21226,14985,21193,29547,31694,23340,21292,14954,21227,25453,25453,25453,25453,23373,19212,23340,23373,25453,27566,29614,27533,25453,25453,25485,25453,31726,27566,29679,27566,27566,25486,25453,27566,33807,31759,31759,29679,29646,25453,25453,27566,17001,4454,2439,15019,17132,17132,19212,17099,17131,19212,23373,25486,23405,21325,27599,29711,27631,21325,19212,23438,23405,21292,23373,23373,23340,10695,8615,17067,21324,25518,19179,23373,23405,23405,21324,21292,19179,12873,14986,17099,14986,14986,10792,4486,4454,4486,2406,23340,52661,37837,18853,18885,19049,48500,46354,35724,35757,52563,50384,27467,29515,37967,37967,40014,27468,35887,48566,56886,48401,31661,35953,46518,46486,44405,44372,42292,40179,38098,42292,54970,52858,52825,52825,54938,50744,31793,27566,21228,21227,31660,33611,38034,29646,38066,50711,61244,48500,59098,211},
{23604,25716,27765,27797,21556,17428,15348,15380,17428,17428,17428,17428,17460,17461,17461,19541,19541,19541,19541,19541,25814,40376,46618,27895,27895,38297,36216,44570,52891,57084,59164,57052,57084,57084,54971,52891,50778,48665,46585,46584,46584,46584,46552,44504,44472,44471,42391,42391,42359,40310,40278,40310,42391,42391,42391,40310,38165,33939,31859,33971,34037,40344,42522,48698,50810,50746,46585,42391,38198,34037,36085,36085,42391,46584,19344,555,2636,2636,4716,4716,4683,4716,8844,12972,15085,13004,15084,17165,17165,17132,15052,15052,12972,8811,10891,10891,12939,21358,38099,38002,37968,17065,17065,27500,27500,33807,25420,25421,21195,23340,25420,25453,27533,25421,25453,25453,27533,27534,27533,27533,27501,29614,29614,29614,29614,29679,27566,29647,31759,31759,33840,27566,29614,31759,31759,33807,31759,31759,31759,31727,31759,31759,27534,21260,23308,25453,23405,27566,27566,27566,27566,29646,29679,29679,27534,29679,31792,33872,31727,27566,25486,27566,29646,27533,27533,27599,29647,23340,25421,27534,27534,29646,25453,25453,25485,25453,27566,27566,27566,23373,25453,25453,23372,23372,14985,6599,6631,6567,4519,29581,52627,46288,25191,20966,14855,46452,54840,50712,33807,54448,52432,40047,37934,44208,44208,44208,42127,37934,48500,63094,39981,29613,40211,42292,40179,38098,38034,35953,33840,31759,33873,52825,52858,52857,52825,54906,52825,33873,27567,21228,21260,29547,29547,29680,40146,33840,54937,59130,52726,61243,244},
{23636,25716,25716,25717,23636,19476,17428,15380,17428,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,19541,23702,40377,48698,32055,27895,34103,27895,34136,52891,57084,55003,55003,57084,57051,54971,54971,52890,48665,46617,48665,46617,46585,46584,44504,44504,44472,44471,42391,42391,42359,42359,42359,42391,42391,42391,40278,38165,33971,31891,33972,36118,40376,44570,48730,50778,48698,46585,42391,38198,34037,34037,34005,40310,46584,15150,555,555,2636,2635,4716,6764,6764,8844,10924,17165,17197,13004,15084,15084,15084,15084,15052,12972,10891,10891,12971,15051,27664,29745,29680,23308,14953,19146,33807,31694,31759,31759,29646,27533,27533,31726,31727,31727,33807,31759,33840,33840,33840,31759,33807,33807,31727,31727,33840,33840,33839,29679,31759,33840,33840,35953,33807,31727,33807,33807,33840,33840,33839,31727,33872,35920,33840,33839,33807,31726,31726,31694,29613,31694,31727,29646,29646,29646,29614,29614,33807,33839,35920,31694,27565,27565,27501,27501,25420,27501,29646,27566,27501,29646,29614,25453,27533,29613,23308,25453,27566,27501,27565,27566,27533,29614,29646,27533,27501,21227,12872,15018,12905,8680,14921,48336,46288,39917,27305,16806,46387,54839,33807,23308,41836,58641,35821,21194,42095,35919,42127,25355,37968,50613,42063,21031,19114,27501,23340,23308,21195,19114,17034,17002,19114,10727,42293,54938,52857,52825,52857,52857,33905,27599,21260,21260,21161,23241,23373,42292,33807,50712,52824,54905,61244,241},
{21556,25716,27797,25716,19508,19508,19476,17428,17428,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,19541,21621,29943,32055,29975,27895,25814,25814,34136,52891,52923,52858,54971,55003,57084,52923,52890,52891,48697,48698,48697,48665,46617,46584,46552,44504,44504,44504,44471,44439,42391,42391,42391,42359,42391,42391,40278,38165,33971,33971,34004,36118,40344,44569,50778,50778,48665,44504,42359,38198,36085,34004,34004,38230,46552,13070,587,587,587,2636,4716,8844,8844,8844,8844,13004,17165,13004,13004,15084,15084,15084,15084,17164,15052,8811,10923,17164,23438,33775,10792,25387,23339,31727,31727,31726,33807,31727,29646,25485,27566,31759,31727,31727,31759,31727,33839,33839,33840,33840,33807,31759,31727,33807,33840,33807,33807,29647,29679,33840,33840,35920,31759,31727,33807,31726,31727,33840,33839,31726,33840,33872,33807,33807,33839,31727,31727,29614,31694,31727,31694,29613,29614,29646,29613,27533,31759,33807,35920,29646,27533,27565,27565,27500,25388,25420,27566,27533,25420,29613,29646,27533,27533,29614,25420,27533,27565,27533,27501,29614,27533,27533,29614,27533,27501,23340,17066,19179,12872,6599,8647,46289,50580,33676,29515,25159,40081,40146,17165,29713,48175,58641,42095,33741,42128,42160,44240,37934,46387,35920,27403,25224,8485,8517,4291,6372,2243,2211,98,2276,4421,6469,31826,54938,54906,52825,52825,54938,35986,27599,19180,21260,23274,27402,27436,31792,33807,46485,48566,57018,63324,235},
{23636,29877,34038,29877,21588,19508,19508,17428,17428,17428,17428,17460,17460,17461,17461,17461,19541,19541,19541,19541,21621,27862,21654,23702,23702,23734,21654,29943,50811,52891,52891,52923,54971,55003,52891,52890,54971,52890,50778,48697,46617,46617,46584,46584,46584,46584,46552,44472,44472,44504,44504,44471,42391,42391,42358,40245,36084,34004,34004,34037,36118,40344,44504,48697,50778,46585,44504,42423,40278,38197,34004,34004,40278,44471,10957,2635,4716,4684,2636,4716,8844,8844,8844,10924,10924,10924,6763,4715,10924,8843,13004,15084,17164,12972,10891,13004,21325,31792,38001,23405,27533,21259,31759,33839,31759,33807,31726,29646,27534,29614,31759,31727,31727,33839,31759,33839,33839,33840,31726,31759,31759,29646,33840,33840,33807,33839,29647,31727,33807,33840,33840,31759,31727,33839,33807,33807,33807,33807,31727,33807,35920,33807,33807,33807,31694,31726,29581,29613,31726,29614,29613,29581,27533,27533,25452,29646,31727,33807,29645,27468,27501,27501,27500,25420,25420,25453,27501,25388,27501,29614,27533,25453,27533,25452,25420,27533,27533,27501,29614,29581,27533,29614,29614,27533,23340,8679,6631,4519,4519,6567,31629,48566,40081,31531,25160,40048,21391,4749,27600,50288,58609,46256,29613,37934,40080,42128,44273,38000,35887,37968,46452,46453,44307,35920,35888,33807,33775,31694,31726,27533,27533,35953,52858,54938,52857,52825,54938,38066,29680,19147,19147,23307,27435,27436,19147,31727,42259,54905,63324,63357,241},
{29877,34038,34038,31989,23636,17428,15380,15380,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,23702,21654,23702,21654,21654,23702,42457,57084,55003,55003,54971,54971,54971,52923,52891,54971,52890,50778,48697,48697,48697,48665,46617,48665,46585,46552,44504,46584,48665,46585,44504,44439,42391,42358,40245,38165,36084,36085,36118,36118,38198,46585,48698,46617,46617,46584,44504,42391,40278,36085,34004,40311,44471,8877,2636,4684,4716,2668,4716,6796,8844,6764,8844,13005,15085,8844,2635,13004,8844,6763,13004,15052,12972,10923,15052,17164,23406,33840,25552,19245,14986,31759,33840,31759,33807,31726,29646,27566,27566,31759,31727,31727,33839,33807,33839,33840,33840,31759,33807,33840,31727,31759,35920,33839,33839,29647,31759,33807,33840,35920,33840,31727,33807,33807,33840,33807,33839,31759,33839,35953,33840,33807,33840,31726,31727,29613,29614,31759,31694,29614,29581,27533,29613,27500,29646,33807,33839,31726,27501,27501,27501,27500,27500,27468,25453,27533,25388,29581,29613,27566,27533,29646,25420,23340,27533,27533,27533,29581,29613,27533,29646,29646,29614,25420,10760,6599,6567,4519,4487,31662,42194,46420,37870,25126,44177,31761,4782,25323,54350,58576,46223,31660,35854,42160,46387,40048,19146,42259,40048,48598,46518,48598,40179,48565,42194,46420,35855,44274,27533,44339,31759,52857,54938,52857,52825,54938,40179,29647,21260,17066,21260,23308,23308,21228,33840,35920,54872,59001,59033,219},
{31957,31957,31957,27829,19508,15348,15380,15380,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,21654,25782,21654,21654,23734,36248,57084,59164,57116,57116,57116,57084,57084,54971,54971,52891,50810,50778,48730,48697,48698,48698,48697,48665,46585,46584,46552,46617,48697,48665,46584,44471,42391,40310,40245,38165,38198,36118,36117,36085,36117,42456,48698,50778,48698,48665,46584,44504,42359,36085,34004,40311,42391,6796,2636,4716,4716,6796,6796,6796,6764,8876,10924,13005,15085,8844,4715,10924,10924,8843,10892,17132,12972,10891,15052,8811,8811,29679,23275,8712,12906,31759,31759,31726,31759,31694,29646,27566,29614,31727,31726,31726,33807,33807,33839,33839,33807,31759,33839,33807,33807,31759,35920,33839,33839,29679,31727,33807,33839,35952,31759,29679,33807,33840,35920,33839,33840,31759,33839,35920,33840,33840,35920,31727,31759,29614,29614,31727,29613,29614,29614,27533,29614,27501,31694,33840,33839,31726,27501,27533,29614,27500,25420,27500,27533,27533,25420,27468,29613,27533,27533,29613,25420,23340,27533,27501,27501,27501,27533,29614,27501,27500,27533,25420,12873,6599,6599,4519,17067,50483,48402,38032,42226,29385,46256,35824,4782,31630,56431,58544,52530,48499,48499,50548,54545,40015,19114,40114,44176,48598,48599,48598,40179,48565,44242,46452,35822,44339,29581,46419,33807,50744,54938,52857,52825,54906,40212,27567,21227,17034,19179,21227,21227,19115,31792,42259,63292,63292,63324,242},
{31925,29845,23636,19476,15348,15348,15380,15380,17428,17428,17428,17460,17460,17461,17461,19541,19541,19541,19541,19541,19573,21622,21654,21622,21654,21654,42489,59196,59197,59197,59197,59197,59164,57084,55003,54971,52891,52890,50810,50778,50810,50778,48697,48665,46585,46584,46584,46585,48697,48697,48665,46584,44471,42391,40278,38197,38165,38197,38198,38198,36117,34037,40343,50778,50810,50778,48697,46617,46584,42359,36085,34004,40310,40246,2635,2635,2636,2635,4716,4716,4716,4716,4716,13005,15085,15085,10924,10924,8812,6763,13036,15084,15084,12972,10891,15052,10859,10891,29745,23340,23373,38033,48631,50679,50679,50711,50711,50711,50679,50679,50711,50711,50711,52792,52792,54872,52824,52824,52824,52824,52824,52857,52824,54905,54905,54905,52824,52824,54905,54905,54937,54905,48566,23308,19147,21227,21227,21227,19179,21227,21227,21260,21260,23340,21227,19114,17033,17034,19146,17034,14953,19114,17034,17066,14921,17034,19114,19114,17034,17001,17033,17001,17001,17033,17034,17034,19114,17001,17034,17001,19179,19146,23307,19114,17033,21227,19114,17001,19114,19114,19114,19114,17033,19114,14889,6567,6599,8647,2373,12776,52400,50580,42226,46354,44046,48370,46519,31957,46258,48142,50386,63357,65470,65470,54709,48271,44143,27533,40179,40081,46485,38033,46485,44405,48598,42259,48533,37968,46452,35887,46420,42226,48631,54970,52857,52824,54905,40179,19180,12808,17034,19114,17034,17034,17001,25454,42325,44437,44437,42325,160},
{21588,21556,17396,15348,15348,15348,15348,15380,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,21654,21654,19606,36248,57084,59197,59197,59197,59197,59197,59164,57084,55003,55003,54971,52891,50778,50778,48697,46617,46585,46585,46585,46617,48665,48697,48697,48665,46585,44504,42391,40278,38165,38165,38197,38198,42391,42391,38231,42456,50810,52858,50778,48697,48665,44472,40278,36117,36085,40311,44439,8909,2635,555,555,555,2635,2635,555,555,4715,10924,13004,15084,13004,4683,2603,8843,15084,15084,12972,10892,15052,12939,12939,27502,14954,23406,44372,59163,57051,57051,54938,57051,57018,54970,57051,57018,59131,57050,57051,59131,57083,59164,59163,59131,61244,59131,59164,57083,59164,59164,59163,59164,59164,59164,59196,59164,61211,50678,12840,12841,10760,14921,12873,10760,14921,12840,14954,14954,10760,17034,12841,10728,14921,17099,14921,10760,14954,12873,12841,12808,8647,10760,12841,12840,12840,14921,10760,14921,14986,19147,17034,8647,12840,14953,12840,12840,14953,21260,17001,12808,12840,17034,14953,14921,14953,12808,14888,14921,19114,10662,2341,8679,10792,4421,6502,50255,54579,48565,59098,65175,63094,54578,39951,48467,50646,56985,65502,65470,65470,50580,42030,46191,23340,35953,35757,44307,29646,42260,42292,46485,27533,44339,31661,44307,27435,44339,42259,46485,54970,52857,52825,52824,35986,17001,14921,17066,17066,19114,19114,19114,17034,17001,17034,16969,6502,21},
{15347,15347,15348,15348,15348,15348,15380,15380,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,21654,21654,19574,34136,52891,59164,59197,59164,57084,57116,57116,57084,57084,57084,57051,54971,50810,50778,48697,46617,48665,48665,46617,46617,48665,48697,48697,48697,48665,46552,42391,40278,38165,38198,38230,40311,46649,54971,48697,44504,50810,52890,50810,50778,48665,44471,40278,36117,36085,40278,46584,15118,6764,17165,17165,15084,12972,15084,17132,19212,19244,19212,19180,17099,21292,19180,19212,19244,23405,23405,21293,19244,17099,21293,23373,29614,27533,23373,40146,54970,54938,50712,46551,52824,50776,50744,50777,54937,50712,50744,52857,52824,52824,52857,52857,52825,52857,52857,54937,54938,57018,54938,54970,54938,54938,54970,54938,57050,54938,42259,12808,12841,10760,14921,12841,10760,14921,10760,21292,21292,10727,17034,14952,10760,10792,12873,12841,12841,10792,12840,10825,14953,10728,10760,12873,12873,12841,12873,10760,17066,14986,17066,19146,8647,17034,14986,14953,14953,12841,12873,12841,12808,19147,21195,21260,19179,17034,12808,17034,19147,17001,14953,6566,8680,12873,6534,2341,44046,56560,52629,37903,33742,42031,54577,37838,52693,50645,52791,59098,56952,59032,48500,42096,46224,29646,33905,46452,46485,46453,46453,48598,48566,46420,46485,44339,46452,44306,46419,46419,46452,54970,54905,52825,48566,23308,12775,25421,21194,6469,25453,10662,14921,19114,6437,23340,23307,6469,31},
{15347,15347,15348,15348,15348,15348,15380,15380,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,21622,21654,38297,54971,55003,57116,59197,59164,59164,59164,59164,57116,57116,57084,57084,54971,52890,50778,48697,48697,48697,48665,48665,48665,46585,48665,48697,50745,48665,46552,42391,40278,38165,38230,42456,46617,52891,54971,54971,50778,52890,52890,50810,50778,46584,42391,40278,38197,36085,38198,44504,21424,10924,29646,29646,25453,23340,23340,25453,27566,27534,27566,27566,23340,25485,27533,29646,29614,29646,29646,27533,27533,21227,27566,29647,29647,29679,29647,33873,57051,52825,38066,25421,42325,42357,42325,42292,44437,42292,44405,44405,42324,44437,46485,46485,44405,44405,44438,46485,46485,46518,46486,46518,46518,46518,46518,46518,48631,44405,31759,14921,14953,14953,19114,17066,17001,19146,14985,17034,17034,17066,21227,17032,19179,19147,6502,10728,8647,19114,17034,8615,17034,8647,10695,14953,14953,10695,12808,6502,23372,21259,21260,23340,17067,23373,21292,12840,17066,12873,12840,14921,10727,31759,29646,33872,29679,23405,10695,19147,23373,29647,25453,8614,8679,12873,8647,10695,46224,58641,50319,23079,27402,27273,52497,37805,52692,52692,54772,54773,52660,50515,50515,46257,48304,27533,25485,33742,35823,38033,27566,48533,44339,38001,33840,33806,31662,25387,29582,35953,38034,46551,48599,44405,38066,19114,8647,19179,17034,2244,21227,8549,8582,17001,2243,17034,17001,6469,21},
{15315,15347,15348,15348,15348,15348,15380,17428,17428,17428,17428,17428,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19574,27895,52923,57084,57052,57084,59197,59197,59197,59164,59164,59164,57084,57084,57051,52891,52858,50778,50778,50778,50746,48697,48665,48665,48665,48665,50745,50745,48665,46552,42391,40278,38165,38230,40311,44537,52890,54971,55003,54971,52890,52858,50810,48697,44504,42359,40278,40246,38165,36117,42391,36084,15085,31760,33840,29647,27566,27566,21292,25485,25453,25453,23373,21292,23373,23372,25485,25453,25453,23372,19179,19147,14953,19179,19179,21228,21260,21260,25519,57051,52825,40179,27534,46518,44470,46518,44405,46551,44437,46486,46551,44438,46551,46518,46486,46550,46518,46583,46518,46486,46486,46518,46550,46551,46550,46551,46550,46518,44372,46453,48566,48533,48565,48565,48566,46518,48566,48598,48598,48566,48631,33872,17033,21292,21292,19212,14954,8680,25518,19212,10760,17034,10760,19211,19179,12841,21260,23373,21292,23405,23373,19212,23405,23373,25485,23372,14953,17034,12905,17066,19179,17066,19179,19147,19179,17066,12808,14921,14921,10760,25453,21227,19147,10760,6534,6534,6534,37903,56560,48272,31530,31564,25225,46256,37805,52660,58966,60981,61080,46518,27501,40114,48370,46289,27533,27565,44241,37935,40146,27533,48565,42291,44339,38032,10662,6502,8614,6502,6534,8550,6534,12873,12840,8615,6502,2308,4421,4356,2276,4356,2244,2244,2211,2244,2276,2211,4356,11},
{15315,15347,15348,15348,15348,15348,15380,17428,17428,17428,17428,17460,17460,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,19574,29975,54971,57084,57084,55003,57084,59164,59164,59164,59164,59164,57084,57051,54971,52890,52890,50810,50778,50778,50746,48698,48697,48697,48697,48697,50746,48697,48665,46552,42391,40278,38165,38165,38198,42456,52891,54971,54971,54939,52890,52858,48697,46584,44439,40278,40278,40310,40278,38197,42423,40310,23504,19213,36116,27600,8844,17198,15051,17132,14986,19179,12906,17099,12906,12938,4584,8712,8713,6535,4454,6502,6534,6502,8550,8582,6535,6599,15019,57018,52824,42259,29614,44438,46518,44470,44438,48631,44405,46518,46551,46518,46583,44438,44437,50712,46518,46518,46518,48598,48663,48631,48631,48631,48631,50712,48631,48631,50712,52824,61276,61244,61244,61244,61244,61244,61244,61244,61244,61244,61211,35919,10727,10792,10792,33937,21260,4389,29712,25486,14921,17034,8615,17066,17066,6534,25518,31825,31825,27631,27598,23373,25518,29646,25453,14954,8647,14954,12841,14953,17066,14985,17066,21259,14920,10760,8647,12808,14921,10695,23373,25518,25486,17033,8582,8582,2308,27468,52531,37968,33774,21195,29581,42030,44143,58902,63094,63094,59099,46453,25388,37968,52530,46289,33742,27533,44372,40146,46485,38065,52759,44274,33710,44306,10565,6534,10727,6469,8614,6437,8582,10760,6502,4454,2243,2243,2276,2179,2276,130,2211,2211,2178,2211,2178,2178,2276,12},
{15347,15347,15348,15348,15348,15380,15380,17428,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19574,38329,57084,57084,52923,50810,54971,55003,57084,59164,59164,57084,57051,54971,52890,52890,52890,50810,50778,50778,50746,48697,48697,48697,48697,48697,48697,48697,46585,44504,42359,40278,38197,38165,38230,48698,57052,54971,54971,54939,52858,50778,46617,46552,42359,38230,40310,42359,40278,36084,38165,42391,29745,17067,31858,29646,8680,21326,46551,46518,46550,46486,42325,44438,44437,27566,14986,14953,19180,14953,8615,10728,6470,10662,8615,8615,10728,8583,17099,48664,46518,38034,14889,33873,38131,38099,36018,38099,33873,35986,35954,38001,40179,35953,38066,38163,38001,38001,38001,38001,40114,35921,38034,33905,37968,40146,35986,40114,38034,44405,59131,57050,59131,57050,57050,57050,57050,57051,57050,54905,50679,33807,10728,12905,12873,17099,17034,14954,17099,17067,12873,19114,12873,14953,12873,12840,17067,25454,19179,17099,12873,10793,14954,14953,14953,10663,14953,17034,10760,14986,17099,12840,12841,12873,17066,17034,10728,12841,10760,14953,17033,19147,14888,12840,14855,14887,10727,29548,54806,35888,31694,25355,31695,35757,48304,52498,50515,57018,52858,46518,21162,33741,50483,48370,31693,12841,38066,14921,40146,17066,44373,37870,25258,46387,23209,6437,12808,6501,8614,8550,8582,12840,8614,4389,2309,2244,2309,2211,2244,2243,2211,2244,2178,2211,2211,2146,2243,13},
{15315,15347,15348,15348,15348,15348,15380,17428,17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,19541,19541,19573,19573,21621,36216,46618,52891,50810,48698,48730,54971,57084,57084,57084,57051,57051,54971,52890,52890,52890,50810,50810,50778,50778,50746,48697,48665,48665,48665,48697,50745,48665,46584,44471,42359,40278,40245,38165,38230,48730,54971,54971,54971,54939,52858,48697,46584,44472,40278,38198,40310,42391,42391,40278,40278,48697,46551,25454,25551,38066,21228,27534,54906,54970,52857,52824,50712,50712,52792,44373,42324,38033,33873,23373,21227,21195,8647,14888,10760,10728,14954,10728,12873,14954,14954,17034,10695,17001,17002,19146,21227,14888,14888,14888,14888,19082,19082,17034,16936,23339,29483,29418,31498,31531,33611,29450,29483,33611,33644,35724,37805,37869,35724,37902,42129,42128,42129,42161,40016,40048,40016,40016,40048,40015,31727,27533,8582,21292,19179,12840,14986,21292,14920,14922,10695,17034,14921,23373,27566,10727,19212,31792,27598,25486,8614,10727,10760,12840,12808,8582,23372,27566,8647,21292,29712,12775,10728,10727,25453,23405,8614,17066,17034,25453,21227,21227,25420,17033,19113,21226,21226,19114,40179,42128,25323,29581,14954,33644,52399,44144,35790,48533,44340,44307,31694,31629,50352,48337,33774,10727,40146,27501,44307,33905,40242,10663,12711,37968,35854,6436,10695,8614,4421,8614,8582,12840,8614,2276,2341,2309,2309,2276,2243,2276,2178,2244,2211,2178,2211,2146,2179,13},
{15347,15347,15347,15348,15348,15380,17428,17428,17428,17428,17460,17460,17461,17461,17461,19541,19541,19541,19541,19573,19573,23702,32023,44537,46617,44537,46585,44537,48665,52891,54971,52891,52923,52923,52891,52891,52890,52890,50810,50810,50778,50778,50778,50746,48665,46585,46617,46617,48665,48697,48665,46584,44471,42359,42326,40278,38165,38198,44537,50810,52891,54971,52891,50778,46585,46552,42423,40278,38198,42359,44471,44471,40310,40310,50778,52858,25421,12841,31694,6469,17002,46486,42357,44405,44405,38164,38131,36019,46583,57051,57018,57018,48598,19114,23373,17034,23340,21260,21227,25453,19147,25453,21292,29614,29647,21259,14889,6437,14824,16969,14888,19082,14921,17001,17001,10630,10630,8484,33840,61244,59163,59131,59163,61244,59131,59163,61244,61244,61244,61276,61276,61244,61244,61244,61244,61244,61276,61244,61212,59164,61276,61276,59130,38033,40211,42259,44405,46486,44372,44372,44340,44372,44405,44372,44405,40244,29678,23373,17034,14986,19179,21260,21292,17066,17066,10793,17033,14953,17034,19179,21260,14954,17067,21227,21259,21260,21292,21292,21259,17034,17066,23372,27533,27566,31791,25420,12840,19114,23339,23339,27566,35953,33709,23242,25388,14888,52464,52464,46223,42128,40081,46420,46452,40113,33774,52465,46289,40048,23340,40179,40146,48598,55001,48694,14856,8550,27436,46354,12710,6501,8679,4421,12808,8582,6534,6501,2178,2341,2341,2309,2341,2211,2276,2211,2243,2276,2178,2243,2179,2146,12},
{13267,15347,15348,15348,15348,15380,17428,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19541,36184,46617,46585,44504,44504,44504,46585,46617,50778,50810,50778,50810,52858,52858,52890,52858,50810,50778,50778,50778,50778,50778,48698,48697,48697,48697,48665,48697,48697,48665,46584,44471,42391,42359,40278,38197,38165,42424,52891,52891,52891,50778,48665,48697,48697,44472,40311,40278,40311,44504,46584,42391,44472,52891,50777,33840,21195,29581,16969,21162,44405,50712,46518,48598,42325,42325,42325,48599,54970,50712,38066,48663,46486,44405,44405,44373,46485,46518,46518,46518,48598,48631,48631,50712,27664,23340,14921,14888,14823,12775,17001,10695,14888,12776,14856,14889,18984,33710,38132,44373,46551,52857,52825,48664,52857,52825,50680,52825,52825,50777,52890,54938,54970,54938,54938,57050,54938,52890,54970,52890,52825,50744,38033,50744,63389,61276,61276,61277,61276,63324,63324,61276,63325,63356,46452,31726,23405,19180,12873,6534,14953,17098,27565,23340,10728,17033,10760,25453,19147,10760,14921,14953,27533,27566,31792,21292,19147,17034,14921,14888,19147,19146,17034,33904,23307,6502,19114,25419,25452,27566,38131,37966,10693,14854,31530,56625,52497,48303,42031,35887,44275,44242,40048,40113,52497,48337,40080,14921,33840,21162,42357,55066,50871,27500,10663,18952,42161,25290,4323,8647,8615,8647,8614,131,2341,2243,2276,2341,2244,2309,2276,2244,2276,2178,2276,2211,2211,2211,98,10},
{15347,15348,15348,15348,15348,15380,17428,17428,17428,17428,17460,17461,17461,17461,17461,17493,17461,21621,19541,23734,34136,46617,46617,44537,44504,44504,44537,46585,46585,48665,48698,48730,50778,50778,50810,50778,50778,50778,50778,48698,48698,50778,50778,48697,48697,48697,48697,48697,48697,48697,48665,46584,44472,42391,42391,42358,40246,38197,44504,54971,55003,52858,46617,48665,52923,54971,46584,42391,42359,42391,48665,48697,46552,46584,48697,46617,44471,42326,25552,17133,13004,33971,46584,42358,44470,42325,42357,40277,42325,40245,38066,17067,29745,44438,42325,42292,40212,42325,42357,44405,42325,42324,44373,42292,44405,23438,42259,35888,40114,38033,38001,42259,38033,42194,38033,37968,40114,44307,50580,33840,40081,35888,21260,19179,19179,21260,19179,19147,21260,21260,19180,27632,29744,31792,29712,27567,27599,29712,29712,29712,27631,29712,44405,33872,52824,57050,57018,57018,57018,57018,57018,54937,57018,57050,52792,42259,33774,12905,14954,12905,12873,17034,14986,17066,14986,12873,19114,12873,19147,14986,10760,12840,12841,14954,17034,14986,14953,19147,17066,19146,19146,14921,17001,14953,19147,21227,10727,21194,23242,25453,23340,29679,48467,16903,33807,37836,54545,54577,48238,42064,40114,44339,50614,42259,50581,50450,42129,42161,27533,35985,42259,44437,55033,52985,35984,8517,12678,31597,42161,21129,23307,17034,8615,8647,21195,23307,4356,2244,4421,2179,2341,2308,2244,4422,2211,2308,4422,2244,2341,2276,11},
{15347,15348,15348,15348,15380,15380,17428,17428,17428,17428,17460,17461,17461,17461,17461,19573,32023,40344,29910,34103,46617,46649,46617,44537,44504,46585,46585,46585,46585,46617,48665,48698,48698,48698,48730,48698,48730,50778,50778,48698,48730,50778,48698,48697,48665,48697,50778,48697,48697,50745,48697,46585,46552,44471,42391,42358,40278,40246,42424,52890,54971,48698,44472,44472,52890,54971,48665,42391,42391,44472,50777,50745,46584,46585,46617,46584,44504,42424,25552,10924,8844,13005,6829,6829,6829,6829,15117,23438,21423,17198,25551,19213,21228,21227,21228,21293,23373,21293,25486,27534,23373,23373,23341,23373,27534,21260,50711,52824,48631,48598,48598,46518,48566,46518,46518,46518,46518,48631,46550,48598,44372,31726,17066,19179,15018,17099,17099,17066,19179,14986,17099,17099,17099,19212,17099,12905,8745,17099,19179,12938,15019,17132,42292,38034,42292,33872,38066,35985,35953,40146,35953,40114,38098,38033,35920,29614,35920,14953,12808,12840,23339,19114,14921,12840,12840,12808,23340,23405,14921,14953,12840,17001,14921,10695,17001,10695,21227,23340,25485,29679,35985,27501,25420,21161,25322,25356,10630,19081,25387,27597,25453,19147,42226,19016,35921,29451,52464,54545,48271,50679,42227,57051,61277,61277,63324,48532,40015,46224,31726,29679,38066,40179,52953,52953,44468,19049,10630,20999,37968,27467,12776,19114,12840,25486,54807,44273,10565,2276,8615,2211,4421,4357,2211,4454,4324,4324,6599,4389,4421,6567,17},
{15348,15348,15348,15348,15348,17428,17428,17428,17428,17460,17461,17461,17461,17461,21621,40377,50778,48698,44537,46617,48698,46617,46617,46585,46585,46617,46617,46585,46585,46617,48665,48698,48730,48730,48698,50778,50778,50778,50778,50778,48730,48697,48697,48697,48697,48697,48697,48697,50777,50777,50777,48697,46585,44504,44439,42358,40278,40246,42424,52890,52858,44536,40311,40343,50778,54971,50778,44504,42391,44504,48697,50777,46584,46617,48698,46584,44472,42423,36084,15117,13005,8844,4684,2635,587,587,4716,13005,6764,10892,13004,15085,21326,36051,38131,36051,38131,38066,40212,40211,38131,38131,31825,35986,35953,27533,40211,23340,23340,19147,21260,21227,21227,23308,19147,21227,21227,21260,23340,19147,25421,21227,17066,17099,14986,15018,15018,14986,17098,14954,17099,15018,15018,17131,14986,12873,6600,15018,19212,15018,17099,17131,44438,38066,52824,50711,52824,50711,52824,52824,50744,54905,52792,54905,54872,48533,44339,40179,40146,40146,44372,42259,40146,40114,40114,40146,44372,44405,21259,19147,19147,23372,23372,19179,23340,19179,25453,21227,27566,25485,23373,27566,27566,19146,21194,19114,21162,21162,25420,27565,29613,23209,42226,48500,54872,46354,48239,52464,52464,52628,46452,48599,52825,50711,56919,46419,44176,48207,31726,27534,50646,48566,52888,46614,40339,29677,4357,12646,25258,38000,29549,14888,23373,56855,58804,44274,16936,2211,6567,4291,6502,10695,2178,8679,8582,2211,4486,4454,2309,6535,16},
{15348,15348,15348,15348,15380,17428,17428,17428,17428,17460,17460,17461,17461,17461,29975,50811,52891,52923,54971,52891,50810,48698,46617,46617,46617,46617,48665,46617,46585,46617,48697,48730,50778,48730,48730,50778,50778,48730,48730,48698,48697,48665,48697,48697,46585,46584,46585,48697,50746,48697,48697,48665,46617,44504,42391,42358,40278,40278,44504,52923,46584,38230,36150,40343,50810,57051,52858,48665,44504,44504,48697,48665,46584,46617,48665,44504,42391,42391,36085,13037,13037,10957,6796,4716,2636,2636,2636,2636,4716,12972,15085,8811,8877,40278,42390,38164,40309,40245,42357,44438,42325,38196,29777,36051,31825,21259,21293,23373,25486,29614,27534,27534,25486,25453,25453,23341,25421,27566,25453,25453,29614,35920,31792,31792,27599,31760,29679,29679,31792,29679,31792,31760,31759,33872,31792,31759,29613,17099,19211,12841,14986,14954,25519,42325,63357,61277,63357,63325,63325,61276,63325,63357,63325,63324,63357,59098,57018,61277,63357,63357,61276,61276,61276,61244,61244,63324,61244,52824,23340,17066,19114,25453,23372,27533,29646,23307,23307,12808,14953,19147,10727,25453,31759,19146,21194,19049,33840,21195,23372,21292,46420,42062,50580,63259,54773,40081,46223,52431,41997,54708,42226,44372,50744,46517,48532,50548,50320,54807,59131,59164,63357,63390,59227,36081,27694,36113,12743,6404,16871,25388,23308,19050,27339,54546,60852,46354,25387,2179,6567,4388,2276,8615,2211,8647,10727,2178,4454,6534,2308,4486,15},
{15348,15348,15348,15348,15380,17428,17428,17428,17428,17460,17461,17461,17461,17461,36216,50811,54971,57051,55003,52891,50810,48730,48697,46617,46585,46585,46585,46585,46585,46617,48698,50810,50810,50778,50778,50778,50778,48698,48697,48697,48697,48698,48698,48665,46584,46617,48698,48697,48697,48665,46585,48665,46585,44504,42391,42359,42358,40310,44504,50810,42391,42391,40311,40343,46617,50810,52858,48697,46584,44504,48697,46617,46617,48697,46584,42423,40343,42391,33972,8877,13037,13037,13037,4716,2636,587,587,2636,4683,13004,10924,2603,6763,13037,10957,8844,10957,15117,15117,25551,25583,21325,17196,12938,17098,17098,38066,31792,33938,36018,38099,38131,35986,36018,36018,33938,38131,40212,40179,38099,33775,48565,54937,50679,50679,50711,50711,52824,50711,50679,50679,50679,52759,50679,50711,42227,35887,14986,14986,12905,17066,14986,14985,31857,54938,52857,52825,52857,52825,52825,52824,50712,50744,50744,50744,48631,54970,57083,57083,59131,59131,57051,57050,57018,57018,57051,57051,46452,25387,14953,21227,21259,29646,25453,25453,21227,25388,23275,25388,21259,27566,25453,33839,29646,27501,23243,27566,27566,27598,25485,35985,63258,61145,52497,50318,40048,48271,54479,46191,46353,42226,46518,40211,46518,50678,54741,59033,63455,65503,65471,65471,63422,50711,33904,23339,12840,6502,4324,8518,17034,16904,20967,20999,50320,62900,50483,33774,2178,8647,10663,131,6567,4324,2244,4486,2178,2341,6534,196,4454,16},
{15348,15348,15348,15348,15380,17428,17428,17428,17428,17460,17461,17461,17461,29943,44570,52923,55003,57051,55003,52891,50810,50778,48698,48665,46585,46585,46585,46585,46585,48665,50778,50810,50810,50810,50778,50778,50778,48698,48697,48697,50778,50778,50778,48665,46585,48665,48697,48665,46585,46552,46584,46617,46584,44504,42391,42359,42359,42391,48697,50810,48665,44504,46585,42391,40311,46584,50745,44504,44472,44472,48665,46585,48665,48697,44504,42423,40343,42391,34004,6829,8909,13005,13005,8876,6796,2635,555,2635,2635,8876,8844,6731,8843,6731,522,522,6731,8843,10891,23536,23536,19212,19179,8712,14986,19211,40212,36051,38132,36051,36084,40277,38164,40212,38131,36051,40277,40245,40244,40212,29549,42259,38066,29646,23340,29614,25453,31727,29614,27501,31727,27533,31727,27533,25420,35985,35920,19114,19147,14953,17033,12905,14986,17066,17099,21260,17066,19179,19179,19147,21259,19081,21260,19180,17066,21260,25518,27599,27631,27599,29679,27566,27566,27566,25518,27566,35985,29614,33839,29614,35985,33840,38098,35953,35985,33840,35920,38000,40178,40211,44372,42259,44372,44372,42227,42226,44372,42357,27566,21227,21227,40180,40048,52399,54479,48271,46158,50286,46126,44045,42096,48598,48631,46486,44306,50678,59164,59131,57051,57083,54970,59164,46420,42356,38129,19114,19179,27598,17034,17002,27403,37871,33677,46191,62900,52628,35887,12742,21227,21195,14823,17034,16969,16968,19114,19017,19082,21227,19114,21194,84},
{15348,15348,15348,15348,17428,17428,17428,17428,17428,17460,17461,17461,19541,25782,38296,48698,50843,52891,52891,52891,50810,50778,50778,48697,46617,46617,46617,46617,48665,48697,50778,52890,52890,50810,50810,50778,50778,48698,48697,50810,50810,50778,50778,48665,48665,48665,46617,46584,46584,46552,46584,46552,44504,44504,44471,42391,42391,44504,54971,55003,50810,40311,44504,38198,36085,42424,46584,42391,40311,40311,46617,48665,46617,46584,44472,42391,40343,42391,23537,6797,6829,10957,15085,15117,10924,6796,2635,2636,2635,8844,8811,10892,6763,6731,6731,4683,8811,8811,8843,21424,33971,27534,23307,8744,10857,23372,35888,21325,15084,27664,44405,40146,40049,33840,33807,38033,38033,48533,46453,29647,27468,35888,31727,29647,29647,29646,31727,35953,33840,31760,33840,33872,33840,33808,33840,54970,52792,46485,48598,46453,46485,46517,46485,46485,46518,48598,48598,48598,48598,48631,46453,27468,29679,25486,25453,27566,23340,27566,23373,25453,27534,23340,27534,23373,23372,25420,31727,35920,56986,61244,61212,61212,61244,61244,61244,61244,61244,63324,61244,61244,61244,61276,61276,61276,61276,63357,63357,48597,25420,17001,19114,14888,19049,52399,56559,48141,48173,54577,50416,50319,50449,54872,50712,46485,44306,50613,46485,48565,48500,48532,44306,52792,48631,44501,42516,40403,42484,40275,19114,10630,31629,35887,33774,44078,62900,50450,40113,40113,40113,42161,42194,42194,42194,42194,42194,42194,42194,42194,42193,42161,163},
{15348,15348,15348,15380,17428,17428,17428,17428,17428,17460,17461,23701,36183,36183,25750,32023,44569,50810,50810,50810,50810,50810,50810,48730,48697,48665,48697,48697,48698,50778,50810,52891,52890,50810,50810,50778,50778,50778,50810,52890,52890,50810,50778,48665,46584,46552,46584,46584,44504,44504,44504,44472,44471,44472,44504,44471,42391,48697,57084,61245,52858,38230,40311,34005,34005,42391,42424,38230,40278,42391,48665,48697,46585,44504,44472,42391,40311,36085,10990,6829,6829,6829,13037,15117,15085,8844,4716,2635,2635,10924,8811,8811,8811,6763,4651,4683,6731,8811,6763,19278,44275,42097,19147,17098,12937,14986,29646,23339,10760,15051,42195,37968,48435,42129,35790,44242,46355,42129,40114,50581,38000,44372,40179,40179,38131,40179,44405,46485,44405,42357,42325,46518,44405,46485,48664,42390,48631,59131,44405,50679,48599,48566,48599,44405,46518,46550,46486,46518,42292,46486,46486,27533,21227,21260,29647,29647,25420,31759,25421,27566,29646,25420,29679,25453,25453,29679,42259,42259,57018,57051,57050,57051,59131,57083,57051,57050,57050,57050,57018,57050,57050,57050,57050,54970,57050,57083,50679,27533,27500,19114,21194,16969,19082,48238,54446,46125,60948,65207,48401,48206,50352,52792,50712,54970,61309,63357,63357,63357,63357,63389,55003,52858,48632,44533,40435,42516,44597,36081,19082,8549,29516,33709,31661,41965,60819,54611,50646,50646,50646,50678,50678,50678,52727,52727,52759,52759,52759,52759,52791,52791,208},
{15348,15348,15348,15380,17428,17428,17428,17428,17460,17460,19541,36183,46617,48698,44505,40344,46618,50810,50810,50810,50778,48698,48730,50778,48697,48665,48697,48730,50778,50810,52891,52891,52890,52858,50810,50810,50810,50778,52890,54971,52891,52858,50778,46617,44504,44472,46552,46584,46552,46552,44504,44471,44471,44439,44471,44471,44471,50810,59197,57052,40343,38198,36085,33972,34005,42423,44504,40310,42391,44504,46585,46584,44504,44504,42424,42391,42391,31859,6797,6829,6829,6829,8877,13037,17198,13037,8844,2635,6764,15052,12972,8811,6731,8811,6763,8811,6731,8843,6763,21391,48403,35758,27534,19212,17130,12873,21292,12905,14953,17067,42194,42129,38033,31760,35920,35823,37936,44177,40016,37968,38066,50712,44405,40212,40244,44438,48599,46518,46551,44438,42292,44438,40179,40244,46485,37935,40147,40147,25453,29614,31727,27534,31727,27534,27566,31759,29646,31727,29646,31759,35920,35920,33872,29711,27598,29646,29678,29711,27598,29646,29679,27566,29679,27598,25485,27566,42260,35888,50712,48599,46485,50712,46518,48631,50711,46486,50711,48566,46485,50712,46518,50679,50679,46485,50711,46518,44372,27566,25452,19114,19146,17001,17001,41965,52301,54610,65272,60785,44046,48206,50384,48631,54938,63390,63422,63422,63422,65503,65471,54938,42489,48664,48664,42517,40435,42516,44597,36017,21227,8517,27403,31629,31629,39885,60787,59066,63390,63357,63357,63358,63357,63357,63357,63357,63357,63357,63357,63357,63357,63357,243},
{15348,15348,15380,15380,15380,17428,17428,17428,17428,17460,23669,38296,48730,50778,50778,50810,50810,50810,50778,50810,48698,48665,48665,48665,46617,46617,48697,50778,52890,52891,52923,52891,52890,52858,50810,50810,50778,50810,52891,54971,52890,50810,48697,46584,44472,44472,44504,46552,46584,44504,44504,44472,44471,44439,44471,44504,46584,54971,59197,44504,34037,36085,34005,31924,34004,40343,44504,42391,44472,44504,44472,44471,44504,44504,42424,42391,42391,38197,8909,6829,8909,6829,6829,10989,15117,15117,13005,2635,8844,12972,12972,8843,6763,8811,8811,8843,6731,10891,6731,15085,40147,42161,44340,33840,19179,27468,29581,12841,21259,17066,44308,40113,25421,46453,42227,31727,33807,35855,25356,33742,44340,48599,46388,44243,40147,52792,40146,40179,52825,48533,48533,48533,40016,29548,44208,52628,44372,38099,38098,40146,40179,42259,40179,38099,38131,38131,42292,40212,46485,48598,42260,44404,25485,23405,21292,25485,21259,27565,23372,23372,25485,21259,27533,25453,23340,27566,38034,46485,54938,54905,52824,54938,52792,52824,54905,52824,54905,54872,54872,54937,54905,54937,54938,54905,54937,57018,46485,31760,23340,19114,21195,19082,17034,35692,52399,63160,60948,58477,52301,48370,48500,38033,38001,48599,50679,50711,46453,36019,35985,17199,34234,46518,44469,44597,42484,42516,42517,35984,25388,8517,25354,29516,27435,35692,58837,58999,61014,61047,61080,61046,61079,61047,61014,61080,60981,60949,61047,60981,61047,61047,233},
{15348,15348,15380,15380,17428,17428,17428,17428,23669,36184,44537,48730,50778,48730,50810,52891,52891,50810,48730,48730,48698,48697,46617,46617,46617,48665,48697,50778,52890,52923,52891,52891,52891,52890,50810,50778,50778,50778,52890,52890,50778,48697,46585,44504,44472,44504,46584,46584,46552,44504,44504,44504,44504,44471,44472,46584,48697,52923,46585,36118,34037,34005,34004,31924,31924,40311,42391,40278,42391,44504,44504,42391,44504,46584,44504,42391,40311,40343,19376,4749,6829,6829,6829,8877,15117,15117,10957,4716,13004,12972,10892,8811,6763,8843,10923,12972,8811,10891,8779,10924,31695,44242,40179,29614,21227,29581,19147,29613,21291,25485,46322,35920,40179,46518,25453,25453,33840,35855,42194,50581,44306,42194,33873,35822,27534,44274,35888,33873,38099,44307,40081,42195,48533,37935,42031,42129,50711,44438,44373,44373,44372,46550,44437,46518,48631,46518,50744,46551,48631,50744,37968,50679,40146,35985,40179,42292,31824,40211,38098,35985,38098,31792,40211,35985,38066,40179,42259,57051,59163,59164,59164,59163,59131,59098,59131,61211,61211,61211,59163,61211,61244,61244,61244,61244,63324,42357,25485,29614,21227,29614,29646,29614,27533,37837,58935,63225,56527,58444,58510,61147,52759,35887,33839,40114,35887,40113,33742,4292,4356,6698,27993,46584,46614,42516,42516,42548,44597,35985,27501,6404,21161,29516,25355,33676,58935,58802,60882,60981,60916,60915,60981,60882,60948,60948,60817,60948,60948,60915,60982,60915,232},
{15348,15348,15380,15380,17428,17428,17428,17460,32023,40376,46617,48698,48698,50778,50811,52891,52890,50810,50810,50778,48730,48698,48697,48665,48697,48698,50778,52890,52923,54971,52923,52923,52891,52890,50810,50778,48730,50778,50810,50810,48698,48665,46584,44472,44471,46584,46617,46585,46584,46584,44504,46552,46584,46584,46585,48697,48730,46585,38231,36117,34037,34004,33972,31892,31892,36150,40278,38230,40343,44504,44472,42391,44504,46585,44504,42423,40311,40311,31924,6797,4749,6829,6829,6797,8877,15117,10957,6796,13004,15084,8843,6763,10892,10891,12972,12972,6731,8811,12972,19213,42162,40114,37968,27566,27534,33742,12873,19244,31727,27534,42129,33905,31825,35953,33839,33807,33840,40114,42194,38001,46485,42227,37935,29483,19115,38000,31661,27501,31694,46420,25387,27566,48500,46387,54774,54676,46420,44373,42194,38034,46453,42194,44307,54806,46518,44406,46551,48664,40114,29582,25388,52825,50744,46518,44469,50744,48598,48598,46485,46550,48663,42357,48631,48631,46518,46485,44242,59131,57050,54970,54970,54938,54905,54905,54937,52857,52825,52825,50776,50744,50744,48632,50712,52825,44438,33905,31792,52824,40049,35823,33710,31597,31565,33743,61212,63259,58543,58477,58673,61277,56985,39983,35888,38000,35887,38000,33806,4356,4356,6632,23799,38361,46517,44597,42548,42549,44597,35984,29614,14855,35887,35920,33872,52726,58900,60882,60980,61014,60915,60981,60948,60915,61046,60915,60916,61014,60948,61014,60981,60916,231},
{15348,15348,15380,15380,17428,17428,17428,17460,25750,36216,46618,48698,48730,50810,52891,52923,52923,52891,52858,50810,50778,48730,48698,48730,48730,50778,50810,52923,54971,54971,54971,52923,52891,52890,50810,50778,50778,50810,50810,50778,48697,46585,46552,44472,44471,44504,46584,46617,48665,46585,46584,46584,46584,46584,48697,50777,48665,42391,38230,36117,34037,34004,31924,31891,31891,34005,38198,38230,40278,42391,42423,42359,44472,46584,44504,42423,42391,40311,40278,17231,4748,6829,6829,6829,6797,8909,10957,10924,15052,15084,12972,6731,6763,4683,4683,6763,8811,6731,8811,10924,25584,27632,44242,27533,19211,23340,25485,25453,21260,35920,44274,33840,31825,42097,33807,35920,31824,42226,44274,35887,37936,40147,40081,33774,40081,44307,33774,31694,25420,33840,33773,40146,46387,35855,52628,54610,42096,48468,42031,23307,40048,44176,29484,33774,42227,44438,48599,48664,37870,31563,29647,50712,46518,46550,44470,50712,46486,48631,50744,46551,48696,46551,48631,50712,46518,40048,44208,38033,21292,21292,19212,21260,21292,17099,19212,17099,19179,19211,15018,17066,12873,8680,21293,21260,2341,31759,57018,59131,46420,46421,46421,46420,46420,44340,48599,48533,54447,56494,42129,33938,29614,42128,35887,33806,33774,40113,40113,6436,4291,6567,19541,34299,42292,48500,44501,44565,44566,42355,46386,50514,48434,46354,48467,59032,61047,61047,61112,61047,61047,61080,61014,61080,61047,61014,61080,61014,61047,61047,61047,58999,237},
{15348,15380,15380,17428,17428,17428,17460,17460,21589,38296,50843,52891,52923,54971,54971,54971,54971,52923,52890,50810,50778,50778,50778,50778,50778,50810,52890,52923,54971,54971,54971,54971,52891,52923,52891,52890,54971,52890,50810,50778,48665,46585,46552,44504,44471,44471,44472,44504,46617,46585,46584,46585,46585,46585,46585,48697,46585,40311,38198,36117,34005,33972,31892,29811,29811,31924,34005,36117,38198,42391,42391,40310,44472,44536,44504,42423,42391,40343,40278,38198,21425,6797,6829,8909,6829,6829,10957,10924,15085,15084,15052,12972,10924,10891,10891,10924,10891,6731,8779,4650,27665,40212,33873,8712,21292,42227,31792,31760,31727,44209,40081,25486,27697,46354,23307,27501,37936,44273,46322,42162,42194,50646,19114,19146,25452,35887,21162,31694,46386,31694,35888,42226,42063,35757,48533,50450,52595,59065,46322,27468,50449,46322,27469,33743,48501,46551,52825,48599,33774,25355,33873,50744,46550,48663,44470,48696,50744,48599,52825,48664,46551,48664,46519,48664,48631,44144,48402,33807,14986,17099,17066,17066,17066,14986,17098,14953,14986,15018,12873,14986,8712,8615,21260,19115,25453,52824,59098,59196,40081,29451,27371,27306,23178,23210,21032,16904,45996,54512,35920,31694,35953,38000,35855,35887,33806,40113,40146,16968,12743,10695,13201,36347,35953,27174,35562,46451,48824,50709,58803,58770,56820,62963,60981,58868,60850,60949,61013,60947,61014,60948,60915,61014,60915,60981,60948,60882,60949,60981,60981,60981,189},
{15348,15348,15380,17428,17428,17460,17460,17428,23701,46650,55004,55003,55003,55003,55003,54971,54971,52923,52891,52890,50810,50778,50778,50810,50810,52890,52891,52923,54971,54971,54971,54971,54971,54971,54971,54971,55003,54971,52890,50778,48665,46585,46584,46552,44472,44472,44472,44504,46584,46585,46617,46617,46584,46585,48665,50745,46584,40278,36118,36085,34005,33972,31892,29811,29811,29843,31892,34004,36117,42391,40310,40278,42424,44504,44504,44472,42391,40343,40278,40311,42391,21457,6797,8909,8877,6829,6829,8876,15085,13004,15052,12972,12972,10924,10891,10924,12972,10891,12972,6731,21391,38099,27534,8713,12906,29647,33808,38131,31662,40081,44242,27566,23666,31825,10760,25518,33905,29647,35953,35888,44307,44241,37967,17065,21226,27532,17001,21260,44274,25387,25355,37901,19049,23275,44405,50483,56789,46387,54839,46354,50449,44241,27501,29581,46388,40212,42325,44437,25355,14921,42292,52857,44405,46551,46518,48631,50744,46550,50744,48664,44437,48663,46550,46583,48599,39919,44339,27501,14986,17066,14953,14986,14953,12873,14986,12841,14953,12873,10792,12873,8647,8615,12841,27566,56985,59164,57050,61277,46420,35790,35823,35790,33742,35823,35790,33743,44046,48304,42227,44405,46517,31628,33742,33742,40080,33807,40178,19082,4324,8550,10990,32120,31693,27207,33318,48531,48791,54708,58770,54642,58868,60915,60981,58802,60915,61014,60947,60980,60981,60915,60981,60948,60948,61013,60915,60948,60981,61013,60981,44077,79},
{15348,15380,15380,17428,17428,17460,17460,17428,32023,52923,54971,55003,55003,55003,55003,55003,55003,54971,52923,52891,52890,50810,52858,52858,52858,52890,52923,54971,54971,54971,54971,54971,55003,57052,55003,55003,55003,54971,52891,50778,48697,46617,46584,46584,46552,44536,46584,46552,46584,46585,46585,46585,46584,48665,50777,50810,48665,40311,36117,36085,36053,34004,31892,29811,29779,29811,29811,29811,36085,40311,40310,40310,42424,44536,44504,44472,42423,40343,40310,38230,42391,44472,17264,6829,8909,6829,6829,6796,15085,15085,15084,12972,12972,12972,12972,12972,12972,12971,12972,8811,12972,42130,37936,14986,10825,23373,40114,40146,31662,27599,25453,40147,42292,29647,12873,15018,27566,31793,52694,31597,35921,25355,29614,25419,21291,35919,33807,46452,33838,10759,21226,23307,8614,21128,31726,42129,48304,44078,46354,23243,44111,54774,38033,35822,35789,35855,40145,46453,31661,21228,42260,42260,29712,31857,42357,46518,48631,46551,46551,46551,44437,46518,46518,44470,50711,27500,19114,17034,19114,19146,21227,19114,17034,17034,19082,17001,17001,17001,14921,12808,12808,10727,10728,44405,52792,54938,56985,57051,50679,44275,35952,40113,40081,35887,33807,29581,35822,46158,35986,48631,57051,44306,33709,27435,37968,17002,23308,19082,10695,8550,8779,32088,31662,50285,50187,40145,52724,60949,58835,56788,60915,60981,58803,56723,60982,58901,60980,58933,60948,61013,60981,60948,61014,60981,60981,61014,61013,56820,33643,14725,48},
{15348,15380,17428,17428,17428,17460,17460,17461,40377,48730,50811,52923,55003,57084,57084,57084,55003,52923,52891,52890,52858,52858,52858,52858,52890,52891,54971,54971,54971,54971,54971,55003,57084,57116,57084,57084,57051,54971,52890,50810,48730,48665,46585,46585,46584,46617,46617,46585,46585,46617,46584,46584,46584,48697,50778,52858,50745,40311,36085,34037,34036,34004,33972,29811,27730,27730,27730,29811,34037,38230,40278,40310,42423,44536,44504,44504,44472,42391,40311,40311,42391,44536,40278,10990,8909,8909,8877,8876,15085,15085,15052,12972,12972,12972,12972,10891,10924,12972,12972,12939,10891,40081,54611,23307,19146,25454,40180,31728,46289,27533,25453,35921,44209,37903,8680,15018,23373,40277,46420,40016,35920,25452,27599,44339,25452,37935,48402,40080,21226,12840,25420,23306,25353,42062,42129,40147,52596,50581,48467,25420,48336,54873,65535,61080,50352,40080,42226,48533,50613,40146,33840,35921,12906,12906,19212,25486,17100,25519,25486,23406,23406,23373,23373,27599,40212,23340,14921,17001,19082,19081,21194,21194,21194,19114,17033,17001,17001,16969,17001,14921,14888,12808,14953,36018,46518,54970,56985,35920,27501,33677,27402,31629,25387,25322,21161,23210,27403,44242,31923,42325,54970,42421,35887,29516,23275,8582,4356,12776,10662,8549,12842,40409,50482,60752,33513,29516,42193,42161,50547,58901,61047,61014,60982,61079,61046,61046,61079,61014,61079,63094,61046,63127,63062,61047,63127,63160,60982,33611,14725,10597,33},
{15380,15380,17428,17428,17428,17460,17428,23701,46618,48730,50811,54971,55004,57116,57084,57084,54971,52923,52890,52890,52890,52890,52890,52890,52891,54971,54971,54971,54971,54971,55003,57084,59197,59164,59164,57084,54971,52891,52890,50810,50778,48697,48665,48665,48665,48697,50745,48697,48697,48665,46585,46584,46584,48665,50810,50810,46584,38198,34037,34005,34004,34004,33972,29811,27730,27730,27698,27731,36085,38197,38165,38230,44504,46585,44504,44504,44504,44472,42391,42391,44472,44504,46617,31924,8877,8910,8909,10957,15117,15085,15085,15052,13004,12972,12972,10891,10891,12971,10891,10891,13004,34036,46485,31662,27534,38066,44340,37968,37936,37967,27534,29614,50613,42194,27566,31792,17132,40147,31695,35856,38001,31759,25453,42194,21259,29580,37903,42161,19081,10759,42259,31662,46256,42194,33807,48598,52628,52661,46420,38000,50482,48632,55003,56953,54774,40048,44274,50645,54839,46420,21227,19147,19179,25486,31825,31793,31792,33905,33873,33873,33905,33873,33873,35986,31759,27533,21227,19114,17001,17001,19114,19081,19081,19114,19114,19081,19081,19081,19049,16969,17001,17001,17001,23340,42324,54938,56986,31661,27468,37870,25322,33741,33774,27435,19081,25355,29548,52825,46518,44404,46550,42389,44175,33611,16936,8582,2243,12743,12743,10597,10728,38165,54839,44209,50384,39950,29516,42095,52530,56821,60916,60915,60982,60948,58900,58933,58868,58901,58868,58868,56820,56722,54707,56788,56788,54773,46321,37935,35757,25094,93},
{15348,17428,17428,17428,17428,17460,17428,29943,50778,52891,54971,55003,55003,57084,57084,57084,54971,52923,52891,52891,52890,52890,52891,52923,54971,54971,54971,54971,54971,54971,57051,59164,57084,57084,59164,57084,54971,52891,52890,52858,50778,48730,48730,48730,50778,50810,52858,50810,50777,48697,48665,46584,46584,46617,50778,50745,40311,36117,34037,34005,34005,34004,33972,29811,29778,27698,27698,27730,34004,36085,36085,38198,44504,46585,44536,44504,42424,42424,42424,42424,46584,46584,48697,50745,19344,8909,8909,8877,15085,15085,15085,15084,13004,15052,15052,10924,10892,12972,12971,12971,19245,23405,33873,35953,25421,35986,35921,44275,25388,27566,40081,40049,44307,33808,33775,35986,12905,27566,40146,33742,35823,42194,35888,29549,19081,23339,44340,50581,23307,15018,44372,31596,52563,33710,38001,52595,48304,44176,40179,54774,50515,44405,46551,50777,40244,31726,38000,48499,48565,54871,52726,50646,40146,44406,48664,48664,48663,48631,48631,48599,48599,46518,44438,46486,40179,50744,54905,46453,27468,27467,29613,27435,27499,29580,27467,29580,33773,27467,25355,27500,27500,25354,23307,19114,38099,57017,59098,44339,31694,42096,29483,33774,33774,31628,27435,31628,46485,54937,44372,48696,46583,50645,60949,42128,21129,31662,21064,33742,25355,31661,16904,29713,50712,44406,40376,29778,27142,29320,35594,33513,33481,31433,27273,31400,25192,33705,25384,19079,14951,15015,8742,8677,8710,25224,20965,19083,36216,57018,50580,35527,130},
{15380,17428,17428,17428,17428,17460,17428,27862,46650,52891,54971,55003,55003,57052,57052,55003,55003,54971,52891,52891,52890,52891,54971,54971,54971,54971,54971,54971,54971,54971,57051,57116,57084,57116,59164,57084,54971,52891,52891,52890,50810,50810,50810,52858,52890,54971,54939,52890,52858,50778,50745,48665,46552,44504,46584,42391,38198,36117,36085,36085,36085,34004,31891,29811,27730,27698,27698,27730,34004,36085,36117,38230,44504,46585,46585,44536,44504,44504,44472,44504,46584,48665,52890,54938,38197,8909,8909,4748,10957,15117,15085,15052,12972,12972,19245,17164,8811,10891,12971,12971,21325,29646,23340,4552,10826,31727,33840,33808,31629,19180,44340,42194,38066,48435,37871,21227,19179,33872,42227,40016,42161,25421,31662,33644,35725,25323,35920,46322,27500,23372,48435,39983,50613,37968,46453,54675,48271,35790,44340,52694,42194,52792,40243,29710,35854,31726,44306,54773,46353,42160,42225,54839,37967,38131,33970,36083,40212,38132,38131,36018,27663,25583,23438,27599,50712,59164,59164,52792,31726,29581,31693,31661,31660,33774,31661,33741,33806,31661,29580,29580,31693,33774,33774,25388,44340,65306,61146,48533,42226,40016,35790,31628,21162,21162,16903,31693,50777,46485,44437,48728,50711,60981,56920,50744,27501,42292,25355,42259,27501,46485,25387,21293,50712,44438,30073,32088,27142,22917,29158,27077,25029,27110,20901,25029,20901,27269,19012,23302,12933,6724,13062,13062,8805,10790,12742,42260,57018,57018,40113,18951,104},
{15380,17428,17428,17428,17428,17460,17428,23702,44537,48730,52891,54971,55003,57084,57084,55003,54971,54971,52923,52891,52923,54971,54971,55003,54971,54971,54971,54971,54971,55003,57084,57084,57116,57084,57051,54971,52890,52891,52891,52891,52890,52890,54939,54971,57051,55003,55003,54971,52890,50810,50777,48665,46584,44472,40311,38165,36117,36117,36085,36117,36085,34004,31891,29779,27730,27698,25618,27698,31924,36085,36117,42391,46585,46585,46649,48730,46617,46584,46585,46584,48665,50778,55003,57051,54970,25618,8909,8877,10957,15085,15085,13004,8844,8843,15084,27598,17164,10891,12971,12971,21326,25421,21195,2439,2472,23340,37968,27469,29647,35888,44438,35921,46518,33872,6568,6599,19211,33936,38032,40048,42194,33807,31661,33775,37902,21194,35888,44274,37903,29548,31564,44307,40113,50613,54905,54708,35822,33742,46486,40081,42194,52662,40211,27598,29612,25517,40146,46387,38032,33872,33840,52758,35822,40179,12937,21325,27632,25519,25518,23373,6728,6695,4550,8583,38100,46583,48696,38098,27501,31661,31660,31660,33741,35854,35854,35854,35854,33741,33741,33741,33774,33774,33741,29548,52660,56952,61113,54740,44307,42031,52595,44273,42193,42030,41997,44405,46550,42292,52857,48695,58934,52563,38099,52792,27501,35953,31661,40179,31694,44372,27435,17034,46519,50712,38427,34234,37707,39689,41769,39689,39721,39689,37609,37641,35528,31462,21221,12901,21448,13062,8805,6692,4516,6629,42356,52824,57018,59099,40146,2211,102},
{15380,15380,17428,17428,17428,17460,21589,38296,44569,48730,52891,54971,57052,57084,57084,55003,54971,54971,54971,54971,54971,54971,54971,55003,55003,55003,54971,54971,54971,55003,57084,57084,57084,54971,52891,52890,50810,52890,52891,54971,54971,55003,54971,55003,57084,57084,57084,55003,54971,52890,48697,48665,46584,44471,40278,36117,36117,36117,36117,36117,36084,33972,31891,29779,27698,27698,25617,27698,31891,34004,38198,44504,46617,46617,50843,57084,50778,48697,48697,48697,50778,52858,57051,57084,57083,50777,17264,8877,10924,13037,13005,13004,10924,8843,10924,17197,19277,21357,19245,13004,33905,27534,25388,4520,2472,27501,23339,37968,35888,38034,46421,38001,42325,31825,14921,10825,29709,29709,40177,42227,31694,42226,44272,31726,31694,21227,27403,27403,42129,33742,31662,21227,25420,54806,50612,37967,27468,25388,29614,42194,44340,44177,40179,27630,27597,23371,23404,35757,31727,31759,31727,50645,44306,33873,10857,21325,31793,29680,27599,27567,13002,13002,6695,4389,8583,12939,10891,23341,21227,35919,35854,35853,37901,35853,37966,37966,37966,35853,35854,35886,31693,33774,33806,25355,31693,29613,52824,48500,50515,63094,63225,63323,65403,54675,48206,44372,44372,42356,50776,46453,50712,44405,35986,52825,33872,31792,42227,42324,33840,42260,31693,14889,46519,46682,34267,38231,50286,43947,33481,29288,27175,23014,18853,18821,16740,12612,25447,23399,19304,21448,17255,12966,8677,33872,61212,54872,57018,57018,50646,4323,92},
{15380,15380,17428,17428,17428,21621,40377,46650,48698,48730,52923,55003,55003,54971,54971,55003,54971,54971,54971,54971,54971,54971,54971,55003,55003,55003,54971,55003,55003,57084,59164,59164,57084,54971,52891,52890,52890,52890,52891,54971,55003,55003,54971,55003,57084,57116,57084,57051,55003,54938,48665,46584,44504,44471,40310,38197,36117,36117,36117,36117,34004,33972,31891,29779,27698,27698,25617,27698,31891,34004,38198,44536,48730,48698,48730,57116,50810,50810,52858,50778,50810,54971,57051,57084,54971,52890,36085,6829,8876,13005,13005,13005,13004,10924,10924,8844,8843,19244,25518,23438,33873,40146,37936,14986,6632,12874,31662,40049,31727,33872,31727,25420,38099,36083,19115,12905,27629,25419,35887,38001,42128,44241,44241,23339,27467,23306,27436,19082,46420,35758,40147,19179,33872,63324,61015,39950,25322,27435,31596,27435,40212,52760,44405,29710,48597,44436,40178,39950,31759,23503,15148,25616,46453,23437,10889,21325,31825,29680,27632,29712,21356,19308,8808,4389,23275,21260,4585,27534,19114,38000,35919,35822,29515,37935,37967,35887,38032,33741,31661,31661,33774,35854,27500,25387,29548,27467,42325,59098,61178,54838,50613,48532,52857,56919,48271,50613,52824,40341,46484,44241,46519,46486,40179,52759,44175,44175,48336,48336,42030,48369,46190,19048,42390,42587,32219,31826,22852,18789,14628,14660,12548,14628,14725,10499,6307,4259,8483,14950,12934,12935,15047,15047,14982,35953,61211,58999,48566,35953,54872,14823,80},
{15380,15380,17428,17428,17428,17461,29975,44569,48730,50778,52891,52923,54971,54971,54971,55003,57051,57051,55003,55003,54971,54971,54971,54971,55003,55003,57051,57084,57084,57084,59164,59164,57084,54971,54971,54971,54971,54971,54971,54971,54971,55003,55003,57084,57116,57116,57084,57051,54971,52890,48665,46552,44504,44471,40310,38198,38165,36117,38165,36117,36084,34004,31891,29778,27698,27698,25617,27698,29843,34004,38198,44536,50778,48730,44569,57084,50810,50810,52890,50778,50810,52858,50778,52858,48697,48697,48697,13038,6796,13037,15085,15085,13004,10924,10924,8876,10924,17164,15084,19245,33873,40114,27534,27501,8745,17099,38099,42259,38001,40147,38000,27565,33872,35986,25420,14953,17131,40114,44274,35790,35822,44307,33839,12872,25386,23306,25420,29714,48600,48435,40114,33840,29613,50646,48370,35887,31563,31563,31595,29515,38066,48631,42325,29613,52725,50742,35887,39918,29646,21357,17196,21357,40212,33970,17163,21325,33906,31793,21356,19276,17195,17195,13001,10695,27468,23373,6731,23374,19147,38032,33774,35854,33741,37934,37934,37934,40047,37902,35821,37934,33709,33741,29580,31628,29580,29515,35953,57051,57051,44340,40113,40113,48664,59032,50286,48500,52923,46550,58901,50613,57019,50744,40179,54643,58704,60818,58737,58770,58770,58770,58770,33643,36117,38427,32219,31990,27077,23112,12742,18853,6469,18821,19049,14758,6339,4291,10500,12743,8645,12903,12870,8678,17095,27597,56986,42129,35953,40179,57050,29613,61},
{15380,15380,17428,17428,17428,17428,23702,42425,46618,50810,50811,52923,54971,55003,55003,57052,57084,57084,57084,57052,54971,54971,54971,55003,57051,57084,57084,57084,57084,57084,59164,59164,57084,57084,57051,55003,54971,55003,55003,57051,57051,57084,57084,59164,59164,57116,57084,57051,55003,52858,48633,44504,44471,42391,40310,38198,38165,38165,38165,36117,36084,33972,31859,29778,27698,27698,25617,27698,29811,34004,38230,48697,52923,50810,46617,48698,50810,50810,52858,50778,50810,50778,48698,48697,44537,48697,50777,15150,6796,13005,15117,17165,15085,13004,8844,10924,17164,15084,15084,10923,17230,40114,38033,29646,8712,17099,29679,35985,33905,42227,31661,31759,35986,44372,27468,10824,19211,40114,46322,40081,37968,50547,25452,12872,21194,27468,25420,50712,50581,42194,52726,31727,29614,59098,48302,46354,44240,44208,44208,46288,48468,42227,44405,42161,52790,48629,35888,27468,25420,27565,27533,31759,50745,44437,19276,21325,33905,29712,17195,15114,17194,15082,13001,16967,31662,27763,34004,25453,14921,35919,31694,31693,33806,35887,35887,40080,44274,37999,29580,42226,35854,33742,35919,31661,29548,29548,38001,54970,54970,46519,46551,50712,50777,56984,48303,35952,46616,61048,56822,54970,50712,50711,44405,54872,52759,54840,52727,56953,54872,54872,54840,31661,19442,38459,30105,32120,29288,27175,23079,27142,20998,25062,20966,16805,14660,10532,12548,14823,14888,14951,10790,8678,10790,27598,52792,33839,27566,52825,61244,35920,51},
{15380,15380,17428,17428,17428,17460,19509,34103,44537,50810,52891,54971,55003,57051,57052,57084,57084,57084,57052,55003,55003,54971,54971,57084,57084,57084,57116,57084,57084,57116,59164,59164,59164,57084,57084,57052,57051,57051,57084,57084,57116,59164,59164,59165,59164,59164,57084,57051,54971,52858,46584,44472,44471,42391,40310,38198,38198,38198,38198,38165,36052,31891,29811,29811,29778,27698,27698,27698,29811,34004,40278,50842,57051,52891,50778,48698,48730,48730,50778,48697,48697,48730,48730,48697,44536,46649,48697,17264,6796,10957,15085,13004,13004,13004,10924,8843,17197,10924,13004,15084,10924,42227,29614,12938,6632,10826,19244,15050,23404,31727,25453,38034,42325,44340,23243,12873,19211,33807,37969,44274,40081,46387,25386,17033,21228,35920,33775,52629,44242,46453,50483,25356,21260,44209,48367,52659,61078,61046,61045,58900,48533,50712,54970,59033,50481,35952,35855,31759,38033,31726,33807,33840,54938,40276,19308,17163,19276,17227,17195,17194,17194,15114,13001,12839,31662,38131,33840,19114,10695,35887,33806,31661,33741,37967,35919,38000,44273,37999,31661,31694,33774,35854,27468,29515,23274,23274,38098,59164,57050,48500,42162,50712,48631,57083,40113,21292,52791,54708,42227,52857,57018,61277,61245,63358,61309,61277,61277,61309,63390,50678,42226,37968,10990,38427,23734,38296,58607,60686,60719,60751,62799,48107,14627,14628,16773,10532,14660,14758,14823,12775,6533,12904,25419,38033,57051,44340,25421,54905,59164,44339,65},
{15380,17428,17428,17428,17428,17460,19509,34135,48698,50810,54971,55003,57052,57084,57084,57084,57084,57052,55003,55003,54971,54971,54971,57084,59164,59164,59164,59164,57116,59164,59164,59164,59164,57116,57084,57084,57052,57084,57116,59164,59164,59165,59165,59164,59164,59164,57084,54971,52890,50777,44504,44471,42423,42391,40310,40278,40310,40278,38198,38165,34004,31891,31859,29811,29778,27698,27698,27698,29811,34004,40310,52923,57084,55003,50810,48698,50810,52890,52890,48697,48697,46617,46617,44537,44536,46617,46617,21457,6796,8876,13005,10924,13004,13004,12972,8844,10924,8843,13004,19245,23341,42130,31727,15018,12873,6633,12906,10858,31759,46354,31760,42195,38001,38034,27500,6632,21260,29647,36051,42194,44242,29550,25452,14953,21228,44242,46355,44176,35757,44275,50515,23307,6535,35822,37936,50545,54706,56753,56753,54705,52758,57084,50777,46387,33579,25421,35855,33677,50450,52595,48434,35854,35953,46551,38227,29711,15146,17259,19372,19371,19339,19339,17291,23404,25388,23340,27468,29548,25322,21227,33741,33773,33741,35853,37934,37902,37934,37934,35854,31628,33740,35821,33708,33708,31628,27434,36019,50711,46453,33709,20999,46486,50712,54970,29614,12808,46322,44274,44307,50744,63422,61277,63390,61277,63357,61277,63357,63357,54937,40047,46355,46354,10860,34299,23701,48337,58573,48140,39787,35594,31433,31628,31628,35789,35855,37968,37935,33774,33807,25355,4356,25388,40048,31662,57051,52759,27533,54938,59163,52759,106},
{15380,17428,17428,17428,17428,17460,19541,38264,46650,50810,54971,55003,57084,57084,57084,57084,57052,55003,55003,55003,54971,54971,55003,57084,59164,59164,59197,59197,59164,59164,59164,59164,59164,59164,57116,57084,57084,57084,59164,59164,59164,59164,59164,59164,59164,57084,57051,54971,52890,48697,44472,44471,42423,42391,42391,42391,42359,40310,38198,36117,34004,31891,31859,29811,29778,27698,27698,27698,29811,31924,40278,52891,57084,52890,46585,46585,48697,52890,54971,50777,44537,44504,44504,44536,44537,44537,46585,25618,6797,8876,15085,13005,13005,13004,10892,8844,8844,8843,10924,15117,40082,54645,38001,14986,19179,12873,12905,14986,38001,48533,46550,35920,19147,29615,27501,19180,29647,31792,46551,35953,38001,19115,27565,17033,12906,40147,48534,40048,31563,29614,21227,8680,8680,48500,48435,58998,63157,61044,61045,61077,54740,42162,21195,25290,16936,25323,31629,27338,35756,39950,29515,19048,23242,36051,42453,40308,42484,42549,42517,42516,40468,38323,34097,29742,25388,25486,21195,23144,29514,21128,31627,29515,31627,31627,31627,33708,33708,31628,31628,33708,31627,31595,29547,29515,23241,21161,21260,40212,50743,27468,22981,42194,48632,35953,17034,4421,23275,44274,44307,42260,59131,59131,59131,59099,59098,61146,59066,54905,44468,33903,46387,46419,12906,27960,23407,25030,18789,14596,12515,8386,31597,46387,33807,40113,42194,42259,42259,40113,40146,33839,8517,23308,38032,21195,54938,57018,31662,52792,59163,56985,103},
{15348,17428,17428,17428,17428,17460,17461,32023,42457,48698,52891,52923,55003,55004,55003,55003,54971,54971,54971,54971,54971,54971,57051,57084,57084,59164,59197,59197,59164,59164,59164,59164,59197,59164,59164,57084,57116,59164,57084,57116,59164,59165,59164,59164,57084,57084,54971,52890,52890,48665,44471,44439,42391,42391,42391,42391,42391,40278,38165,36084,33972,31891,31859,29811,29778,27698,27698,27698,29811,33972,36149,46585,52890,48697,44536,44537,44537,50810,52858,48697,46585,46585,46617,50810,50810,46617,44504,31924,8909,8844,13005,13037,15085,13004,10924,6763,8843,10924,6795,10956,19278,33873,42194,17067,19180,25453,23404,12937,17099,27567,38131,19179,19180,33841,42162,31630,38066,42390,33840,29614,10760,4519,23372,21194,14921,31630,31629,39983,37870,29547,23274,12808,14954,46354,46420,50646,35756,29451,42161,37967,37935,44112,25420,23209,33676,33676,31595,29483,29450,27370,23177,19016,25355,33905,32017,48696,57084,57083,48728,42421,34033,29743,25485,42292,48532,19245,19212,37901,35854,33807,38032,35952,40145,42226,46321,46321,48368,48401,48433,50481,52463,52463,52431,50188,31563,35888,40114,29614,31759,25355,25062,29451,31727,31727,21227,17001,23308,42226,48500,29646,27566,40081,31662,35790,50319,56560,48206,46224,44598,33968,42194,40048,12808,15347,16937,14595,6404,10532,12580,16871,50711,44340,29581,40081,40146,42227,44340,42227,42227,40146,14888,23308,46387,27403,52792,59131,40146,50712,59098,59098,142},
{15380,17428,17428,17428,17460,17428,21621,42457,50778,50778,50810,50810,50810,50810,52891,54971,54971,54971,54971,54971,54971,54971,57084,57116,57084,57116,59164,59164,57116,59164,59197,59197,59197,59197,59164,59164,59164,57116,57084,57084,59164,59164,59164,57084,57084,57051,54971,52890,52858,46584,44472,44471,42391,42423,44472,42423,42359,38198,36117,36052,34004,31923,31891,29811,29778,29746,27698,29778,29811,34004,40310,48730,50810,46617,46617,48697,48730,50810,50778,48697,48697,48697,48697,54971,55003,50778,44472,38230,17231,8844,13005,13005,13037,15085,13005,6763,6763,8843,6763,4683,2602,21326,29777,15019,23373,40113,38032,15018,8713,21228,38001,27566,15019,29712,44242,33743,46518,38131,27598,29581,14985,10760,12872,10759,12840,31629,35855,44144,35888,29516,19147,8615,4454,19147,48533,50646,31596,25258,39951,39983,40080,35822,21227,21129,31595,31595,31595,29450,29483,27402,23209,14855,23373,38131,31824,46584,48697,48664,42325,33905,19244,21292,31727,44438,42226,38000,50710,65435,61243,57050,54936,52857,52857,50679,54773,56822,58870,54840,54806,60981,65010,65010,64847,52270,46355,46420,44372,33807,25420,40048,25094,27306,50744,37936,29387,27306,23080,27469,48533,27501,17067,42161,39885,25159,50318,54512,52399,44045,31856,48727,50646,44241,16969,6862,17035,20869,14758,16838,33579,25192,44340,46453,27533,40081,42259,42259,44372,44372,42259,42259,23275,19049,50450,35822,50679,61212,46452,48598,59098,61211,165},
{15380,15380,17428,17428,17460,17428,27830,44537,52891,52891,52891,50810,48730,48698,50811,52891,52891,52923,54971,52923,54971,55003,57052,57084,57084,57084,57116,57084,57084,59164,59197,59197,59197,59164,59164,59164,57116,57084,57084,57084,57084,57084,57084,57084,57051,57051,54971,52858,50810,46584,44472,44471,42423,42423,44504,42391,42359,42391,40310,38197,36085,33972,31891,29811,29778,29778,27730,29811,31892,34004,38230,46617,50778,46584,44536,48730,52890,50778,50778,50778,50778,48697,48697,50810,54971,50810,42423,38230,23537,10957,13005,13005,15085,13004,13005,10924,6763,6731,6763,6763,4683,31760,31727,10858,10826,25486,29678,17098,14954,17034,27599,23405,4552,6632,25421,42195,38099,35953,31727,33807,14921,8680,19114,19081,14953,21162,35791,35789,10727,14888,4454,2341,261,10728,42194,52758,33676,25257,44144,50514,42194,33775,21194,21129,29482,29515,29515,27435,27402,27370,21096,14855,35985,35985,29712,29712,29712,29712,29614,29549,14987,27501,27534,46486,48467,56789,56919,52791,61112,63225,61144,61111,56885,61013,58933,54708,58967,59032,58932,62962,64945,62767,56332,35790,48533,42259,38066,29614,25453,29614,23047,29516,61244,33741,22982,20935,20870,23210,48500,23275,12776,33644,48206,23046,41997,50384,46190,48205,19016,36018,40178,38032,19145,8810,12938,12709,12677,25290,44208,29287,46388,52791,29581,38001,42226,42227,42227,42227,42259,40179,27501,16969,46387,46387,48566,61277,50646,40179,59131,61244,168},
{15380,17428,17428,17428,17460,17460,21621,36216,52859,52891,52891,52891,50810,48698,48730,50810,50778,52891,52923,52891,52923,54971,55003,55003,57051,57084,57084,55003,55003,55003,57084,59197,59197,59164,59164,57084,57084,57084,54939,52891,55003,54971,54971,54971,57051,57051,54971,52890,50778,46552,44472,44471,42423,44471,44504,44472,46584,48665,46584,44471,38197,33972,31891,29811,29778,29778,29778,29811,31891,31892,36085,44504,48697,46584,42423,50778,54971,50810,50778,50810,50778,48730,48697,46585,48697,48697,42391,38230,21457,8909,10957,13005,15085,13004,13005,13005,13004,13004,6763,6763,4683,29712,29777,17067,6632,17132,19211,15018,19179,25453,31727,17066,10825,15082,31856,46453,33808,48468,50581,37936,27435,17001,31759,27435,12872,33873,42031,23209,21259,27435,19081,6598,4486,23243,46452,44307,31628,27305,44176,54774,42194,33807,40113,40081,46322,35789,31596,29515,29515,29483,25322,21161,33840,50712,38131,29712,31792,29712,31727,31695,19147,27533,25355,40047,40080,44307,40080,46387,52791,59098,56985,61178,59065,61211,59131,61178,63292,63323,40079,16967,14887,12742,6436,10728,46387,23275,10695,14889,19147,21195,31727,29647,57083,44274,35953,48533,37902,23177,31564,21096,16903,33579,44078,23079,37804,52464,44045,41932,14758,33807,21290,17161,19274,19242,17161,12968,19210,52792,56985,50515,52759,52824,27500,35952,42259,40146,38066,40146,40146,40146,35920,10597,27534,46420,40146,59164,54904,46452,57018,59164,170},
{15380,17428,17428,17428,17460,17460,17461,25782,42457,48698,44537,46618,50778,50778,50778,48730,48698,48730,50778,50810,52891,54971,55003,52923,50810,52923,54971,54971,52891,52890,54971,57084,59164,59164,59164,57084,55003,52891,52858,50778,52858,52890,54971,54971,55003,55003,54971,52890,50777,46552,44472,44471,44471,44472,44504,50745,52858,50778,50777,46584,40246,33972,31859,29811,29778,29778,29778,29811,29811,31891,36085,42424,48665,46584,44504,48730,54971,52923,50778,50810,50778,50778,48697,46585,46617,48665,42423,38230,21457,8877,10925,10924,13037,13005,13005,13004,13004,13004,13036,8843,8811,27632,23700,27664,17066,17099,14986,12905,19179,21259,31793,27566,12905,23436,21323,29745,42195,44274,56854,40081,37903,42161,38033,35952,19211,27501,52497,44175,25421,39951,46191,21259,19145,35855,46387,37902,29418,27273,37870,50613,52726,54839,61146,63258,50580,23275,29548,29547,29547,29548,23274,17001,19148,35986,31792,31792,31792,29712,29647,27566,19147,23275,21096,23144,19115,35919,33840,50646,61276,61276,61276,61276,61276,61276,63325,63325,59098,38096,12871,4517,2340,2340,2340,4421,40146,40080,31727,21195,23340,21228,44406,48566,57083,46420,23210,31532,50383,25191,25126,27305,21227,31498,33514,20966,37771,60818,41899,41932,23210,46354,29644,17194,19242,19242,17161,15016,31758,46420,54938,54970,54938,54905,31694,31726,40179,40146,38066,40146,40114,40113,38032,16871,23308,38033,40179,50679,38066,54938,56985,52792,191},
{17428,17428,17428,17428,17428,17460,17461,19509,25782,40344,42457,46618,50778,50810,52891,46650,44537,46650,48698,48730,52891,52891,52891,50778,48698,52890,52890,52890,52858,52858,52858,52891,54971,55003,57051,54971,50778,50778,50810,50746,50778,52890,57051,57084,57051,55003,54971,52858,48697,46552,44504,44472,44472,44504,48665,52890,52890,52858,50777,42391,36117,33971,31859,29811,29811,29778,29778,29811,29811,31891,36150,44504,48697,48697,48665,46617,50810,52891,52890,52890,50778,48697,46617,48697,52890,52858,46584,40311,27731,8877,10957,10924,13037,13005,13005,8876,8844,8844,19277,13004,13004,27566,36052,40245,25453,14986,23373,23340,17066,19211,27632,35953,12905,12905,21259,44274,42162,42194,31630,40146,38034,42194,44307,33807,10793,14921,48304,40080,23340,42063,41998,25421,27500,33742,40113,44274,37935,37935,31629,31695,44307,44339,48501,48500,33807,23275,25388,27468,25420,25355,23275,21194,12841,46551,42292,35985,31727,35985,33807,25387,23307,27435,31595,33676,31661,35887,40146,54871,61243,61243,61243,61243,61211,61211,61212,61211,54903,35981,12935,4485,2340,4388,2340,4388,35920,33840,21227,21227,17066,14954,46551,54938,54970,50678,18886,29255,56657,31498,20999,23079,12678,20999,31400,25191,31465,60850,62898,58704,50581,50645,37967,17161,19242,19242,17193,12872,25420,46419,52824,54938,54937,54938,35920,27500,40114,38066,38033,38001,35919,35854,35886,21064,23276,42194,27501,33741,33773,50711,56985,52792,211},
{17428,17428,17428,17428,17460,17460,17461,19509,29910,38296,44537,48730,50811,52891,52891,48698,40376,42457,44537,46617,48730,50810,50810,50778,50778,52858,52890,52858,50810,52858,50810,50810,50810,52858,52858,50778,48698,50778,50778,50778,50778,52858,57051,55003,54971,54971,52890,50777,46584,46552,46552,44504,44472,46552,50778,54939,52858,48697,46552,42326,36084,31891,31859,29811,29811,29811,29811,29811,29811,31859,36150,46617,50810,50810,50777,48665,50810,52923,54971,52891,48730,48697,48697,48698,50810,50810,48665,42359,34037,10990,10957,8876,15085,13005,13005,13004,10924,4715,13004,10924,6763,25487,46453,33905,15018,21324,44373,27566,8745,17098,27631,33904,23371,23340,33839,37936,37935,29646,19115,31760,42227,35855,37968,8647,293,6567,35790,25453,25486,50613,25421,17034,21260,21260,21260,23341,23341,23341,21292,19115,19179,19147,19147,19115,19179,19147,17034,17034,17034,17002,14954,21195,19180,50777,44405,40146,31792,40146,31726,27435,23274,35886,48498,46387,40015,42259,59131,61244,52792,48533,38001,35888,40114,33775,44176,42063,39950,35788,21353,12935,6565,10790,4420,4388,23308,17034,14953,4357,6534,6534,38132,57051,50744,59098,46453,50482,60850,39884,16838,27240,12612,16838,29320,37706,25159,52431,65076,58902,52759,52726,40080,19242,17193,19274,17194,12872,14921,42258,48631,54970,54937,48631,42259,33807,44372,44405,44340,42259,40113,38000,35887,29549,23308,44274,42226,44339,50613,50679,57050,54937,223},
{17428,17428,17428,17428,17460,17461,17461,23701,40344,44537,50778,50810,50843,52923,52891,48730,42457,36183,38264,44537,46617,46585,46617,48698,50778,52858,52858,52858,52858,50810,50810,50810,50810,50810,50778,50746,50778,50810,50810,50810,50778,50778,52890,52890,52858,52858,50810,48665,46552,46552,46584,46552,44504,46585,50810,52890,50778,46585,44471,40278,36052,31891,31859,29811,29811,29779,29811,31891,29811,29811,38198,46617,50778,50810,50745,48697,48697,50810,52891,50810,48730,48698,50778,50778,50778,50778,48665,40278,40310,21424,8877,8876,13037,13005,10956,10924,10924,10892,10892,10924,8843,27600,48598,31760,4584,15051,33905,23404,12905,15018,29679,25485,17098,23405,25486,37936,44209,14889,10793,21195,42194,37968,27436,12840,12873,10793,23275,14888,14954,44405,25420,12841,21228,19179,19147,19147,19147,19115,19179,19115,19147,19147,19147,19115,19147,19115,17034,17066,19147,17034,19115,23341,25519,40245,46518,38001,31694,35920,35855,29581,31694,23275,23307,19049,23275,42259,35855,35822,35855,48533,31661,29548,42194,44175,41997,33611,29385,29385,27531,21418,12903,12935,10854,8614,19114,23340,19082,6469,4389,2276,31826,57084,50679,54807,42161,42095,62963,41997,14725,23079,25127,18918,27239,41899,23079,37771,42095,42260,48566,48533,44273,23467,19242,19274,19242,15049,10760,38033,44405,57050,48566,38099,59164,59164,48664,44439,46551,33906,40245,31793,29680,31793,17001,35823,46453,40113,37967,50647,59163,57018,229},
{19508,17428,17428,17428,17428,17461,17460,27862,44537,44537,46650,48730,48730,50810,52891,48730,40344,29942,29942,40344,44537,44537,44537,46617,48730,50810,52890,52890,52858,52858,52890,52890,52890,52890,50810,50778,50810,52891,52890,52858,50810,52858,52890,52858,50810,50810,48665,46584,46552,46584,46584,46584,46584,48697,52858,52858,46617,44504,42391,40246,36052,31891,31891,29811,29811,29811,29811,31891,31859,34036,40311,48697,52858,52858,50810,50778,48697,52891,59164,54971,52890,48730,50810,52890,52858,52890,50777,44471,40343,38198,10990,8876,13037,15085,10957,10924,10924,10924,8844,15117,15084,27600,38098,21325,8745,8745,23405,23436,15018,19179,33840,19179,10793,19374,25616,35921,42130,27534,44339,38000,40082,50646,29581,19180,27468,17066,31629,35724,33775,42259,25420,12841,19179,19147,19115,19147,19147,19115,19147,19115,19115,21195,19114,19147,19114,19115,19115,19115,21227,21195,17034,29712,36019,38099,48598,33807,29581,33839,31726,25388,25388,21162,21227,19049,23308,42161,29417,27337,27337,40146,31694,33709,52661,50515,44110,37804,33578,29417,19112,15080,12999,12935,15015,14822,23210,37937,31499,12580,10500,10435,33809,57083,54905,44274,33709,35789,52463,23111,23144,18886,31400,20998,23014,43980,25191,29385,20999,35626,44143,33839,44306,50679,40177,19274,19274,17161,10727,38000,48565,57018,42259,40179,52890,50744,19147,36019,31792,12906,40244,12808,25486,25519,21424,29581,42194,46452,44307,50679,59164,46518,181},
{19508,17428,17428,17428,17428,17460,19541,32023,46617,46650,44537,38264,40376,44569,46617,40344,32023,29910,25782,32055,38296,46650,52891,50810,50810,52890,52891,52890,52890,52891,52891,52891,54971,54971,52890,54971,54971,54971,54971,52890,52890,52858,50810,50778,50778,48665,46552,46552,46584,46584,46584,46585,46585,48697,50778,50777,46584,44504,42359,38197,34004,31891,31891,31891,31891,29811,31891,31924,36117,44504,50778,52890,54971,54938,50810,48697,50810,59164,61277,59164,54971,50778,52891,54971,54971,54971,52890,46584,42423,42423,15151,6796,15085,15085,13005,10924,10924,8844,4715,15117,17198,19278,31792,29712,15019,19244,38066,27565,12938,21325,33906,29679,19147,27664,42292,31662,35856,37968,19180,10825,33775,40082,44372,44307,42129,27501,48533,46223,37936,46486,38033,19147,33840,33840,29679,31760,33905,33841,31760,31792,38066,33873,35985,35921,38066,35953,35953,35953,35985,40146,35953,40179,44372,38066,42226,29614,23274,25453,25420,14888,14856,14856,14921,12841,21260,40114,29418,29450,27369,38000,38001,37967,56788,44274,37869,42030,39917,37804,23208,19178,12967,14919,37771,25095,12483,14531,14563,18692,16644,14563,31663,57050,42161,37967,35855,33677,29385,18918,23079,16806,25192,16838,12645,33513,29352,35626,33545,46093,58673,35822,44273,35887,46420,21354,19274,17162,8679,31694,44339,52857,42292,38066,50777,54905,31727,35986,42292,19147,42325,25421,23373,38099,34200,35790,44242,46486,44307,40081,54938,44373,163},
{23669,17428,17428,17428,17428,17460,23669,38296,46617,50778,46650,38296,40376,46617,40376,27862,25814,29943,25814,25782,40377,50810,54971,52923,52891,52923,52891,52923,54971,54971,54971,55003,57051,55003,54971,55003,57051,54971,54939,52890,52890,52858,50777,50745,48697,46584,46552,46584,46585,46585,46617,46585,48697,50778,50778,50778,48697,46584,42391,38165,33972,31891,31891,31891,31891,31891,31891,34037,40311,46584,52890,57051,57084,54971,50778,48730,52891,59196,59197,59164,52891,52890,55003,55003,57051,57051,54939,48665,44472,42424,21457,8877,13037,15117,13005,13005,10924,8844,8844,10956,23471,19278,17165,10859,392,12938,42260,33839,17162,19277,42325,35952,21260,19212,31792,31662,35921,37936,8680,6665,38033,40146,44340,46322,42292,40212,42161,50580,46420,40245,57018,40211,48664,48631,44405,46518,46551,46551,44373,44373,46518,44405,44405,42325,44405,42292,40179,40179,40211,40179,40179,40179,42324,38065,35953,33807,27468,31694,31693,25355,25355,25387,27468,25420,23340,38033,39983,46223,44208,46452,40146,46322,48370,31727,42161,54773,54676,50449,33675,40113,19113,21192,46094,25062,12515,16676,16644,14563,16644,14563,21033,33776,35855,27468,31629,37804,25192,27305,16838,25159,23079,12677,10597,33546,31433,33578,27305,48206,56560,33644,42193,31660,42227,21355,19274,17194,12904,25421,46452,50679,44339,29614,48631,52825,42292,42292,48599,35985,44405,38066,33873,29679,23504,37968,46355,38033,35920,48566,59131,46485,164},
{21556,17428,17428,17428,17460,17461,21621,25782,32023,38296,40344,44537,48698,46617,32023,23702,23702,23702,27862,36216,52891,54971,54971,54971,54971,54971,54971,54971,54971,54971,55003,57084,57084,57052,55003,57052,55003,52890,50810,52858,52890,52858,50778,48697,46617,46584,46585,46585,46585,46584,46617,46617,46617,48697,52890,52858,50810,48697,44471,38165,34004,31891,31891,31891,31891,31891,31924,36085,38230,42424,50810,57084,57051,52890,48730,48730,55003,59164,59164,57084,54971,54971,57084,57051,57084,57084,54971,48697,44536,42424,29811,8909,10957,15117,13005,13005,13005,13004,13004,13004,19277,15052,2472,6665,4552,10826,42195,40081,21324,19211,40211,38000,14986,21292,21293,23341,29582,42129,14921,8713,31792,35888,44242,42161,48664,52890,42227,42064,40179,50745,54905,44373,46518,46518,46518,44405,44373,44438,42325,42325,42293,42292,42260,42292,40212,40179,40179,38098,40179,40179,40146,40147,40179,23340,27599,35953,31661,35855,40081,33774,31693,35919,31694,31694,27500,31694,37870,23209,23274,27533,46387,48337,25355,25355,59033,61081,61113,48336,27338,52792,25388,10532,43981,29255,12548,14596,14563,14563,14563,14563,12483,12483,31662,27500,37902,44046,33514,29353,25192,25159,23079,12677,12645,46125,33545,29385,29385,50319,54480,40015,46419,33741,40179,21323,19274,17194,12904,27534,54905,40113,48533,25420,44373,50744,52792,50712,50712,48631,46518,46518,38034,29387,46290,44176,44242,42227,48566,44340,54937,48598,164},
{21588,17428,17428,17428,17460,17460,17461,17461,17461,21589,34103,36216,40376,36183,29942,21622,21622,21622,29943,50843,55003,55003,55003,55003,55003,55003,57051,57052,57051,55003,57084,59164,57084,57084,57084,57051,52890,50778,50778,48698,50778,50810,50777,48665,48665,48665,46585,46585,46585,46585,46617,48665,48697,54971,54971,52890,52858,48697,44471,38197,34004,31891,31891,31891,31891,31891,33972,36085,38198,40311,46585,54971,52891,50778,48698,48730,50810,52891,57084,57084,57084,59164,57084,57051,57084,57083,52858,48665,48665,44504,38198,13070,8909,15117,15117,15085,13037,13004,15117,13004,13036,12971,4584,2472,6698,15019,44210,42097,25452,23404,40212,35985,17098,25453,19179,17034,31662,35953,25453,6567,12906,31727,46387,33807,27664,31857,44340,35854,38099,63390,52792,44405,46486,44438,44405,48599,44405,44405,44405,44373,42325,44405,40212,42292,42260,40179,40147,40146,40147,40179,40146,40146,38098,19179,25518,33807,29581,33774,37968,33742,31694,38000,27500,31694,27533,29548,37901,12839,6533,14921,44144,23210,16903,35790,59032,56887,58967,48337,23177,48664,27566,14726,48142,37674,18919,16773,14531,14563,14563,14563,12483,10435,29614,35887,48337,50449,37739,33513,52366,25224,20999,20966,18919,50319,39787,29352,31465,50286,52432,46387,50646,33741,29646,21323,21323,19242,12904,25486,52824,42226,48565,27467,33873,50744,46485,19147,44406,27501,21260,44405,12743,23015,33450,50352,52433,42259,44373,38001,48598,50711,155},
{21588,17428,17428,17428,17460,17461,17461,17461,17461,19541,25782,25782,23669,27862,29975,21621,19573,19574,40409,55003,55003,57052,57051,57051,57084,57084,57084,57084,57084,57084,57084,59164,59164,59164,57084,52858,52858,52858,50778,48697,48665,50745,50777,50745,48697,48665,46617,46585,46585,46585,46585,48697,52890,57084,54971,52890,52858,48665,44439,38197,36052,33971,31891,31891,31891,31924,34005,36085,36117,36117,42424,50810,50810,48698,48665,48697,48698,48730,52891,57084,57116,57116,57051,59164,59164,54971,48697,48697,50777,44504,40343,19344,8877,15117,17165,10956,13037,10924,13004,15085,8844,17197,10826,2504,4617,12971,29614,29646,40113,31791,31791,21291,15018,19211,21292,17067,29614,42259,29646,10792,14954,29647,44307,33775,31793,40179,38066,21259,42260,63389,50711,46486,44405,46486,46518,46551,44438,46486,44405,44373,42325,42324,42260,42292,40212,40147,38098,38066,38034,38066,38066,38033,21260,12841,12841,35888,40048,33806,37967,35887,29548,27468,25387,31661,27468,16936,27434,21225,14952,35854,37838,29549,27500,35887,54805,54740,52595,54806,25289,33873,17067,14856,48206,43948,14693,14628,14531,14563,14596,14563,14596,27338,42193,48435,56691,56821,44045,25159,52399,39819,18853,29287,27272,52399,41932,23079,29353,46125,54479,44307,46485,27532,14985,19210,19242,17162,15048,23404,50712,42226,25420,23307,29647,48599,46453,31759,44373,38034,29679,44405,29646,23243,10630,41901,56626,42227,35920,38001,54970,54905,160},
{21556,19476,17428,17428,17460,17460,17461,17461,17461,17461,21621,23701,21621,27862,29942,23702,21622,36216,55003,57084,57116,57116,57084,57084,57116,59164,59164,59164,59164,57084,57084,57084,57052,55003,52891,52891,57084,54971,50810,48697,48697,48697,50778,50745,48697,48665,46617,46585,46584,46584,46552,48697,54971,55003,54971,52890,52858,48665,44471,40246,36084,33971,31891,31891,31891,34004,36118,36118,34037,34037,42456,50778,50778,48730,48697,48698,48730,48698,50810,55003,57084,52891,57051,57116,57051,50810,46584,48697,50778,44504,42424,25618,8877,13037,17165,10957,10957,13005,13004,8844,6763,4715,8811,8745,4552,15019,23404,17099,19212,31824,38065,25484,15018,15018,27599,23405,35921,29679,31727,15017,21293,35888,37936,37903,42129,38000,17066,17001,46486,61277,48566,44405,44438,46486,46518,44405,44405,44373,42292,42292,40212,42292,40212,40179,40179,40147,38066,38066,38034,40146,38066,27566,14921,12841,12808,17067,33839,31661,21161,19081,16968,23242,23242,21162,12808,12808,37901,37836,38000,39950,39918,33611,23275,19049,27467,37869,52628,52792,23144,29614,19147,16969,35692,48141,33446,29317,23046,23045,16805,10532,10532,16871,35854,42193,58837,61015,46158,33513,48238,48205,39917,52497,44077,52399,46093,18951,25192,41932,56592,46223,25548,21387,21355,21387,21387,19306,19274,21355,48599,48565,42226,21195,25421,48631,50712,52793,50712,50680,50712,46518,46518,35986,8582,31531,50483,42194,46453,46452,46518,57018,215},
{17428,17428,17428,17428,17460,17461,17461,17461,17461,17493,19541,19541,23734,25782,27862,27830,29943,52923,59164,57084,59164,59164,59164,59164,59164,59164,59164,59164,59164,57084,57051,54971,54971,52891,52891,57084,57084,54971,50810,50778,50778,50810,50778,50777,48697,48697,48665,46617,46584,46584,46552,48697,54971,54971,54971,52890,52858,50745,44439,38197,36052,33971,31891,31923,31891,34037,36150,36118,34037,34037,42457,48730,50810,48698,48730,48730,50778,48698,50810,54971,54971,48730,50810,55003,54971,50777,46552,46617,48730,46617,44536,27763,8909,13037,13037,10924,10957,10956,10924,8844,10924,6731,10924,12971,10891,21325,15018,10825,10825,31824,38130,27598,14985,21324,36051,42259,35888,27567,42260,19178,31791,40114,42194,50580,40015,33708,12872,23307,35921,52858,48598,46486,44406,44438,44405,44405,46486,46551,44373,40244,42292,42292,40212,40179,38066,35986,35985,38098,38066,38098,35953,31727,27533,25453,25453,23275,31693,29580,23242,16968,16968,25355,27468,25387,17001,12808,31628,42095,50417,44079,40016,33578,33774,48499,50547,58898,56952,44373,23144,33741,31661,16969,35692,52366,60846,50348,46154,31496,10564,6436,6403,4323,19049,46289,58935,63193,52432,41933,54610,35723,29483,25322,25257,52367,50286,18951,23079,39852,54512,46190,25483,21387,21387,21387,19339,19306,19306,25581,50712,50678,48532,44307,40113,46518,50680,36018,33906,46486,23341,40212,31760,14954,10695,21161,35953,46420,44372,42259,40081,54970,223},
{17428,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,25782,21622,21622,21621,25814,52923,59164,57084,59164,59164,59164,59164,59164,59197,59164,59164,59164,57084,57051,54971,52891,52890,54971,57084,57084,54939,50810,50810,50810,50810,50778,50745,48697,48697,48697,46617,46585,46584,46552,50778,54971,54971,54971,52890,50778,46584,44439,38197,36052,33971,33971,31891,31891,34004,34037,34069,34037,34037,42457,48730,46650,46617,46617,48730,50778,48698,50810,52891,52891,48730,50778,52890,52890,50777,46585,48697,52858,50777,48697,34037,10990,13070,17198,13005,13005,10924,10956,10924,10924,8843,15116,15084,4683,19245,8745,14986,12905,29712,48631,33872,10857,21323,21293,44274,35887,31760,23405,19211,27629,31727,44340,54840,40016,42030,31661,23339,38001,52824,46518,44405,40244,44438,48599,46518,44405,44438,42325,40212,42260,42325,40179,38066,38098,40114,35985,35986,35953,38066,35953,40179,38034,40179,33840,33774,40080,27468,21194,17001,17001,21194,25387,25387,21162,10695,29547,33676,50352,46322,44242,37739,33676,33872,37999,37966,31727,21228,21064,25355,10727,14823,44046,52430,50347,35689,27335,12644,4291,4259,4291,4259,6404,29548,40049,56821,54545,54643,56625,29319,10532,10532,18919,50286,54479,25192,18918,35659,50319,44078,29676,23532,25580,25580,21387,19306,19306,33937,52792,50646,48532,50678,44371,44373,50679,33840,25486,46486,19082,38066,33873,14953,10695,14856,27469,48565,40113,44339,40048,46518,226},
{17428,17428,17428,17460,17460,17461,17461,17461,17461,19541,19541,19541,21621,19573,19573,19574,23702,48730,57116,57116,59164,59164,59164,59164,59197,59197,59164,59164,59164,57052,54971,54971,52891,52891,54971,55003,54971,52858,50778,50778,50810,50778,48697,48697,48697,50778,48697,48665,46584,46584,46552,48697,52891,54971,54939,52890,50777,46552,44471,38197,36084,34004,33971,31891,31891,31924,31957,34070,34037,34070,42489,46650,46618,44570,44570,48730,52890,48730,50778,52891,57084,55003,52890,52890,52890,52858,48697,50810,54939,50810,48665,38230,17264,10990,19278,17165,13005,8876,10957,10956,8844,8811,8843,13004,10859,10826,6665,8745,14986,25518,50744,29711,10825,15018,35823,27501,33840,31759,29679,23339,25516,31792,40050,44373,52628,44177,31629,19082,44242,46388,44275,52792,48599,50679,50515,44340,48468,35855,40049,35921,37935,35790,37902,42063,56723,50449,25388,8647,8647,19147,31792,33873,33873,33872,29679,40179,48533,27435,21162,19049,21161,31596,23307,25388,27435,10695,23242,31629,48337,48468,44208,39787,25160,8614,10694,8581,21129,23307,23275,23307,8647,14919,41933,33480,16771,8451,6338,6338,4290,12677,16838,16838,18918,16773,14725,29451,50417,52464,54414,37706,16805,16805,16838,48174,54480,31466,18951,33546,48173,39950,46549,44500,46614,48694,31854,19306,19306,27662,50712,50712,52759,46354,42063,44373,46518,48599,48599,48567,48566,46486,44405,42292,19017,18789,27176,42227,40146,52857,40080,44372,228},
{17428,17428,17428,17428,17461,17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,40409,57116,59164,59196,59164,59164,59164,59197,59164,59164,59164,57084,55003,54971,54971,54971,55003,57084,54971,52890,50810,50778,50746,48698,48697,48698,48698,50778,50778,48697,48665,46584,46552,46552,46585,52891,54971,52890,52858,50745,46552,42358,38165,36084,34004,33971,31891,31891,31892,34005,34070,34070,36183,42490,44570,44570,42522,42522,48730,57084,57116,50810,52891,57052,57116,57051,57051,52890,52858,48697,50778,54971,52858,46585,40311,25650,10957,17198,21358,13037,8876,8844,13004,13004,10892,6763,10892,12971,8745,6665,15018,23372,25518,50645,33870,21259,27533,40113,15051,21292,25356,31825,33806,27629,31759,31663,27469,44275,37936,25388,31629,39983,33612,37838,56920,48631,52760,35822,35954,48468,27403,40081,29549,33611,44143,44110,44110,62996,52594,31661,10598,10630,31728,33905,29680,29679,29679,29647,33807,27402,25322,25387,25355,29515,35789,21161,19081,19049,14856,21162,35920,48403,50548,39885,42031,52628,52660,42193,27501,21129,29450,25322,19115,4388,6533,37740,29287,16772,14856,14888,14888,12808,17034,16838,14758,18918,16806,16774,12645,31628,50286,52367,41899,18886,16838,12645,44013,56560,35626,14790,43980,58672,31498,21194,21259,31725,35985,33935,21387,21355,23468,50744,63357,61211,52693,48468,48566,46486,44405,38099,46453,38066,35986,40179,27567,27566,18854,25030,40049,44339,44340,40114,52824,233},
{17428,17428,17428,17460,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,19574,36248,52923,57084,57116,59164,59164,59164,57116,57116,57116,57116,55003,54971,54971,55003,57084,57084,57051,54939,52890,50778,50778,48697,48697,48697,50778,50810,52858,50810,50778,48665,46584,46552,46585,54971,59164,57051,52890,52858,48697,42391,40278,38165,36085,36052,33972,31891,31859,31892,31924,34005,34037,36216,40474,42522,44570,44570,44570,44635,55036,59197,50810,52923,59197,59196,59164,54971,50778,48697,46585,48665,54971,52890,48665,40311,29876,10958,10957,19278,15085,13037,10956,10924,10924,10924,10891,10924,10858,6633,2472,6665,17098,23437,48532,33902,21291,19179,23372,23373,8745,27600,31695,27500,25516,35952,37903,31662,31629,14921,2374,19114,37902,40048,39951,48533,48632,50711,29613,33873,46420,29516,42129,27403,37804,41997,39884,42030,39983,35920,50547,54708,46192,29647,31792,29679,27566,25486,25453,33774,44208,48499,54806,56952,59064,35854,10630,12710,10630,8517,19082,35920,31662,39950,39819,25193,33840,52693,40114,29516,10727,33805,29482,19081,2372,2275,31498,31400,16870,14954,17066,17067,12873,14954,16871,12677,16806,16838,16838,12677,21064,48238,54447,48173,16838,18886,10565,37739,56560,39820,18952,52432,54577,27468,29580,12807,23274,31759,35984,21354,19306,19306,33969,46583,57018,59164,54905,48566,46486,42259,23308,42292,29582,23341,40146,14921,27567,19049,16709,33678,42259,44339,42226,52825,229},
{17428,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,19573,27863,48730,55003,57084,59164,59164,57084,57052,57084,57084,55003,54971,54971,54971,57052,57084,57084,54971,52891,52890,50778,50746,48697,48698,50746,50810,52890,52890,50810,50778,46617,46584,46552,46585,50810,55003,54939,52858,50810,48665,42391,40278,38165,36084,36052,33972,31923,31891,31892,31924,31924,34005,38296,40474,42522,44570,42522,42554,42554,48763,57084,50810,54971,59164,57084,57084,52890,50777,46585,44504,48665,55003,52890,44504,40311,29844,10958,8877,15085,13037,10956,8876,10956,10956,8843,10924,13004,10891,2504,2472,17099,19146,21292,38032,36017,19211,10857,23373,25421,10858,23471,33677,27468,25516,31791,42129,54741,44242,23275,14889,25420,37903,48402,35888,29778,57084,57018,44306,37936,39917,25290,44274,48369,46191,44077,35659,31563,35855,35920,54676,54708,52466,27534,27599,29679,27599,25486,25453,29647,33872,33873,40179,31760,25356,23307,12678,10630,10598,8517,14888,14823,23275,37935,14823,16936,16968,19114,14921,16936,14888,10727,16967,14951,4452,2404,29450,33578,16969,14921,17034,17034,14954,14986,18984,18984,16903,12678,12645,8484,8517,27370,54479,50286,20966,20998,12613,31498,56560,41933,14791,31564,33774,25453,33774,16870,25322,31726,40146,21355,19306,19306,17161,33903,52726,56985,57018,50679,44405,40146,27501,38099,35921,27566,38066,27533,35921,31727,14726,21032,40146,50712,46452,38033,218},
{17428,17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,19574,25814,46650,52891,54971,57084,57084,52923,52923,55003,57084,54971,54971,54971,54971,57052,57084,57052,54971,52891,52858,50778,48697,48698,50778,50778,52858,52890,52890,50810,48729,46617,46584,46584,48697,50777,52858,52890,50778,50778,48665,42391,40246,36117,36084,36052,33972,33971,31891,31892,31924,31924,36150,38362,40474,42522,44569,42522,42554,44602,44602,48730,50778,52891,57084,57084,54971,50810,48665,46584,46584,48665,52858,46584,38230,40311,36117,15151,8909,13005,15117,10924,8844,8844,10924,12972,8844,13004,10859,8745,4585,21292,29645,17131,31791,34001,27630,14986,27664,35921,23308,27599,50581,33742,19211,21260,44307,40081,42096,35758,35856,12776,23307,54611,40147,38132,50679,46518,44274,46191,41900,27338,42129,58869,50384,52464,39884,33611,46387,46453,44208,46256,50418,23373,29679,29680,27599,27567,27566,27534,25421,25453,44373,29549,29418,25388,12710,12678,10630,8517,14856,16904,31661,38033,16870,21096,21096,12807,12775,16968,14888,10694,14951,8709,4484,292,23176,33644,12808,12841,10760,14954,12873,14986,25290,18886,12678,12677,12645,10597,6436,21096,54447,54447,25159,18886,12612,25225,54479,46093,10598,25323,27533,23308,35920,16838,23209,27501,40178,21387,19306,19274,17193,27662,52726,54905,54938,50712,54872,35920,40179,42292,42260,42259,40147,40147,44340,40146,23275,18951,38001,40114,38001,38033,213},
{17428,17428,17428,17460,17460,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19573,21654,36216,46650,44537,50778,52891,52891,54971,55003,57051,55003,54971,54971,55003,57084,57084,55003,52891,52858,50810,50778,48697,48730,50778,50810,52891,52891,52858,50810,48697,48665,46584,46585,52858,52890,52890,50778,48697,50810,46617,42391,40246,36085,36084,36052,33972,33971,31891,31891,33972,36118,38329,40442,40474,42522,42522,42522,42554,44569,46617,46650,50810,50810,52923,57084,54971,52890,52858,48665,44504,44504,46584,40343,36150,40311,40311,17296,10990,13037,13037,13005,8876,8844,10924,10924,8843,10924,17164,17132,10890,10858,17099,17098,35985,29710,29710,17099,15084,29615,31695,25551,31727,40179,19180,21261,35921,40114,42161,46290,31695,4486,17034,46225,44340,52694,35757,33775,42193,52464,54610,42030,46322,58901,35692,56756,56788,35724,40081,35985,27501,27501,19115,21260,31760,31760,25453,25486,27566,27566,25453,31760,44373,27500,31661,25420,14791,10630,12743,29516,19049,14855,31694,44340,21128,19016,21128,19016,19015,16935,16968,23368,17192,8709,4549,2404,23176,31563,8615,10695,12808,8615,6567,12841,23242,12645,10597,10597,8517,6404,4324,14823,52367,54446,29352,18886,14693,21031,52399,41900,12678,21032,33807,23340,40081,20999,23144,31693,38097,21355,19306,19274,17194,23468,50613,52824,52792,44405,54937,31727,35953,42260,42259,40179,40179,40179,42259,40179,29582,23113,31694,40146,46452,46420,211},
{17428,17428,17428,17460,17460,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19574,19574,36216,48730,48698,52891,55003,55003,54971,54971,54971,55003,54971,54971,55003,57084,57084,54971,52858,50810,50778,48697,50746,50778,50810,52858,52891,52890,50810,48730,48697,46617,46584,44504,46585,46617,46585,48665,52858,50810,48665,44504,40278,36085,36084,34004,33972,33971,31891,33972,36118,38296,40442,40442,42522,44570,42522,44570,44570,46617,46649,48730,50810,46617,50778,57084,55003,57051,57051,50778,44504,44536,42424,40343,38263,38231,38263,23570,10990,13070,8877,10957,8844,8876,10924,8844,8844,13004,15084,15084,15084,12971,6665,19245,31792,21325,27629,19179,12938,23406,23406,33840,40212,40114,17034,23438,40114,35888,42227,33742,12841,4486,29580,46257,50744,48500,27338,25323,40113,54578,58967,56918,44274,39983,44079,52595,56821,35790,19114,21227,21292,17099,12873,25518,31760,29679,27534,27566,25486,27534,25453,33938,31727,4454,19114,31694,16936,12677,19082,44307,21194,21129,25388,44405,23307,21161,25290,20999,19015,16903,10662,14919,19208,12934,12999,8741,21095,23209,4454,6502,10695,10695,8615,10760,23308,14725,12678,14726,12645,10565,8484,10598,46125,54446,35593,18886,18853,18886,48206,41867,12678,14758,18984,33775,44339,23111,16838,31693,31759,19242,19306,19274,17194,21355,48532,52792,54970,46485,54938,38066,33872,42260,40179,40179,42227,42260,44340,42227,31694,25258,38066,42259,48599,25388,132},
{17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19573,19574,21622,19574,21654,36216,48698,50778,54971,55003,55003,54971,52923,54971,54971,54971,54971,52891,54971,54971,52890,50778,50778,50778,48698,50778,52890,52890,52891,52890,50810,50778,48698,48697,46617,46584,44504,44472,44504,46617,50810,54971,52890,48697,46552,42358,38197,36085,34004,33972,33971,31891,34004,36183,38296,40442,40474,48698,46617,50810,50810,48730,48730,46649,48730,50810,46617,52891,59164,59196,57083,50810,46584,46585,46585,46585,46585,38263,36150,38231,25650,10958,17231,10957,10957,10957,13005,8876,8844,8844,13004,13004,17165,15084,15051,12938,25583,44372,23438,25581,29678,17131,29777,23406,25421,40212,40081,27436,31760,42227,38001,42194,52629,25388,19146,40081,33645,37902,37967,33612,33710,23243,44078,61047,54675,40113,35822,44111,52562,52661,29614,17034,21227,27566,19147,21260,25486,38066,40147,40147,40179,40179,42260,40179,29712,27534,2341,21227,31727,18984,12678,12743,40146,38000,21194,23275,42259,29613,27402,27435,23176,21129,21161,16968,21129,23273,23369,23337,23370,23273,27403,23242,23210,23209,23241,21161,16968,19147,14693,10597,10597,10565,8452,6404,4324,41932,56527,41899,16805,16805,16838,44045,39754,12678,14790,14758,25420,42291,48499,50515,35887,25452,17161,17194,17194,15113,17162,44371,50679,50712,42227,52857,48566,35920,40179,40179,42260,42260,42228,42292,44340,31694,18984,35920,40146,37968,46322,208},
{17428,17428,17460,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,19574,19574,21654,27895,32055,48730,54971,55003,55003,54971,52923,54971,54971,54971,54971,54971,54971,52890,50810,50778,50778,50810,50778,52858,55003,55003,54971,52890,50810,50778,50746,48697,46617,48665,50810,52858,50810,50778,55003,57084,54971,50777,46584,46584,44471,38197,34004,33972,33971,31891,34004,36183,38329,42522,46618,48697,48697,52923,57084,54971,52891,48730,46649,50778,46617,50810,55003,57084,52891,46585,46584,46585,46617,50810,46617,40311,40311,38263,34037,13070,10958,8877,13005,10924,13005,10956,8844,8844,10924,10924,13004,17164,17132,8778,27598,35888,25454,25549,38065,19212,35986,31727,23373,29712,46290,38001,33840,42162,31694,35855,44242,23275,27501,37903,37870,25354,21227,52563,52628,23242,33611,50547,54610,40081,33775,56723,54611,46420,27566,8647,25453,44405,42259,40179,25421,50777,59131,57051,59131,59131,44372,33873,35986,31727,4421,23308,31694,19049,12678,16936,42260,31661,29515,33741,33773,35854,33741,33773,33773,35821,37934,37934,37934,40014,37934,37902,37934,37934,37934,40047,40015,37934,37934,35821,29515,17034,10565,6404,6404,4292,6437,4324,2211,35691,58607,48140,16773,14725,12678,37771,35593,18887,14725,16805,27501,48532,57018,48565,35854,42258,33935,19274,19306,19274,17161,40210,50711,48631,42226,52825,54938,42259,40146,40147,38066,40179,42260,44340,46453,27404,20967,25388,40113,61080,65241,200},
{17428,17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19573,19574,19574,19574,21622,19574,23734,46650,54971,54971,54971,52923,54971,54971,55003,57051,54971,54971,52923,50810,50778,50778,50810,52890,52891,55003,59164,57084,54971,52890,52858,50778,50778,48697,50778,57084,57051,55003,54939,54971,59164,57084,57051,52890,50745,50745,48665,40278,34004,33971,33971,31891,34004,38263,44537,46649,48697,48697,48697,48730,57084,54971,52891,46650,46617,48730,46649,44537,48730,50778,46585,42424,44504,44536,50778,52890,48697,42391,42424,40343,36150,17231,8877,4748,13005,10957,13037,13005,10924,4716,6763,13004,10891,15084,19245,21325,29647,44307,33808,25485,40114,25486,33873,29615,23374,31695,39984,48469,42162,33742,42161,35888,44210,35855,25355,35823,44242,35789,27500,54643,39983,35920,52627,50449,40015,23340,29581,54545,46224,35953,46486,40212,44405,46518,44438,44405,35954,48664,57051,54970,57019,52792,40113,35986,38066,35953,6534,23308,29614,21162,10597,19016,42227,35887,33708,35821,37966,40015,37902,35821,35853,37966,37934,37967,40047,37934,40014,39982,37869,40014,37934,35821,37966,33773,31660,33773,27402,23275,18984,12677,12678,12678,12678,10597,6405,27337,56527,52333,18886,20966,10532,33513,31368,20999,16871,18951,29581,42226,31694,33775,35855,35953,31823,19306,19307,19274,17161,29743,48566,54938,57050,54938,54970,44340,38001,38066,38033,35921,40179,44373,31759,23145,27241,37936,61112,65209,58869,203},
{17428,17428,17460,17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,21622,21622,19574,29975,50811,54971,52923,52923,52923,54971,55003,55003,55003,54971,52891,50810,50778,50810,52858,50810,52858,54971,57116,59197,59164,57051,52891,52858,50778,50778,52858,57116,59197,57116,57084,55003,55003,59164,59164,57051,52890,50777,48665,46552,40278,34004,33971,33971,33971,36085,42424,46617,48697,48698,50778,48697,46650,57084,52923,50810,48698,46649,48698,46617,46617,50810,48697,44504,42391,42424,46585,50810,52890,50778,42424,40311,40311,38231,17263,4748,6796,10957,10924,8876,8876,10924,2635,555,15084,13004,10891,17164,31824,40147,31759,31760,25454,37968,38033,27632,19180,25389,33840,44242,35790,23340,37936,42129,23308,40016,29613,21194,33743,52531,31596,17001,44111,37902,21261,36018,31727,10729,8615,25323,52497,48304,42227,52890,52825,59131,50744,48631,38033,33873,27632,31793,33906,33906,27534,35920,31793,33906,40180,8615,21227,31694,23275,10629,16969,48631,40080,31628,31627,33773,35853,35821,33708,35821,37934,35821,35854,37934,37934,40014,40014,39982,42095,40015,40014,40079,40015,37934,35854,33675,23307,33774,14726,12678,10597,10598,10662,6469,21032,52334,52366,23079,20966,12612,23079,25094,20934,14758,21031,23047,25159,18983,29613,35919,33840,38097,19274,19306,19274,17193,19275,42292,54938,54970,54970,54970,44372,35888,42227,38033,40146,42259,42227,25356,14694,33579,52498,58870,54513,37577,172},
{17428,17428,17428,17460,17461,17461,17461,19509,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,21654,46650,55003,54971,54971,54971,55003,55003,57084,57084,55003,52891,50778,48730,50778,52858,52890,52858,50810,54971,59164,59197,59164,57084,54971,52890,50810,52891,57084,59197,59197,59197,57084,57051,57051,59164,59164,57084,52858,48697,46552,42391,38197,33972,33971,33971,34004,36118,42424,44504,46617,50778,50778,48697,46650,52891,50778,48730,46617,46649,50810,50778,52890,52890,48730,44504,42391,42391,44536,48697,52858,46617,40343,38263,38263,38263,19344,4748,2668,6796,13037,10956,6764,8844,6796,555,8843,10923,8843,17197,27664,36018,27502,35888,29615,35888,33808,29679,29647,23308,25454,37936,23243,23308,23341,33840,31597,38001,19147,31759,42064,44177,44143,33805,42063,39982,19147,14889,6535,8713,10728,23242,35757,31661,27599,31858,31858,36019,31825,27599,14954,12906,8713,6567,8713,8680,10760,38000,29646,33939,40180,8615,23307,29614,27436,8550,25486,48631,44340,48433,50546,50579,50612,50612,52660,48467,42127,40047,37966,40047,40079,40047,40047,37934,37934,35886,35886,35854,35854,35821,31693,31627,27500,35920,16773,14726,16806,16806,14726,10565,16871,54414,56526,29320,16773,14693,14725,20934,20934,10532,18886,39786,29287,12710,23275,35887,29613,35953,21387,19306,19307,21355,23403,38065,52792,50744,57050,54938,48598,33807,42194,38033,42259,44372,44372,27436,35692,54644,60852,60885,58804,43882,172},
{17428,17428,17428,17460,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,36248,55003,54971,54971,55003,55003,57084,57084,57084,55003,52891,50778,48697,48698,50810,52858,52891,52890,52890,54971,57116,59197,59164,57084,54971,52890,54971,57116,57084,59164,57084,57084,57084,57084,57084,59164,59164,57084,52858,48697,44471,40278,38165,33972,33971,34004,36052,38230,40344,40311,46617,50778,48697,50778,46650,46650,46649,46649,46649,50810,50810,52891,57051,55003,50778,46584,42391,42391,44504,44536,42424,40343,40311,42424,40343,38263,21457,6829,4716,4748,10957,8876,8844,8876,10956,6764,8844,13004,8811,13004,17165,25486,35855,35856,46387,42162,29615,19245,31760,25389,23276,12906,2439,6600,8746,31695,46290,44209,40048,29581,42193,39983,39951,25420,42063,48304,23341,14888,8583,6600,12809,23307,14921,12938,15019,15019,12938,14986,15019,14987,15019,12906,10793,10793,8713,6600,4487,40179,38033,36019,36018,8647,23307,29614,29548,12678,25421,48599,54937,56985,56984,52758,48532,40145,33839,27500,25387,27435,25387,25387,25355,23306,23274,21194,21194,21161,19049,19049,16968,16968,14888,14888,38033,38001,14725,12645,14726,14725,12645,10565,12678,54414,60686,33513,14692,16805,10564,16805,20934,14693,20966,41867,33448,23177,40112,35887,31661,33872,23467,19307,21355,21355,19274,40146,52825,48599,57018,54905,52792,33775,40114,40081,42227,44340,46453,37968,33710,61081,60983,60885,56757,46094,91},
{17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,21622,19574,25782,46650,55003,55003,57052,57084,57084,59164,57084,54971,52858,50810,48698,48698,50778,50810,52890,54971,52890,52891,55003,57084,59164,59164,57116,55003,52891,57116,59164,57084,57084,54971,55003,57084,57116,59164,59164,57116,57051,52858,48665,46552,40278,36084,33972,33972,33972,36084,38231,38263,40311,48730,52858,50778,50810,48730,48730,46649,48698,50778,48698,44536,46649,54971,52923,46617,42424,40343,42424,46585,44504,40343,40343,42424,44504,42424,38263,25618,8877,4716,6796,13037,10924,6796,8844,10924,8844,6763,13004,10924,8843,23438,21260,31694,38001,50548,38034,25486,27567,33808,29550,29647,15018,6631,6599,21227,29582,35855,27500,38000,44307,21227,14888,10695,2342,31596,48337,29647,14856,10728,27631,23406,19211,8648,12873,12874,12906,12906,14954,12906,12906,14954,14954,14954,12906,12873,10760,4422,25453,33807,27599,31792,8647,21227,27533,29581,12710,17002,46518,54970,44307,21096,21129,14888,14855,10694,10694,10694,8614,10695,10662,8582,12807,10695,8582,10727,8614,6502,8582,8582,17001,8582,6502,38033,44339,18951,19049,12645,8517,10565,6404,8517,48205,60719,41834,25094,25126,8484,16773,18853,14725,20966,43947,31432,42194,44307,37968,31693,31792,23468,19307,19307,19274,17161,33871,40146,44372,57018,54905,54905,33774,37935,37968,40114,42227,42194,44340,33709,46258,61048,60950,60885,50385,138},
{17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19573,19574,19574,21622,21622,25782,50811,57084,57052,57084,57116,57116,57084,55003,52891,50810,48730,48697,48698,48698,50778,52891,54939,50778,52858,54971,57084,59197,59197,59164,57051,54971,59197,59164,54971,55003,54971,55003,57084,57084,59164,57116,54971,50778,48697,48665,46584,42358,36084,33972,33971,33972,36085,38198,38263,46617,54939,54971,52858,50810,52891,50778,48730,50810,50810,48698,46617,46617,46617,46617,44504,42424,42424,46585,48697,44504,42423,42424,42424,44536,42424,38231,29811,6829,2668,6828,10957,8844,6796,8844,8844,8844,10924,13004,13004,13036,19277,12939,23437,25486,46387,27534,23406,33873,33873,36019,38066,21259,8744,12905,12906,29646,46355,29614,35855,38066,27534,33742,46256,12775,23307,39983,33841,14888,17034,21293,6535,10760,19114,21227,21227,19147,21227,21227,21227,21227,21259,23307,23307,21259,21227,19147,14953,29614,42259,19180,36018,17002,21227,27468,29581,14790,16969,46551,52857,48500,19015,19081,23274,17001,14856,16936,12775,10662,14920,12807,10695,14856,12808,12808,17001,14888,10662,12775,10662,21227,14856,8582,31727,46485,21096,16936,12710,12678,12710,10597,8485,39851,60654,46060,23046,27174,8452,12645,16773,12613,25127,45995,33513,23242,31727,42194,35855,31759,25581,19307,21355,19274,17194,31758,40113,44405,57051,54905,54937,33807,35920,40081,40081,42259,42227,42227,46387,33644,52596,48371,39984,42097,137},
{17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,34136,55003,57084,57052,57084,59164,57084,57051,54971,50778,48698,48698,48698,48697,48697,50810,52858,50810,50778,50810,52891,57052,59164,59197,59197,57084,57084,59197,55003,52890,52891,52890,54971,57116,59197,59164,54971,50777,50745,48697,48697,48697,44471,38165,33972,33972,36084,36117,38230,38263,46617,54971,54971,52858,52890,52923,50810,50842,52891,52890,52858,48697,46617,44537,44537,44536,46584,46617,50778,48697,42456,42424,42456,40343,42456,40343,38263,34037,10989,2668,6796,13005,10924,8876,8844,10956,6796,8876,15084,10924,13004,23470,17164,27565,23404,38066,33808,31727,29647,29745,38262,33808,10792,10792,10792,8745,42194,44242,38001,42096,40113,31727,27468,39983,19081,27599,42194,40081,23210,10695,12906,25485,21227,19180,25453,23373,23341,23340,23373,23373,23341,23373,23373,23373,23341,23341,21260,19147,33905,48565,23373,50745,27534,21227,25420,31629,37902,44241,50711,46486,44339,25322,19081,27467,21193,19081,23306,19113,14888,21227,23307,14920,17001,19114,14888,16969,12775,12775,14888,12775,14888,12775,6469,27501,48500,21064,6436,8485,8517,10565,6404,4324,31466,58606,52333,20966,25094,8452,10532,14693,12612,35593,48075,33513,21096,31694,44307,35855,29646,27597,19306,19307,19274,17193,29678,48566,54937,57018,48599,42260,25388,35822,40048,40015,42194,42226,42194,46355,40081,40114,50679,59131,63324,210},
{17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19574,19574,19574,21622,29975,46618,55003,57052,57084,57116,57084,57084,55003,52891,48698,48665,48697,48697,48665,48697,48697,48697,48697,48730,50810,52923,57084,59197,59197,59164,59164,59197,59164,54971,54971,54971,52890,54971,57084,57084,52891,50810,54939,54971,52890,50810,50777,44471,36085,33972,36052,36117,38198,38230,38296,42489,48730,50810,50810,52890,52891,52891,54971,57051,54971,52890,48730,48697,46617,46617,48665,48697,50810,48697,44504,44504,44504,42424,38263,38231,38263,38263,34004,13070,2668,4716,8844,10924,8876,6796,6796,8844,10956,19278,15084,13036,23438,31793,38034,33871,38001,40147,31695,21260,33808,46453,21259,14953,8712,6599,8712,38001,33775,23308,37935,40113,31727,17034,23307,12840,29549,33678,39983,23275,8615,23406,36018,25453,17067,25453,19180,17099,17099,19147,17067,17034,17066,17066,17034,17034,17034,14986,14953,29646,35921,48664,52857,29614,21195,25388,44208,65077,60949,56985,52792,46485,29483,19081,27500,21161,19081,23274,19081,19081,21194,23275,17033,19114,27500,16968,14921,10695,12775,14856,10695,12807,12775,6469,23308,44339,25290,8452,8485,8485,8484,6404,4324,25192,56494,52333,20966,27174,10500,8484,14725,16773,43915,46028,25159,23177,37968,42226,35887,25420,25516,21355,21387,21355,21387,29710,35920,35986,38098,38033,44307,50613,54806,52759,56985,54872,56985,59098,56985,59130,61211,59098,54905,44405,181},
{17428,17460,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,19574,21622,36216,50810,55003,57084,59164,57116,57084,57084,55003,52858,48697,46617,48665,48665,48665,48697,48697,48697,48697,48730,50778,52890,57084,59197,59197,59164,59164,59197,59197,55003,52891,50810,50778,54971,54971,52890,50810,52891,57084,57084,55003,52858,46584,40246,36052,33972,36052,38165,38230,38263,38329,38361,44537,46617,44570,48730,50810,55004,52923,54971,52891,52891,50810,52858,50778,50778,50778,50778,50778,46585,42424,42424,40344,38231,36150,38231,38263,36183,40343,23472,4716,4716,8844,8876,8876,8844,4715,4716,13037,27632,17197,15052,25518,17165,25454,31791,31726,35954,42129,21260,33808,35855,14953,14985,6632,6632,15018,25486,33774,33839,42227,46485,25486,17034,14920,19081,29647,37903,42194,23243,10695,25487,46485,40179,23340,14986,12906,12873,12873,12873,12906,12906,12873,12906,12873,12873,12905,12905,12905,29614,29549,37935,35953,23308,19114,33709,58868,63029,60916,48468,44373,46453,31629,17001,27500,19081,21162,25387,21161,19081,21194,23339,19081,17001,23307,19081,17001,10695,14855,12775,14855,14855,14856,10662,19082,25388,23242,12645,12645,12645,10597,8484,8517,27403,54446,54413,25127,23046,10532,4291,10597,23046,45995,50253,27207,23177,33807,42226,37968,38000,46485,42225,46484,44370,46484,40210,40145,46420,50678,56952,59065,52824,56985,52759,50679,48598,42292,46486,35986,33840,27501,23340,23308,23308,108},
{17428,17460,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,19574,21654,44570,55003,57084,57116,59164,57052,57084,57084,55003,50778,48665,46617,48665,48665,46617,46617,46617,48665,48697,50778,50810,54971,57116,59197,59197,57116,57084,57084,55003,52891,52858,50778,50778,52890,54938,52858,50810,57052,59164,57084,57051,50777,42391,38165,36052,33972,34004,36085,38230,40311,38329,36314,38394,38394,40442,44569,48762,61277,52923,48730,48730,50810,54971,57051,54971,52890,50810,50778,46617,42424,40343,40343,38263,36150,36150,40311,38263,38231,44504,33939,13070,6796,10925,10957,8876,6796,6796,2635,13037,27664,13004,19246,31792,21293,19213,29711,29678,42259,42162,23373,31792,29678,17066,12840,6632,8712,31825,46453,38001,44274,31694,21293,6631,10727,12840,19049,19147,44079,46387,23243,12808,21326,57051,50678,17034,8713,12938,12906,14986,15019,17067,17131,17099,17131,17099,15018,17099,17132,19212,31727,29614,37870,35953,27469,19081,50417,60948,60916,52595,31694,42292,46486,31596,16935,27500,19146,23274,21194,16969,21162,21226,23307,19113,17001,17001,25387,25420,10727,14856,12743,16936,14888,10695,12743,14888,17001,19081,18984,33775,16838,12678,10565,10630,27403,48140,48172,29320,23014,18853,12613,14758,37772,58673,64978,48140,23144,29614,40113,42193,48499,40179,56919,42193,56919,40047,31661,35920,31727,31694,21292,21228,12808,14856,19049,21129,16968,12710,16936,19114,14921,17001,25420,27565,31727,126},
{17428,17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19574,19574,19574,25782,48763,57084,57084,57084,57084,55003,57084,57084,52891,48730,48697,48665,48665,46585,46584,46584,46617,48665,50778,50810,52891,55003,59164,59197,59164,57084,55003,52890,50810,48730,48697,48697,48697,52890,52890,50810,52858,57084,59164,57084,54938,46584,42358,38165,34004,33972,33972,36085,40310,40344,38362,36346,36346,38394,40442,44537,50810,61277,57084,46649,48698,48730,54971,59164,57084,52890,50810,50778,50778,42424,38263,40343,42424,40311,38231,40343,38263,42424,46585,36052,17198,8844,13005,13005,10924,4716,6796,4683,10957,21358,15085,21359,31823,29711,29679,29711,35953,33841,42195,33872,27599,25485,23339,17033,8680,4551,33938,48598,29582,35823,31629,25388,21259,19178,17001,12775,25420,41998,40147,23275,14856,21358,61244,48629,14953,10825,15018,17099,17131,19179,17099,19212,19180,21260,19212,21292,21293,23405,27598,33840,29646,39983,35920,21195,33676,62931,60916,60884,42128,29581,40179,48598,33774,14921,27500,23307,23242,21226,21194,23274,23307,23274,23274,21161,19081,25387,27500,14855,14920,16936,14888,16968,10630,12775,8614,12808,21162,35953,48598,35658,31465,23046,29320,31432,31400,31400,33480,33480,33480,29320,23079,35691,60818,62865,60784,25224,21194,23340,46420,59032,50678,61210,50580,61178,40047,29547,19049,19081,12840,359,8745,10760,10695,14791,23275,25420,19114,23340,27533,19146,21260,21195,29614,31726,132},
{17428,17460,17460,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19574,23702,42457,55003,57052,55003,54971,55004,55004,54971,50810,48730,48730,48697,46617,46585,46584,46617,48697,50778,50778,52858,54971,54971,57084,59164,59164,57051,52891,50810,48697,46617,46585,46585,46585,50778,52858,50810,54971,57116,57084,55003,50777,44471,40278,38165,36052,33972,34004,36117,40311,38328,38362,36346,36346,38394,42522,46650,52891,54971,50811,48698,48730,54971,57084,59196,57084,54971,54971,52890,52890,44504,40343,42424,44504,42456,40343,42424,38263,42424,46585,36052,19311,6796,10925,10925,6796,4715,6796,8844,8876,15085,21359,25487,31824,25518,29680,23373,31792,38033,46388,33808,33873,40146,38000,21259,19210,12905,21293,40180,35888,33742,31629,40147,46420,25420,21193,16968,27501,42031,46453,23275,12808,17132,33971,29776,29679,35986,31825,35985,38066,35986,38098,38131,40179,40179,42292,42324,44372,44405,46518,44404,35887,46224,31727,17002,31661,35855,35855,46420,46420,33774,40147,48632,35887,16968,25420,23275,25355,25355,21226,23307,23274,19114,21161,17001,25388,25387,19113,14888,14888,16969,14888,14888,10662,14920,14920,19081,19081,38067,44373,35755,31497,20966,31400,29385,23111,23111,21031,20999,18918,16838,23111,29449,48271,62898,64978,29320,19049,21195,38066,40049,40114,40114,38066,40211,31662,25355,23275,19114,14986,21260,25421,23373,23340,23275,23275,27501,21227,27598,17001,6469,17034,6502,21227,21228,117},
{17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,21622,19574,23734,40377,44570,50810,52891,54971,54971,52891,50810,50810,50778,48697,46617,46585,48665,48697,50778,50778,50778,52858,52891,54971,54971,57084,57084,54971,52891,50810,48665,46584,46584,44472,44504,48698,52858,52890,54971,57052,57083,52890,48665,44472,40278,38165,36052,33972,34004,38198,38296,38362,38394,36346,38394,38394,46618,50810,52923,48730,48730,46617,48698,57052,59164,59164,57051,57051,52858,52858,50810,44536,42456,42456,42424,40343,44536,44536,38263,44504,44505,34004,19311,19311,13005,10925,13037,8876,6764,13005,8844,15085,13004,23406,33872,23406,25487,21259,25486,33808,42260,42162,21293,21227,17034,14954,12873,8680,12873,21260,33775,27501,23210,31695,38066,19146,23274,35822,42096,31532,29647,25388,12808,8680,2472,19244,44405,48599,46518,46518,46486,46485,46485,46485,46518,46518,46518,48566,48598,48598,50679,42323,40113,42031,25388,12841,14922,12841,25454,29712,29614,29549,40147,46551,37968,10695,21227,21194,23274,23307,19114,21226,19114,21194,19114,14920,19081,17033,17001,19049,14888,12808,14888,14856,19081,23242,23274,31661,33774,44438,44405,37836,29385,20966,29320,27304,14757,14757,14758,14757,16805,16838,25159,29384,27370,52465,54479,29418,40146,40015,29516,38034,42226,29516,27501,29647,19114,21195,25421,29646,25453,27533,25485,21260,21227,19179,21227,23340,21227,19147,10630,4355,14953,17001,23275,25388,126},
{17428,17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,21654,34136,52923,55003,55003,55003,52891,52858,50778,48730,48697,48665,48665,48697,50778,50778,48730,50778,50810,52891,54971,55003,57084,52891,52890,52890,50778,46585,44504,44472,42391,44504,46617,50810,52890,52890,55003,55003,52858,46585,44504,42358,38165,36084,34004,36085,38198,38264,38329,36313,36314,38394,38362,46650,55003,59164,55003,52891,48697,46617,52891,59164,59164,54971,52890,48697,46617,46617,46585,42456,40343,38263,44504,50810,48665,38263,42424,40376,36085,25585,31859,27632,6764,15150,19278,17165,17165,6796,10924,15117,27599,25486,21358,25421,19146,15051,27599,31760,29647,17066,27469,21195,14953,12905,10792,12937,21260,31695,35888,35822,31629,17098,29613,27500,44340,39950,39918,33775,27501,12776,19212,38132,42292,44405,46486,46518,46518,48598,48566,46453,44373,44405,42324,42292,40212,42292,44405,42259,40243,44340,40081,40147,8615,12906,10696,31759,33840,29614,31662,38098,48664,40146,12710,21226,21227,23274,23307,23307,25355,19114,23275,19081,14855,23274,23307,19081,23242,23241,14888,17001,21194,23274,21162,21162,27500,35854,46486,40244,37901,31465,23046,25127,31400,31400,31400,31400,31400,31400,31400,29320,23078,18951,19016,31596,33839,46387,48434,42160,46453,50679,46452,54905,54872,25420,27534,25421,31727,29646,27534,23340,10728,17066,23373,27533,21228,21292,12775,17034,14920,19082,16969,29548,23242,93},
{17460,17460,17461,17461,17461,17461,19541,19541,19541,19541,19573,19573,19574,21622,21622,21622,21654,21654,44570,57084,57116,57084,57051,54971,50778,48730,48730,48697,48697,48698,50778,50778,48730,50778,50778,50810,52890,52858,54971,55003,52891,50778,50778,48697,46552,44471,42391,42424,44472,46584,50778,50810,52890,54971,52890,50778,46584,44472,40278,38197,36085,36052,36117,38296,36215,36150,36216,36313,38394,38394,50843,57084,59197,57084,52891,48698,48730,50810,52891,50810,44537,44537,46617,46585,46617,46617,42424,42391,46617,50778,50810,46617,38263,40376,40344,36085,31858,27633,25552,13037,15117,21358,19245,13036,4683,8876,13004,31793,42195,35921,35921,31759,4585,27632,23373,12906,12906,31694,27469,25420,25452,10792,17099,40179,37969,40114,56854,42129,21259,23275,23308,37935,41997,52432,52562,29548,19049,40146,56886,48500,40179,42162,42292,46420,54708,29581,19017,19050,25355,14888,12743,12776,14888,17066,23339,40179,27534,33873,40211,10695,12841,12776,29647,38033,27501,27501,38066,48599,42259,21063,23307,23275,21194,19081,23274,23242,21194,25355,19049,16968,21194,19114,19081,21194,21129,19081,19081,19081,23274,21129,29580,42160,42193,42293,42325,42160,39917,35658,37772,41997,41965,44045,46158,44110,48400,50481,52594,46255,48369,42160,48435,48434,35822,27501,50646,56985,59131,56985,54872,50711,31759,25421,8583,23373,23340,23340,14954,6502,12841,14954,10728,10728,14986,25421,17001,10695,12776,19082,23242,27468,111},
{17428,17460,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,21622,21622,21622,19574,27895,52891,57084,59197,59164,57084,52891,50778,48730,48730,48730,50778,50778,50810,50810,50778,50810,52890,52891,52890,52890,52891,52890,50778,48697,48697,46617,44504,42391,42391,42391,42423,46584,46617,48698,54971,57051,52890,50777,44504,42391,38198,38165,36117,36084,36150,38296,36183,36118,36183,36281,38329,38329,48730,55004,59164,57084,54971,52858,52891,52891,46617,42424,42456,46617,50778,48697,48665,46585,44504,46585,52891,52858,50778,42456,38263,40344,38296,38198,29746,19344,33907,21391,15117,19278,17197,15117,13004,10956,13004,27665,40147,33841,33841,19245,4552,27599,38001,25420,6632,23405,35888,25389,17034,12905,17099,44373,44307,42194,52628,31694,35953,29451,29549,42129,41998,48272,48336,44241,46354,42160,42128,29483,33840,42096,44242,46321,58803,21129,8517,10597,16968,14823,17001,10695,23307,21195,19146,23307,17033,16969,17034,19114,19114,8615,27534,35920,35920,17033,25421,50744,44372,12743,16969,25420,21194,16936,21194,21129,19082,21227,19081,17001,23242,19082,19081,19049,10695,21161,21096,14888,23274,21162,29614,35855,27533,40212,52825,44339,44273,40014,54643,54545,37837,39982,52529,46191,44078,42030,42096,44144,46192,42063,29483,29581,33807,40179,57050,59131,59131,57018,54904,52824,33840,29679,12939,10826,8680,17067,12809,10695,6534,12808,10663,16969,10663,21195,14888,6469,6437,12744,19082,23242,124},
{17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19573,19574,19574,21622,21654,19574,32056,52923,57116,59197,59164,55003,52890,50810,50778,50778,50778,50810,50778,52858,52890,52891,52891,54971,54971,54971,55003,54971,52858,50778,48698,48697,46584,44471,42391,42391,42359,42359,42423,44504,48697,57051,57084,54971,50745,44471,42359,38198,38165,36117,36085,38198,38231,36150,34070,36150,36118,36150,38263,42424,54971,61277,59164,57084,57052,55003,48698,44504,44504,44537,48730,50778,48697,48730,46617,46585,50810,54939,50810,48729,40344,38263,38263,38296,38230,31826,23505,38067,33906,23471,21358,21358,21358,21358,15085,10956,25519,38034,38034,35921,27566,12938,31825,40082,38001,29646,25485,42195,25388,4487,12905,23372,35953,29679,48501,40114,31629,27565,19049,23275,42096,42063,48336,46224,44372,54807,50547,42161,25355,40179,37935,44176,50417,48336,23275,12677,10597,14856,19082,19147,6502,23307,27500,19082,25420,21227,19114,17001,17033,17034,10663,29615,37934,35788,29514,31694,50745,46453,35655,37834,25355,19049,21161,23274,23209,23242,25387,25355,27435,29516,27468,31661,31661,31661,37934,37934,35854,38000,40080,40081,40081,25453,38099,31727,21161,29548,29515,42029,50351,33709,29580,29548,29321,25258,29581,27436,29581,14888,21194,21195,35953,59065,50646,52792,57018,59130,50646,48566,54937,23340,12841,17001,19147,6534,10728,19147,12775,6437,8550,10695,14889,14856,14921,12808,6469,6437,10630,19082,17001,111},
{17460,17461,17461,17461,19509,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21654,21622,23767,46650,57084,59164,55004,54971,52891,52890,52858,52858,52858,50810,50810,52858,52890,54971,54971,55003,55003,55003,52923,52858,50778,50778,50778,46617,44504,44471,42391,40310,40310,40278,40311,42423,48698,57051,57084,54971,48697,44471,40278,38197,38165,36117,38165,38230,40278,36150,36117,36117,36117,36118,36150,38231,52923,59197,59164,59164,59164,50810,44537,44536,46617,46617,50778,48730,46617,52858,48730,50810,54971,54971,50778,46617,40376,38263,38263,38296,38231,38100,29746,40180,36019,31793,21390,25519,23439,27664,23406,10924,25552,33873,33841,35954,42227,23340,19213,27567,38001,31694,27501,38001,29581,6599,10824,15018,19179,21260,42227,48468,40080,27500,27371,23340,33807,46289,46355,48303,42227,50711,44144,40049,29581,42293,48566,50679,40146,29516,27501,14790,10597,10662,19082,23373,12840,21227,21194,19114,21194,17033,21162,17033,14920,14921,12776,29615,40047,35788,37836,37967,48664,48599,39948,56819,52726,52759,54839,54872,56952,56952,56985,56952,56985,56985,56984,56984,54904,54905,54872,52824,52824,50679,50679,48631,48566,27534,31792,31694,29548,35886,33773,29515,27435,21194,25420,27468,25323,25388,29647,44340,54872,21195,23275,29581,35887,54872,48565,50614,54905,52727,40146,42194,40147,23275,17001,21195,14921,6470,6502,14921,8615,6437,10663,8550,14888,12775,6470,10663,6469,8550,14824,17034,19114,64},
{17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,21654,21654,34136,57084,55004,52923,54971,52923,52891,52890,52891,52891,52890,52858,50810,52890,54971,55003,57084,57116,54971,52890,52890,50810,50810,48697,46585,44472,42391,40310,40278,38230,40278,40311,44472,50810,57084,57051,54939,50745,44471,40278,40278,38165,36117,38198,40311,40311,40310,38198,36117,36117,38197,38197,42424,54971,57116,59196,59196,54971,44537,42457,44537,50778,48730,50778,48730,46585,50778,50810,57051,57051,52890,48697,46617,44504,38263,38296,38296,40344,40213,25585,40180,33906,35986,27600,33874,27600,21391,29712,19277,19278,31760,40114,40180,33840,38001,27567,25454,29680,33840,31727,19179,23308,40082,25420,15018,17196,17131,25388,40017,33774,29581,39950,35822,27435,42129,35921,50482,50613,44372,52595,56886,46354,54971,59164,54971,38001,27305,31662,16870,10565,8517,14889,25454,12840,23340,27533,19081,19081,21194,19114,21226,19049,19114,27566,29679,35887,29514,31595,35854,48632,50711,50480,54838,40244,44373,40179,38066,40146,33873,35953,38033,33872,38033,38033,33775,33840,35953,33839,35887,35953,33840,37935,37936,35888,25420,21227,27500,27500,25387,21161,17001,14888,12808,12840,17034,21195,8583,29647,42259,46453,14921,23275,25323,33806,46518,38001,38001,52792,48468,44307,31629,19017,14889,8615,17001,14856,4324,6470,10695,10695,17001,19114,12840,10727,8647,14953,19114,17033,14921,6502,8582,17066,65},
{17460,17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,21654,21654,25815,50811,52923,54971,52923,52923,52923,54971,54971,52891,52890,50810,50810,52890,54971,57084,59164,57084,52890,52890,52890,52858,48698,48665,46552,44471,42391,40278,40246,40278,40278,40311,44504,52891,57084,57051,52890,50778,48665,44471,40278,38165,38197,40310,42391,42391,40311,38230,38198,38197,38197,38230,46617,52923,55003,59164,55003,46617,44537,44537,46649,50810,50810,52890,50810,46617,48730,48730,50810,52858,52890,48697,46617,46585,40343,40344,38264,42424,40213,31826,40180,29713,31826,31793,31825,33873,29713,31761,25550,27631,37969,38001,42228,42194,35921,21293,19213,38098,40179,29647,27533,33808,38033,35887,19179,19179,17099,35855,42063,10728,10825,33840,44209,42129,40016,23210,35887,54904,52792,52530,52693,52727,59196,57083,57018,40113,29320,31662,16903,10630,10597,14888,25454,17034,21227,29646,21162,27435,23242,25355,27468,38066,42324,38066,25453,33807,21096,27401,33741,46519,54806,61111,50613,31759,44339,40146,38000,44372,38033,42193,48533,44372,46420,48533,42194,50646,52726,48533,50645,52791,52824,54806,54839,50678,52759,50646,44404,52759,42161,35854,29548,12775,12808,12808,12840,10759,19082,27468,33873,48565,27533,21194,25388,31695,33775,29614,37968,48533,50581,33774,21130,10630,14888,12743,8582,12775,14888,12743,8582,12808,17034,17034,12840,8582,14953,14888,12775,17034,19147,12808,6404,17001,116},
{17460,17461,17461,17461,19541,19541,19541,19541,19541,19541,19573,19573,19574,19574,21622,21622,21654,21654,21654,38296,52923,54971,54971,54971,54971,54971,54971,52891,52890,52858,52858,52890,52891,55003,57084,54971,54971,52890,50778,50778,48697,46585,46552,42391,42358,40278,38198,40278,40278,42391,46617,55003,57084,54971,52858,50778,48665,42391,40278,38198,38230,42391,42391,42391,40311,40310,40278,38198,38198,38263,42489,48730,52891,52923,52891,48730,48698,46617,48730,50810,50810,50810,50778,46585,48697,50778,54971,54971,52890,46617,42456,44504,40344,40376,38296,44537,36052,29746,36019,25552,27665,33873,29713,46388,27664,31793,27599,27631,40082,35889,38002,33873,40114,25486,23471,31760,27567,33775,35888,29614,40016,35920,21227,19114,14986,42259,48305,14888,4487,6600,35855,46387,46256,40048,40145,61244,61080,46322,50580,54839,61145,50581,31694,31629,48336,42161,16871,12678,10598,12743,23341,29581,35886,37967,35886,37967,35886,35854,33774,40212,44373,33905,27566,31628,29450,31562,31628,46486,44208,52725,54872,52759,56985,54905,54872,56953,54872,54872,54872,54937,57050,57018,50679,50679,48598,46453,46453,44341,40147,38099,35986,40147,46388,42193,44340,50646,35854,33644,21129,10695,15019,8746,8647,2308,14954,38034,54904,44372,21195,12906,17067,21227,27533,23275,21195,35888,40081,40049,12743,6404,14856,8550,12808,14954,19114,12840,6534,14953,14953,8583,10728,8647,19114,19081,12840,19114,19082,13037,15084,19114,73},
{17460,17461,17461,17461,19541,19541,19541,19541,19541,19541,19573,19573,19574,19574,21622,21654,21654,21654,21654,38296,54971,55003,54971,54971,55003,55003,54971,52891,52890,52858,52858,52858,52890,55003,57052,54971,55003,54939,50778,48697,48665,46585,44504,42391,40310,40278,40246,40278,40310,44472,50778,57051,55003,52890,48697,46584,42359,38198,38198,38198,40278,44471,42391,42391,42391,40311,40310,38230,38230,38263,46650,50778,50778,52891,52891,50810,50778,50778,50810,50810,50778,52890,50810,48697,48697,52858,57084,57051,54971,46617,40344,42456,42424,40376,38264,46617,44406,27665,29746,17198,19311,35986,25520,42228,27600,31761,35954,23439,35921,35987,42228,33808,40115,33808,25487,33840,33775,37936,46421,35888,31728,35986,23307,21258,17066,42259,48468,31629,21195,21227,29647,46290,41998,42096,38001,52825,46453,35921,40081,40113,42161,19017,14856,16904,19049,42259,23177,12645,12677,10630,21228,25420,33806,31693,31661,31661,31661,29580,27500,40147,44373,36018,33807,19082,25289,33675,33708,40015,35821,40113,44274,44241,42161,42128,42128,35887,29581,29614,14921,29713,52923,44438,23242,19049,21161,21097,23079,21031,16806,18983,40081,40113,46093,44176,40113,35855,21194,52497,42031,12776,10728,12874,23340,23307,21195,25486,35986,31760,25388,14954,12938,14889,29581,25323,12775,25356,35920,33775,12808,4357,12808,6405,196,6567,17034,10728,6469,8680,8680,10760,14954,14921,17001,19147,10728,21194,10662,15020,14987,23372,92},
{17461,17461,17461,17461,17461,19541,19541,19541,19541,19573,19573,19574,19574,19574,21622,21654,21654,21654,27895,46650,54971,55003,54971,54971,54971,55003,54971,52891,52890,52890,52858,50810,52858,54971,54971,54971,54971,52891,50778,48665,46584,44504,44471,42358,40278,40246,40246,40278,42391,46584,50778,57051,57051,52890,48665,42391,40278,38198,38230,38230,42359,44472,44471,42391,42391,42391,40310,40310,40310,40344,48730,52891,54971,57051,54971,52923,52891,52890,50810,50810,52891,54971,52858,48730,50778,48697,52890,52890,52890,48697,42456,42456,42456,40376,38296,46650,38132,25585,27665,25551,17198,27632,27566,35954,31793,25487,31761,29680,31728,35921,35954,31825,40179,42129,29582,25486,37968,35856,46453,33743,31727,38001,19114,27532,27597,44307,38034,31695,31662,37968,27631,19082,21097,21129,19049,21130,19049,25356,23242,21130,21129,16904,19017,19017,14856,46486,44110,23112,29320,23079,14888,8615,10728,21162,25355,23274,23274,23241,21161,38034,44405,44438,38033,25388,25322,31562,33643,33675,33676,33708,33740,35788,35756,33676,35788,33708,23275,29581,12775,25486,52923,50777,37935,29516,33742,35855,37870,37870,37903,42161,48500,33807,48207,33677,44405,21163,19017,54707,54740,12743,8615,14889,21195,23340,27469,33808,17001,12841,14857,14856,12711,8550,21162,33775,14856,25388,46322,21130,8615,10695,8615,6469,4389,12840,14921,8582,18855,14922,6698,4422,10728,19147,19179,17099,8647,21260,23373,25453,25453,25453,114},
{17461,17461,17461,17461,19541,19541,19541,19541,19541,19541,19573,19573,19574,19574,21622,21654,21654,19574,32055,50778,54971,54971,54971,54971,54971,54971,52923,52891,52891,52890,50778,48698,50810,52923,52923,52923,52891,52858,50778,46585,44504,42423,42391,40278,40278,40246,40278,40310,44504,48665,52858,55003,55003,52858,46552,42359,40278,40278,40278,40278,42391,44504,44472,42423,42423,42391,40311,40311,40311,42424,46650,52923,59164,57084,57084,57084,55003,52923,52891,54971,54971,52891,48698,50778,50778,46617,48697,50810,48698,46617,40376,44537,42456,40376,40376,44569,33971,25585,27665,27664,25552,33906,31792,35986,38066,33905,31793,33873,31761,31760,35954,38034,29615,44275,31695,25486,42194,33808,23341,25486,40049,38001,23308,31662,25420,31727,27501,29581,42096,48467,29581,10695,16937,19017,19017,19016,23210,23210,19017,21130,23210,21097,21097,16937,16970,46452,52530,48271,41997,14758,21162,25388,31694,46420,48532,48532,48565,50645,50646,48598,44373,40179,52791,40081,42096,46256,42063,31563,31595,33740,35788,35788,33708,33676,35756,35756,21195,29613,29580,33775,50745,48632,48566,48566,50679,50711,52792,54742,50581,50711,42260,46322,54545,44241,44307,15020,12645,52399,58900,23177,12808,14856,12776,12776,16871,31662,23275,10630,8582,8550,10663,10663,21195,38000,10728,17067,38034,21162,10728,8680,10728,10663,8582,12841,12841,10630,10630,12775,17034,10760,19179,17067,17067,17099,12808,14954,23308,27501,25486,25485,115},
{17461,17461,17461,17461,19541,19541,19541,19541,19541,19541,19573,19573,19574,19574,21622,21622,21654,21654,34136,48730,52923,52923,52923,54971,52923,52891,52891,52890,52858,50810,48698,48665,50778,52891,54971,54971,52890,50778,48697,46585,44471,42391,42358,40278,40246,40245,40278,42391,44536,50778,52890,52890,52858,48665,44472,42359,40278,42358,40310,40310,44472,46552,44504,44471,44471,42391,42391,42391,40343,42457,44569,52923,59197,59164,59196,59197,59164,54971,54971,55003,52923,50778,46617,46617,46617,50810,57084,52891,50810,46617,40344,44537,44537,42456,40376,44537,38100,25585,25585,27633,31793,33841,29711,35986,33841,33874,31825,33873,35954,31760,33874,33809,29615,35888,33939,25518,35953,33840,25421,23373,33808,29550,27501,35887,38000,25388,27501,33742,42128,40049,33840,8615,14888,18952,14791,19016,21129,21130,23242,19017,19017,18984,21130,19082,27502,33807,44209,44176,42095,37902,40015,44241,46387,48533,44340,38066,38066,35953,33872,40179,35954,38066,46452,40146,46387,50613,46354,31595,31595,33740,33708,33708,33676,31595,33675,33708,21227,27468,23242,23243,21390,42292,52694,48403,46355,46453,48501,52792,52825,46420,31727,46322,56820,46386,42096,21359,14759,50352,65305,31628,10663,12744,17001,17002,12776,29614,23307,19082,10663,12743,8518,8615,29517,18984,6502,10728,38066,48565,23373,6600,12776,8582,6502,14986,17067,10760,12808,19082,19114,17099,23373,14986,6567,8648,12873,10760,17001,17002,23340,25421,103},
{17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19573,19574,19574,19574,21622,21622,21654,23734,40344,46618,50810,52858,52891,52923,52891,52891,52890,50778,50778,48698,48665,48665,48698,50810,52858,52890,50778,48698,48665,46552,42423,42359,40310,40278,38197,38197,40311,44472,44504,48697,50778,48697,46617,46552,44471,42391,40278,42359,42391,42423,46584,46584,44504,44472,44471,42423,42391,42391,42424,44537,46617,52891,59196,59197,59197,61277,59196,55003,52891,50810,50810,48665,44537,46617,50810,57084,59197,57084,55003,52891,44537,44537,46617,42424,40376,44537,36020,25553,19344,25552,29680,31793,27632,33841,33841,27632,31761,31793,31761,29680,40180,35954,44341,46421,29679,21324,27599,40081,33808,27566,33808,46387,42161,31726,38000,31726,35888,29582,29581,31662,33840,21227,25356,27436,25388,29549,31694,31662,33839,31727,31727,33807,35920,35920,35953,35953,38033,35953,38033,38033,35953,35952,35920,33872,33840,33840,33839,31759,27565,29614,25323,40179,31759,21194,35986,42325,38001,33643,31563,33708,33708,33707,33708,31595,33675,33675,25355,29613,23242,27566,44405,50549,50484,46356,44340,48501,46485,46583,46551,46420,50614,48304,58933,48499,48500,46485,35986,50677,63290,31726,16969,16937,14889,21195,19082,25421,12776,17066,14921,10663,16904,17033,27469,19049,17001,25388,35889,46421,29581,8582,12808,12808,17001,17002,19147,21293,19179,12873,12840,17034,19147,17099,14888,16935,21161,23242,12841,17066,25453,19180,50},
{17461,17461,17461,19541,19541,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21654,21622,25815,36216,42457,48730,50810,52891,52891,52891,52890,50778,48697,48697,48665,46617,46585,48697,50810,50778,48698,48665,46585,44504,42423,42391,40310,40278,38198,38165,38197,40310,42423,44536,46617,46617,46585,46585,46552,44471,42391,42391,44504,42391,42391,46584,46552,44504,44472,44472,42423,42423,42423,44504,46617,48698,50843,55004,59197,59197,59196,59164,57051,52891,50810,54971,48697,44537,52891,59164,57116,57116,57084,54971,52923,48698,44536,44536,42456,40344,48697,33971,23505,21424,27633,29680,29713,27600,33873,25519,25519,33873,29680,31760,33873,31793,33874,35954,19245,17132,19180,8745,29647,33775,33872,33840,35952,35952,35952,35920,35952,35985,35953,35953,35953,35953,35985,35953,35953,35952,33872,33872,33872,31791,31759,31759,29679,29646,27566,27566,23373,23373,23340,21260,21259,19147,17034,14954,12873,17002,14921,14921,27533,6534,17067,35921,50745,42226,23307,44438,44405,33840,33676,31530,33708,33708,33675,33708,33675,33675,33675,27468,31727,27468,35953,42194,44275,44274,38000,42226,44405,48599,27566,21259,40179,56985,52496,61046,56821,46191,46355,52790,50515,58967,25420,12808,14823,10663,10728,14953,17034,10695,10696,8615,14954,19114,25355,27469,38067,27469,19115,29582,27534,21195,6469,10695,10695,8615,10727,10695,10695,12808,8647,6502,10727,10760,19180,31726,44174,42061,39980,29613,29680,23340,12873,27},
{17461,17461,17461,19541,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,21654,21654,21654,32023,42457,48698,52891,52891,52891,52891,50810,50778,48665,46617,48665,46617,46585,46585,48697,48697,48665,46584,42423,40311,40310,40278,40278,40246,38197,36117,36117,40278,44471,46552,46584,46585,46584,44504,44504,44471,42423,44504,46552,42359,42359,46584,46552,44504,44472,44472,44472,44472,44504,46585,46617,48730,52923,54971,55003,55003,57084,57084,55003,52891,50810,52891,50778,46585,52891,59197,59164,57084,54971,52891,48730,46617,48697,46617,42456,40344,52890,33971,21424,25585,29746,33938,27632,31825,25486,21326,27665,31761,27600,29712,31728,27600,25519,35921,25486,23438,19115,8713,38001,35953,27534,25486,25453,23340,21260,21260,19179,19147,17067,17034,14954,14953,14954,12841,10760,12873,12840,8680,10760,8615,10728,12808,8647,8647,8614,10760,8647,6534,8615,8647,8615,8615,8582,8582,6502,8615,8615,23373,35953,10695,10728,19180,25519,44372,37934,44438,46486,33808,33708,31530,33676,33708,33676,33741,33708,33708,33676,35854,35887,27501,29581,31693,27501,35920,33873,50743,42292,35918,19078,21226,42260,54937,58999,63160,59064,52562,52629,54904,50417,50483,21064,6502,10727,6501,4421,17001,12808,14889,14921,12776,12939,19017,27468,33839,27631,10728,10728,10696,21194,21161,17001,27467,19081,29580,21194,27434,23176,19016,31659,16968,35788,17001,14953,19147,44339,40113,44307,35920,27566,17002,4389,16},
{17461,17461,17461,17461,19541,19541,19541,19541,19541,19573,19573,19574,19574,21622,21622,21654,21654,21654,29975,32055,46617,52891,52891,52858,52858,50778,48698,46617,46585,46585,46585,44536,44504,46585,46585,44472,42391,42359,40278,38230,38198,38198,38197,38165,36117,36117,40246,44471,46584,46584,46552,46585,46552,44504,44472,48665,48665,44472,40310,42391,46584,46584,44504,44504,44504,44504,44504,46585,46585,48698,50810,55003,57116,57084,55003,57084,57084,55003,52890,52890,52891,50810,46617,50810,61277,59197,55003,54971,48730,46617,44537,52891,48698,44537,38296,46617,31859,21424,25585,29713,21391,23472,31826,33808,19246,17165,29681,31793,35954,38002,27600,29680,40147,33873,12939,29614,10826,38001,35953,12841,8647,6502,4389,4389,8615,10728,6502,6534,10695,4421,6502,8615,6534,10695,10728,8647,6502,8615,6534,8615,10727,8647,8615,8615,17034,12840,8582,8615,8647,10727,10695,8647,8615,8582,8582,8615,10760,33840,12808,8582,12808,21260,46518,44240,46453,46551,35920,35854,35821,37967,40048,40080,40112,42160,40112,40080,40112,40080,42161,44339,42193,35921,35920,23373,33905,40114,48597,46385,50580,48565,48566,48402,56854,56952,50612,54840,56789,44013,39885,18951,6502,6502,4356,2275,19113,17033,14953,19114,19147,21195,14888,12808,14954,10695,25454,27534,19115,31759,44240,31693,37901,29613,35821,33741,33708,31562,21128,35788,21161,31562,21128,14888,27566,46518,46551,44405,38066,38066,25453,10727,14},
{17461,17461,17461,19541,19541,19541,19541,19541,19541,19573,19573,19574,19574,19574,21622,21654,21654,21654,21654,29975,48698,50810,52858,52858,50778,48698,48698,48665,44537,44504,44504,44504,44504,46584,44504,42391,40311,40278,38198,38197,38197,38197,38165,36117,36085,38165,40278,44472,46584,46584,46552,48665,46585,46552,46617,46585,44504,44471,40310,42359,46584,46584,46552,46552,46552,44504,44504,44504,48697,50778,52891,59197,61277,57084,55003,55003,52923,52923,52891,52923,54971,52890,48697,48730,59164,61277,57084,52891,48698,44504,42456,50810,48698,42457,38296,46585,27698,23505,25585,27665,23472,33906,35954,40115,33841,21358,31793,31760,31761,33841,31793,33873,33873,23406,10858,40146,29679,25486,31792,10728,8647,10728,4422,6502,14921,10695,8582,6567,14921,10728,8582,8615,8582,14921,10760,8582,6534,6534,8615,8647,10695,12840,8615,6534,10727,8647,8615,8615,10727,10727,10727,10695,10727,12840,12776,12808,12808,31759,10695,8582,12808,19147,46518,37999,40212,38066,25388,31661,33774,35887,37999,37935,37967,40080,44273,44273,44241,46419,52791,50711,40179,52727,33775,14920,17033,40147,52792,48534,56985,46420,48500,42161,37871,44210,35854,46192,59000,41933,41836,17001,4357,2244,4389,17067,25453,29647,14889,10695,12808,25453,29679,29647,29647,31760,38066,46486,42292,38033,40013,21194,35788,31726,31628,37999,35887,33707,16903,35787,19048,29481,21063,21195,42292,48631,46519,48632,44372,38098,19114,6502,15},
{17461,17461,17461,19541,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,21654,21654,21654,21654,36216,50778,52858,52858,50810,50778,48698,48697,46585,44536,46585,48665,46585,44504,44504,42423,40311,40310,38230,38165,36117,36117,36117,36117,36085,36085,38165,40310,44504,46585,46585,46617,46617,46584,46584,46617,44504,42391,42391,40278,42359,46584,46584,46584,46584,46584,44504,44504,44536,48697,48698,52891,59164,61277,59196,55003,52891,52923,54971,54971,54971,54971,54971,48730,44537,52891,59197,59164,46617,40376,40344,44537,50810,48730,44537,40376,50810,29778,21424,23505,23505,27633,38067,27600,29713,33873,25519,27664,31761,31760,35921,29680,33841,33873,27567,2472,23504,29744,35920,35920,8583,4422,8583,4422,6502,14953,14921,10695,6567,12808,10728,10695,10695,8582,12840,12808,8615,6534,10695,6534,8614,10728,10760,10727,8614,8647,17034,14953,14953,12840,10728,10727,10695,10727,14953,8614,10727,14888,29679,12808,8582,10728,17067,44405,38033,35953,35919,35920,42194,44306,46420,50613,48565,50678,46452,44372,40146,35920,23340,12907,12906,29679,59098,42161,19146,38000,35920,46485,42194,48534,52726,54807,44339,21162,35692,35789,48402,56953,52628,41771,14759,17034,17034,17034,36018,44373,38066,21194,31759,38099,40211,40179,42292,35986,38131,38099,46518,19147,19114,44174,33740,33707,31595,31595,37901,33740,35755,21128,33674,29547,27369,25256,25454,46518,46551,40212,44439,46551,25421,10695,2276,15},
{17461,17461,19541,19541,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,21654,21654,21654,23734,40377,50778,50810,52858,50778,48665,48665,48665,46585,46617,48665,48697,46585,44504,42391,40311,40310,38230,38197,36117,36085,36085,36084,36084,36084,36085,38197,42391,46584,48665,48697,48665,46617,46584,44504,44472,42391,42391,42391,40278,42391,46617,46617,46584,46584,46584,46584,46584,46617,46649,46649,52923,55003,59197,61277,57051,55003,57084,54971,54971,54971,54971,54971,50778,48698,50810,55003,48730,40344,40344,44537,46617,50778,48697,44537,40376,54971,33971,21424,25553,27665,29713,38067,29713,15117,25519,27600,21390,31760,38002,35921,29648,23406,31793,31728,17100,23406,23405,27534,31760,8647,6502,12808,4421,4422,12840,12873,14921,12808,6567,10760,10728,10760,10728,12808,10727,6534,6534,10727,6502,6534,12808,12808,14921,10727,12808,14921,14921,14921,10760,10728,8615,8615,8647,14921,8582,10695,12808,27599,14889,8582,12840,19147,31760,48631,54905,59098,52824,44406,44470,52824,46518,46518,36018,25421,21260,19179,12873,6534,10793,15019,23340,48599,46419,23308,38066,42194,44274,40081,50646,54839,54937,52792,42162,44340,33741,19114,35920,35854,33611,27402,31693,21260,29614,42259,44373,42325,33807,33840,40212,46518,48598,46485,33873,23340,40244,48599,23275,10728,42094,21161,31660,25289,16968,40046,27533,35755,10662,29515,27500,19080,25288,27599,46519,46486,44405,44406,40180,25421,14888,2308,17},
{17461,17461,17461,19541,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,21654,21654,21654,29975,44537,44537,48698,48698,46585,46585,48665,46617,46585,46585,46585,44537,44504,42424,40311,40278,38230,38198,38197,36117,36085,36084,36084,36052,36084,36085,40246,44471,48665,48697,48697,48665,46585,46552,44471,42423,42391,42423,42391,40278,42423,46617,46617,46585,46584,46584,46584,46585,46617,46649,46650,48730,52891,59197,59196,55003,54971,54971,54971,54971,54971,54971,52891,48730,50778,50810,50778,42457,40344,46617,46649,46617,50778,46617,42456,38296,50810,33971,23472,21424,27633,27633,40180,33873,23439,23471,31761,23439,29680,27600,33841,33808,27567,31728,33873,35953,31727,19148,10826,25519,10728,6502,17002,6502,4422,8647,14953,14953,12808,6534,10727,8615,8615,8615,12840,12873,10727,6534,12840,10695,10695,17033,10727,14921,12808,8647,8615,8615,10695,14953,12808,10695,10695,10760,14921,10727,14888,10695,27566,17001,6502,10695,12808,25486,23341,40212,52825,40179,25486,27567,40081,25322,19082,4389,2276,2276,2341,4389,8583,17132,19278,23340,50712,44372,19017,29614,50548,44275,40146,38033,42259,40244,42357,52824,54937,31661,4324,27402,29515,29548,27435,31661,14921,31695,42259,42292,44406,35953,35953,44405,50711,52791,46484,19049,2243,36019,46551,31760,17035,37933,27500,27467,29482,12775,37868,10695,33707,16935,25321,29515,12775,27434,33873,48598,46519,46486,50745,46486,42259,29613,2276,15},
{17461,17461,17461,19541,19541,19541,19541,19541,19573,19573,19574,19574,19574,21622,21654,21654,21654,21654,27895,32055,34103,46617,44537,42424,42456,44504,46585,44504,42391,42391,42424,42423,42391,40311,38230,38198,38198,38165,36117,36085,36084,36052,36052,36052,36117,40278,46584,48697,48697,48697,48665,46617,46584,44504,46552,44471,44471,42391,40278,42423,48665,48665,46617,46617,46585,46585,46585,46585,44569,46649,48698,52891,57084,57084,57051,52891,52891,54971,55003,57084,57051,52890,50810,50810,52891,50810,42457,46650,52891,50778,46617,48697,46617,40344,40344,46617,27698,19344,17264,27666,29713,36019,33874,33873,33873,29713,25519,29648,25519,33841,33809,27567,33873,33808,33874,40081,33808,15019,25518,12808,8615,14954,6502,4422,10760,12873,12841,12840,10760,8647,8647,10695,8647,12840,14921,6567,6534,8615,8615,10728,14953,10728,10727,8615,10727,8647,8647,10728,10728,10760,12840,14921,12808,17001,10727,12840,10695,25453,21194,8615,10728,12873,25454,23307,23340,25453,38066,42259,44372,40146,35854,31661,21162,19017,14856,10760,10728,4455,10793,19147,19115,50711,40179,19082,25388,44340,29647,17099,21227,19114,23274,23307,46486,52824,37935,4323,25354,33708,31628,29515,33709,17034,33872,42226,40180,36019,33872,44372,46387,50678,52792,46485,40179,35953,42260,46518,33840,4357,31627,29547,21161,33675,10662,37868,12775,31627,29580,23241,33675,17066,25354,27534,42260,46518,44406,48664,52825,33872,29614,4388,17},
{17461,17461,19541,19541,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21654,21654,21654,21654,23734,34135,40376,42456,42456,42456,42424,44504,44504,42391,40311,40311,42391,44472,42423,40311,38230,38198,38198,38165,36117,36084,36052,36052,34004,36052,36117,40310,48697,50778,50778,48697,48697,48665,46584,44504,46552,44504,44472,42391,40311,44504,48697,48697,48697,46617,46617,46617,46585,46585,44537,44569,50811,54971,57084,57084,55003,52891,50843,55004,57084,57084,57084,54971,50810,52891,52923,50810,48698,50842,50842,50778,44537,44569,42457,38296,40376,40310,15183,17264,15183,27666,36019,27665,25552,29681,25552,29680,29680,19278,23439,29680,38002,25519,27665,40115,40147,40081,25454,10858,27599,14921,12775,17034,6502,4454,8615,8647,10728,12808,10760,12841,10760,10728,10728,10727,12808,6567,8615,8615,8615,8647,12873,10728,10760,12808,10727,10727,12808,14921,8647,10728,12808,12808,12808,17001,8647,12775,10694,21228,44340,33873,33743,31662,39984,31630,35725,31760,46485,38033,44307,44274,44274,42161,35920,25420,12808,23405,21260,8680,17034,23308,25454,46388,40081,14889,27501,21260,8647,8648,21194,16968,23274,25420,44405,54905,42193,8484,19016,25322,23242,21161,23274,23308,29646,29614,35986,29647,27533,46419,46419,48565,57050,54905,50712,38099,33873,46518,38034,2243,27402,31562,14856,35820,8549,33675,12742,25321,35854,27533,31627,21292,21161,14953,33840,46486,42325,38132,50647,27533,31759,12775,24},
{17461,17461,17461,19541,19541,19541,19541,19541,19573,19573,19574,19574,19574,21622,21654,21654,21654,23734,34136,44537,44505,42424,42424,44504,46585,46617,42424,40343,40343,42391,40343,42391,42391,40311,38230,38198,38197,38165,36117,36084,36052,34004,34004,36052,36117,42391,50778,52858,50778,50778,50778,50777,48665,46585,46585,46552,44472,42391,42391,46585,50778,48697,48697,48665,48665,48665,46617,46585,44537,40442,48763,52923,55003,55003,54971,52891,48730,54971,55003,57051,55003,54971,50810,50810,55003,50810,48730,50810,50778,46649,44537,44537,44537,38296,42456,29811,13103,15183,19344,21424,31826,25585,27600,27600,19278,21391,33841,25519,25487,27567,29712,29680,23407,40147,33808,35952,25421,6665,27632,14921,12775,17002,8647,8615,12808,10727,10728,10760,10727,12873,12808,8647,10728,8615,10728,10695,8615,8647,8647,10727,17034,10728,10728,10727,14953,10727,8615,10728,10760,10728,10760,12808,10728,12808,8615,12775,16969,25454,48599,42227,39886,46063,46062,41966,41869,35921,40278,29679,31662,23275,17001,19082,23275,23308,10728,21326,14921,12808,12808,17066,23308,44274,40113,17002,25421,12841,12808,6437,19049,19081,27468,27500,42292,54937,46420,12677,8549,8517,8582,6437,6469,21260,19082,14856,31825,33873,27598,48533,52824,59131,59196,57018,50712,33840,23341,46486,42292,14889,25387,33740,16935,35788,16903,33707,23208,25321,35821,33773,31562,25354,23208,14888,27534,40147,42292,33873,48566,29614,31726,16969,55},
{17461,17461,17461,19541,19541,19541,19541,19541,19573,19573,19574,19574,19574,21622,21654,21654,21654,32023,42457,44537,44505,42456,42424,42424,44504,44504,42424,40343,42424,44504,42391,42391,40311,40278,38230,38198,38197,38165,36117,36084,36052,34004,34004,34004,38197,46584,52890,52890,50810,52858,52890,50810,50778,48665,46617,46552,44504,42423,42391,46617,50778,48697,48665,48665,48665,48665,46617,44537,42489,42554,55036,57084,57084,55003,54971,50810,48698,50810,54971,55003,54971,54971,52858,48730,50810,50810,50810,48730,46617,44505,46649,48730,46617,38296,42456,27698,17264,19344,21425,19344,31826,29713,29745,29680,38067,25519,35954,25519,19213,31728,27600,33808,29648,40180,35921,31791,42258,31793,33906,12808,4454,12840,8615,6534,12841,10760,12808,10728,12841,14954,10760,8615,12808,10728,12873,10728,8615,8647,10695,12841,17034,12808,12808,12808,10760,8615,6534,8647,12873,12808,12808,14889,12808,12808,10695,14921,21162,25453,46518,42260,35726,44015,43982,41901,41804,33710,42390,46486,46289,44078,46321,44274,27501,29679,14889,12874,12808,12808,6502,10695,21227,27567,21195,25388,35920,25486,27501,16935,21129,21194,25387,23275,38099,50712,46420,16935,8614,14855,10694,6469,8550,17034,12873,10793,29712,33873,40212,59163,59164,59163,59164,57018,48631,44405,35953,44405,44405,14954,17001,42094,33773,35821,29547,31627,35821,29547,33708,19048,29546,25387,23274,17001,25486,38034,42292,35920,48631,33839,27533,29647,116},
{17461,17461,19541,19541,19541,19541,19541,19541,19573,19574,19574,19574,21622,21622,21622,21654,29975,44569,46617,44504,44504,44537,44504,42424,42456,42424,42424,42424,46617,48665,44472,42391,40311,40278,38230,38198,38197,38165,36085,36084,36052,34004,33972,36052,40278,50778,54971,52890,52890,52890,52890,50810,50778,48665,46585,44504,44504,42423,44504,48697,48698,48697,48697,48697,48665,46617,46617,42489,40442,46683,61277,59197,59164,57084,54971,50810,48698,48730,52923,57051,54971,54971,50810,48730,52923,52923,48698,44504,46617,46617,48730,50810,46585,38296,44504,25617,19312,23505,25617,25585,35987,29713,27665,29681,38099,29713,35953,21358,15117,25487,27535,27567,31760,33905,31728,27567,40179,44373,38067,12809,4422,12841,6534,6534,8615,10728,10727,6502,8647,10728,10695,8647,10728,8615,10727,6567,8615,8614,8615,12840,17034,14888,12808,14888,10695,10695,10727,12808,12840,12840,17001,19114,17034,17001,17001,19114,27468,33775,48631,42292,31629,31565,33677,33677,33710,35888,44405,40146,48533,48500,56921,54872,29646,27567,19017,10760,8615,10663,8583,8647,14986,23341,27370,25388,44372,46485,35920,10662,12807,21162,21162,16969,35953,50679,48533,23209,6469,10662,12743,6501,10662,12841,14954,6664,23438,33873,40179,59163,59163,59163,59164,57050,48599,50712,48631,42325,46486,21195,10695,40014,23307,33740,16936,21161,35854,17001,35821,8614,27467,35854,44404,33807,23373,46486,42293,46519,57083,44372,25421,19147,86},
{17461,17461,19541,19541,19541,19541,19541,19541,19573,19573,19574,19574,21622,19574,23702,34103,46617,48698,44537,44504,46617,48698,44536,42424,42424,42424,44504,44504,50778,50778,48665,42423,42359,40310,40278,38198,38198,38165,36085,36084,36052,34004,33972,36084,40310,50810,54971,54939,52858,50810,52890,52890,50778,48665,46585,44504,44504,44504,46617,48697,48697,48697,48697,48697,48665,46617,46617,42489,40442,48763,61309,61277,59197,59164,55003,52891,50810,52891,52891,54971,55003,54971,50810,50810,48730,46617,44537,42424,44569,44537,48698,50810,44537,38264,46617,31891,19312,17264,23537,23505,31826,29713,31794,29713,17166,21391,42195,25487,15117,25551,31760,25487,23439,35921,35954,33743,31728,40114,31760,12841,4422,12808,10728,10695,12808,10727,8647,10727,8647,12873,12840,12840,14921,14953,21227,17034,17066,19146,21227,25420,27533,27533,27533,27565,29614,29646,31759,31759,31759,33839,35920,35952,35952,35952,35952,35952,40113,50711,54937,52726,50613,48533,50613,50645,50613,50645,48533,31629,29549,52759,52759,56985,31694,27566,25290,12776,8583,12776,4422,10695,19115,27533,25420,27501,44372,42357,38033,12807,14856,21129,23274,21194,31760,48631,48566,29548,14888,21194,21227,21227,19147,19115,21260,15018,19180,31760,38099,59163,59163,59163,59164,57050,48599,48631,46519,42324,44438,35953,27534,40047,31726,33806,21160,14855,37933,21259,35820,17001,25354,42160,48599,37968,16936,44437,42293,44438,55003,57051,33840,27534,134},
{17461,19541,19541,19541,19541,19541,19541,19573,19573,19574,19574,19574,19574,21622,34135,44537,44537,44537,44504,44504,48665,48697,46617,44504,42424,42424,42424,44504,50810,54971,52858,46585,42391,40310,40278,40246,38198,38197,36117,36084,36052,33972,33972,36084,42391,50810,57051,54939,50810,52890,55003,52890,48697,46617,46585,46552,44504,44504,46617,48665,48697,48698,48697,48665,48665,46617,44537,40442,42490,48731,61309,61309,61277,59197,54971,52923,54971,54971,52923,52891,54971,52891,48730,50842,46649,42457,42456,40376,42456,42456,46617,48697,44537,40344,48730,46584,23537,17263,19344,21424,31826,33906,31826,21391,13037,23471,48501,33841,15084,15085,23439,29680,23406,35921,40082,40082,31761,40147,33841,23373,21260,23340,25453,27501,27533,29646,31727,33839,31759,33839,33840,33872,35920,35952,35953,35985,38033,38033,38065,38065,38033,38065,38066,40146,40146,40146,40146,40146,40178,40146,40178,40178,40178,42226,40178,42226,40145,42226,46485,44339,42193,40113,40080,38000,38032,42226,38000,35919,52725,56887,54775,54937,38033,21260,21162,25289,27434,29547,27467,29515,31628,21162,6535,21227,44502,38261,42259,35953,44340,40179,42324,42324,42357,42325,42325,42325,42292,42325,40212,42325,38131,27599,29679,19212,14986,27566,38067,59163,59163,59163,59163,57050,48599,48599,44438,42292,44405,35986,17164,37966,27500,27467,33740,21227,37934,19114,31660,14855,19048,40048,48598,42259,14888,44405,42293,38131,46551,48632,31727,27533,155},
{17461,19541,19541,19541,19541,19541,19541,19573,19573,19574,19574,21622,25782,32023,42457,46617,46617,46585,44537,44536,48698,50778,48730,46585,42424,42424,42424,44504,50810,54971,52858,48665,42423,42359,40278,40278,38198,38197,36117,36084,36052,33972,33972,36085,42391,50810,57051,54971,52858,54971,55003,50810,48665,46585,46584,46552,44472,44472,46617,46617,48697,48698,48697,48697,48665,46617,44537,40442,42489,44570,55036,61277,59197,59164,55003,57084,59164,57084,57051,52891,52891,50810,46649,50810,48698,44537,44537,40376,46617,42456,48697,46617,40376,38296,46617,42391,25650,19344,19344,23537,29746,33939,36019,19278,17198,23503,48469,31728,8843,15085,17165,19246,21358,31793,38067,44308,23276,27534,40212,40211,35985,38033,38033,38033,38033,38033,38033,35985,38033,38033,38033,38033,38033,38033,38033,38033,38033,35985,38065,38065,38065,38033,38065,38032,38065,38033,35952,40113,40113,38032,38032,38032,35952,38032,35952,35952,35951,35919,35887,33838,31726,31694,31693,33774,33774,27500,31694,37968,50645,50613,54807,50679,40180,29646,23307,29515,31595,31628,31628,27434,29515,21162,4422,6502,21390,25680,33840,38099,48599,46519,48631,48632,48632,46551,48632,48631,46551,44406,38131,33906,25486,19147,19180,14986,10793,27566,35986,59131,59131,59131,59164,57083,46518,48599,40180,35953,42292,38066,12939,35854,23241,17000,37966,27566,37901,17001,29548,21096,12775,35854,40146,46485,40146,44437,42292,40179,42325,48664,40147,33839,176},
{17461,19541,19541,19541,19541,19541,19541,19573,19573,19574,19573,36216,42457,42424,46617,48730,46617,46617,46617,46585,46617,48697,46617,46584,44504,44504,44504,44504,50778,52891,50810,50778,46584,42391,40310,40278,40246,38197,38165,36085,36052,33972,33972,36084,40310,48730,57051,54971,54971,57084,52891,48730,48665,46585,46584,46552,44472,44472,46585,46617,48697,48697,48697,48697,48665,46617,44537,42489,42489,42489,50876,61277,59197,59196,59164,59197,61277,59197,59164,48730,44569,46649,46649,50810,50810,50810,42457,42424,46649,42456,50810,48698,42456,36215,46649,44504,23505,15183,15183,19376,23505,38100,33906,19278,23471,25584,44340,40115,17165,19245,29648,27567,33873,35954,38100,44340,23276,17132,42293,35986,29679,31726,29646,29614,29614,29646,29614,27565,29646,29614,29646,29646,29646,31759,33806,31758,33839,33839,35952,35920,31726,33839,35920,35952,35920,31759,31759,29646,29646,29646,27533,23372,25485,19179,19147,21260,21292,23340,25453,31790,19210,12872,19178,17067,33840,21227,42194,44275,46420,44339,46420,33840,38164,44372,21227,19081,23242,23307,23307,23242,21129,16968,8582,8582,12970,19407,29614,36019,46551,50777,52857,52825,48631,44438,42293,38131,36018,31792,29712,25486,23405,23341,19212,19212,14954,25518,35986,59131,48565,54905,59196,59131,46518,48599,19114,19147,40179,42260,14986,31693,33740,21226,37934,25453,33740,14823,23274,25322,10694,31660,40114,44438,46485,42259,38001,40113,40179,35986,42259,44373,165},
{17461,19541,19541,19541,19541,19541,19573,19573,19573,21622,38296,50778,46617,44505,46650,48698,48698,48698,46617,46617,46585,46585,46585,46585,44536,46585,46585,48697,52891,52858,52890,50810,48697,46584,42391,40278,40246,38197,38165,36085,36052,34004,33972,36052,38198,48698,55003,54971,54971,55003,52858,50778,48698,46617,46584,46552,44472,44504,48665,48697,48697,48697,48697,48697,48697,44537,42457,42489,42489,42489,52956,61277,61277,61277,59197,59197,59164,57116,50843,40376,40344,44537,48698,46649,48698,46617,40376,42424,46617,42456,48730,48698,42457,36183,48730,46584,25585,17232,15184,15151,19344,36052,31794,23439,25551,27664,44308,48567,35921,23407,31793,31760,35987,44373,35986,46421,31694,19211,42162,35953,29679,27566,29614,29614,29582,31759,31759,35952,40113,40146,40081,42226,46452,52759,38033,29679,38098,44340,40244,31793,8681,10793,27567,33775,19115,6600,21260,12873,10793,10761,6600,8648,12905,6535,6534,8647,8680,17034,19147,23307,12936,15081,17097,8614,38131,29646,33807,33807,33807,33807,31727,31694,40212,44405,25388,21226,27467,27435,25420,21194,23209,16968,6534,6502,15084,21519,31695,17034,40212,44340,44340,54938,50744,46518,42292,27566,38099,29679,33905,29712,25486,29679,17067,23373,14986,23373,40179,59164,46419,52824,61276,57050,40179,33872,25420,25388,31759,33872,25453,27532,27500,25420,25419,25387,27467,25387,25387,23307,21226,21227,23308,17066,31727,42193,35920,31759,46485,42292,33840,42227,159},
{17461,19541,19541,19541,19541,19541,19573,19573,19574,38329,55003,50811,46617,44537,48730,48730,50778,48730,48697,46617,46617,48665,48697,46617,46585,46585,46617,50810,52923,52891,52891,52890,50810,46584,42391,40278,40246,38197,38165,36085,36052,34004,33972,34004,38197,46617,54971,54939,52891,54971,52890,50778,48697,46585,44504,44472,44472,48665,48730,48697,48697,48697,48730,48697,46617,44537,42457,42489,42489,42490,48795,61277,59197,59197,59197,59164,57084,52923,44537,38296,38296,40376,42456,42456,44537,44537,42424,40376,42456,42456,46617,46617,44537,36183,44569,48698,33972,17263,15183,13103,15183,33939,38067,23407,21358,29777,46453,44308,31760,17101,23503,25519,31761,31793,35954,42227,40048,19243,31759,21260,6665,17100,27534,25454,21196,35921,35953,33807,40114,37969,29582,17100,17133,40049,31662,27566,35986,40179,36018,35986,23373,19148,19180,31694,17001,6567,21259,12841,10760,10760,6599,8712,19179,8647,6534,8647,8647,17034,19114,21195,6502,8646,6534,19148,54938,33872,31759,33839,33839,33839,33839,33807,33808,35986,27500,21129,23274,21194,23307,21161,21161,19081,10695,4421,21325,23568,42259,23340,40212,27501,35953,52825,50745,48631,46486,38099,40212,38066,38066,35985,29712,27631,23406,21325,19147,21260,40244,61244,46451,52824,48664,27599,29614,29613,31726,31694,29581,29613,31693,31726,29613,31694,29613,27532,31693,29581,29613,27500,25420,23275,17033,17066,35985,35855,25355,25486,42391,46518,17001,31597,204},
{17461,19541,19541,19541,19541,19541,19573,19541,34136,55004,55003,50778,46650,50778,50810,50778,50778,50810,52890,50810,50810,50810,50778,48698,48665,46617,48697,52891,54971,54971,54971,54971,50810,46584,42358,40278,40246,38197,38165,38133,36084,34004,34004,34004,38165,46617,54971,54971,52891,52890,50810,48730,46617,44504,42423,42391,44472,48697,50778,48698,48697,48730,48730,48697,46617,44537,42457,44537,42522,40474,44635,59164,59197,61277,61277,61245,55003,50810,44537,38264,38264,40344,40344,46649,46650,44537,40376,40376,44505,42456,46617,46617,44537,36183,42457,44569,36085,19344,15183,13071,15183,31859,38067,21358,21358,27665,42260,42228,35921,25487,17198,19246,33841,25487,31761,38034,35823,14986,19212,19180,19213,17132,23405,23308,23341,31727,40146,25388,23308,29516,10663,228,2341,29516,33774,29679,35985,38066,36018,40245,23405,14954,14922,29549,19082,4421,19147,12873,12873,14954,10760,10793,12906,10793,10760,14954,10760,17001,17034,21194,8614,6566,8646,40146,59132,35953,31727,33840,33840,33840,33839,33807,29613,33840,27500,21227,23274,21194,23307,23274,23274,19114,17001,4454,17132,19439,31760,19114,29646,33840,35953,48631,50712,44438,46519,40244,35986,29680,25486,25454,31792,31824,31792,31760,29679,27598,38131,61244,46452,52792,27599,17067,31694,31661,31726,31693,29581,31694,29613,33806,29645,31693,31694,29580,31694,29581,29581,27533,27468,25387,19146,19146,44470,35952,42226,6534,8648,23405,10728,25388,206},
{17461,19541,19541,19541,19541,19541,19541,21622,44570,55004,52891,48730,50810,50843,50778,48730,52891,55003,54971,54971,52923,52890,50810,48730,48697,48665,52890,55003,54971,54971,57051,54971,50778,46552,42358,40278,40246,38197,38165,38133,36085,36084,34004,34004,38165,48697,55003,54971,52890,52890,50778,48697,46552,42423,42391,42423,46585,50778,50778,50778,50778,50778,48698,46617,46617,44537,44536,44570,40474,40474,48795,59197,59197,61277,59197,59164,50810,46650,42457,40344,38296,40344,42424,52891,50810,44537,42456,46617,46617,44537,46617,46617,42456,36183,40376,44569,38198,21424,17264,13103,15183,29746,42261,25552,17197,25552,38067,44308,33841,31760,12972,17197,33873,27599,29680,31760,37968,19179,17164,27502,19180,12938,27599,33808,21195,33840,44339,33743,23275,23308,6534,293,4454,31662,50646,54937,44404,19180,23374,44438,42292,36018,33840,31695,19114,4389,19179,17067,14986,14986,12873,12873,12873,12873,12841,17066,10793,19147,19114,23307,12840,6566,33839,46518,61277,44340,31759,33840,33840,33840,33840,37935,25354,29646,25420,25485,25387,19081,23274,23242,23242,19114,10662,4422,10728,13165,21293,10695,27501,42292,42292,52825,38066,21293,38099,25486,29581,8615,4454,12841,46518,54905,52857,52824,50711,40179,38099,61277,57017,56985,52824,46518,27533,29580,27533,29613,27468,27533,27533,25420,29613,25387,29613,23307,25420,29581,25388,29581,23275,25420,21194,17033,42324,35920,46485,10662,10695,21260,23308,29581,115},
{19541,19541,19541,19541,19541,19573,19573,19573,34136,50810,48730,48730,52891,52923,50811,52891,52923,54971,54971,57084,57051,52923,52890,50810,48730,52891,57084,57084,57084,57084,57084,54971,50777,44471,40310,40278,40246,38197,38165,38165,38165,36084,34004,34004,38198,48697,55003,54971,52891,52890,50778,48665,46552,44504,42391,44504,50778,50810,50810,50810,50810,50778,46649,46617,46617,46617,44569,44570,42522,40474,46715,61277,59197,59197,59197,52923,46650,46617,42457,42456,40344,40344,46617,57084,50810,44569,46617,46649,46617,44537,44569,44537,40376,36215,42457,44537,46584,23505,19344,15183,13103,19344,36085,33906,19245,25520,33906,44340,27600,27567,4651,8844,25519,25487,31793,31760,46290,12938,23438,33808,29646,8778,27566,31662,23308,23308,35888,35953,21260,23243,23210,6534,4454,14986,31793,52694,46485,17034,10794,38034,27501,29548,27468,29549,19114,19114,27533,27533,29581,29646,31694,31726,31726,33774,33774,33806,27468,21227,21227,23307,17001,12775,35887,42293,63422,42259,29614,33840,33839,33807,33807,33774,25322,29646,25388,23340,23307,23307,25387,25354,25387,21226,12775,2374,4454,12840,12841,14888,25453,27599,38066,38099,31760,19179,29647,44274,40048,25420,19179,17099,44405,52824,52825,50711,48631,44405,38098,50744,61276,42226,38033,17067,25421,29580,25387,29613,27500,27500,27533,23307,25388,23307,21227,23339,29646,27533,17033,19114,23372,25485,21227,19179,38131,40114,42259,19113,19082,21227,27501,31694,121},
{19541,19541,19541,19541,19541,19573,19573,23702,44570,52891,52891,54971,55003,52923,50811,52891,55003,57052,57084,59164,57116,55003,54971,52891,52890,57084,59164,57116,57116,57084,55003,54971,48697,44471,40310,40278,40246,38197,38197,38165,36117,36084,34004,34004,38230,48730,54971,54971,54971,52890,50778,48665,46585,46584,44504,46585,50810,52890,52890,52890,52858,48698,48698,50778,48698,48698,46618,44570,44570,40442,46715,61309,61277,59197,55003,48730,46650,44537,40376,40376,40376,40376,48730,59164,52890,46649,46649,44537,44537,44569,46617,44537,40344,36215,42457,42489,48730,34037,21424,15183,13103,15183,33972,42228,23439,23439,35986,42260,31696,25487,19213,13004,29745,29648,33841,44307,52660,19244,10858,40179,31792,12939,29647,31629,23308,21228,29614,27565,19114,23243,21097,17001,31726,31694,35855,50418,48566,21260,2407,21293,25355,29515,31661,38001,33872,40113,38000,40080,40081,42193,42193,42161,40081,40081,40080,40081,38033,25387,29580,29548,29581,29548,37934,36019,63423,46485,29614,33840,33839,33839,33839,29581,25322,35920,25420,21227,29580,27435,23275,27467,29580,19146,14888,4356,4356,16838,16936,19082,21195,6502,31792,42324,29581,27534,35953,44274,42129,29646,31825,21325,42325,42292,50712,50712,50744,48631,46453,44405,61276,54871,48532,27501,35920,29613,29613,31726,27500,19081,25420,17001,14921,21194,14921,23307,25453,25420,21194,21226,23339,23372,23307,19113,33905,42259,40179,23275,21194,27534,25388,38065,209},
{19541,19541,19541,19541,19541,19541,23734,48730,57084,57084,55003,57084,57084,55003,52891,50811,54971,54971,55004,59164,59164,57116,57084,54971,54971,57051,57116,57084,57116,57084,54971,50778,46552,42391,42358,40278,40278,40245,38197,38165,38165,36085,36052,36052,40310,50778,54971,54971,54971,52858,50778,48697,46585,44472,42423,44536,50810,52891,54938,52891,50810,46650,52891,54971,52891,50810,46682,46682,46650,42522,48795,61309,52923,50811,46618,50810,50810,44537,40376,40376,44569,46649,44537,52923,50810,48730,46617,42456,44537,48730,48698,46617,40376,38296,42457,46617,48698,36151,25618,19344,13103,13071,29778,35954,21359,25584,44372,42227,35889,31761,29647,21326,27632,40114,33873,42195,44307,21260,8745,23406,27566,29679,38066,27436,14987,19147,29614,40113,23340,25388,23210,21163,29679,33840,42162,44177,46420,21292,4487,31760,33774,29647,35986,35986,27598,38033,38000,38000,38000,40081,40081,40113,40113,40080,40048,40146,42259,19146,31661,29580,29613,25420,33741,31825,61342,50646,27566,33840,33839,33839,31759,38001,52758,48565,14856,10727,29580,29483,25354,27500,29613,21194,16968,6470,4324,14790,21162,10728,19147,10728,29679,40211,33872,25486,33775,44242,40049,29646,36018,25486,40212,46518,50712,52857,52824,50712,48598,42259,54970,56985,50645,29646,38000,31693,29580,31726,29613,31693,29613,31726,31726,29613,31726,29613,29613,31693,29613,31661,27500,29580,27468,25355,27534,38066,38033,27501,10695,29679,44404,54905,208},
{19541,19541,19541,19541,19541,19573,36216,55004,57084,57084,55003,57084,57116,57084,52923,52891,52891,52891,52923,59164,59197,59197,59165,57084,55003,57084,57084,57084,57084,55003,50778,46584,44471,42391,42359,40310,40278,40246,40245,38165,38165,36085,36052,36084,40311,50810,54971,55003,54971,52890,50810,48697,46584,42423,42423,44536,52858,54971,54971,52890,48730,44570,50843,57084,57084,52891,48730,50811,48730,44570,44635,57116,50843,46650,50810,52923,50810,44537,40376,42456,50810,50810,44537,52891,50810,46617,40376,42456,46649,52890,50778,48730,42456,40344,46617,48730,44537,32022,23537,19312,13071,10990,23537,35986,25552,31793,33874,33874,35953,38034,31761,25519,27632,40082,35954,31728,33808,40016,8745,42194,48467,33872,35986,25420,4552,23308,33743,21260,6600,31662,27371,16937,6600,4519,25420,42128,48533,25453,2374,25486,42259,21260,23341,23406,33840,40113,40113,40113,42194,42227,42259,44339,44339,44339,44339,46485,44405,27533,33806,33807,33774,35887,31693,33840,61310,52792,27533,33839,33807,33807,33807,33807,33840,35953,19016,6534,27468,25387,27500,27468,29613,23274,16968,4422,2309,12677,25388,10695,14921,8647,31792,40179,27533,19147,27469,46323,40081,31694,29645,21226,33905,54938,52857,52857,52825,50712,44405,50711,52857,61276,61244,38001,35920,33807,29580,31726,29613,31694,29581,31693,29645,27500,31694,23339,27533,25388,27500,25420,23307,27500,19114,25387,12840,29614,42161,40113,31759,48598,56985,44307,167},
{19541,19541,19541,19573,19541,23702,52923,57084,55004,52923,55004,57116,59164,57084,54971,52891,52923,52891,54971,57116,59197,59229,59229,59197,59164,57116,57116,57116,59164,57051,50778,46552,44472,42391,42359,40310,40278,40278,40246,38197,38165,36085,36052,36084,40311,50810,55003,57051,55003,54971,52858,50745,46585,44504,44472,46617,54971,57084,55003,52891,46650,46650,50811,57084,59164,54971,48730,48730,48730,44602,42555,50843,46618,44537,46650,46650,46650,42456,40376,44569,50810,50778,48698,55003,48698,40376,40376,44537,50810,50810,48730,50778,44537,40376,48730,48730,42424,32022,27731,17231,13071,11023,19344,36019,33906,38099,31761,27600,33873,38002,31728,17165,19278,31760,33841,31695,33840,38033,6697,42227,33807,27631,40211,33775,12874,25389,21195,10793,8648,19082,25323,23242,6567,4519,35822,42063,48533,21292,2407,4487,15019,23373,19180,19147,40146,48599,48599,44438,44438,44438,44405,44405,44373,44373,44373,46518,48631,31759,38065,40146,40080,46386,46386,52758,63357,57018,31727,33807,33807,33807,33807,31759,31726,33840,27468,6502,19081,27435,27500,29613,27533,21194,16968,4421,4356,12645,31564,14824,19147,21260,35953,42226,38065,31792,27469,48403,44242,29613,23339,21194,31792,52825,52824,52857,52825,48631,42292,57051,52857,61276,61309,48565,35920,33774,27467,31693,21227,29581,23307,31726,29581,23275,27533,19114,25387,23307,25387,27467,23274,27468,27467,25387,23274,35920,48565,57083,61277,61244,46518,33840,104},
{19541,19541,19541,19541,19541,25815,50843,57084,55003,50811,52923,57116,57116,55003,54971,52891,52891,52891,52891,55003,57116,59197,59197,59164,57084,57084,59196,59196,59197,57116,52858,46552,44471,42391,42359,40310,40278,40278,40278,38197,38165,36085,36084,36085,40310,48697,54971,57051,57051,54971,52890,50778,46617,44504,44504,46617,55003,59164,57084,52923,46650,44570,50810,55003,57084,57084,52891,46650,44602,42522,44635,48763,48730,44569,44537,46617,44569,42424,42457,46617,48698,50810,55004,54971,42456,40376,40376,44537,52890,50810,48730,50810,46617,40376,48730,48730,38296,32022,29909,17264,11023,11023,19344,29745,23472,33939,31825,25519,25551,38034,35986,23406,15084,29680,33873,33873,23373,31760,10891,21293,27469,27631,36018,33840,33808,29614,23308,25420,10792,25356,33677,31596,21162,8615,31596,44176,46486,29744,6632,8713,25421,21260,19147,19180,42292,44405,44405,44340,42292,42292,40179,36018,38066,31760,31727,35921,48598,35953,38066,40146,50678,59032,56919,54838,54970,59163,35920,33807,33840,33840,33839,31759,31727,29679,23275,8549,19114,29547,29580,25420,19114,19081,16936,8614,4454,14823,23112,18952,12906,31825,44339,42194,40146,38099,27501,46290,46322,33806,25452,23339,33872,46550,44405,54937,52825,50712,44373,57051,54937,59164,61309,54872,44339,50711,50712,52825,54937,54970,57018,57051,54872,37934,35854,37902,31628,37966,35821,37901,33740,33708,37934,31660,29547,33873,38099,38099,50712,40179,25453,19114,53},
{19541,19541,19541,19541,19573,44570,59164,57084,55003,52891,52891,57084,57084,55003,54971,52891,52891,52891,52891,52891,57084,57116,57084,54971,52891,55004,61277,59197,59197,59164,54971,46585,44472,42391,42359,42358,40310,40278,40278,38197,38165,36085,36084,36085,38230,46585,55003,57084,57052,55003,54971,50778,46617,46585,46584,46617,52891,57084,57084,54971,46650,42490,46682,55003,55003,54971,52891,50810,44602,42554,50843,52891,52891,46650,46617,44569,44569,42457,40376,40376,44537,48698,52890,46617,42424,44537,42456,46617,52891,50810,50810,50810,44537,42457,48698,50778,38263,32022,31990,21425,11022,11022,17232,35987,25552,23504,27633,27600,21359,29680,38034,31760,21294,29713,33841,25486,10826,36019,29680,17035,35855,25486,17164,17100,29679,33841,35921,33807,23308,29549,50449,42096,27371,12776,33709,42128,42325,40244,14954,19115,29516,23307,17002,14954,27599,29679,31727,33840,33840,33807,25388,12874,23373,16936,21097,23275,48599,38033,38098,42292,38000,44339,40080,44338,36052,59164,48566,40146,38099,33905,23373,17099,14986,21162,31596,31628,29547,27467,21194,8615,14953,29646,27566,17099,8811,10728,20999,23209,10695,14922,40179,40146,38033,40179,29646,44210,48403,33774,31759,40277,46518,48598,42292,54937,52857,50744,46518,54970,54938,59131,61277,59196,59164,61309,57084,54971,52889,54937,50712,46486,59098,44240,33774,31628,29547,27467,35789,25355,33773,27435,29547,27434,27468,46551,48663,50679,35887,19049,25355,31628,119},
{19541,19541,19541,19541,21654,50843,59197,59164,57084,52923,54971,57116,57084,55003,54971,52923,52891,52923,52891,52891,54971,57084,55003,50810,48730,52891,59197,59197,59197,59197,55003,48665,44472,44439,42391,42359,42358,40278,40278,40246,38165,36117,36084,36085,38198,46585,57052,57084,57084,57084,54971,50810,48665,46617,46617,48665,50778,52891,57084,57084,50810,44570,46650,54971,52923,52891,52923,52891,48762,50843,55003,52923,50843,48730,46650,46649,44537,40376,38263,38263,40376,44537,44537,42424,42456,44537,44537,46649,48730,46617,46649,46649,44537,42457,46650,46650,38263,32022,31990,19377,11022,11022,15183,33939,31761,31793,27600,23439,23439,31760,33873,33808,23407,23439,29680,27599,14987,25519,38066,25454,27566,17100,6633,27598,23373,21293,31792,35921,31662,37903,52563,31597,31564,16937,40048,44209,42325,42325,31824,33840,29516,33840,38066,38099,44438,27566,31694,35920,33839,31726,21227,10793,19180,19049,21097,23242,46486,29647,29613,40113,50613,56919,52725,44273,35953,29745,21325,17066,12906,12873,10793,10760,8679,23308,25322,21129,23242,25354,14888,10695,21227,33807,33807,27501,21292,19081,25290,27435,14920,12808,35920,42227,40146,40179,31759,42129,46322,27500,35985,46616,48631,50711,48631,52857,52857,50744,48631,54970,57083,57083,57018,59196,61277,61309,59164,54937,50744,46452,46420,50614,57018,46353,29581,27500,27500,23243,29581,21195,27468,21227,23275,21162,23308,27502,31727,29581,21162,25354,33708,40047,218},
{19541,19541,19541,19541,23734,50811,59164,59164,57084,54971,55004,59164,57084,57052,55003,54971,54971,54971,52891,52923,55003,57052,52891,50810,50778,50810,57052,57084,59197,59164,55003,48697,46552,44471,42391,42359,42358,40310,40278,40278,38197,38165,36085,36085,38230,46617,57052,57084,57116,57084,55003,52858,48697,48665,48697,48665,48730,50810,55003,57084,52923,46650,48730,52923,52923,52891,48762,46682,52923,59164,59197,55003,52923,50810,50778,46650,40376,38263,38295,40376,42456,40376,40376,42456,42424,42424,44537,44537,44537,44537,46617,48698,44569,42457,44537,44537,36151,34102,29910,17264,11022,11023,13103,36019,29713,29745,23471,25552,25519,27632,29680,29648,25487,21391,29712,29713,8746,6698,31858,40180,23309,29679,29712,29743,27566,23308,31760,37968,37936,40049,42096,33677,31564,12744,27599,52628,50549,46486,44405,44405,35888,46552,52924,52891,40245,31727,38032,38001,35920,29646,21227,17066,17099,16969,21161,23274,46485,27533,27533,35887,40146,42194,42259,35952,31759,23340,21259,21259,23339,23339,25420,27468,27500,29613,31693,33741,33773,33741,33741,29580,27500,29613,27468,27468,25387,23275,21227,19082,14856,10695,31694,35985,42226,40147,35953,40049,44242,31694,27599,36051,48631,56985,56985,59131,54904,59098,57050,59098,61244,59033,59098,57051,61277,61277,61277,59163,54938,50744,50744,57018,59131,52791,33839,25420,25356,25388,23275,25355,21194,21194,21130,21161,33806,42161,38000,37967,50547,54772,56820,56853,206},
{19541,19541,19541,19541,23702,44570,57084,59164,57084,57084,57116,59197,59164,57084,55003,55003,55003,55003,55003,57084,57084,57084,52891,52890,50810,50778,52891,55003,59197,59197,57051,50777,46585,44504,42391,42391,42358,42358,40278,40278,38197,38165,36085,36117,38230,48697,57052,57116,57084,57084,54971,50810,50778,48698,48697,48665,48698,50778,52923,57051,54971,52891,52923,52891,52923,52891,48730,46682,55004,59197,59197,55003,52923,52891,50843,42457,38263,38263,42456,44537,44505,42456,42456,42424,42424,42424,42457,44537,44537,44537,46617,48730,44569,42457,42457,42489,34103,34103,31990,19344,11022,11022,11023,36052,27600,25520,23471,25551,25520,27600,23407,25519,25519,10924,25455,29713,17132,17099,38099,42260,19147,31760,42293,33937,38033,27502,27534,42194,27501,14953,21162,42064,33645,6534,23406,48435,52629,54872,52759,52759,54872,48502,46389,38067,25453,29548,25355,29647,44405,31760,40147,38066,19114,21128,21161,23274,48599,29614,25355,31661,21129,19016,33774,40145,25388,23275,23307,23275,23275,21227,19082,27468,21194,12808,14888,10695,17034,12808,19017,10695,4389,12808,4421,8582,6534,6470,8582,4389,6437,4357,23275,27566,44307,48566,46453,44242,48500,50711,29711,38099,59098,57017,61211,56952,56952,57017,54839,56985,50645,52792,48500,52824,61277,61277,59164,57051,57050,50744,54904,57018,44340,27501,25355,25387,25387,25355,25387,25323,25355,25355,31628,46420,61145,52726,56985,56854,50579,54740,50515,44144,106},
{19541,19541,19573,19541,29943,52923,59164,59197,59197,59197,59197,59229,59197,59164,57084,57084,57084,57084,57084,57116,59164,57084,52891,52890,52858,50810,52891,57084,59197,59197,57051,50810,48697,44504,44439,42391,42358,42358,40278,40278,38197,38165,36117,36117,40278,48697,55003,57116,57084,57051,54971,50810,50810,50778,48697,48697,48697,48698,52891,55003,52923,55003,55004,52923,52923,52923,48730,48763,57084,59164,55003,55003,55003,50810,46617,40376,38295,40344,46617,46649,46617,44537,42456,42456,42456,42457,44505,44537,44569,44537,44569,48730,44569,42457,44537,44569,36183,34102,32022,21457,11022,11022,8942,29778,27633,25552,25519,21359,23407,25519,31729,31793,25487,21326,17165,23407,21326,35920,35954,35856,37936,35953,38131,29777,35921,29614,27534,35986,42259,31726,27371,25323,21195,6535,25421,42096,44241,56919,54806,52725,50580,37870,35692,33710,25388,31596,29516,33808,50777,42260,44406,42293,21259,27466,25322,21129,44406,31727,27435,33774,23242,21129,31628,29647,14920,6501,10662,8582,16968,10695,6469,19082,12808,6469,8582,4389,12840,12775,10662,8550,6437,10695,8615,19114,10662,12775,12808,10695,14856,10597,21096,25388,48566,48632,50613,46420,40147,17035,8680,29646,40113,38000,40081,35886,37968,35886,37967,40047,40047,40015,35821,50711,61276,54970,46518,52792,54905,54905,63324,52759,38001,46419,48532,46452,48532,54871,54871,52692,52693,50547,48435,40081,33807,27436,19017,16936,14888,29484,27338,18983,49},
{19541,19541,19541,19541,40409,59164,59197,59197,59197,59229,59229,59229,59197,59164,59164,57116,57084,57084,55003,55003,55003,54971,52891,52858,52923,55003,57084,57084,59164,59164,55003,52890,50777,46552,44439,42391,42358,40310,40278,40278,38197,38165,36117,38165,42391,50778,54971,57084,57084,57051,54971,52890,52890,50810,50778,48697,48665,48665,50810,52923,52923,54971,57084,57084,55003,52891,44602,46683,50843,46618,44537,52891,52923,44537,42457,42456,40376,42424,48698,50810,50810,46649,44537,42488,46617,52891,50778,48697,46617,44537,44569,46650,44569,42457,46650,50810,38263,32022,34102,21489,13071,11022,8942,25618,29713,23440,29713,21359,25519,27600,29680,29713,29680,23407,15053,21326,25486,21293,25486,33840,37969,46453,38033,21357,33873,23308,31630,27502,31727,27501,33645,25355,10760,6567,23307,40016,48566,50679,46322,48337,25355,31564,27306,42031,44405,44339,35822,40179,46519,35921,29647,27566,14921,14888,23210,21129,42260,33840,21162,35854,23274,19081,29580,25420,17001,10630,12775,8550,14855,10662,6469,10662,6469,8517,6469,6405,8614,8582,8582,6502,18951,21032,19049,33840,14856,21228,17034,21260,40211,35887,29581,42260,48566,29647,44210,46355,35855,8484,163,25387,35886,35886,37934,37966,37967,40047,40079,42159,44208,44240,40079,46485,59131,48566,52759,59065,54905,61244,61211,61243,61243,61210,61178,63323,63291,50646,44307,35855,23242,14823,12743,10597,10597,6404,8517,10662,12743,12743,6437,14823,40},
{19541,19541,19541,21622,48730,59164,59197,61277,59229,59229,59229,59197,59197,59197,59164,59164,57116,57084,55003,57052,55003,52923,52891,52923,55003,59164,59164,57084,59164,59164,57051,52890,50778,46584,44471,42391,42358,42358,40278,40278,40245,38165,38165,38198,42423,48697,52923,57051,57084,55003,52891,52890,52890,50810,50778,48697,46617,46617,50810,52891,54971,52891,55003,57084,55003,50811,42522,46650,46650,46649,46650,50810,46617,44569,44537,40376,40344,44537,50810,52891,52891,48730,46617,46617,48698,52891,50810,52891,50810,46649,46617,46650,44569,44537,52890,54971,40343,31990,34102,25650,13103,10990,8942,25585,38067,23439,35986,27600,25520,27600,27600,31761,31761,27568,19246,23407,40147,29647,29680,35953,27502,40147,31727,23470,31825,25388,35726,33807,27436,23275,31564,31662,12873,6567,29614,44209,37936,38001,39951,42129,17034,29483,29451,29549,31728,33873,44340,50679,38066,33840,29580,25355,25355,23274,23308,27566,46486,38033,19113,25355,17000,10727,16969,14921,8582,4389,4421,4389,4389,4357,2309,4357,4389,4389,4389,4389,4357,4389,4389,4389,6502,6470,4454,12873,4389,2309,2309,12874,46551,44373,35986,31760,42227,19147,40081,48468,37935,12775,21227,35887,37934,37967,37967,37999,40047,40047,40047,40079,42160,42160,40079,42226,61244,59065,54871,61211,63356,59032,56984,63356,63258,54838,61178,61178,42161,27403,19048,14790,10630,8582,8549,6469,8549,10662,8615,12775,19049,8550,2276,12742,59},
{19541,19541,19541,21622,46650,59164,59197,61277,61277,59197,59197,59197,59197,59197,59197,59164,57084,57084,59164,59164,54971,52923,52923,52923,55003,59164,59197,59197,59197,59164,57051,54939,50778,46584,44439,42391,42358,42358,40278,40278,40246,40246,38197,40278,46617,52890,57084,57084,57084,55003,54971,52890,52890,50810,48730,48665,46617,48697,50811,52923,52891,48730,48730,52923,52923,48730,46650,50811,55003,52923,50810,50810,46617,44569,42456,40376,40376,44537,50810,52923,54971,52890,46649,50810,50810,50842,50810,54971,52923,48730,46617,48698,44537,44569,52891,50810,38263,31990,34102,25683,15151,8942,8942,21425,38100,27633,36019,27632,27600,27632,27600,29680,33841,33873,17165,17133,36020,46518,29647,33872,33775,40146,33873,25518,31792,27534,40049,35921,33807,14954,31597,27404,25356,21097,25388,33775,38034,44307,50418,44274,21162,31596,37935,23373,25453,23340,42292,56985,52759,52726,46419,48565,48532,48565,46518,38066,44406,42227,25387,27468,23307,8550,196,2244,2276,2309,2309,2309,2309,2309,2309,2309,4389,4389,4389,4389,4389,4389,4389,4389,4389,4389,4389,2309,4389,4389,4389,17034,44438,44373,38066,29646,44404,38034,37968,52596,35887,23275,31759,35919,35886,37934,37967,37966,37999,37967,40047,40079,42160,42192,42192,44306,54904,59097,59097,61243,59097,59065,59065,48500,46419,40081,33743,27436,16968,10695,8550,8550,6501,4388,4356,6469,8615,10695,10662,23242,33741,12743,14888,29547,139},
{19541,19541,19541,21622,44570,57084,57116,59197,59197,59197,59197,59197,59229,59197,59164,57084,55003,57084,59197,57116,54971,52923,52923,57084,57116,59197,59229,61277,59197,59164,57052,52890,48697,46552,44439,42391,42358,40310,40278,40278,40278,40278,38198,40311,48698,55003,57116,57116,57084,57051,54971,54939,52890,50810,48697,46617,46617,48698,48730,48763,48730,44602,42522,48730,50811,50811,52923,55036,59164,55004,54971,50843,48698,44569,44537,44537,44504,46617,52891,54971,57052,50810,46617,48730,50810,52923,54971,55003,54971,50810,44569,44569,42457,44537,50810,48730,38231,29910,32022,25683,15151,10990,8942,17296,38067,23440,33874,25519,29680,29648,29713,29680,33906,29681,12972,17133,27600,29615,29615,40179,35921,29615,29615,25551,25519,31760,44341,33775,38001,27534,27404,29517,31629,33612,29549,37969,37969,44210,54676,46290,27403,31531,29517,25453,27533,31727,40147,48598,56952,54839,56952,52791,46420,40212,40278,46518,48632,42259,23274,29581,25387,8582,2244,2276,2276,2309,2309,4389,4357,2309,2309,2309,2309,4389,4389,4389,4357,4389,4389,4389,4389,4389,4389,4389,4389,4389,4389,10728,42293,42324,40147,31727,40146,31760,33775,50483,40081,35920,44339,50580,46386,52693,50579,52725,54805,52692,56951,54773,59032,54838,56952,54806,54838,56951,54773,54806,54773,52660,37869,25289,21096,18983,16903,12743,8550,6502,8550,6437,4356,4324,4389,4422,6469,4324,16934,12742,16969,27500,31661,35820,150},
{19541,19541,19541,36216,50843,57084,57116,57084,57084,57116,59197,59197,59197,59197,59164,57084,57051,55003,57084,57084,54971,55003,57052,59164,59197,59197,59197,59229,59197,59197,55003,50810,48665,46584,44471,42391,42359,40310,40278,40278,40278,40278,40278,40343,50778,57084,59164,57116,57084,57052,55003,54971,52890,50810,48697,48665,46617,46617,44570,44570,44602,44570,42522,48763,50811,50811,52923,57116,59197,59164,57084,54971,50810,48730,48697,46617,46617,48698,52923,55003,54971,48698,46649,46650,52891,52923,55003,55003,54971,52890,44505,42457,42457,44569,50810,50778,38263,31990,32022,29844,17231,11022,10990,13135,35987,27632,33906,27632,27600,31793,31826,31858,31761,29680,12972,23440,38034,40049,23406,31858,21326,31728,31695,31824,21325,23439,44308,37903,42227,35953,27501,23308,31629,48305,44209,40082,48337,42195,54872,37935,29451,33612,33742,44373,48598,40081,23339,42259,52726,50613,44307,29614,25420,23307,23340,19180,21326,44372,21194,27468,23275,8582,2276,2276,2276,2308,2309,2309,2309,2276,2309,2309,2309,2309,4357,4357,4357,4357,4389,4389,4389,4389,4389,4389,4389,4389,4389,4389,38099,48598,46518,38033,35920,23340,29614,46420,44340,48566,56919,56918,56919,56951,56951,59032,56951,56951,56919,59032,56886,56919,52726,56919,52692,54773,54773,54773,52627,31563,23208,21063,18983,16903,12743,12743,16903,16936,16936,16903,6437,8582,6534,4389,4356,4324,6469,10662,35887,50646,40080,35820,145},
{19541,19541,21654,46650,55004,57084,57084,55003,55003,57084,57084,59197,59197,59197,59164,57116,55003,54971,54971,52891,52891,57052,59164,59164,59197,59197,59197,59229,61277,59164,55003,50778,48665,46584,44472,42391,42358,40310,40278,40310,40278,40278,40278,44472,52923,59164,59164,59164,59164,57084,55003,54971,52890,50810,48697,48697,46617,46617,42522,42522,46682,46682,46682,50811,50843,50811,55003,57116,59229,59197,57116,57084,54971,50842,50778,48697,48698,48698,50811,52923,48730,46649,48698,44569,48698,50810,52891,52923,54971,50810,42456,42424,42457,44569,50810,48730,40344,31990,32022,31990,21425,11023,11022,13103,33907,31826,33906,23471,25552,31826,31826,31761,35921,29648,6763,15053,42293,50679,19278,25552,12939,17036,25486,27566,27631,23373,37969,37936,42227,35920,10792,23340,44210,37903,23243,27469,52596,52727,35921,46387,23210,25355,29582,31759,35985,40211,42258,50646,46453,46420,46419,46419,46452,46419,40080,29580,25454,46485,25355,29548,25420,12776,2244,2276,2276,4357,6470,6469,8582,8582,4389,4389,12808,21195,17002,19114,21227,14921,4357,4389,4389,4389,4389,4389,4389,4389,4389,4389,25552,44440,54971,46485,44307,38001,44307,42259,42194,59032,54806,59032,56919,59032,58999,56951,59032,56886,59032,56886,61080,54773,58967,54773,54773,52660,52660,50580,44241,35822,37935,42128,37902,40048,44208,46354,48434,50482,54741,52596,16969,6469,4389,10663,14921,21161,19081,19048,33839,50678,40048,33707,143},
{19541,19541,19541,29975,46650,50843,50843,52923,52923,55003,57084,59164,59164,59164,57116,57084,54971,52891,52891,52858,50810,57084,59164,59197,59197,59197,59197,59197,59197,59164,54971,50778,48665,46584,44472,42391,42359,42391,42358,42358,40310,40278,42391,48697,57084,59197,59197,59197,59197,57116,57051,54971,52890,50810,48697,48665,46617,46617,42490,46650,48763,50843,50811,52923,54971,52891,52891,57116,61277,61277,59197,57116,57084,52923,50810,50810,50810,48730,50810,50810,46649,44569,44537,44537,46649,46649,48698,52923,54971,50810,44537,42457,46617,44569,44569,46617,40376,34070,32022,29942,19377,11022,11023,11023,29778,38067,31826,25519,23439,29745,33874,31728,33841,33841,19213,15053,29713,35921,25389,21196,19148,25454,25421,19180,40212,33808,35921,31695,25454,31727,12873,19147,37936,16969,6567,31728,46388,48402,44144,46257,27468,19114,14954,40179,33872,38098,46452,46453,44339,44339,44307,42258,44307,42227,31661,37935,33839,44405,29549,31629,25420,16937,2244,2276,2244,14954,29646,25355,27533,27567,23308,21228,19180,31792,25486,27566,25453,19115,4389,4421,4422,4421,4421,4389,4389,4421,4421,4421,4422,4423,36019,50646,54773,54773,59032,56918,59031,54838,54839,54839,52726,52726,46453,54872,48533,54905,59098,44307,33710,29484,29484,23211,29516,16937,14889,18951,14790,10630,19082,21162,27436,48468,50548,50548,50548,52628,56822,52628,19016,17001,33839,27534,27533,21194,19081,17000,29614,48533,42193,29547,144},
{19541,19541,19541,19541,21654,36216,50778,52891,50810,50843,55003,57084,59164,59164,57084,55003,54971,52891,50810,50810,50810,55004,57084,57116,59164,59197,59229,59197,59197,57084,52890,50778,48697,46584,44471,42391,42391,42359,42359,42359,42359,40311,42424,52891,59197,59197,59197,59197,59164,57084,57051,54971,52890,50810,48698,48697,46617,46617,46650,44570,40442,48763,54971,57084,57051,52891,50843,57116,61277,61277,59229,59197,57116,55003,54971,54971,52923,50778,48730,48730,44537,42456,42456,42457,46617,46649,50810,55003,52923,50810,46617,44569,48698,44537,44537,46617,42456,34070,32022,27829,17263,11023,11023,11022,25585,38067,29681,23471,25520,31793,31760,27600,31761,31760,23406,23407,25519,33840,27502,21196,21228,38034,42227,33873,40244,33840,25389,37968,40113,35953,25421,31629,14889,196,10760,42293,44274,29451,46191,41966,27468,21194,4486,12873,29679,38032,50645,44339,40113,44306,44306,44339,46419,44242,35822,37967,33807,44405,31694,31629,23274,16969,2244,2276,2244,8648,17035,12808,14921,10728,4422,2309,6502,12809,6535,6502,4422,4389,4389,4389,4389,4389,4389,4389,4389,4421,4389,4389,4421,4389,10794,38067,35953,29679,29679,40179,44339,25387,27468,33774,35821,29515,17034,50777,38033,42358,59164,35952,16838,18853,20998,14758,25290,12677,10630,18756,18951,10565,14824,19049,25355,48436,50516,52628,52596,50516,48467,46387,33807,44372,46452,12808,29647,21194,8517,16968,27501,48565,44307,31628,136},
{19541,19541,19541,19541,19541,27895,44537,44537,42457,46617,50810,54971,57084,57084,55003,54971,52891,50810,50778,50810,50811,55003,57084,59164,59164,59197,59197,59197,59164,57051,52890,50778,48697,46552,42391,42391,42359,42359,42391,42391,42391,42359,44536,55003,59164,59197,61277,59196,57084,57084,54971,54939,52891,50810,48698,48697,46617,44569,44570,40442,38394,46682,54971,55003,50843,48730,48763,57084,59197,59229,59229,61277,59197,57084,57084,57084,57051,52890,48730,46649,44569,42457,42457,46617,48730,50810,52891,57051,52923,50810,48730,46617,46617,44569,46617,46650,46617,32022,32022,27829,15183,11023,11022,8942,17264,38100,29680,27600,31825,31794,33906,25487,29680,31793,25487,21294,19213,33905,27502,21228,19180,27599,27567,35921,42292,35920,29615,42194,46387,38034,27534,35823,27403,4487,12873,44340,44209,29418,39885,41966,25355,23242,14920,12905,29679,35952,52791,48565,48565,48598,50646,46517,40114,42161,37934,37935,33807,46518,23308,27500,33774,19081,2244,2276,2276,2276,2309,2309,2309,2308,2309,4389,2309,4389,4357,4389,4389,4389,4421,4389,4389,4389,4389,4389,4389,4389,4389,4421,6470,4422,4389,23275,25387,21194,21227,33840,46484,21161,23210,33742,35853,25321,10728,48665,44372,40212,61245,44307,14823,18885,18919,16805,8484,12677,10662,20773,18887,14791,12743,21162,23275,44275,50516,50548,46387,46420,46485,40146,44340,46518,46453,23307,29647,21227,6436,14855,21259,46485,46420,33741,134},
{19541,19541,19541,19541,19541,34136,46650,46617,46617,46617,48698,50810,54971,55003,54971,52923,50810,48730,50778,50810,50843,55003,55003,55003,57084,59164,59197,59197,57116,54971,52890,50778,48665,44504,42391,42391,42391,42358,42391,42423,42391,42391,46585,52923,59164,59197,61277,57116,54971,52890,54939,54939,52891,50810,48730,48665,46617,44569,38394,40442,42522,44602,50811,50843,48730,46650,44602,50876,59164,59229,61277,61277,61277,59197,59197,59164,57084,54971,50810,46649,46617,44569,46617,48730,52891,52891,52923,55003,54971,50842,52890,48730,44569,48698,48730,48698,50810,34102,29942,27796,15183,13071,11023,10990,13103,33939,31761,25487,27664,27633,31826,25520,27600,31761,25487,25519,23406,35953,27469,19115,21196,29647,23406,33840,40114,40049,38033,40146,46387,40113,29647,33710,31597,21162,14953,42293,54839,42096,29450,39918,21162,19050,19114,23405,33872,40178,50678,50646,48566,46485,40081,37967,31628,40146,33741,35854,29614,48631,25388,29580,33774,19082,2308,4389,2276,2308,4421,4389,4389,4389,4389,4389,4389,4421,4389,4389,4389,4389,4389,4389,4389,4389,4389,4389,4389,4389,4389,4389,4421,4422,4422,29647,27468,23274,23340,40179,48566,23274,25322,31596,31661,29514,31792,57084,44340,40179,61245,35888,14726,16740,18853,16773,10500,16805,12742,18789,18854,14790,12743,14921,19082,42161,46387,44274,44339,54938,54937,38065,35920,44372,48533,21195,21227,25453,19081,19081,17001,44372,40146,25388,126},
{17493,17493,19541,21621,38296,44569,44537,44537,46617,46617,46617,48698,52891,52923,52891,52891,50810,50778,50810,50778,50778,52891,52891,50810,54971,59197,59197,59197,57116,54971,50810,48697,48665,46552,44439,42391,42359,42359,42391,42391,42391,44471,48697,55003,59164,59197,59164,54971,50778,50810,52890,52891,52890,50810,48697,46617,46617,42489,36314,38362,42522,42522,46650,48730,46682,42522,38394,42555,55004,59229,61277,61277,61277,59197,59197,59197,57116,57051,52890,48698,48730,48698,50778,52891,54971,54971,52923,54971,52891,52890,52891,50778,46617,46649,52890,48730,50810,36183,29974,29877,17264,13071,11022,10990,11023,25585,29713,25520,25552,23439,25552,25487,25487,27567,31761,27600,21326,33905,31695,27469,23308,31792,40147,33775,33840,38034,37969,44372,59097,40146,31694,29548,29516,23243,12744,29615,52694,25356,29451,37805,10663,12841,14888,6599,33938,35985,40146,40146,38065,33840,29581,27468,29548,40114,37934,42128,42128,50679,27468,25387,31661,25388,4357,2276,2276,2308,2309,4389,2309,2309,2309,2309,2309,2309,4389,4389,4389,4389,4389,4389,4389,4389,4421,4421,4421,6470,8582,10695,8582,8582,4422,27599,27468,23274,23373,44373,44405,27467,25387,29483,27467,33675,31727,35986,23177,33807,61277,35724,29319,33480,33513,35626,37739,35723,23144,14693,10565,8517,16937,19082,16969,31694,42194,40081,44340,59164,56986,33774,29581,44405,42227,35920,27599,27566,25387,23210,19081,35953,23275,6502,115},
{27894,34135,38264,38264,44505,42425,42424,42424,42456,44537,46617,48698,50778,48698,50810,52891,50810,52891,52891,52890,50810,52890,52891,50810,55004,59197,59197,59197,57084,52890,50810,50778,48697,46585,44471,42391,42391,42391,42391,42391,44504,46584,50778,54971,57052,57051,54971,52890,50810,50810,52890,52891,52890,50778,48697,46617,44537,42489,36314,38394,38394,40442,42522,44570,44602,40474,38394,40474,50843,59197,59197,59197,59197,57116,59164,59164,57116,57051,52891,52891,52891,50843,52891,52891,54971,55003,54971,54971,54971,52890,52890,48730,48698,44569,52891,50810,48762,38263,29942,29942,19376,13103,11022,10990,11023,17264,31793,27600,25520,25487,27632,27600,23439,27600,35986,31793,19213,21326,27469,23276,21195,29614,35986,33775,38034,29647,31695,48631,50680,38066,35920,25322,23275,33710,14856,21195,48435,29549,16936,16936,14856,14889,12839,2373,6600,40211,44372,44405,44405,42227,31662,27500,29548,40146,48598,46453,44372,50711,35887,35887,42193,29613,4356,196,2276,2308,4389,4389,4389,4421,4421,6470,6470,6502,8582,8582,8582,6534,8582,8582,8583,8582,6534,6502,6502,6502,8583,10695,6470,10728,12808,25454,27467,23307,23308,35953,44405,29646,25355,23209,23242,31628,29514,27435,27337,37870,56985,52529,54642,52497,52530,46256,46223,31466,12710,10598,4356,6470,14856,14889,12776,25388,40113,40080,42226,59164,54938,29581,46452,35920,31727,33807,12809,29679,14855,10565,19016,12840,12776,6502,102},
{50778,46650,44537,44537,44537,44505,44505,44505,46617,48730,50778,48698,46617,46617,48698,50778,50778,52891,52923,54971,54971,52891,52891,52890,55003,59197,59197,59197,57051,52890,52890,52858,50778,48665,44471,42391,42391,42391,42391,46585,50778,48697,50810,52890,52923,52923,52890,52891,52891,52891,54939,52891,52890,50778,48665,46617,44537,42489,38362,38362,38362,38362,38394,40442,40474,38394,38394,38394,48795,57084,57084,55004,57084,57116,59164,57084,57084,55003,52891,54971,54971,52891,54971,55003,57084,50810,46649,54971,55003,52890,50810,44569,48730,46617,52891,48730,50810,38263,29942,32022,23538,13103,11023,11023,11023,17296,31794,23407,25520,31793,31793,23407,19246,27600,33841,25519,23406,21325,35888,33775,35888,33808,38034,46421,40179,31728,27534,31727,27567,54905,48501,27468,25356,23243,16936,27501,44405,40114,10663,8615,23275,19049,8679,6534,4487,40212,33840,33742,31629,33774,31661,25387,27468,27468,29581,21194,29614,48598,61211,63324,63291,35919,16968,17001,17001,8582,6470,4421,4389,4421,4421,4389,6469,6502,6502,8550,8582,10663,12775,14855,16936,17000,21129,23241,25354,27435,29547,31628,33741,31693,35920,29646,25355,25387,23275,35986,48566,35920,27468,25257,27436,35887,33741,25322,27370,29450,29451,27337,25257,21064,14791,12710,16904,23243,21097,8549,6470,8582,10695,27402,29547,31595,31628,27402,31661,54971,48631,23275,46518,46419,44340,29647,6469,27534,21162,6436,14855,10695,14855,23242,115},
{52891,44569,44505,44537,44537,44537,44537,44537,48698,50778,48730,46617,46617,46617,48697,48730,48730,50778,50778,52891,54971,52891,50810,52890,57052,59164,59164,57116,54971,52890,54971,54971,50778,46584,44439,42359,42391,42423,46617,52858,52890,52890,52890,52890,52891,54971,54971,54971,55003,54971,54971,54971,52890,50778,46617,44537,44537,42489,38362,36314,38362,38394,38394,40442,40442,40442,38394,38426,40507,50843,54971,52923,52923,55004,55004,54971,54971,52923,50842,52891,50811,50843,55004,59197,57084,44569,44537,54971,52891,52890,48730,44569,52890,46617,52891,50810,48730,34135,29942,32022,25650,15151,13071,11023,13103,17296,31826,25487,15085,25520,21359,25552,21391,25552,35986,31760,19213,29712,50646,50581,52661,40081,33840,33808,31760,37968,27534,33840,29648,52760,40081,21195,23243,23243,25291,39984,46290,29614,21195,17034,31693,17001,8679,12840,8680,25487,29614,29614,23275,31661,35854,29516,29548,27468,29581,25387,25453,46518,40147,31728,35953,35855,31661,31661,25420,16936,16968,19081,23242,25354,27467,29548,31628,31693,31693,33773,33741,33773,33774,33773,33741,29613,29580,27500,27500,27468,27468,25388,25355,23308,42324,46421,29516,27467,25355,31760,33840,35920,33775,35920,44373,42292,35920,33774,37935,37999,37968,40113,40081,40113,40178,35953,23307,25388,31596,14791,29581,8550,4356,6437,4389,4356,2276,2243,10760,50712,44406,14889,38098,33840,31792,21227,21162,29679,27500,17001,25453,19114,23242,35820,151},
{48730,48698,46617,44569,44569,44537,44537,46617,48698,48730,48698,46617,46617,46617,46649,48698,48730,48698,48698,48730,50810,50778,48730,52923,57116,57084,57084,57051,52890,50810,54971,54971,50777,46552,42391,42359,44471,46584,50810,54971,54971,54971,52891,52890,52891,54971,54971,55003,57052,57051,55003,54971,52890,48698,46585,44504,42456,42457,38361,36314,38362,38394,38394,38394,38394,38394,38394,38426,38426,48763,55003,52891,50843,52891,54971,54971,52923,50811,48730,48730,50810,52923,54971,52891,48698,44537,44537,52891,52890,52890,48730,46649,52890,48698,50810,50810,48698,34103,32022,32022,29876,15183,13103,11023,11055,15216,25552,27568,23471,27600,23407,25520,29843,25552,27568,29648,31761,40179,44274,40049,44209,42162,27566,37936,27501,40081,31727,25486,23276,27470,29549,17034,27468,25323,25388,12841,42031,21130,16969,29549,33742,17001,14888,14921,12841,10793,10761,8680,6567,29580,37967,27468,29515,27467,29581,23307,27436,33840,27436,16904,27533,42226,44306,48466,27468,27468,25420,25387,25387,23339,23307,23275,23275,23275,23275,23275,25388,25420,27501,31694,31727,35920,35953,31661,25388,25387,19114,17001,21195,31727,33742,50418,35757,27467,27467,14986,29646,35952,38066,44405,40212,33840,44307,50646,50678,50678,50711,50678,50646,50646,46486,31858,17001,25289,29548,44340,52759,8549,2276,2276,2244,2276,2244,163,12840,38099,25421,12743,27534,25420,23308,38033,40211,46485,31726,31792,31825,29581,23274,25354,142},
{48730,48730,48730,48698,48698,46617,46617,46617,48698,50810,52890,48698,46617,48665,48697,48697,48697,48698,48698,48730,48730,48730,50778,54971,57084,57084,57084,54971,50778,52858,54971,50810,46617,44472,42391,42359,44504,48665,52858,55003,55003,54971,54971,52891,52923,54971,55003,57052,57084,57084,55003,54971,52891,48730,46584,42456,42456,42457,38362,36314,38362,38394,38394,38394,38394,38394,38394,38394,40474,52956,57084,52923,50811,50811,52891,52923,52891,50843,50810,50810,52923,52891,50810,48730,46617,42456,42457,52891,52891,48730,46650,46649,50810,48730,48730,48762,46617,32055,32022,32022,29876,19344,13103,11023,11023,15183,29746,21326,21391,29680,25487,23439,29844,25552,35986,29680,29712,40114,37968,35921,44307,46388,29615,27534,27566,19212,29647,31727,38034,31662,23210,16969,21162,6599,2374,2341,33677,21162,2341,23242,27436,29484,16969,17034,10728,6567,8648,6567,2374,25419,37934,29548,33741,31693,27500,21195,27436,31662,27468,19016,29614,40081,42259,44306,33709,25355,29581,33807,35887,29613,44372,50711,52824,54905,57018,57050,59131,59164,61244,61244,61276,61277,59130,35886,35854,33773,29547,14855,8647,12808,23144,52466,42129,27467,29515,17098,31759,40146,40211,35985,35953,46485,50646,50646,50678,50678,50646,50646,46485,35985,19180,10695,16935,33708,33873,40147,50679,14856,2244,2276,2244,2276,2244,12808,42259,27566,6469,17001,33839,38000,23340,40179,31727,46518,31727,29548,14921,31727,29548,27401,143},
{50810,50810,50810,50778,50778,48698,48698,46649,48698,50810,50810,48730,48697,48698,48698,48698,48698,48730,48730,50778,48698,50778,52923,57116,59164,57116,55003,52891,50810,54971,52890,48697,46584,44471,42359,42359,44472,46585,52858,57084,57084,55003,54971,54971,54971,55003,57084,57084,59164,57084,57084,55003,52891,50778,46584,42424,42424,42457,36314,36314,36314,38362,38394,36346,38394,38394,38394,38426,40475,55004,57084,55003,50811,50811,50843,50843,50810,50810,48730,52891,52923,52891,50810,48730,48697,42456,42457,50810,48698,42456,44537,48730,52890,52891,50810,48730,44537,32023,29974,29974,27796,19344,15151,11023,11023,13103,27665,25519,19279,29680,27632,27633,31956,23504,31793,27568,29745,35921,35920,42194,50580,48468,31695,40048,33840,23340,33840,31695,31727,29614,27436,17001,23243,12904,6567,17033,35725,33676,27370,25258,29516,27403,12839,12873,6599,6599,6567,14953,27468,33773,37966,31596,33709,33807,29581,23275,25420,27533,27501,16903,27501,40113,33806,35853,39982,48207,54806,56952,54871,50678,52890,52891,61310,61277,59197,59164,54971,52858,50745,46584,44504,46519,38033,25387,23242,12743,23210,21129,10728,4454,21064,52434,44144,25355,27467,21226,25421,29582,31760,38066,52759,50679,50679,48566,42292,46453,42292,42259,40114,31760,23275,27434,39981,37901,38099,40146,48598,23242,196,2308,2244,2244,2244,31793,52824,33807,4388,19081,46452,44307,21195,38099,42259,38034,31727,14888,14856,33872,33774,29482,142},
{52923,52923,54971,52923,52891,50778,48698,48698,48698,48698,48698,48730,48698,48698,48698,48698,48730,50778,50778,50778,50778,52891,57084,59197,59197,57084,52923,50778,54971,54971,50778,46617,44504,42391,40311,42359,44504,48697,52891,57084,57084,57084,55003,54971,54971,54971,57084,59164,59164,57084,57084,57052,54971,52858,46585,42424,42424,40409,36313,36314,36314,38362,38362,36346,38394,38394,38394,40474,42555,57084,57084,55003,50843,50811,50811,50778,48730,48698,48730,50810,48730,50778,50810,50810,48730,46617,44537,48698,46617,42457,44537,50810,52890,52891,50810,48730,46649,29975,32022,29974,27796,19344,15183,11022,11022,11023,21424,25519,19246,27600,23439,21327,29876,21391,27567,33841,38066,31727,42226,42195,40082,33905,40179,37936,33742,27502,31792,27599,40113,35953,25388,17001,33677,44240,31693,35822,35790,29516,33644,27403,29516,25323,23307,27566,6535,4487,4454,19147,33774,29613,42160,29548,33741,33806,27468,23307,29549,29516,29614,16871,25421,35953,44372,35854,42095,46354,46419,38000,35887,31726,31793,35986,36019,31793,31825,31793,23374,12907,17067,14954,12841,25421,21195,40049,35822,33578,31400,25258,27436,21227,19016,39886,19017,4389,4389,2276,2244,196,10696,14987,14954,12842,8681,12841,25453,35952,38001,38033,50679,31727,27468,33707,42094,40014,40179,42259,50679,29549,163,2276,2276,2276,163,27631,52824,35921,6437,16968,42259,50646,23275,35953,38033,27501,31727,17000,12742,33872,38033,27434,132},
{57116,57116,57116,57084,54971,50778,48698,48698,48698,48698,48698,48698,48698,48698,48730,48730,50778,50778,50778,48698,48730,54971,59164,59197,57116,54971,50810,48665,50810,52858,48697,46584,42423,42359,40311,42359,46585,50810,54971,57084,59164,57084,57084,55003,54971,54971,57084,59164,59164,57084,57084,57084,55003,50778,44536,42424,42424,40409,36314,36314,38362,38394,38394,36346,38394,38394,38394,40474,44635,57084,55004,52923,52923,52923,52891,50778,50778,48730,48730,46650,42457,42456,46650,50810,50810,48730,44569,46649,48698,46617,46617,52891,50810,48730,48730,50843,48698,29974,32023,32022,27829,19376,15151,11022,11023,11023,17231,19278,17198,21326,27600,31793,29811,23504,33873,35922,33873,27567,40114,35888,29647,38132,40114,37936,37968,25454,31792,27599,38066,31760,25420,21226,42128,54676,37902,35953,52661,40015,33709,27435,35854,29548,29548,37967,25355,23307,25420,31693,31693,33741,40079,31693,29548,31693,27501,33807,35887,29484,33808,16903,27501,33774,33840,42226,44273,35886,33740,27499,31693,31693,29580,31660,29580,25387,25420,25420,14921,12808,21161,17001,14888,42292,50711,46160,42064,35790,31368,27338,27436,38099,35888,19017,6502,6502,14888,27436,29581,35822,16999,8711,6729,15019,261,21292,50646,42227,35921,50711,48565,37869,37933,40013,42094,37933,35953,33840,40179,31726,2244,2276,2276,2276,196,23406,52824,40146,16903,25322,40114,46420,35920,38098,44405,44372,38098,23242,25386,33840,40146,25354,129},
{59229,59197,59164,57084,52891,50778,48730,48698,48698,48698,48698,48730,48730,48730,48730,50778,50778,50810,50778,48698,48697,50810,54971,55003,52923,50778,48697,48697,48697,48698,46585,44504,42391,40311,40310,42391,46617,52923,57084,57084,59164,57084,57084,55003,54971,54971,57084,57084,57084,57084,57084,57084,55003,50778,44536,42424,42456,38361,36313,36314,38362,38362,36314,36346,38394,38394,38394,40474,46683,55004,52923,54971,54971,55003,54971,50810,50810,50810,48698,46617,44537,42424,44537,48698,48698,48730,46617,46617,48698,48698,48730,52891,52891,46650,46618,50843,44569,29942,34103,31990,29910,23538,15183,13071,11022,11022,17231,21327,21326,21359,21359,25552,27763,25552,40115,33873,27535,33808,44242,46355,50548,48566,25422,40082,29615,33840,33808,35921,29647,29614,25258,14920,31629,37903,31694,25421,37968,37902,37901,35853,35886,35854,35821,33741,31661,29580,25420,31726,38032,37999,40047,33741,29548,29581,25388,25420,33775,29451,35953,16904,21195,38000,31694,31760,38000,37967,29548,33773,33806,33774,25419,27500,23274,23274,23274,27501,12776,14888,23274,23274,17001,42293,52824,42129,46322,31433,29124,27109,27207,31793,17295,19244,36018,4421,17034,33807,50613,37901,25418,15018,15116,21391,6601,27566,48533,40114,33840,54905,46420,23209,33708,37900,37901,35820,33807,27534,21260,31727,6437,2276,2243,2276,2276,21293,50744,46518,48599,46486,44373,48533,48565,52824,48598,31760,33873,21194,27468,31694,40179,27435,141},
{59197,57084,54971,52891,50810,50810,50778,48698,48697,48698,50778,50810,50810,50778,50810,50810,50810,50778,48730,48698,48697,48698,50810,52890,48698,46617,48697,50778,48698,48665,44504,42423,42359,40310,40310,42391,46585,52923,57084,59164,59164,57084,57084,54971,54971,55003,55003,55003,57084,57084,57084,57084,52891,48665,44504,42424,42457,38361,36281,36314,36314,36314,36314,36314,38394,38394,38394,40475,42555,55003,52891,50843,50843,54971,55003,52891,50810,48698,44569,44537,46617,42456,42456,44569,46649,46617,44569,46617,46649,50810,52891,57051,52923,46650,46618,48730,40376,29942,34103,29942,27862,27764,17263,11022,10990,11022,17231,19278,19278,21391,21391,21326,23471,29680,35921,31760,23374,35921,54742,54774,56855,44307,25389,31728,37968,35953,31727,29680,38001,31694,23178,12808,25388,35790,35888,19114,17001,17033,19082,17034,17034,17001,17034,17034,17002,14921,12841,17034,10760,21227,40080,35854,29581,27468,23242,19114,31694,31564,38001,16871,21162,29614,29581,19114,33806,31725,23274,27500,29580,29613,25387,25387,21193,25354,23307,31726,10727,14856,23274,21227,17001,38099,54904,37902,41998,33709,35594,37838,23144,6535,650,21520,46551,21227,23275,17001,48434,52557,25482,12937,31824,25453,35954,44340,35986,27567,27599,48599,44340,16936,19048,29547,35788,35820,31726,29647,19114,33840,10630,2276,2243,2243,2211,14954,48632,46453,48632,48631,40146,46387,46485,50646,44340,31727,31760,25420,14855,23275,40179,31628,137},
{55003,52891,50810,48698,48730,50810,50778,48698,48698,48730,50810,50843,50811,50810,50810,50810,50810,48730,48730,48698,48730,50810,52858,50778,46617,48697,52890,50778,48697,46584,44472,42391,42359,40310,40278,42391,46585,50810,55003,57084,57084,57084,55003,54971,54971,54971,55003,57052,59164,59164,57052,54971,50810,48665,44504,42424,40377,38329,36281,36314,36314,36314,36314,36314,38394,38394,38394,40474,46715,55003,50843,50843,50811,52891,52891,50810,50810,48698,44537,42457,42457,44569,46617,46617,48698,44537,46617,48697,48730,50810,52891,55003,52891,44569,46618,48730,36216,29943,34103,29910,27861,29909,17296,11022,8942,13103,15150,17166,19278,19278,21327,27600,27567,29712,31761,27567,21326,38066,52629,52661,52629,33808,27502,27534,33775,31728,31760,29614,38034,31727,25388,21195,23275,33774,37968,19114,12808,14921,14921,14921,14921,14953,17001,17002,17002,17033,17001,17001,14921,23307,37999,31661,29580,27467,23275,19114,29646,48467,42259,14823,25388,27501,29581,21194,35887,35886,25387,29515,31628,23307,25419,25387,21162,27467,19114,29646,14920,17001,25354,23275,14921,33873,48630,42128,41998,35822,33546,35757,29451,25421,4714,23568,48664,27566,29614,12742,27500,31660,25451,27598,42324,38001,42259,44340,23439,229,15019,35953,33872,29548,31595,37901,39981,35820,33774,31792,23308,31727,14856,2243,2276,2243,2244,4389,19246,25617,44470,50777,42292,42259,46452,54905,50646,31727,29679,29614,8549,14856,38066,46452,176},
{54971,52891,48730,48698,48730,50810,50778,50778,50778,50810,50810,50810,50810,50810,50810,50778,50778,50778,48730,48698,48730,50810,48730,48665,48697,50778,52891,48730,46585,44504,42423,42391,40311,40310,40310,42391,44504,48730,52891,55003,57052,57051,55003,54971,52923,52891,54971,55003,57116,59164,55003,52890,48730,46617,44504,42424,42425,38329,36281,36314,36314,36314,36314,36346,38394,38394,40474,42555,52923,55004,52923,50810,50810,50810,50778,50778,48730,46649,42457,40344,42456,46617,48730,50810,50778,44537,46649,50810,52891,52891,50842,52891,48730,44569,46650,48730,34135,29974,32022,27861,27861,29909,17296,11022,10990,13071,10990,13038,19246,23439,23407,27568,31793,31793,33873,31760,19246,44307,56789,58902,44209,27502,33840,31695,27469,29582,38001,33775,27599,31760,25389,21163,19113,31662,33775,21227,17001,21194,23274,23307,25387,27500,29580,31661,31693,33774,35854,35886,37934,40047,40047,31660,27468,27435,23307,23275,21162,35986,46518,14791,19114,23275,40179,29581,42226,40112,33774,35854,35854,27500,31693,29613,27467,33741,23307,33840,23340,19081,25354,23307,12808,23275,29582,44177,44046,37935,33578,35757,29483,33743,17001,21325,38067,23243,27566,4389,8680,17066,46483,54839,56854,35921,44340,44340,31826,8647,33774,29647,23341,31661,31595,39981,42094,37933,40178,44437,42292,31759,19049,163,2276,2276,4389,2243,12907,19376,40245,50744,46453,42226,46452,44405,44340,35952,38098,33840,16968,21161,23275,33840,175},
{52891,50811,48730,48697,48730,50810,50810,50778,50810,50810,50810,50811,50811,50810,50810,50778,50778,50778,48730,48730,48730,48730,48730,48698,50810,50810,50778,48665,46552,44472,42391,42391,40311,40278,40310,42391,44504,48698,52891,54971,55003,55003,55003,54971,50778,52891,54971,52891,54971,57051,54971,50778,48697,46585,44504,42424,42424,40377,38329,36314,36314,36314,36314,36346,38394,38394,40474,52956,61277,59164,55003,52891,50810,50778,50778,48730,48730,46617,42424,40344,42456,48698,50810,50810,48730,46649,50810,50810,52891,50842,48730,50843,48730,46617,46650,46617,32023,32022,32022,27861,27861,29909,19344,15151,13070,11022,13070,17166,23439,29680,23407,27600,29681,29680,21326,38034,25519,38034,48501,46388,35856,35953,38066,40082,35823,25357,33840,31630,31727,25421,23308,21195,27501,33742,27501,25388,31693,35887,37967,37934,37967,40015,40047,40079,40047,40079,40079,42160,42160,44273,48532,35887,25387,25355,19114,27501,27468,29679,46453,27435,29516,33742,42292,25355,25387,40080,35887,37967,35887,29613,35886,31726,31660,31693,21194,27566,29614,19081,25355,25355,23340,19017,27468,41965,44046,37935,33611,37838,29516,31629,17034,10761,29483,42129,33905,19081,25420,44274,37903,46290,52628,23308,40147,44307,33906,38066,35888,25453,19179,27533,23241,25322,21129,27533,46453,48631,46551,33840,23275,2243,2276,2276,10695,4356,8648,19344,33939,50712,46518,40114,33839,31727,23340,38033,21196,29647,19113,19081,19081,31759,166},
{50778,50778,48698,48698,48730,50810,50810,50810,50810,50810,52891,52891,52891,50811,50811,50810,50810,50778,50778,50778,48730,48730,50810,52890,52890,50810,48698,46617,44504,44472,42391,42391,40311,40310,40311,42359,44472,48697,52891,54971,55003,55003,54971,54971,52890,54971,52891,52890,54971,54971,52890,50778,48697,46585,44504,42424,42424,42457,36281,36314,36314,36314,36314,36314,38394,38394,40474,57116,61277,59197,57084,52891,48730,48730,50810,50842,48730,44569,40376,38296,40344,46650,50810,50810,48698,50810,50843,50810,46650,48730,48730,50810,50778,48730,48730,44537,32023,32022,32022,29910,27861,29942,21457,13103,15151,10990,15150,17198,27600,31761,31761,33906,35954,29680,21326,36019,25551,19245,29712,23438,25486,29615,31728,38001,42129,29550,35953,29582,25421,33742,27404,23243,29615,42096,29516,27501,35887,40080,42160,42192,44273,46386,48467,48499,50612,50645,50645,52726,52758,52758,52726,37968,27467,29548,27435,27500,27468,25322,27435,27533,19082,17002,38099,42194,35887,40113,44339,42259,42291,40146,35985,33807,25420,17001,12808,17066,31759,16969,14888,16969,19179,23210,37838,41965,41998,39983,31498,37837,33742,35823,23341,19212,31596,44373,33938,27566,19115,33742,35822,25389,27501,4422,21293,40113,29549,46551,38001,12808,12841,14888,10630,16935,16967,21161,40179,44438,44406,33873,25388,4356,2309,2276,2276,2244,4422,19409,31826,48631,46518,38001,46420,33742,27468,38033,10565,25421,23307,12775,19081,25453,152},
{50778,48730,48730,48730,50778,50810,50843,50843,50843,52891,52923,52923,52891,52891,52891,50843,50810,50810,50810,52891,50810,52891,52891,52890,50810,50778,48697,46585,44504,44504,42423,42391,42359,40311,40311,42391,44504,48697,52891,54971,54971,54971,54971,54971,54971,54971,52891,54971,55003,54971,50810,50778,48665,44536,44504,42424,42424,42457,36281,36314,36314,36314,36314,36346,38394,38394,40474,52924,59197,59197,55036,52891,50810,48730,50810,52923,50810,46617,40376,40344,44537,50810,52891,52923,52923,52891,50843,50810,44569,44569,44537,50810,50810,50810,50810,44537,32022,32022,34071,29942,27861,29942,25683,13102,15151,10990,13038,17166,25552,35954,33906,35987,38067,29712,25519,27600,23439,21325,29712,23471,33808,27469,25389,33807,33840,40114,29647,33808,27501,31662,42129,40113,44308,48468,25323,38034,48598,54839,54872,59097,56984,56952,56952,56920,54872,52759,52759,52758,52726,50613,48565,48532,48466,40014,27500,25420,27500,27435,25387,19082,21129,21161,38066,33840,25421,31694,12809,8615,14888,10728,10696,8615,8582,6469,6469,10695,31792,21260,8615,14954,19114,19049,33612,41997,44013,39983,29483,35692,31629,35790,27566,8615,14954,25421,19115,12874,19050,29549,27501,14986,10696,131,8615,31596,23144,36019,35986,6501,14920,21162,23177,31595,33675,31627,40114,42325,40244,33905,29614,6469,4389,4356,4324,6437,2276,25584,38099,46486,44406,33807,46420,46452,52726,44307,14823,23340,25388,27468,23274,25421,161},
{50810,50778,50810,50810,50810,50843,52891,52891,52891,52923,52923,52923,52891,52923,52891,52859,50811,50810,55036,57084,52923,54971,54971,52891,50810,48730,48698,46617,46584,46552,44472,42391,42359,40311,40311,44472,46585,48697,50810,54971,54971,52923,52891,50810,50778,50810,50810,54971,52923,52891,52891,50778,46585,44504,42456,42424,42456,40409,36281,36314,36314,36314,36314,36314,38394,38394,42523,52924,59164,57116,52891,52923,52923,50810,50811,50810,46617,42457,40344,40376,46650,50810,50810,50810,54971,52923,48730,46650,44569,42457,40409,48730,50810,50810,48730,42457,32022,32023,32022,29910,27861,29910,29876,17231,13102,13070,10990,13038,21359,31793,40147,35986,33906,27632,21390,29680,29712,23438,40115,21326,31760,31695,25421,31760,31758,38066,38033,35856,29647,31695,37838,29517,35986,40146,25389,42259,46485,50646,52791,54904,54839,52726,48533,42227,44372,52759,46420,42227,44307,35953,35953,48599,46486,52758,50580,50612,48499,44273,19114,14986,21161,31595,38000,33873,12809,29646,23307,17001,19114,19114,19114,17033,14921,17002,12841,21260,29712,25453,17001,8647,19082,19017,23177,35724,44045,39950,29451,35627,31531,33612,31564,12808,31662,46387,39983,19082,19082,12841,8648,15019,10728,163,8615,27435,21194,29680,29679,14887,19114,23340,23241,23241,37933,27435,40146,48599,36018,29744,33872,10662,10695,10662,4389,12840,4356,23341,38033,44406,42325,27501,42227,48533,59131,50711,31726,40147,25421,23275,21194,17033,155},
{52891,50810,50810,50811,52891,52891,52923,52923,52923,52923,52923,52923,52923,52923,52891,52859,50810,52923,59164,59164,55003,55003,57052,54971,52891,52858,50810,48697,46585,46552,44504,42391,42391,40311,40311,44472,46617,48697,50810,52923,52923,52891,50810,50778,46585,46617,46617,52890,52891,52890,52891,48697,44536,44504,42424,42424,42456,40409,38361,36313,36314,36314,36314,36314,38394,38394,48795,59197,59197,57084,50843,50843,50843,50810,50810,46650,44537,42424,40376,44537,46649,48730,50810,50810,48730,48730,48730,46650,44569,42457,40376,44569,48730,48730,46649,42457,32022,32022,32022,29910,27829,29909,27796,17231,15150,13038,13070,15150,27600,29681,35954,29680,31760,19246,17197,31826,31825,29777,44275,19245,25519,33808,33840,29647,23404,40146,42195,33808,27502,27567,35822,27436,35921,40081,27502,46518,42226,50679,46387,35887,40047,42161,31792,25486,29614,40114,35953,31792,25453,25454,29647,29679,27501,38001,25388,19115,14954,15019,4454,21293,23274,31595,35854,40179,12808,19180,21227,17034,17034,19147,23308,8779,10925,19312,12973,21261,23373,21194,21162,17001,19146,14856,29385,33578,44111,42128,35561,29222,33449,29385,33448,35887,50679,54709,44176,12809,4487,4519,4487,4454,2406,2374,10728,17001,12808,17001,21129,23241,16968,27501,23241,27434,37934,37901,44306,44405,44373,42292,38033,19049,6501,12775,2276,10727,4389,14986,44340,48631,57050,31661,38066,44372,48566,48533,35920,25422,27566,21194,19081,10695,110},
{52923,52891,52891,52891,52923,52923,52923,52923,52923,54971,55003,52923,52923,52891,52891,52891,50843,57084,59197,59164,57084,59197,59164,57084,57052,55003,52891,50778,48697,46584,44504,42423,42391,42391,42391,42424,46585,48697,50810,52890,52890,52890,50778,48665,46585,44537,48697,52891,52890,48698,50778,46617,44536,44504,42456,42456,42456,42457,38361,38361,36314,36314,36314,36346,38394,38394,48795,59197,59196,59164,57084,52891,48730,50778,50778,48698,46617,46617,44537,44537,48730,50810,52923,50810,46617,48698,46650,46649,44569,42457,40376,44569,46650,46650,48730,46649,32022,32022,32022,29910,27829,29909,27764,17263,15151,13038,13038,15150,25552,31826,35986,38067,25519,29712,15085,29745,35986,29712,40082,17165,23471,35953,33840,31727,19147,44372,31727,25421,33743,29582,25454,17067,42227,27501,6600,31792,44404,50711,48500,31629,39982,50548,29679,21261,27501,31694,25421,31760,21227,17034,25486,29647,25421,21195,14921,6502,8615,8647,6535,12971,21226,31595,31693,42260,12808,10793,23372,25453,27533,33840,25485,19245,17199,12973,8844,12939,17066,25387,23274,25387,25355,14791,31531,50352,54676,44111,40015,33839,44340,38000,33644,23275,44373,46355,17002,4454,2342,6567,6535,4389,6437,4389,29614,29614,17001,29581,16968,19016,12775,25421,29515,33740,40014,44207,44241,40244,42292,33905,38098,27501,4389,14888,4356,10727,8549,4389,21293,54970,63422,46485,33807,42260,46485,38033,31694,4356,25486,21226,19049,12807,65},
{54971,52923,52923,52923,52923,54971,55003,52923,52923,55003,55003,54971,52923,52891,52891,52859,54971,57116,59229,59164,59165,59229,59197,59164,59164,57084,54971,52890,50778,48697,46584,44472,42391,42391,42391,44504,46585,48697,50810,50810,52858,52858,48730,48665,46584,46617,54971,54971,50810,48697,48697,48697,46585,44504,44504,42456,42456,42457,38361,36314,36314,36314,36314,36346,38394,38394,44603,55036,59164,59197,59196,55004,50810,48730,48730,50778,48730,50810,48730,48730,50810,50810,52891,48698,42457,46618,46650,48730,46617,42457,40376,44537,44569,44537,46650,46617,32022,32022,32022,27829,27829,27829,34069,21424,15150,13038,10990,13070,19311,25520,35986,42228,31793,33906,23374,29713,31793,31760,31727,12972,23438,23373,17132,25454,23340,38098,40114,27502,31695,37969,14986,21260,48501,25420,294,31760,44373,50679,44307,33774,40113,42162,25388,19114,23340,27566,23308,33873,19147,23340,25453,23373,21260,21195,14921,14953,21195,16969,12776,4487,17033,29515,29547,44372,21195,12906,23340,25453,29679,27633,21325,27632,15086,12973,8812,8779,19147,25387,23274,27467,25355,14823,29418,52465,50450,44144,44306,38001,46420,35888,21129,16969,33873,31727,6535,2406,6535,17002,21097,4324,2211,98,19147,33839,21226,40113,19048,19048,19016,17001,23242,33708,37933,37933,37967,46518,52825,44405,31760,33807,2308,14888,4356,8615,8582,2244,4421,36085,63358,59131,42291,42292,33840,21195,38000,6469,23341,23307,25355,19048,35},
{55003,55003,55003,55003,55003,55003,55003,54971,52923,55003,55003,54971,52923,52891,52891,52891,54971,59197,61277,59197,59229,61277,59197,59164,59164,57116,55003,52858,50778,48697,46584,44472,42391,42423,44504,46584,46617,48698,50810,52858,52858,52858,48730,46617,46585,52891,57084,54971,48730,48698,50778,50778,46617,44536,44504,44504,42456,42457,38361,36314,36314,36314,36314,36346,38394,38394,42554,55004,59164,59197,59197,55004,48730,48698,50810,50843,52891,55003,50810,48698,46649,48730,50810,46649,42457,42457,46650,48730,44537,44537,42457,44537,44569,42489,46650,40376,32022,32022,32022,27829,27829,29877,34070,21424,15150,10990,10957,13038,21392,33906,31793,35954,33906,38067,25487,33874,31761,25519,33840,23438,31793,33840,25453,27534,29614,35920,42227,29614,27501,35921,27501,23308,38034,40048,19147,40146,42324,35921,29581,23340,21227,25388,23308,25388,23340,31727,29581,33873,19147,23373,31727,19212,19180,23275,29548,29646,25388,10663,12808,17066,29679,40178,38066,44406,25389,10761,10793,10760,25520,4684,17099,21358,15086,15085,10859,10859,23341,25355,19049,29548,21194,18984,21064,35757,48402,50417,56658,54675,46224,39983,31564,10696,27567,29614,6535,6470,19049,21097,33807,10597,131,98,12808,38033,17001,27533,21161,23241,25322,33774,48500,46354,27435,12807,21194,23407,36019,40211,29646,38033,4356,6502,4324,4324,4324,2243,163,14987,59196,61309,48566,38066,33806,31693,40146,23307,29679,27501,27468,19081,80},
{57084,55003,55003,55003,55003,55003,55003,54971,55003,55004,55003,55003,52923,52923,52891,52891,52923,59197,61277,59197,61277,61277,59197,59197,59197,59164,57051,52890,48698,46617,44504,44472,44472,44472,44536,48665,48698,50778,50843,52891,50810,48730,48698,46617,46617,54971,52891,50778,48697,50778,52891,50810,46617,46585,44536,44504,42456,42457,38361,36314,36314,36314,36314,36346,38394,38394,44635,55004,57116,59197,57116,52891,48730,50778,52923,52923,54971,55003,48730,44537,44537,48730,50810,46617,42456,44537,46650,44569,44537,44569,42489,42489,44537,44569,48698,40376,31990,31990,32022,27829,27829,29909,31957,19343,17230,13038,13038,15118,19279,31793,31794,38067,33874,31825,25487,35986,35954,25519,17165,15085,25519,29647,35888,25454,27534,35952,38001,27502,29582,35920,33807,31694,31727,29647,25454,17100,40179,31727,21162,23307,19147,17034,19147,21260,21260,35953,48533,50678,23340,19180,23373,19147,21293,21260,27500,29614,25453,12808,14921,21293,46519,42325,38132,40212,14953,2406,4487,2406,19246,10925,19245,27567,25519,27567,33742,25356,19115,25420,14888,23307,19081,25258,29451,35855,42096,46191,46224,42129,29451,31564,27436,14986,21260,19146,12840,14791,14855,19082,21228,12645,4259,4357,17034,40146,38000,40080,50580,48467,48500,56952,56985,52726,31629,10727,25354,6436,19114,44405,33808,40179,8549,163,2244,2243,2244,2211,8549,25388,52857,63390,54937,29646,40146,44307,44339,40179,40212,27534,21194,19049,95},
{57116,57084,57052,55003,55003,55003,55003,55003,55003,57084,57084,55003,54971,52923,52923,52923,52923,59197,59197,59197,61277,61277,59197,59164,59164,57116,54971,50810,48697,46617,44536,44504,44504,44504,44537,48698,50810,50810,52891,52859,50810,48730,48698,48665,48698,54971,50810,48730,50778,50778,52890,50778,46617,44536,44504,42456,42456,42456,38361,36314,36314,36314,36314,36346,38394,38394,42555,48795,57084,57116,54971,50843,50810,50810,52923,54971,52891,50810,46649,44537,44569,46650,48698,44537,42457,46617,48730,44569,44537,50778,46617,42489,46617,48730,50810,44537,32022,32022,31990,27829,27829,29909,23570,15150,17231,10990,10990,13070,15150,29745,33874,35986,31793,33874,21358,27632,42228,23438,23406,12939,19245,23374,12906,12971,25421,29680,38034,33807,25356,23340,19180,21260,19180,19180,14986,23373,48599,46452,46419,38000,19147,14986,19115,21227,21227,27534,42227,33873,25421,12841,17034,19147,29680,31792,33807,33872,33872,31792,31759,27599,44438,48631,38164,36019,19147,4487,6568,4487,6600,6600,10761,8680,6568,4487,23276,35790,29614,29614,25453,25453,27533,25355,29483,35822,40015,38001,25389,14857,12808,14921,17001,19114,14921,12840,12873,12775,12840,35790,35823,18854,2178,2375,15019,27632,48599,46419,27404,33612,12712,33612,40146,42259,33806,16968,25419,14823,14921,42260,31792,40179,14856,196,2244,2243,2244,8582,31694,33774,44405,61277,52792,33774,42259,44372,50646,29646,29647,29647,27501,27533,72},
{59197,57084,57084,57084,57052,57051,55003,55003,57084,59164,57084,55003,55003,57084,55003,54971,52923,59164,59197,59164,59197,59197,57116,57084,57084,57052,52923,50778,48665,46617,46584,46584,46584,44536,46617,50778,52891,52891,52891,52891,52858,50778,50778,48698,48698,50810,50810,48698,48730,48730,48730,48697,46617,44504,42456,42456,44504,42457,38361,36314,36314,36314,36314,36346,38394,38426,42554,50843,57116,57084,54971,52891,50810,50810,52891,50843,48730,46649,46617,46617,46617,46617,44537,42456,46617,46650,46650,44569,46617,50810,46650,44537,50810,52891,48730,44537,31990,31990,29909,27797,27829,31990,21489,11022,13102,10990,8909,6829,13037,29745,29681,36019,31793,36019,25552,25520,38067,17132,12972,17132,21325,29615,14987,21324,25453,33905,33840,29646,33806,25421,21292,21260,19147,17099,10793,19180,50712,54839,56853,46420,21260,25388,25388,23307,23340,23372,38065,31759,19180,14954,25453,29646,38098,38066,38098,38066,35985,35953,33872,27599,46519,54938,48631,48631,23308,6567,4487,4487,2374,2342,2309,261,293,261,261,29517,40049,35985,44373,42259,40211,35953,29516,21195,12808,8615,2309,19147,17066,12808,25354,25354,25355,17066,10824,10695,12808,35790,35855,23080,4259,2309,8681,6535,42259,50645,25225,31466,6339,25225,38000,40146,38032,19049,25355,21128,12775,38066,38066,42325,23275,163,2244,2276,2276,8615,33774,35854,42226,52890,48566,46453,48565,44339,46453,35920,27533,33840,21194,25421,74},
{59229,59164,57084,57084,57084,57084,57052,57084,59197,59197,59164,57052,57052,57084,55003,52923,54971,57084,57084,57052,57084,57084,55003,54971,54971,52923,52890,48698,48697,46617,46617,48697,48697,46617,48698,50810,52923,52923,52923,52891,52890,50810,50778,50778,52891,52923,50810,48698,48697,48665,48665,48665,46584,44504,42424,42456,42456,40409,36313,36314,36314,36314,36314,36346,38394,40474,40474,48795,61277,55003,55003,52891,50810,50810,52891,48730,48730,48730,48730,46649,48698,44537,42424,44569,48730,46617,46617,44569,46617,50810,48698,44569,52891,52923,42457,40409,32022,31990,27829,25749,27829,34070,23537,13070,17231,13070,6829,13038,13069,31826,33906,40148,31793,31826,33874,27632,29680,15052,10859,12971,21326,35921,25421,19212,23373,40147,33873,38099,38001,21227,14987,10826,23372,25421,25420,29679,52791,48466,52659,46485,23340,19114,17034,19114,23308,21260,40113,33807,23340,19179,23340,29614,38098,38066,38066,36018,35985,35985,33905,29647,27469,33775,46486,50777,23340,6599,8680,8680,6567,6567,8615,8647,8680,8680,8647,19082,35790,29647,25486,21261,14987,10761,6535,6502,8615,6502,4422,21227,14889,16968,23274,23274,23307,21259,10792,8615,14888,35822,33710,27371,4422,6502,6600,6502,38066,50678,25290,33546,8452,21032,35855,38033,44372,52725,27402,14888,6502,31727,35986,46518,31695,131,2243,163,163,4389,29613,40048,44274,54970,52825,40147,46453,44340,42259,38033,27533,33840,21227,27533,87},
{61277,59197,57116,57084,57084,57084,57084,59197,59197,59197,59164,57116,57084,57084,55003,55003,55003,55003,54971,54971,54971,52923,52891,52923,52891,52923,52891,50810,48698,48697,48730,50778,50810,50778,50810,54971,54971,55003,55003,52891,52890,50810,50778,52890,57084,54971,52890,48730,48698,48665,48665,48665,44504,42424,42424,42456,40409,38361,36314,36314,36314,36314,36314,36314,38394,40474,42522,48795,57084,55003,54971,50810,50810,52923,52923,48698,48730,50778,48730,48698,48730,44537,42457,48730,48730,46650,46649,46617,46650,50843,50843,48730,52891,48730,40376,40376,32022,29942,27797,27797,27829,31989,21457,15150,19311,13070,6829,17231,17198,25552,29713,42228,33874,27600,29713,31793,27599,17165,6730,8778,21358,35921,33743,27599,25453,35921,42292,31727,31760,23307,12873,12906,31694,35887,33807,35953,48467,52626,54740,44339,21228,21227,21227,19147,19114,21227,38065,31695,23275,27533,27566,27533,38098,38066,38098,38098,38066,31792,29712,27534,19049,31628,44405,48664,42292,38098,33840,17034,17066,19114,19114,19147,19115,19147,17066,17002,17002,14954,12808,4422,4422,4454,8647,19115,14986,14921,25388,35887,12710,19016,16968,14920,14888,23372,10824,6566,12743,35790,31597,31630,4520,4454,4455,4454,33841,46453,21129,33579,12645,16839,33710,42226,57017,61244,35887,21194,2276,25485,44372,52825,46453,25388,21163,27534,25421,17002,31693,42193,44307,54938,54937,40113,44340,42226,46452,42194,33807,35920,14856,27337,89},
{61277,59229,59164,59164,59164,59164,59164,59197,59229,59197,59197,59197,59164,57116,57084,55003,55003,54971,52923,52923,52923,52891,52891,52891,52890,54971,54971,52890,52858,52890,52890,54971,54971,52923,54971,55003,57052,55003,54971,52891,52891,52891,52890,55003,57084,57051,52891,50778,48698,48697,48665,46617,44504,42424,42424,40377,38329,38361,36314,36314,36314,36314,36314,36314,38394,38426,42555,48763,50843,54971,52923,50843,54971,55003,52891,46649,48730,48730,48698,48730,48730,42457,46617,48730,48730,48730,50810,48730,50810,48730,46650,48730,50810,48730,38328,40376,32022,29909,27797,27829,29909,29877,17263,13102,17231,10990,8877,21456,17198,25520,29680,38067,31793,29713,33841,33841,29712,23406,12971,10891,12972,12939,25519,27631,25486,31760,44373,25421,25486,44339,38033,38000,25420,31727,31694,31759,42096,50581,54806,46355,21260,21227,21227,21195,19114,23275,38033,31727,33774,42193,33873,21260,40146,38098,38098,38098,38066,31727,19212,29712,31661,27467,40113,46453,40179,40212,35985,23372,25453,27533,27534,25453,25453,25421,23340,17067,14954,12873,8647,2277,2309,6567,8648,6600,4487,17067,38033,40146,12710,16903,19016,16968,14856,27566,12937,6599,14889,35823,35758,39984,2375,4388,2309,2341,27566,42227,16936,31695,19017,10597,33645,46486,52825,59196,40113,27467,4356,19179,42293,50712,50712,35986,21260,31825,14954,21292,35920,44306,44307,54938,54970,35920,33807,35953,50646,42227,14888,21260,21129,23176,89},
{61277,59229,59164,59164,59164,59197,59197,59229,61277,59229,59197,59197,59197,59164,57116,55003,55003,54971,52923,52923,52891,52890,52891,52891,52890,52923,54971,54971,55003,54971,57051,57084,57052,55003,55003,57084,57084,55003,54971,52891,54971,54971,55003,57116,57084,57084,52891,50778,48698,48698,48665,46585,44504,42456,40376,38329,36281,36313,36314,36314,36314,36314,36314,36346,38394,40474,48763,46683,48763,54971,52891,52891,55003,54971,48730,46617,48730,48730,48730,48762,48698,44537,48730,46649,46650,48730,52891,50843,50810,48698,44537,44569,50810,46650,38296,44569,32022,27829,27797,27829,27829,27829,27730,13070,13102,13070,6829,19311,15118,29713,31793,38100,35954,33906,35987,27600,38067,17165,10891,25519,10891,6698,15052,15051,19245,33873,46486,25453,17035,21228,8713,29614,37967,40080,40080,35887,44241,54773,56886,48435,23340,19114,19146,19114,21195,21227,40212,29680,33839,42161,33840,21260,38098,40146,38098,38098,38066,31727,17002,23406,42259,27435,35854,37869,37967,40179,33873,27534,27566,27599,27599,27599,25518,21292,12906,8713,6600,4487,12776,4454,2342,6535,8648,8615,12808,29679,38034,14954,10695,19048,21129,19048,19049,40212,17098,6664,8746,27502,35790,42129,4488,2276,2407,2342,21227,38001,18984,27502,16937,8452,31499,35693,41967,57051,44339,27500,12775,14953,38099,46518,48631,31727,10760,31825,6501,17067,40113,46355,44307,54970,57051,25421,44372,46453,46420,42227,16968,14921,23307,14921,69},
{59197,59197,59164,59197,59197,59197,59197,61277,61277,59229,59197,59197,59229,59197,57116,57084,57052,55003,54971,52923,52890,52890,52891,52923,52890,52923,55003,57084,57084,55003,57084,57084,57052,55003,57084,59164,57084,54971,52923,54971,55003,55003,57084,57084,57084,55003,52923,50810,50778,48698,48665,46585,44504,42456,40409,38329,38362,36314,36314,36314,36314,36314,36314,36346,36346,40474,50843,52891,52923,55003,52891,50843,52923,52923,48730,46649,48730,48730,48730,50810,48762,46649,46650,46649,44569,50810,52923,50810,48730,46617,42457,42457,50810,44569,38328,42489,29942,27829,27797,27829,29877,27829,29844,15150,13070,13070,6829,15150,13037,21391,38067,38035,31793,31826,29680,21326,29648,23374,12939,8811,6730,4585,17165,25519,10859,31826,40147,27534,29516,25388,23373,31695,31695,33742,33807,14986,15019,33905,35888,42162,29679,21195,19147,19147,21195,27468,33840,31825,38033,40080,25388,29614,35985,38066,38098,38066,38066,33808,27501,17099,38131,29581,33709,37934,35886,44405,40179,33873,31792,31760,29647,25486,23340,14921,8647,8647,6535,4486,21195,21228,21260,12873,21227,14823,25388,40179,29647,17034,12808,23242,27435,27435,29548,19115,8712,6664,360,19180,38033,44177,10794,6567,4520,4552,17034,27501,12743,25389,23243,6372,31434,35659,40016,52858,50646,29580,12775,10727,33905,42325,48631,38033,14920,31825,12776,12841,35985,44307,44339,52857,54905,37968,42259,46452,42227,27533,14921,10728,27566,19049,117}
};

const uint16_t Austin PROGMEM [320][241] = {
{42489,44569,44602,46650,46650,46682,46682,46650,44569,42521,40441,38329,36281,34201,42489,50842,52922,48762,42521,38329,30073,27993,27993,27993,27993,30041,34201,42489,42489,40441,42489,42489,46650,52923,55035,55035,55035,55035,55003,52955,50842,48729,48729,46649,44536,42456,42424,40376,40376,44537,48729,48729,48729,44569,44536,44536,46649,48729,48730,50810,50842,50842,50842,50842,50842,50842,55003,55003,52954,50842,48729,46649,46649,44569,42521,44601,46649,44601,44601,46649,48730,52890,50842,50842,50842,50842,50810,50810,48762,48730,48729,48730,48729,48761,48761,50809,48761,46649,44569,40408,40376,46649,46617,46617,44569,46617,44569,44569,46649,52890,50809,46649,44569,42488,44536,44569,42489,44568,44569,46649,44569,29910,19475,25684,19475,17395,17329,17264,27666,23472,15151,25520,21358,19276,17130,15050,15018,23177,39688,39688,39688,39720,39721,41801,41801,41833,43914,43914,43914,43946,46027,46027,52725,52791,50711,48599,35560,27526,17029,37968,42194,35822,10597,6436,10598,25323,46453,44209,42194,29648,12742,16996,10659,6435,8515,14916,8579,6467,4323,4323,4291,4323,6403,4323,4322,6403,6435,6403,4323,4258,4258,4258,4291,4388,4420,4420,4420,4420,4420,4420,4419,4485,8777,6697,8744,15084,17263,21424,21489,21489,23602,25683,23602,25715,25715,25715,27764,25716,25715,27764,27796,27796,27796,27796,27796,27796,27796,27796,27796,27796,27796,25715,25715,25683,25683,23635,23635,23603,23603,23603,255},
{42489,42521,44602,46650,46650,46682,48730,46650,44569,42521,42489,38329,36281,34201,40409,50842,55003,52923,44602,36281,32121,27993,25945,27993,27993,30073,36281,42521,44569,40441,42489,42489,46650,50842,55035,55035,55035,55003,55003,52923,50842,48762,48729,46649,44537,42456,40376,40344,40344,44536,48729,48729,46649,46617,44536,44537,46649,50810,48730,50810,50842,50842,50842,50842,50842,50842,55003,52955,52922,50810,48729,46617,46649,44569,42521,44601,46649,46649,44601,46649,48730,52922,50842,50842,52890,50842,50810,48729,48697,48729,48729,48729,48729,48761,48761,48761,48729,44569,42488,40376,40408,46649,46617,46617,44569,46617,44569,44569,48761,50842,48729,46617,44537,42488,44536,44569,44569,44568,44569,46649,46649,23669,19475,23604,19443,19443,17329,19377,25553,23472,17231,25552,21358,21292,17066,17131,17162,29548,29255,27305,27305,27305,27305,27305,27305,29418,33578,31531,29417,29418,31531,39852,52661,52824,48435,46420,33513,25445,17029,40081,42162,40015,12773,8612,10597,25355,46452,44274,35954,19049,12709,19110,10659,8547,8547,12804,8580,6435,4323,4323,4290,4322,6403,6435,4355,4322,6403,4355,4290,4258,4258,4258,4323,4420,4420,4420,4420,4452,4452,4452,4420,6598,8810,8745,10890,17230,19376,21457,21489,21490,23602,25683,25651,25715,25683,27796,27796,27796,27796,27764,27796,27796,27796,27796,29876,27796,27796,27796,27796,27764,27764,25715,25683,25683,25683,23635,23635,23635,23635,23603,255},
{42489,42521,44602,46650,46650,46682,48730,46682,44602,42521,42489,40409,38329,34201,38329,50810,55003,52923,48730,38361,34201,30073,25913,27993,27993,30073,38329,40441,40441,42489,40441,40441,46650,48762,52955,55035,55003,55003,52955,52922,52922,50842,50810,46649,44537,42456,40376,40344,38296,42488,48762,48729,46649,46617,44569,44569,46649,48762,48730,50810,50810,50842,50842,50842,50842,52922,55035,52954,52922,50810,46649,44569,44569,44569,42521,44601,46649,46681,46649,46649,50842,52922,52922,52890,52922,52890,50810,46649,44569,48729,48729,48729,48729,48761,48761,48729,48729,44569,42488,40408,42456,46649,46617,44569,44569,46617,44569,44569,50810,50809,46649,44569,42488,42488,44536,44569,44537,44569,46617,46649,46649,21621,15315,17395,19443,17362,19409,17264,17199,17199,19311,25552,23438,15051,15019,15019,14986,31661,25127,23145,23177,25225,25225,25225,25225,29386,29418,27370,27337,27338,31531,39884,46354,50613,48337,40081,31400,25381,23367,40114,42162,29579,10725,12806,10661,16998,38032,40147,23276,16870,23276,16998,14852,10659,8547,6402,6403,6435,4355,4323,4290,4323,4322,4355,6435,4323,4323,6403,4290,4258,4258,4290,4355,4420,4420,4388,12839,12873,4485,4420,4420,8712,8842,8744,15149,19344,19409,21489,21489,21522,25683,25683,25683,27763,25683,29876,27796,29844,27796,27796,27796,27796,27796,27796,27796,27796,27828,27796,27796,27796,25716,25715,25715,25683,25683,25683,23635,23635,23603,23603,255},
{42489,42489,44601,46650,46650,46682,48730,46682,46650,44569,42521,40441,38329,34201,34201,48730,55003,52923,48762,42521,36281,32121,25945,27993,27993,30073,38329,40409,40409,40441,40409,40441,42521,44602,50842,55035,55003,55035,52955,52922,52922,50842,50842,48729,44569,42456,40376,40344,38296,42456,46649,48729,46649,46617,46649,44569,46649,48729,48729,48729,48762,50842,50842,50842,50842,52955,55035,55003,52922,48729,46649,44569,44569,42521,42521,44569,46681,46681,46681,48762,52922,50842,52922,52890,50842,50810,48697,42456,44536,46649,48729,48729,48729,48761,48761,48729,48729,46649,44536,42456,42488,46617,46617,44569,44569,46617,44569,46617,50810,50809,46649,44569,42488,42488,44569,44569,44536,44569,46617,46649,44569,25749,13267,17395,17395,17362,19409,15184,15151,15118,17230,19311,19246,19212,8746,8714,10826,33742,27207,23177,25224,25225,25225,25257,25257,29386,29418,29418,27337,27338,35692,39852,46321,46420,41965,44274,31401,29383,27529,38033,42129,29579,10725,10629,8484,17030,38033,29679,10629,19049,23307,14918,17029,12804,8547,4322,4322,8547,8547,4323,4355,6435,4355,4323,4322,6403,4355,4323,4290,4258,4258,4290,4356,4420,4420,4387,19179,8679,4518,4518,6566,10891,13004,15084,19344,23537,21457,21489,23570,23602,25683,25683,25715,25715,27763,29876,29844,27796,27796,27796,27796,27796,27796,27828,27796,29876,29876,27796,27796,27796,25716,25715,25715,25715,25683,23635,23635,23635,23603,23603,255},
{42489,42521,44569,46650,46682,46682,46682,48730,46682,42521,42521,42489,38361,36249,36281,50842,52955,52923,48762,44569,36281,36281,32153,30073,30073,32121,40409,40441,38361,38361,38361,40409,42489,44569,52923,52955,52955,55003,52955,52955,52922,52922,50842,48762,46617,42456,40376,40344,38296,40376,44569,48697,46649,46649,46681,46649,46649,48697,48697,46649,48729,50842,50842,50842,50842,55035,55035,55003,50842,48697,46649,46617,44569,42521,42521,44569,46681,48729,48729,50842,52922,52890,52922,50842,48761,48729,44537,40376,42456,46649,48729,48729,48729,48761,48761,48729,48729,46649,44569,44536,44569,46617,46617,46617,46617,46617,46617,46617,50809,50841,46649,44569,42488,44536,44569,44569,44536,44568,44569,46617,38328,17428,15315,21556,19443,17362,19409,17264,15151,15151,17231,19343,17230,19277,12939,4586,6666,31630,27174,23177,25225,25225,25224,25225,27338,29418,29450,27338,27337,27338,37772,39853,50547,52791,46224,44339,29321,25222,25415,33775,31563,33707,12805,6436,6403,19047,27531,14886,10660,14853,14917,12772,12740,19077,8579,6435,6403,6435,6467,4355,4323,6435,6435,4322,4322,6435,6435,6403,6403,4258,4290,4323,4388,4420,4420,4420,10694,4485,6599,6664,10858,13069,15182,19344,23537,23602,21457,21522,23602,25683,25715,25683,25715,25683,29844,29876,29876,27796,27796,27796,27796,27796,27796,27828,27796,29876,29876,27796,27796,27764,25715,25715,25715,25683,25683,25683,23635,23635,23635,23603,255},
{42489,42521,44569,46650,46682,46682,46682,48730,46682,44569,42521,42489,40409,38329,44602,52923,52955,52923,48762,46650,38329,32121,32121,34201,32121,40409,44601,42521,40441,40409,38329,40441,46650,48762,52955,55003,52923,52955,55035,55035,52923,52922,50842,48762,46617,42456,40376,40344,38296,40376,44536,46649,46649,46649,48729,46649,48729,48729,48729,48697,48729,50842,50842,50842,50842,55035,55035,52954,50810,46649,46649,46649,46649,42521,42521,44601,46681,48729,50810,52922,52922,52922,50842,50809,48729,46649,44536,40376,40376,46617,48729,48729,48729,48761,48761,48729,48729,48729,44569,44536,46617,46617,44569,44569,46649,46617,44569,46617,50810,52890,48729,48697,44536,44569,44568,42488,42488,44568,44569,46617,38328,15348,13267,29812,19443,17362,21457,19344,15183,15151,17231,19343,15150,8844,19311,29843,36117,42064,25094,23177,25225,23177,25225,25225,29418,29419,29418,27338,27338,27338,35724,41933,48467,52792,48402,46388,27305,23334,23401,33840,16967,16901,12740,12741,6371,16934,19111,8580,8580,14917,12805,16965,16997,21189,14884,8547,6403,6403,6403,4355,4322,6403,4355,4322,4290,6435,6403,4290,4290,4258,4258,4323,4388,4388,4387,4420,4453,6566,6697,8843,13004,15150,17263,21456,23570,21489,21489,21522,23570,25683,25683,27764,27763,25715,29876,29876,29844,27796,27796,29876,27796,27796,27828,29876,29876,27796,29876,27796,27796,27796,25715,25715,25715,25715,25683,25683,25683,23635,23635,23603,255},
{40409,42489,44602,46650,46650,46682,46682,48762,46682,44570,42521,42489,40409,38361,48762,52923,52955,52923,48762,44601,38329,30073,25913,27993,34201,42489,46682,44602,42489,40409,36281,40441,46682,44602,46682,55035,52955,55035,55067,55003,52922,52922,52922,50810,46649,42488,40376,40344,38296,40376,44536,46649,48729,50810,48729,48729,48762,48762,48762,48762,48730,50810,50842,50842,50842,52922,52955,50842,48729,46649,46649,46649,46649,44569,44569,46681,52922,52890,55003,55003,52922,52890,50842,50809,48729,46649,42456,40376,40376,46617,46681,46681,48729,48729,48761,48729,48697,46649,44569,44569,46617,46617,46617,44569,46649,46617,44569,46617,48729,52890,48729,46649,44569,44569,44536,42488,42488,44569,44568,44569,38328,17428,13235,23604,19443,15314,17297,17296,17231,17231,15151,19343,15117,2604,23570,44536,46649,41998,27142,23177,25225,25225,25225,25225,29386,29418,29386,27338,27338,27338,37772,39884,48434,52792,48402,46420,33546,23334,23368,38001,23276,8484,14821,14789,8515,12837,12805,10725,12837,14917,19077,23270,23269,16996,16996,8547,10627,6467,4354,6403,6403,6403,4322,4290,4322,4323,6371,6371,4290,4258,4290,4323,4388,4387,4387,4420,4453,6632,8810,8876,13037,15150,17262,21424,21457,19409,21489,23570,23570,25683,25683,27764,27763,27763,31956,31956,27796,27796,27796,29876,27796,27796,27828,29876,29876,29876,29876,27796,27796,27796,27764,25715,25715,25715,25715,25683,25683,23635,23635,23635,255},
{40409,42489,44569,46650,46650,46682,46682,48762,46682,44602,42521,42521,40409,40409,48762,52955,55003,52923,46682,38361,32121,27993,25913,27993,40409,42521,46650,46682,42521,40409,38361,36281,38361,38361,42521,57115,55035,55035,57116,52955,52922,52922,52923,50842,46649,42488,40376,40344,38296,40376,42456,46617,48729,50842,50842,50842,50842,50810,50810,48762,48730,50810,50842,50842,48762,50842,52922,50842,48729,46617,46649,46649,46649,44569,44569,52922,55035,52922,52955,55003,55003,52922,50842,50810,48729,46649,42456,38328,40376,46617,46649,46681,48729,48761,48761,48729,48729,46649,46617,46649,46649,46649,46649,44569,46649,46617,44569,46617,48761,50841,48729,46649,44569,44569,44536,40408,42488,44568,44569,44569,42488,25782,13267,17395,17395,19410,15217,17264,17231,17263,15151,19343,21390,8877,29844,44536,46616,43980,25094,25192,23177,25224,25225,27305,29386,29418,27338,27338,29418,27338,35691,39852,48401,52792,48370,46388,33546,23269,23207,25259,25389,6436,14853,16901,12805,12805,8580,10628,14949,17029,23269,21157,21156,16996,8547,6402,6403,6370,6403,6467,6435,4323,4323,4323,4322,4322,4322,4323,4258,4258,4290,4356,4388,4388,4420,4420,6565,6697,8843,8876,10989,15150,17230,17296,19376,19409,21490,23570,25651,25715,25683,27763,27763,27795,31989,29908,27764,27796,29876,29876,27796,27764,27796,29876,29876,29876,29876,27796,27796,27796,25716,27764,25715,25715,25683,25715,25683,25683,25683,23603,255},
{38361,42489,44569,46650,46682,46682,46682,48730,46682,46650,44570,42521,40441,40409,46682,52955,55003,50842,44602,34201,25913,25913,23865,34201,46649,44569,44601,44569,42521,44569,40441,36281,36281,36281,38361,50842,52923,55035,55035,55003,52955,52923,52923,50842,46649,42488,40376,40344,38296,40344,42456,44569,48729,52890,52922,52922,50842,50842,50810,48729,48730,50810,50810,50842,48762,48762,52922,55003,50810,46649,46617,46649,48729,44569,44569,50842,55003,52922,52922,55003,55003,55003,52954,50842,48729,46649,44536,38296,40376,46617,46681,48729,48730,48729,48729,48729,48729,48697,46649,46649,46649,48729,46649,44569,46649,44569,44569,46617,48729,50809,50809,46649,44569,46617,44568,40408,42488,44569,44569,44568,44569,36215,17395,15315,19475,19443,19377,17296,17231,15151,13070,21391,17230,4684,29811,44569,46584,39754,25094,23144,23177,23177,25225,25225,27370,29418,27338,27338,27370,27338,29450,37804,50514,52759,46289,46453,33578,19109,21160,23178,23308,6467,10692,16901,14885,12773,8516,10660,14917,23302,21156,16964,10627,12739,10659,4290,6403,6435,10659,8612,4355,6403,4355,6403,6403,4258,4258,4290,4258,4258,4291,4356,4388,4420,4420,4452,6565,6696,8842,8875,10989,15117,15182,17296,19376,21489,21490,21490,25683,25715,27763,27763,25715,29844,34037,29876,25715,27796,29876,27796,27763,27796,29876,29876,29876,29876,29876,27796,27796,27796,25716,27763,25715,25715,25683,25715,25683,25683,25683,23635,255},
{38329,40441,44569,46650,46682,46682,46682,48730,48730,46682,44602,42521,40441,40409,44569,52955,55035,52923,46682,38329,25945,25912,32121,42489,46650,46650,44569,42489,42521,46650,42489,36281,34201,36281,36281,38361,48762,55003,55003,55035,55003,52955,52955,50842,46649,42456,40376,40344,38296,40376,42456,46617,48730,52890,52922,52922,50842,50842,50810,48729,48762,50810,50810,50810,48762,48762,52923,55035,50842,46649,46649,48762,48729,44569,44601,46681,52954,52954,55003,55035,55003,52954,52922,50842,48761,50809,46617,38296,40344,46617,46681,48729,48729,48729,48729,48729,48729,46649,46649,48729,48729,48729,46649,44569,46617,44569,44569,46617,48729,50809,48729,46649,44569,44569,42488,42488,42488,44568,44568,44568,44569,36215,17395,19443,21523,17362,19377,19344,17231,15183,10990,17230,17230,4684,29876,42162,48467,39754,25094,23145,25224,23145,23177,25225,27337,27337,27338,27338,29418,29418,29451,39852,50515,50646,44176,46453,35627,21158,21192,33775,23308,6403,14885,14917,14917,12805,8580,10725,14917,23237,16996,12739,8547,6435,12772,6403,6435,6370,8547,8580,6500,4323,4355,6370,6403,4290,4290,4290,4258,4258,4323,4388,4388,4388,4420,4452,4517,6664,8810,8875,10989,13069,15215,17296,19377,21489,21522,23570,25683,25715,27795,27763,27763,29876,31957,29876,25715,29844,29876,27796,27764,27796,29876,29876,29876,29876,29876,27796,27796,27796,27796,25715,27763,25715,25715,25715,25683,25683,25683,23635,255},
{36249,40409,42489,46650,46682,46682,46682,46682,48730,46682,46650,44569,42489,40409,46682,55035,55035,52923,48730,42489,27993,32153,44569,46650,44601,46649,44601,42489,42489,46649,44569,36281,34201,34201,34233,40441,52922,55003,55003,55003,52955,52955,55003,52922,46649,42456,40376,40344,38296,40376,44537,46649,48729,48762,50810,50842,50842,50842,48762,48762,50842,50810,50810,50810,48762,50842,55003,55003,52922,48729,48729,50810,48729,44569,44601,46649,50842,55003,55035,55035,55035,52954,50842,50809,50809,50810,46649,38296,38296,46617,46649,48729,48729,48729,48729,48729,48729,46649,48729,48729,48729,48729,46649,44569,44569,44569,44569,46617,48729,50809,48729,44569,44569,44536,44536,42488,44568,44568,44568,44568,46617,34135,15315,15315,21491,17362,17329,21456,17231,15151,8910,17230,17198,6764,34004,41965,46354,37805,25094,23145,23144,23144,23145,25225,27337,27337,27338,25290,27370,29418,29418,37772,50515,50581,46257,46518,37707,29384,25289,40114,23243,8516,21192,12772,10725,10692,10692,10693,8580,21157,21157,12739,8547,6435,6435,12740,6435,4322,4322,4322,6403,4322,4355,6403,6435,6371,4258,4258,4258,4258,4355,4420,4420,4420,4420,4452,4517,6696,8778,8876,10988,15150,17264,19376,19409,21490,23570,23570,25683,25683,27763,27796,27796,29876,31957,27796,27763,29876,29876,27796,27796,29844,29908,29876,29876,29876,29844,27796,27796,27764,27764,25715,25715,25715,25715,25683,25683,25683,25683,23603,255},
{34201,38329,40441,44569,46682,46682,48730,46682,46682,46682,46650,44570,42521,46650,52923,55035,55035,52923,48762,44602,38361,40409,44569,44569,44569,46649,46682,46650,42521,44601,42521,36281,32153,34201,40409,48762,52955,52955,52955,52955,52955,52955,55003,52922,48729,44537,40376,40344,38296,40376,46617,46649,48729,48730,48729,48730,50810,50810,50810,48762,50842,50810,50810,48762,48762,50842,52922,52922,50842,48762,50810,50810,46681,44569,46649,46649,46649,52922,57083,57083,55035,52890,50810,50842,50809,50809,46617,38296,38296,46617,46649,48729,48729,48729,46649,48729,48729,48729,48729,48729,48729,48729,46649,44569,44569,44569,44569,46649,48761,50809,48729,46617,42488,42488,44569,44569,44568,44568,46617,44569,46617,36215,21588,15315,19443,19443,19409,21424,15151,13071,15150,21424,15117,25356,43979,44012,44241,33611,25127,23145,23144,23144,23177,23177,27305,27305,27305,27305,27337,27338,29418,35724,48434,48435,46387,44406,35659,31529,29547,38034,21195,12740,19206,10692,8548,12773,10693,10660,10692,19077,19076,16964,10659,4322,6435,8547,6403,6403,6467,4322,4322,6403,6435,6403,6435,4322,4258,4258,4258,4291,4388,4388,4420,4420,4453,4453,6598,6697,8810,10956,13069,17231,17296,19377,21489,21522,23570,23602,27763,27763,27763,29844,27796,31956,31956,27763,27796,29876,27828,27796,27796,29876,29908,29876,29876,29876,29876,27796,27796,27764,27764,25715,25715,25715,25715,25715,25683,23635,25683,23635,255},
{34169,36281,40409,42521,46650,48730,48730,46682,46682,46682,46682,44602,48730,52955,55035,55035,55003,50842,46650,44569,44569,40441,36281,40409,46650,48730,48762,46682,44569,44569,42489,36281,32121,36281,48762,52922,52922,52955,52955,52922,52922,52923,55003,52922,48730,44569,42456,40344,38296,42424,44569,46649,48729,48729,48729,48730,48762,50810,48762,50810,50842,50810,50810,48762,48762,48762,52890,52890,50842,50810,50810,50810,46681,46681,46649,46649,46649,50842,57083,57115,55035,50842,50842,50810,50809,50809,46649,38296,38296,44569,46649,48729,48730,48729,46649,48729,48729,48729,48729,48729,48729,48729,46649,44569,44569,44568,44569,46617,48729,50809,48729,46649,42488,42488,46617,44569,44568,44569,46617,44569,46649,36215,19475,17395,17395,19443,17329,17296,15151,15119,15183,17198,17230,33676,43814,41898,42096,35691,25126,23112,23144,23144,23144,23177,27305,27305,27337,27305,27305,27338,31531,35724,48369,48468,50744,38067,31465,16997,25355,38002,21226,17029,17060,10692,10724,14885,25419,19143,10692,10692,19076,16996,8547,6435,8515,4322,6435,8515,8547,4322,4322,6403,6435,6403,6403,4323,4258,4258,4258,4355,4388,4388,4420,4420,4485,4485,6631,8778,8843,13037,17230,17264,19376,19409,21490,21522,23602,23603,25683,27764,29844,29908,27796,31989,29876,27763,27796,27828,27796,27796,27796,29876,29876,29876,29876,29876,29844,27796,27796,27796,27764,27764,25715,27764,25715,25683,25683,23635,23635,25649,255},
{34169,36249,40409,42521,46650,46682,48730,48730,46682,46682,46682,46682,52955,57115,55035,55035,52923,48762,46649,46650,44569,40409,38329,44569,48762,50842,50842,46682,44601,46649,40441,34233,38361,50842,52955,52955,52955,52922,52922,50842,52922,52955,55003,52922,48762,44569,42456,40344,38296,42456,44569,46649,48729,48729,46649,48729,48762,48762,48762,50810,50842,50810,50810,48762,48762,48730,50810,50842,50810,50842,50842,48762,48729,50810,48729,48762,50874,52922,57115,57115,55003,50842,50842,50842,50842,50842,48729,40376,38296,44537,46649,48729,48730,48697,46649,48729,48729,48729,48729,48729,48729,48729,46649,44569,44569,44569,44569,46617,48697,50809,48729,46617,44536,42488,46617,44569,44568,44569,46617,46617,46649,34167,17395,17363,17395,17394,17297,17297,15151,13071,10990,15183,8877,29451,43815,41964,42030,35658,25094,23112,23112,23144,23144,23177,25225,27305,27305,27305,27305,27306,29418,33579,46191,46289,50777,40147,23174,14916,27435,38002,19112,17060,17060,12836,12805,10692,23340,21225,10692,8611,16996,19109,10627,14852,8579,6403,8579,6403,6403,4322,6435,6435,6403,6435,6403,4290,4258,4258,4291,4356,4420,4419,4420,4452,4485,4517,6696,8810,10924,13069,17263,17296,19376,21489,21490,23602,21522,23602,25683,27763,29876,29876,29844,31989,29844,27796,29876,27796,27796,27796,29876,29877,29876,29876,29876,29876,29844,27796,27796,27796,27764,25716,25715,27764,25715,25683,25683,23635,25650,23270,255},
{32121,36249,38361,42489,44569,46682,48730,48762,48730,48730,46682,48762,55035,57115,55035,52955,50842,48730,44601,46682,46650,42489,38329,44569,48762,52922,50842,46682,46649,48730,42521,42489,50874,55003,52955,52923,50842,50842,50842,50842,52922,55003,55003,52922,48762,44569,42456,40376,38296,42456,46649,46649,48730,48730,46649,46681,48729,48762,48730,50810,50842,50810,50810,48762,48730,48730,48762,50842,50842,50842,50842,48762,48730,48729,48729,48762,52922,55035,57083,55035,52922,50842,52922,52922,52922,52890,48729,40376,38264,44536,48729,46649,48729,48697,46649,48729,48729,48729,48729,48729,48729,48729,46649,44569,44569,44537,44569,46617,48729,50809,48697,46617,42488,40408,44569,44568,44568,46617,44569,46617,46617,36247,15347,13235,17363,17362,17297,17296,15151,15119,13070,13070,8877,29451,43782,44142,41932,33546,25094,21031,23112,23144,23144,25225,25225,25225,25225,25224,25225,27305,25257,31498,44078,46191,50679,36016,17060,12836,29580,35922,14918,17092,12867,10691,8611,8547,21227,19111,12803,10691,14884,23301,12771,12739,8515,6403,10660,6403,4355,4290,4322,6371,6435,6403,6403,4258,4258,4258,4323,4388,4420,4387,4420,4485,4485,6599,8810,8843,10989,15150,17263,17296,19409,21489,21522,23602,21522,25651,25683,27763,29876,29876,29876,31956,27764,27796,27796,27796,27796,27796,29876,29876,29876,29876,29876,29876,27796,27796,27796,27764,27764,27764,25715,25715,25715,25683,25683,25683,25617,23235,255},
{32121,36249,38329,42489,44569,46650,48730,48762,48730,48762,46682,48762,55003,55035,55003,52923,50842,46650,42489,44569,48730,48762,46650,44569,50810,52923,50842,48762,48762,50810,46682,46650,50842,52922,50842,50842,46682,46682,52922,52955,52955,55003,55003,50842,48762,46617,42456,40376,38296,42456,48729,48729,48762,48730,48729,48729,46649,48730,48730,50810,50842,50810,50810,48762,48730,48730,46681,50842,50842,50842,50810,50810,48762,48762,48762,50810,50842,52890,52922,52922,52890,52922,52954,52922,52922,50842,48729,40376,36216,44536,48729,46649,46649,48729,46649,48697,48729,48729,48729,48729,48729,48729,46617,44569,44569,44568,44569,48697,52890,48761,48729,46649,44536,40408,44568,44536,44568,44568,44569,46617,44568,42488,15380,13235,17363,17362,17329,21425,17232,15151,11022,19344,15118,35757,41702,44209,39786,37739,27175,23111,23112,25192,25192,27272,27273,27273,27272,27304,29352,29385,31433,33546,41932,48239,46452,25417,14947,8612,29613,33840,17029,17060,12868,10692,8579,8579,12773,14949,14948,16996,19076,23269,14916,10691,6402,6435,8547,6403,6467,4323,4290,4290,6435,6435,4323,4258,4258,4258,4355,4388,4420,4388,4452,4485,6566,6664,8810,10923,13037,15150,17263,19376,19409,21522,23570,23602,23570,25683,27763,27796,29876,29876,27796,29876,27764,27796,27796,27796,27796,29876,29876,29877,29876,27796,29876,29876,27796,27796,27796,27764,27764,25715,25715,25715,25715,25683,23635,25683,25616,23204,255},
{34169,36249,38329,40441,44569,44602,46682,48762,48762,48762,48730,48762,52923,55035,52923,50842,48762,46649,42489,48730,50842,50842,46682,46650,50842,50842,50842,48730,48762,48762,46682,46649,48762,50842,50842,46650,44601,46649,48762,52955,52955,52955,52922,50842,48730,46649,42488,40376,40344,44536,48730,50810,50842,50810,48762,48730,46649,48729,48730,50842,50842,50810,48762,48762,48762,48730,46681,50842,52922,50842,50810,50810,50810,50810,48762,50842,50842,50810,50810,50842,50842,52922,52922,50842,50810,48729,48697,40376,36215,42488,48729,46649,46649,48729,48729,46649,46649,48729,48729,48729,48729,48729,46617,44569,44569,44568,48729,52890,52890,50809,48697,46649,42488,40408,44536,42488,44568,44568,44568,46617,44568,44569,19540,11155,17395,17330,17297,19345,17232,15151,17263,23504,17199,31564,33415,39721,39721,39721,37640,37608,37640,37640,39721,39721,41801,41833,41833,43914,43914,45994,46026,45994,45994,46026,48402,25514,10755,12772,31661,31695,14981,17060,10692,14885,14885,10724,12772,12772,19109,16996,16964,16996,19141,8547,6403,8547,8579,6403,6435,4323,6371,4290,4323,6403,6371,4290,4258,4290,4356,4388,4388,4420,4453,4485,6598,8744,8810,10956,13069,17198,17296,19409,21489,23570,23570,23602,23602,25683,25715,27764,29876,27796,29876,29876,27764,27796,27763,27796,29876,29876,29876,29876,29876,27796,29876,29876,27796,27796,27764,27764,27764,25715,25715,25683,25683,23635,23635,23635,23602,23504,255},
{32121,36249,38329,40409,42521,44569,46650,48762,48762,48762,48762,46682,48762,52955,52923,50842,48730,44569,42489,48730,50842,48762,44569,44569,48730,46650,48762,48730,46649,44569,44569,42521,46682,50842,50842,46682,48730,48762,50842,52923,52955,52923,52922,50842,48729,46617,44537,42456,40376,44537,50810,52890,52890,50842,50842,48762,46681,48729,48762,50842,50842,50810,48762,48762,48762,48730,50842,52922,52922,52922,48762,48761,50842,50810,48729,48762,48762,48730,48762,50842,50842,52922,52922,50810,50809,48729,46617,38296,34135,42456,48729,46649,46649,48729,48729,46649,46649,48729,48729,48729,48729,48729,46649,44537,44569,46649,52890,50809,50841,50809,48697,46617,42488,40408,44536,42488,44568,44568,44568,44568,44536,44568,21621,11154,15315,23603,17329,19376,23473,15151,17231,21423,23470,25421,25127,33447,39689,39721,39721,39721,41801,41801,41801,41801,41833,43881,43881,43914,43914,45994,46026,45994,48041,48074,52628,31887,10691,12772,25454,25422,17062,17060,10724,14948,8611,12772,12805,8547,19076,16964,14884,16932,14852,6435,6435,8515,8547,6435,6435,6371,6403,4355,6403,4290,4258,4290,4258,4258,4355,4388,4387,4420,4453,4518,6598,8745,8810,10956,13037,17231,19344,21457,21489,23570,23602,23602,25651,25683,27763,27796,27796,27764,29876,29876,27796,27796,27764,27796,29876,29876,29876,29876,27796,27796,29876,29876,27796,27796,25716,25716,25715,25715,25715,25683,25683,23635,23635,23635,23603,23603,255},
{32121,36249,38329,40441,42489,44569,46650,48730,48762,48762,48762,48762,46682,52922,52923,50842,48730,44569,42489,48730,52922,50810,44569,42489,42489,42489,48730,48762,42521,40409,44569,44569,46682,50842,48762,46650,46682,48762,50842,52923,52955,52923,50842,48762,46649,46649,46649,44537,40376,44536,48729,50842,52922,52922,50842,50810,48729,48762,48762,50810,50842,50810,48762,48762,48762,50810,52922,52922,52922,50842,48761,50810,50842,48729,46649,50810,50842,48729,48761,52890,50842,52922,50810,50809,50842,48729,42488,38296,34135,40376,48729,46649,46649,48729,48729,48729,46649,48729,48729,48729,48729,48729,46649,44537,44569,46649,50842,50809,50841,50809,48729,44568,40408,40408,44568,44568,44568,44568,44536,44568,44536,44569,23733,11154,15315,19442,17297,27633,29713,10990,17231,21392,19278,25518,29320,33447,37641,39721,39721,39689,39721,39753,39753,41801,41801,41801,41833,41833,43882,43914,43914,45994,46026,48106,52595,29678,10723,10692,25518,25454,14822,14916,14949,19173,12836,10692,12772,10692,16997,21221,16964,10627,10659,6435,6403,6402,8515,6467,6467,6370,4290,6435,6435,4290,4258,4258,4258,4290,4388,4388,4388,4420,4485,4518,6631,8777,8810,10956,15117,17263,19376,21457,23570,23570,23602,23602,25683,27763,25715,27796,27763,25715,29876,29876,27796,27796,25715,27796,29876,29876,27828,27828,27796,27796,29876,27796,27796,27764,27764,25715,25715,25683,25683,23635,25683,23635,23635,23635,23603,23603,255},
{32121,34201,38329,42489,42489,44569,46650,48730,48762,50842,50842,48762,48762,52923,52890,52923,50842,44569,44569,48762,52923,50842,42489,42489,44569,46682,50810,50810,46682,44569,46650,44569,44601,48730,42489,44569,44569,46682,52955,55003,52955,52922,50842,48762,48762,48730,48762,46649,42456,42488,48729,52922,52922,52922,52890,50810,48762,50842,48730,48762,50842,50810,48762,48762,48762,50842,52922,52890,50842,50810,48729,50810,50842,46649,46649,50842,52922,48762,50810,50842,50842,50810,50809,50809,50842,48729,42456,36215,34103,40376,48729,46649,46649,48729,48729,48729,48697,48729,48729,48729,48729,48729,46649,44569,44569,48729,52922,52890,50809,48729,48729,44536,40408,42456,44569,44536,44568,42488,42488,44568,44536,46617,27894,11154,17363,17330,15217,27666,35987,10990,17230,23472,15117,23372,29320,29255,31335,31335,29287,29287,31335,31335,31335,29287,31335,31335,31335,31367,31368,31368,33448,33480,35561,35593,42128,21259,10660,16966,33839,29583,10630,14885,16997,17061,14949,12772,12804,12772,23301,16996,12707,8515,8547,6435,6435,6435,6435,6435,6467,6435,4322,6467,6467,4323,4290,4258,4258,4323,4388,4420,4420,4452,4485,4517,6663,8810,8810,10957,15150,17263,19376,21489,23570,23570,23602,23602,27763,27763,25683,27763,25715,25715,29876,27796,27763,25715,27763,29876,29876,27796,27796,27828,27796,27796,27796,27796,27796,27796,25716,25715,25715,25683,23635,23635,23603,23603,23603,23603,23603,21523,255},
{32121,34201,38329,42489,42521,44569,46650,48730,48762,50810,50842,48762,48762,52923,52955,52955,48762,44569,44569,50810,52923,50842,40441,36249,44601,48762,50842,48762,46650,46649,44569,40409,38361,42489,34201,44569,40441,46650,55035,55035,52923,52923,52922,52922,52922,50842,52922,50810,44537,42488,48762,55003,55003,52922,52922,50842,50842,50842,48762,50842,50842,50810,48762,48762,48729,50842,52890,50842,50810,48762,48729,50810,50810,46649,46649,50842,52890,52922,52922,52922,52922,52890,50809,48729,50809,48729,42456,36183,32055,40344,48697,46649,46649,48729,48729,48729,48697,48729,48729,48729,48729,48729,46649,44536,44569,50810,52890,50809,48729,48729,46617,42488,40408,42456,46649,44568,42488,42488,42488,44568,44568,46617,32054,11154,15282,17362,15217,21425,25553,11023,17262,21391,19310,25485,25127,25094,25126,25127,25126,27207,27207,27207,27207,27207,27240,27240,27207,27207,27239,29288,29288,29320,29320,27240,35757,21259,8516,14854,37968,29647,8517,14821,14917,10692,10627,16966,12773,14852,21221,14883,8547,10627,12708,6435,6435,6467,6435,4322,6435,6403,4322,6467,6435,4290,4291,4258,4258,4323,4420,4420,4420,4452,4485,4518,8744,8810,8843,13038,17231,19344,19409,21490,23602,23570,23602,23602,27763,27763,27763,25715,25683,25715,27796,27796,27796,25683,27796,29877,29876,29844,27796,27796,27796,27828,27796,27796,27796,25716,25715,25715,25683,23635,23635,23635,23603,23603,21555,21555,21555,23537,255},
{30041,34201,38329,40441,44569,44570,46650,48730,48762,50810,50810,48762,48730,52923,52955,48762,44569,42489,40409,50842,52922,52922,46650,40409,40409,50810,50842,48762,46649,46649,42489,42489,38361,32121,30073,38361,38361,46682,55035,55003,52922,52922,52922,55003,52922,52922,52922,52922,46649,44537,50810,55035,55003,52922,52922,50810,50810,50842,50810,50842,50810,50810,50810,48762,48729,48762,52922,50842,50810,50810,48729,50810,48729,44569,46649,50842,52890,52922,55003,52922,50810,52922,50842,48729,48729,46649,40376,34135,32055,38296,48697,46649,46649,48729,48729,48729,48697,48697,48697,48697,48729,48729,46649,44536,44568,50809,50809,46649,50809,48729,46617,42488,40408,42488,44568,44568,44536,42488,42488,44568,44536,46617,32022,13234,15282,19410,17297,17264,15151,13071,15182,19311,23502,29742,25127,25094,27175,27175,27175,27240,27240,27240,29288,29320,29320,29320,29353,29353,29353,29353,29320,29320,29321,27240,31499,25323,12709,12742,35920,29615,8485,12708,12772,8515,8547,23240,14885,21189,19108,16996,10691,10691,10692,6435,6435,6435,6403,6467,6371,4323,6371,4322,4323,4290,4290,4258,4290,4356,4420,4419,4420,4453,4518,6599,8777,8810,11020,15214,17263,19376,21489,23570,25650,23602,23603,23602,27763,27763,25715,25683,25715,25683,29876,27796,27796,27763,29876,29909,29876,27796,27828,27796,27796,27796,27796,25716,25716,25716,23635,23635,23635,23635,23635,23603,21555,23603,21555,21555,21523,23503,255},
{30041,34169,38329,40409,44569,46650,46650,48762,50810,50842,50842,48762,48730,50842,50842,44569,40409,36249,38361,48762,48762,50842,46682,44569,42489,46682,50842,48762,44601,44569,40441,40409,36281,25945,27993,36281,36281,48762,52955,52923,50842,50842,50842,55035,52923,50842,48762,50842,50842,46617,50842,55003,55003,52922,52890,50810,48762,48762,48762,50842,50842,50810,48762,48762,48730,48729,50810,50842,50842,50842,50810,48730,46649,44569,46649,50810,52890,52922,55003,52890,48729,52922,52922,50810,48729,46617,40376,34135,32055,38296,48697,46649,46649,48729,48729,46649,46649,46649,48697,48697,48729,48729,46649,44536,44569,48697,48729,46649,50809,48729,46649,42488,42456,44568,44568,42488,44568,44568,42488,44568,44536,46649,32022,9074,15282,15249,17297,19377,17264,11022,13103,19344,21423,23405,23112,25160,23014,23014,23014,23046,20966,23014,20966,23014,20966,23047,23079,23079,23079,23047,23112,23080,21032,18951,16903,14758,14790,16903,37968,31662,8452,10628,12773,10692,12804,12804,16997,23268,14915,19076,14916,12772,8611,6402,6435,6435,4323,6435,6435,6403,6403,4322,4258,4290,4258,4258,4291,4388,4388,4388,4420,4485,6598,6664,8810,12971,23533,19374,19376,21457,23537,25650,25683,25651,23602,23602,27763,27763,25715,25683,25715,25715,29876,27796,27763,27796,29877,29909,29876,27828,27828,27796,27796,25716,25716,25716,23668,23636,23635,23635,23603,21555,23603,21555,23603,21555,21555,21523,21522,23569,255},
{32089,34169,36281,40409,42521,46650,46682,48762,48762,50842,48762,48762,48730,46682,46682,44570,38329,34169,34201,44569,42521,40409,42521,42489,44601,48730,50810,46682,44569,44569,44569,44601,42489,28025,27993,34201,36281,48762,52922,50842,48730,48762,50810,52922,50842,50842,48762,50810,50842,46649,48762,52955,52922,52922,50842,50842,48730,48729,50810,50842,50842,50810,48762,48762,48762,48730,46681,48762,50842,50842,50810,48729,46649,46617,46649,48729,50810,50842,55003,50842,48729,50810,52922,50810,48729,44536,40376,36215,32055,38296,48697,46649,46649,48729,48729,46649,46649,46649,46649,48697,48729,48729,46649,44536,44569,48729,48729,46617,50809,48729,44569,42488,42488,44568,44568,42488,44568,46617,44568,44536,44536,46617,29942,9074,13202,15249,15249,17296,17264,13071,13103,21424,19342,19309,17131,23210,20869,20869,16773,27436,29713,25519,27599,17031,19110,19078,16966,27401,29515,12740,12709,12677,8484,14693,8581,6404,6403,14790,37969,27534,6404,12740,16997,12836,10692,12804,19076,25380,16995,17027,12803,10659,10627,8547,8515,8515,6435,6370,6467,6467,6435,6435,4290,4258,4258,4258,4323,4388,4420,4420,4452,6566,6631,8777,8843,15084,29744,19311,21424,21489,23570,27731,25683,25683,23570,25683,27763,25683,25683,25683,27764,27796,29876,27796,27763,29876,29909,29876,27828,27828,29876,27796,27796,25716,25716,23636,23635,23635,21555,21555,21555,21555,21555,21555,21555,21523,23602,23569,23570,27595,255},
{32089,34169,36281,40409,42489,44602,46682,48762,48762,48762,48762,48762,48730,46650,46650,44569,38329,34201,32121,38361,44569,36281,36281,38329,44601,48730,48762,46649,40409,40409,42489,44601,38361,32153,32121,38329,38361,42521,44602,46650,46650,48762,48762,48762,50842,50842,50842,50810,48730,46649,48729,52922,52922,50842,50810,50810,48762,48762,48762,50810,50810,50810,50810,48762,48762,48730,46681,46681,50810,50842,48762,48729,46617,46649,46649,46649,50810,55003,55003,50842,46649,48761,48761,48729,46617,42456,40376,36216,34135,40408,48729,46649,46649,48729,46649,46649,46649,46649,46649,48697,48729,48729,46649,44568,44569,46649,48729,48729,50809,48697,46617,42488,44536,46617,46649,44536,44568,44568,44536,44568,42488,46617,27862,9075,15283,17330,15249,19344,21425,17231,15183,21392,19310,17197,17132,12874,14889,27566,25487,27502,38262,36085,29744,14886,23302,23335,16997,39981,35885,12740,8515,8548,6436,18886,10629,10726,8549,14823,38033,27502,8484,16965,14948,10659,8547,12771,19075,19076,14851,14883,12803,8579,8579,8579,6467,8579,6467,6403,6403,6435,4323,4323,4323,4258,4258,4290,4356,4388,4420,4452,4485,6599,8712,8810,10923,13037,17230,19344,21457,23537,25650,27763,27731,25683,21522,25683,27764,25683,25683,25715,29876,29908,29909,27764,27796,29876,29909,29876,27796,27828,27828,27796,25748,25716,23636,23635,23635,23635,21555,21555,19475,21555,21555,21555,21555,23537,23402,21256,21256,23363,255},
{30041,34169,36281,40409,42489,44602,46682,48762,48762,48762,48762,48762,48730,46682,46650,42521,38329,34201,30041,34201,46682,42489,32121,27993,38329,44569,44569,46649,42489,38329,36281,42489,36281,32153,36281,42521,44569,36281,36281,40409,44601,48730,48730,48762,52922,50842,50842,48762,48762,48762,50842,52922,52922,50842,48730,48730,48729,48762,48729,48762,50810,50810,50810,48762,48730,46682,46682,46649,48762,48730,48730,48729,46649,46649,46649,46681,52922,52954,52890,48729,48729,48730,48729,46617,42488,40376,40376,38296,36215,46617,48729,46649,46649,46649,46649,46649,46649,46649,48697,46649,46649,48697,46649,44536,44569,46617,50809,52890,48729,46649,46617,44536,46649,46649,46649,44536,44536,44536,44536,44568,42488,44568,29942,6994,9042,13169,17297,17296,17296,17263,15183,17231,19277,17165,19244,15051,12970,23471,25488,14858,21261,31859,31890,17098,21191,23271,21190,29577,29577,14917,14886,10725,8548,16838,8516,10693,6436,16903,40082,29549,19081,14884,10724,10659,6499,12771,21219,17028,12803,12803,12803,8579,8547,6435,10627,10723,6403,4355,4355,6467,4322,4323,4323,4258,4258,4291,4388,4388,4420,4453,4485,6631,8745,8843,10956,13037,17231,19376,21489,23570,25683,27763,27763,23603,21522,25683,27764,25715,23603,27796,29876,29877,29876,27796,27796,29877,29909,27828,27796,27828,27828,27796,25716,23636,21588,21587,21555,21555,21555,19475,19475,21555,21555,23569,25549,27561,23301,19109,21252,21248,255},
{27992,32121,36249,40409,42489,44569,46682,48762,48762,48762,48762,48762,48762,46682,46682,44569,38361,34201,30041,25912,36249,34169,32121,25913,25912,38361,36281,34201,38329,34201,34201,34201,34201,40409,42489,42489,42489,36281,36281,40441,44601,48730,48730,48762,50810,50842,50842,50874,50842,52922,52922,52922,52922,50810,48729,46649,46649,46681,48729,48762,50810,50810,50810,48762,48730,46681,46681,46649,46649,46649,48730,48730,46649,46649,46649,48729,52922,50842,48729,46617,46649,48761,46649,46617,42488,40376,42456,42488,40408,48697,48729,46649,46649,46649,46649,46649,48697,46649,48697,48697,46649,48697,46649,44536,44569,44568,48697,50809,48729,46649,44568,46649,48697,48729,46617,42488,44536,44536,44568,44568,44536,44568,32054,6994,11122,15249,17297,17296,17264,17263,15183,19343,19277,15052,19211,17098,17066,15017,14922,16971,29778,31923,42423,38230,17032,19014,21222,27558,21222,16997,12806,12805,8548,6436,6468,8613,6468,21096,40114,25420,12773,10692,10724,12836,10691,14883,23300,19076,14883,14916,10659,16996,8579,8547,10627,12804,6403,6403,6467,6403,6403,6435,4323,4258,4258,4291,4388,4388,4452,4485,4518,6664,8777,8843,10956,15117,17263,19376,21489,23570,29844,27763,27763,25651,23602,25683,27763,25683,23603,29876,29876,29877,27828,27796,27828,29876,29877,27828,27828,27828,27828,25748,23668,21587,19507,19507,19507,19507,19475,19475,19475,21523,25615,25415,23236,19075,14883,14883,19170,17057,255},
{27960,32089,36249,38361,42489,42521,46650,48730,48762,48762,48762,48762,48730,48730,46682,44601,40409,36249,30073,23864,23832,23864,30041,27993,23864,27993,30041,25912,25912,30041,32153,34201,34201,40409,40409,38329,36281,34201,36281,42521,44601,46682,46682,48730,48762,50842,50842,52922,52922,52922,52955,52954,52955,50842,46649,46649,46649,46649,46681,48762,50810,50810,50810,48762,48762,46682,46681,44601,44569,44569,46649,48730,46681,46649,46649,46681,48761,48762,46649,44569,46617,46649,46649,46649,46617,44569,44569,48697,48697,48729,48729,46649,46649,46649,46649,46649,46649,46649,48697,48697,48697,48697,46649,44536,44568,44568,44568,48697,48729,44568,44568,48697,48697,46649,44568,42488,44536,44536,44568,44536,44536,44568,29974,6994,15282,13169,17297,19377,17264,17296,15183,19344,19278,15085,21323,17162,17097,17129,17035,19115,34004,31923,40310,42391,23438,12805,23399,27590,19109,12805,10660,8580,6436,4323,10661,10693,10693,25450,40115,19144,12804,10692,12836,14916,8579,14851,23332,21189,17028,10659,10627,14884,10691,8515,6435,8547,6403,4323,6435,4290,4290,4323,4290,4258,4258,4323,4388,4387,4420,4453,6566,6664,8810,8843,10956,15150,17263,21457,21489,25650,36117,27763,27731,23570,23603,25683,27796,25683,23603,29876,27796,29909,27828,27796,29876,29876,29876,29876,29876,27828,27796,23668,23636,21555,19507,19507,19475,19475,19475,19475,19475,23568,23334,21187,16995,14851,16963,19106,21249,14976,255},
{27960,30041,34169,38329,40441,44569,46650,48730,48762,48762,48762,48730,46682,46682,46682,44601,40441,36281,30041,25912,23864,23832,27993,27961,23864,21784,23864,23864,25945,32121,34201,40409,34201,32121,32121,32121,30073,32121,32153,38361,44569,46650,46682,46682,48762,50842,52922,55035,55003,55003,55003,52922,52922,50842,46649,46649,46649,46649,48729,50810,50842,50810,50810,48762,48762,48730,46681,44601,42521,42521,46649,48729,46681,46649,46649,46649,46681,46681,46681,46649,46649,46617,46649,46649,46649,46649,48729,48729,50809,48761,48729,48729,46649,46649,46649,46649,46649,46649,48697,46649,46649,48697,46617,44536,44568,44568,44568,46649,48729,46649,46617,48729,46649,44568,44536,42488,42488,46617,46616,44536,44536,44568,29974,9042,13202,17330,21457,19344,17264,17296,13103,15183,21390,19245,21323,21354,19178,19177,17067,14890,27630,19178,19180,36051,40342,21355,19206,21254,14885,8612,8580,6468,6404,4356,6468,8581,10724,27562,38034,19110,14916,14917,14916,12836,10723,12771,25380,23269,14852,10691,8547,8547,8547,4322,6467,6403,6403,4323,4322,4291,4290,4258,4258,4258,4258,4323,4387,4387,4420,4453,6566,6664,8810,8843,10957,15150,19344,21489,23570,29713,31859,27764,25683,21522,25683,27796,29876,25715,27764,27796,27796,29876,29876,29876,29876,29876,29876,29876,29876,27828,27796,23668,23636,21555,19475,19475,19475,19475,17427,17427,21522,25514,23300,19106,14914,14851,19074,19168,19074,16962,255},
{25912,32089,34169,36281,40409,44569,46650,48730,48762,48762,48730,46682,46682,46650,46650,44602,42489,38329,32121,27993,23832,23832,32121,32121,23864,21784,21784,23864,23864,27992,34201,38329,32121,30073,30073,27993,30073,32121,32121,36281,42521,46650,46682,48730,48762,50810,50842,55035,55035,52955,52922,50842,52890,50810,46649,46649,46649,46649,48729,50810,50810,50810,50810,48762,48762,48730,46681,44601,42521,44569,44569,46649,48729,46649,46649,46681,46681,46681,46681,46649,46649,46649,46649,46649,48729,48729,48729,48729,50809,48761,50809,48729,46649,46649,46649,46649,46649,46649,48729,48697,48697,48697,46617,44536,44568,44569,44569,46649,48729,46649,46617,46649,44568,44568,44568,42488,44536,48697,46616,44568,44536,44568,27862,6994,9042,19410,25618,19376,15184,15183,17263,15183,17229,15084,15018,19242,19209,12937,12809,14857,21224,12807,8615,21324,40343,40310,29776,14949,10724,8612,8580,6436,8548,8580,6404,8548,17091,29610,33840,12804,12804,16997,14916,12835,8611,10691,21220,19140,12772,10659,8579,6467,6403,6403,6467,6403,4290,6435,4323,4291,4323,4258,4258,4258,4259,4355,6533,4420,4452,4485,6599,6697,8810,8876,13069,17263,21425,23570,25650,25651,25618,27796,25683,23602,25683,29876,27828,25715,27796,25715,29876,29876,27796,27828,29876,29876,29876,29876,27828,27796,25716,21588,21588,19507,19507,19475,17427,17427,17427,19475,23569,25447,21219,21187,19107,12803,14883,17057,16995,16962,255},
{23832,30041,34169,36281,40409,42521,44602,46682,48730,48730,46682,48730,48730,46682,46650,44602,44569,40409,32121,30041,23832,21784,32121,38361,27993,23864,21784,23864,23864,23864,32121,30041,34201,32121,32121,30073,30073,30073,32153,38361,42521,46649,46682,48730,48762,48762,50842,55003,52955,52922,52922,50842,50842,50810,48729,46649,46649,44569,48729,50842,50810,50810,50810,48762,48762,48730,46681,46649,44569,44569,42521,44601,46649,46649,46649,46681,46681,46681,46681,46649,46649,46649,46649,48729,48729,48729,48729,50777,50809,48729,50809,48729,46649,46649,46649,48697,46649,46649,48729,48729,48697,46649,44569,44536,44569,44569,44568,46617,46649,46617,46649,48697,46649,46617,46649,42488,46616,48697,46648,44536,44536,44568,25781,4914,11122,19410,19377,21457,17264,15184,15183,15151,17197,17196,17163,19275,17097,14985,14986,14921,17064,8647,6534,17131,40310,40342,36047,14949,10724,8612,6468,8612,14917,12804,6403,12868,17059,27499,35953,10692,12772,17028,14916,14915,10659,10659,19108,23365,17029,10659,8515,6467,6403,6403,6403,4323,4290,6403,6435,6403,6403,4290,4258,4258,4291,4422,23406,10825,4485,6566,6664,8778,8876,10989,17231,19376,23570,25650,25683,27764,29844,29876,27764,23603,27764,29876,27828,23603,27796,25715,29877,29876,27828,27828,29876,29876,29876,29876,27828,27796,23636,21588,21555,19507,19475,19475,19475,17395,19475,19475,25614,23301,23300,21187,17027,10692,12772,14883,19137,19169,255},
{21784,27960,32121,36249,40409,42489,44569,46650,46682,46682,46682,48730,48730,46682,46649,44602,44569,40441,34169,27960,21784,19736,19704,30041,30041,23864,21784,21816,27993,30041,36281,36281,42489,40409,34201,30073,30073,30073,32153,40409,44569,44601,46649,46650,46682,46682,48730,52922,52955,52922,52922,52922,50842,50810,46649,46649,46649,44537,46681,50842,50810,50810,50810,48762,48729,46682,46682,46649,44601,42521,42521,44569,46649,46649,46649,46649,46681,46681,46681,46681,46649,44601,46649,48729,48729,48730,48729,50809,50809,48761,50809,48729,46649,46649,48729,48729,46649,46649,48729,48729,46649,46617,44569,44536,44568,44569,44569,46616,46649,48697,48697,48697,48697,46616,46649,44536,48697,48697,46616,44536,44536,44568,25749,4946,11122,21491,19377,21425,17264,13103,13103,17232,21389,19277,21356,17131,12840,12872,17002,12808,10759,10760,10793,25584,40343,40343,34001,21318,14917,10660,8580,14981,17029,12836,6435,14979,17059,29611,35953,14917,19141,19141,12836,10659,8547,6402,17028,19172,16996,14916,10691,6435,6403,6403,8515,6403,6403,6371,6403,6403,6403,4290,4258,4258,4324,8682,25519,8680,6566,6632,6730,8876,10989,15183,19376,21489,25650,25683,27763,29844,29876,29876,25715,25683,29876,29876,29876,23635,27764,27796,29909,29876,27796,29876,29876,29876,29876,29876,27796,25716,21556,21555,21587,19507,19507,19475,19475,19475,19475,19475,25615,25382,25412,16995,17027,12805,12805,17027,21280,19105,255},
{21784,27960,30040,36249,38361,42489,44569,44602,46650,46682,46682,48730,48730,46682,44601,44601,44569,42489,34201,25912,21784,19704,19704,19704,23864,27992,21784,21816,27993,32121,42521,44569,46649,42521,32153,30073,30073,27993,34201,42489,44569,44569,44601,46650,46682,46682,48730,52922,52955,52922,52922,52922,52922,50842,48729,46649,46617,42488,46617,50810,50810,50810,50810,48762,48730,46682,48730,46681,44601,42521,42521,44601,44601,46649,46649,46649,46681,46681,46681,46681,46649,44601,46649,48730,48730,48730,48729,50809,50809,48761,50809,48729,46649,48729,48729,48729,46649,46649,48729,48729,46617,44568,44569,44569,44568,44569,44569,46616,46649,46649,48697,48729,48697,46617,46649,44536,48697,48729,46616,44536,44536,42456,19508,6994,9074,17330,19378,17232,13071,15183,13103,19344,23502,21325,17195,15050,14986,14986,17002,12776,8679,17164,31923,40343,40343,42424,33936,21348,17030,16998,10660,17061,17029,10692,8580,17059,15011,31692,31791,14884,21189,17028,12804,8579,6435,6435,19077,14948,6434,19109,16996,6435,6435,8515,6371,6371,6467,6403,4323,4322,4323,4322,4258,4290,4388,8680,17099,6534,6599,6697,8844,10989,13135,17296,21489,23570,25683,27763,27796,29844,29876,27796,27764,27764,29876,29844,29876,23635,25715,29877,31957,29876,27796,29876,29876,29876,29876,27828,27796,23668,21555,21555,21555,19507,19507,19475,19475,19475,19475,21523,25547,25446,21252,17028,17029,12804,12803,21217,17025,16962,255},
{19704,27960,30041,34169,38329,40409,42489,44569,46650,46650,46682,48730,48730,46682,46650,44602,44602,42489,34201,25912,19704,19704,19704,19704,19736,21784,19736,21816,23864,36281,46650,48730,48730,44569,34201,30073,27993,25945,34201,42489,42521,44569,44601,46682,48762,50842,50810,50842,52922,52890,52922,52922,52922,52922,48729,46649,44569,42456,44569,50810,50810,50810,50810,48762,48730,46682,48730,46681,44601,42521,42521,44601,44601,44601,46649,46681,46681,46681,46681,46681,46649,44601,46649,48730,48729,48730,48729,50809,50809,50809,48761,48729,46649,48729,48729,48729,46649,46649,48729,48729,46617,44568,46649,46617,44568,46617,46617,46616,46649,48697,48729,48729,46617,44568,46649,44536,48696,48729,46616,44536,44536,40376,17428,11154,9074,13201,15217,23473,11023,17264,11023,17263,21389,15019,17099,17130,19243,17066,14952,12808,10792,15019,36084,40310,40343,42423,40342,21322,12773,29645,23371,17029,17029,14884,14916,14980,12867,31693,23304,10627,14885,14948,10724,6467,6435,10628,14885,17028,6499,12771,17028,8547,10660,8579,4322,6403,6435,6403,4322,4387,4354,4355,4290,4291,4387,6533,6566,4486,6696,6763,8909,13102,15215,19376,23538,25650,27763,25715,27796,29844,29844,27796,27796,27764,29876,29876,27828,23603,25715,29909,29877,27828,27796,29909,29876,29876,29876,27828,27796,23636,21555,21587,21587,21555,21555,19507,19475,19475,19475,21522,25481,23301,25413,21187,16995,16996,21218,19136,14913,10690,255},
{17624,25880,30041,34169,36249,40409,42489,44569,44602,46650,46650,46682,48730,46682,46650,46650,46650,42521,36249,25913,19736,19704,19704,19704,19704,17656,17656,21784,30040,44601,48762,48762,48762,42521,34201,30073,28025,25945,30073,38361,42521,44601,46650,48762,50842,50842,50842,50842,50842,52890,52922,52922,50842,50842,48729,44569,44569,40408,44537,50810,50810,50810,50810,50810,48730,48730,48730,46682,44601,42521,42521,44601,46649,44601,46649,46681,46681,48729,48729,46681,46649,44601,46649,48729,48729,48729,48729,50809,50809,50809,50809,48729,46649,48729,48729,48729,46649,46649,48729,48697,46617,46616,46649,46617,44568,46617,46617,46617,48697,48697,48729,48729,46616,44536,44568,42488,48697,48729,46616,44536,44536,40376,19476,15315,11122,17330,21457,25553,15152,13104,10991,21424,21390,19245,19179,21354,17098,14954,19145,12808,8647,12938,36085,40310,40375,42423,42423,23404,12838,35888,40212,21192,19109,14916,14916,14948,17092,29610,14916,8579,14884,14916,10659,6467,6403,14821,16933,19141,10659,6435,14916,10755,10691,6402,4355,4322,4322,4323,4322,4387,4355,4323,4290,4323,4388,4452,4518,6631,6729,8843,8941,13102,15215,19376,21489,23602,25683,25715,27764,27796,27764,29876,27796,25715,27796,31957,27796,23635,27796,29909,27796,27796,27828,29909,29876,29876,29876,27828,25716,21588,19507,19507,21555,21587,21555,19475,19475,19507,19475,21555,27595,21188,23268,16995,14917,14916,19074,17024,14849,12770,255},
{17624,23832,27960,34169,36249,40409,40441,42489,44569,46650,46650,46682,46682,46650,46650,46650,44602,44569,38329,27961,19736,17656,19704,19736,19704,17656,17656,17656,27992,46650,50810,48730,48730,44569,34201,30073,30073,30073,32121,36281,42489,44601,46682,48730,48762,50842,50842,50842,50842,50842,52922,50842,50810,50810,46649,44537,44537,40408,44569,50810,50810,50842,50842,50810,48762,48730,48730,46681,44601,42521,42521,44601,46649,44601,46649,46681,46681,48729,48729,46681,46649,44569,46649,48730,48729,48729,48730,50809,50809,50809,50809,48729,46681,48729,48761,48729,46649,46649,48729,48697,46617,46617,48697,46617,44568,46617,46617,46617,46649,46649,48697,48729,48697,44568,44536,42488,48729,48729,44568,44536,44536,40376,15347,13235,17363,27699,25586,13136,13104,13104,6863,17263,19277,19278,17164,21322,14986,12841,17033,14952,12904,12873,33971,38198,40343,42391,31856,14951,10661,33807,38132,23272,17029,10659,10660,10724,17061,29644,16999,6467,10660,14852,12804,8547,6403,10595,19077,19076,12804,8547,12836,10723,8611,6403,4290,4322,4355,4355,4355,4355,4291,4290,4291,4355,4420,4453,4518,6632,6730,8876,8909,11022,15183,17296,21457,23570,25651,27763,27763,27796,25683,29876,25715,27796,29844,31957,25716,23635,27796,29909,27796,27796,29876,29909,29876,29876,27828,27796,23636,21556,19507,19507,21587,23635,21587,19507,21555,21555,21523,21555,23502,19241,21188,12834,12803,14915,21091,23267,17059,14915,255},
{17624,23832,27960,32121,36249,38329,40409,42489,44569,44602,46682,48730,46682,46650,44601,44602,44601,44569,38361,30041,19736,17656,17656,19704,19704,19704,17656,17656,23864,40409,42521,46649,46649,44569,34201,32153,32153,36281,38361,40441,42521,46650,46682,46682,48762,50842,50842,50842,50810,50810,50810,48762,50810,50842,46649,44537,42489,42456,46649,50810,50810,50842,50842,50810,48762,48729,48729,46681,46649,44569,42521,44601,46649,44601,46649,46681,48729,48729,48729,46681,46649,44569,46681,48730,48729,48729,48729,50809,50809,50809,48761,48729,48729,48729,48729,48729,46649,46649,48729,48697,46649,46649,48729,46649,44568,46617,46617,46616,48697,46649,48729,50809,48729,46616,44536,44536,50777,48697,44536,44536,44536,38295,17395,15315,15282,25619,23538,11055,13136,8943,8943,15150,17197,19278,15052,21290,17098,17065,14920,14857,14889,14857,21293,33972,40343,40375,29809,10758,10629,33840,36019,18952,12773,14918,10660,10724,10725,33807,31694,10692,10627,16933,14916,10691,6467,14852,21221,16964,12804,10627,6467,6435,8547,6467,4355,4355,6467,4355,4323,4355,4323,4258,4291,4388,4420,4485,4518,6632,6730,8843,8908,10990,15183,17296,19409,23570,25650,25683,27763,27763,25683,29876,25683,29844,29876,31957,31989,25683,29876,31957,29876,29876,31957,29876,27828,29876,27828,25748,21588,21556,19507,21555,21587,23635,21555,19475,21555,19507,19475,19475,21522,23569,21321,19107,14948,19077,25252,23266,17058,12771,255},
{15576,23832,27960,32089,36249,38329,40409,40441,42489,44569,46682,48730,46682,44602,44569,44601,44601,44569,40409,32121,21784,17656,17656,19704,19704,19704,17656,17656,19736,30040,34201,38329,44569,42489,38361,36281,34201,34201,40441,42489,44569,46650,46650,46682,48762,50842,50842,50810,50810,50810,50810,50810,50842,50810,48762,48729,46649,44569,48729,50810,50810,50842,50810,50810,50810,48762,48730,46649,46649,44569,42521,44601,46649,44601,46649,46681,48729,48730,48730,46681,46649,44569,46681,48730,48729,48729,48729,50809,50809,50809,48761,48729,48729,48729,48729,48729,46649,46649,46649,46649,46649,48729,48729,46617,44569,46616,46617,46616,46649,48729,50809,50809,48729,44536,42488,42488,48729,46616,44536,44536,42488,40408,17428,15315,11154,15250,19377,11023,6895,8943,13104,19311,21389,23439,23436,19178,17098,14985,14888,12776,8647,6503,14987,33972,40343,40343,40375,17161,8580,29615,33939,8485,19049,36018,19144,14917,10693,33807,33776,14854,12772,8580,6435,10691,10659,19077,23301,14884,12772,8515,6403,6403,4323,6435,6403,6435,6467,4355,4322,4355,4323,4290,4291,4388,4420,4485,4518,6632,6729,8843,8876,10989,13102,17264,19377,23570,25651,27763,27796,25683,25683,29877,23635,27796,34037,34004,35987,27535,29877,31957,29876,29909,29909,29876,29876,29876,27828,25716,21588,21556,19507,21555,21555,21555,21555,21555,19507,19475,19475,19475,19475,19442,21389,21287,19044,25253,27300,27397,21220,14916,255},
{13528,21784,27960,30040,34169,36281,38329,40409,42489,44569,46682,48730,46682,44601,44569,44601,44601,44569,40409,34201,23832,19704,17656,17656,19704,19736,19736,17688,21784,27992,32121,38361,46650,44569,42489,40409,36281,36281,40441,40441,42521,44601,46650,48730,50810,50842,50842,50810,48762,50810,50842,50842,48730,50810,50842,50810,48762,48762,50810,50842,50810,50810,50810,50810,50810,48762,46681,46649,46649,44601,44569,46649,46649,46649,46649,46681,48729,48730,48730,48729,46649,44569,46681,48762,48729,46681,48729,50809,50842,50809,48761,48730,48729,48729,48761,48729,46649,46649,46649,46649,48697,50777,48729,44568,46617,46649,46616,46617,48697,50809,50809,50809,46649,42488,42456,44536,50777,46616,44536,44536,42488,42488,19508,15283,17330,15250,17329,15216,6863,11024,13104,21423,17164,21357,23403,17131,14986,15017,12808,8583,6502,6566,8712,31891,40311,40343,40310,19208,10692,29615,33906,6404,21162,29714,17002,19177,21258,35920,29583,16934,10691,12772,8612,10660,8579,23333,19109,14852,6403,6435,6403,6371,4323,4355,4323,6435,6467,6403,6403,4322,4290,4258,4323,4420,4420,4485,4518,4584,6730,6795,8876,10989,13103,15216,21457,23570,25683,27796,29844,23603,29844,29909,25683,29876,34037,34037,41903,27372,31989,31957,29876,31957,29909,29876,27828,27828,27796,25716,21588,21556,19507,19507,21555,21555,21555,21555,19475,19475,17395,17395,17394,17394,17394,19374,25353,27302,27302,27366,21223,14951,255},
{13496,21752,25912,30040,32121,36249,38329,38329,40409,42521,46650,48730,46682,44601,44569,44569,44569,42489,40409,36249,25912,19704,17656,17656,17656,17656,19704,17656,19704,19736,27992,44569,46650,44569,42489,42489,38361,40409,42489,42489,42521,44569,46649,48730,50842,50842,52890,50842,48762,50810,52922,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50810,50810,50810,50810,48762,46682,46681,46649,44569,44601,46649,46649,46649,46681,46681,48729,48730,48730,48729,46649,44569,46681,48762,48729,46681,48729,50809,50842,50809,48761,48729,48729,48729,48761,48729,46649,46649,46649,46649,48729,48729,46649,44536,44569,46616,46616,46649,48697,46649,48729,48729,46616,42456,42488,46648,50777,46616,44568,44536,42488,44536,25813,17363,23507,19378,23603,15217,11023,11024,8943,21424,15085,23438,19244,15019,19179,19178,12776,10664,12839,10791,10824,31891,38263,40343,38262,17063,12774,38099,29713,6404,8485,8582,8583,25519,34003,29647,25324,14853,17028,12836,10692,8515,8515,23269,16996,8547,6435,6435,6467,4355,4323,6435,6435,6435,6499,6435,6435,4291,4258,4291,4388,4420,4452,4485,4550,6664,6762,6796,8909,13070,15183,17296,21490,25683,27796,29876,29876,25715,34037,29877,25715,31957,34069,36117,35791,27730,31989,31957,29909,31957,29909,29876,27828,27828,25748,23668,21588,19507,19475,19507,21555,19475,19475,19475,17427,17395,17395,17362,17362,17362,17394,23472,29482,27237,25285,21188,16999,14985,255},
{11448,21752,25912,27960,32089,34201,36249,38329,40409,42489,46649,46682,46682,44601,44569,44569,44569,42489,38361,36281,27992,19704,17656,17656,17656,17656,19704,19704,19704,17656,19736,36281,46617,44569,42489,42489,40409,40409,42489,40441,42489,42489,44569,48730,50810,50842,52890,50842,48762,48762,50842,52922,52922,50842,50810,50842,50842,50842,50842,50810,50842,50842,50810,50810,50810,48762,46681,46681,46681,44601,44601,46649,46649,46681,46681,46681,48729,48730,48730,48729,46649,44569,46681,48762,48729,46681,48730,50809,50842,50809,48761,48729,48729,48729,48761,48729,46649,46649,48697,46649,48697,48697,46617,44568,44569,46616,46616,46649,48697,46649,48697,48729,44568,42456,44536,46616,48729,44536,44536,42488,42488,44536,32022,13203,23539,17298,17297,13136,13136,13104,13071,25552,21391,27664,19277,15019,17067,17033,12776,8551,10727,8615,8680,29778,38262,40343,40375,19210,12742,38099,27633,4356,6437,4356,8582,27665,38198,33874,25388,19077,16965,12772,10659,10596,10692,16997,16996,8547,8515,6435,6403,6403,4355,6435,6435,6403,6467,6403,6435,4291,4258,4323,4420,4420,4485,4518,4583,6697,8876,8909,11022,15183,17328,21490,25683,27796,31956,34069,38066,31761,34069,29876,25683,34069,34069,34037,34004,34037,34037,31957,31957,31957,29909,29877,27828,27796,25748,23668,21588,19507,19475,19475,19475,19475,17427,17395,17395,15346,15314,15314,17362,17362,17362,23439,25355,27366,19106,12833,10754,10691,255},
{7352,19704,25880,27960,30041,34169,36249,36249,38361,42489,44601,46682,46682,44602,44569,44569,44569,40441,38329,36249,30041,19736,17656,17656,17656,19704,19704,19704,19704,17656,19736,32121,40409,42489,44569,42489,42489,42489,42489,40441,40409,42489,44601,48762,50842,50842,52890,50842,50842,50810,52922,52890,52890,50842,50842,50842,52890,52890,50842,50842,50842,50842,50810,50810,50810,48762,48730,48729,46681,44601,46649,46649,46649,46681,46681,46681,48729,48730,48730,48729,46649,44569,46681,48730,48729,48729,48762,50809,50842,50809,48729,48729,48729,48729,48729,48729,46649,48729,48729,48729,48729,48697,46649,44568,44569,46649,46616,46649,48697,46649,46649,48697,44568,42488,44536,46649,46648,44568,44536,44536,42488,44536,27862,9074,11122,15250,21490,13104,13104,11056,15151,27633,15053,21325,17131,14987,12873,14953,10696,6535,10728,8615,6599,27665,40311,40343,42456,25615,10661,38066,27632,14889,19148,12841,14954,31858,40278,40180,21258,10723,12739,10659,12740,10628,10660,14916,19108,12803,12771,8579,4355,4355,4355,4322,4323,6435,6499,6435,4323,4323,4291,4355,4420,4452,4518,6632,6730,8876,11022,13135,15248,19409,21522,25651,27796,31957,34069,38197,46126,31760,34102,29876,27796,34069,34069,34037,34037,34069,31989,31989,31989,31989,29877,29877,27828,27796,25716,23636,21556,19507,19475,19475,17427,17395,17395,15315,15314,15314,15314,15314,15314,15314,15314,21359,29546,19171,8641,8610,8610,6466,255},
{5272,15576,23832,27960,30040,32121,34201,36249,38329,42489,44569,46682,46682,46650,44569,44569,44569,42489,38361,36249,30041,21784,17656,17656,17656,17656,19704,19704,19704,17656,19736,27992,38361,40409,42489,40409,40441,42489,42489,40441,40409,42489,46682,50810,50842,50842,52890,52890,50842,50842,50842,50842,50842,50842,50842,50842,52890,52922,50842,50842,50842,50810,50810,50810,50810,48762,48729,48730,46681,46649,46649,46649,46649,46681,46681,46681,48729,48730,48730,48729,46649,44569,46681,48730,48729,48729,48762,50809,50842,50810,48730,48729,48729,48729,46649,46649,46649,50842,50809,48729,48697,48729,46649,44569,44569,46649,46616,46649,48697,46649,46649,46649,46649,46617,44568,48697,46649,44568,44568,44536,42488,44536,21589,4914,9074,17298,17330,13104,13104,8943,15118,23471,21358,21324,19244,19243,12873,15017,12840,10760,12872,10792,10824,25584,40311,40343,42455,34003,14886,40146,27633,12808,10663,8550,10728,31858,40310,33906,25415,17027,10691,10659,6403,10627,19108,19140,12836,14948,19108,16964,8611,6499,6467,6402,4354,6403,6435,6403,4323,4290,4258,4356,4388,4485,4617,6762,8909,13103,15216,17329,19409,21522,23603,27764,29876,34037,36150,36150,36117,34101,36150,27892,29908,34069,34069,34037,34069,34069,31989,31989,31989,31957,29909,29877,27828,27796,25716,23636,21588,19475,19475,17427,17395,17395,15315,13266,13234,13266,13234,13234,15282,15314,15314,21457,31689,21219,8578,8642,6498,8578,255},
{3224,11448,19704,25912,30040,32121,34201,36249,38329,40441,44569,46682,48730,46650,44569,44569,44569,42489,40409,34201,30041,21784,17656,17656,17657,17657,17656,17656,19736,19736,19736,23864,34169,34201,38329,36281,36281,40409,42489,42489,40441,44569,46682,48762,50842,50842,50842,50842,50810,50810,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50810,50810,50810,50810,48762,48729,48762,46682,46649,46649,46649,46649,46681,46681,46681,48729,48729,48729,48729,46649,44569,48729,48730,48729,46681,48762,50810,50842,48761,48730,48729,48729,48729,48729,48761,50810,50842,50809,46649,46649,48729,48697,44569,44569,46649,46648,46649,48697,46649,46649,48697,44568,44568,46616,46649,44568,44568,44568,44536,42488,44536,17460,818,11122,19411,17297,15217,17265,8943,13038,27632,29745,23406,33873,19242,14985,14952,12840,14952,12871,10759,8647,21325,38198,40310,40343,40375,27598,40114,27600,21359,6502,6501,10727,31859,40278,33841,27495,17027,8579,6435,8579,21220,21252,17060,16995,12867,10659,12739,17027,12866,10723,6434,6434,6435,6435,4323,4290,4258,4290,4355,4388,6631,6763,8909,13103,15248,17329,19409,21490,23603,25683,27764,31924,34069,36150,36150,36150,36150,36117,29872,31923,34102,34069,34037,34037,34069,34037,31989,31989,31957,29909,29876,27828,27796,25716,21588,21555,19507,17427,15347,15347,17395,15314,13266,13234,13234,13234,13234,15282,15314,19410,29643,25350,17029,12802,8641,8578,6497,255},
{1176,7352,17624,23832,27960,32089,34169,36249,38329,40409,42521,46650,46682,46650,44569,44569,44569,42521,40409,36249,30041,21784,17656,17656,17657,17657,17657,17656,19736,19736,19736,21784,25912,30073,32153,30073,34201,40441,42489,42489,42489,44601,46682,48762,50810,50810,50810,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50810,50810,48762,48762,48762,48729,46649,46649,46649,46649,46682,46681,46681,48729,48729,48729,48729,46649,44601,48729,48730,48729,46681,48761,50842,50842,48761,48730,48730,48729,48729,48729,48729,50842,48729,48729,44568,46649,48729,48697,44569,44569,46649,46649,46649,46649,46649,46649,48729,46617,46649,46649,46616,44536,46616,44568,44536,42488,44536,19508,4914,15250,23539,25586,15184,15184,8976,17231,29746,29746,29680,35986,17130,15049,14984,14952,10727,10727,8614,4421,14987,34004,38230,40343,42423,36116,40148,23439,17067,10793,17132,15052,31891,40278,33839,25382,12803,6499,8611,21220,23332,23333,14948,14916,8611,6435,6435,8579,10627,10723,10723,6467,6435,6403,4323,4291,4291,4323,4355,4420,6697,8876,11022,13135,15248,17329,19410,21522,23602,25683,27764,31956,36149,38230,38230,36182,36150,36117,33938,34004,34069,34037,34037,34069,34069,34037,34037,34037,31957,29877,27828,27828,27796,25716,23636,21555,19475,17427,15347,15315,15315,13266,13234,11186,13234,13234,13234,13234,17330,27498,31620,16963,10690,10690,8610,8578,8610,255},
{1176,5304,13528,21752,25912,30040,32121,34201,38329,40409,42489,44601,46682,46650,44569,42521,42521,42521,40441,36281,32121,23832,17656,17656,17656,17657,17657,17656,19736,19736,19736,21784,25912,27992,27992,32121,34201,38361,42489,42521,42521,44601,46682,48762,48762,48762,48762,50810,50842,52922,52922,52890,48762,50810,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,48762,48730,48762,48729,46681,46681,46681,46681,46681,46681,46681,46681,48729,48729,48729,46681,46649,48729,48730,48729,46681,48761,50842,50842,50809,48730,48730,48730,48729,48729,48697,48729,46649,46649,44536,46617,48729,48697,46617,44569,46649,46617,46649,46649,46649,46649,46649,46649,48697,46617,44568,44568,46649,44536,44536,42488,42488,17428,9042,15250,21491,23506,19377,11056,17264,17231,27665,21326,33841,27630,17161,12872,14984,17064,23371,33937,23373,17034,23406,38230,40310,42391,42423,40278,38100,31858,29810,38197,36182,29811,38198,31889,21190,25381,12835,10723,21284,21188,21221,10723,10659,10724,6435,4355,4355,6435,6467,6467,10723,10691,6467,4355,4323,4323,4323,4323,4387,6565,6763,8909,11022,13135,15248,17329,19409,21522,23602,25683,27796,31957,36182,38262,38230,38230,36150,36150,34068,36150,34069,34037,34069,34069,34069,34069,34069,34037,31989,29877,29877,27796,27796,25716,23636,21555,19475,17427,17395,13267,15314,13234,11186,11186,13234,13234,13234,13234,15282,25483,23298,10689,10690,8547,10723,6530,6402,255},
{1176,5304,11448,19704,25880,30040,32121,34201,38329,40409,42489,44569,46650,46650,44601,44569,42489,42489,42489,38329,32121,25912,19704,17656,17656,17656,17657,17656,17656,19736,19736,21784,25913,27993,27993,34201,38329,38361,42489,42521,42489,44601,46682,48762,50810,48762,48762,50842,50842,52922,52923,52923,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,48762,48729,48762,48729,46681,46681,46649,46681,48729,48729,46681,46681,48729,48729,48729,46681,46681,48730,48730,48729,46681,48761,50842,50842,50809,48761,48729,48729,50809,50809,48729,48729,48729,48729,44536,44568,48697,48697,46617,44569,46649,46617,46649,46649,46649,46649,46649,48729,46649,46617,44568,46616,46616,44568,42488,44536,42488,15380,11122,19443,31892,27699,21458,11056,15215,15118,27632,35889,29646,17131,17161,12904,12905,17063,33871,48631,36018,27567,29647,42390,42423,42423,42455,40277,38067,38164,46616,42456,40310,31891,38230,34001,17028,19107,19107,21187,25412,23332,17028,6499,6435,6435,6467,6435,6435,6467,6467,6467,6435,6467,6435,4323,4323,4355,4323,4355,4453,6664,8876,8941,11055,15216,15249,17361,19442,21522,23603,25683,27796,34037,38230,38262,38230,38230,36182,34101,34069,36150,34069,34037,34069,36149,34069,34069,34069,34037,31957,29909,27828,29876,27796,25716,21588,21555,19475,17427,15347,15315,13266,13234,11186,11154,13234,13234,13234,13234,17362,19307,10657,10754,6498,8546,8514,6530,8578,255},
{1176,5272,9400,17656,23832,30040,32121,34169,36249,38361,40441,44569,46650,46650,46650,44601,42521,42489,42489,40409,34169,25912,21784,17656,17656,17656,17656,17656,17656,17656,19736,21784,25912,27993,30073,34201,36281,38361,40441,42521,42489,44569,46682,48762,48762,50810,50842,50842,52922,52922,52922,52922,52922,52890,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50842,50810,48762,48762,48730,46681,46681,46649,46681,48729,48729,46681,46681,46681,48729,48729,48729,48729,48730,48730,48729,46681,48761,50810,50809,50809,48761,48761,50809,52890,50809,48729,48761,50809,50809,42488,44536,48729,48697,46617,46617,46649,46617,46649,46649,48697,48697,46649,48697,46649,46616,44568,46617,46649,46616,44536,42488,42488,15348,13202,25684,21491,23570,15217,6896,8975,15118,33938,38035,23437,12937,15017,10760,12840,15015,33871,46518,38034,29647,25421,40278,42391,42423,42456,38165,38067,38164,44536,42423,38230,31891,38230,31888,14915,14914,19107,19140,21188,21187,17027,12836,8579,6435,12739,10691,6435,8611,6467,4355,6435,4355,4290,4291,4323,4387,4323,6468,6664,6795,10990,13135,15216,17329,17361,19442,21522,23603,25683,25715,29844,36117,38262,40310,38262,38230,36182,36149,36150,34101,34069,34037,34069,36149,34069,34069,34069,31989,31957,29877,29876,27828,27796,25716,23636,21555,17427,15347,15347,13266,13234,13234,11186,11154,13234,13234,15282,21424,27563,12867,6497,6466,6434,12706,10626,10722,6530,255},
{1176,3224,9400,17624,23832,27960,32121,34169,36249,38329,40409,44569,46650,46682,46682,46650,44569,44569,42489,40409,34201,30040,23832,17656,17656,15608,15608,17656,17656,17656,19736,21784,25912,27993,30041,34201,36249,36281,40409,42489,42489,44569,46682,48762,50810,50842,50842,52922,52922,52922,52923,52922,52922,52890,50842,50842,52890,50842,50842,50842,50842,50842,50842,50842,50842,50842,48762,48762,48730,46681,46681,46649,46681,48729,48761,46681,46681,46681,48762,48730,48729,48729,48762,48730,48729,46681,48761,50809,50809,50809,48761,50809,52922,52890,48761,48697,48697,50809,48729,42456,44536,48697,48697,46617,46617,46649,46649,46649,46649,48729,48729,46649,46649,46649,46649,46649,46617,46617,46617,44536,42488,42488,15348,17330,23571,15282,13169,15217,8976,8976,15150,35986,38002,23470,17098,21291,12873,12873,15016,29614,42259,35953,27566,19178,35986,42358,42423,42423,38132,38099,38165,44536,42455,38198,31891,40278,33903,19108,17027,17028,19108,21220,17027,12771,12803,10691,6467,14851,17059,8515,6435,6467,6435,6435,4355,4259,4291,4355,4420,4387,6598,8843,10989,13135,17296,17361,19410,19442,21522,23603,23603,25715,27764,29876,36150,38262,40310,38262,38230,36182,36150,36150,34069,34037,34069,36117,36117,34069,34069,34069,34037,31957,29909,29877,27828,27796,25716,21588,21555,19475,17395,15347,13266,11186,11186,11186,11154,17362,17361,25484,27465,29479,16963,12770,10690,8578,6498,6498,10722,8578,255},
{1176,1176,7352,17624,23832,30008,32121,34201,36249,38329,40409,44569,46649,46682,46682,46682,46649,44569,42489,40409,36249,30041,25912,17656,15608,15608,15608,17656,17656,17656,17656,21784,25913,27992,27992,32121,36281,36281,38329,40409,40441,44569,48730,48762,50810,50842,52890,52922,52922,52922,52923,52922,52890,50842,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50842,48730,48762,48730,46649,46681,46681,46649,48729,48762,48730,46681,46681,48762,48762,48729,48729,48762,48762,48729,46681,48761,50809,50810,50809,50809,50842,55003,52922,48729,48697,48697,50809,48729,40408,42488,46649,46649,44569,46617,46649,46649,46649,48697,48729,48697,46649,48697,48697,48697,46649,46617,46649,44568,42488,44536,42488,15347,19443,21523,17330,17330,19377,15217,8975,13038,33874,42293,29712,25453,27566,17097,19209,12904,23339,29678,29613,23337,17030,21225,31792,40310,40278,33939,38099,38165,44536,42423,36117,31891,36051,21190,21189,17028,21156,21188,25381,21221,14915,10691,6467,4354,12739,17027,8547,6403,6403,6467,6403,4258,4291,4323,4355,4419,6501,8778,10990,15183,17296,19409,21490,21522,21522,23603,23603,25683,25715,27796,31956,36150,40310,40310,40310,38230,36182,36150,36150,34069,34037,34069,36149,36117,34069,34069,34069,31989,31957,31957,29877,27828,27796,23668,23636,21555,19475,17395,15315,13234,11186,13234,13234,11154,15281,23437,29510,23268,19075,16994,19042,16994,10722,10690,8578,8578,8546,255},
{1176,1176,7352,15576,23832,30008,32121,36249,38329,38361,40409,42521,44601,46650,46682,46682,46649,44569,42489,40409,36281,32121,25912,19704,15608,15608,15608,17656,17657,17656,17656,19736,27992,27992,25912,30040,34201,36281,36281,38329,40441,46649,48762,50810,50842,52890,52922,52922,52922,52922,52922,52922,50842,50842,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50842,48762,48762,48730,44601,44601,46681,46649,48729,48762,48762,48729,48729,48762,48762,48730,48729,48762,48762,46681,46649,48729,50809,50810,50810,50842,55003,55003,52890,46649,46649,48729,50809,48697,40376,42456,46649,46649,44569,46649,46649,46649,48697,48729,48729,46649,46617,48697,48729,48729,46649,46649,46649,44536,42488,44536,42456,21556,19443,17363,15250,15249,23506,17297,15216,10957,33907,36052,21358,21260,19243,17098,17098,12871,17127,12902,14918,14918,12806,17063,19178,34004,40278,33939,35986,40245,44536,44504,34069,31924,27597,14883,19108,19076,19076,23237,14884,16996,19108,12835,10659,6467,6435,10659,12771,8547,6435,6467,4323,4259,4323,4323,4387,6500,8745,10989,15183,17329,19409,21522,21523,21555,23603,23603,23635,25715,27764,29844,31957,36150,40310,40310,40310,38230,36182,36150,36150,34069,34069,36117,36149,36117,34069,36117,34069,34037,31957,29909,29876,27828,25748,23668,23636,19507,19475,17395,15315,13266,13234,13234,13234,13201,15017,23339,27463,19139,12801,10689,17025,17025,12802,12770,8546,10658,10690,255},
{1176,1176,7352,15576,21784,27960,32120,36249,38329,38361,40409,42489,44569,46649,46649,46650,46650,44569,40441,38361,38329,34169,27960,19704,15608,15608,15608,17656,17656,17656,17656,21784,27992,30040,25912,25912,32121,34201,34201,36281,40441,46649,48762,50842,50842,52922,52922,52922,52922,52922,52922,52922,50842,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,48762,48762,48730,44569,44601,46681,46649,46681,48762,48762,48762,48762,48762,50810,48762,48729,48762,48762,48729,46681,48761,48761,50809,50810,55003,55003,55002,50809,46649,44568,48729,50809,46649,42456,42488,46649,46649,44568,46617,46649,46649,48697,50777,48729,46649,48697,46649,48697,48729,46616,46649,46617,42488,42488,44568,38295,19443,15282,17331,13202,11089,25586,17297,17296,17230,33906,33906,27600,17099,15017,12905,17066,12903,14983,12839,14918,10725,12805,31755,25516,34004,40310,33939,36019,35987,38132,36051,27665,29745,23304,12739,16996,16964,19076,21221,10691,10627,19109,21221,14916,10659,6467,6467,10627,10627,6467,6403,4291,4291,4355,4355,6468,6664,10956,15183,17329,19442,21522,23571,23603,23603,23635,23635,25683,27764,27796,29844,31957,38230,40310,40310,40310,38230,36150,36150,36150,34069,34069,36117,36149,36149,36117,36149,34069,34037,31957,31957,29909,27828,27796,25716,23636,21555,19475,17395,15315,15315,15314,15314,13235,15149,12869,21223,25316,17058,12770,12738,14913,12833,12770,12770,6434,6402,6402,255},
{1176,3224,7352,15576,21752,27960,32120,34201,38329,38329,40409,42489,42489,44569,46649,46649,46649,42521,40409,38329,38329,34201,27992,19736,15608,15608,15608,15608,17656,17656,17656,19736,25912,30073,27992,23864,32121,36281,34201,34201,40409,46649,48762,50842,50842,52890,52922,52922,52922,52922,52922,52922,52890,52922,52922,52922,52922,52922,52922,52890,50842,50842,50842,50842,50842,50842,48762,48762,48730,44601,44601,46681,46649,46681,48729,48762,48762,48762,50810,50810,48762,48729,48729,48762,48729,48729,50809,48761,50809,52890,55035,55003,52922,50842,46649,44536,48697,48729,46649,42488,44536,46649,46649,44568,46617,46649,46649,48697,48729,48697,48729,48729,46649,48729,46649,46617,46649,44568,42488,42488,44568,38295,13235,9074,13202,11090,13169,33907,19345,15183,15150,27600,25552,29712,17131,15049,12905,19113,12839,12839,17031,16998,12870,12837,25353,19145,23373,36084,36019,38132,14922,12776,8648,6534,21293,23337,16931,21189,14852,21156,23269,14884,8579,14852,14852,16996,12836,8579,8547,6467,6403,6403,4323,4258,4291,4355,4387,8614,10924,15183,19377,21490,23570,21523,23603,23603,23635,23635,25683,25715,27796,27796,29876,31957,38230,40310,40310,40310,38230,36150,38198,36150,34069,34069,36150,36150,34069,36117,36149,34069,31989,31989,31989,29909,29876,27796,25716,23636,21555,21555,19475,17395,17395,15314,15315,15281,14982,14949,21124,21155,14914,12738,10626,14881,12834,14882,12802,10626,6434,4290,255},
{1176,1176,7352,15576,21752,27960,32088,34201,36249,38329,38361,40409,42489,42521,44569,46649,44601,42489,40409,38329,36281,36249,27992,21784,17656,15608,15576,15608,17656,15608,15608,17656,23864,30073,32121,27992,32121,36281,36281,36281,40409,44569,48762,50842,50842,52922,52922,52922,52922,52922,52922,52922,52890,52890,52922,52922,52922,52922,52922,52890,52890,50842,50842,50842,50842,50842,48762,48729,48730,46649,44601,46681,46649,46681,48761,48762,48762,50810,50810,50810,50810,48730,48729,48762,48729,48729,50809,50810,52922,55003,57083,55003,52922,50841,46617,42456,46616,48729,46649,44536,44536,46649,46649,44568,44569,46649,46649,48697,48697,48697,48729,48697,46649,46649,48697,46649,46616,44568,42488,42488,44568,36215,13203,9074,13234,11089,13169,27699,17329,15183,17198,19278,19440,25486,19245,15083,14986,25387,14920,14952,17031,16999,16998,10726,16935,10694,12807,25583,31760,38132,10728,12841,10761,8647,23406,29744,21189,21156,16964,12771,16964,19076,12804,6467,6467,14883,19108,12740,8547,8548,6403,4258,8484,10564,4291,4387,6533,12939,17263,19377,21490,23570,23603,23603,23635,25683,23635,23635,25683,27764,27796,27796,29876,31989,38230,40310,40310,40310,38230,38230,36150,34069,34069,36150,36150,36150,34069,36117,36149,34069,34037,31989,31957,31957,29909,27796,27796,25716,23636,21555,21523,19475,19443,17395,15347,13101,10691,12835,19043,16995,12802,12771,12771,17026,16994,14915,12770,10658,8514,8514,255},
{1176,1176,7352,13528,21752,25912,30040,34201,36249,38329,38361,40409,42489,42489,42489,44569,44569,42489,40409,38329,38329,36249,30041,23832,17656,15608,13528,15608,17656,15608,15608,17656,25912,30041,32121,34201,34201,36281,38361,38361,40441,46649,48762,50842,50842,52890,52922,52922,52922,52922,52922,52922,52890,52890,52922,52922,52922,52922,52922,52922,52890,52890,50842,50842,50842,50842,48762,48729,48762,46681,44601,46681,46649,46681,48729,48762,48762,50810,50810,50810,50810,48762,48730,48762,48729,48729,50810,50810,52922,55035,55035,55003,52922,50809,44536,40376,44536,46649,44569,44536,44536,46649,46649,44569,44568,46616,46649,48697,46649,48697,48697,48697,48697,46649,48729,46649,44568,44568,44536,42488,44568,38295,15283,9074,11122,11121,13169,17330,11088,17263,19278,19309,19310,17132,15018,12937,14985,19177,14887,15016,16999,14886,14918,12806,10661,6469,10694,21358,31727,38100,19147,27632,23374,17132,27632,40310,31757,21157,12771,8579,10659,14819,19076,8579,8515,10691,10723,6467,6435,6435,4323,4259,6371,6371,4323,6468,10792,17198,19409,21490,23602,23603,25683,25683,25683,25683,25683,25683,25715,27764,27796,27796,29876,34037,38230,40310,40310,40310,38230,38230,34101,31989,34069,36150,36150,36150,34069,36149,36149,34069,34069,34037,31989,31989,31957,29877,27796,25716,25716,23636,21456,17164,15083,17165,17262,15181,12837,12803,14915,16995,17026,14914,14914,16962,12770,10626,8514,8546,6434,6402,255},
{1144,1176,3224,13528,21752,25880,30040,34169,36249,38329,38329,38361,40409,40409,42489,42489,42489,40409,40409,40409,38329,36249,32121,25912,17656,13528,15608,17656,17656,15608,15608,17656,23864,32121,34201,40409,38361,38361,40409,40441,42521,46682,48762,50842,50842,52890,52922,52922,52922,52922,52922,52922,52890,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,48762,48762,48762,46681,44601,46649,46649,46681,48729,48730,48762,48762,50810,50810,50810,48762,48730,48761,48729,48729,50810,50809,52922,55035,55035,55003,52922,50809,44536,40376,42456,46649,46617,44536,44568,48697,46649,44569,44568,46616,46649,48697,46649,46649,46649,48697,48697,48697,48729,46649,44568,44568,44536,42488,44568,36215,13235,6994,4913,11122,13202,17329,15217,17264,17198,21357,21357,21357,17163,10857,15050,14985,14888,14983,14951,14918,12806,10694,12806,6469,8646,23471,29648,38132,38197,42423,40343,29843,31891,40310,40180,27499,12740,10627,8515,6435,12771,12803,8579,8547,8579,8579,6435,4323,4291,4291,4291,4323,4355,6533,15051,21424,21490,23602,25683,25715,25715,25715,27764,25716,25716,25716,27764,27796,27796,27796,31957,34037,38230,40310,40310,38230,36150,38230,36149,34069,34069,36150,36150,36149,36117,36149,36149,34069,34069,34037,34003,31888,31822,31855,29843,27730,25581,23536,17128,14984,12936,12804,12770,12836,12803,17027,19137,17025,17057,14913,10689,8546,6402,6402,8514,8578,6370,6402,255},
{1144,1144,3224,11448,19704,25880,27960,32121,34201,36249,36249,38329,38329,40409,40409,42489,42489,40409,40409,40409,38329,36249,34169,25912,19704,13528,15608,17656,17656,15608,15608,17656,21784,32121,38361,42489,44569,42489,42489,44569,44569,46682,48762,50842,50842,52890,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52890,50842,50842,50842,50842,50842,48762,48762,48762,46681,44601,46649,46649,46681,46681,48762,48762,48762,50810,50810,50810,48762,48729,48762,48729,48729,50810,50810,52954,57083,57083,55003,52922,50809,44536,38295,42456,46649,44568,44568,46617,48697,46649,44569,46617,46616,46649,48729,46649,46649,48697,48697,48697,48697,46649,46617,46616,44568,44568,42488,44568,36215,13234,6994,6961,11122,13169,17329,13168,17263,17198,21358,23438,25548,15082,12905,19211,19146,14856,12871,10727,14887,12806,14918,17030,12902,12871,31890,23375,38067,40310,42455,42423,31956,31923,40278,38067,27501,16965,16996,10659,8547,8579,12803,10691,10659,8579,6435,6371,4323,4291,4291,4323,4355,6501,12938,21391,25650,25683,27763,27764,27796,27796,27764,27796,27796,25716,27764,27796,27796,27796,29876,31957,34037,38230,40310,40310,36182,36182,38230,36117,36149,36117,36150,36149,36150,36117,36149,36149,34069,34035,36117,29773,19140,21185,21186,21323,21285,21185,12836,10690,8610,10658,12834,10690,8578,10690,19170,14913,14945,14914,12834,8578,6466,6370,6402,8482,8514,8514,6434,255},
{1176,1144,1176,9400,19704,23832,27960,30040,34169,36249,36249,36249,38329,40409,40409,42489,42489,40409,38329,38329,38329,36249,34201,30040,21784,13560,13560,19704,19704,15608,15608,15608,21784,38329,40409,42521,46649,44569,44601,46649,46649,46682,48762,50842,50842,52890,52890,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52890,52890,50842,50842,50842,50842,50842,48762,48762,48762,46681,44601,44601,46649,46649,46682,48730,48762,48762,50810,50810,48762,48730,48729,48762,46681,48729,50810,50842,55003,57083,57083,55003,52922,50809,42456,38295,40376,46617,46649,46649,46649,48697,46649,44569,46617,46649,46649,48729,46616,46649,48697,50777,48729,46649,46649,46649,46617,46616,44536,42488,44568,38295,13235,6993,6993,15250,17298,19409,19377,19343,21391,17165,21358,19243,12937,15017,19178,25452,17002,12840,10759,17095,21287,19110,17094,12870,10726,29777,31793,38100,42358,42423,40343,31956,34004,40278,38099,25389,12676,23402,25549,14884,12804,8579,10691,14884,8611,6500,6468,6436,4323,4356,8646,8679,17099,27730,29844,27764,27796,29876,29876,29877,29876,27796,27796,27796,25716,27764,27796,29876,29876,29877,31957,34037,38230,40310,40310,36182,38230,36150,34069,36149,36149,36149,36149,36149,36149,36149,36150,31856,25515,33933,25476,17026,23296,19105,12835,19105,14882,10690,12771,10658,10658,14915,12834,8578,12802,19137,14945,14977,12770,10658,6434,6402,6402,6402,10658,8546,10658,6434,255},
{1144,1144,1176,7352,17624,23832,27960,30040,32088,34201,36249,36249,38329,38361,40409,42489,42489,40409,38329,36281,38329,36281,34201,32120,23832,15608,15608,17656,19736,17656,15576,15608,21784,38329,42489,44569,46649,46649,46649,46649,46650,46682,48762,50810,50842,52890,52890,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,48762,48762,48762,48730,44601,44601,44601,46649,46681,48729,48762,48762,50810,50810,48762,48729,48729,48730,46681,46681,50809,52922,55003,55003,55003,52922,52890,48729,40408,38296,40376,46617,48697,46649,48697,48697,48697,44569,46617,46649,46649,48697,46649,48697,50777,50809,48697,46617,46616,46616,46616,44568,44536,42488,44536,42488,17427,6961,6993,13202,17330,25650,23538,19343,23472,15117,17163,15083,17130,12937,21261,25421,23244,21258,12871,14950,19142,17061,14949,10693,8614,17066,33808,38100,40277,40311,36149,27730,33971,40245,40115,25389,6403,21162,40310,34003,17096,10659,8515,10660,17067,15020,14987,8582,6501,10727,19245,25584,29843,34037,34037,29876,29877,29877,31957,31957,29909,29876,27828,27796,27796,27796,27796,29876,29876,29909,31989,34069,38230,40310,40310,38230,38230,36150,34069,36150,36150,36149,36149,36149,36149,36150,34068,21319,23402,29705,23328,16993,21216,16962,12770,14849,16962,14915,14883,10690,10690,12802,10691,12739,14946,19106,17026,14914,8546,10626,8546,6434,6402,8546,14882,8578,6402,4322,255},
{1144,1144,1176,7352,15576,21784,27960,30040,32088,34169,36249,36249,38329,40409,40409,40441,40441,40409,36249,36249,38329,38329,36249,32121,25912,17656,17656,19704,21784,17656,13528,15608,23864,38329,42489,44569,46649,46682,46682,46682,46650,46682,48762,48762,50842,50842,52890,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,52890,50842,50842,50842,50842,50842,50842,50842,50810,48762,48762,48730,44601,44601,46649,46649,46649,46681,48762,48762,50809,50810,48730,46681,48729,48729,46681,46681,50809,52954,55035,55003,55002,50842,52890,46617,40376,36216,38296,44568,46649,46649,46649,46649,48697,46617,46617,46649,46649,48697,46649,48697,52890,50809,46649,44568,46616,46616,44568,44536,44536,42488,44536,44536,19508,6961,6993,13170,17297,21490,15249,15183,13005,21423,17163,15084,15019,14986,17131,27534,23275,17065,21226,17064,14983,17061,12870,8581,6501,19212,35987,36051,40310,40343,36150,27698,34004,38197,38034,25356,6371,14758,19082,21195,14887,10692,6435,4323,8550,10663,12841,6534,12873,21391,31923,38198,38230,38230,36150,31989,31957,31957,31957,31989,29909,29876,29876,27828,27796,27796,27828,27828,29876,29909,31989,34069,38230,40310,38230,38230,38230,36150,34069,36150,36149,36149,36149,36149,36117,31855,27626,25442,25445,23364,23328,14881,12769,10658,8545,10658,21123,21219,14882,14882,12770,10658,12771,10658,16963,17026,14882,14946,10722,10690,10690,6434,12738,14882,10722,6434,4322,6370,255},
{1144,1176,1176,5304,13528,21752,25912,30040,32088,34169,36249,36281,38329,38361,40409,40441,40441,40409,36281,36249,38329,38361,36281,34169,25912,19736,19704,21784,23832,17656,13528,13560,23832,38329,42489,42489,44601,46682,46682,46682,46650,46682,48762,50810,50842,50842,52890,52890,52922,52922,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50842,50810,48762,48762,48730,44601,44601,46649,46649,44601,46681,48729,48762,50809,50810,48730,46681,46681,46681,46681,46681,50810,52922,55035,55003,52922,50842,48729,42488,38296,36215,38264,44536,48697,46649,48697,46649,48697,44569,44569,46649,46649,48697,46649,48729,52890,50809,46616,44536,46616,46616,44536,44536,44536,44536,44536,44568,23701,4913,6994,11121,17330,21458,13169,19344,19246,17165,15084,17164,17163,19210,17066,29646,21129,19177,21227,21223,19142,17030,12838,8613,12808,12808,33873,33938,38197,40311,34037,25585,33971,38165,35953,23308,4291,10597,12710,12678,14823,8517,8549,6468,6436,10663,17068,23472,31891,34037,38230,40310,38230,38230,36150,34037,31957,31957,31989,31957,29909,29876,27796,29876,27796,27796,27796,27796,29876,31957,31989,34069,38230,38262,38230,38230,38230,36150,36117,36149,36149,36149,36149,36150,34069,23431,21185,23267,21187,21217,19104,14881,12738,12770,14851,21187,23267,19107,12834,14946,12802,8610,10658,10690,16995,19107,10594,10658,8546,10690,14882,12739,12675,8546,8546,6434,6370,4322,255},
{1144,1176,1176,3224,11448,19704,25880,30040,32088,32120,36249,36281,38329,38329,38361,40409,40441,40409,36281,36249,36281,38329,36249,32121,27960,21784,21784,23832,23832,17656,13528,13528,21784,36281,42489,42521,44601,46650,46682,46682,46682,46650,48762,50810,50842,50842,52890,52890,52890,52922,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50842,50810,48762,48762,48730,44601,44601,46681,46649,44601,44601,46681,48762,50810,50810,48730,46681,44601,46649,46681,46649,48761,52922,55003,55003,52922,52890,48697,42456,38296,36215,36215,44536,48697,48729,48729,46649,46649,44569,46617,46649,46649,48697,46649,48729,52890,50809,44568,44568,46616,44568,42488,44536,44536,44536,42488,44568,29942,9074,9042,13170,15249,13169,13136,19279,17197,15019,10826,17163,15019,12937,17035,29678,16936,17000,12839,14918,12742,8581,6469,10693,10662,10727,35920,31793,31891,38230,31891,21391,31891,40245,38002,21195,4323,8452,14856,21162,16936,10630,12808,12808,8582,12809,21294,29811,34004,36117,40310,40310,38230,38230,36150,31989,31989,31957,31989,31957,29909,29877,27796,27796,27796,27796,27828,27828,29876,31957,31989,36150,38230,38262,36150,38230,36150,36149,36117,36149,36117,36149,36149,36150,36117,23432,17026,17027,21186,21249,16993,12769,16931,25412,19075,21186,16994,14850,16994,12802,12739,10691,10690,14914,19139,21219,14882,8546,8514,12834,10690,6434,6402,6402,4290,4290,4322,4290,255},
{1144,1176,1176,5272,11448,17624,23832,27960,32088,32121,36249,36249,38329,38329,38329,38329,40409,40409,36281,36249,36249,38329,36281,32121,27960,25912,21784,23832,21784,17656,15608,13528,21784,36249,40441,42521,44569,46649,46682,46682,46682,46682,48762,50810,50842,50842,50842,50842,52890,52890,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50842,50810,48762,48762,48762,44601,44601,46681,46681,44601,44601,46681,48762,50810,50810,48729,46649,42521,46649,46681,46649,50842,55003,52954,52954,52954,52922,48729,42488,38328,36215,36215,44568,48697,48729,46649,46649,46649,44569,44569,46649,46649,46649,46616,48729,52889,48729,44568,44568,46649,44568,42488,44568,44536,44536,42488,44568,27861,13170,9041,13169,17330,23538,15184,21358,15118,15052,12906,15051,14987,15018,19179,27533,16969,14951,21193,14950,8613,6501,10693,12838,12838,10791,29615,27632,34004,38230,31924,23504,31923,38197,35954,23275,10662,10597,33971,38230,34037,34036,36150,31956,23472,21359,27665,31924,34037,36117,40310,40310,38230,36150,36150,34037,31989,31989,31989,31957,29909,29909,29876,27796,27796,27796,27796,27796,29876,29909,31989,34069,38230,38230,36150,36150,36150,34069,36149,36149,34069,36149,36149,36149,36117,23400,21221,21222,19106,21185,19106,16994,19076,27525,19107,16930,12770,12834,12802,12803,12771,8578,10658,10690,19106,17058,14946,10690,12770,12802,8610,6434,6370,4322,4290,6370,4290,6434,255},
{1176,1176,1176,5304,11448,17624,23832,27960,32088,32121,34201,36249,38329,38329,36249,36249,38329,40409,38329,36249,36249,38329,36281,32121,30040,25912,23832,23832,21784,17656,15608,13528,21784,36281,40409,42489,44569,44601,46682,46682,46682,46682,48762,50810,50842,50842,52890,50842,50842,50842,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50842,50810,48762,48762,48730,46649,44601,46649,46682,46649,44601,46649,48729,48762,48762,48729,46649,42521,46649,48729,48729,50842,52890,55003,55003,52954,52922,48729,42488,40376,36215,38295,46649,46649,46649,46617,46649,46649,44569,44569,46649,46649,46649,48697,50809,50841,46649,44536,46617,46649,46616,42488,44568,44536,44536,42488,44536,21556,13170,9041,15282,17330,23570,17264,25519,19279,19278,19211,15018,17098,19242,19242,25452,17001,17032,29580,21288,12934,8645,8613,12806,15015,12872,31793,33939,38229,40311,34037,27730,36117,38100,35921,19082,6339,27567,40343,40311,38230,40311,40343,36149,29811,25617,29811,34004,36117,38198,40310,40310,38230,36150,36118,34037,31989,31957,31957,31957,29909,29876,29876,27796,27796,27796,27796,27796,27828,29909,31989,34069,38230,38230,36150,36150,36117,34069,36149,34069,34069,36149,36149,36150,36117,29776,23401,17059,19138,21186,21218,23331,27556,27492,19075,10658,10690,14915,12802,8578,8578,8514,6434,8514,16995,17026,14914,10722,6434,8514,6402,6434,6370,4257,4322,4290,4290,8514,255},
{1176,1176,1176,7352,11448,17624,23832,27960,32088,32120,34169,36249,36281,38329,36249,36249,38329,38329,38329,36249,36249,38329,38329,34169,30041,25912,21784,19704,21784,17656,15608,15608,23864,36249,38361,40409,42489,44601,46650,46682,46682,46682,48762,50810,50842,50842,50842,50842,50842,50842,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50842,48762,48762,48762,48762,46649,46649,46681,46681,46681,46649,46649,48729,48762,48762,48729,46649,44601,48729,48729,48729,50842,50809,52922,52922,52922,52890,48729,44536,40376,36215,40376,46649,44536,44569,46617,46649,46649,44569,46617,46649,46649,46649,50809,52890,50809,46616,44536,46617,46649,46616,44536,44536,44536,44536,42488,42456,15315,13170,13202,15282,17329,13137,15216,19311,23439,21326,21324,17163,15017,17066,19243,17097,19049,14952,17031,19111,14982,8581,10758,10790,10790,14985,38066,33939,38229,38230,34036,27730,36117,38164,35921,16937,12743,38230,40343,38262,38230,40310,40343,36149,31924,29811,31924,34037,36117,38230,40310,40311,38230,36150,36150,34037,31989,31957,31989,31957,29909,29877,29876,27796,27796,27796,27796,27796,27828,31957,34037,34069,38230,36150,36182,36150,34069,36117,36150,36150,34069,36150,36150,36149,34036,31888,25546,21253,19139,16994,19138,21218,29635,16994,19106,16962,12802,14850,12771,10690,8546,8514,8482,6434,12738,14978,14946,10754,6466,4322,6370,12802,8545,8578,8514,4322,8546,6402,255},
{1176,1176,1176,7320,11448,17624,23832,27960,32088,34168,34201,36249,38329,38329,36249,36249,36281,38329,38329,36281,38329,38329,38329,34201,30040,25912,19736,17656,19704,17656,13528,15608,25912,36249,36281,38329,42489,44569,46649,46682,46650,46682,48762,50810,50842,50842,50842,50842,50842,50842,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50842,48762,48762,48730,48762,46681,46649,46681,46681,48729,46681,44601,46649,48762,48762,48729,46649,44569,46649,46649,48729,50842,50810,50809,50810,52890,52890,50809,44536,40376,36215,44536,46649,42488,46617,48729,48729,46649,44569,46617,46649,46649,48697,50842,52890,50809,48697,46616,44568,46649,46649,44568,42488,44568,44536,42488,40376,11154,11122,13202,19410,19410,15249,15216,19310,29712,33873,21324,12937,15017,17097,17130,17065,14888,10695,10758,14982,14982,10758,14950,15047,8646,21260,35921,36051,40343,40311,36117,29810,38197,38165,35889,16904,25486,42423,40343,40310,38198,40311,40343,38230,34004,31924,34004,36117,36149,38230,40310,40310,38230,36150,36150,34069,31989,31957,31989,31957,29909,29877,29876,27796,27796,27796,27796,27796,29876,29877,34037,34069,36150,36150,36150,36150,34069,36150,36149,31855,29741,33970,31922,29775,17029,21223,25547,21220,16994,17059,21218,27523,25411,16993,23267,12770,8546,14914,17026,12802,10659,6402,8514,10658,12801,17057,12802,10722,8578,4354,6434,14913,12801,12770,8546,6434,8514,6370,255},
{1144,1176,1176,5272,11448,15576,21752,27960,30040,32120,36249,36281,38329,38329,36281,36249,36249,38329,38361,38361,38361,38329,38329,36249,32121,27992,19704,17656,19704,15608,15576,15608,23864,34169,34201,34201,38361,42489,44569,46650,46650,46650,48730,48762,50842,50842,50842,50842,50842,52922,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50842,48762,48729,48729,48730,46681,46649,46649,46681,48729,46681,46649,46649,48730,48762,48729,46649,42521,44601,46681,50842,52922,50842,48729,48729,52890,52922,50809,44536,38296,38296,46649,46649,44536,46617,48729,48729,46649,44569,46617,46649,46649,48729,52922,52889,48729,46616,44536,44536,48729,48697,44536,42488,44536,44536,42488,40376,11155,9042,13202,19410,19410,11089,15184,19278,21423,29713,14986,14986,23372,25453,23308,21259,17034,12873,12872,14983,15014,10758,12839,10661,10662,27566,35986,33906,33971,33939,29745,27665,38197,40213,33808,19049,34004,40343,40343,40311,38230,40311,40343,38230,34036,33972,34037,36117,38198,40310,40343,40310,38230,36150,36150,34037,31989,31957,31989,31957,31957,29877,29876,29876,27796,27796,27796,27796,27796,29909,31989,34069,36150,36150,36150,34069,34069,36150,29775,17059,19139,12836,14885,21287,16994,16963,25482,25544,17027,12834,21186,25411,21186,23298,21250,14850,19043,21251,17026,10658,6466,8513,17024,17024,19169,14945,10754,10722,10722,6434,10625,14881,10658,10626,6370,8514,8546,6370,255},
{1144,1176,1176,7352,13496,17624,21752,25912,30040,32121,34201,36281,38329,38329,38329,36249,36249,38329,40409,40409,40409,40409,38361,38329,36249,30040,19704,19704,23864,21784,19736,17656,21784,30040,36249,34201,34201,38329,42521,44601,46649,46650,46682,48730,50810,50842,50842,50842,50842,52922,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50810,48730,48730,48729,48730,46681,44601,46649,46681,48729,48729,46681,46649,48729,48762,48730,46649,44601,44569,48761,52922,52922,50809,48729,48729,50842,52890,50809,44568,38296,40376,48697,48729,44568,46649,48729,48729,46649,44569,46617,46649,46649,52890,52890,50809,46649,42488,42456,44536,48729,48697,44568,44568,44536,44536,42488,38328,9074,11122,15282,17362,19409,11088,15152,17101,19182,36019,21358,23309,21261,19148,19116,25453,19115,12841,21194,17065,17030,10693,12775,10630,12775,25356,40180,25486,14921,12841,8680,21293,36117,40212,33743,23308,38230,40311,40343,40343,38230,40311,40343,38230,34036,33972,34037,36117,38230,40310,40343,40310,36182,36150,36150,34069,31957,31989,31989,31957,31989,29909,29876,29876,27796,27796,27796,27796,27796,29876,31957,34069,36149,36150,36150,34069,36117,34035,21319,19141,14914,8546,8547,17026,14914,12738,19077,21253,17059,12802,23267,29603,19074,23299,23331,19106,16962,16994,10690,10690,6401,19168,19168,12833,10689,10721,12865,10754,12802,12770,10722,8577,12769,8546,6434,6434,6370,6370,255},
{1144,1176,1176,7352,13528,17624,21752,25912,30040,32121,34201,36249,38329,38329,38329,36249,36249,38329,40409,40441,42489,42489,40409,40409,38329,32121,21784,19736,27992,30040,30073,23864,25912,30073,36281,36281,34169,36249,40441,44569,46649,46682,46650,46682,48762,50810,50842,50842,50842,52922,52922,52922,52922,52922,52922,52922,52922,52922,50842,50842,50842,50842,50842,50842,50842,50810,48730,48762,48762,48762,48730,44601,46649,46681,48762,48730,46681,46681,48729,48762,48729,46649