/***************************************************************************
 *   Copyright (C) 2003 by TAM (Teppei Tamra)                              *
 *   tamra@users.sourceforge.jp                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include "mplayerThumbnailConfig.h"


mplayerThumbnailConfig::mplayerThumbnailConfig(QWidget *parent, const char *mname)
    //: KDialogBase(KDialogBase::IconList,"mplayerThumbnailConfig",Ok|Cancel|Apply,Ok)
{
    config = new KConfig(MPLAYERTHUMBNAILRC,false,true);
    
    type << "MplayerThumbnail" << "AVI" << "MPG" << "MOV" << "RM";
    name << 
        i18n("All files") <<
        i18n("AVI files (.AVI)") <<
        i18n("MPEG files (.MPG)") <<
        i18n("QuickTime files (.MOV)") <<
        i18n("RealMedia files (.RM)");
    icon << 
        "files" <<
        "video" <<
        "video" <<
        "quicktime" <<
        "real";
    
    tab = new QTabWidget(this);
                    
    for (unsigned int num = 0;num != type.count();++num) {
        configw[num] = new mplayerThumbnailConfigBase(parent,mname);
        tab->addTab(configw[num],(QString)name[num]);
        //QFrame *page = tab->addWidget((QString)name[num]); //,name[num],DesktopIcon((QString)icon[num]));
//        QGridLayout *grid = new QGridLayout(page,0,0,10);
//        configw[num] = new mplayerThumbnailConfigBase(page);
//        grid->addWidget(configw[num],0,1);
        config->setGroup(type[num]);
        configw[num]->cFrames->setMinValue(1); // 饤ˤޤͤͿ뤪ޤʤ
        // ͭ/̵ɽʤ
        if (type[num] != "MplayerThumbnail") {
            bool e = config->readBoolEntry("Enable",false);
            emit configw[num]->configEnable->setChecked(e);
            emit configw[num]->configFrame->setEnabled(e);
        } else configw[num]->configEnable->setHidden(true);
        //
        emit configw[num]->cPosition->setValue(config->readNumEntry("CapturePosition"));
        emit configw[num]->cFrames->setValue(config->readNumEntry("CaptureFrames",1));
        if (config->readBoolEntry("DrawArrow",true)) 
            emit configw[num]->drawArrow->setChecked(true);
        else 
            emit configw[num]->drawArrow->setChecked(false);
    }
    QGridLayout *grid = new QGridLayout(this,0,0,10);
    grid->addWidget(tab,0,1);

/*    connect(this,SIGNAL(okClicked()),SLOT(okAction()));
    connect(this,SIGNAL(applyClicked()),SLOT(applyAction()));
    connect(this,SIGNAL(cancelClicked()),SLOT(cancelAction()));
*/

}


mplayerThumbnailConfig::~mplayerThumbnailConfig()
{
    delete config;
}

void mplayerThumbnailConfig::okAction()
{
    writeConfig();
    emit quit();
}

void mplayerThumbnailConfig::applyAction()
{
    writeConfig();
}

void mplayerThumbnailConfig::cancelAction()
{
    emit quit();
}

void mplayerThumbnailConfig::writeConfig()
{
    for (unsigned int num = 0;num != type.count();++num) {
        config->setGroup(type[num]);
        if (type[num] != "MplayerThumbnail") {
            config->writeEntry("Enable",configw[num]->configEnable->isChecked());
        }
        config->writeEntry("CapturePosition",configw[num]->cPosition->value());
        config->writeEntry("CaptureFrames",configw[num]->cFrames->value());
        config->writeEntry("DrawArrow",configw[num]->drawArrow->isChecked());
    }
    config->sync();
}


#include "mplayerThumbnailConfig.moc"

