/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2004 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  #Id: $
 */

#include "kz-bookmark-edit-win.h"

#include "intl.h"
#include "gobject-utils.h"
#include "kz-icons.h"
#include "kz-bookmark-edit.h"

static void kz_bookmark_edit_win_class_init (KzBookmarkEditWinClass *klass);
static void kz_bookmark_edit_win_init       (KzBookmarkEditWin      *win);
static void kz_bookmark_edit_win_dispose    (GObject                *object);
static void kz_bookmark_edit_win_finalize   (GObject                *finalize);
static void kz_bookmark_edit_win_response   (GtkDialog              *dialog,
					     gint                    arg);

static GtkDialogClass *parent_class = NULL;


KZ_OBJECT_GET_TYPE(kz_bookmark_edit_win, "KzBookmarkEditWin", KzBookmarkEditWin,
		   kz_bookmark_edit_win_class_init, kz_bookmark_edit_win_init,
		   GTK_TYPE_DIALOG)
KZ_OBJECT_FINALIZE(kz_bookmark_edit_win, KzBookmarkEditWin)


static void
kz_bookmark_edit_win_class_init (KzBookmarkEditWinClass *klass)
{
	GObjectClass *object_class;
	GtkDialogClass *dialog_class;

	parent_class = g_type_class_peek_parent(klass);
	object_class = (GObjectClass *) klass;
	dialog_class = (GtkDialogClass *) klass;

	object_class->dispose  = kz_bookmark_edit_win_dispose;
	object_class->finalize = kz_bookmark_edit_win_finalize;

	dialog_class->response = kz_bookmark_edit_win_response;
}


static void
kz_bookmark_edit_win_init (KzBookmarkEditWin *win)
{
	GtkWidget *edit;

	win->priv = NULL;

	gtk_window_set_default_size(GTK_WINDOW(win), 400, 300);
	gtk_window_set_icon(GTK_WINDOW(win), kz_icon);

	gtk_dialog_add_buttons(GTK_DIALOG(win),
			       GTK_STOCK_CLOSE, GTK_RESPONSE_CLOSE,
			       NULL);

	/* paned */
	edit = kz_bookmark_edit_new();
	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(win)->vbox), 
			   edit, TRUE, TRUE, 0);
	gtk_widget_show(edit);

	/* initialize member */
	win->bookmark_edit = edit;
}


static void
kz_bookmark_edit_win_dispose (GObject *object)
{
	KzBookmarkEditWin *win = KZ_BOOKMARK_EDIT_WIN(object);

	win->bookmark_edit = NULL;

	if (G_OBJECT_CLASS(parent_class)->dispose)
		G_OBJECT_CLASS(parent_class)->dispose(object);
}


static void
kz_bookmark_edit_win_response (GtkDialog *dialog, gint arg)
{
	switch (arg)
	{
	case GTK_RESPONSE_CLOSE:
		gtk_widget_destroy(GTK_WIDGET(dialog));
		break;
	default:
		break;
	}
}


GtkWidget *
kz_bookmark_edit_win_new (KzBookmark *bookmark)
{
	GObject *obj;
	KzBookmarkEditWin *win;

	obj = g_object_new(KZ_TYPE_BOOKMARK_EDIT_WIN,
			   "title", _("Kazehakase Bookmark Editor"),
			   NULL);
	win = KZ_BOOKMARK_EDIT_WIN(obj);

	if (KZ_IS_BOOKMARK(bookmark))
		kz_bookmark_edit_set(KZ_BOOKMARK_EDIT(win->bookmark_edit),
				     bookmark);

	return GTK_WIDGET(win);
}
