/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2009 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_BIN_H__
#define __KZ_BIN_H__

#include <gtk/gtk.h>

G_BEGIN_DECLS

#define KZ_TYPE_BIN		(kz_bin_get_type ())
#define KZ_BIN(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_BIN, KzBin))
#define KZ_BIN_CLASS(klass)	(G_TYPE_CHECK_CLASS_CAST ((klass), KZ_TYPE_BIN, KzBinClass))
#define KZ_IS_BIN(obj)		(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_BIN))
#define KZ_IS_BIN_CLASS(klass)  (G_TYPE_CHECK_CLASS_TYPE ((klass), KZ_TYPE_BIN))
#define KZ_BIN_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS ((obj), KZ_TYPE_BIN, KzBinClass))

typedef struct _KzBin           KzBin;
typedef struct _KzBinClass      KzBinClass;

struct _KzBin
{
	GtkBin parent;
};

struct _KzBinClass
{
	GtkBinClass parent_class;
};

GType      kz_bin_get_type (void) G_GNUC_CONST;
GtkWidget *kz_bin_new      (void);
void	   kz_bin_change_child (KzBin *bin,
				GtkWidget *new_child);

G_END_DECLS

#endif /* __KZ_BIN_H__ */
