/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003-2004 Takuro Ashie
 *  Copyright (C) 2004 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include "kz-thumbnails-sidebar.h"

#include <glib/gi18n.h>
#include "kazehakase.h"
#include "kz-thumbnails-view.h"
#include "kz-paned.h"
#include "kz-tab-label.h"
#include "kz-proxy-folder.h"

enum {
	PROP_0,
	PROP_SIDEBAR
};


/* Object class methods */
static GObject *constructor  (GType type,
                              guint n_props,
                              GObjectConstructParam *props);
static void     dispose      (GObject      *obj);
static void     set_property (GObject      *object,
                              guint         prop_id,
                              const GValue *value,
                              GParamSpec   *pspec);
static void     get_property (GObject      *object,
                              guint         prop_id,
                              GValue       *value,
                              GParamSpec   *pspec);
static void     cb_paned_changed_position          (KzPaned *pane,
						    GtkPositionType position,
						    KzThumbnailsView *view);
static void	cb_thumbnail_activate		   (KzThumbnailsView *view,
						    KzBookmark *bookmark,
						    gint index,
						    KzWindow *kz);

static GtkWidget *kz_thumbnails_sidebar_closed_tabs_new 
						   (KzSidebarEntry *entry,
						    KzSidebar *sidebar);
#if 0
static GtkWidget *kz_thumbnails_sidebar_history_search_new 
						   (KzSidebarEntry *entry,
						    KzSidebar *sidebar);
#endif
static KzSidebarEntry kz_sidebar_thumbnails[] = 
{
	{
		/* .priority_hint = */ 0,
		/* .label         = */ N_("Closed tabs"),
		/* .icon          = */ NULL,
		/* .create        = */ kz_thumbnails_sidebar_closed_tabs_new,
	}
/*
	{
		priority_hint: 0,
		label:         N_("History search"),
		icon:          NULL,
		create:        kz_thumbnails_sidebar_history_search_new,
	}
*/
};


KzSidebarEntry *
kz_thumbnails_sidebar_get_entry (gint idx)
{
	if (idx > 0) return NULL;

	return &kz_sidebar_thumbnails[idx];
}

G_DEFINE_TYPE(KzThumbnailsSidebar, kz_thumbnails_sidebar, GTK_TYPE_VBOX)

static void
kz_thumbnails_sidebar_class_init (KzThumbnailsSidebarClass *klass)
{
	GObjectClass *gobject_class;

	gobject_class = G_OBJECT_CLASS(klass);

	gobject_class->constructor  = constructor;
	gobject_class->dispose      = dispose;
	gobject_class->set_property = set_property;
	gobject_class->get_property = get_property;

	g_object_class_install_property
		(gobject_class,
		 PROP_SIDEBAR,
		 g_param_spec_object ("sidebar",
				      _("Sidebar"),
				      _("The parent sidebar"),
				      KZ_TYPE_SIDEBAR,
				      G_PARAM_READWRITE |
				      G_PARAM_CONSTRUCT_ONLY));
}


static void
kz_thumbnails_sidebar_init (KzThumbnailsSidebar *sidebar)
{
	GtkWidget *scrwin, *view;

	/* create scrolled window */
	scrwin = gtk_scrolled_window_new(NULL, NULL);

	gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrwin),
				       GTK_POLICY_AUTOMATIC,
				       GTK_POLICY_AUTOMATIC);
        gtk_scrolled_window_set_shadow_type(GTK_SCROLLED_WINDOW(scrwin),
					    GTK_SHADOW_IN);
	gtk_box_pack_start(GTK_BOX(sidebar), scrwin, TRUE, TRUE, 0);
	gtk_widget_show(scrwin);

	view = kz_thumbnails_view_new();
	gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrwin),
					      view);
	gtk_widget_show(view);

	sidebar->view = view;
}


static GObject *
constructor (GType                  type,
             guint                  n_props,
             GObjectConstructParam *props)
{
	KzThumbnailsSidebar *sidebar;
	GObject *object;
	GObjectClass *klass = G_OBJECT_CLASS(kz_thumbnails_sidebar_parent_class);

	object = klass->constructor(type, n_props, props);

	sidebar = KZ_THUMBNAILS_SIDEBAR(object); 

	g_signal_connect(sidebar->sidebar->kz->pane,
			 "changed_position",
			 G_CALLBACK(cb_paned_changed_position),
			 sidebar->view);
	g_signal_connect(sidebar->view,
			 "activate",
			 G_CALLBACK(cb_thumbnail_activate),
			 sidebar->sidebar->kz);
	return object;
}
static void
dispose (GObject *obj)
{
	KzThumbnailsSidebar *sidebar = KZ_THUMBNAILS_SIDEBAR(obj);

	if (sidebar->sidebar)
		g_object_unref(sidebar->sidebar);

	sidebar->sidebar = NULL;

	if (G_OBJECT_CLASS (kz_thumbnails_sidebar_parent_class)->dispose)
		G_OBJECT_CLASS (kz_thumbnails_sidebar_parent_class)->dispose(obj);
}


static void
set_property (GObject         *object,
              guint            prop_id,
              const GValue    *value,
              GParamSpec      *pspec)
{
	KzThumbnailsSidebar *sidebar = KZ_THUMBNAILS_SIDEBAR(object);
  
	switch (prop_id)
	{
	case PROP_SIDEBAR:
		sidebar->sidebar = g_object_ref(g_value_get_object(value));
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
		break;
	}
}


static void
get_property (GObject         *object,
              guint            prop_id,
              GValue          *value,
              GParamSpec      *pspec)
{
	KzThumbnailsSidebar *sidebar = KZ_THUMBNAILS_SIDEBAR(object);

	switch (prop_id)
	{
	case PROP_SIDEBAR:
		g_value_set_object(value, sidebar->sidebar);
		break;
	default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, prop_id, pspec);
		break;
	}
}


static GtkWidget *
kz_thumbnails_sidebar_closed_tabs_new (KzSidebarEntry *entry,
				       KzSidebar *sidebar)
{
	KzThumbnailsSidebar *tsidebar;
	KzBookmark *proxy;

	tsidebar = g_object_new(KZ_TYPE_THUMBNAILS_SIDEBAR,
			        "sidebar", sidebar,
			        NULL);

	/* 
	 * create a new bookmark folder which included each current page of  
	 * closed tab.
	 */
	proxy = kz_proxy_folder_new(sidebar->kz->closed_tabs);
	
	kz_thumbnails_view_set_folder(KZ_THUMBNAILS_VIEW(tsidebar->view),
				      KZ_BOOKMARK_FOLDER(proxy));
	g_object_unref(proxy);

	return GTK_WIDGET(tsidebar);
}

#if 0
static GtkWidget *
kz_thumbnails_sidebar_history_search_new (KzSidebarEntry *entry,
					  KzSidebar *sidebar)
{
	KzThumbnailsSidebar *tsidebar;

	tsidebar = KZ_THUMBNAILS_SIDEBAR(g_object_new(KZ_TYPE_THUMBNAILS_SIDEBAR,
						   "sidebar", sidebar,
						   NULL));

	kz_thumbnails_view_set_folder(KZ_THUMBNAILS_VIEW(tsidebar->view),
				      sidebar->kz->history_search);

	return GTK_WIDGET(tsidebar);
}
#endif

static void     
cb_paned_changed_position (KzPaned *pane,
			   GtkPositionType position,
			   KzThumbnailsView *view)
{
	switch(position)
	{
	 case GTK_POS_LEFT:
	 case GTK_POS_RIGHT:
		kz_thumbnails_view_set_mode(view, KZ_THUMBNAILS_VIEW_VERTICAL);	
		break;
	 case GTK_POS_TOP:
	 case GTK_POS_BOTTOM:
		kz_thumbnails_view_set_mode(view, KZ_THUMBNAILS_VIEW_HORIZONTAL);	
		break;
	 default:
		break;
	}	
}


static void
cb_thumbnail_activate (KzThumbnailsView *view,
		       KzBookmark *bookmark,
		       gint index,
		       KzWindow *kz)
{
	KzBookmarkFolder *tab;
	GtkWidget *kzembed;
	KzTabLabel *kztab;

	g_return_if_fail(KZ_IS_BOOKMARK(bookmark));
	g_return_if_fail(KZ_IS_WINDOW(kz));

	tab = KZ_BOOKMARK_FOLDER(kz_bookmark_folder_get_nth_child(kz->closed_tabs, index));
	g_return_if_fail(tab);

	kzembed = kz_window_open_new_tab(kz, NULL);
	kztab = kz_notebook_get_tab_label(KZ_NOTEBOOK(kz->notebook), KZ_EMBED(kzembed));
	kz_tab_label_set_history(KZ_TAB_LABEL(kztab), tab);

	kz_bookmark_folder_remove(kz->closed_tabs, KZ_BOOKMARK(tab));
}
