/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2008  g新部 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implmoz_web_viewd warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#include <glib/gi18n.h>

#include "kz-moz-web-view.h"

#include <moz-web-view.h>

#include "kz-embed.h"

typedef struct _KzMozWebViewPrivate	KzMozWebViewPrivate;
struct _KzMozWebViewPrivate
{
	gint progress;
	gchar *location;
	gchar *title;
	gchar *link_message;
	gboolean lock;
	gboolean is_loading;
};
#define KZ_MOZ_WEB_VIEW_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), KZ_TYPE_MOZ_WEB_VIEW, KzMozWebViewPrivate))

static GType           kz_type_moz_web_view = 0;
static MozWebViewClass *kz_moz_web_view_parent_class;

GtkWidget  *kz_moz_web_view_new          (void);
static void kz_moz_web_view_class_init   (KzMozWebViewClass *klass);
static void kz_moz_web_view_iface_init   (KzEmbedIFace      *iface);
static void kz_moz_web_view_init         (KzMozWebView      *view);
static void kz_moz_web_view_dispose      (GObject           *object);

static GObject *constructor  (GType type,
			      guint n_props,
			      GObjectConstructParam *props);

static void     title_changed    (MozWebView *view, const char *title);
static void     status_changed   (MozWebView *view, const char *status);
static void     location_changed (MozWebView *view, const char *uri);
static void     document_loaded  (MozWebView *view);

static void	    load_url               (KzEmbed      *kzembed,
					    const gchar  *url);
static void	    stop_load              (KzEmbed      *kzembed);
static void	    reload		   (KzEmbed      *kzembed,
					    KzEmbedReloadFlag flags);
static void	    go_back                (KzEmbed      *kzembed);
static void	    go_forward             (KzEmbed      *kzembed);
static gboolean	    can_go_back            (KzEmbed      *kzembed);
static gboolean	    can_go_forward         (KzEmbed      *kzembed);
static gboolean     can_go_nav_link	   (KzEmbed      *kzembed,
					    KzEmbedNavLink link);
static KzNavi      *get_nth_nav_link	   (KzEmbed      *kzembed,
					    KzEmbedNavLink link,
					    guint         n);
static GList       *get_nav_links	   (KzEmbed      *kzembed,
					    KzEmbedNavLink link);
static gboolean     can_cut_selection      (KzEmbed      *kzembed);
static gboolean     can_copy_selection     (KzEmbed      *kzembed);
static gboolean     can_paste              (KzEmbed      *kzembed);
static void	    cut_selection          (KzEmbed      *kzembed);
static void	    copy_selection         (KzEmbed      *kzembed);
static void	    paste                  (KzEmbed      *kzembed);
static void	    select_all             (KzEmbed      *kzembed);
static gdouble	    get_progress	   (KzEmbed      *kzembed);
static const gchar *get_title              (KzEmbed      *kzembed);
static const gchar *get_location           (KzEmbed      *kzembed);
static gchar       *get_link_message       (KzEmbed      *kzembed);
static gboolean     selection_is_collapsed (KzEmbed      *kzembed);
static gboolean     is_loading             (KzEmbed      *kzembed);
static void         zoom_set               (KzEmbed      *kzembed, 
					    int           zoom, 
					    gboolean      reflow);
static int          zoom_get               (KzEmbed      *kzembed);
static gboolean     get_lock               (KzEmbed      *kzembed);
static void         set_lock               (KzEmbed      *kzembed,
					    gboolean      lock);
static gboolean	    get_allow_javascript   (KzEmbed      *kzembed);
static void	    set_allow_javascript   (KzEmbed      *kzembed,
    					    gboolean      allow);
static gboolean	    get_allow_images	   (KzEmbed      *kzembed);
static void	    set_allow_images	   (KzEmbed      *kzembed,
					    gboolean      allow);

void
kz_moz_web_view_register_type (GTypeModule *module)
{
	static const GTypeInfo kz_moz_web_view_info =
	{
		sizeof (KzMozWebViewClass),
		NULL,		/* base_init */
		NULL,		/* base_finalize */
		(GClassInitFunc) kz_moz_web_view_class_init,
		NULL,		/* class_finalize */
		NULL,		/* class_data */
		sizeof (KzMozWebView),
		0,		/* n_preallocs */
		(GInstanceInitFunc) kz_moz_web_view_init,
	};

	const GInterfaceInfo kz_embed_info =
	{
		(GInterfaceInitFunc) kz_moz_web_view_iface_init,
		NULL,
		NULL
	};

	kz_type_moz_web_view = g_type_module_register_type(module,
						 MOZ_TYPE_WEB_VIEW,
						 "KzMozWebView",
						 &kz_moz_web_view_info,
						 (GTypeFlags)0);

	g_type_module_add_interface(module,
				    KZ_TYPE_MOZ_WEB_VIEW,
				    KZ_TYPE_EMBED,
				    &kz_embed_info);
}

GType
kz_moz_web_view_get_type (void)
{
	return kz_type_moz_web_view;
}

static void
kz_moz_web_view_class_init (KzMozWebViewClass *klass)
{
	GObjectClass *object_class;
	MozWebViewClass *moz_web_view_class;

	kz_moz_web_view_parent_class = MOZ_WEB_VIEW_CLASS(g_type_class_peek_parent(klass));
	object_class = G_OBJECT_CLASS(klass);
	moz_web_view_class = MOZ_WEB_VIEW_CLASS(klass);

	object_class->dispose = kz_moz_web_view_dispose;
	object_class->constructor = constructor;

	moz_web_view_class->title_changed = title_changed;
	moz_web_view_class->status_changed = status_changed;
	moz_web_view_class->location_changed = location_changed;
	moz_web_view_class->document_loaded = document_loaded;

	g_type_class_add_private(object_class, sizeof(KzMozWebViewPrivate));
}

static void
kz_moz_web_view_iface_init (KzEmbedIFace *iface)
{
	iface->load_url               = load_url;
	iface->view_source            = NULL;
	iface->view_current_page_source_in_new
				      = NULL;
	iface->is_loading             = is_loading;
	iface->get_title              = get_title;
	iface->get_location           = get_location;
	iface->get_link_message       = get_link_message;
	iface->get_progress           = get_progress;
	iface->can_cut_selection      = can_cut_selection;
	iface->can_copy_selection     = can_copy_selection;
	iface->can_paste              = can_paste;
	iface->cut_selection          = cut_selection;
	iface->copy_selection         = copy_selection;
	iface->paste                  = paste;
	iface->select_all             = select_all;
	iface->get_selection_string   = NULL;
	iface->find                   = NULL;
	iface->incremental_search     = NULL;
	iface->selection_is_collapsed = selection_is_collapsed;
	iface->get_links              = NULL;
	iface->copy_page              = NULL;
	iface->shistory_get_pos       = NULL;
	iface->shistory_get_nth       = NULL;
	iface->reload                 = reload;
	iface->stop_load              = stop_load;
	iface->go_back                = go_back;
	iface->go_forward             = go_forward;
	iface->can_go_back            = can_go_back;
	iface->can_go_forward         = can_go_forward;
	iface->can_go_nav_link        = can_go_nav_link;
	iface->go_nav_link            = NULL;
	iface->append_nav_link        = NULL;
	iface->set_nav_link           = NULL;
	iface->set_nth_nav_link       = NULL;
	iface->get_nav_link           = NULL;
	iface->get_nth_nav_link       = get_nth_nav_link;
	iface->get_nav_links          = get_nav_links;
	iface->go_history_index       = NULL;
	iface->do_command             = NULL;
	iface->can_do_command         = NULL;
	iface->get_lock               = get_lock;
	iface->set_lock               = set_lock;
	iface->get_body_text          = NULL;
	iface->set_encoding           = NULL;
	iface->get_encoding           = NULL;
	iface->print                  = NULL;
	iface->print_preview          = NULL;
	iface->get_printer_list       = NULL;
	iface->create_thumbnail       = NULL;
	iface->save_with_content      = NULL;
	iface->set_text_into_textarea = NULL;
	iface->get_text_from_textarea = NULL;
	iface->zoom_set               = zoom_set;
	iface->zoom_get               = zoom_get;
	iface->set_text_size          = NULL;
	iface->get_text_size          = NULL;
	iface->get_html_with_contents = NULL;
	iface->set_history            = NULL;
	iface->get_history            = NULL;
	iface->get_last_modified      = NULL;
	iface->fine_scroll            = NULL;
	iface->page_up                = NULL;
	iface->page_down              = NULL; 
	iface->get_allow_javascript   = get_allow_javascript;
	iface->set_allow_javascript   = set_allow_javascript; 
	iface->get_allow_images       = get_allow_images;
	iface->set_allow_images       = set_allow_images;

	iface->link_message           = NULL;
	iface->js_status              = NULL;
	iface->location               = NULL;
	iface->title                  = NULL;
	iface->progress               = NULL;
	iface->net_start              = NULL;
	iface->net_stop               = NULL;
	iface->new_window             = NULL;
	iface->open_uri               = NULL;
	iface->size_to                = NULL;
	iface->dom_key_down           = NULL;
	iface->dom_key_press          = NULL;
	iface->dom_key_up             = NULL;
	iface->dom_mouse_down         = NULL;
	iface->dom_mouse_up           = NULL;
	iface->dom_mouse_click        = NULL;
	iface->dom_mouse_dbl_click    = NULL;
	iface->dom_mouse_over         = NULL;
	iface->dom_mouse_out          = NULL;
	iface->security_change        = NULL;
	iface->status_change          = NULL;
}

static GObject*
constructor (GType                  type,
             guint                  n_props,
             GObjectConstructParam *props)
{
	GObject *object;
	GObjectClass *klass = G_OBJECT_CLASS(kz_moz_web_view_parent_class);

	object = klass->constructor(type, n_props, props);

	return object;
}

static void
kz_moz_web_view_init (KzMozWebView *webkit)
{
	KzMozWebViewPrivate *priv = KZ_MOZ_WEB_VIEW_GET_PRIVATE(webkit);

	priv->location = NULL;
	priv->title = NULL;
	priv->link_message = NULL;

	priv->progress = 0;

	priv->lock = FALSE;
	priv->is_loading = FALSE;
}

static void
kz_moz_web_view_dispose (GObject *object)
{
	KzMozWebViewPrivate *priv = KZ_MOZ_WEB_VIEW_GET_PRIVATE(object);
	if (priv->location)
		g_free(priv->location);
	if (priv->title)
		g_free(priv->title);
	if (priv->link_message)
		g_free(priv->link_message);
	priv->location = NULL;
	priv->title = NULL;
	priv->link_message = NULL;

	if (G_OBJECT_CLASS(kz_moz_web_view_parent_class)->dispose)
		G_OBJECT_CLASS(kz_moz_web_view_parent_class)->dispose(object);
}

static void
title_changed (MozWebView *view, const char *title)
{
	g_signal_emit_by_name(view, "kz-title", title);
}

static void
status_changed (MozWebView *view, const char *status)
{
	g_signal_emit_by_name(view, "kz-js-status");
}

static void
location_changed (MozWebView *view, const char *uri)
{
	g_signal_emit_by_name(view, "kz-location", uri);
}

static void
document_loaded (MozWebView *view)
{
	g_signal_emit_by_name(view, "kz-net-stop");
}

GtkWidget *
kz_moz_web_view_new (void)
{
	return GTK_WIDGET(g_object_new(KZ_TYPE_MOZ_WEB_VIEW, NULL));
}

static void
load_url (KzEmbed *kzembed, const gchar  *url)
{
	g_return_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed));

	moz_web_view_load_uri(MOZ_WEB_VIEW(kzembed), url);
}

static void
reload (KzEmbed *kzembed, KzEmbedReloadFlag flags)
{
	g_return_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed));
}

static void
stop_load (KzEmbed *kzembed)
{
	g_return_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed));
}

static void
go_back (KzEmbed *kzembed)
{
	g_return_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed));
}

static void
go_forward (KzEmbed *kzembed)
{
	g_return_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed));
}

static gboolean
can_go_back (KzEmbed *kzembed)
{
	g_return_val_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed), FALSE);

	return FALSE;
}

static gboolean
can_go_forward (KzEmbed *kzembed)
{
	g_return_val_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed), FALSE);

	return FALSE;
}

static gboolean
can_cut_selection (KzEmbed *kzembed)
{
	g_return_val_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed), FALSE);

	return FALSE;
}

static gboolean
can_copy_selection (KzEmbed *kzembed)
{
	g_return_val_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed), FALSE);

	return FALSE;
}

static gboolean
can_paste (KzEmbed *kzembed)
{
	g_return_val_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed), FALSE);

	return FALSE;
}

static void
cut_selection (KzEmbed *kzembed)
{
	g_return_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed));
}

static void
copy_selection (KzEmbed *kzembed)
{
	g_return_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed));
}

static void
paste (KzEmbed *kzembed)
{
	g_return_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed));
}

static void
select_all (KzEmbed *kzembed)
{
	g_return_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed));
}

static const gchar *
get_title (KzEmbed *kzembed)
{
	g_return_val_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed), NULL);

	return moz_web_view_get_title(MOZ_WEB_VIEW(kzembed));
}

static const gchar *
get_location (KzEmbed *kzembed)
{
	g_return_val_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed), NULL);

	return moz_web_view_get_location(MOZ_WEB_VIEW(kzembed));
}

static gchar *
get_link_message (KzEmbed *kzembed)
{
	g_return_val_if_fail(KZ_IS_MOZ_WEB_VIEW(kzembed), NULL);

	return g_strdup(KZ_MOZ_WEB_VIEW_GET_PRIVATE(kzembed)->link_message);
}

static gdouble
get_progress (KzEmbed *kzembed)
{
	return 0.0f;
}

static gboolean
selection_is_collapsed (KzEmbed *kzembed)
{
	return FALSE;
}

static gboolean
is_loading (KzEmbed *kzembed)
{
	return FALSE;
}

static void
zoom_set (KzEmbed *kzembed, int zoom, gboolean reflow)
{
}

static int
zoom_get (KzEmbed *kzembed)
{
	return 100;
}

static gboolean
get_lock (KzEmbed *kzembed)
{
	return KZ_MOZ_WEB_VIEW_GET_PRIVATE(kzembed)->lock;
}


static void
set_lock (KzEmbed *kzembed, gboolean lock)
{
	KZ_MOZ_WEB_VIEW_GET_PRIVATE(kzembed)->lock = lock;
}

static gboolean
get_allow_javascript (KzEmbed *kzembed)
{
	return TRUE;
}

static void
set_allow_javascript (KzEmbed *kzembed, gboolean allow)
{
}

static gboolean
get_allow_images (KzEmbed *kzembed)
{
        return TRUE;
}

static void
set_allow_images (KzEmbed *kzembed, gboolean allow)
{
}

static gboolean
can_go_nav_link (KzEmbed *kzembed, KzEmbedNavLink link)
{
	return FALSE;
}

static KzNavi *
get_nth_nav_link (KzEmbed *kzembed, KzEmbedNavLink link,
		  guint n)
{
	return NULL;
}

static GList *
get_nav_links (KzEmbed *kzembed, KzEmbedNavLink link)
{
	return NULL;
}

