// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

// derived from epiphany's embed/mozilla/GeckoCookiePromptService.cpp.
// original header:
/*
 *  Copyright © 2003 Tommi Komulainen <tommi.komulainen@iki.fi>
 *  Copyright © 2004, 2007 Christian Persch
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2
 *  as published by the Free Software Foundation.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-mozcookiepromptservice.cpp 3511 2008-08-13 21:10:06Z kous $
 */ 

#include "mozilla-config.h"
#include "config.h"

#include <glib/gi18n.h>

#include <gtk/gtkbox.h>
#include <gtk/gtkcheckbutton.h>
#include <gtk/gtkdialog.h>
#include <gtk/gtkmessagedialog.h>
#include <gtk/gtkstock.h>
#include <gtk/gtkwindow.h>

#include <nsStringAPI.h>

#include "kz-mozcookiepromptservice.h"

#include "kz-mozutils.h"

NS_IMPL_ISUPPORTS1 (KzMozCookiePromptService, nsICookiePromptService)

KzMozCookiePromptService::KzMozCookiePromptService()
{
}

KzMozCookiePromptService::~KzMozCookiePromptService()
{
}

/* boolean cookieDialog (in nsIDOMWindow parent, in nsICookie cookie, in ACString hostname, in long cookiesFromHost, in boolean changingCookie, inout boolean checkValue); */
NS_IMETHODIMP
KzMozCookiePromptService::CookieDialog (nsIDOMWindow *aParent,
                                        nsICookie *aCookie,
                                        const nsACString &aHostname,
                                        PRInt32 aCookiesFromHost,
                                        PRBool aChangingCookie,
                                        PRBool *_checkValue,
                                        PRBool *_retval)
{
	NS_ENSURE_ARG(aParent);
	NS_ENSURE_ARG(aCookie);
	NS_ENSURE_ARG_POINTER(_checkValue);
	NS_ENSURE_ARG_POINTER(_retval);

	nsCString host(aHostname);

	GtkWidget *kz;
	GtkWidget *dialog;

	kz = GetGtkWindowForDOMWindow(aParent);
	dialog = gtk_message_dialog_new(GTK_WINDOW(kz),
					GTK_DIALOG_MODAL /* FIXME mozilla sucks! */,
					GTK_MESSAGE_QUESTION,
					GTK_BUTTONS_NONE,
					_("Accept cookie from %s?"),
					host.get());
	gtk_window_set_title(GTK_WINDOW(dialog), _("Accept Cookie?"));

	if (aChangingCookie) {
		gtk_message_dialog_format_secondary_text
			(GTK_MESSAGE_DIALOG(dialog),
			 _("The site wants to modify an existing cookie."));
	} else if (aCookiesFromHost == 0) {
		gtk_message_dialog_format_secondary_text
			(GTK_MESSAGE_DIALOG(dialog),
			 _("The site wants to set a cookie."));
	} else if (aCookiesFromHost == 1) {
		gtk_message_dialog_format_secondary_text
			(GTK_MESSAGE_DIALOG(dialog),
			 _("The site wants to set a second cookie."));
	} else {
		char *num_text = g_strdup_printf
			(ngettext("You already have %d cookie from this site.",
				  "You already have %d cookies from this site.",
				  aCookiesFromHost),
			 aCookiesFromHost);

		gtk_message_dialog_format_secondary_text
			(GTK_MESSAGE_DIALOG(dialog),
			 "The site %s wants to set another cookie. %s",
			 host.get(), num_text);
		g_free(num_text);
	}

	GtkWidget *check_button;
	check_button = gtk_check_button_new_with_mnemonic
		(_("Apply this _decision to all cookies from this site"));
	gtk_widget_show(check_button);

	GtkWidget *content_box;
	GList *children;

	content_box = GTK_DIALOG(dialog)->vbox;
	children = gtk_container_get_children(GTK_CONTAINER(content_box));
	content_box = GTK_WIDGET(children->data);
	g_list_free(children);

	children = gtk_container_get_children(GTK_CONTAINER(content_box));
	content_box = GTK_WIDGET(children->next->data);
	g_list_free(children);

	gtk_box_pack_start(GTK_BOX(content_box), check_button, FALSE, FALSE, 0);

	*_checkValue = PR_TRUE;
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(check_button),
				     *_checkValue);

	gtk_dialog_add_button(GTK_DIALOG(dialog),
			      _("_Reject"), GTK_RESPONSE_REJECT);
	gtk_dialog_add_button(GTK_DIALOG(dialog),
			      _("_Accept"), GTK_RESPONSE_ACCEPT);
	gtk_dialog_set_default_response(GTK_DIALOG(dialog), GTK_RESPONSE_ACCEPT);

	int response = gtk_dialog_run(GTK_DIALOG(dialog));

	if (response == GTK_RESPONSE_ACCEPT || response == GTK_RESPONSE_REJECT) {
		*_retval = (response == GTK_RESPONSE_ACCEPT);
		*_checkValue = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(check_button));
	} else {
		*_retval = PR_FALSE;
		*_checkValue = PR_FALSE;
	}
	gtk_widget_destroy(dialog);

	return NS_OK;
}
