/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2007 Hiroyuki Ikezoe
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __KZ_GECKO_EMBED_H__
#define __KZ_GECKO_EMBED_H__

#include <glib-object.h>
#include "gtkmozembed.h"

G_BEGIN_DECLS

#define KZ_TYPE_GECKO_EMBED		(kz_gecko_embed_get_type ())
#define KZ_GECKO_EMBED(obj)		(G_TYPE_CHECK_INSTANCE_CAST ((obj), KZ_TYPE_GECKO_EMBED, KzGeckoEmbed))
#define KZ_IS_GECKO_EMBED(obj)   	(G_TYPE_CHECK_INSTANCE_TYPE ((obj), KZ_TYPE_GECKO_EMBED))

typedef struct _KzGeckoEmbed		KzGeckoEmbed;

struct _KzGeckoEmbed
{
	GtkMozEmbed parent;
};

GType      kz_gecko_embed_get_type      (void) G_GNUC_CONST;
void	   kz_gecko_embed_register_type (GTypeModule *module);

G_END_DECLS

#endif /* __KZ_GECKO_EMBED_H__ */
