// -*- Mode: C++; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*-

//
//  Copyright (C) 2007 Hiroyuki Ikezoe
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//

#include "kz-module-impl.h"

#include "kz-gecko-embed.h"
#include "kz-gecko-single.h"
#include "mozilla-prefs.h"

static KzGeckoSingle *gecko_single = NULL;

G_MODULE_EXPORT void
KZ_MODULE_IMPL_INIT (GTypeModule *module)
{
	mozilla_prefs_init();

	gtk_moz_embed_set_comp_path(MOZILLA_HOME);

	gtk_moz_embed_push_startup();

	gecko_single = kz_gecko_single_new(kz_app);
	kz_gecko_embed_register_type(module);
}

G_MODULE_EXPORT void
KZ_MODULE_IMPL_EXIT (void)
{
	g_object_unref(gecko_single);
	gtk_moz_embed_pop_startup();
}

G_MODULE_EXPORT GObject *
KZ_MODULE_IMPL_INSTANTIATE (const gchar *first_property,
			    va_list      var_args)
{
	KzGeckoEmbed *kzembed;

	kzembed = KZ_GECKO_EMBED(g_object_new_valist(KZ_TYPE_GECKO_EMBED,
						     first_property, var_args));
	return G_OBJECT(kzembed);
}

G_MODULE_EXPORT const gchar *
KZ_MODULE_IMPL_GET_NAME (void)
{
	return GECKO_VERSION;
}

