/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */

/*
 *  Copyright (C) 2006 Kouhei Sutou
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "kz-rb-ext.h"

#define _SELF(obj) RVAL2KZNB(obj)
#define RVAL2GDKSD(obj) RVAL2GENUM(obj, GDK_TYPE_SCROLL_DIRECTION)

static VALUE
rb_kz_notebook_new(VALUE self, VALUE kz)
{
    GtkWidget *notebook;

    notebook = kz_notebook_new(RVAL2KZWIN(kz));
    RBGTK_INITIALIZE(self, notebook);
    return Qnil;
}

static VALUE
rb_kz_notebook_open_new_tab(int argc, VALUE *argv, VALUE self)
{
    VALUE rb_embed, rb_label, pos;
    KzNotebook *notebook;
    KzEmbed *embed;
    KzTabLabel *label;
    KzTabLabel *sibling_label;

    rb_scan_args(argc, argv, "21", &rb_embed, &rb_label, &pos);

    notebook = _SELF(self);
    embed = RVAL2KZEMB(rb_embed);
    label = RVAL2KZTL(rb_label);
    if (NIL_P(pos)) {
        sibling_label = kz_notebook_open_new_tab(notebook, embed, label);
    } else {
        sibling_label = kz_notebook_open_new_tab_at_pos(notebook, embed, label,
                                                        NUM2INT(pos));
    }

    return GOBJ2RVAL(sibling_label);
}

static VALUE
rb_kz_notebook_close_tab(VALUE self, VALUE widget)
{
    gboolean result;
    result = kz_notebook_close_tab(_SELF(self), RVAL2GTKWIDGET(widget));
    return CBOOL2RVAL(result);
}

static VALUE
rb_kz_notebook_close_all_tab(VALUE self)
{
    gboolean result;
    result = kz_notebook_close_all_tab(_SELF(self));
    return CBOOL2RVAL(result);
}

static VALUE
rb_kz_notebook_move_tab(VALUE self, VALUE dest_notebook, VALUE widget)
{
    gboolean result;
    result = kz_notebook_move_tab(_SELF(self),
                                  _SELF(dest_notebook),
                                  RVAL2GTKWIDGET(widget));
    return CBOOL2RVAL(result);
}

static VALUE
rb_kz_notebook_next_tab(VALUE self)
{
    kz_notebook_next_tab(_SELF(self));
    return Qnil;
}

static VALUE
rb_kz_notebook_prev_tab(VALUE self)
{
    kz_notebook_prev_tab(_SELF(self));
    return Qnil;
}

static VALUE
rb_kz_notebook_reorder_tab(VALUE self, VALUE rb_widget, VALUE pos)
{
    GtkWidget *widget;
    widget = kz_notebook_reorder_tab(_SELF(self),
                                     RVAL2GTKWIDGET(rb_widget),
                                     NUM2INT(pos));
    return GOBJ2RVAL(widget);
}

static VALUE
rb_kz_notebook_scroll_tab(VALUE self, VALUE direction)
{
    gboolean result;
    result = kz_notebook_scroll_tab(_SELF(self),
                                    RVAL2GDKSD(direction));
    return CBOOL2RVAL(result);
}


void
_kz_rb_notebook_init(VALUE mKz)
{
    VALUE cKzNotebook;

    cKzNotebook = G_DEF_CLASS(KZ_TYPE_NOTEBOOK, "Notebook", mKz);

    rb_define_method(cKzNotebook, "initialize", rb_kz_notebook_new, 1);

    rb_define_method(cKzNotebook, "open_new_tab",
                     rb_kz_notebook_open_new_tab, -1);
    rb_define_method(cKzNotebook, "close_tab", rb_kz_notebook_close_tab, 1);
    rb_define_method(cKzNotebook, "close_all_tab",
                     rb_kz_notebook_close_all_tab, 0);
    rb_define_method(cKzNotebook, "move_tab", rb_kz_notebook_move_tab, 2);
    rb_define_method(cKzNotebook, "next_tab", rb_kz_notebook_next_tab, 0);
    rb_define_method(cKzNotebook, "prev_tab", rb_kz_notebook_prev_tab, 0);
    rb_define_method(cKzNotebook, "reorder_tab",
                     rb_kz_notebook_reorder_tab, 2);
    rb_define_method(cKzNotebook, "scroll_tab",
                     rb_kz_notebook_scroll_tab, 1);

    G_DEF_SETTERS(cKzNotebook);
}
